/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.skc.utils.text;

import chemaxon.marvin.io.formats.skc.utils.text.TextBaseData;
import chemaxon.marvin.io.formats.skc.utils.text.TextData;
import chemaxon.marvin.io.formats.skc.utils.text.TextStyleMark;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TextUtil {
    private static final List<String> nameList = Arrays.asList("alpha", "beta", "gamma", "delta", "epsilon", "zeta", "eta", "theta", "iota", "kappa", "lambda", "mu", "nu", "xi", "omicron", "pi", "rho", "sigma", "tau", "upsilon", "phi", "chi", "psi", "omega", "SIGMA", "DELTA");
    private static final List<String> specialCharacterList = Arrays.asList("\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd");
    private List<TextStyleMark> textStyleMarkList = new ArrayList<TextStyleMark>();
    private List<Short> characterList = new ArrayList<Short>();
    private List<TextBaseData> textBaseDataList = null;

    private static String findNameBySpecialCharacter(String text) {
        String str = null;
        for (int i = 0; i < nameList.size(); ++i) {
            if (text.compareTo(nameList.get(i)) != 0) continue;
            str = "\\u" + specialCharacterList.get(i).charAt(0) + "?";
            break;
        }
        return str;
    }

    public List<TextBaseData> getTextBaseDataList() {
        return this.textBaseDataList;
    }

    public TextStyleMark[] getTextStyleMarkList() {
        return this.textStyleMarkList.toArray(new TextStyleMark[this.textStyleMarkList.size()]);
    }

    public Short[] getCharacterList() {
        return this.characterList.toArray(new Short[this.characterList.size()]);
    }

    public void parseTextContent(String textContent) {
        TextData parser = new TextData().createNewTextDataObject(textContent);
        this.textBaseDataList = (ArrayList)parser.getTextBaseDataList();
        if (parser.getTextBaseDataList().size() > 0 && parser.getTextBaseDataList().get(parser.getTextBaseDataList().size() - 1).getTextContent() == "\n") {
            parser.getTextBaseDataList().remove(parser.getTextBaseDataList().size() - 1);
        }
        for (TextBaseData textBaseData : (ArrayList)parser.getTextBaseDataList()) {
            byte[] bytes;
            TextStyleMark tsm = textBaseData.getTextStyleMark();
            String fontName = "Arial";
            byte fontEmphasis = (byte)((tsm.isBold() ? 1 : 0) | (tsm.isItalic() ? 2 : 0) | (tsm.isSublevelAdy() ? 8 : 0) | (tsm.isSublevelScale() ? 16 : 0) | (tsm.isUnderLine() ? 4 : 0) | (tsm.isMagneto() ? 32 : 0));
            short fontSize = (short)(tsm.getFontSizeValue() * 5);
            int v1 = -1;
            int size = this.textStyleMarkList.size();
            for (int v2 = 0; v2 < size && v1 == -1; ++v2) {
                if (!this.textStyleMarkList.get(v2).isSameFormat(fontName, fontEmphasis, fontSize)) continue;
                v1 = v2;
            }
            if (v1 == -1) {
                TextStyleMark ts = new TextStyleMark(fontName, fontEmphasis, fontSize);
                this.textStyleMarkList.add(ts);
                v1 = this.textStyleMarkList.indexOf(ts);
            }
            if ((bytes = textBaseData.getTextContent().getBytes()) == null) continue;
            for (byte num7 : bytes) {
                this.characterList.add((short)(((v1 & 0x3F) << 8) + num7));
            }
        }
    }

    public static String replaceSignWithSpecialCharacter(String specialCharacter) {
        int startIndex;
        StringBuilder sb = new StringBuilder();
        int index = startIndex = 0;
        while (true) {
            if ((index = specialCharacter.indexOf(46, index)) < 0) {
                sb.append(specialCharacter.substring(startIndex));
                break;
            }
            String str = specialCharacter.substring(startIndex, startIndex + index - startIndex);
            sb.append(str);
            startIndex = specialCharacter.indexOf(46, index + 1);
            if (startIndex < 0) {
                sb.append(specialCharacter.substring(index));
                break;
            }
            String name = TextUtil.findNameBySpecialCharacter(specialCharacter.substring(index + 1, index + 1 + startIndex - index));
            if (name == null) {
                sb.append(specialCharacter.substring(index, index + startIndex - index));
            } else {
                sb.append(name);
                ++startIndex;
            }
            index = startIndex;
        }
        return sb.toString();
    }

    public static String findSpecialCharacterByName(String textName) {
        String name = null;
        for (int i = 0; i < specialCharacterList.size(); ++i) {
            if (!textName.equals(specialCharacterList.get(i))) continue;
            name = nameList.get(i);
            break;
        }
        return name;
    }
}

