/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.skc.utils.text;

import chemaxon.marvin.io.formats.skc.utils.text.TextBaseParser;
import chemaxon.marvin.io.formats.skc.utils.text.TextData;

public class TextWrapper
extends TextBaseParser {
    private String symbolName;
    private String parameter;

    public TextWrapper(TextData textDataInfo, String symbolName, String parameter) {
        super(textDataInfo, null);
        this.symbolName = symbolName;
        this.parameter = parameter;
    }

    public String getSymbolName() {
        return this.symbolName;
    }

    public String getparameter() {
        return this.parameter;
    }

    @Override
    boolean parse() {
        if (this.getSymbolName().equals("deff")) {
            this.textData.setFontName("f" + this.getparameter());
        } else if (this.getSymbolName().equals("f")) {
            this.textData.getTextStyleMark().setTextFont(this.textData.getFextFontMap().get(this.getSymbolName() + this.getparameter()));
        } else if (this.getSymbolName().equals("fs")) {
            this.textData.getTextStyleMark().setFontSizeValue(Integer.parseInt(this.getparameter()));
        } else if (this.getSymbolName().equals("b")) {
            this.textData.getTextStyleMark().setBold(this.getparameter() != null && !this.getparameter().equals("0"));
        } else if (this.getSymbolName().equals("i")) {
            this.textData.getTextStyleMark().setItalic(this.getparameter() != null && !this.getparameter().equals("0"));
        } else if (this.getSymbolName().equals("up")) {
            this.textData.getTextStyleMark().setSublevelScale(false);
            this.textData.getTextStyleMark().setSublevelAdy(this.getparameter() != null && !this.getparameter().equals("0"));
        } else if (this.getSymbolName().equals("super")) {
            this.textData.getTextStyleMark().setSublevelScale(false);
            this.textData.getTextStyleMark().setSublevelAdy(true);
        } else if (this.getSymbolName().equals("dn")) {
            this.textData.getTextStyleMark().setSublevelAdy(false);
            this.textData.getTextStyleMark().setSublevelScale(this.getparameter() != null && !this.getparameter().equals("0"));
        } else if (this.getSymbolName().equals("sub")) {
            this.textData.getTextStyleMark().setSublevelAdy(false);
            this.textData.getTextStyleMark().setSublevelScale(true);
        } else if (this.getSymbolName().equals("nosupersub")) {
            this.textData.getTextStyleMark().setSublevelAdy(false);
            this.textData.getTextStyleMark().setSublevelScale(false);
        } else if (this.getSymbolName().equals("plain")) {
            this.textData.getTextStyleMark().setSublevelAdy(false);
            this.textData.getTextStyleMark().setSublevelScale(false);
            this.textData.getTextStyleMark().setBold(false);
            this.textData.getTextStyleMark().setItalic(false);
        } else if (this.getSymbolName().equals("ul")) {
            this.textData.getTextStyleMark().setUnderLine(this.getparameter() != null && !this.getparameter().equals("0"));
        } else if (this.getSymbolName().equals("ulnone")) {
            this.textData.getTextStyleMark().setUnderLine(false);
        } else if (this.getSymbolName().equals("m")) {
            this.textData.getTextStyleMark().setMagneto(this.getparameter() != null && !this.getparameter().equals("0"));
        } else if (this.getSymbolName().equals("par")) {
            this.textData.isCanAddTextBaseData("\n");
        } else if (this.getSymbolName().equals("'")) {
            this.textData.isCanAddTextBaseData(Integer.parseInt(this.parameter, 16) + "");
        } else if (this.getSymbolName().equals("*")) {
            this.textData.isCanAddTextBaseData("*");
        } else if (this.getSymbolName().equals(":")) {
            this.textData.isCanAddTextBaseData(":");
        } else if (this.getSymbolName().equals("\\")) {
            this.textData.isCanAddTextBaseData("\\");
        } else if (this.getSymbolName().equals("_")) {
            this.textData.isCanAddTextBaseData("_");
        } else if (this.getSymbolName().equals("{")) {
            this.textData.isCanAddTextBaseData("{");
        } else if (this.getSymbolName().equals("|")) {
            this.textData.isCanAddTextBaseData("|");
        } else if (this.getSymbolName().equals("}")) {
            this.textData.isCanAddTextBaseData("{");
        } else if (this.getSymbolName().equals("~")) {
            this.textData.isCanAddTextBaseData("~");
        }
        return true;
    }
}

