/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.smiles;

import chemaxon.calculations.hydrogenize.Hydrogenize;
import chemaxon.calculations.stereo.BicycloStereoRecognizer;
import chemaxon.common.util.ArrayTools;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.formats.smiles.CxsConstants;
import chemaxon.marvin.io.formats.smiles.SmartsAtomQuerifier;
import chemaxon.marvin.io.formats.smiles.SmilesExport;
import chemaxon.marvin.util.OptionDescriptor;
import chemaxon.marvin.util.text.LocaleUtil;
import chemaxon.struc.BicycloStereoDescriptor;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.StereoConstants;
import chemaxon.struc.sgroup.DataSgroup;
import chemaxon.struc.sgroup.MulticenterSgroup;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;

public class CxsmilesExport
extends SmilesExport
implements StereoConstants {
    private boolean writeEnhancedStereo = true;
    private boolean writeLabels = true;
    private boolean writeWigglybonds = true;
    private boolean writeFragments = true;
    private boolean writeCT = true;
    private boolean writeLocalP = true;
    private boolean writeRadical = true;
    private boolean writeLonePair = true;
    private boolean hasExplicitLonePair = false;
    private boolean writeCoordinates = false;
    private int coordinatePrecision = 2;
    private boolean writeCoordAndMultiCenter = true;
    private boolean writeLinkNode = true;
    private double[][] lpCoordinates = null;
    private boolean writeDataSgroup = true;
    private boolean writeAttachmentPoint = true;
    private boolean writeLocalBicyclo = true;
    private boolean writeRgroup = true;
    private int[] originalLPIdxAndParity = null;
    private static final int LP_MASK = 65535;
    private static final int PARITY_O = 65536;
    private static final int PARITY_E = 131072;
    private static final int LOCAL_PARITY_MASK = 196608;
    private static final String allowedCharsInDataSgroup = " ><\"!@#$%()[]./\\?-+*^_~=";
    private static final String allowedCharsBetwenDollar = " ><\"!@#%()[]./\\?-+*^_~=,:";

    public CxsmilesExport() {
    }

    CxsmilesExport(CxsmilesExport e) {
        this.setFields(e);
    }

    @Override
    protected void getOptionDescriptors(String fmtname, String optnames, List<OptionDescriptor> l) {
        String basefmt = fmtname.startsWith("cxsmiles") ? "smiles" : (fmtname.startsWith("cxsmarts") ? "smarts" : fmtname);
        super.getOptionDescriptors(basefmt, null, l);
        ResourceBundle rc = LocaleUtil.getResourceBundle(CxsmilesExport.class.getName(), null);
        CxsmilesExport.getOptionDescriptors(rc, fmtname, null, l);
    }

    @Override
    public Object open(String fmtopts) throws MolExportException {
        Object o = super.open(fmtopts);
        this.querySmarts |= this.isCxSMARTS();
        this.rgToRecursiveSmarts = false;
        return o;
    }

    @Override
    protected String getSMILESColumnName() {
        return this.isCxSMARTS() ? "CxSMARTS" : "CxSMILES";
    }

    @Override
    public boolean isCleanable() {
        return this.writeCoordinates;
    }

    private boolean isCxSMARTS() {
        String fmt = this.getFormat();
        return fmt != null && fmt.toLowerCase().equals("cxsmarts");
    }

    @Override
    protected int parseOption(String opts, int i) throws IllegalArgumentException {
        char c;
        int ii = super.parseOption(opts, i);
        if (ii != i) {
            return ii;
        }
        i = this.parseCharIfOptionSign(opts, i);
        int optionSign2 = this.getOptionSign();
        if (optionSign2 == 0) {
            this.removeDefaultCxExportOptions();
        }
        if ((c = opts.charAt(i)) == 'e') {
            this.writeEnhancedStereo = optionSign2 >= 0;
            ++i;
        } else if (c == 'l') {
            this.writeLabels = optionSign2 >= 0;
            ++i;
        } else if (c == 'w') {
            this.writeWigglybonds = optionSign2 >= 0;
            ++i;
        } else if (c == 'f') {
            this.writeFragments = optionSign2 >= 0;
            ++i;
        } else if (c == 'd') {
            this.writeCT = optionSign2 >= 0;
            ++i;
        } else if (c == 'p') {
            this.writeLocalP = optionSign2 >= 0;
            ++i;
        } else if (c == 'R') {
            this.writeRadical = optionSign2 >= 0;
            ++i;
        } else if (c == 'L') {
            this.writeLonePair = optionSign2 >= 0;
            ++i;
        } else if (c == 'm') {
            this.writeCoordAndMultiCenter = optionSign2 >= 0;
            ++i;
        } else if (c == 'N') {
            this.writeLinkNode = optionSign2 >= 0;
            ++i;
        } else if (c == 'D') {
            this.writeDataSgroup = optionSign2 >= 0;
            ++i;
        } else if (c == 'c') {
            int j;
            this.writeCoordinates = optionSign2 >= 0;
            int prec = 0;
            for (j = i + 1; j < opts.length() && (c = opts.charAt(j)) >= '0' && c <= '9'; ++j) {
                prec = prec * 10 + c - 48;
            }
            this.coordinatePrecision = prec > 0 ? prec : this.coordinatePrecision;
            i = j;
        }
        return i;
    }

    void removeDefaultCxExportOptions() {
        if (!(this.writeEnhancedStereo && this.writeLabels && this.writeWigglybonds && this.writeCT && this.writeLocalP && this.writeRadical && this.writeLonePair && this.writeCoordAndMultiCenter && this.writeLinkNode && this.writeDataSgroup && this.writeAttachmentPoint && this.writeLocalBicyclo && this.writeRgroup)) {
            return;
        }
        this.writeEnhancedStereo = false;
        this.writeLabels = false;
        this.writeWigglybonds = false;
        this.writeFragments = false;
        this.writeCT = false;
        this.writeLocalP = false;
        this.writeRadical = false;
        this.writeLonePair = false;
        this.writeCoordAndMultiCenter = false;
        this.writeLinkNode = false;
        this.writeDataSgroup = false;
        this.writeAttachmentPoint = false;
        this.writeLocalBicyclo = false;
        this.writeRgroup = false;
    }

    public static final boolean canBeDescribedByCxsmiles(Molecule mol) {
        if (CxsmilesExport.hasNonSupportedCxsmilesMolecularFeature(mol)) {
            return false;
        }
        int ac = mol.getAtomCount();
        for (int i = 0; i < ac; ++i) {
            MolAtom a = mol.getAtom(i);
            if (!CxsmilesExport.hasNonSupportedCxsmilesAtomFeature(a)) continue;
            return false;
        }
        return true;
    }

    public static final boolean canBeDescribedByCxsmarts(Molecule mol) {
        if (CxsmilesExport.hasNonSupportedCxsmartsMolecularFeature(mol)) {
            return false;
        }
        int ac = mol.getAtomCount();
        for (int i = 0; i < ac; ++i) {
            MolAtom a = mol.getAtom(i);
            if (!CxsmilesExport.hasNonSupportedCxsmartsAtomFeature(a)) continue;
            return false;
        }
        return true;
    }

    static final boolean hasNonSupportedCxsmilesMolecularFeature(Molecule mol) {
        return CxsmilesExport.hasNonSupportedCxsmartsMolecularFeature(mol);
    }

    static final boolean hasNonSupportedCxsmartsMolecularFeature(Molecule mol) {
        return CxsmilesExport.hasNonsupportedSgroup(mol);
    }

    private static final boolean hasNonsupportedSgroup(Molecule m) {
        int nSg = m.getSgroupCount();
        for (int i = 0; i < nSg; ++i) {
            DataSgroup dsg;
            SelectionMolecule sgg;
            Sgroup sg = m.getSgroup(i);
            int t = sg.getType();
            if (t == 0 || t == 1 || t == 14 || t == 10) continue;
            return !(sg instanceof DataSgroup) || (sgg = (dsg = (DataSgroup)sg).getSgroupGraph()) != null && sgg.getAtomCount() != 0;
        }
        return false;
    }

    static final boolean hasNonSupportedCxsmilesAtomFeature(MolAtom a) {
        int atno = a.getAtno();
        int arom = a.getQueryAromaticity();
        return CxsmilesExport.hasNonSupportedCxsmartsAtomFeature(a) || atno == 128 || atno == 129 || SmartsAtomQuerifier.hasSMARTSPropsExcluding(a, "av") || a.getQueryString() != null && !a.getQueryString().equals("") || (a.getFlags() & 4) != 0 || arom == 3;
    }

    static final boolean hasNonSupportedCxsmartsAtomFeature(MolAtom a) {
        int atno = a.getAtno();
        return atno > 109 && atno != 131 && atno != 134 && atno != 136 && atno != 128 && atno != 129 && atno != 132 && atno != 137 && atno != 133;
    }

    @Override
    protected Molecule preconvert(Molecule mol) {
        MDocument d;
        Molecule m = this.preconvert(mol, true, 1, false);
        if (m == mol) {
            d = m.getDocument();
            Molecule molecule = m = d != null ? (Molecule)d.cloneMainMoleculeGraph() : (Molecule)m.clone();
        }
        if (m instanceof Molecule) {
            if (this.writeAttachmentPoint) {
                CxsmilesExport.convertRGAttachmentAtoms(m);
            } else {
                CxsmilesExport.removeAttachmentAtoms(m);
            }
        }
        if (this.hasExplicitLonePair = m.hasExplicitLonePairs()) {
            if (m == mol) {
                d = m.getDocument();
                Molecule molecule = m = d != null ? (Molecule)d.cloneMainMoleculeGraph() : (Molecule)m.clone();
            }
            if (this.writeLonePair) {
                int ac = m.getAtomCount();
                int n = 0;
                int lonePairCount = 0;
                for (int i = 0; i < ac; ++i) {
                    MolAtom a = m.getAtom(i);
                    if (a.getAtno() != 130) continue;
                    ++n;
                }
                int[] tmp = new int[n];
                if (this.writeCoordinates) {
                    this.lpCoordinates = new double[n][3];
                }
                n = 0;
                for (int i = 0; i < ac; ++i) {
                    int lpc = 0;
                    MolAtom a = m.getAtom(i);
                    if (a.getAtno() == 130) {
                        ++lonePairCount;
                        continue;
                    }
                    lpc = a.getBondCount() - a.getRealBondCount();
                    if (lpc <= 0) continue;
                    int z = n;
                    for (int j = 0; j < lpc; ++j) {
                        tmp[n++] = i - lonePairCount;
                    }
                    int p = 0;
                    p = m.getLocalParity(i);
                    if (p > 0) {
                        int n2 = p = m.getParityType(i) != 1 ? 0 : p;
                        p = p == 1 ? 65536 : (p == 2 ? 131072 : 0);
                        int n3 = n - 1;
                        tmp[n3] = tmp[n3] | p;
                    }
                    for (int j = a.getBondCount() - 1; this.writeCoordinates && j >= 0; --j) {
                        MolAtom l = a.getLigand(j);
                        if (l.getAtno() != 130) continue;
                        this.lpCoordinates[z][0] = l.getX();
                        this.lpCoordinates[z][1] = l.getY();
                        this.lpCoordinates[z++][2] = l.getZ();
                    }
                }
                this.originalLPIdxAndParity = tmp;
            }
            Hydrogenize.removeLonePairs(m);
        }
        return m;
    }

    static final void convertRGAttachmentAtoms(Molecule m) {
        MolAtom[] atoms;
        Molecule root = m;
        if (m instanceof RgMolecule) {
            RgMolecule rgm = (RgMolecule)m;
            root = rgm.getRoot();
        }
        for (MolAtom atom : atoms = root.getAtomArray()) {
            if (atom.getAtno() != 138) continue;
            int value = atom.getRgroupAttachmentPointOrder();
            atom.setAtno(131);
            atom.setAliasstr("_AP" + value);
        }
    }

    static final int convertedIdx(int idx, MoleculeGraph m) {
        MolAtom a = m.getAtom(idx);
        if (a.getAtno() == 130) {
            return Integer.MAX_VALUE;
        }
        return idx;
    }

    @Override
    public Object convert(Molecule mol) throws MolExportException {
        Molecule r;
        this.smilesBondIdx = null;
        this.cx = true;
        if (this.uniqueFormat && CxsmilesExport.needDoubleExport(mol)) {
            Molecule mol2;
            String smi2;
            String smiles = null;
            String smi1 = this.toSMILES(mol);
            int c = smi1.compareTo(smi2 = this.toSMILES(mol2 = CxsmilesExport.createMirrorImage(mol)));
            if (c > 0) {
                mol = mol2;
                smiles = smi2;
            } else {
                smiles = c == 0 ? smi1 : smi1;
            }
            this.stringBuffer.setLength(0);
            this.stringBuffer.append(smiles);
        } else {
            this.toSMILES(mol);
        }
        RxnMolecule rxn = null;
        if (mol instanceof RxnMolecule) {
            rxn = (RxnMolecule)mol;
        } else if (mol instanceof RgMolecule && (r = ((RgMolecule)mol).getRoot()) instanceof RxnMolecule) {
            rxn = (RxnMolecule)r;
        }
        NumberFormat formatter = null;
        if (this.writeCoordinates) {
            formatter = NumberFormat.getInstance(Locale.US);
            formatter.setMaximumFractionDigits(this.coordinatePrecision);
            formatter.setMinimumFractionDigits(0);
            formatter.setMinimumIntegerDigits(0);
        }
        boolean hasWigglyBond = this.writeWigglybonds ? (this.writeCoordinates ? CxsmilesExport.hasWedgeBond(this.molecule) : CxsmilesExport.hasWigglyBond(this.molecule)) : false;
        boolean featureWritten = false;
        int startpos = this.stringBuffer.length();
        this.stringBuffer.append(" |");
        if (this.writeEnhancedStereo) {
            featureWritten |= this.writeEnhancedStereoFeatures(this.molecule, this.smilesAtoms);
        }
        if (hasWigglyBond) {
            if (this.smilesBondIdx == null) {
                this.smilesBondIdx = CxsmilesExport.generateSmilesBonds(this.molecule, this.smilesAtoms, this.ringAtoms, this.ringNumbers, this.atomFlags);
            }
            featureWritten |= this.writeWigglyBond(this.molecule, this.smilesBondIdx, this.ctab2smi, this.writeCoordinates);
        }
        if (this.writeLabels) {
            featureWritten |= this.writeAliasPseudoRgroupStrings(this.molecule, this.smilesAtoms);
            featureWritten |= this.writeAtomValue(this.molecule, this.smilesAtoms);
        }
        if (this.writeFragments && rxn != null) {
            featureWritten |= this.writeMolFragments(rxn);
        }
        if (this.writeCT) {
            if (this.smilesBondIdx == null) {
                this.smilesBondIdx = CxsmilesExport.generateSmilesBonds(this.molecule, this.smilesAtoms, this.ringAtoms, this.ringNumbers, this.atomFlags);
            }
            featureWritten |= this.writeCTinRings(this.molecule, this.smilesBondIdx, this.ctab2smi);
        }
        if (this.writeLonePair) {
            if (this.hasExplicitLonePair) {
                featureWritten |= this.writeExplicitLonePair(this.molecule, this.ctab2smi);
            }
            featureWritten |= this.writeImplicitLonePair(this.molecule, this.smilesAtoms);
        }
        if (this.writeLocalP && this.wrparinfo) {
            int[] locp = null;
            if (!this.querySmarts && this.uniqueFormat) {
                locp = this.standardizeLocalParity(this.molecule);
            }
            featureWritten |= this.writeLocalParity(this.molecule, this.smilesAtoms, this.ctab2smi, locp);
        }
        if (this.writeLocalBicyclo) {
            featureWritten |= this.writeBicycloStereo(this.molecule, this.ctab2smi);
        }
        if (this.writeRadical) {
            featureWritten |= this.writeRadicals(this.molecule, this.smilesAtoms);
        }
        if (this.writeCoordAndMultiCenter) {
            if (this.smilesBondIdx == null) {
                this.smilesBondIdx = CxsmilesExport.generateSmilesBonds(this.molecule, this.smilesAtoms, this.ringAtoms, this.ringNumbers, this.atomFlags);
            }
            featureWritten |= this.writeCoordAndMultiCenter(this.molecule, this.smilesAtoms, this.ctab2smi, this.smilesBondIdx);
        }
        if (this.writeLinkNode) {
            featureWritten |= this.writeLinkNodes(this.molecule, this.smilesAtoms, this.ctab2smi);
        }
        if (this.writeCoordinates) {
            featureWritten |= this.writeCoordinates(this.molecule, this.smilesAtoms, formatter);
        }
        if (this.writeDataSgroup) {
            featureWritten |= this.writeDataSgroup(this.molecule, this.ctab2smi, formatter);
        }
        if (!this.rgToRecursiveSmarts) {
            featureWritten |= this.writeRgroup(mol);
            featureWritten |= this.writeLigandOrder(this.molecule, this.smilesAtoms, this.ctab2smi);
        }
        int l = this.stringBuffer.length();
        if (featureWritten) {
            this.stringBuffer.setCharAt(l - 1, '|');
        } else {
            this.stringBuffer.setLength(startpos);
        }
        this.writeHeaderIfNeeded(mol);
        if (this.compress) {
            this.CompressAndBase64Encode();
        }
        if (this.incFields != null || this.writeMolName) {
            CxsmilesExport.writeSDFFields(this.molecule, this.incFields, this.stringBuffer, this.writeMolName);
        }
        this.stringBuffer.append('\n');
        return this.stringBuffer.toString();
    }

    static final boolean hasWigglyBond(MoleculeGraph m) {
        int bc = m.getBondCount();
        for (int i = 0; i < bc; ++i) {
            MolBond b = m.getBond(i);
            if (b.getStereo1(null) != 48) continue;
            return true;
        }
        return false;
    }

    static final boolean hasWedgeBond(MoleculeGraph m) {
        int bc = m.getBondCount();
        for (int i = 0; i < bc; ++i) {
            MolBond b = m.getBond(i);
            if (b.getStereo1(null) == 0) continue;
            return true;
        }
        return false;
    }

    final boolean writeEnhancedStereoFeatures(MoleculeGraph m, int[] smilesAtoms) {
        int i;
        int na = smilesAtoms.length;
        boolean hasEnhStereo = false;
        boolean hasParityDefined = false;
        int[] abs = new int[na + 1];
        Object or = new int[na][];
        Object and = new int[na][];
        for (int i2 = 0; i2 < na; ++i2) {
            int p;
            Object tmp;
            int sgn;
            int atom = smilesAtoms[i2];
            MolAtom a = m.getAtom(atom);
            if (a.getStereoGroupType() == 1) {
                int l = abs[abs.length - 1];
                abs[l++] = i2;
                abs[abs.length - 1] = l;
                hasEnhStereo = true;
            } else if (a.getStereoGroupType() == 2) {
                sgn = a.getStereoGroupNumber();
                if (sgn >= ((int[][])or).length) {
                    tmp = new int[sgn + 1][];
                    System.arraycopy(or, 0, tmp, 0, ((int[][])or).length);
                    or = tmp;
                }
                if (or[sgn] == null) {
                    or[sgn] = new int[1];
                } else {
                    tmp = new int[or[sgn].length + 1];
                    System.arraycopy(or[sgn], 0, tmp, 0, or[sgn].length);
                    or[sgn] = (int[])tmp;
                }
                or[sgn][or[sgn].length - 1] = i2;
                hasEnhStereo = true;
            } else if (a.getStereoGroupType() == 3) {
                sgn = a.getStereoGroupNumber();
                if (sgn >= ((int[][])and).length) {
                    tmp = new int[sgn + 1][];
                    System.arraycopy(and, 0, tmp, 0, ((int[][])or).length);
                    and = tmp;
                }
                if (and[sgn] == null) {
                    and[sgn] = new int[1];
                } else {
                    tmp = new int[and[sgn].length + 1];
                    System.arraycopy(and[sgn], 0, tmp, 0, and[sgn].length);
                    and[sgn] = (int[])tmp;
                }
                and[sgn][and[sgn].length - 1] = i2;
                hasEnhStereo = true;
            }
            if (hasParityDefined) continue;
            int n = p = this.wrparinfo ? m.getParity(i2) : 0;
            if (p == 0 || p == 3) continue;
            hasParityDefined = true;
        }
        if (this.uniqueFormat) {
            or = CxsmilesExport.rearrangeBasedOnAtomIndexes(or);
            and = CxsmilesExport.rearrangeBasedOnAtomIndexes(and);
        }
        int absLength = abs[abs.length - 1];
        if (!hasEnhStereo && !m.isAbsStereo() && hasParityDefined) {
            this.stringBuffer.append("r,");
        }
        if (absLength > 0) {
            this.stringBuffer.append("a:");
        }
        for (i = 0; i < absLength; ++i) {
            this.stringBuffer.append(abs[i] + ",");
        }
        for (i = 0; i < ((int[][])or).length; ++i) {
            if (or[i] == null) continue;
            this.stringBuffer.append("o" + i + ":");
            for (int j = 0; j < or[i].length; ++j) {
                this.stringBuffer.append(or[i][j] + ",");
            }
        }
        for (i = 0; i < ((int[][])and).length; ++i) {
            if (and[i] == null) continue;
            this.stringBuffer.append("&" + i + ":");
            for (int j = 0; and[i] != null && j < and[i].length; ++j) {
                this.stringBuffer.append(and[i][j] + ",");
            }
        }
        return hasEnhStereo || !m.isAbsStereo() && hasParityDefined;
    }

    static final int[][] rearrangeBasedOnAtomIndexes(int[][] x) {
        int l = x.length;
        int[] smallestElements = new int[l];
        int n = 0;
        for (int i = 0; i < l; ++i) {
            if (x[i] != null) {
                CxsmilesExport.sortAscending(x[i]);
                smallestElements[i] = x[i][0];
                ++n;
                continue;
            }
            smallestElements[i] = -1;
        }
        int[][] sorted = new int[n + 1][];
        for (int i = 0; i < n; ++i) {
            int idx = CxsmilesExport.smallestPositiveIndex(smallestElements);
            if (idx >= 0) {
                smallestElements[idx] = -1;
                sorted[i + 1] = x[idx];
                continue;
            }
            System.err.println("Some unaccepted error during enhanced stereo information sort");
        }
        return sorted;
    }

    static final void sortAscending(int[] x) {
        ArrayTools.sortDescending(x);
        int l = x.length;
        for (int i = 0; i < l / 2; ++i) {
            int e = x[i];
            x[i] = x[l - 1 - i];
            x[l - i - 1] = e;
        }
    }

    static final int smallestPositiveIndex(int[] x) {
        int min = Integer.MAX_VALUE;
        int index = -1;
        int l = x.length;
        for (int i = 0; i < l; ++i) {
            int v = x[i];
            if (v < 0 || v >= min) continue;
            index = i;
            min = v;
        }
        return index;
    }

    final boolean writeWigglyBond(MoleculeGraph m, int[] smilesBonds, int[] ctab2smi, boolean allBonds) {
        int aid;
        MolBond b;
        int i;
        int bc = smilesBonds.length;
        boolean written = false;
        boolean written1 = false;
        int startpos = this.stringBuffer.length();
        this.stringBuffer.append("w:");
        for (i = 0; i < bc; ++i) {
            b = m.getBond(i);
            if (b.getStereo1(null) != 48) continue;
            aid = m.indexOf(b.getAtom1());
            this.stringBuffer.append(ctab2smi[aid] + "." + smilesBonds[i] + ",");
            written1 = true;
        }
        if (!written1) {
            this.stringBuffer.setLength(startpos);
        } else {
            written = true;
        }
        if (allBonds) {
            written1 = false;
            startpos = this.stringBuffer.length();
            this.stringBuffer.append("wU:");
            for (i = 0; i < bc; ++i) {
                b = m.getBond(i);
                if (b.getStereo1(null) != 16) continue;
                aid = m.indexOf(b.getAtom1());
                this.stringBuffer.append(ctab2smi[aid] + "." + smilesBonds[i] + ",");
                written1 = true;
            }
            if (!written1) {
                this.stringBuffer.setLength(startpos);
            } else {
                written = true;
            }
            written1 = false;
            startpos = this.stringBuffer.length();
            this.stringBuffer.append("wD:");
            for (i = 0; i < bc; ++i) {
                b = m.getBond(i);
                if (b.getStereo1(null) != 32) continue;
                aid = m.indexOf(b.getAtom1());
                this.stringBuffer.append(ctab2smi[aid] + "." + smilesBonds[i] + ",");
                written1 = true;
            }
            if (!written1) {
                this.stringBuffer.setLength(startpos);
            } else {
                written = true;
            }
        }
        return written;
    }

    final boolean writeAliasPseudoRgroupStrings(MoleculeGraph m, int[] smilesAtoms) {
        int na = smilesAtoms.length;
        boolean written = false;
        int startpos = this.stringBuffer.length();
        this.stringBuffer.append("$");
        for (int i = 0; i < na; ++i) {
            int atno;
            int atom = smilesAtoms[i];
            MolAtom a = m.getAtom(atom);
            if (this.isCxsmilesAlias(a)) {
                CxsmilesExport.appendEscapedString(this.stringBuffer, allowedCharsBetwenDollar, a.getAliasstr());
                written = true;
            }
            if (a.getAtno() == 132 && !this.isCxSMARTS()) {
                CxsmilesExport.appendEscapedString(this.stringBuffer, allowedCharsBetwenDollar, CxsConstants.SpecialAtoms.Q_ATOM.getSymbol());
                written = true;
            }
            if (a.getAtno() == 133 && !this.isCxSMARTS()) {
                CxsmilesExport.appendEscapedString(this.stringBuffer, allowedCharsBetwenDollar, CxsConstants.SpecialAtoms.STAR_ATOM.getSymbol());
                written = true;
            }
            if ((atno = a.getAtno()) == 136) {
                this.stringBuffer.append("_p");
            }
            if (atno == 132 || atno == 133) {
                this.stringBuffer.append("_e");
            } else if (atno == 134) {
                int rg = a.getRgroup();
                this.stringBuffer.append("_R" + rg);
                written = true;
            }
            this.stringBuffer.append(";");
        }
        int endpos = this.stringBuffer.length();
        if (!written) {
            this.stringBuffer.setLength(startpos);
            return false;
        }
        this.stringBuffer.setCharAt(endpos - 1, '$');
        this.stringBuffer.append(",");
        return true;
    }

    private boolean isCxsmilesAlias(MolAtom a) {
        String alias = a.getAliasstr();
        return alias != null && (!alias.equals("X") || !this.isCxSMARTS());
    }

    private boolean writeRgroup(MoleculeGraph m) throws MolExportException {
        RgMolecule rgm;
        boolean written = false;
        int startpos = this.stringBuffer.length();
        this.stringBuffer.append("RG:");
        RgMolecule rgMolecule = rgm = m != null && m instanceof RgMolecule ? (RgMolecule)m : null;
        if (rgm != null) {
            CxsmilesExport exporter = new CxsmilesExport(this);
            for (int rg = 0; rg < rgm.getRgroupCount(); ++rg) {
                int rgId = rgm.getRgroupId(rg);
                int members = rgm.getRgroupMemberCount(rg);
                if (members <= 0) continue;
                this.stringBuffer.append("_R" + rgId + "=");
                for (int j = 0; j < members; ++j) {
                    Molecule rgmember = rgm.getRgroupMember(rg, j).cloneMolecule();
                    String rgroupsmarts = (String)exporter.convert(rgmember);
                    this.stringBuffer.append("{" + rgroupsmarts.trim() + "}");
                    this.stringBuffer.append(",");
                    written = true;
                }
            }
        }
        if (!written) {
            this.stringBuffer.setLength(startpos);
            return false;
        }
        return true;
    }

    private boolean writeLigandOrder(MoleculeGraph m, int[] smilesAtoms, int[] ctab2smi) {
        int na = smilesAtoms.length;
        int[][] ctab = m.getCtab();
        boolean written = false;
        int startpos = this.stringBuffer.length();
        this.stringBuffer.append("LO:");
        for (int i = 0; i < na; ++i) {
            int atomIdx = smilesAtoms[i];
            MolAtom a = m.getAtom(atomIdx);
            if (a.getAtno() != 134) continue;
            int start = this.stringBuffer.length();
            boolean atomWritten = false;
            this.stringBuffer.append(i + ":");
            if (a.getBondCount() > 1) {
                int j;
                int[] ligandIdxesByOrder = new int[a.getBondCount()];
                for (j = 0; j < ligandIdxesByOrder.length; ++j) {
                    int smilesLigandIdx;
                    int ligandOrder = a.getLigandOrder(a.getLigand(j));
                    int molLigandIdx = ctab[atomIdx][j];
                    ligandIdxesByOrder[ligandOrder - 1] = smilesLigandIdx = ctab2smi[molLigandIdx];
                }
                for (j = 0; j < ligandIdxesByOrder.length; ++j) {
                    this.stringBuffer.append(ligandIdxesByOrder[j] + ".");
                    written = true;
                    atomWritten = true;
                }
            }
            if (!atomWritten) {
                this.stringBuffer.setLength(start);
                continue;
            }
            this.stringBuffer.setCharAt(this.stringBuffer.length() - 1, ',');
        }
        if (!written) {
            this.stringBuffer.setLength(startpos);
            return false;
        }
        return true;
    }

    final boolean writeAtomValue(MoleculeGraph m, int[] smilesAtoms) {
        int na = smilesAtoms.length;
        boolean written = false;
        int startpos = this.stringBuffer.length();
        this.stringBuffer.append("$_AV:");
        for (int i = 0; i < na; ++i) {
            int atom = smilesAtoms[i];
            MolAtom a = m.getAtom(atom);
            String al = a.getExtraLabel();
            if (al != null) {
                CxsmilesExport.appendEscapedString(this.stringBuffer, allowedCharsBetwenDollar, al);
                written = true;
            }
            this.stringBuffer.append(";");
        }
        int endpos = this.stringBuffer.length();
        if (!written) {
            this.stringBuffer.setLength(startpos);
            return false;
        }
        this.stringBuffer.setCharAt(endpos - 1, '$');
        this.stringBuffer.append(",");
        return true;
    }

    final boolean writeMolFragments(RxnMolecule rm) {
        int k;
        Molecule mol;
        int i;
        boolean written = false;
        int startpos = this.stringBuffer.length();
        this.stringBuffer.append("f:");
        int n = 0;
        int f = 0;
        for (i = 0; i < rm.getReactantCount(); ++i) {
            mol = rm.getReactant(i);
            f = mol.getFragCount(1);
            if (f > 1) {
                for (k = 0; k < f; ++k) {
                    if (k + 1 < f) {
                        this.stringBuffer.append(n + k + ".");
                        continue;
                    }
                    this.stringBuffer.append(n + k + ",");
                }
                written = true;
            }
            n += f;
        }
        for (i = 0; i < rm.getAgentCount(); ++i) {
            mol = rm.getAgent(i);
            f = mol.getFragCount(1);
            if (f > 1) {
                for (k = 0; k < f; ++k) {
                    if (k + 1 < f) {
                        this.stringBuffer.append(n + k + ".");
                        continue;
                    }
                    this.stringBuffer.append(n + k + ",");
                }
                written = true;
            }
            n += f;
        }
        for (i = 0; i < rm.getProductCount(); ++i) {
            mol = rm.getProduct(i);
            f = mol.getFragCount(1);
            if (f > 1) {
                for (k = 0; k < f; ++k) {
                    if (k + 1 < f) {
                        this.stringBuffer.append(n + k + ".");
                        continue;
                    }
                    this.stringBuffer.append(n + k + ",");
                }
                written = true;
            }
            n += f;
        }
        if (!written) {
            this.stringBuffer.setLength(startpos);
            return false;
        }
        return true;
    }

    final boolean writeCTinRings(MoleculeGraph m, int[] smilesBonds, int[] ctab2smi) {
        int[][] ctab = m.getCtab();
        int[][] dbsab = this.dbsActiveBonds;
        if (dbsab == null) {
            return false;
        }
        int bc = m.getBondCount();
        int FCXCT = 393216;
        for (int i = 0; i < bc; ++i) {
            int sidx;
            int idx;
            int j;
            MolBond b = m.getBond(i);
            int type = b.getType();
            int smiBondIdx = smilesBonds[i];
            int f = dbsab[smiBondIdx][0];
            if (type != 2 || (f & FCXCT) == 0 || (f & FCXCT) == FCXCT) continue;
            int idx2 = dbsab[smiBondIdx][1];
            int idx3 = dbsab[smiBondIdx][2];
            int idx1 = 0;
            int idx4 = 0;
            int sidx1 = Integer.MAX_VALUE;
            int sidx4 = Integer.MAX_VALUE;
            int[] an = ctab[idx2];
            for (j = 0; j < an.length; ++j) {
                idx = an[j];
                sidx = ctab2smi[idx];
                if (idx == idx3 || sidx >= sidx1) continue;
                sidx1 = sidx;
                idx1 = idx;
            }
            an = ctab[idx3];
            for (j = 0; j < an.length; ++j) {
                idx = an[j];
                sidx = ctab2smi[idx];
                if (idx == idx2 || sidx >= sidx4) continue;
                sidx4 = sidx;
                idx4 = idx;
            }
            int ct = (f & 0x20000) != 0 ? 128 : 0;
            ct = (f & 0x40000) != 0 ? 64 : ct;
            MolAtom a1 = m.getAtom(idx1);
            MolAtom a4 = m.getAtom(idx4);
            ct = b.transformCT(a1, a4, ct);
            f &= ~FCXCT;
            f = ct == 128 ? (f |= 0x20000) : (f |= 0x40000);
            dbsab[smiBondIdx][0] = f;
        }
        boolean written1 = false;
        int startpos = this.stringBuffer.length();
        this.stringBuffer.append("c:");
        for (int i = 0; i < bc; ++i) {
            int f = dbsab[i][0];
            if ((f & 0x20000) == 0) continue;
            this.stringBuffer.append(i + ",");
            written1 = true;
        }
        if (!written1) {
            this.stringBuffer.setLength(startpos);
        }
        int endpos1 = this.stringBuffer.length();
        boolean written2 = false;
        this.stringBuffer.append("t:");
        for (int i = 0; i < bc; ++i) {
            int f = dbsab[i][0];
            if ((f & 0x40000) == 0) continue;
            this.stringBuffer.append(i + ",");
            written2 = true;
        }
        if (!written2) {
            this.stringBuffer.setLength(endpos1);
        }
        return written1 || written2;
    }

    final int[] standardizeLocalParity(MoleculeGraph m) {
        int[][] ctab = null;
        int[] grinv = null;
        int ac = m.getAtomCount();
        int[] locp = new int[ac];
        int[][] sssr = null;
        boolean[] ringAtom = null;
        for (int i = 0; i < ac; ++i) {
            locp[i] = m.getLocalParity(i);
            int p = m.getParity(i);
            int n = p = p != 0 && m.getParityType(i) != 1 ? 0 : p;
            if (locp[i] == 0 || locp[i] == p) continue;
            if (sssr == null) {
                ctab = m.getCtab();
                sssr = m.getSSSR();
                grinv = new int[ac];
                m.getGrinv(grinv, 3);
                ringAtom = new boolean[ac];
                for (int j = 0; j < sssr.length; ++j) {
                    int[] r = sssr[j];
                    for (int k = 0; k < r.length; ++k) {
                        ringAtom[r[k]] = true;
                    }
                }
            }
            boolean found = false;
            int[] an = ctab[i];
            int bc = an.length;
            for (int j = 0; j < bc && !found; ++j) {
                int idx = an[j];
                long g = grinv[idx];
                if (ringAtom[idx]) continue;
                for (int k = j + 1; k < bc && !found; ++k) {
                    int idx2 = an[k];
                    if (ringAtom[idx2] || g != (long)grinv[idx2]) continue;
                    found = true;
                }
            }
            if (!found || locp[i] == 1) continue;
            locp[i] = 1;
        }
        return locp;
    }

    final boolean writeLocalParity(MoleculeGraph m, int[] smilesAtoms, int[] ctab2smi, int[] localp) {
        int i;
        int atom;
        int[][] ctab = m.getCtab();
        int na = smilesAtoms.length;
        boolean written1 = false;
        int startpos = this.stringBuffer.length();
        this.stringBuffer.append("@:");
        for (int i2 = 0; i2 < na; ++i2) {
            int locP_converted;
            int atom2 = smilesAtoms[i2];
            int locp = localp == null ? m.getLocalParity(atom2) : localp[atom2];
            int n = locp = locp != 0 && m.getParityType(atom2) != 1 ? 0 : locp;
            if (locp == 0 || locp == 3) continue;
            int[] lidx = ctab[atom2];
            int psignMDL = MolAtom.paritySign(lidx[0], lidx[1], lidx[2], lidx.length == 4 ? lidx[3] : Integer.MAX_VALUE);
            int psignSMI = MolAtom.paritySign(ctab2smi[lidx[0]], ctab2smi[lidx[1]], ctab2smi[lidx[2]], lidx.length == 4 ? ctab2smi[lidx[3]] : Integer.MAX_VALUE);
            int n2 = locP_converted = psignMDL != psignSMI ? locp ^ 3 : locp;
            if (locP_converted != 1 || locp == (m.getParity(atom2) & 3)) continue;
            this.stringBuffer.append(i2 + ",");
            written1 = true;
        }
        int lonePairL = this.originalLPIdxAndParity == null ? 0 : this.originalLPIdxAndParity.length;
        for (int i3 = 0; i3 < lonePairL; ++i3) {
            int locP_converted;
            int info = this.originalLPIdxAndParity[i3];
            int locp = info & 0x30000;
            if (locp == 0) continue;
            locp = locp == 65536 ? 1 : (locp == 131072 ? 2 : 0);
            atom = info & 0xFFFF;
            int[] lidx = ctab[atom];
            int psignMDL = MolAtom.paritySign(lidx[0], lidx[1], lidx[2], Integer.MAX_VALUE);
            int psignSMI = MolAtom.paritySign(ctab2smi[lidx[0]], ctab2smi[lidx[1]], ctab2smi[lidx[2]], Integer.MAX_VALUE);
            int n = locP_converted = psignMDL != psignSMI ? locp ^ 3 : locp;
            if (locP_converted != 1) continue;
            this.stringBuffer.append(ctab2smi[atom] + ",");
            written1 = true;
        }
        if (!written1) {
            this.stringBuffer.setLength(startpos);
        }
        int endpos1 = this.stringBuffer.length();
        boolean written2 = false;
        this.stringBuffer.append("@@:");
        for (i = 0; i < na; ++i) {
            int locP_converted;
            atom = smilesAtoms[i];
            int locp = localp == null ? m.getLocalParity(atom) : localp[atom];
            int n = locp = locp != 0 && m.getParityType(atom) != 1 ? 0 : locp;
            if ((locp &= 3) == 0 || locp == 3) continue;
            int[] lidx = ctab[atom];
            int psignMDL = MolAtom.paritySign(lidx[0], lidx[1], lidx[2], lidx.length == 4 ? lidx[3] : Integer.MAX_VALUE);
            int psignSMI = MolAtom.paritySign(ctab2smi[lidx[0]], ctab2smi[lidx[1]], ctab2smi[lidx[2]], lidx.length == 4 ? ctab2smi[lidx[3]] : Integer.MAX_VALUE);
            int n3 = locP_converted = psignMDL != psignSMI ? locp ^ 3 : locp;
            if (locP_converted != 2 || locp == (m.getParity(atom) & 3)) continue;
            this.stringBuffer.append(i + ",");
            written2 = true;
        }
        for (i = 0; i < lonePairL; ++i) {
            int locP_converted;
            int info = this.originalLPIdxAndParity[i];
            int locp = info & 0x30000;
            if (locp == 0) continue;
            int atom3 = info & 0xFFFF;
            locp = locp == 65536 ? 1 : (locp == 131072 ? 2 : 0);
            int[] lidx = ctab[atom3];
            int psignMDL = MolAtom.paritySign(lidx[0], lidx[1], lidx[2], Integer.MAX_VALUE);
            int psignSMI = MolAtom.paritySign(ctab2smi[lidx[0]], ctab2smi[lidx[1]], ctab2smi[lidx[2]], Integer.MAX_VALUE);
            int n = locP_converted = psignMDL != psignSMI ? locp ^ 3 : locp;
            if (locP_converted != 2) continue;
            this.stringBuffer.append(ctab2smi[atom3] + ",");
            written2 = true;
        }
        if (!written2) {
            this.stringBuffer.setLength(endpos1);
        }
        return written1 || written2;
    }

    private final boolean writeBicycloStereo(MoleculeGraph m, int[] ctab2smi) {
        int THB = 4;
        int TLB = 5;
        int TEB = 6;
        BicycloStereoRecognizer sr = new BicycloStereoRecognizer();
        sr.calculateDescriptors(m);
        HashMap<Integer, BicycloStereoDescriptor[]> d = sr.getLocalDescriptors();
        if (d.isEmpty()) {
            return false;
        }
        Set<Integer> k = d.keySet();
        boolean written1 = false;
        int startpos = this.stringBuffer.length();
        this.stringBuffer.append("TLB:");
        for (Integer key : k) {
            int atom = ctab2smi[key];
            BicycloStereoDescriptor[] v = d.get(key);
            for (int i = 0; i < v.length; ++i) {
                BicycloStereoDescriptor desc = v[i];
                int value = CxsmilesExport.flipBicycloValueIfNedded(desc, ctab2smi);
                if (value != 5) continue;
                this.writeBicycloDescriptor(ctab2smi, atom, desc);
                written1 = true;
            }
        }
        if (!written1) {
            this.stringBuffer.setLength(startpos);
        }
        boolean written2 = false;
        int startpos1 = this.stringBuffer.length();
        this.stringBuffer.append("THB:");
        for (Integer key : k) {
            int aIdx = key;
            int smiatom = ctab2smi[aIdx];
            BicycloStereoDescriptor[] v = d.get(key);
            for (int i = 0; i < v.length; ++i) {
                BicycloStereoDescriptor desc = v[i];
                int value = CxsmilesExport.flipBicycloValueIfNedded(desc, ctab2smi);
                if (value != 4) continue;
                this.writeBicycloDescriptor(ctab2smi, smiatom, desc);
                written2 = true;
            }
        }
        if (!written2) {
            this.stringBuffer.setLength(startpos1);
        }
        boolean written3 = false;
        int startpos2 = this.stringBuffer.length();
        this.stringBuffer.append("TEB:");
        for (Integer key : k) {
            int aIdx = key;
            int smiatom = ctab2smi[aIdx];
            BicycloStereoDescriptor[] v = d.get(key);
            for (int i = 0; i < v.length; ++i) {
                BicycloStereoDescriptor desc = v[i];
                int value = desc.getStereoValue();
                if (value != 6) continue;
                this.writeBicycloDescriptor(ctab2smi, smiatom, desc);
                written3 = true;
            }
        }
        if (!written3) {
            this.stringBuffer.setLength(startpos2);
        }
        return written1 || written2 || written3;
    }

    private static int flipBicycloValueIfNedded(BicycloStereoDescriptor d, int[] sa) {
        int v = d.getStereoValue();
        if (!BicycloStereoRecognizer.isSameStereoClass(d, sa)) {
            if (v == 4) {
                v = 5;
            } else if (v == 5) {
                v = 4;
            }
        }
        return v;
    }

    private void writeBicycloDescriptor(int[] smilesAtoms, int atom, BicycloStereoDescriptor desc) {
        int l;
        int j;
        this.stringBuffer.append(atom + ":");
        this.stringBuffer.append(smilesAtoms[desc.getConnectionAtomIndex()] + ":");
        int[] rIdx = desc.getLowBridgeAtomIndexes();
        for (j = 0; j < rIdx.length; ++j) {
            l = rIdx[j];
            this.stringBuffer.append(smilesAtoms[l] + ".");
        }
        this.stringBuffer.setCharAt(this.stringBuffer.length() - 1, ':');
        rIdx = desc.getHighBridgeAtomIndexes();
        for (j = 0; j < rIdx.length; ++j) {
            l = rIdx[j];
            this.stringBuffer.append(smilesAtoms[l] + ".");
        }
        this.stringBuffer.setCharAt(this.stringBuffer.length() - 1, ',');
    }

    final boolean writeRadicals(MoleculeGraph m, int[] smilesAtoms) {
        int na = smilesAtoms.length;
        boolean written1 = false;
        int startpos = this.stringBuffer.length();
        this.stringBuffer.append("^1:");
        for (int i = 0; i < na; ++i) {
            int atom = smilesAtoms[i];
            int rad = m.getAtom(atom).getRadical();
            if (rad != 1) continue;
            this.stringBuffer.append(i + ",");
            written1 = true;
        }
        if (!written1) {
            this.stringBuffer.setLength(startpos);
        }
        int endpos1 = this.stringBuffer.length();
        boolean written2 = false;
        this.stringBuffer.append("^2:");
        for (int i = 0; i < na; ++i) {
            int atom = smilesAtoms[i];
            int rad = m.getAtom(atom).getRadical();
            if (rad != 2) continue;
            this.stringBuffer.append(i + ",");
            written2 = true;
        }
        if (!written2) {
            this.stringBuffer.setLength(endpos1);
        }
        int endpos2 = this.stringBuffer.length();
        boolean written3 = false;
        this.stringBuffer.append("^3:");
        for (int i = 0; i < na; ++i) {
            int atom = smilesAtoms[i];
            int rad = m.getAtom(atom).getRadical();
            if (rad != 6) continue;
            this.stringBuffer.append(i + ",");
            written3 = true;
        }
        if (!written3) {
            this.stringBuffer.setLength(endpos2);
        }
        int endpos3 = this.stringBuffer.length();
        boolean written4 = false;
        this.stringBuffer.append("^4:");
        for (int i = 0; i < na; ++i) {
            int atom = smilesAtoms[i];
            int rad = m.getAtom(atom).getRadical();
            if (rad != 10) continue;
            this.stringBuffer.append(i + ",");
            written4 = true;
        }
        if (!written4) {
            this.stringBuffer.setLength(endpos3);
        }
        int endpos4 = this.stringBuffer.length();
        boolean written5 = false;
        this.stringBuffer.append("^5:");
        for (int i = 0; i < na; ++i) {
            int atom = smilesAtoms[i];
            int rad = m.getAtom(atom).getRadical();
            if (rad != 3) continue;
            this.stringBuffer.append(i + ",");
            written5 = true;
        }
        if (!written5) {
            this.stringBuffer.setLength(endpos4);
        }
        return written1 || written2 || written3 || written4 || written5;
    }

    final boolean writeExplicitLonePair(MoleculeGraph m, int[] ctab2smi) {
        int ll = this.originalLPIdxAndParity.length;
        boolean written = false;
        int startpos = this.stringBuffer.length();
        this.stringBuffer.append("LP:");
        for (int i = 0; i < ll; ++i) {
            int smiidx = ctab2smi[this.originalLPIdxAndParity[i] & 0xFFFF];
            this.stringBuffer.append(smiidx + ",");
            written = true;
        }
        if (!written) {
            this.stringBuffer.setLength(startpos);
        }
        return written;
    }

    final boolean writeImplicitLonePair(MoleculeGraph m, int[] smilesAtoms) {
        int na = smilesAtoms.length;
        boolean written = false;
        int startpos = this.stringBuffer.length();
        this.stringBuffer.append("lp:");
        for (int i = 0; i < na; ++i) {
            int atom = smilesAtoms[i];
            int lp = m.getAtom(atom).getElectronProp();
            if (lp <= 0) continue;
            this.stringBuffer.append(i + ":" + lp + ",");
            written = true;
        }
        if (!written) {
            this.stringBuffer.setLength(startpos);
        }
        return written;
    }

    final boolean writeCoordAndMultiCenter(MoleculeGraph m, int[] smilesAtoms, int[] ctab2smi, int[] smilesBonds) {
        int na = smilesAtoms.length;
        boolean written1 = false;
        int startpos = this.stringBuffer.length();
        this.stringBuffer.append("m:");
        for (int i = 0; i < na; ++i) {
            int atom = smilesAtoms[i];
            MolAtom a = m.getAtom(atom);
            if (a.getAtno() != 137) continue;
            this.stringBuffer.append(i + ":");
            MulticenterSgroup msg = ((Molecule)m).findContainingMulticenterSgroup(a);
            if (msg == null) continue;
            int l = msg.getAtomCount();
            for (int j = 0; j < l; ++j) {
                int idx = m.indexOf(msg.getAtom(j));
                this.stringBuffer.append(ctab2smi[idx] + ".");
            }
            this.stringBuffer.setCharAt(this.stringBuffer.length() - 1, ',');
            written1 = true;
        }
        if (!written1) {
            this.stringBuffer.setLength(startpos);
        }
        int endpos1 = this.stringBuffer.length();
        boolean written2 = false;
        int bc = m.getBondCount();
        this.stringBuffer.append("C:");
        for (int i = 0; i < bc; ++i) {
            MolBond b = m.getBond(i);
            if (!b.isCoordinate()) continue;
            int idx = m.indexOf(b.getAtom1());
            this.stringBuffer.append(ctab2smi[idx] + "." + smilesBonds[i] + ",");
            written2 = true;
        }
        if (!written2) {
            this.stringBuffer.setLength(endpos1);
        }
        return written1 || written2;
    }

    final boolean writeLinkNodes(MoleculeGraph m, int[] smilesAtoms, int[] ctab2smi) {
        boolean written = false;
        int startpos = this.stringBuffer.length();
        this.stringBuffer.append("LN:");
        int l = smilesAtoms.length;
        for (int i = 0; i < l; ++i) {
            int atom = smilesAtoms[i];
            MolAtom a = m.getAtom(atom);
            if (!a.isLinkNode()) continue;
            this.stringBuffer.append(i + ":" + a.getMinRepetitions() + "." + a.getMaxRepetitions());
            if (a.getBondCount() == 2) {
                this.stringBuffer.append(",");
            } else {
                int o_0 = a.getLinkNodeOuterAtom(0);
                o_0 = o_0 >= 0 ? ctab2smi[m.indexOf(a.getLigand(o_0))] : o_0;
                int o_1 = a.getLinkNodeOuterAtom(1);
                o_1 = o_1 >= 0 ? ctab2smi[m.indexOf(a.getLigand(o_1))] : o_1;
                this.stringBuffer.append("." + (o_0 >= 0 ? "" + o_0 : "") + "." + (o_1 >= 0 ? "" + o_1 : "") + ",");
            }
            written = true;
        }
        if (!written) {
            this.stringBuffer.setLength(startpos);
        }
        return written;
    }

    final boolean writeCoordinates(MoleculeGraph m, int[] smilesAtoms, NumberFormat formatter) {
        int i;
        int na = smilesAtoms.length;
        boolean written = false;
        int startpos = this.stringBuffer.length();
        this.stringBuffer.append("(");
        for (i = 0; i < na; ++i) {
            double z;
            double y;
            int atom = smilesAtoms[i];
            MolAtom a = m.getAtom(atom);
            double x = a.getX();
            if (!CxsmilesExport.isZero(x, y = a.getY(), z = a.getZ())) {
                this.stringBuffer.append((x == 0.0 ? "" : formatter.format(x)) + "," + (y == 0.0 ? "" : formatter.format(y)) + "," + (z == 0.0 ? "" : formatter.format(z)));
                written = true;
            }
            this.stringBuffer.append(";");
        }
        if (this.writeLonePair && this.lpCoordinates != null) {
            for (i = 0; i < this.lpCoordinates.length; ++i) {
                double x = this.lpCoordinates[i][0];
                double y = this.lpCoordinates[i][1];
                double z = this.lpCoordinates[i][2];
                if (!CxsmilesExport.isZero(x, y, z)) {
                    this.stringBuffer.append((x == 0.0 ? "" : formatter.format(x)) + "," + (y == 0.0 ? "" : formatter.format(y)) + "," + (z == 0.0 ? "" : formatter.format(z)));
                }
                this.stringBuffer.append(";");
            }
        }
        int endpos = this.stringBuffer.length();
        if (!written) {
            this.stringBuffer.setLength(startpos);
            return false;
        }
        this.stringBuffer.setCharAt(endpos - 1, ')');
        this.stringBuffer.append(",");
        return true;
    }

    final boolean writeDataSgroup(MoleculeGraph mg, int[] ctab2smi, NumberFormat formatter) {
        Molecule m = null;
        if (!(mg instanceof Molecule)) {
            return false;
        }
        m = (Molecule)mg;
        boolean written = false;
        int startpos = this.stringBuffer.length();
        int nSg = m.getSgroupCount();
        for (int i = 0; i < nSg; ++i) {
            int j;
            Sgroup sg = m.getSgroup(i);
            int t = sg.getType();
            if (t != 10) continue;
            this.stringBuffer.append("SgD:");
            DataSgroup dsg = (DataSgroup)sg;
            SelectionMolecule sgg = dsg.getSgroupGraph();
            int sgl = sgg.getAtomCount();
            for (j = 0; j < sgl; ++j) {
                this.stringBuffer.append(ctab2smi[mg.indexOf(sgg.getAtom(j))]);
                if (j < sgl - 1) {
                    this.stringBuffer.append(",");
                    continue;
                }
                this.stringBuffer.append(":");
            }
            CxsmilesExport.appendEscapedString(this.stringBuffer, allowedCharsInDataSgroup, dsg.getFieldName());
            this.stringBuffer.append(":");
            sgl = dsg.getDataLineCount();
            for (j = 0; j < sgl; ++j) {
                CxsmilesExport.appendEscapedString(this.stringBuffer, allowedCharsInDataSgroup, dsg.getDataLine(j));
                if (j >= sgl - 1) continue;
                this.stringBuffer.append("&#");
                this.stringBuffer.append(Integer.toString(10));
                this.stringBuffer.append(';');
            }
            this.stringBuffer.append(":");
            String queryOp = dsg.getQueryOp();
            if (queryOp != null) {
                this.stringBuffer.append(queryOp);
            }
            this.stringBuffer.append(":");
            String unit = dsg.getUnits();
            if (unit != null) {
                this.stringBuffer.append(unit);
            }
            this.stringBuffer.append(":");
            char tag = dsg.getTag();
            if (tag != ' ') {
                this.stringBuffer.append(tag);
            }
            this.stringBuffer.append(":");
            if (this.writeCoordinates) {
                this.stringBuffer.append("(");
                if (!dsg.isDataDetached()) {
                    this.stringBuffer.append("-1");
                } else {
                    DPoint3 p = dsg.getAbsoluteXY();
                    double x = p.x;
                    double y = p.y;
                    if (!CxsmilesExport.isZero(x, y, 0.0) && formatter != null) {
                        this.stringBuffer.append((x == 0.0 ? "" : formatter.format(x)) + "," + (y == 0.0 ? "" : formatter.format(y)));
                    }
                }
                this.stringBuffer.append(")");
            }
            this.stringBuffer.append(",");
            written = true;
        }
        if (!written) {
            this.stringBuffer.setLength(startpos);
        }
        return written;
    }

    static final void correctSmiBondIdx(int[] smilesBondIdx, RxnMolecule rxn) {
        int i;
        int eR = 0;
        int eP = 0;
        int eA = 0;
        for (i = 0; i < rxn.getReactantCount(); ++i) {
            eR += rxn.getReactant(i).getBondCount();
        }
        for (i = 0; i < rxn.getProductCount(); ++i) {
            eP += rxn.getProduct(i).getBondCount();
        }
        for (i = 0; i < rxn.getAgentCount(); ++i) {
            eA += rxn.getAgent(i).getBondCount();
        }
        for (i = 0; i < smilesBondIdx.length; ++i) {
            if (i < eR) continue;
            if (i < eA + eR) {
                int n = i;
                smilesBondIdx[n] = smilesBondIdx[n] + eP;
                continue;
            }
            int n = i;
            smilesBondIdx[n] = smilesBondIdx[n] - eA;
        }
    }

    static final void correctSmiAtomIdx(int[] smilesAtoms, RxnMolecule rxn) {
        int i;
        int eR = 0;
        int eP = 0;
        int eA = 0;
        for (i = 0; i < rxn.getReactantCount(); ++i) {
            eR += rxn.getReactant(i).getAtomCount();
        }
        for (i = 0; i < rxn.getProductCount(); ++i) {
            eP += rxn.getProduct(i).getAtomCount();
        }
        for (i = 0; i < rxn.getAgentCount(); ++i) {
            eA += rxn.getAgent(i).getAtomCount();
        }
        for (i = 0; i < smilesAtoms.length; ++i) {
            if (i < eR) continue;
            if (i < eA + eR) {
                int n = i;
                smilesAtoms[n] = smilesAtoms[n] + eP;
                continue;
            }
            int n = i;
            smilesAtoms[n] = smilesAtoms[n] - eA;
        }
    }

    static final int[] smiAtomIdxConv(RxnMolecule rxn) {
        int i;
        int ac = rxn.getAtomCount();
        int[] conv = new int[ac];
        int eR = 0;
        int eP = 0;
        int eA = 0;
        for (i = 0; i < rxn.getReactantCount(); ++i) {
            eR += rxn.getReactant(i).getAtomCount();
        }
        for (i = 0; i < rxn.getProductCount(); ++i) {
            eP += rxn.getProduct(i).getAtomCount();
        }
        for (i = 0; i < rxn.getAgentCount(); ++i) {
            eA += rxn.getAgent(i).getAtomCount();
        }
        for (i = 0; i < ac; ++i) {
            conv[i] = i < eR ? i : (i < eA + eR ? i + eP : i - eA);
        }
        return conv;
    }

    private static final boolean isZero(double x, double y, double z) {
        return x == 0.0 && y == 0.0 && z == 0.0;
    }

    @Override
    final void throwMolExportExceptionSMILES(Molecule mol) throws MolExportException {
        String molSmarts = this.getSimpleSmartsString(mol);
        throw new MolExportException("\nSome features of " + molSmarts + " cannot be converted to cxsmiles." + " Try cxsmarts format.");
    }

    static final void appendEscapedString(StringBuffer sb, String allowed, String v) {
        if (v == null) {
            return;
        }
        for (int i = 0; i < v.length(); ++i) {
            char c = v.charAt(i);
            CxsmilesExport.appendEscapedCharData(sb, allowed, c);
        }
    }

    private static final void appendEscapedCharData(StringBuffer sb, String allowed, char c) {
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || allowed.indexOf(c) >= 0) {
            sb.append(c);
        } else {
            sb.append("&#");
            sb.append(Integer.toString(c));
            sb.append(';');
        }
    }

    private static final boolean needDoubleExport(MoleculeGraph m) {
        int ac = m.getAtomCount();
        int stereoN = -1;
        boolean hasParityInfo = false;
        for (int i = 0; i < ac; ++i) {
            int p = m.getParity(i);
            if (p != 1 && p != 2) continue;
            hasParityInfo = true;
            MolAtom a = m.getAtom(i);
            int t = a.getStereoGroupType();
            if (t == 2) {
                int n = a.getStereoGroupNumber();
                if (n > 0) {
                    if (stereoN == -1) {
                        stereoN = n;
                    } else if (stereoN != n) {
                        return false;
                    }
                    if (a.getStereoGroupType() == 2) continue;
                    return false;
                }
                return false;
            }
            if (t == 0) continue;
            return false;
        }
        if (stereoN > 0) {
            return true;
        }
        return !m.isAbsStereo() && hasParityInfo;
    }

    private static final Molecule createMirrorImage(Molecule m) {
        Molecule mol = (Molecule)m.clone();
        if (mol.getDim() == 0) {
            int ac = mol.getAtomCount();
            for (int i = 0; i < ac; ++i) {
                MolAtom a = mol.getAtom(i);
                int p = a.getFlags() & 7;
                if (p != 1 && p != 2) continue;
                a.setFlags(p ^= 3, 7);
            }
        } else {
            CTransform3D flip = new CTransform3D();
            flip.m00 = -1.0;
            flip.m22 = -1.0;
            mol.transform(flip);
        }
        return mol;
    }

    void setFields(CxsmilesExport classObject) {
        super.setFields(classObject);
        this.writeEnhancedStereo = classObject.writeEnhancedStereo;
        this.writeLabels = classObject.writeLabels;
        this.writeWigglybonds = classObject.writeWigglybonds;
        this.writeFragments = classObject.writeFragments;
        this.writeCT = classObject.writeCT;
        this.writeLocalP = classObject.writeLocalP;
        this.writeRadical = classObject.writeRadical;
        this.writeLonePair = classObject.writeLonePair;
        this.hasExplicitLonePair = classObject.hasExplicitLonePair;
        this.writeCoordinates = classObject.writeCoordinates;
        this.coordinatePrecision = classObject.coordinatePrecision;
        this.writeCoordAndMultiCenter = classObject.writeCoordAndMultiCenter;
        this.writeLinkNode = classObject.writeLinkNode;
        this.lpCoordinates = classObject.lpCoordinates;
        this.writeDataSgroup = classObject.writeDataSgroup;
        this.writeAttachmentPoint = classObject.writeAttachmentPoint;
        this.writeLocalBicyclo = classObject.writeLocalBicyclo;
        this.writeRgroup = classObject.writeRgroup;
    }
}

