/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.smiles;

import chemaxon.calculations.stereo.BicycloStereoRecognizer;
import chemaxon.common.util.IntVector;
import chemaxon.formats.MolFormatException;
import chemaxon.marvin.io.formats.smiles.CxsConstants;
import chemaxon.marvin.io.formats.smiles.SmilesImport;
import chemaxon.struc.BicycloStereoDescriptor;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.sgroup.DataSgroup;
import chemaxon.struc.sgroup.MulticenterSgroup;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class CxsmilesImport
extends SmilesImport {
    static final int FCXCIS = 1;
    static final int FCXTRANS = 2;
    static final int REACTANTS = 0;
    static final int AGENTS = 2;
    static final int PRODUCTS = 1;
    private static final String stepCharDataSgroup = ":";
    private static final String separatorDataSgroup = ",|";
    private HashMap<MolAtom, LinkedList<MolAtom>> multicenterSgroups = null;
    private boolean fixStereoFlag = false;

    public CxsmilesImport() {
    }

    CxsmilesImport(CxsmilesImport cxsim) {
        this();
        this.fixStereoFlag = cxsim.fixStereoFlag;
        this.querySmarts = cxsim.querySmarts;
        super.copyOptions(cxsim);
    }

    @Override
    int setOptions(String opts, int i, List<String> fields) {
        if ((i = super.setOptions(opts, i, fields)) >= opts.length()) {
            return i;
        }
        char c = opts.charAt(i);
        if (c == 's') {
            this.fixStereoFlag = true;
            ++i;
        }
        return i;
    }

    @Override
    public boolean readMol(String smiles, Molecule mol) throws IOException {
        boolean ret = super.readMol(smiles, mol);
        mol.setInputFormat(this.querySmarts ? "cxsmarts" : "cxsmiles");
        if (this.multicenterSgroups != null) {
            this.multicenterSgroups.clear();
        }
        return ret;
    }

    @Override
    boolean setChiralFlag(MoleculeGraph m) {
        if (this.fixStereoFlag) {
            return super.setChiralFlag(m);
        }
        m.setAbsStereo(true);
        return true;
    }

    @Override
    int readExtendedFeatures(int beginIndex, String line, Molecule m) throws IOException {
        boolean up_down_restored = false;
        int dim = 0;
        int ac = m.getAtomCount();
        int bc = m.getBondCount();
        int cac = ac;
        int[] bondFlags = new int[bc];
        int grp = -1;
        int grpNr = -1;
        int radicalType = -1;
        MolAtom fromAtom = null;
        MulticenterSgroup msg = null;
        Molecule mcsg_p = null;
        MolAtom multicenterSgCenter = null;
        int bondType = 0;
        Molecule moljoin = null;
        int removed = 0;
        int last = line.length();
        MolAtom atom_BS = null;
        MolAtom conn_BS = null;
        int value_BS = 0;
        IntVector ring1 = null;
        IntVector ring2 = null;
        int rgIndex = -1;
        MolAtom ligandOrderCenter = null;
        IntVector ligandOrder = null;
        RxnMolecule rxn = CxsmilesImport.getRxnMolecule(m);
        int nR = CxsmilesImport.getComponentNodeCount(rxn, 0);
        int nA = CxsmilesImport.getComponentNodeCount(rxn, 2);
        int nP = CxsmilesImport.getComponentNodeCount(rxn, 1);
        int eR = CxsmilesImport.getComponentEdgeCount(rxn, 0);
        int eA = CxsmilesImport.getComponentEdgeCount(rxn, 2);
        int eP = CxsmilesImport.getComponentEdgeCount(rxn, 1);
        int status = -1;
        int i = 0;
        block0: for (i = beginIndex; i < last; ++i) {
            int x = 0;
            char c = line.charAt(i);
            if (c == 'r') {
                m.setAbsStereo(false);
                continue;
            }
            if (c == 'a') {
                grp = 1;
                status = 2;
                continue;
            }
            if (c == 'o') {
                grp = 2;
                status = 1;
                continue;
            }
            if (c == '&') {
                grp = 3;
                status = 1;
                continue;
            }
            if (c == 'w') {
                up_down_restored = true;
                if (i + 2 >= last) continue;
                if (line.charAt(i + 1) == 'U') {
                    status = 27;
                    i += 2;
                    continue;
                }
                if (line.charAt(i + 1) == 'D') {
                    status = 29;
                    i += 2;
                    continue;
                }
                status = 3;
                continue;
            }
            if (c == 'f') {
                status = 5;
                continue;
            }
            if (c == 'c') {
                status = 7;
                continue;
            }
            if (c == 't') {
                status = 8;
                continue;
            }
            if (c == 'u') {
                status = 9;
                continue;
            }
            if (c == '@') {
                status = i > 0 && line.charAt(i - 1) == '@' ? 11 : 10;
                continue;
            }
            if (c == '^') {
                status = 12;
                continue;
            }
            if (c == 'L') {
                char nextc = line.charAt(i + 1);
                if (nextc == 'P') {
                    status = 14;
                    ++i;
                    continue;
                }
                if (nextc == 'N') {
                    status = 19;
                    ++i;
                    continue;
                }
                if (nextc != 'O') continue;
                status = 37;
                ++i;
                continue;
            }
            if (c == 'l') {
                char nextc = line.charAt(i + 1);
                if (nextc != 'p') continue;
                status = 24;
                ++i;
                continue;
            }
            if (c == 'm') {
                status = 15;
                continue;
            }
            if (c == 'C') {
                status = 17;
                bondType = 9;
                String coordinative = "COORDINATE";
                for (int j = 1; j < coordinative.length() && (c = line.charAt(i + 1)) == coordinative.charAt(j); ++j) {
                    ++i;
                }
                continue;
            }
            if (c == 'S') {
                status = -1;
                if (last <= i + 3) {
                    throw new MolFormatException("Invalid string representation in DataSgroup");
                }
                char c1 = line.charAt(i + 1);
                char c2 = line.charAt(i + 2);
                char c3 = line.charAt(i + 3);
                if (c1 == 'g' && c2 == 'D' && c3 == ':') {
                    i += 3;
                    if ((c = line.charAt(++i)) >= '0' && c <= '9') {
                        i = CxsmilesImport.readDataSgroup(line, i, m, nR, nP, nA);
                        c = line.charAt(i);
                    }
                    --i;
                    continue;
                }
                throw new MolFormatException("Invalid string representation in DataSgroup");
            }
            if (c == 'A') {
                if (last <= i + 3) {
                    throw new MolFormatException("Invalid string representation in Attachment Point");
                }
                char c1 = line.charAt(++i);
                char c2 = line.charAt(++i);
                char c3 = line.charAt(++i);
                if (c1 != 'P' || c2 != '_' || c3 < '0' || c3 > '9') continue;
                grp = c3 - 48;
                status = 26;
                continue;
            }
            if (c == 'T') {
                if (last <= i + 3) {
                    throw new MolFormatException("Invalid string representation in Bicyclo Stereo information");
                }
                char c1 = line.charAt(++i);
                char c2 = line.charAt(++i);
                if (c1 == 'L' && c2 == 'B') {
                    value_BS = 5;
                } else if (c1 == 'H' && c2 == 'B') {
                    value_BS = 4;
                } else if (c1 == 'E' && c2 == 'B') {
                    value_BS = 6;
                }
                status = 31;
                continue;
            }
            if (c == 'R') {
                if (!(m instanceof RgMolecule) && last <= i + 3 || line.charAt(++i) != 'G' || line.charAt(++i) != ':') {
                    throw new MolFormatException("Invalid string representation in RGMolecule information");
                }
                status = 35;
                continue;
            }
            if (status == 35 && c == '_') {
                if (last <= i + 2 || line.charAt(++i) != 'R') {
                    throw new MolFormatException("Invalid string representation in RGMolecule index information");
                }
                status = 36;
                continue;
            }
            if (status == 35 && c == '{') {
                if (rgIndex < 0) {
                    throw new MolFormatException("Invalid string representation in RGMolecule index information");
                }
                int endOfSubMolecule = line.indexOf(125, i + 1);
                if (endOfSubMolecule < 0) {
                    throw new MolFormatException("Invalid string representation in RGMolecule RGroup");
                }
                Molecule nextRGroup = this.readRGroup(line.substring(i + 1, endOfSubMolecule));
                ((RgMolecule)m).addRgroup(rgIndex, nextRGroup);
                i = endOfSubMolecule;
                continue;
            }
            if (c >= '0' && c <= '9') {
                MolAtom a4;
                int idx4;
                int j;
                int idx3;
                int idx2;
                while (i < last) {
                    c = line.charAt(i);
                    if (c < '0' || c > '9') {
                        --i;
                        break;
                    }
                    x = 10 * x + (c - 48);
                    ++i;
                }
                if (status == 1) {
                    grpNr = x;
                    status = 2;
                    continue;
                }
                if (status == 2) {
                    MolAtom a = m.getAtom(x = CxsmilesImport.recalculateAtomIndexIfReaction(x, nR, nP, nA));
                    if (a != null) {
                        a.setStereoGroupType(grp);
                        if (grp == 1) continue;
                        a.setStereoGroupNumber(grpNr);
                        continue;
                    }
                    throw new MolFormatException("Extended Feature import error.\nCould not set atom " + x + " to group" + grpNr + ". The atom doesn't exist.");
                }
                if (status == 3) {
                    x = CxsmilesImport.recalculateAtomIndexIfReaction(x, nR, nP, nA);
                    fromAtom = m.getAtom(x);
                    status = 4;
                    continue;
                }
                if (status == 4) {
                    MolBond b = m.getBond(x = CxsmilesImport.recalculateBondIndexIfReaction(x, eR, eP, eA));
                    if (b != null && fromAtom != null) {
                        b.setFlags(48, 48);
                        if (b.getAtom1() != fromAtom) {
                            b.swap();
                        }
                    } else {
                        throw new MolFormatException("Extended Feature import error.\nCould not set wiggly bond " + x + ". The bond, or the from atom " + "doesn't exist.");
                    }
                    fromAtom.setFlags(3, 3);
                    status = 3;
                    continue;
                }
                if (status == 27) {
                    x = CxsmilesImport.recalculateAtomIndexIfReaction(x, nR, nP, nA);
                    fromAtom = m.getAtom(x);
                    status = 28;
                    continue;
                }
                if (status == 28) {
                    MolBond b = m.getBond(x = CxsmilesImport.recalculateBondIndexIfReaction(x, eR, eP, eA));
                    if (b != null && fromAtom != null) {
                        if (b.getAtom1() != fromAtom) {
                            b.swap();
                        }
                    } else {
                        throw new MolFormatException("Extended Feature import error.\nCould not set UP bond " + x + ". The bond, or the from atom " + "doesn't exist.");
                    }
                    b.setFlags(16, 48);
                    status = 27;
                    continue;
                }
                if (status == 29) {
                    x = CxsmilesImport.recalculateAtomIndexIfReaction(x, nR, nP, nA);
                    fromAtom = m.getAtom(x);
                    status = 30;
                    continue;
                }
                if (status == 30) {
                    MolBond b = m.getBond(x = CxsmilesImport.recalculateBondIndexIfReaction(x, eR, eP, eA));
                    if (b != null && fromAtom != null) {
                        if (b.getAtom1() != fromAtom) {
                            b.swap();
                        }
                    } else {
                        throw new MolFormatException("Extended Feature import error.\nCould not set DOWN bond " + x + ". The bond, or the from atom " + "doesn't exist.");
                    }
                    b.setFlags(32, 48);
                    status = 29;
                    continue;
                }
                if (status == 5) {
                    if (rxn == null) break;
                    moljoin = CxsmilesImport.getFragment(rxn, x -= removed, false);
                    status = 6;
                    continue;
                }
                if (status == 6) {
                    Molecule mol = CxsmilesImport.getFragment(rxn, x -= removed, true);
                    moljoin.fuse(mol);
                    ++removed;
                    continue;
                }
                if (status == 7) {
                    MolBond b = m.getBond(x = CxsmilesImport.recalculateBondIndexIfReaction(x, eR, eP, eA));
                    if (b == null) continue;
                    int ct = 0;
                    if (bondFlags[x] != 2) {
                        int[][] ctab = m.getCtab();
                        idx2 = m.indexOf(b.getAtom1());
                        idx3 = m.indexOf(b.getAtom2());
                        int idx1 = Integer.MAX_VALUE;
                        int[] an = ctab[idx2];
                        for (j = 0; j < an.length; ++j) {
                            int idx = an[j];
                            if (idx == idx3 || idx >= idx1) continue;
                            idx1 = idx;
                        }
                        if (idx1 == Integer.MAX_VALUE) {
                            throw new MolFormatException("CIS bond cannot be set for bond " + x + " between atoms " + (m.indexOf(b.getAtom1()) + 1) + "," + (m.indexOf(b.getAtom2()) + 1));
                        }
                        idx4 = Integer.MAX_VALUE;
                        an = ctab[idx3];
                        for (int j2 = 0; j2 < an.length; ++j2) {
                            int idx = an[j2];
                            if (idx == idx2 || idx >= idx4) continue;
                            idx4 = idx;
                        }
                        if (idx4 == Integer.MAX_VALUE) {
                            throw new MolFormatException("CIS bond cannot be set for bond " + x + " between atoms " + (m.indexOf(b.getAtom1()) + 1) + "," + (m.indexOf(b.getAtom2()) + 1));
                        }
                        ct = 128;
                        MolAtom a1 = m.getAtom(idx1);
                        a4 = m.getAtom(idx4);
                        ct = b.transformCT(a1, a4, ct);
                    } else {
                        ct = 192;
                    }
                    int n = x;
                    bondFlags[n] = bondFlags[n] | 1;
                    b.setFlags(ct, 448);
                    continue;
                }
                if (status == 8) {
                    MolBond b = m.getBond(x = CxsmilesImport.recalculateBondIndexIfReaction(x, eR, eP, eA));
                    if (b == null) continue;
                    int ct = 0;
                    if (bondFlags[x] != 1) {
                        int[][] ctab = m.getCtab();
                        idx2 = m.indexOf(b.getAtom1());
                        idx3 = m.indexOf(b.getAtom2());
                        int[] an = ctab[idx2];
                        int idx1 = Integer.MAX_VALUE;
                        for (j = 0; j < an.length; ++j) {
                            int idx = an[j];
                            if (idx == idx3 || idx >= idx1) continue;
                            idx1 = idx;
                        }
                        if (idx1 == Integer.MAX_VALUE) {
                            throw new MolFormatException("TRANS bond cannot be set for bond " + x + " between atoms " + (m.indexOf(b.getAtom1()) + 1) + "," + (m.indexOf(b.getAtom2()) + 1));
                        }
                        an = ctab[idx3];
                        idx4 = Integer.MAX_VALUE;
                        for (int j3 = 0; j3 < an.length; ++j3) {
                            int idx = an[j3];
                            if (idx == idx2 || idx >= idx4) continue;
                            idx4 = idx;
                        }
                        if (idx4 == Integer.MAX_VALUE) {
                            throw new MolFormatException("TRANS bond cannot be set for bond " + x + " between atoms " + (m.indexOf(b.getAtom1()) + 1) + "," + (m.indexOf(b.getAtom2()) + 1));
                        }
                        ct = 64;
                        MolAtom a1 = m.getAtom(idx1);
                        a4 = m.getAtom(idx4);
                        ct = b.transformCT(a1, a4, ct);
                    } else {
                        ct = 192;
                    }
                    int n = x;
                    bondFlags[n] = bondFlags[n] | 2;
                    b.setFlags(ct, 448);
                    continue;
                }
                if (status == 9) {
                    MolBond b = m.getBond(x = CxsmilesImport.recalculateBondIndexIfReaction(x, eR, eP, eA));
                    if (b == null) continue;
                    b.setFlags(b.getFlags() | 0x100, 448);
                    continue;
                }
                if (status == 10) {
                    MolAtom a = m.getAtom(x = CxsmilesImport.recalculateAtomIndexIfReaction(x, nR, nP, nA));
                    if (a == null) continue;
                    a.setFlags(1, 3);
                    continue;
                }
                if (status == 11) {
                    MolAtom a = m.getAtom(x = CxsmilesImport.recalculateAtomIndexIfReaction(x, nR, nP, nA));
                    if (a == null) continue;
                    a.setFlags(2, 3);
                    continue;
                }
                if (status == 12) {
                    int n = x == 1 ? 1 : (x == 2 ? 2 : (x == 3 ? 6 : (x == 4 ? 10 : (radicalType = x == 5 ? 3 : 0))));
                    if (radicalType == 0) {
                        throw new MolFormatException("Radical type not supported.");
                    }
                    status = 13;
                    continue;
                }
                if (status == 13) {
                    MolAtom a = m.getAtom(x = CxsmilesImport.recalculateAtomIndexIfReaction(x, nR, nP, nA));
                    if (a != null) {
                        a.setRadical(radicalType);
                        a.valenceCheck();
                        continue;
                    }
                    throw new MolFormatException("Extended Feature import error.\nCould not set atom " + x + " to radical" + radicalType + ". The atom doesn't exist.");
                }
                if (status == 14) {
                    if (x >= 0 && x < ac) {
                        x = CxsmilesImport.recalculateAtomIndexIfReaction(x, nR, nP, nA);
                        MolAtom a = m.getAtom(x);
                        MolAtom lp = m.reuseAtom(130, cac++);
                        MolBond b = new MolBond(a, lp, 1);
                        m.add(b);
                        continue;
                    }
                    throw new MolFormatException("Extended Feature import error.\nCould not set the lone pair to the atom " + x);
                }
                if (status == 15) {
                    if (x >= 0 && x < ac) {
                        x = CxsmilesImport.recalculateAtomIndexIfReaction(x, nR, nP, nA);
                        MolAtom a = m.getAtom(x);
                        a.setAtno(137);
                        if (m instanceof RgMolecule) {
                            if (this.multicenterSgroups == null) {
                                this.multicenterSgroups = new HashMap();
                            }
                            multicenterSgCenter = a;
                            this.multicenterSgroups.put(a, new LinkedList());
                        } else {
                            mcsg_p = (Molecule)a.getParent();
                            msg = new MulticenterSgroup(mcsg_p);
                            msg.setCentralAtom(a);
                        }
                    } else {
                        throw new MolFormatException("Extended Feature import error.\nCould not set MULTICENTER atom " + x);
                    }
                    status = 16;
                    continue;
                }
                if (status == 16) {
                    if (c == ',') {
                        status = 15;
                    }
                    if (x >= 0 && x < ac) {
                        x = CxsmilesImport.recalculateAtomIndexIfReaction(x, nR, nP, nA);
                        MolAtom a = m.getAtom(x);
                        if (m instanceof RgMolecule) {
                            LinkedList<MolAtom> keys = this.multicenterSgroups.get(multicenterSgCenter);
                            keys.add(a);
                            continue;
                        }
                        mcsg_p.setSgroupParent(a, msg, true);
                        continue;
                    }
                    throw new MolFormatException("Extended Feature import error.\nCould not set MULTICENTER atom " + x);
                }
                if (status == 17) {
                    if (x >= 0 && x < ac) {
                        x = CxsmilesImport.recalculateAtomIndexIfReaction(x, nR, nP, nA);
                        fromAtom = m.getAtom(x);
                        status = 18;
                        continue;
                    }
                    throw new MolFormatException("Extended Feature import error.\nCould not set special bond to atom " + x);
                }
                if (status == 18) {
                    MolBond b = m.getBond(x = CxsmilesImport.recalculateBondIndexIfReaction(x, eR, eP, eA));
                    if (b != null && fromAtom != null) {
                        b.setType(bondType);
                        if (b.getAtom1() != fromAtom) {
                            b.swap();
                        }
                        status = 17;
                        continue;
                    }
                    throw new MolFormatException("Extended Feature import error.\nCould not set special bond " + x);
                }
                if (status == 19) {
                    if (x >= 0 && x < ac) {
                        x = CxsmilesImport.recalculateAtomIndexIfReaction(x, nR, nP, nA);
                        fromAtom = m.getAtom(x);
                        status = 20;
                        continue;
                    }
                    throw new MolFormatException("Extended Feature import error.\nCould not set Link Node " + x);
                }
                if (status == 20) {
                    if (x >= 0) {
                        fromAtom.setMinRepetitions(x);
                        status = 21;
                        continue;
                    }
                    throw new MolFormatException("Extended Feature import error.\nLink Node minimum repetition " + x);
                }
                if (status == 21) {
                    if (x >= 0) {
                        fromAtom.setMaxRepetitions(x);
                        if (line.charAt(i + 1) != '.') {
                            fromAtom.setLinkNodeOuterAtom(0, 0);
                            fromAtom.setLinkNodeOuterAtom(1, 1);
                            status = 19;
                            continue;
                        }
                        status = 22;
                        continue;
                    }
                    throw new MolFormatException("Extended Feature import error.\nLink Node maximum repetition " + x);
                }
                if (status == 22) {
                    if (x >= 0) {
                        int lidx = fromAtom.getLigandIndex(m.getAtom(x));
                        fromAtom.setLinkNodeOuterAtom(0, lidx);
                    }
                    status = 23;
                    continue;
                }
                if (status == 23) {
                    if (x >= 0) {
                        int lidx = fromAtom.getLigandIndex(m.getAtom(x));
                        fromAtom.setLinkNodeOuterAtom(1, lidx);
                    }
                    status = 19;
                    continue;
                }
                if (status == 24) {
                    if (x < 0 || x >= ac) {
                        throw new MolFormatException("Extended Feature import error.\nCould not set implicit lone pair to the atom " + x);
                    }
                    fromAtom = m.getAtom(x);
                    status = 25;
                    continue;
                }
                if (status == 25) {
                    if (x <= 0) {
                        throw new MolFormatException("Extended Feature import error.\nCould not set implicit lone pair value to " + x);
                    }
                    fromAtom.setElectronProp(x);
                    status = 24;
                    continue;
                }
                if (status == 26) {
                    if (x >= 0 && x < ac) {
                        x = CxsmilesImport.recalculateAtomIndexIfReaction(x, nR, nP, nA);
                        MolAtom a = m.getAtom(x);
                        a.setRadical(0);
                        if (grp == 1 || grp == 3) {
                            MolAtom ap = new MolAtom(138);
                            ap.setRgroupAttachmentPointOrder(1);
                            MolBond b = new MolBond(a, ap, 1);
                            m.add(ap);
                            m.add(b);
                        }
                        if (grp != 2 && grp != 3) continue;
                        MolAtom ap = new MolAtom(138);
                        ap.setRgroupAttachmentPointOrder(2);
                        MolBond b = new MolBond(a, ap, 1);
                        m.add(ap);
                        m.add(b);
                        continue;
                    }
                    throw new MolFormatException("Extended Feature import error.\nCould not set attachment point to " + x);
                }
                if (status == 31) {
                    if (x < 0 || x >= ac) {
                        throw new MolFormatException("Extended Feature import error. Bicyclo stereo descriptor setting failure");
                    }
                    x = CxsmilesImport.recalculateAtomIndexIfReaction(x, nR, nP, nA);
                    atom_BS = m.getAtom(x);
                    status = 32;
                    continue;
                }
                if (status == 32) {
                    if (x < 0 || x >= ac) {
                        throw new MolFormatException("Extended Feature import error. Bicyclo stereo descriptor setting failure");
                    }
                    x = CxsmilesImport.recalculateAtomIndexIfReaction(x, nR, nP, nA);
                    conn_BS = m.getAtom(x);
                    status = 33;
                    continue;
                }
                if (status == 33) {
                    if (x >= 0 && x < ac) {
                        x = CxsmilesImport.recalculateAtomIndexIfReaction(x, nR, nP, nA);
                        if (ring1 == null) {
                            ring1 = new IntVector();
                        }
                        ring1.add(x);
                        continue;
                    }
                    throw new MolFormatException("Extended Feature import error. Bicyclo stereo descriptor setting failure");
                }
                if (status == 34) {
                    if (x >= 0 && x < ac) {
                        x = CxsmilesImport.recalculateAtomIndexIfReaction(x, nR, nP, nA);
                        if (ring2 == null) {
                            ring2 = new IntVector();
                        }
                        ring2.add(x);
                        continue;
                    }
                    throw new MolFormatException("Extended Feature import error. Bicyclo stereo descriptor setting failure");
                }
                if (status == 36) {
                    if (line.charAt(++i) != '=') {
                        throw new MolFormatException("Invalid string representation in RGMolecule index information: missing '='");
                    }
                    rgIndex = x;
                    status = 35;
                    continue;
                }
                if (status == 37) {
                    if (line.charAt(++i) != ':') {
                        throw new MolFormatException("Invalid string representation in ligand order: missing ':'");
                    }
                    x = CxsmilesImport.recalculateAtomIndexIfReaction(x, nR, nP, nA);
                    ligandOrderCenter = m.getAtom(x);
                    ligandOrder = new IntVector();
                    status = 38;
                    continue;
                }
                if (status != 38) continue;
                x = CxsmilesImport.recalculateAtomIndexIfReaction(x, nR, nP, nA);
                ligandOrder.add(x);
                continue;
            }
            if (c == '$') {
                boolean value = false;
                StringBuffer strb = new StringBuffer();
                if (i + 4 < last && line.charAt(i + 1) == '_' && line.charAt(i + 2) == 'A' && line.charAt(i + 3) == 'V' && line.charAt(i + 4) == ':') {
                    value = true;
                    i += 4;
                }
                x = 0;
                ++i;
                while (i < last) {
                    strb.setLength(0);
                    i = CxsmilesImport.parseLinetoString(line, i, strb, null, ";$|");
                    if (strb.length() != 0) {
                        CxsmilesImport.setAliasString(m, nR, nA, nP, x, value, strb.toString());
                    }
                    if ((c = line.charAt(i)) == ';') {
                        ++x;
                    } else {
                        if (c == '$') continue block0;
                        if (c == '|') {
                            this.postProcess(m, dim, up_down_restored);
                            return i;
                        }
                        throw new MolFormatException("Extended Feature import error. Definition end missing.");
                    }
                    ++i;
                }
                continue;
            }
            if (c == '(') {
                x = 0;
                ++i;
                while (i < last) {
                    c = line.charAt(i);
                    if (c == ';') {
                        ++x;
                        ++i;
                        continue;
                    }
                    if (c == ')') break;
                    if (c == '|' || c == ' ' || c == '\t') {
                        this.postProcess(m, dim, up_down_restored);
                        return i;
                    }
                    int coordStart = i;
                    while (i < last && c != ')' && c != ';') {
                        c = line.charAt(++i);
                    }
                    String coords = line.substring(coordStart, i);
                    int l = coords.length();
                    int xr = CxsmilesImport.recalculateAtomIndexIfReaction(x, nR, nP, nA);
                    MolAtom a = m.getAtom(xr);
                    if (l == 0) {
                        a.setXYZ(0.0, 0.0, 0.0);
                        continue;
                    }
                    double[] val = new double[3];
                    int cStart = coordStart;
                    int n = 0;
                    for (int j = coordStart; j < i; ++j) {
                        String coord;
                        c = line.charAt(j);
                        if (n < 2 && c == ',') {
                            coord = line.substring(cStart, j);
                            val[n++] = coord.length() == 0 ? 0.0 : Double.valueOf(coord);
                            cStart = j + 1;
                            continue;
                        }
                        if (n != 2) continue;
                        coord = line.substring(cStart, i);
                        val[n++] = coord.length() == 0 ? 0.0 : Double.valueOf(coord);
                    }
                    a.setXYZ(val[0], val[1], val[2]);
                    if (dim == 0) {
                        if (val[2] != 0.0) {
                            dim = 3;
                            continue;
                        }
                        if (val[1] == 0.0) continue;
                        dim = 2;
                        continue;
                    }
                    if (dim != 2 || val[2] == 0.0) continue;
                    dim = 3;
                }
                if (dim <= 0 || rxn == null) continue;
                rxn.setReactionArrow();
                continue;
            }
            if (c == '|' || c == ' ' || c == '\t') {
                if (status == 34) {
                    BicycloStereoDescriptor d = CxsmilesImport.createBicycloSD(atom_BS, conn_BS, value_BS, ring1, ring2, m);
                    atom_BS.setBicycloStereo(BicycloStereoRecognizer.addStereoDescriptor(d, atom_BS.getBicycloStereo()));
                    atom_BS = null;
                    conn_BS = null;
                    ring1.clear();
                    ring2.clear();
                    break;
                }
                if (status != 38) break;
                for (int j = 0; j < ligandOrder.size(); ++j) {
                    ligandOrderCenter.setLigandOrder(j + 1, m.getAtom(ligandOrder.get(j)));
                }
                break;
            }
            if (c == ',' || c == ':') {
                if (status == 6) {
                    status = 5;
                    continue;
                }
                if (status == 33) {
                    if (ring1 == null || ring1.size() == 0) continue;
                    status = 34;
                    continue;
                }
                if (status == 34) {
                    BicycloStereoDescriptor d = CxsmilesImport.createBicycloSD(atom_BS, conn_BS, value_BS, ring1, ring2, m);
                    atom_BS.setBicycloStereo(BicycloStereoRecognizer.addStereoDescriptor(d, atom_BS.getBicycloStereo()));
                    atom_BS = null;
                    conn_BS = null;
                    ring1.clear();
                    ring2.clear();
                    status = 31;
                    continue;
                }
                if (status != 38) continue;
                for (int j = 0; j < ligandOrder.size(); ++j) {
                    ligandOrderCenter.setLigandOrder(j + 1, m.getAtom(ligandOrder.get(j)));
                }
                status = 37;
                continue;
            }
            if (c == '.') continue;
            throw new MolFormatException(c + ": unknown ChemAxon Extended " + "SMILES feature");
        }
        this.postProcess(m, dim, up_down_restored);
        return i;
    }

    private static final void setAliasString(Molecule m, int nR, int nA, int nP, int x, boolean value, String alias) throws MolFormatException {
        int l = alias.length();
        int xr = CxsmilesImport.recalculateAtomIndexIfReaction(x, nR, nP, nA);
        if (xr >= m.getAtomCount()) {
            throw new MolFormatException("Extended Feature import error. \nCould not set alias string to the " + xr + "th atom. No such atom.");
        }
        MolAtom a = m.getAtom(xr);
        if (!value && alias.charAt(l - 1) == 'p' && alias.charAt(l - 2) == '_') {
            a.setAtno(136);
            a.setAliasstr(alias.substring(0, l - 2));
        } else if (!value && alias.charAt(l - 1) == 'e' && alias.charAt(l - 2) == '_') {
            if (alias.subSequence(0, l - 2).equals(CxsConstants.SpecialAtoms.Q_ATOM.getSymbol())) {
                a.setAtno(132);
            }
            if (alias.subSequence(0, l - 2).equals(CxsConstants.SpecialAtoms.STAR_ATOM.getSymbol())) {
                a.setAtno(133);
            }
        } else if (!value && alias.charAt(0) == '_' && alias.charAt(1) == 'R') {
            char n;
            int rgidx = 0;
            for (int z = 2; z < l && (n = alias.charAt(z)) <= '9' && n >= '0'; ++z) {
                rgidx = 10 * rgidx + (n - 48);
            }
            if (a.getAtno() == 131) {
                String qstr = a.getQueryString();
                a.setAtno(134);
                a.setRgroup(rgidx);
                if (qstr != null && qstr.equals("[$([#1,*])]")) {
                    a.setQueryString(null);
                }
            }
        } else if (!value && alias.charAt(0) == '_' && alias.charAt(1) == 'A' && alias.charAt(2) == 'P') {
            char n;
            int order = 0;
            for (int z = 3; z < l && (n = alias.charAt(z)) <= '9' && n >= '0'; ++z) {
                order = 10 * order + (n - 48);
            }
            a.setQueryString(null);
            a.setAtno(138);
            a.setRgroupAttachmentPointOrder(order);
        } else if (value) {
            a.setExtraLabel(alias);
        } else {
            a.setAliasstr(alias);
        }
    }

    private Molecule readRGroup(String rgroupString) throws IOException {
        CxsmilesImport importer = new CxsmilesImport(this);
        Molecule result = importer.createMol();
        importer.readMol(rgroupString, result);
        return result instanceof RgMolecule ? ((RgMolecule)result).getRoot() : result;
    }

    private static BicycloStereoDescriptor createBicycloSD(MolAtom atom_BS, MolAtom conn_BS, int value_BS, IntVector ring1, IntVector ring2, Molecule m) {
        MolAtom[] bridge1 = new MolAtom[ring1.size()];
        for (int j = 0; j < bridge1.length; ++j) {
            bridge1[j] = m.getAtom(ring1.get(j));
        }
        MolAtom[] bridge2 = new MolAtom[ring2.size()];
        for (int j = 0; j < bridge2.length; ++j) {
            bridge2[j] = m.getAtom(ring2.get(j));
        }
        BicycloStereoDescriptor d = new BicycloStereoDescriptor(conn_BS, value_BS, bridge1, bridge2);
        return d;
    }

    static final Molecule getFragment(RxnMolecule rxn, int x, boolean remove) {
        int r = rxn.getReactantCount();
        int a = rxn.getAgentCount();
        if (x < r) {
            if (remove) {
                return rxn.removeComponent(0, x);
            }
            return rxn.getReactant(x);
        }
        if (x < r + a) {
            if (remove) {
                return rxn.removeComponent(2, x - r);
            }
            return rxn.getAgent(x - r);
        }
        if (remove) {
            return rxn.removeComponent(1, x - r - a);
        }
        return rxn.getProduct(x - r - a);
    }

    final boolean postProcess(Molecule m, int dim, boolean up_down_bond) {
        m.setDim(dim);
        this.processMulticenterSg(m);
        if (dim > 0) {
            int bc = m.getBondCount();
            for (int i = 0; i < bc; ++i) {
                MolBond b = m.getBond(i);
                if (b.getType() != 2 || m.canBeCT(m.indexOf(b.getAtom1()), m.indexOf(b.getAtom2()))) continue;
                b.setFlags(0, 448);
            }
        }
        if (!up_down_bond && dim == 2) {
            int ac = m.getAtomCount();
            int[] parity = new int[ac];
            for (int i = 0; i < ac; ++i) {
                parity[i] = m.getAtom(i).getFlags() & 7;
            }
            return !m.setParity(parity);
        }
        return true;
    }

    private void processMulticenterSg(Molecule m) {
        if (m instanceof RgMolecule && this.multicenterSgroups != null) {
            RgMolecule rgmol = (RgMolecule)m;
            RxnMolecule rxn = null;
            Set<MolAtom> keys = this.multicenterSgroups.keySet();
            for (MolAtom sgCenter : keys) {
                Molecule parentCenter = (Molecule)sgCenter.getParent();
                LinkedList<MolAtom> sgAtoms = this.multicenterSgroups.get(sgCenter);
                for (MolAtom a : sgAtoms) {
                    MoleculeGraph p = a.getParent();
                    CxsmilesImport.moveAllAtoms(parentCenter, p);
                }
                MulticenterSgroup msg = new MulticenterSgroup(parentCenter);
                msg.setCentralAtom(sgCenter);
                for (MolAtom a : sgAtoms) {
                    msg.add(a);
                }
                parentCenter.addSgroup(msg, true);
            }
            Molecule root = rgmol.getRoot();
            if (root instanceof RxnMolecule) {
                rxn = (RxnMolecule)root;
                rxn.removeEmptyComponents();
            }
        }
    }

    private static void moveAllAtoms(MoleculeGraph to, MoleculeGraph p) {
        MolAtom[] atoms;
        MolBond[] bonds;
        if (to == p) {
            return;
        }
        for (MolBond b : bonds = p.getBondArray()) {
            if (b.getParent() == to) continue;
            to.add(b);
        }
        for (MolAtom a : atoms = p.getAtomArray()) {
            if (a.getParent() == to) continue;
            to.add(a);
        }
        p.removeAll();
    }

    static final int recalculateAtomIndexIfReaction(int idx, int nR, int nP, int nA) {
        if (idx < nR) {
            return idx;
        }
        if (idx < nA + nR) {
            return idx + nP;
        }
        return idx - nA;
    }

    static final int recalculateBondIndexIfReaction(int bidx, int eR, int eP, int eA) {
        if (bidx < eR) {
            return bidx;
        }
        if (bidx < eA + eR) {
            return bidx + eP;
        }
        return bidx - eA;
    }

    static final RxnMolecule getRxnMolecule(Molecule m) {
        Molecule r;
        RxnMolecule rxn = null;
        if (m instanceof RxnMolecule) {
            rxn = (RxnMolecule)m;
        } else if (m instanceof RgMolecule && (r = ((RgMolecule)m).getRoot()) instanceof RxnMolecule) {
            rxn = (RxnMolecule)r;
        }
        return rxn;
    }

    static final int getComponentNodeCount(RxnMolecule rxn, int component) {
        int n;
        block5: {
            block6: {
                block4: {
                    if (rxn == null) {
                        return 0;
                    }
                    n = 0;
                    if (component != 0) break block4;
                    for (int i = 0; i < rxn.getReactantCount(); ++i) {
                        n += rxn.getReactant(i).getAtomCount();
                    }
                    break block5;
                }
                if (component != 1) break block6;
                for (int i = 0; i < rxn.getProductCount(); ++i) {
                    n += rxn.getProduct(i).getAtomCount();
                }
                break block5;
            }
            if (component != 2) break block5;
            for (int i = 0; i < rxn.getAgentCount(); ++i) {
                n += rxn.getAgent(i).getAtomCount();
            }
        }
        return n;
    }

    static final int getComponentEdgeCount(RxnMolecule rxn, int component) {
        int n;
        block5: {
            block6: {
                block4: {
                    if (rxn == null) {
                        return 0;
                    }
                    n = 0;
                    if (component != 0) break block4;
                    for (int i = 0; i < rxn.getReactantCount(); ++i) {
                        n += rxn.getReactant(i).getBondCount();
                    }
                    break block5;
                }
                if (component != 1) break block6;
                for (int i = 0; i < rxn.getProductCount(); ++i) {
                    n += rxn.getProduct(i).getBondCount();
                }
                break block5;
            }
            if (component != 2) break block5;
            for (int i = 0; i < rxn.getAgentCount(); ++i) {
                n += rxn.getAgent(i).getBondCount();
            }
        }
        return n;
    }

    static final int readDataSgroup(String line, int startIdx, Molecule m, int nR, int nP, int nA) throws IOException {
        DataSgroup sg = new DataSgroup(m);
        char c = line.charAt(startIdx);
        int last = line.length();
        int i = 0;
        for (i = startIdx; i < last; ++i) {
            c = line.charAt(i);
            if (c >= '0' && c <= '9') {
                int x = 0;
                while (i < last) {
                    c = line.charAt(i);
                    if (c < '0' || c > '9') {
                        --i;
                        break;
                    }
                    x = 10 * x + (c - 48);
                    ++i;
                }
                x = CxsmilesImport.recalculateAtomIndexIfReaction(x, nR, nP, nA);
                MolAtom a = m.getAtom(x);
                sg.add(a);
                m.setSgroupParent(a, sg, true);
                continue;
            }
            if (c == ':') break;
            if (c != '|') continue;
            return i;
        }
        ++i;
        StringBuffer strb = new StringBuffer();
        try {
            i = CxsmilesImport.parseLinetoString(line, i, strb, stepCharDataSgroup, separatorDataSgroup);
        }
        catch (Exception e) {
            throw new MolFormatException("Invalid field name in DataSgroup");
        }
        sg.setFieldName(strb.toString());
        strb.setLength(0);
        try {
            i = CxsmilesImport.parseLinetoString(line, i, strb, stepCharDataSgroup, separatorDataSgroup);
        }
        catch (Exception e) {
            throw new MolFormatException("Invalid data value in DataSgroup");
        }
        sg.setData(strb.toString());
        strb.setLength(0);
        try {
            i = CxsmilesImport.parseLinetoString(line, i, strb, stepCharDataSgroup, separatorDataSgroup);
        }
        catch (Exception e) {
            throw new MolFormatException("Invalid query operator in DataSgroup");
        }
        sg.setQueryOp(strb.toString());
        strb.setLength(0);
        try {
            i = CxsmilesImport.parseLinetoString(line, i, strb, stepCharDataSgroup, separatorDataSgroup);
        }
        catch (Exception e) {
            throw new MolFormatException("Invalid unit in DataSgroup");
        }
        sg.setUnits(strb.toString());
        strb.setLength(0);
        try {
            i = CxsmilesImport.parseLinetoString(line, i, strb, stepCharDataSgroup, separatorDataSgroup);
        }
        catch (Exception e) {
            throw new MolFormatException("Invalid tag in DataSgroup");
        }
        if (strb.length() == 1) {
            sg.setTag(strb.charAt(0));
        }
        if ((c = line.charAt(i)) == '(') {
            int cStart = ++i;
            while (i < last && c != ')') {
                c = line.charAt(++i);
            }
            int cEnd = ++i;
            double[] val = new double[2];
            int n = 0;
            for (i = cStart; i < cEnd; ++i) {
                c = line.charAt(i);
                if (c != ',' && i != cEnd - 1) continue;
                String coord = line.substring(cStart, i);
                val[n++] = coord.length() == 0 ? 0.0 : Double.valueOf(coord);
                cStart = i + 1;
            }
            if (n == 1 && val[0] == -1.0) {
                sg.setDataDetached(false);
            } else if (n == 2) {
                sg.setAbsoluteXY(val[0], val[1]);
            }
        }
        return i;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static final int parseLinetoString(String line, int i, StringBuffer strb, String stepForwardChars, String separatorChars) throws IOException {
        char c = '\u0000';
        int last = line.length();
        while (i < last) {
            c = line.charAt(i);
            if (c == '&') {
                if ((c = line.charAt(++i)) != '#') throw new MolFormatException();
                if ((c = line.charAt(++i)) >= '0' && c <= '9') {
                    char x = '\u0000';
                    while (i < last) {
                        c = line.charAt(i);
                        if (c < '0' || c > '9') {
                            --i;
                            break;
                        }
                        x = (char)(10 * x + (c - 48));
                        ++i;
                    }
                    strb.append(x);
                    ++i;
                }
                if ((c = line.charAt(i)) != ';') {
                    throw new MolFormatException();
                }
            } else {
                if (stepForwardChars != null && stepForwardChars.indexOf(c) >= 0) {
                    ++i;
                    return i;
                }
                if (separatorChars != null && separatorChars.indexOf(c) >= 0) return i;
                strb.append(c);
            }
            ++i;
        }
        return i;
    }
}

