/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.smiles;

import chemaxon.marvin.io.formats.SingleLineRecordReader;
import chemaxon.struc.MPropertyContainer;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;

public final class SMILESRecordReader
extends SingleLineRecordReader {
    public SMILESRecordReader(InputStream istr, String opts) throws IOException {
        super(istr, opts);
        if (opts != null && opts.length() != 0) {
            ArrayList<String> fields = new ArrayList<String>();
            for (int i = 0; i < opts.length(); ++i) {
                int k;
                char c = opts.charAt(i);
                if (c != 'f') continue;
                if ((k = opts.indexOf(44, ++i)) < 0) {
                    k = opts.length();
                }
                if (k <= i) continue;
                String s = opts.substring(i, k);
                fields.add(s);
                i = k;
            }
            if (fields.size() != 0) {
                this.fieldNames = new String[fields.size()];
                fields.toArray(this.fieldNames);
            }
        }
    }

    @Override
    protected String[] parseFieldNamesFromHeaderRow(String line) {
        String lline;
        if (line != null && ((lline = line.toLowerCase()).startsWith("smiles") || lline.startsWith("#smiles") || lline.startsWith("smarts") || lline.startsWith("#smarts") || lline.startsWith("#cxsmiles") || lline.startsWith("#cxsmarts"))) {
            StringTokenizer st = new StringTokenizer(line, "\t");
            int n = st.countTokens() - 1;
            st.nextToken();
            String[] fieldNames = new String[n];
            for (int i = 0; i < n; ++i) {
                fieldNames[i] = st.nextToken().trim();
            }
            return fieldNames;
        }
        return null;
    }

    @Override
    protected String parseFields(String line, MPropertyContainer pc) {
        int starti = -1;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c != ' ' && c != '\t') continue;
            starti = i;
            break;
        }
        if (starti >= 0) {
            int i;
            if (starti + 1 < line.length() && line.charAt(starti + 1) == '|') {
                boolean end_found = false;
                for (i = starti + 2; i < line.length() && !end_found; ++i) {
                    char c = line.charAt(i);
                    if (c == '|') {
                        starti = i + 1;
                        end_found = true;
                        continue;
                    }
                    if (c != '{') continue;
                    while (i < line.length() && line.charAt(i) != '}') {
                        ++i;
                    }
                }
                if (!end_found) {
                    starti = line.length();
                }
            }
            String[] fields = this.readFields(line, starti);
            for (i = 0; i < fields.length; ++i) {
                String name = this.fieldNames != null && i < this.fieldNames.length ? this.fieldNames[i] : "field_" + i;
                pc.setString(name, fields[i].length() == 0 ? null : fields[i]);
            }
            return line.substring(0, starti);
        }
        return line;
    }

    private String[] readFields(String line, int starti) {
        ArrayList<String> v = new ArrayList<String>();
        block0: for (int i = starti; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c != ' ' && c != '\t') {
                int j;
                if (c == '\"') {
                    for (j = ++i + 1; j < line.length(); ++j) {
                        c = line.charAt(j);
                        if (c == '\\' && j + 1 < line.length()) {
                            c = line.charAt(j + 1);
                            if (c == '\\' || c == '\"') {
                                line = line.substring(0, j) + line.substring(j + 1);
                                continue;
                            }
                            if (c != 'n' || j + 2 >= line.length()) continue;
                            line = line.substring(0, j) + "\n" + line.substring(j + 2);
                            continue;
                        }
                        if (c != '\"') continue;
                        v.add(line.substring(i, j));
                        i = j;
                        continue block0;
                    }
                    v.add("");
                    continue;
                }
                if (c == '|' && v.size() == 0) continue;
                for (j = i + 1; j <= line.length(); ++j) {
                    char c2 = c = j == line.length() ? (char)'\u0000' : line.charAt(j);
                    if (c != '\t' && c != '\r' && c != '\n' && c != '\u0000') continue;
                    v.add(line.substring(i, j));
                    i = j - 1;
                    continue block0;
                }
                continue;
            }
            if (c != '\t' || i <= 0 || line.charAt(i - 1) != '\t') continue;
            v.add("");
        }
        String[] fields = new String[v.size()];
        v.toArray(fields);
        return fields;
    }
}

