/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.smiles;

import chemaxon.formats.MFileFormat;
import chemaxon.marvin.modules.smarts.ParseException;
import chemaxon.marvin.modules.smarts.SimpleNode;
import chemaxon.marvin.modules.smarts.SmartsAtomTreeParser;
import chemaxon.marvin.modules.smarts.SmartsAtomTreeParserTreeConstants;
import chemaxon.marvin.modules.smarts.TokenMgrError;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.struc.ExtraAtomProperties;
import chemaxon.struc.MolAtom;
import chemaxon.struc.PeriodicSystem;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Vector;

public class SmartsAtomQuerifier
implements SmartsAtomTreeParserTreeConstants {
    private int[] listArray;
    private String[] listAtoms;
    private int listArrayLength;
    private int listAliphaticFlagCandidate = -1;
    private static final int MAX_NOTLISTARRAY_LENGTH = 256;
    private int[] initValues;
    private String initAliasStr;
    private static final int UNDEF = -10000;
    private static final int INITIALIZEDLENGTH = 13;
    private static final int I_ATOMSYMBOL = 0;
    private static final int I_CHARGE = 1;
    private static final int I_MAP = 2;
    private static final int I_MASS = 3;
    private static final int I_A = 4;
    private static final int I_HCAPITAL = 5;
    private static final int I_RCAPITAL = 6;
    private static final int I_RSMALL = 7;
    private static final int I_V = 8;
    private static final int I_X = 9;
    private static final int I_D = 10;
    private static final int I_HSMALL = 11;
    private static final int I_ALIASSTRING = 12;
    private boolean marvinCompMode = true;
    private String fullQueryString = null;
    private static String[] bracketlessSymbols = new String[]{"*", "B", "b", "C", "c", "N", "n", "O", "o", "P", "p", "S", "s", "F", "f", "Cl", "cl", "Br", "br", "I", "i"};
    private static String[] bracketlessQueries = new String[]{"a", "A", "r", "R", "H", "h"};

    public boolean isMarvinCompMode() {
        return this.marvinCompMode;
    }

    private static String querify(SmartsAtomQuerifier smartsAtomQuerifier, MolAtom ma, String qs) throws ParseException {
        if (qs == null) {
            return null;
        }
        StringReader sr = new StringReader(qs);
        SmartsAtomTreeParser parser = new SmartsAtomTreeParser(sr);
        SimpleNode node = parser.parseSmartsAtomExpression();
        smartsAtomQuerifier.fullQueryString = qs;
        smartsAtomQuerifier.clearInitValues();
        smartsAtomQuerifier.processNode(node, ma);
        smartsAtomQuerifier.initialize(ma);
        String newQS = node.toSmartsAtom();
        return newQS;
    }

    private void processNode(SimpleNode node, MolAtom ma) throws ParseException {
        this.transformAmbiguousHydrogens(node, false);
        this.transformGenericAtoms(node);
        this.processAtomSymbol(node, ma);
        this.processAtomNotList(node, ma);
        this.processQueryFeatures(node, ma);
        this.processAa(node, ma);
        this.processOrExpressions(node, ma);
        this.processCc(node, ma);
    }

    private void processCc(SimpleNode node, MolAtom ma) {
        if (this.isInitialized(0)) {
            return;
        }
        switch (node.getId()) {
            case 2: {
                boolean isSameAtomType = true;
                int atomType = -1;
                boolean hadArom = false;
                boolean hadAliph = false;
                for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                    int childAtomType;
                    SimpleNode child = (SimpleNode)node.jjtGetChild(i);
                    if (child.getId() != 6) {
                        isSameAtomType = false;
                        break;
                    }
                    String value = child.getValue();
                    if ("*".equals(value)) {
                        childAtomType = 131;
                    } else if (value.charAt(0) == '#') {
                        hadArom = true;
                        hadAliph = true;
                        childAtomType = Integer.parseInt(value.substring(1));
                    } else {
                        childAtomType = PeriodicSystem.getAtomicNumber(value);
                        if (Character.isUpperCase(value.charAt(0))) {
                            hadAliph = true;
                        } else if (Character.isLowerCase(value.charAt(0))) {
                            hadArom = true;
                        }
                    }
                    if (atomType == -1) {
                        atomType = childAtomType;
                        continue;
                    }
                    if (atomType == childAtomType) continue;
                    isSameAtomType = false;
                    break;
                }
                if (!isSameAtomType) break;
                this.recordInitialization(0, atomType);
                boolean wasSet = false;
                if (hadArom && hadAliph) {
                    wasSet = this.recordInitialization(4, 3);
                } else if (hadArom) {
                    wasSet = this.recordInitialization(4, 1);
                } else if (hadAliph) {
                    wasSet = this.recordInitialization(4, 2);
                }
                if (!wasSet) break;
                node.setId(3);
                break;
            }
            case 1: {
                for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                    SimpleNode child = (SimpleNode)node.jjtGetChild(i);
                    this.processCc(child, ma);
                }
                break;
            }
        }
    }

    private void processOrExpressions(SimpleNode node, MolAtom ma) throws ParseException {
        if (node.getId() == 1) {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                SimpleNode child = (SimpleNode)node.jjtGetChild(i);
                this.processOrExpressions(child, ma);
            }
        } else if (node.getId() == 2) {
            this.processOrBacktrack(node, ma);
        }
    }

    private void processOrBacktrack(SimpleNode node, MolAtom ma) throws ParseException {
        SimpleNode[] gCs = new SimpleNode[node.jjtGetNumChildren()];
        int[] gCi = new int[gCs.length];
        int[] gCn = new int[gCi.length];
        for (int i = 0; i < gCs.length; ++i) {
            gCi[i] = 0;
            SimpleNode child = (SimpleNode)node.jjtGetChild(i);
            gCn[i] = child.getId() == 1 ? child.jjtGetNumChildren() : 1;
            gCs[i] = node.getANDGrandChild(i, 0);
        }
        boolean overflow = false;
        while (!overflow) {
            int stepPos;
            int i;
            boolean areAllEqual = true;
            for (i = 0; i < gCs.length - 1; ++i) {
                if (gCs[i].equals(gCs[i + 1])) continue;
                areAllEqual = false;
                break;
            }
            if (areAllEqual) {
                this.processNode(gCs[0], ma);
                if (gCs[0].getId() == 3) {
                    for (i = 0; i < gCs.length; ++i) {
                        gCs[i].setId(3);
                    }
                }
            }
            int n = stepPos = gCs.length - 1;
            gCi[n] = gCi[n] + 1;
            while (stepPos >= 0 && gCi[stepPos] == gCn[stepPos]) {
                gCi[stepPos] = 0;
                gCs[stepPos] = node.getANDGrandChild(stepPos, 0);
                if (--stepPos < 0) continue;
                int n2 = stepPos;
                gCi[n2] = gCi[n2] + 1;
            }
            overflow = stepPos == -1;
            if (overflow) continue;
            gCs[stepPos] = node.getANDGrandChild(stepPos, gCi[stepPos]);
        }
    }

    private void processAtomNotList(SimpleNode node, MolAtom ma) {
        if (this.isInitialized(0)) {
            return;
        }
        this.listArrayLength = 0;
        this.collectNotListAtoms(node);
        if (this.listArrayLength != 0) {
            this.removeArrayDuplicates();
            if (this.listArrayLength == 2 && (this.listArray[0] == 1 && this.listArray[1] == 6 || this.listArray[0] == 6 && this.listArray[1] == 1)) {
                this.recordInitialization(0, 132);
            } else {
                this.recordInitialization(0, 129);
            }
        }
    }

    private void collectNotListAtoms(SimpleNode node) {
        block8: {
            block6: {
                SimpleNode child;
                block7: {
                    if (this.isInitialized(0)) {
                        return;
                    }
                    if (node.getId() != 4) break block6;
                    child = (SimpleNode)node.jjtGetChild(0);
                    if (child.getId() != 6) break block7;
                    String qAtom = child.getValue();
                    if (qAtom.charAt(0) == '#' && this.listArrayLength < 256) {
                        int qAtomNo = Integer.parseInt(qAtom.substring(1));
                        node.setId(3);
                        if (this.listArray == null) {
                            this.listArray = new int[256];
                        }
                        this.listArray[this.listArrayLength] = qAtomNo;
                        ++this.listArrayLength;
                    }
                    break block8;
                }
                if (!this.marvinCompMode || child.getId() != 5 || !"H".equals(child.getValue()) || this.listArrayLength >= 256) break block8;
                node.setId(3);
                this.printHWarning();
                if (this.listArray == null) {
                    this.listArray = new int[256];
                }
                this.listArray[this.listArrayLength] = 1;
                ++this.listArrayLength;
                break block8;
            }
            if (node.getId() == 1) {
                for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                    this.collectNotListAtoms((SimpleNode)node.jjtGetChild(i));
                }
            }
        }
    }

    private void collectGenericListAtoms(SimpleNode node) {
        if (this.isInitialized(0)) {
            return;
        }
        if (node.getId() == 4) {
            String qAtom;
            SimpleNode child = (SimpleNode)node.jjtGetChild(0);
            if (child.getId() == 6 && (qAtom = child.getValue()).charAt(0) == '#' && this.listArrayLength < 256) {
                if (this.listAtoms == null) {
                    this.listAtoms = new String[256];
                }
                this.listAtoms[this.listArrayLength] = "!" + child.getValue();
                ++this.listArrayLength;
            }
        } else if (node.getId() == 6) {
            if (this.listAtoms == null) {
                this.listAtoms = new String[256];
            }
            this.listAtoms[this.listArrayLength] = node.getValue();
            ++this.listArrayLength;
        } else if (node.getId() == 2) {
            for (int childIndex = 0; childIndex < node.jjtGetNumChildren(); ++childIndex) {
                this.collectGenericListAtoms((SimpleNode)node.jjtGetChild(childIndex));
            }
        }
    }

    private boolean collectGenericNotListAtoms(SimpleNode node) {
        if (this.isInitialized(0)) {
            return false;
        }
        if (node.getId() == 4) {
            SimpleNode child = (SimpleNode)node.jjtGetChild(0);
            if (child.getId() == 6) {
                String qAtom = child.getValue();
                if (qAtom.charAt(0) == '#' && this.listArrayLength < 256) {
                    int qAtomNo = Integer.parseInt(qAtom.substring(1));
                    if (this.listArray == null) {
                        this.listArray = new int[256];
                    }
                    this.listArray[this.listArrayLength] = qAtomNo;
                    ++this.listArrayLength;
                    return true;
                }
                this.listArray = null;
                this.listArrayLength = 0;
                return false;
            }
            if (this.marvinCompMode && child.getId() == 5 && "H".equals(child.getValue()) && this.listArrayLength < 256) {
                if (this.listArray == null) {
                    this.listArray = new int[256];
                }
                this.listArray[this.listArrayLength] = 1;
                ++this.listArrayLength;
                return true;
            }
        } else if (node.getId() == 1) {
            for (int i = 0; i < node.jjtGetNumChildren() && this.collectGenericNotListAtoms((SimpleNode)node.jjtGetChild(i)); ++i) {
                if (i != node.jjtGetNumChildren() - 1) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private void processQueryFeatures(SimpleNode node, MolAtom ma) throws ParseException {
        switch (node.getId()) {
            case 1: {
                for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                    this.processQueryFeatures((SimpleNode)node.jjtGetChild(i), ma);
                }
                break;
            }
            case 9: {
                int map = Integer.parseInt(node.getValue());
                if (map <= 0 || !this.recordInitialization(2, map)) break;
                node.setId(3);
                break;
            }
            case 5: {
                this.processQuery(node, ma);
                break;
            }
            case 8: {
                this.processRecursive(node, ma);
                break;
            }
        }
    }

    private void processRecursive(SimpleNode node, MolAtom ma) throws ParseException {
        String atomExpr = this.getFirstSmartsAtom(node.getValue());
        StringReader sr = new StringReader(atomExpr);
        SmartsAtomTreeParser parser = new SmartsAtomTreeParser(sr);
        SimpleNode nodeRec = parser.parseSmartsAtomExpression();
        this.processNode(nodeRec, ma);
    }

    private String getFirstSmartsAtom(String smartsExpr) {
        int i;
        int start;
        for (start = 0; smartsExpr.charAt(start) == '(' && start < smartsExpr.length(); ++start) {
        }
        String workBuffer = start > 0 && start < smartsExpr.length() ? smartsExpr.substring(start) : smartsExpr;
        if (workBuffer.startsWith("[")) {
            return workBuffer;
        }
        for (i = 0; i < bracketlessSymbols.length; ++i) {
            if (!workBuffer.startsWith(bracketlessSymbols[i])) continue;
            return "[" + bracketlessSymbols[i] + "]";
        }
        for (i = 0; i < bracketlessQueries.length; ++i) {
            if (!workBuffer.startsWith(bracketlessQueries[i])) continue;
            return "[" + bracketlessQueries[i] + "]";
        }
        return smartsExpr;
    }

    private void processQuery(SimpleNode node, MolAtom ma) {
        int sign = 1;
        String value = node.getValue();
        char label = value.charAt(0);
        switch (label) {
            case 'A': {
                this.recordInitialization(4, 2);
                node.setId(3);
                break;
            }
            case 'a': {
                this.recordInitialization(4, 1);
                node.setId(3);
                break;
            }
            case 'H': {
                if (this.marvinCompMode && "H".equals(value) && !this.isInitialized(0)) {
                    this.recordInitialization(0, 1);
                    node.setId(3);
                    this.printHWarning();
                    break;
                }
                int qHCount = node.getValue().length() == 1 ? 1 : Integer.parseInt(node.getValue().substring(1));
                this.recordInitialization(5, qHCount);
                node.setId(3);
                break;
            }
            case 'h': {
                int qHCount = node.getValue().length() == 1 ? 1 : Integer.parseInt(node.getValue().substring(1));
                this.recordInitialization(11, qHCount);
                node.setId(3);
                break;
            }
            case 'R': {
                if (node.getValue().length() == 1) {
                    this.recordInitialization(6, 256);
                } else {
                    int qRcount = Integer.parseInt(node.getValue().substring(1));
                    this.recordInitialization(6, qRcount);
                }
                node.setId(3);
                break;
            }
            case 'r': {
                if (node.getValue().length() == 1) {
                    this.recordInitialization(6, 256);
                } else {
                    int qRSize = Integer.parseInt(node.getValue().substring(1));
                    this.recordInitialization(7, qRSize);
                }
                node.setId(3);
                break;
            }
            case '-': {
                sign = -1;
            }
            case '+': {
                int qCharge = sign;
                if (node.getValue().length() != 1) {
                    qCharge = "+-".indexOf(node.getValue().charAt(1)) == -1 ? (qCharge *= Integer.parseInt(node.getValue().substring(1))) : (qCharge *= node.getValue().length());
                }
                if (qCharge == 0) break;
                this.recordInitialization(1, qCharge);
                node.setId(3);
                break;
            }
            case 'v': {
                int qV = node.getValue().length() == 1 ? 1 : Integer.parseInt(node.getValue().substring(1));
                this.recordInitialization(8, qV);
                node.setId(3);
                break;
            }
            case 'X': {
                int qX = node.getValue().length() == 1 ? 1 : Integer.parseInt(node.getValue().substring(1));
                this.recordInitialization(9, qX);
                node.setId(3);
                break;
            }
            case 'D': {
                int qD = node.getValue().length() == 1 ? 1 : Integer.parseInt(node.getValue().substring(1));
                this.recordInitialization(10, qD);
                node.setId(3);
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                int qMass = Integer.parseInt(node.getValue());
                this.recordInitialization(3, qMass);
                node.setId(3);
                break;
            }
        }
    }

    private void printHWarning() {
        System.err.println("WARNING: smarts import: ambiguous meaning of \"H\" in " + this.fullQueryString + ". \n" + "\"H\" is now interpreted as Hydrogen atom, not total H count!" + "\nTo avoid this warning message, please use \"H1\" for hydrogen count and" + "\n\"#1\" for H atom. Or to force H count in this situation, " + "please use import option \"d\".");
    }

    private void processAtomSymbol(SimpleNode node, MolAtom ma) {
        switch (node.getId()) {
            case 1: {
                for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                    this.processAtomSymbol((SimpleNode)node.jjtGetChild(i), ma);
                }
                break;
            }
            case 6: {
                this.processAtomSymbolNode(node, ma);
                break;
            }
            case 2: {
                this.processAtomList(node, ma);
                break;
            }
        }
    }

    private void processAtomSymbolNode(SimpleNode node, MolAtom ma) {
        int ar;
        int qAtomNo;
        String qAtom = node.getValue();
        if ("*".equals(qAtom)) {
            if (this.marvinCompMode && this.recordInitialization(0, 131)) {
                node.setId(3);
            }
            return;
        }
        if (qAtom.charAt(0) == '#') {
            qAtomNo = Integer.parseInt(qAtom.substring(1));
            ar = 3;
        } else {
            ar = Character.isLowerCase(qAtom.charAt(0)) ? 1 : 2;
            qAtomNo = PeriodicSystem.getAtomicNumber(qAtom);
        }
        if (qAtomNo <= 0) {
            return;
        }
        int set = 0;
        if (this.recordInitialization(0, qAtomNo) || this.initValues[0] == qAtomNo) {
            ++set;
        }
        if (this.recordInitialization(4, ar)) {
            ++set;
        }
        if (set == 2) {
            node.setId(3);
        }
    }

    private boolean processAtomList(SimpleNode node, MolAtom ma) {
        int[] list = this.getAtomList(node, ma);
        if (list == null) {
            return false;
        }
        int set = 0;
        if (list.length == 1) {
            if (this.recordInitialization(0, list[0])) {
                ++set;
            }
        } else if (this.recordInitialization(0, 128)) {
            this.listArray = list;
            this.listArrayLength = list.length;
            ++set;
        }
        if (this.recordInitialization(4, this.listAliphaticFlagCandidate)) {
            ++set;
        }
        if (set == 2) {
            node.setId(3);
        }
        return set > 0;
    }

    private int[] getAtomList(SimpleNode node, MolAtom ma) {
        int i;
        Vector<Integer> atoms = null;
        int nextAliphaticFlag = -1;
        int nextAtom = -1;
        boolean needHWarning = false;
        for (i = 0; i < node.jjtGetNumChildren(); ++i) {
            SimpleNode child = (SimpleNode)node.jjtGetChild(i);
            switch (child.getId()) {
                case 1: {
                    if (child.jjtGetNumChildren() != 2) {
                        return null;
                    }
                    SimpleNode gc1 = (SimpleNode)child.jjtGetChild(0);
                    SimpleNode gc2 = (SimpleNode)child.jjtGetChild(1);
                    if (gc1.getId() != 6) {
                        SimpleNode gct = gc1;
                        gc1 = gc2;
                        gc2 = gct;
                    }
                    if (gc1.getId() != 6 || !"#1".equals(gc1.getValue()) || gc2.getId() != 5) {
                        return null;
                    }
                    nextAtom = 1;
                    if ("a".equals(gc2.getValue())) {
                        nextAliphaticFlag = 1;
                        break;
                    }
                    if ("A".equals(gc2.getValue())) {
                        nextAliphaticFlag = 2;
                        break;
                    }
                    return null;
                }
                case 5: {
                    if (!"H".equals(child.getValue()) || !this.marvinCompMode) {
                        return null;
                    }
                    nextAtom = 1;
                    nextAliphaticFlag = 2;
                    needHWarning = true;
                    break;
                }
                case 6: {
                    String qAtom = child.getValue();
                    if ("*".equals(qAtom)) {
                        return null;
                    }
                    if (qAtom.charAt(0) == '#') {
                        if (qAtom.equals("#1")) {
                            nextAtom = 1;
                            nextAliphaticFlag = 100;
                            break;
                        }
                        nextAliphaticFlag = 3;
                        nextAtom = Integer.parseInt(qAtom.substring(1));
                        break;
                    }
                    if (Character.isLowerCase(qAtom.charAt(0))) {
                        nextAliphaticFlag = 1;
                        nextAtom = PeriodicSystem.getAtomicNumber(qAtom);
                        break;
                    }
                    nextAliphaticFlag = 2;
                    nextAtom = PeriodicSystem.getAtomicNumber(qAtom);
                    break;
                }
                default: {
                    return null;
                }
            }
            if (this.listAliphaticFlagCandidate == -1) {
                this.listAliphaticFlagCandidate = nextAliphaticFlag;
            } else if (this.listAliphaticFlagCandidate != nextAliphaticFlag) {
                if (this.listAliphaticFlagCandidate == 100 || nextAliphaticFlag == 100) {
                    if (this.listAliphaticFlagCandidate == 1 || nextAliphaticFlag == 1) {
                        return null;
                    }
                    this.listAliphaticFlagCandidate = Math.min(this.listAliphaticFlagCandidate, nextAliphaticFlag);
                } else {
                    return null;
                }
            }
            if (atoms == null) {
                atoms = new Vector<Integer>();
            }
            atoms.addElement(new Integer(nextAtom));
        }
        if (needHWarning) {
            this.printHWarning();
        }
        for (i = 0; i < atoms.size(); ++i) {
            Integer atomI = (Integer)atoms.elementAt(i);
            if (atoms.indexOf(atomI, i + 1) == -1) continue;
            atoms.removeElementAt(i);
            --i;
        }
        if (atoms != null) {
            int[] array = new int[atoms.size()];
            for (int i2 = 0; i2 < atoms.size(); ++i2) {
                array[i2] = (Integer)atoms.elementAt(i2);
            }
            return array;
        }
        return null;
    }

    private void processAa(SimpleNode node, MolAtom ma) {
        block3: {
            block2: {
                if (node.getId() != 2 || node.jjtGetNumChildren() != 2) break block2;
                SimpleNode ch1 = (SimpleNode)node.jjtGetChild(0);
                SimpleNode ch2 = (SimpleNode)node.jjtGetChild(1);
                if (ch1.getId() != 5 || ch2.getId() != 5) break block3;
                String value1 = ch1.getValue();
                String value2 = ch2.getValue();
                if ((!"a".equals(value1) || !"A".equals(value2)) && (!"a".equals(value2) || !"A".equals(value1))) break block3;
                node.setId(3);
                this.recordInitialization(4, 3);
                break block3;
            }
            if (node.getId() == 1) {
                for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                    this.processAa((SimpleNode)node.jjtGetChild(i), ma);
                }
            }
        }
    }

    private void transformGenericAtoms(SimpleNode node) {
        if (this.isInitialized(0)) {
            return;
        }
        switch (node.getId()) {
            case 1: {
                this.listArrayLength = 0;
                this.collectGenericNotListAtoms(node);
                this.removeArrayDuplicates();
                if (this.listArrayLength <= 0) break;
                Arrays.sort(this.listArray, 0, this.listArrayLength);
                StringBuffer sb = new StringBuffer();
                for (int atomIndex = 0; atomIndex < this.listArrayLength; ++atomIndex) {
                    sb.append("!#");
                    sb.append(this.listArray[atomIndex]);
                }
                String genericAtom = sb.toString();
                if (this.transformPseudoAtom(node, "M", "!#1!#2!#5!#6!#7!#8!#9!#10!#14!#15!#16!#17!#18!#33!#34!#35!#36!#52!#53!#54!#85!#86", genericAtom)) break;
                this.transformPseudoAtom(node, "MH", "!#2!#5!#6!#7!#8!#9!#10!#14!#15!#16!#17!#18!#33!#34!#35!#36!#52!#53!#54!#85!#86", genericAtom);
                break;
            }
            case 2: {
                this.listArrayLength = 0;
                this.collectGenericListAtoms(node);
                StringBuffer sb = new StringBuffer();
                for (int atomIndex = 0; atomIndex < this.listArrayLength; ++atomIndex) {
                    if (atomIndex > 0) {
                        sb.append(",");
                    }
                    sb.append(this.listAtoms[atomIndex]);
                }
                String genericAtom = sb.toString();
                if (this.transformPseudoAtom(node, "AH", "*,#1", genericAtom) || this.transformPseudoAtom(node, "QH", "#1,!#6", genericAtom)) break;
                this.transformPseudoAtom(node, "XH", "F,Cl,Br,I,#1", genericAtom);
                break;
            }
            default: {
                for (int childIndex = 0; childIndex < node.jjtGetNumChildren(); ++childIndex) {
                    this.transformGenericAtoms((SimpleNode)node.jjtGetChild(childIndex));
                }
            }
        }
    }

    private boolean transformPseudoAtom(SimpleNode node, String aliasStr, String aliasAtom, String genericAtom) {
        if (aliasAtom.equals(genericAtom)) {
            this.recordInitialization(0, 136);
            this.recordInitialization(4, 3);
            this.initAliasStr = aliasStr;
            node.setId(3);
            node.setValue(aliasStr);
            return true;
        }
        return false;
    }

    private boolean transformAmbiguousHydrogens(SimpleNode node, boolean atomFound) {
        if (node.getId() == 1) {
            for (int childIndex = 0; childIndex < node.jjtGetNumChildren(); ++childIndex) {
                SimpleNode childNode = (SimpleNode)node.jjtGetChild(childIndex);
                if ("H".equals(childNode.getValue())) {
                    this.transformHydrogen(childNode, atomFound);
                    continue;
                }
                atomFound = childNode.getId() == 6 ? true : this.transformAmbiguousHydrogens(childNode, atomFound);
            }
        } else if ("H".equals(node.getValue())) {
            this.transformHydrogen(node, atomFound);
        } else {
            for (int childIndex = 0; childIndex < node.jjtGetNumChildren(); ++childIndex) {
                this.transformAmbiguousHydrogens((SimpleNode)node.jjtGetChild(childIndex), atomFound);
            }
        }
        return atomFound;
    }

    private void transformHydrogen(SimpleNode node, boolean atomFound) {
        if (atomFound || !this.marvinCompMode) {
            node.setId(5);
            node.setValue("H1");
        } else {
            node.setId(6);
            node.setValue("#1");
        }
    }

    private static String query(SmartsAtomQuerifier smartsAtomQuerifier, MolAtom atom, String queryStr) {
        try {
            String result = SmartsAtomQuerifier.querify(smartsAtomQuerifier, atom, queryStr);
            return result;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Error in smarts atom expression '" + queryStr + "':\n" + e.getMessage());
        }
        catch (TokenMgrError e) {
            throw new IllegalArgumentException("Error in smarts atom expression '" + queryStr + "':\n" + e.getMessage());
        }
    }

    private void removeArrayDuplicates() {
        for (int i = 0; i < this.listArrayLength; ++i) {
            for (int j = i + 1; j < this.listArrayLength; ++j) {
                if (this.listArray[i] != this.listArray[j]) continue;
                System.arraycopy(this.listArray, j + 1, this.listArray, j, this.listArrayLength - j);
                --this.listArrayLength;
                --j;
            }
        }
    }

    private void clearInitValues() {
        this.initValues = new int[13];
        for (int i = 0; i < 13; ++i) {
            this.initValues[i] = -10000;
        }
    }

    private boolean isInitialized(String queryValue) {
        int i = this.getInitIndex(queryValue);
        if (i != -1) {
            return this.isInitialized(i);
        }
        return true;
    }

    private boolean isInitialized(int i) {
        if (i == 4) {
            return this.initValues[i] != -10000 && this.initValues[i] != 3;
        }
        return this.initValues[i] != -10000;
    }

    private boolean recordInitialization(int propertyIndex, int value) {
        if (this.initValues[propertyIndex] == -10000) {
            this.initValues[propertyIndex] = value;
            return true;
        }
        if (propertyIndex == 4) {
            if (this.initValues[4] == 3) {
                this.initValues[4] = value;
                return true;
            }
            if (value == 3) {
                return true;
            }
        } else if (propertyIndex == 0) {
            int oldValue = this.initValues[propertyIndex];
            if (oldValue == 131 && value != 1 && value != 129 && value != 128) {
                this.initValues[0] = value;
                return true;
            }
            if (value == 131 && oldValue != 1 && oldValue != 129 && oldValue != 128) {
                return true;
            }
        }
        return false;
    }

    private void initialize(MolAtom ma) {
        int an = this.initValues[0];
        if (an != -10000 && an != 131) {
            ma.setAtno(an);
            if (an == 128 || an == 129) {
                ma.setList(this.listArray, this.listArrayLength);
            } else if (an == 136) {
                ma.setAtno(136);
                ma.setAliasstr(this.initAliasStr);
            }
        }
        if (this.isInitialized(3)) {
            ma.setMassno(this.initValues[3]);
        }
        if (this.isInitialized(1)) {
            ma.setCharge(this.initValues[1]);
        }
        if (this.isInitialized(8)) {
            ma.setValenceProp(this.initValues[8]);
        }
        if (this.isInitialized(2)) {
            ma.setAtomMap(this.initValues[2]);
        }
        if (this.initValues[4] != -10000) {
            ma.setQueryAromaticity(this.initValues[4]);
        }
        this.setQProp(5, "H", ma);
        this.setQProp(11, "h", ma);
        this.setQProp(6, "R", ma);
        this.setQProp(7, "r", ma);
        this.setQProp(9, "X", ma);
        this.setQProp(10, "D", ma);
    }

    private void setQProp(int index, String s, MolAtom ma) {
        if (this.initValues[index] != -10000) {
            ma.setQProp(s, this.initValues[index]);
        }
    }

    private int getInitIndex(String queryValue) {
        switch (queryValue.charAt(0)) {
            case 'A': 
            case 'a': {
                return 4;
            }
            case 'H': {
                return 5;
            }
            case 'h': {
                return 11;
            }
            case 'R': {
                return 6;
            }
            case 'r': {
                if (queryValue.length() == 1) {
                    return 6;
                }
                return 7;
            }
            case 'v': {
                return 8;
            }
            case 'X': {
                return 9;
            }
            case 'D': {
                return 10;
            }
            case '+': 
            case '-': {
                return 1;
            }
            case ':': {
                return 2;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return 3;
            }
        }
        return -1;
    }

    private String getCharges(String queryString) {
        char[] c = queryString.replace(" ", "").toCharArray();
        StringBuffer sb = new StringBuffer();
        boolean pos = false;
        return sb.length() == 0 ? null : sb.toString();
    }

    public static final boolean hasSMARTSPropsExcluding(MolAtom atom, String exclude) {
        if (atom.getValenceProp() >= 0 && exclude.indexOf("v") < 0) {
            return true;
        }
        String list = "HXDRrah";
        for (int i = 0; i < list.length(); ++i) {
            String key = list.substring(i, i + 1);
            if (atom.getQProp(key) == null || exclude.indexOf(key) >= 0) continue;
            return true;
        }
        if (atom.getQProp("rb") != null && exclude.indexOf("rb") < 0) {
            return true;
        }
        if (atom.getQProp("s") != null && exclude.indexOf("s") < 0) {
            return true;
        }
        return atom.getQProp("u") != null && exclude.indexOf("u") < 0;
    }

    public static final boolean hasSMARTSProps(MolAtom atom) {
        return SmartsAtomQuerifier.hasSMARTSPropsExcluding(atom, "");
    }

    public static void setSMARTS(MolAtom atom, String s) throws SecurityException {
        if (s != null) {
            if (!(s = s.trim()).startsWith("[")) {
                s = "[".concat(s);
            }
            if (!s.endsWith("]")) {
                s = s.concat("]");
            }
            try {
                CallbackIface ci = (CallbackIface)((Object)MFileFormat.SMILES.createImportModule());
                MolAtom a = (MolAtom)ci.callback("readSmartsAtom", s);
                if (a != null) {
                    ExtraAtomProperties.mergeProperties(a, atom);
                    return;
                }
            }
            catch (SecurityException sex) {
                throw sex;
            }
            catch (Exception ex) {
                System.err.println("Cannot load SmilesImport module\n");
            }
        }
        SmartsAtomQuerifier.setQuerystr(atom, s);
    }

    public void setMarvinCompMode(boolean marvinCompMode) {
        this.marvinCompMode = marvinCompMode;
    }

    public static void setQuerystr(MolAtom atom, String s, int options) {
        if (s != null) {
            String remainingQuerystr = null;
            if (s == null || "[]".equals(s) || "".equals(s)) {
                remainingQuerystr = s;
            } else {
                SmartsAtomQuerifier smartsAtomQuerifier = new SmartsAtomQuerifier();
                if (options == 1) {
                    smartsAtomQuerifier.setMarvinCompMode(false);
                }
                remainingQuerystr = SmartsAtomQuerifier.query(smartsAtomQuerifier, atom, s);
            }
            atom.setQueryString(remainingQuerystr == null || remainingQuerystr.length() == 0 ? null : remainingQuerystr);
        }
    }

    public static void setQuerystr(MolAtom atom, String s) {
        SmartsAtomQuerifier.setQuerystr(atom, s, 0);
    }
}

