/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.smiles;

import chemaxon.calculations.hydrogenize.Hydrogenize;
import chemaxon.common.util.ArrayTools;
import chemaxon.common.util.Base64OutputStream;
import chemaxon.core.calculations.GraphInvariants;
import chemaxon.core.util.BondTable;
import chemaxon.enumeration.MarkushEnumeratorFactory;
import chemaxon.enumeration.MolEnumerator;
import chemaxon.formats.MolExporter;
import chemaxon.marvin.io.MPropHandler;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.MolExportModule;
import chemaxon.marvin.io.formats.smiles.CxsmilesExport;
import chemaxon.marvin.io.formats.smiles.SmartsAtomQuerifier;
import chemaxon.marvin.util.CleanUtil;
import chemaxon.marvin.util.OptionDescriptor;
import chemaxon.marvin.util.text.LocaleUtil;
import chemaxon.struc.MDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.QueryBond;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.StereoConstants;
import chemaxon.struc.sgroup.MulticenterSgroup;
import chemaxon.util.SmilesCompressor;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SmilesExport
extends MolExportModule
implements StereoConstants {
    private static final Logger logger = Logger.getLogger(SmilesExport.class.getName());
    private static final Level FINE = Level.FINE;
    private static final Level FINEST = Level.FINEST;
    private static boolean DEBUG_UNCROWD = false;
    private static boolean DEBUG_DB_FLAGS = true;
    private static boolean DEBUG_DB_EXPORT = false;
    private static boolean DEBUG_RINGATOMS = false;
    private static final int FFINAL = 1;
    private static final int FACTIVE = 2;
    private static final int FDOUBLE = 4;
    private static final int FTERMINAL = 8;
    private static final int FRING = 16;
    private static final int FBETWEEN = 32;
    static final int FSMARI = 64;
    private static final int SMALL_R_SIZE = 8;
    private static final int FWARIBO = 128;
    private static final int FSLASH = 256;
    private static final int FUNSPEC = 512;
    private static final int FDEFAULT = 1024;
    private static final int FCARE = 2048;
    private static final int FFSBON1 = 4096;
    private static final int FFSBON2 = 8192;
    private static final int FALLEN = 16384;
    private static final int FN1HV = 32768;
    private static final int FN2HV = 65536;
    static final int FCXCIS = 131072;
    static final int FCXTRANS = 262144;
    private static final int FNRPDB = 524288;
    static final int FDBINACTIVE = 0x100000;
    static final int CISTRANS = 192;
    static final int H_ORDER = Integer.MAX_VALUE;
    static final int LP_ORDER = 0x7FFFFFFE;
    static final int ALLENIC_IMPL_H2 = 0x7FFFFFFD;
    int[] origBtab2;
    int[] smilesAtoms;
    int[][] ringAtoms;
    int[][] ringNumbers;
    Molecule molecule;
    private int[][] origCtab;
    private BondTable origBtab;
    int[][] smiCtab;
    int[] ctab2smi;
    private static final int H_OFFSET = 10;
    int[][] dbsActiveBonds;
    private boolean[] ringbond;
    private int[] dbsActiveAtoms;
    private int[][] dbsActiveRingAtomFlags;
    private static final long F_AROMATIC = 1L;
    private static final long F_QUERYAROM = 2L;
    static final long F_BEGINBRANCH = 4L;
    static final long F_ENDBRANCH = 8L;
    static final long F_ENDFRAG = 16L;
    private static final long F_BEGINCLG = 32L;
    private static final long F_ENDCLG = 64L;
    private static final int BOND_SHIFT = 7;
    long[] atomFlags;
    private int[] branchDepth;
    boolean wrdbsEnabled = true;
    boolean wrparEnabled = true;
    boolean wrparinfo = true;
    boolean uniqueFormat = false;
    boolean gInvCheck = true;
    boolean parityAndCTinCanon = true;
    boolean querySmarts = false;
    boolean forceQuerySmarts = false;
    boolean rgToRecursiveSmarts = true;
    boolean enumerateLinkAndPosVarBonds = true;
    boolean writeMolName = false;
    boolean setTerminalAtomArom = false;
    private static final int TYPE_MASK = 15;
    private static final int AROMATICB = 4;
    private static final int SINGLE_OR_AROMATIC = 6;
    private static final int DOUBLE_OR_AROMATIC = 7;
    private static final int SINGLE_OR_DOUBLE = 5;
    private static final int ANYBOND = 0;
    private static final int ANY = 131;
    private static final int AROMATICA = 1;
    private static final int ALIPHATIC = 2;
    private static final int QUERY_STR = 16;
    boolean convExpToHCount = false;
    boolean simplestForm = false;
    boolean compress = false;
    SmilesCompressor compressor = null;
    boolean ignoreMaps = true;
    boolean writeHeader = true;
    String[] incFields = null;
    private boolean queryBondStrRearrange = false;
    int[] smilesBondIdx = null;
    int[] smiToOrigBondIdx = null;
    private int startingIndex = -1;
    private int[] originalQueryAromaticity = null;
    private boolean[] flipQueryString = null;
    boolean cx = false;
    private GraphInvariants grinv = new GraphInvariants();
    public static final int FULL_FLEXIBLE = 1;
    public static final int ATOM_AND_MOL_CHECK = 5;
    public static final int DBSTEREOCHECK = 7;
    int SMILES_strictness = 5;
    private boolean headerShouldBeGuessed = false;

    public SmilesExport() {
    }

    SmilesExport(SmilesExport e) {
        this.setFields(e);
    }

    public void setSMILESExportRigor(int r) {
        this.SMILES_strictness = r;
    }

    public int getSMILESExportRigor() {
        return this.SMILES_strictness;
    }

    @Override
    public boolean isCleanable() {
        return false;
    }

    static boolean hasNonSupportedSmilesAtomFeature(MolAtom a) {
        return CxsmilesExport.hasNonSupportedCxsmilesAtomFeature(a) || a.getStereoGroupType() != 0;
    }

    static boolean hasNonSupportedSmartsAtomFeature(MolAtom a) {
        return CxsmilesExport.hasNonSupportedCxsmartsAtomFeature(a) || a.getStereoGroupType() != 0;
    }

    static boolean hasNonSupportedSmilesMolecularFeature(Molecule mol) {
        RgMolecule m;
        int l;
        for (int i = mol.getSgroupCount() - 1; i >= 0; --i) {
            MulticenterSgroup mcsg;
            Sgroup s = mol.getSgroup(i);
            if (!(s instanceof MulticenterSgroup) || !(mcsg = (MulticenterSgroup)s).hasNonCoordinateBond()) continue;
            return true;
        }
        if (mol instanceof RgMolecule && (l = (m = (RgMolecule)mol).getRgroupCount()) > 0) {
            return true;
        }
        if (CxsmilesExport.hasNonSupportedCxsmilesMolecularFeature(mol)) {
            return true;
        }
        return SmilesExport.hasRGAttachAtom(mol);
    }

    static boolean hasNonSupportedSmartsMolecularFeature(Molecule mol) {
        if (CxsmilesExport.hasNonSupportedCxsmartsMolecularFeature(mol)) {
            return true;
        }
        return SmilesExport.hasRGAttachAtom(mol);
    }

    static boolean hasRGAttachAtom(Molecule mol) {
        int ac = mol.getAtomCount();
        for (int i = 0; i < ac; ++i) {
            MolAtom a = mol.getAtom(i);
            if (a.getAtno() != 138) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void getOptionDescriptors(String fmtname, String optnames, List<OptionDescriptor> l) {
        super.getOptionDescriptors(null, null, l);
        ResourceBundle rc = LocaleUtil.getResourceBundle(SmilesExport.class.getName(), null);
        SmilesExport.getOptionDescriptors(rc, fmtname, null, l);
    }

    @Override
    public Object open(String fmtopts) throws MolExportException {
        this.wrparinfo = true;
        this.incFields = null;
        super.open(fmtopts);
        if (this.getFormat() != null && this.getFormat().toLowerCase().equals("smarts")) {
            this.querySmarts = true;
            this.gInvCheck = false;
        }
        if (this.incFields != null && (this.incFields.length != 1 || !this.incFields[0].equals("*") && !this.incFields[0].equals("\"*\"")) && this.writeHeader) {
            return SmilesExport.createHeaderString(this.incFields, this.getSMILESColumnName(), this.writeMolName);
        }
        return null;
    }

    private static String createHeaderString(String[] fields, String format2, boolean writeName) {
        StringBuffer sb = new StringBuffer("#");
        sb.append(format2);
        if (writeName) {
            sb.append("\tname");
        }
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            if (writeName && field.equals("name")) continue;
            sb.append("\t");
            sb.append(field);
        }
        sb.append('\n');
        return sb.toString();
    }

    protected String getSMILESColumnName() {
        return this.getFormat().toUpperCase();
    }

    public int[] getOriginalAtomIndexes() {
        return this.smilesAtoms;
    }

    public int[] getSmilesAtomIndexes() {
        return this.ctab2smi;
    }

    @Override
    protected int parseOption(String opts, int i) throws IllegalArgumentException {
        int ii = super.parseOption(opts, i);
        if (ii != i) {
            return ii;
        }
        i = this.parseCharIfOptionSign(opts, i);
        int optionSign2 = this.getOptionSign();
        char c = opts.charAt(i);
        if (c == '0') {
            this.wrdbsEnabled = false;
            this.wrparEnabled = false;
            ++i;
        } else if (c == 'q') {
            this.gInvCheck = true;
            ++i;
        } else if (c == 'r') {
            int j;
            int r = 0;
            for (j = i + 1; j < opts.length() && (c = opts.charAt(j)) != '0' && c <= '9'; ++j) {
                r = r * 10 + c - 48;
            }
            i = j;
            this.SMILES_strictness = r;
        } else if (c == 'S') {
            this.forceQuerySmarts();
            ++i;
        } else if (c == 's') {
            this.querySmarts = true;
            ++i;
        } else if (c == 'z') {
            this.simplestForm = true;
            ++i;
        } else if (c == 'Z') {
            this.compress = true;
            ++i;
        } else if (c == 'n') {
            this.writeMolName = true;
            ++i;
        } else if (c == 'h') {
            this.convExpToHCount = true;
            ++i;
        } else if (!(this instanceof CxsmilesExport || c != 'e' && c != 'l' && c != 'w' && c != 'd' && c != 'f' && c != 'p' && c != 'R' && c != 'L' && c != 'm' && c != 'N' && c != 'D' && c != 'c')) {
            ++i;
        } else if (c == 'u') {
            this.uniqueFormat = true;
            this.gInvCheck = true;
            this.aromatize = this.aromatize == 0 ? 3 : this.aromatize;
            this.hydrogenize = -1;
            this.parityAndCTinCanon = true;
            ++i;
        } else if (c == 'M') {
            this.ignoreMaps = false;
            ++i;
        } else if (c == 'T') {
            StringTokenizer st;
            int n;
            int j;
            this.writeHeader = optionSign2 >= 0;
            for (j = i + 1; j < opts.length() && (c = opts.charAt(j)) != ',' && c != '\n' && c != '\r'; ++j) {
            }
            if (j > i + 1 && (n = (st = new StringTokenizer(opts.substring(i + 1, j), ":")).countTokens()) > 0) {
                this.incFields = new String[n];
                for (int k = 0; k < n; ++k) {
                    this.incFields[k] = st.nextToken();
                }
            }
            if (this.incFields != null && this.incFields.length == 1 && (this.incFields[0].equals("*") || this.incFields[0].equals("\"*\""))) {
                this.headerShouldBeGuessed = true;
            }
            i = j;
        } else if (c == 't') {
            this.setTerminalAtomArom = true;
            ++i;
        } else if (c == 'I') {
            int j;
            for (j = i + 1; j < opts.length() && (c = opts.charAt(j)) != ',' && c != ' ' && c != '\n' && c != '\r'; ++j) {
            }
            if (j > i + 1) {
                String idxStr = opts.substring(i + 1, j);
                this.startingIndex = new Integer(idxStr);
            }
            i = j;
        }
        return i;
    }

    void forceQuerySmarts() {
        this.forceQuerySmarts = true;
        this.querySmarts = true;
        this.SMILES_strictness = 1;
    }

    @Override
    public Object convert(Molecule mol) throws MolExportException {
        this.cx = false;
        this.toSMILES(mol);
        this.writeHeaderIfNeeded(mol);
        if (this.compress) {
            this.CompressAndBase64Encode();
        }
        if (this.incFields != null || this.writeMolName) {
            SmilesExport.writeSDFFields(mol, this.incFields, this.stringBuffer, this.writeMolName);
        }
        this.stringBuffer.append('\n');
        return this.stringBuffer.toString();
    }

    protected void writeHeaderIfNeeded(Molecule mol) {
        if (this.headerShouldBeGuessed) {
            this.writeMolName = true;
            this.incFields = SmilesExport.createFieldsAddHeader(mol);
            this.headerShouldBeGuessed = false;
            if (this.writeHeader) {
                String header = SmilesExport.createHeaderString(this.incFields, this.getSMILESColumnName(), this.writeMolName);
                this.stringBuffer.insert(0, header);
            }
        }
    }

    private static String[] createFieldsAddHeader(Molecule mol) {
        String[] fields = new String[mol.getPropertyCount()];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = mol.getPropertyKey(i);
        }
        return fields;
    }

    @Override
    protected Molecule preconvert(Molecule mg) {
        MDocument d;
        Molecule m = mg;
        if (mg instanceof Molecule && mg.getSgroupCount() > 0) {
            d = mg.getDocument();
            Molecule mol = m = d != null ? (Molecule)d.cloneMainMoleculeGraph() : (Molecule)mg.clone();
            mol.setGUIContracted(true);
            if (!this.querySmarts) {
                mol.ungroupSgroups(14);
            }
            mol.ungroupSgroups(0);
        }
        if (m.getDim() > 0 && this.hydrogenize == 1) {
            if (m == mg) {
                d = m.getDocument();
                m = d != null ? (Molecule)d.cloneMainMoleculeGraph() : (Molecule)m.clone();
            }
            m.setDim(0);
        }
        if ((m = this.preconvert(m, true, 0, false)) instanceof Molecule) {
            if (m == mg) {
                d = m.getDocument();
                m = d != null ? (Molecule)d.cloneMainMoleculeGraph() : (Molecule)m.clone();
            }
            Molecule mol = m;
            for (int i = mol.getBondCount() - 1; i >= 0; --i) {
                MolBond b = m.getBond(i);
                if (!b.isCoordinate()) continue;
                mol.removeBond(b);
            }
        }
        if (m.hasExplicitLonePairs()) {
            if (m == mg) {
                d = m.getDocument();
                m = d != null ? (Molecule)d.cloneMainMoleculeGraph() : (Molecule)m.clone();
            }
            Hydrogenize.removeLonePairs(m);
        }
        return m;
    }

    public String toSMILES(Molecule origmol) throws MolExportException {
        if (!this.forceQuerySmarts && this.SMILES_strictness > 1) {
            Molecule m = origmol;
            if (CxsmilesExport.hasNonSupportedCxsmartsMolecularFeature(m)) {
                this.throwMolExportException(m);
            }
            if (this.querySmarts) {
                if (!this.cx && SmilesExport.hasNonSupportedSmartsMolecularFeature(m)) {
                    this.throwMolExportExceptionSMARTS(m);
                }
            } else if (this.cx) {
                if (CxsmilesExport.hasNonSupportedCxsmilesMolecularFeature(m)) {
                    this.throwMolExportExceptionSMILES(m);
                }
            } else if (SmilesExport.hasNonSupportedSmilesMolecularFeature(m)) {
                this.throwMolExportExceptionSMILES(m);
            }
        }
        this.stringBuffer.setLength(0);
        this.originalQueryAromaticity = null;
        this.flipQueryString = null;
        this.queryBondStrRearrange = this.wrdbsEnabled ? SmilesExport.checkQueryBond(origmol) : false;
        Molecule mol = this.convExpToHCount ? (Molecule)origmol.clone() : origmol;
        mol = this.preconvert(mol);
        if (this.forceQuerySmarts) {
            if (mol == origmol) {
                mol = (Molecule)origmol.clone();
            }
            SmilesExport.removeAttachmentAtoms(mol);
        }
        if (origmol instanceof RxnMolecule) {
            this.exportReaction((RxnMolecule)mol);
        } else if (origmol instanceof RgMolecule) {
            Molecule m;
            RgMolecule rgmol = (RgMolecule)mol;
            mol = m = rgmol.getRoot();
            if (m instanceof RxnMolecule) {
                this.exportReaction((RxnMolecule)m);
            } else {
                this.singleMolToSMILES(mol);
            }
        } else {
            if (mol instanceof RgMolecule) {
                mol = ((RgMolecule)mol).getRoot();
            }
            this.singleMolToSMILES(mol);
        }
        this.molecule = mol;
        return this.stringBuffer.toString();
    }

    void CompressAndBase64Encode() throws MolExportException {
        try {
            if (this.compress) {
                if (this.compressor == null) {
                    this.compressor = new SmilesCompressor();
                }
                byte[] cs = this.compressor.compress(this.stringBuffer.toString());
                this.stringBuffer.setLength(0);
                int l = cs.length;
                int ni0 = 3 * (l / 3);
                int nout = 4 * (l / 3);
                Base64OutputStream base64 = new Base64OutputStream(null);
                byte[] b64 = base64.convertBase64(0, cs, ni0, nout, false);
                this.stringBuffer.append(new String(b64));
                int len = l - ni0;
                if (len > 0) {
                    byte[] r = new byte[len];
                    System.arraycopy(cs, ni0, r, 0, len);
                    b64 = base64.convertBase64(r, len);
                    this.stringBuffer.append(new String(b64));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MolExportException("SMILES Compression failure");
        }
    }

    String singleMolToSMILES(Molecule mol) throws MolExportException {
        int i;
        this.stringBuffer.setLength(0);
        this.molecule = mol;
        mol.valenceCheck();
        if (this.convExpToHCount) {
            SmilesExport.convertExplicitHToHCount(mol);
        }
        if (this.querySmarts && !this.cx && this.enumerateLinkAndPosVarBonds) {
            boolean success = SmilesExport.enumerateLinkAndPosVarBonds(mol, this.stringBuffer);
            if (this.stringBuffer.length() != 0) {
                if (!success) {
                    return this.getSimpleSmartsString(mol);
                }
                return this.stringBuffer.toString();
            }
        }
        int nall = mol.getAtomCount();
        int ball = mol.getBondCount();
        this.origCtab = mol.getCtab();
        int[][] ctab = this.origCtab;
        BondTable btab = this.origBtab = mol.getBondTable();
        int[] brasta = new int[nall];
        this.createBtab2();
        this.smilesAtoms = new int[nall];
        boolean excH = !this.parityAndCTinCanon;
        this.atomFlags = this.grinv.makeInitial(mol, false, excH);
        int[][] nArrayArray = new int[nall][];
        this.ringNumbers = nArrayArray;
        int[][] rings = nArrayArray;
        this.ringAtoms = new int[nall][];
        for (int atom = 0; atom < nall; ++atom) {
            int nneis = ctab[atom].length;
            rings[atom] = new int[nneis];
            Arrays.fill(rings[atom], -1);
            this.ringAtoms[atom] = new int[nneis];
            Arrays.fill(this.ringAtoms[atom], -1);
        }
        this.ctab2smi = new int[nall];
        this.wrparinfo = this.wrparEnabled && SmilesExport.checkParityPossibility(mol);
        int na = this.determineSmilesAtomOrder(this.atomFlags, this.ringAtoms);
        if (na != nall) {
            return null;
        }
        if (logger.isLoggable(FINE) && DEBUG_RINGATOMS) {
            logger.fine(SmilesExport.toString(this.ringAtoms));
        }
        this.smilesBondIdx = SmilesExport.generateSmilesBonds(mol, this.smilesAtoms, this.ringAtoms, this.ringNumbers, this.atomFlags);
        this.smiToOrigBondIdx = new int[ball];
        for (i = 0; i < ball; ++i) {
            this.smiToOrigBondIdx[this.smilesBondIdx[i]] = i;
        }
        this.smiCtab = new int[nall][];
        for (i = 0; i < nall; ++i) {
            int[] an = ctab[i];
            int l = an.length;
            int[] san = new int[l];
            for (int j = 0; j < l; ++j) {
                san[j] = this.ctab2smi[an[j]];
            }
            ArrayTools.sortDescending(san);
            this.smiCtab[this.ctab2smi[i]] = san;
        }
        if (this.wrparinfo) {
            this.initStereo1(mol);
        }
        if (this.wrdbsEnabled) {
            this.initStereo2(btab);
        } else {
            this.ringbond = new boolean[mol.getBondCount()];
            int[][] sssr = mol.getSSSR();
            for (int i2 = 0; i2 < sssr.length; ++i2) {
                int[] sr = sssr[i2];
                int siz = sr.length;
                for (int ib = 0; ib < siz; ++ib) {
                    int h = sr[ib];
                    int n = sr[(ib + 1) % siz];
                    int idx = btab.getBondIndex(h, n);
                    this.ringbond[idx] = true;
                }
            }
        }
        if (this.queryBondStrRearrange) {
            this.flipQueryString = new boolean[mol.getBondCount()];
            this.rearrangeQueryBondString(brasta, btab);
        }
        this.generateSmilesString(brasta, this.ringAtoms);
        SmilesExport.restoreMolecule(mol, this.originalQueryAromaticity, this.flipQueryString, this.queryBondStrRearrange);
        return this.stringBuffer.toString();
    }

    private void canonicalize(long[] caninv, int[] ranks) {
        int nranks;
        boolean excH = !this.parityAndCTinCanon;
        int[] nn = SmilesExport.numberOfNonNegativeRanks(caninv);
        int na = nn[0];
        int lastnn = nn[1];
        int bc = this.molecule.getBondCount();
        int[][] ctab = this.origCtab;
        BondTable btab = this.origBtab;
        if (!this.ignoreMaps) {
            int grinvOptions = this.molecule.getGrinvOptions();
            this.molecule.setGrinvOptions(grinvOptions | 0x20);
            caninv = this.grinv.recalcCanInv(this.molecule);
            this.molecule.setGrinvOptions(grinvOptions &= 0xFFFFFFDF);
        }
        if ((nranks = GraphInvariants.genRanks(caninv, ranks, excH, lastnn)) != na) {
            nranks = SmilesExport.breakTies((MoleculeGraph)this.molecule, caninv, ranks, nranks, ctab, btab, nn, excH);
        }
        int[] ct = null;
        if (nranks != na && this.parityAndCTinCanon) {
            ct = new int[bc];
            for (int i = 0; i < bc; ++i) {
                MolBond b = this.molecule.getBond(i);
                MolAtom a2 = b.getAtom1();
                MolAtom a3 = b.getAtom2();
                if (b.getType() != 2 || a2.getBondCount() <= 1 || a3.getBondCount() <= 1 || !SmilesExport.checkForSingleBonds(b)) continue;
                MolAtom a1 = b.getCTAtom1();
                MolAtom a4 = b.getCTAtom4();
                int s = this.molecule.getStereo2(b, a1, a4, true);
                ct[i] = (s &= 0xC0) == 192 ? 0 : s;
            }
            int[][] sssr = this.molecule.getSSSR();
            for (int isr = 0; isr < sssr.length; ++isr) {
                int[] sr = sssr[isr];
                int siz = sr.length;
                if (siz >= 8) continue;
                for (int ib = 0; ib < siz; ++ib) {
                    int h = sr[ib];
                    int n = sr[(ib + 1) % siz];
                    int idx = btab.getBondIndex(h, n);
                    ct[idx] = 0;
                }
            }
            int generatedranks = SmilesExport.CTInfoToRanks(this.molecule, caninv, ranks, nranks, ct, nn, excH);
            if (generatedranks != nranks) {
                SmilesExport.copyRankToCaninv(ranks, caninv, lastnn);
                nranks = generatedranks;
            }
        }
        int[] parities = null;
        if (nranks != na && this.parityAndCTinCanon && this.wrparinfo) {
            parities = new int[lastnn];
            boolean hasParityInfo = false;
            for (int i = 0; i < lastnn; ++i) {
                int p = this.molecule.getParity(i) & 3;
                p = p == 3 ? 0 : p;
                parities[i] = p = this.molecule.getParityType(i) != 1 ? 0 : p;
                hasParityInfo |= p != 0;
            }
            if (hasParityInfo) {
                nranks = SmilesExport.addParityInfoToRanks(this.molecule, caninv, ranks, parities, ctab, nn, excH, nranks);
            } else {
                parities = null;
            }
        }
        while (nranks != na) {
            int tiedIndex = SmilesExport.selectFromTiedAtoms(ranks, parities, ctab, this.molecule, nn, excH, this.parityAndCTinCanon);
            for (int i = 0; i < lastnn; ++i) {
                caninv[i] = ranks[i] == -1 ? -1L : (long)(ranks[i] + 1 << 1);
            }
            int n = tiedIndex;
            caninv[n] = caninv[n] - 1L;
            nranks = GraphInvariants.genRanks(caninv, ranks, excH, nn[1]);
            nranks = SmilesExport.addParityInfoToRanks(this.molecule, caninv, ranks, parities, ctab, nn, excH, nranks);
        }
    }

    private static final int selectFromTiedAtoms(int[] ranks, int[] p, int[][] ctab, MoleculeGraph m, int[] nn, boolean excH, boolean unique) {
        int nr;
        int i;
        if (unique) {
            int n = 0;
            int l = ctab.length;
            if (p != null) {
                for (int i2 = 0; i2 < l; ++i2) {
                    if (p[i2] == 0) continue;
                    ++n;
                }
            }
            if (n > 0) {
                int[][] ranksWithParity = new int[2][n];
                n = 0;
                for (i = 0; i < l; ++i) {
                    if (p[i] == 0) continue;
                    ranksWithParity[0][n] = i;
                    ranksWithParity[1][n++] = ranks[i];
                }
                ArrayTools.sortDescending(ranksWithParity[1], ranksWithParity[0]);
                int ligand = SmilesExport.getTiedIndexFromCommonLigandRank(ranksWithParity, ctab, ranks, p, m, nn, excH);
                if (ligand >= 0) {
                    return ligand;
                }
            }
        }
        int tiedIdx = -1;
        int min = -1;
        do {
            ++min;
            nr = 0;
            tiedIdx = -1;
            for (i = 0; i < ranks.length; ++i) {
                if (ranks[i] != min) continue;
                if (tiedIdx < 0) {
                    tiedIdx = i;
                }
                ++nr;
            }
        } while (nr == true);
        return tiedIdx;
    }

    private static final int getTiedIndexFromCommonLigandRank(int[][] idAndRank, int[][] ctab, int[] ranks, int[] p, MoleculeGraph m, int[] nn, boolean excH) {
        int[] idxes = idAndRank[0];
        int[] rs = idAndRank[1];
        int[] selectFrom = new int[idxes.length];
        int n = 0;
        for (int i = idxes.length - 1; i >= 0 && (i >= idxes.length - 1 || rs[i] == rs[i + 1] || n <= 0); --i) {
            int center = idxes[i];
            int[] an = ctab[center];
            int nc = SmilesExport.getCommonRankCount(an, ranks);
            if (nc >= 3) continue;
            selectFrom[n++] = center;
        }
        if (n > 0) {
            BitSet[] s = new BitSet[n];
            int[] tiedIdxes = new int[n];
            for (int j = 0; j < n; ++j) {
                s[j] = new BitSet();
                tiedIdxes[j] = SmilesExport.getAtomIdxBasedOnParity(selectFrom[j], ctab, ranks, p, s[j], m, nn, excH);
            }
            int i = SmilesExport.getDistinctSetIdx(s, 0);
            if (i == -1) {
                return -1;
            }
            return tiedIdxes[i];
        }
        return -1;
    }

    private static final int getCommonRankCount(int[] an, int[] ranks) {
        int c = 0;
        for (int j = 0; j < an.length; ++j) {
            int n = 0;
            int r = ranks[an[j]];
            for (int k = j + 1; k < an.length && (r != ranks[an[k]] || ++n <= 1); ++k) {
            }
            if (n > 1) break;
            if (n == 1) {
                ++c;
            }
            if (c <= 1) continue;
            return 3;
        }
        return c + 1;
    }

    static final int getAtomIdxBasedOnParity(int idx, int[][] ctab, int[] ranks, int[] p, BitSet uniqueSet, MoleculeGraph m, int[] nn, boolean excH) {
        int[] an = ctab[idx];
        int l = ranks.length;
        int[] rankc = new int[l];
        int[] p_clone = new int[l];
        long[] caninv = new long[l];
        int[] equalRankIdx = SmilesExport.getEquals(an, ranks);
        BitSet[] s = new BitSet[equalRankIdx.length];
        for (int j = 0; j < equalRankIdx.length; ++j) {
            s[j] = new BitSet();
            System.arraycopy(p, 0, p_clone, 0, l);
            for (int k = 0; k < l; ++k) {
                caninv[k] = ranks[k] + 1 << 1;
            }
            int n = equalRankIdx[j];
            caninv[n] = caninv[n] - 1L;
            int rankCount = GraphInvariants.genRanks(caninv, rankc, excH, nn[1]);
            SmilesExport.addParityInfoToRanks(m, caninv, rankc, p_clone, ctab, nn, excH, rankCount);
            for (int i = 0; i < l; ++i) {
                if (p[i] == 0) continue;
                int i4 = (an = ctab[i]).length == 3 ? Integer.MAX_VALUE : an[3];
                int pc = SmilesExport.parityConversion(an[0], an[1], an[2], i4, rankc, m);
                if (pc != 0) {
                    int par_red = p[i] == 1 ? 0 : 1;
                    par_red = pc == 1 ? par_red : par_red ^ 1;
                    s[j].set(rankc[i] * 2 + par_red);
                    continue;
                }
                s[j].set(rankc[i] * 2);
                s[j].set(rankc[i] * 2 + 1);
            }
        }
        int i = SmilesExport.getDistinctSetIdx(s, 0);
        if (i == -1) {
            return -1;
        }
        uniqueSet.or(s[i]);
        return equalRankIdx[i];
    }

    static final int getDistinctSetIdx(BitSet[] s, int startBit) {
        int l;
        int n = l = s != null ? s.length : -1;
        if (l == 1) {
            return 0;
        }
        if (l >= 1) {
            int i;
            int min_val = Integer.MAX_VALUE;
            int min_idx = 0;
            boolean more = false;
            for (i = s.length - 1; i >= 0; --i) {
                if (s[i] == null) continue;
                int sb = s[i].nextSetBit(startBit);
                if (sb < min_val) {
                    min_val = sb;
                    min_idx = i;
                    more = false;
                    continue;
                }
                if (sb != min_val) continue;
                more = true;
            }
            if (!more) {
                return min_idx;
            }
            if (min_val == Integer.MAX_VALUE || min_val == -1) {
                return -1;
            }
            for (i = s.length - 1; i >= 0; --i) {
                if (s[i] == null || s[i].get(min_val)) continue;
                s[i] = null;
            }
            int min = SmilesExport.getDistinctSetIdx(s, min_val + 1);
            return min < 0 ? min_idx : min;
        }
        return -1;
    }

    static int[] getEquals(int[] ct, int[] r) {
        int l = ct.length;
        int[] tmp = new int[l];
        for (int i = 0; i < l; ++i) {
            int n = 0;
            int a = r[ct[i]];
            tmp[n] = ct[i];
            for (int j = i; j < l; ++j) {
                if (a != r[ct[j]]) continue;
                tmp[n++] = ct[j];
            }
            if (n <= 1) continue;
            int[] e = new int[n];
            System.arraycopy(tmp, 0, e, 0, n);
            return e;
        }
        return new int[0];
    }

    public static int breakTies(MoleculeGraph mol, long[] caninv, int[] ranks, int rankCount, int[][] ctab, BondTable btab, int[] nn, boolean excH) {
        int prevRankCount;
        int na = nn[0];
        int lastnn = nn[1];
        int tm = 15;
        long[] primeNumbers = GraphInvariants.getPrimeNumbers(na + tm);
        do {
            int i;
            long max = 0L;
            for (i = 0; i < lastnn; ++i) {
                if (ranks[i] == -1) continue;
                int[] ctabi = ctab[i];
                long r = 1L;
                long r_a = 0L;
                for (int j = 0; j < ctabi.length; ++j) {
                    int neighbor = ctabi[j];
                    if (ranks[neighbor] == -1) continue;
                    int t = mol.getBond(btab.getBondIndex(i, neighbor)).getType();
                    t = (int)primeNumbers[t];
                    long inv = (long)t * primeNumbers[ranks[neighbor] + tm];
                    r *= inv;
                    r_a += inv;
                }
                if (r > max) {
                    max = r;
                }
                caninv[i] = r + r_a;
            }
            ++max;
            for (i = 0; i < lastnn; ++i) {
                if (ranks[i] == -1) {
                    caninv[i] = -1L;
                    continue;
                }
                int n = i;
                caninv[n] = caninv[n] + max * (long)ranks[i];
            }
        } while ((prevRankCount = rankCount) < (rankCount = GraphInvariants.genRanks(caninv, ranks, excH, lastnn)) && rankCount < na);
        for (int i = 0; i < lastnn; ++i) {
            caninv[i] = ranks[i];
        }
        return rankCount;
    }

    public static int breakTies(MoleculeGraph mol, long[] caninv, int[] ranks, int rankCount, int[][] ctab, int[][] btab, int[] nn, boolean excH) {
        int prevRankCount;
        int na = nn[0];
        int lastnn = nn[1];
        int tm = 15;
        long[] primeNumbers = GraphInvariants.getPrimeNumbers(na + tm);
        do {
            int i;
            long max = 0L;
            for (i = 0; i < lastnn; ++i) {
                if (ranks[i] == -1) continue;
                int[] ctabi = ctab[i];
                int[] btabi = btab[i];
                long r = 1L;
                long r_a = 0L;
                for (int j = 0; j < ctabi.length; ++j) {
                    int neighbor = ctabi[j];
                    if (ranks[neighbor] == -1) continue;
                    int t = mol.getBond(btabi[neighbor]).getType();
                    t = (int)primeNumbers[t];
                    long inv = (long)t * primeNumbers[ranks[neighbor] + tm];
                    r *= inv;
                    r_a += inv;
                }
                if (r > max) {
                    max = r;
                }
                caninv[i] = r + r_a;
            }
            ++max;
            for (i = 0; i < lastnn; ++i) {
                if (ranks[i] == -1) {
                    caninv[i] = -1L;
                    continue;
                }
                int n = i;
                caninv[n] = caninv[n] + max * (long)ranks[i];
            }
        } while ((prevRankCount = rankCount) < (rankCount = GraphInvariants.genRanks(caninv, ranks, excH, lastnn)) && rankCount < na);
        for (int i = 0; i < lastnn; ++i) {
            caninv[i] = ranks[i];
        }
        return rankCount;
    }

    public static int CTInfoToRanks(MoleculeGraph mol, long[] caninv, int[] ranks, int rankCount, int[] ctinfo, int[] nn, boolean excH) {
        int prevRankCount;
        boolean hasCTinfo = false;
        int l = ctinfo.length;
        for (int i = 0; i < l && !hasCTinfo; ++i) {
            if (ctinfo[i] <= 0) continue;
            hasCTinfo = true;
        }
        if (!hasCTinfo) {
            return rankCount;
        }
        int[][] ctab = mol.getCtab();
        BondTable btab = mol.getBondTable();
        int na = nn[0];
        int lastnn = nn[1];
        Arrays.fill(caninv, 0L);
        do {
            int i;
            long max = 0L;
            for (i = 0; i < lastnn; ++i) {
                if (ranks[i] == -1) continue;
                int[] ctabi = ctab[i];
                for (int j = 0; j < ctabi.length; ++j) {
                    int neighbor = ctabi[j];
                    int bidx = btab.getBondIndex(i, neighbor);
                    if (ctinfo[bidx] == 0) continue;
                    MolBond b = mol.getBond(bidx);
                    if (!SmilesExport.allLigandRankDiffer(i, neighbor, ctab, ranks)) continue;
                    int i1 = SmilesExport.getSmallestRank(i, neighbor, ctab, ranks);
                    int i4 = SmilesExport.getSmallestRank(neighbor, i, ctab, ranks);
                    if (mol.getAtom(i) != b.getAtom1()) {
                        int tmp = i1;
                        i1 = i4;
                        i4 = tmp;
                    }
                    MolAtom n1 = mol.getAtom(i1);
                    MolAtom n4 = mol.getAtom(i4);
                    int ct = b.transformCT(n1, n4, ctinfo[bidx]);
                    ctinfo[bidx] = 0;
                    int n = i;
                    caninv[n] = caninv[n] + (long)ct;
                    if (ranks[neighbor] == -1) continue;
                    int n2 = neighbor;
                    caninv[n2] = caninv[n2] + (long)ct;
                }
                int n = i;
                caninv[n] = caninv[n] + 1L;
                if (caninv[i] <= max) continue;
                max = caninv[i];
            }
            ++max;
            for (i = 0; i < lastnn; ++i) {
                if (ranks[i] == -1) continue;
                int n = i;
                caninv[n] = caninv[n] + max * (long)ranks[i];
            }
            prevRankCount = rankCount;
            rankCount = GraphInvariants.genRanks(caninv, ranks, excH, lastnn);
            SmilesExport.copyRankToCaninv(ranks, caninv, lastnn);
        } while (prevRankCount < (rankCount = GraphInvariants.makeRanks(ctab, caninv, ranks, excH)) && rankCount < na);
        return rankCount;
    }

    static void copyRankToCaninv(int[] ranks, long[] caninv, int lastnn) {
        for (int i = 0; i < lastnn; ++i) {
            if (ranks[i] == -1) continue;
            caninv[i] = ranks[i];
        }
    }

    static boolean allLigandRankDiffer(int i1, int i2, int[][] ctab, int[] ranks) {
        int i;
        int[] ctabi = ctab[i1];
        int l = ctabi.length;
        if (l > 3) {
            return false;
        }
        int r1 = Integer.MIN_VALUE;
        int r2 = Integer.MIN_VALUE;
        for (i = 0; i < l; ++i) {
            if (ctabi[i] == i2) continue;
            if (r1 == Integer.MIN_VALUE) {
                r1 = ranks[ctabi[i]];
                continue;
            }
            r2 = ranks[ctabi[i]];
        }
        if (r1 == r2) {
            return false;
        }
        ctabi = ctab[i2];
        l = ctabi.length;
        if (l > 3) {
            return false;
        }
        r1 = Integer.MIN_VALUE;
        r2 = Integer.MIN_VALUE;
        for (i = 0; i < l; ++i) {
            if (ctabi[i] == i1) continue;
            if (r1 == Integer.MIN_VALUE) {
                r1 = ranks[ctabi[i]];
                continue;
            }
            r2 = ranks[ctabi[i]];
        }
        return r1 != r2;
    }

    static int getSmallestRank(int idx, int ex, int[][] ctab, int[] ranks) {
        int[] ctabi = ctab[idx];
        int l = ctabi.length;
        int minr = Integer.MAX_VALUE;
        int minIdx = -1;
        for (int i = 0; i < l; ++i) {
            int lidx = ctabi[i];
            if (lidx == ex || ranks[lidx] >= minr) continue;
            minr = ranks[lidx];
            minIdx = lidx;
        }
        return minIdx;
    }

    static int addParityInfoToRanks(MoleculeGraph m, long[] caninv, int[] ranks, int[] p, int[][] ctab, int[] nn, boolean excH, int rankCount) {
        boolean changed;
        int na = nn[0];
        int lastnn = nn[1];
        long[] primeNumbers = GraphInvariants.getPrimeNumbers(na);
        int rankC = rankCount;
        int[] newRanks = new int[ctab.length];
        long maxCaninvValue = 0L;
        boolean overflow = false;
        do {
            BigInteger bb;
            BigInteger ba;
            BigInteger br;
            for (int i = 0; i < lastnn; ++i) {
                int i4;
                int i3;
                int i2;
                int i1;
                int pc;
                if (ranks[i] == -1) continue;
                int[] neighbors = ctab[i];
                int nb = neighbors.length;
                long x = 1L;
                for (int j = 0; j < nb; ++j) {
                    int k = neighbors[j];
                    if (ranks[k] == -1) continue;
                    x *= primeNumbers[ranks[k]];
                }
                if (p != null && p[i] != 0 && (pc = SmilesExport.parityConversion(i1 = neighbors[0], i2 = neighbors[1], i3 = neighbors[2], i4 = nb == 3 ? Integer.MAX_VALUE : neighbors[3], ranks, m)) != 0) {
                    int par = pc == 1 ? p[i] : p[i] ^ 3;
                    par = par == 1 ? 1 : 2;
                    x *= primeNumbers[par];
                    p[i] = 0;
                }
                caninv[i] = x;
                if (x > maxCaninvValue) {
                    maxCaninvValue = x;
                }
                if (x >= 0L) continue;
                overflow = true;
            }
            if (!overflow && (br = (ba = new BigInteger(String.valueOf(maxCaninvValue))).multiply(bb = new BigInteger(String.valueOf(rankC)))).compareTo(BigInteger.valueOf(Long.MAX_VALUE)) != -1) {
                overflow = true;
            }
            int rCount = 0;
            rCount = overflow ? SmilesExport.getNewranksBasedOnOldRanksAndCaninv(newRanks, ranks, caninv, rankC, lastnn) : SmilesExport.getNewranksBasedOnOldRanksAndCaninvSpeedup(ranks, caninv, maxCaninvValue, lastnn);
            changed = rCount != rankC;
            rankC = rCount;
        } while (changed);
        return rankC;
    }

    static int getNewranksBasedOnOldRanksAndCaninv(int[] newRanks, int[] ranks, long[] caninv, int rankCount, int lastnn) {
        int newRankCount = 0;
        for (int i = 0; i < lastnn; ++i) {
            newRanks[i] = -1;
        }
        for (int r = 0; r < rankCount; ++r) {
            int nr;
            do {
                int i;
                nr = 0;
                long min = Long.MAX_VALUE;
                for (i = 0; i < lastnn; ++i) {
                    if (newRanks[i] != -1 || ranks[i] != r) continue;
                    ++nr;
                    if (caninv[i] >= min) continue;
                    min = caninv[i];
                }
                if (nr == 0) continue;
                for (i = 0; i < lastnn; ++i) {
                    if (ranks[i] != r || caninv[i] != min) continue;
                    newRanks[i] = newRankCount;
                }
                ++newRankCount;
            } while (nr != 0);
        }
        System.arraycopy(newRanks, 0, ranks, 0, lastnn);
        return newRankCount;
    }

    static int getNewranksBasedOnOldRanksAndCaninvSpeedup(int[] ranks, long[] caninv, long maxCaninv, int lastnn) {
        for (int i = 0; i < lastnn; ++i) {
            long r = ranks[i];
            if (r == -1L) continue;
            int n = i;
            caninv[n] = caninv[n] + r * maxCaninv;
        }
        return GraphInvariants.genRanks(caninv, ranks, true, lastnn);
    }

    static int parityConversion(int i1, int i2, int i3, int i4, int[] ranks, MoleculeGraph m) {
        int s1 = MolAtom.paritySign(i1 = SmilesExport.isHydrogen(m.getAtom(i1)) ? Integer.MAX_VALUE : i1, i2 = SmilesExport.isHydrogen(m.getAtom(i2)) ? Integer.MAX_VALUE : i2, i3 = SmilesExport.isHydrogen(m.getAtom(i3)) ? Integer.MAX_VALUE : i3, i4 = i4 == Integer.MAX_VALUE || SmilesExport.isHydrogen(m.getAtom(i4)) ? Integer.MAX_VALUE : i4);
        if (s1 == 0) {
            return 0;
        }
        int s2 = MolAtom.paritySign(i1 = i1 == Integer.MAX_VALUE ? Integer.MAX_VALUE : ranks[i1], i2 = i2 == Integer.MAX_VALUE ? Integer.MAX_VALUE : ranks[i2], i3 = i3 == Integer.MAX_VALUE ? Integer.MAX_VALUE : ranks[i3], i4 = i4 == Integer.MAX_VALUE ? Integer.MAX_VALUE : ranks[i4]);
        if (s2 == 0) {
            return 0;
        }
        return s1 == s2 ? 1 : -1;
    }

    private int determineSmilesAtomOrder(long[] flags, int[][] ringAtoms) {
        Molecule m = this.molecule;
        int[][] ctab = this.origCtab;
        int nall = ctab.length;
        this.originalQueryAromaticity = new int[nall];
        int[] btab2 = this.origBtab2;
        int rsnext = 0;
        int bsnext = 0;
        int[] ringstk = new int[2 * nall * (nall - 1)];
        int[] bracketstk = new int[nall];
        boolean[] tmpbool = new boolean[nall];
        boolean[] visited = new boolean[nall];
        int[] order = new int[nall];
        int[] ranks = new int[nall];
        boolean closedCLG = true;
        int clg = 0;
        this.canonicalize(flags, ranks);
        int atom = 0;
        if (this.startingIndex < 0) {
            atom = SmilesExport.findSmallestRankUnvisitedAtom(ranks, visited);
        } else {
            if (this.startingIndex >= nall) {
                System.err.println("Invalid starting atomindex,you should consider H atoms that removed");
            }
            atom = this.startingIndex;
        }
        int na = 0;
        while (na < nall && atom != -1) {
            int next;
            int an;
            boolean notList;
            int qArom;
            this.smilesAtoms[na] = atom;
            this.ctab2smi[atom] = na;
            int f = 0;
            MolAtom a = this.molecule.getAtom(atom);
            clg = a.getQPropAsInt("c");
            if (clg > 0 && closedCLG) {
                f = (int)((long)f | 0x20L);
            }
            if ((qArom = a.getQueryAromaticity()) == 1) {
                f = (int)((long)f | 1L);
            }
            if (qArom != 0) {
                f = (int)((long)f | 2L);
            }
            this.originalQueryAromaticity[atom] = qArom;
            boolean aaBond = false;
            if (qArom != 2 && qArom != 3) {
                int[] neighbors = ctab[atom];
                for (int i = neighbors.length - 1; i >= 0; --i) {
                    int t = btab2[atom * nall + neighbors[i]] & 0xF;
                    if ((t & 0xF) == 4) {
                        f = (int)((long)f | 1L);
                        if (this.querySmarts) continue;
                        break;
                    }
                    if (t != 6 && t != 7) continue;
                    aaBond = true;
                }
            }
            boolean bl = notList = (an = a.getAtno()) == 129;
            if (notList) {
                an = 128;
            }
            int absOx = MolAtom.numoxstatesOf(an) > 0 ? Math.abs(MolAtom.oxstateOf(an, 0)) : 4;
            int twicesb = a.twicesumbonds(true, false) + SmilesExport.getQueryBondCount(a);
            int charge = a.getCharge();
            if (this.querySmarts) {
                int qv;
                int freeValence = absOx - twicesb / 2 - Math.abs(charge);
                int x = a.getQPropAsInt("X");
                int h = a.getImplicitHcount();
                if (x >= 0) {
                    freeValence = x - h - a.getBondCount();
                    int n = freeValence = freeValence > 1 ? 3 : freeValence;
                }
                if ((qv = a.getValenceProp()) >= 0) {
                    freeValence = qv - twicesb / 2;
                }
                if (an == 7 || an == 8 || an == 16) {
                    ++freeValence;
                    if (this.setTerminalAtomArom && a.getBondCount() == 1) {
                        ++freeValence;
                    }
                }
                if (!notList && qArom == 0 && ((long)f & 1L) == 0L && an != 132 && (freeValence > 2 || aaBond || an == 131)) {
                    a.setQueryAromaticity(3);
                }
            }
            order[atom] = na;
            visited[atom] = true;
            if (this.countUnvisitedNeighbors(ctab[atom], visited) == 0) {
                if (bsnext > 0) {
                    f = (int)((long)f | 8L);
                    atom = bracketstk[--bsnext];
                } else {
                    int nextCLG = 0;
                    if (na != nall - 1) {
                        f = (int)((long)f | 0x10L);
                        atom = SmilesExport.findSmallestRankUnvisitedAtom(ranks, visited);
                        nextCLG = m.getAtom(atom).getQPropAsInt("c");
                    }
                    if (clg != nextCLG) {
                        closedCLG = true;
                        if (clg > 0) {
                            f = (int)((long)f | 0x40L);
                        }
                    } else {
                        closedCLG = false;
                    }
                    flags[na] = f;
                    ++na;
                    continue;
                }
            }
            if ((next = SmilesExport.findSmallestRankUnvisitedAtom(ranks, visited, ctab[atom])) == -1) continue;
            closedCLG = false;
            int rsnext0 = rsnext;
            int ringatom = this.findUnvisitedRing(atom, next, visited, tmpbool, ranks);
            if (ringatom != -1) {
                int type = btab2[atom * nall + ringatom] & 0xF;
                if (type == 2 || type == 3) {
                    int tmp = next;
                    next = ringatom;
                    ringatom = tmp;
                }
                rsnext = this.pushRings(atom, ringatom, next, rsnext, ringstk, visited, tmpbool, ranks);
            }
            int nrings = (rsnext - rsnext0) / 2;
            if (this.countUnvisitedNeighbors(ctab[atom], visited) - nrings > 1) {
                f = (int)((long)f | 4L);
                bracketstk[bsnext++] = atom;
            }
            rsnext = this.removeRingClosure(ringstk, rsnext, atom, next);
            atom = next;
            flags[na] = f |= (btab2[atom * nall + next] & 0xF) + 1 << 7;
            ++na;
        }
        rsnext = this.removeSuperfluousRings(ringstk, rsnext);
        if (na == nall) {
            SmilesExport.closeRings(rsnext, ringstk, ringAtoms, btab2, order, this.ringNumbers, this.smilesAtoms);
        }
        return na;
    }

    void generateSmilesString(int[] brasta, int[][] ringAtoms) throws MolExportException {
        Molecule mol = this.molecule;
        boolean wrpar = this.wrparinfo;
        boolean wrdbs = this.wrdbsEnabled;
        int na = this.smilesAtoms.length;
        int bras = 0;
        for (int i = 0; i < na; ++i) {
            boolean dbsActive;
            boolean isRingBond;
            boolean explicitBond;
            int here;
            boolean nextAny;
            int atom = this.smilesAtoms[i];
            MolAtom a = mol.getAtom(atom);
            int atno = a.getAtno();
            long f = this.atomFlags[i];
            boolean aromatic = (f & 1L) != 0L;
            boolean anyType = SmilesExport.isAnyType(a) || !this.querySmarts && atno == 136;
            int qAromaticity = 0;
            int h = a.getImplicitHcount();
            if ((f & 0x20L) != 0L) {
                if (!this.querySmarts) {
                    this.throwMolExportExceptionSMILES(mol);
                }
                this.stringBuffer.append('(');
            }
            if (this.simplestForm) {
                if (atno > 0) {
                    String sym = MolAtom.symbolOf(atno);
                    if (aromatic) {
                        sym = sym.toLowerCase();
                    }
                    this.stringBuffer.append(sym);
                }
            } else {
                boolean hasQuery;
                int dbsf;
                boolean fast;
                if (!this.forceQuerySmarts && this.SMILES_strictness > 1) {
                    if (CxsmilesExport.hasNonSupportedCxsmartsAtomFeature(a)) {
                        this.throwMolExportException(mol);
                    }
                    if (this.querySmarts) {
                        if (!this.cx && SmilesExport.hasNonSupportedSmartsAtomFeature(a)) {
                            this.throwMolExportExceptionSMARTS(mol);
                        }
                    } else if (this.cx) {
                        if (CxsmilesExport.hasNonSupportedCxsmilesAtomFeature(a)) {
                            this.throwMolExportExceptionSMILES(mol);
                        }
                    } else if (SmilesExport.hasNonSupportedSmilesAtomFeature(a)) {
                        this.throwMolExportExceptionSMILES(mol);
                    }
                }
                fast = (fast = SmilesExport.isOrganicSubsetLowestNormalValence(a, this.querySmarts, f)) && a.getRadical() == 0;
                boolean bl = fast = fast && !a.hasValenceError();
                if (!(this.querySmarts || !fast || aromatic || atno != 7 && atno != 15 && atno != 16)) {
                    int val = a.getValence();
                    if (!(atno != 15 && atno != 7 || val == 3 || val == 5 && h < 2)) {
                        fast = false;
                    }
                    if (!(atno != 16 || val == 2 || val == 4 && h < 2 || val == 6 && h < 2)) {
                        fast = false;
                    }
                }
                String sym = anyType ? (this.querySmarts ? "A" : "*") : MolAtom.symbolOf(atno);
                qAromaticity = a.getQueryAromaticity();
                if (aromatic && qAromaticity == 0) {
                    if (!(atno != 7 && atno != 15 && atno != 33 && atno != 5 || h == 0 || this.querySmarts)) {
                        fast = false;
                    } else if (atno == 128 || atno == 129) {
                        a.setQueryAromaticity(1);
                    } else if (anyType) {
                        sym = this.querySmarts ? "a" : "*";
                    } else if (this.SMILES_strictness <= 1 || MolAtom.isAromaticSMILESSubset(atno)) {
                        sym = sym.toLowerCase();
                    } else if (this.cx && atno == 5) {
                        sym = sym.toLowerCase();
                    } else {
                        if (!this.querySmarts) {
                            throw new MolExportException("The following atom cannot be aromatic according to the SMILES definition: " + sym);
                        }
                        sym = "[#" + String.valueOf(atno) + "&a]";
                    }
                } else if (qAromaticity == 1) {
                    if (anyType) {
                        sym = this.querySmarts ? "a" : "*";
                    } else if (this.SMILES_strictness <= 1 || MolAtom.isAromaticSMILESSubset(atno)) {
                        sym = sym.toLowerCase();
                    } else {
                        if (!this.querySmarts) {
                            throw new MolExportException("The following atom cannot be aromatic according to the SMILES definition: " + sym);
                        }
                        sym = "[#" + String.valueOf(atno) + "&a]";
                    }
                } else if (qAromaticity == 3) {
                    sym = anyType ? "*" : "[#" + String.valueOf(atno) + "]";
                }
                if (wrdbs && ((dbsf = this.dbsActiveAtoms[i]) & 1) != 0) {
                    int l = this.stringBuffer.length();
                    if (l - 1 > 0 && this.stringBuffer.charAt(l - 1) == '-') {
                        this.stringBuffer.setCharAt(l - 1, (dbsf & 2) != 0 ? (char)'/' : '\\');
                    } else {
                        this.stringBuffer.append((dbsf & 2) != 0 ? (char)'/' : '\\');
                    }
                    if ((dbsf & 4) != 0) {
                        if (!this.querySmarts) {
                            this.throwMolExportExceptionSMILES(mol);
                        }
                        this.stringBuffer.append('?');
                    }
                }
                int aflags = a.getFlags() & 0xFFC0000;
                if (wrpar && !aromatic) {
                    aflags |= this.tetrahedralMol2Smi(this.smilesAtoms[i], ringAtoms);
                    aflags |= SmilesExport.allenMol2Smi(this.smilesAtoms[i], this.ctab2smi, mol);
                }
                boolean hasprop = a.getCharge() != 0 || a.getMassno() != 0 || aflags != 0;
                boolean bl2 = hasQuery = atno == 132 || atno == 133 || atno == 128 || atno == 129 || a.getQueryString() != null || SmartsAtomQuerifier.hasSMARTSPropsExcluding(a, "a");
                if (fast && !hasprop && !hasQuery && (atno <= 109 || anyType)) {
                    this.stringBuffer.append(sym);
                } else if (atno == 134) {
                    MoleculeGraph m = a.getParent();
                    m = m != null ? m.getParent() : null;
                    RgMolecule rgm = m != null && m instanceof RgMolecule ? (RgMolecule)m : null;
                    MoleculeGraph mp = m != null ? m.getParent() : null;
                    RgMolecule rgMolecule = rgm = rgm == null && mp != null && mp instanceof RgMolecule ? (RgMolecule)mp : rgm;
                    if (rgm == null) {
                        if (!this.querySmarts) {
                            this.stringBuffer.append("[*]");
                        } else {
                            String queryStr = a.getQueryString();
                            if (queryStr == null || queryStr == "") {
                                this.stringBuffer.append("[$([#1,*])]");
                            } else {
                                this.stringBuffer.append(queryStr);
                            }
                        }
                    } else if (this.rgToRecursiveSmarts) {
                        int members;
                        int rg = a.getRgroup();
                        int rgi = rgm.findRgroupIndex(rg);
                        int n = members = rgi >= 0 ? rgm.getRgroupMemberCount(rgi) : 0;
                        if (members > 0) {
                            this.stringBuffer.append("[");
                            for (int j = 0; j < members; ++j) {
                                Molecule rgmember = rgm.getRgroupMember(rgi, j).cloneMolecule();
                                SmilesExport.writeRGroup(rgmember, this.stringBuffer, this.forceQuerySmarts);
                                if (j >= members - 1) continue;
                                this.stringBuffer.append("),");
                            }
                            this.stringBuffer.append(")]");
                        } else if (!this.querySmarts) {
                            this.stringBuffer.append("[*]");
                        } else {
                            this.stringBuffer.append("[$([#1,*])]");
                        }
                    } else {
                        this.stringBuffer.append("[*]");
                    }
                } else if (atno != 130) {
                    if (atno == 0) {
                        this.stringBuffer.append("[#0]");
                    } else if (atno == 131 && !hasprop && !hasQuery) {
                        this.stringBuffer.append(sym);
                    } else if (this.querySmarts) {
                        this.stringBuffer.append(a.getAtomSymbol(17, aflags, null, null));
                    } else {
                        String symbol = atno == 132 || atno == 133 ? "*" : a.getAtomSymbol(1 | (this.cx ? 64 : 0), aflags, null, null);
                        this.stringBuffer.append(symbol);
                    }
                }
            }
            int[] btab2 = this.origBtab2;
            BondTable btab = mol.getBondTable();
            int[] rings = this.ringNumbers[atom];
            for (int j = rings.length - 1; j >= 0; --j) {
                int rn;
                boolean explicitBond2;
                int r = rings[j];
                if (r == -1) continue;
                int nextIdx = ringAtoms[atom][j];
                int bf = btab2[atom * na + nextIdx];
                int bt = bf & 0xF;
                MolAtom nextA = mol.getAtom(nextIdx);
                int qArom2 = nextA.getQueryAromaticity();
                String queryStr = mol.getBond(btab.getBondIndex(atom, nextIdx)).getQuerystr();
                nextAny = nextA.getAtno() == 131;
                boolean bl = explicitBond2 = this.querySmarts && bt == 4 && (atno == 131 || nextAny);
                if (explicitBond2) {
                    this.appendBond(this.stringBuffer, bf, queryStr, this.querySmarts, false, mol);
                } else if (bt != 1 && bt != 4 && (bt != 6 || qAromaticity != 3 || qArom2 != 3)) {
                    this.appendBond(this.stringBuffer, bf, queryStr, this.querySmarts, false, mol);
                } else if (bt == 1 && aromatic && (this.atomFlags[this.ctab2smi[nextIdx]] & 1L) != 0L) {
                    this.stringBuffer.append('-');
                } else if (wrdbs && ((rn = this.dbsActiveRingAtomFlags[i][j]) & 1) != 0) {
                    this.stringBuffer.append((rn & 2) != 0 ? (char)'/' : '\\');
                    if ((rn & 4) != 0) {
                        if (!this.querySmarts) {
                            this.throwMolExportExceptionSMILES(mol);
                        }
                        this.stringBuffer.append('?');
                    }
                }
                if (r >= 10) {
                    this.stringBuffer.append('%');
                }
                this.stringBuffer.append(r);
            }
            int next = i + 1;
            int nextIdx = next < na ? this.smilesAtoms[next] : -1;
            int bt = (int)(f >> 7 & 0xFL) - 1;
            boolean sbia = false;
            if ((f & 8L) != 0L) {
                int sblength;
                this.stringBuffer.append(')');
                if (this.simplestForm && this.stringBuffer.charAt((sblength = this.stringBuffer.length()) - 2) == '(') {
                    this.stringBuffer.setLength(sblength - 2);
                }
                int atko = brasta[bras - 1];
                int j = i + 1;
                if (bt == 1 && nextIdx != -1 && (f & 4L) == 0L && (this.atomFlags[j] & this.atomFlags[atko] & 1L) != 0L) {
                    if (wrdbs) {
                        int dbsf = this.dbsActiveAtoms[j];
                        if ((dbsf & 1) != 0) {
                            this.stringBuffer.append((dbsf & 2) != 0 ? (char)'/' : '\\');
                            if ((dbsf & 4) != 0) {
                                if (!this.querySmarts) {
                                    this.throwMolExportExceptionSMILES(mol);
                                }
                                this.stringBuffer.append('?');
                            }
                        } else {
                            this.stringBuffer.append('-');
                        }
                    } else {
                        this.stringBuffer.append('-');
                    }
                    sbia = true;
                }
            }
            if ((f & 0x40L) != 0L) {
                if (!this.querySmarts) {
                    this.throwMolExportExceptionSMILES(mol);
                }
                this.stringBuffer.append(')');
            }
            if (nextIdx == -1) {
                return;
            }
            if ((f & 0x10L) != 0L) {
                this.stringBuffer.append('.');
                continue;
            }
            if ((f & 4L) != 0L) {
                this.stringBuffer.append('(');
                if ((f & 8L) == 0L) {
                    brasta[bras++] = i;
                } else {
                    brasta[bras] = brasta[bras - 1];
                    ++bras;
                }
            }
            if ((f & 8L) != 0L) {
                here = bras - 1 >= 0 ? brasta[bras - 1] : brasta[bras];
                --bras;
                atom = this.smilesAtoms[here];
                a = mol.getAtom(atom);
                f = this.atomFlags[here];
                aromatic = (f & 1L) != 0L;
                qAromaticity = a.getQueryAromaticity();
                atno = a.getAtno();
            } else {
                here = i;
            }
            int bf = btab2[atom * na + nextIdx];
            bt = bf & 0xF;
            String queryStr = mol.getBond(btab.getBondIndex(atom, nextIdx)).getQuerystr();
            MolAtom nextA = mol.getAtom(nextIdx);
            nextAny = nextA.getAtno() == 131;
            boolean bl = explicitBond = this.querySmarts && bt == 4 && (atno == 131 || nextAny);
            if (explicitBond) {
                this.appendBond(this.stringBuffer, bf, queryStr, this.querySmarts, false, mol);
                continue;
            }
            boolean arom2 = (this.atomFlags[next] & 1L) != 0L;
            int qArom2 = nextA.getQueryAromaticity();
            int bondIdx = this.origBtab.getBondIndex(this.smilesAtoms[here], nextIdx);
            int sbondIdx = this.smilesBondIdx[bondIdx];
            boolean bl3 = this.wrdbsEnabled ? (this.dbsActiveBonds[sbondIdx][0] & 0x10) != 0 : (isRingBond = this.ringbond[bondIdx]);
            boolean bl4 = this.wrdbsEnabled ? (this.dbsActiveAtoms[next] & 1) != 0 : (dbsActive = false);
            if (bt == 1) {
                if (bf != 1) {
                    this.appendBond(this.stringBuffer, bf, queryStr, this.querySmarts, this.setTerminalAtomArom, mol);
                    continue;
                }
                if ((aromatic || qAromaticity > 0 && qAromaticity != 2) && (arom2 || qArom2 > 0 && qArom2 != 2) && !dbsActive && !sbia && !this.setTerminalAtomArom) {
                    this.appendBond(this.stringBuffer, bf, queryStr, this.querySmarts, this.setTerminalAtomArom, mol);
                    continue;
                }
                if (!this.querySmarts || atno != 131 || qAromaticity != 0 || !nextAny || qArom2 != 0) continue;
                this.appendBond(this.stringBuffer, bf, queryStr, this.querySmarts, false, mol);
                continue;
            }
            if (!(bt != 4 || isRingBond && aromatic && arom2 && bf == 4)) {
                this.appendBond(this.stringBuffer, bf, queryStr, this.querySmarts, false, mol);
                continue;
            }
            if (bt == 6 && (bf != 6 || !aromatic && qAromaticity != 1 && qAromaticity != 3 || !arom2 && qArom2 != 1 && qArom2 != 3)) {
                this.appendBond(this.stringBuffer, bf, queryStr, this.querySmarts, false, mol);
                continue;
            }
            if (bt != 0 && bt != 2 && bt != 3 && bt != 5 && bt != 7) continue;
            this.appendBond(this.stringBuffer, bf, queryStr, this.querySmarts, false, mol);
        }
    }

    private static void writeRGroup(Molecule rgmember, StringBuffer sb, boolean forceQuerySmarts) {
        int startIdx = SmilesExport.removeAttachmentAtoms(rgmember);
        startIdx = startIdx == -1 ? 0 : startIdx;
        sb.append("$(");
        if (forceQuerySmarts) {
            String s;
            try {
                s = MolExporter.exportToFormat(rgmember, "smarts:S");
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            sb.append(s);
        } else {
            String s;
            try {
                s = MolExporter.exportToFormat(rgmember, "smarts:I" + startIdx);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            sb.append(s);
        }
    }

    void appendTopology(StringBuffer s, int f, boolean querySmarts, Molecule mol) throws MolExportException {
        int topology = f & 0xC00;
        if (topology != 0 && !querySmarts) {
            this.throwMolExportExceptionSMILES(mol);
        }
        if (topology == 1024) {
            s.append("@");
        } else if (topology == 2048) {
            s.append("!@");
        }
    }

    void appendBond(StringBuffer s, int f, String q, boolean querySmarts, boolean setTAA, Molecule mol) throws MolExportException {
        if ((f & 0x10) == 16) {
            s.append(q);
            if (!querySmarts) {
                this.throwMolExportExceptionCXSMILES(mol);
            }
            return;
        }
        int type = f & 0xF;
        if (!(type <= 4 && type >= 1 || querySmarts || this.cx && type == 9)) {
            this.throwMolExportExceptionSMILES(mol);
        }
        int topology = f & 0xC00;
        this.appendTopology(s, f, querySmarts, mol);
        if (type == 1) {
            if (!setTAA || topology == 0) {
                s.append("-");
            }
        } else if (type == 2) {
            s.append("=");
        } else if (type == 3) {
            s.append("#");
        } else if (type == 4) {
            s.append(":");
        } else if (type == 0 && topology == 0) {
            s.append("~");
        } else if (type == 5) {
            s.append("-,");
            this.appendTopology(s, f, querySmarts, mol);
            s.append("=");
        } else if (type == 6) {
            if (topology == 0) {
                s.append("-,:");
            }
        } else if (type == 7) {
            s.append("=,");
            this.appendTopology(s, f, querySmarts, mol);
            s.append(":");
        }
    }

    public final int[] getSmilesAtomOrder() {
        return this.smilesAtoms;
    }

    private int pushRings(int atom, int ringatom, int next, int rsnext, int[] ringstk, boolean[] visited, boolean[] tmpbool, int[] ranks) {
        ringstk[rsnext++] = atom;
        ringstk[rsnext++] = ringatom;
        int[] neighbors = this.origCtab[atom];
        for (int i = 0; i < neighbors.length; ++i) {
            int r;
            int k = neighbors[i];
            if (k == next || k == ringatom || visited[k] || (r = this.findUnvisitedRing(atom, k, visited, tmpbool, ranks)) < 0) continue;
            ringstk[rsnext++] = atom;
            ringstk[rsnext++] = k;
        }
        return rsnext;
    }

    private int removeRingClosure(int[] ringstk, int rsnext, int b1, int b2) {
        int i = rsnext;
        while (i >= 2) {
            int a1;
            int a2 = ringstk[--i];
            if ((a1 = ringstk[--i]) != b1 || a2 != b2) continue;
            System.arraycopy(ringstk, i + 2, ringstk, i, (rsnext -= 2) - i);
        }
        return rsnext;
    }

    private int removeSuperfluousRings(int[] ringstk, int rsnext) {
        int i = rsnext;
        block0: while (i >= 2) {
            int b2 = ringstk[--i];
            int b1 = ringstk[--i];
            int j = i;
            while (j >= 2) {
                int a1;
                int a2 = ringstk[--j];
                if ((a1 = ringstk[--j]) != b1 || a2 != b2) continue;
                System.arraycopy(ringstk, i + 2, ringstk, i, (rsnext -= 2) - i);
                continue block0;
            }
        }
        return rsnext;
    }

    private static void closeRings(int rsnext, int[] ringstk, int[][] ringAtoms, int[] btab2, int[] order, int[][] ringNumbers, int[] smilesAtoms) {
        int[] ringConv = new int[rsnext / 2 + 1];
        for (int nrings = rsnext / 2; nrings > 0; --nrings) {
            int fc;
            int fr;
            int i1 = ringstk[--rsnext];
            int i2 = ringstk[--rsnext];
            int ringatom = order[i1];
            int closeatom = order[i2];
            int[] rs = ringNumbers[i1];
            for (fr = 0; fr < rs.length && rs[fr] != -1; ++fr) {
            }
            rs[fr] = nrings;
            ringAtoms[i1][fr] = i2;
            rs = ringNumbers[i2];
            for (fc = 0; fc < rs.length && rs[fc] != -1; ++fc) {
            }
            rs[fc] = nrings;
            ringAtoms[i2][fc] = i1;
            if (fc == 0) continue;
            SmilesExport.fixUniqueness(ringatom, fr, closeatom, fc, ringAtoms, ringNumbers, smilesAtoms);
        }
        BitSet usedNumbers = new BitSet(ringConv.length);
        for (int i = 0; i < smilesAtoms.length; ++i) {
            int atom = smilesAtoms[i];
            int[] rings = ringNumbers[atom];
            for (int j = rings.length - 1; j >= 0; --j) {
                int ringNo;
                int n = rings[j];
                if (n < 0) continue;
                if (ringConv[n] > 0) {
                    ringNo = ringConv[n];
                    usedNumbers.clear(ringNo);
                    rings[j] = ringNo;
                    continue;
                }
                ringConv[n] = ringNo = usedNumbers.nextClearBit(1);
                rings[j] = ringNo;
                usedNumbers.set(ringNo);
            }
        }
    }

    private static void fixUniqueness(int ringatom, int fr, int closeatom, int fc, int[][] ringAtoms, int[][] rings, int[] smilesAtoms) {
        int aclose = smilesAtoms[closeatom];
        int aring = smilesAtoms[ringatom];
        for (int i = closeatom + 1; i < ringatom; ++i) {
            int[] ringsi = rings[smilesAtoms[i]];
            for (int j = 0; j < ringsi.length; ++j) {
                int fca;
                int rij = ringsi[j];
                if (rij == -1 || rij != rings[aclose][fca = fc - 1]) continue;
                rings[aring][fr] = rings[aclose][fca];
                ringsi[j] = rings[aclose][fc];
                int t = ringAtoms[aclose][fca];
                ringAtoms[aclose][fca] = ringAtoms[aclose][fc];
                ringAtoms[aclose][fc] = t;
                if (fca > 0) {
                    SmilesExport.fixUniqueness(ringatom, fr, closeatom, fca, ringAtoms, rings, smilesAtoms);
                }
                return;
            }
        }
    }

    private static final int findSmallestRankUnvisitedAtom(int[] ranks, boolean[] visited) {
        int min = 0;
        int j = -1;
        for (int i = 0; i < ranks.length; ++i) {
            if (visited[i] || j != -1 && ranks[i] >= min) continue;
            min = ranks[i];
            j = i;
        }
        return j;
    }

    private static final int findSmallestRankUnvisitedAtom(int[] ranks, boolean[] visited, int[] an) {
        int min = visited.length + 1;
        int j = -1;
        for (int i = 0; i < an.length; ++i) {
            int k = an[i];
            if (visited[k] || ranks[k] >= min) continue;
            min = ranks[k];
            j = k;
        }
        return j;
    }

    private int countUnvisitedNeighbors(int[] neighbors, boolean[] visited) {
        int count = 0;
        for (int i = neighbors.length - 1; i >= 0; --i) {
            if (visited[neighbors[i]]) continue;
            ++count;
        }
        return count;
    }

    private int findUnvisitedRing(int start, int branch, boolean[] visited, boolean[] tmpbool, int[] ranks) {
        int idx;
        int i;
        int[] an = this.origCtab[start];
        int l = an.length;
        int[] an_ordered = new int[l];
        System.arraycopy(an, 0, an_ordered, 0, l);
        int[] r = new int[l];
        for (i = 0; i < l; ++i) {
            idx = an[i];
            r[i] = ranks[idx];
        }
        ArrayTools.sortDescending(r, an_ordered);
        for (i = l - 1; i >= 0; --i) {
            idx = an_ordered[i];
            if (idx == branch || visited[idx]) continue;
            System.arraycopy(visited, 0, tmpbool, 0, visited.length);
            if (!this.areConnected(start, idx, branch, tmpbool)) continue;
            return idx;
        }
        return -1;
    }

    private boolean areConnected(int start, int next, int target, boolean[] visited) {
        for (int k : this.origCtab[next]) {
            if (k == start || visited[k]) continue;
            visited[k] = true;
            if (k != target && !this.areConnected(next, k, target, visited)) continue;
            return true;
        }
        return false;
    }

    private void createBtab2() {
        int i;
        Molecule mol = this.molecule;
        int na = mol.getAtomCount();
        int[][] ctab = this.origCtab;
        BondTable btab = this.origBtab;
        this.origBtab2 = new int[na * na];
        int[] btab2 = this.origBtab2;
        int[] tmp = new int[na];
        for (i = 0; i < na; ++i) {
            tmp[i] = -1;
        }
        for (i = 0; i < na; ++i) {
            System.arraycopy(tmp, 0, btab2, i * na, na);
        }
        for (i = 0; i < na; ++i) {
            int[] neighbors = ctab[i];
            for (int j = 0; j < neighbors.length; ++j) {
                int iaa = neighbors[j];
                MolBond b = mol.getBond(btab.getBondIndex(i, iaa));
                int f = b.getFlags() & 0xDCF;
                if ((f & 0xF) == 0 && b.getQuerystr() != null) {
                    f |= 0x10;
                }
                int n = f;
                btab2[iaa * na + i] = n;
                btab2[i * na + iaa] = n;
            }
        }
    }

    private int tetrahedralMol2Smi(int atomIndex, int[][] ringAtoms) {
        boolean isUnspec;
        Molecule mol = this.molecule;
        int l = this.origCtab[atomIndex].length;
        if (l > 4 || l < 3) {
            return 0;
        }
        int hIndex = this.origCtab.length + 10;
        int nOfAtoms = this.origCtab.length;
        int par = this.querySmarts ? this.molecule.getLocalParity(atomIndex) : this.molecule.getParity(atomIndex);
        par = par != 0 && this.molecule.getParityType(atomIndex) != 1 ? 0 : par;
        boolean bl = isUnspec = (par & 4) == 4;
        if ((par &= 3) == 1 || par == 2) {
            int connAtom1;
            int i;
            boolean[] hidrogens = new boolean[2];
            int[] atomorder = SmilesExport.orderMolType(atomIndex, hidrogens, this.origCtab, mol);
            int a = atomorder[0];
            int b = atomorder[1];
            int c = atomorder[2];
            int d = atomorder[3];
            if (c == d) {
                return 0;
            }
            boolean implH = hidrogens[0];
            boolean explH = hidrogens[1];
            int expHSmi = explH ? this.ctab2smi[atomorder[4]] : -1;
            int pSignMol = MolAtom.paritySign(a, b, c, d);
            int smiAtIdx = this.ctab2smi[atomIndex];
            int smiFromAtomIdx = -1;
            if (smiAtIdx > 0) {
                int i2;
                int[] tmp = new int[4];
                int possFromAtomLength = 0;
                for (i2 = 0; i2 < 5; ++i2) {
                    if (atomorder[i2] >= nOfAtoms || this.ctab2smi[atomorder[i2]] >= smiAtIdx) continue;
                    tmp[possFromAtomLength++] = this.ctab2smi[atomorder[i2]];
                }
                i2 = 1;
                while (smiAtIdx - i2 >= 0) {
                    for (int j = 0; j < possFromAtomLength; ++j) {
                        if (smiAtIdx - i2 != tmp[j]) continue;
                        smiFromAtomIdx = smiAtIdx - i2;
                        i2 = nOfAtoms;
                        break;
                    }
                    ++i2;
                }
            } else if (implH) {
                smiFromAtomIdx = smiAtIdx;
            } else {
                int ringconn = -1;
                i = 0;
                l = this.ringNumbers[atomIndex].length;
                while (this.ringNumbers[atomIndex][i] >= 0 && i < l) {
                    ringconn = this.ctab2smi[ringAtoms[atomIndex][i++]];
                }
                if (ringconn >= 0) {
                    smiFromAtomIdx = ringconn;
                } else {
                    int[] tmp = new int[4];
                    int possFromAtomLength = 0;
                    for (i = 0; i < 5; ++i) {
                        if (atomorder[i] >= nOfAtoms) continue;
                        tmp[possFromAtomLength++] = this.ctab2smi[atomorder[i]];
                    }
                    i = 1;
                    while (smiAtIdx + i < nOfAtoms) {
                        for (int j = 0; j < possFromAtomLength; ++j) {
                            if (smiAtIdx + i != tmp[j]) continue;
                            smiFromAtomIdx = smiAtIdx + i;
                            i = nOfAtoms;
                            break;
                        }
                        ++i;
                    }
                }
            }
            int ringConn = 0;
            for (i = 0; i < this.ringNumbers[atomIndex].length; ++i) {
                if (this.ringNumbers[atomIndex][i] < 0) continue;
                ++ringConn;
            }
            int c2a = this.ctab2smi[a];
            int c2b = this.ctab2smi[b];
            int c2c = this.ctab2smi[c];
            int c2d = d < nOfAtoms ? this.ctab2smi[d] : d;
            c2a = c2a == smiFromAtomIdx ? hIndex + 1 : c2a;
            c2b = c2b == smiFromAtomIdx ? hIndex + 1 : c2b;
            c2c = c2c == smiFromAtomIdx ? hIndex + 1 : c2c;
            c2d = c2d == smiFromAtomIdx ? hIndex + 1 : c2d;
            int n = expHSmi = expHSmi == smiFromAtomIdx ? c2d : expHSmi;
            if (ringConn == 0) {
                a = c2a;
                b = c2b;
                c = c2c;
                d = explH ? expHSmi : c2d;
            } else if (ringConn == 1) {
                connAtom1 = this.ctab2smi[ringAtoms[atomIndex][0]];
                int n2 = c2a == smiFromAtomIdx ? c2a : (c2a == connAtom1 ? smiAtIdx + 1 : (a = c2a < smiAtIdx ? c2a : c2a + 1));
                int n3 = c2b == smiFromAtomIdx ? c2b : (c2b == connAtom1 ? smiAtIdx + 1 : (b = c2b < smiAtIdx ? c2b : c2b + 1));
                int n4 = c2c == smiFromAtomIdx ? c2c : (c2c == connAtom1 ? smiAtIdx + 1 : (c = c2c < smiAtIdx ? c2c : c2c + 1));
                d = explH ? (expHSmi < smiAtIdx ? expHSmi : expHSmi + 1) : (c2d == smiFromAtomIdx ? c2d : (c2d == connAtom1 ? smiAtIdx + 1 : (c2d < smiAtIdx ? c2d : c2d + 1)));
            } else if (ringConn == 2) {
                connAtom1 = this.ctab2smi[ringAtoms[atomIndex][1]];
                int connAtom2 = this.ctab2smi[ringAtoms[atomIndex][0]];
                int n5 = c2a == smiFromAtomIdx ? c2a : (c2a == connAtom1 ? smiAtIdx + 1 : (c2a == connAtom2 ? smiAtIdx + 2 : (a = c2a < smiAtIdx ? c2a : c2a + 2)));
                int n6 = c2b == smiFromAtomIdx ? c2b : (c2b == connAtom1 ? smiAtIdx + 1 : (c2b == connAtom2 ? smiAtIdx + 2 : (b = c2b < smiAtIdx ? c2b : c2b + 2)));
                int n7 = c2c == smiFromAtomIdx ? c2c : (c2c == connAtom1 ? smiAtIdx + 1 : (c2c == connAtom2 ? smiAtIdx + 2 : (c = c2c < smiAtIdx ? c2c : c2c + 2)));
                d = explH ? (expHSmi < smiAtIdx ? expHSmi : expHSmi + 2) : (c2d == smiFromAtomIdx ? c2d : (c2d == connAtom1 ? smiAtIdx + 1 : (c2d == connAtom2 ? smiAtIdx + 2 : (c2d < smiAtIdx ? c2d : c2d + 2))));
            } else {
                connAtom1 = this.ctab2smi[ringAtoms[atomIndex][2]];
                int connAtom2 = this.ctab2smi[ringAtoms[atomIndex][1]];
                int connAtom3 = this.ctab2smi[ringAtoms[atomIndex][0]];
                int n8 = c2a == smiFromAtomIdx ? c2a : (c2a == connAtom1 ? smiAtIdx + 1 : (c2a == connAtom2 ? smiAtIdx + 2 : (c2a == connAtom3 ? smiAtIdx + 3 : (a = c2a < smiAtIdx ? c2a : c2a + 3))));
                int n9 = c2b == smiFromAtomIdx ? c2b : (c2b == connAtom1 ? smiAtIdx + 1 : (c2b == connAtom2 ? smiAtIdx + 2 : (c2b == connAtom3 ? smiAtIdx + 3 : (b = c2b < smiAtIdx ? c2b : c2b + 3))));
                int n10 = c2c == smiFromAtomIdx ? c2c : (c2c == connAtom1 ? smiAtIdx + 1 : (c2c == connAtom2 ? smiAtIdx + 2 : (c2c == connAtom3 ? smiAtIdx + 3 : (c = c2c < smiAtIdx ? c2c : c2c + 3))));
                d = explH ? (expHSmi < smiAtIdx ? expHSmi : expHSmi + 3) : (c2d == smiFromAtomIdx ? c2d : (c2d == connAtom1 ? smiAtIdx + 1 : (c2d == connAtom2 ? smiAtIdx + 2 : (c2d == connAtom3 ? smiAtIdx + 3 : (c2d < smiAtIdx ? c2d : c2d + 3)))));
            }
            int pSignSmi = MolAtom.paritySign(a, b, c, d);
            if (pSignMol != pSignSmi) {
                par ^= 0xFFFFFFFF;
                par &= 3;
            }
            if (isUnspec) {
                par |= 4;
            }
        } else {
            par = 0;
        }
        return par;
    }

    private static int allenMol2Smi(int idx, int[] ctab2smi, MoleculeGraph m) {
        boolean isUnspec;
        int par = m.getParity(idx);
        par = par != 0 && m.getParityType(idx) != 2 ? 0 : par;
        boolean bl = isUnspec = (par & 4) == 4;
        if ((par &= 3) == 1 || par == 2) {
            int[] catom = new int[]{-1, -1, -1, -1};
            int[][] ctab = m.getCtab();
            int[] idxes = SmilesExport.getAllenicLigands(catom, idx, ctab, m);
            if (idxes != null) {
                int ac = m.getAtomCount();
                int pSignMol = MolAtom.paritySign(idxes[0], idxes[1], idxes[2], idxes[3]);
                int[] smiIdxs = new int[]{idxes[0] < ac ? ctab2smi[idxes[0]] : ctab2smi[catom[0]], idxes[1] < ac ? ctab2smi[idxes[1]] : ctab2smi[catom[1]], idxes[2] < ac ? ctab2smi[idxes[2]] : ctab2smi[catom[2]], idxes[3] < ac ? ctab2smi[idxes[3]] : ctab2smi[catom[3]]};
                int pSignSmi = MolAtom.paritySign(smiIdxs[0], smiIdxs[1], smiIdxs[2], smiIdxs[3]);
                if (pSignMol == pSignSmi) {
                    par ^= 0xFFFFFFFF;
                    par &= 3;
                }
                if (isUnspec) {
                    par |= 4;
                }
            } else {
                par = 0;
            }
        } else {
            par = 0;
        }
        return par;
    }

    static int[] getAllenicLigands(int[] clig, int idx, int[][] ctab, MoleculeGraph m) {
        int[] an = ctab[idx];
        int l = an.length;
        if (l != 2 || !SmilesExport.hasOnlyDoubleBond(m.getAtom(idx))) {
            return null;
        }
        int[] o = new int[4];
        int n = 0;
        int cn = 0;
        int depth = 0;
        for (int i = 0; i < l; ++i) {
            int lig = an[i];
            int from = idx;
            int d = 0;
            BitSet used = new BitSet();
            do {
                used.set(lig);
                int[] an_l = ctab[lig];
                MolAtom ligand = m.getAtom(lig);
                int an_ll = an_l.length;
                if (an_ll == 2 && SmilesExport.hasOnlyDoubleBond(ligand)) {
                    int next = SmilesExport.getIndexNotTo(from, an_l);
                    from = lig;
                    lig = next;
                    ++d;
                    if (!used.get(lig)) continue;
                    return null;
                }
                if (an_ll < 4) {
                    for (int j = 0; j < an_ll; ++j) {
                        int index = an_l[j];
                        if (index == from) continue;
                        o[n] = SmilesExport.isHydrogen(m.getAtom(index)) ? (n < 2 ? Integer.MAX_VALUE : 0x7FFFFFFD) : index;
                        ++n;
                        if (clig == null) continue;
                        clig[cn++] = lig;
                    }
                    if (an_ll == 2) {
                        o[n] = n < 2 ? Integer.MAX_VALUE : 0x7FFFFFFD;
                        ++n;
                        if (clig != null) {
                            clig[cn++] = lig;
                        }
                    } else if (an_ll < 2) {
                        return null;
                    }
                    from = -1;
                    continue;
                }
                return null;
            } while (from >= 0);
            if (i == 0) {
                depth = d;
                continue;
            }
            if (depth == d) continue;
            return null;
        }
        return o;
    }

    private static boolean hasOnlyDoubleBond(MolAtom a) {
        int bc = a.getBondCount();
        for (int i = 0; i < bc; ++i) {
            MolBond b = a.getBond(i);
            if (b.getType() == 2) continue;
            return false;
        }
        return true;
    }

    private static int getIndexNotTo(int idx, int[] an) {
        int l = an.length;
        for (int i = 0; i < l; ++i) {
            if (an[i] == idx) continue;
            return an[i];
        }
        return -1;
    }

    private static final int[] orderMolType(int idx, boolean[] hs, int[][] ctab, MoleculeGraph m) {
        int i;
        int[] order = new int[5];
        int nOfAtoms = ctab.length;
        int idxH = nOfAtoms + 10;
        order[4] = idxH + 1;
        int explicitHidx = -1;
        if (ctab[idx].length == 3) {
            order[3] = idxH;
            hs[0] = true;
        }
        for (i = 0; i < ctab[idx].length; ++i) {
            int lig = ctab[idx][i];
            MolAtom a = m.getAtom(lig);
            if (a.getAtno() == 1 && a.getMassno() == 0) {
                order[i] = idxH;
                hs[1] = true;
                explicitHidx = lig;
                continue;
            }
            order[i] = lig;
        }
        i = 1;
        do {
            if (order[i - 1] > order[i]) {
                int tmp = order[i - 1];
                order[i - 1] = order[i];
                order[i] = tmp;
                i = 1;
                continue;
            }
            ++i;
        } while (i < 4);
        if (hs[1]) {
            order[4] = explicitHidx;
        }
        return order;
    }

    private void initStereo1(MoleculeGraph m) {
        int ac = this.origCtab.length;
        this.branchDepth = new int[ac];
        int actdepth = 0;
        for (int i = 0; i < ac; ++i) {
            this.branchDepth[i] = actdepth++;
            long af = this.atomFlags[i];
            if ((af & 4L) != 0L) {
                // empty if block
            }
            if ((af & 8L) == 0L) continue;
            --actdepth;
        }
    }

    private void initStereo2(BondTable btab) throws MolExportException {
        int i;
        Molecule mol = this.molecule;
        int[][] rings = this.ringNumbers;
        int nbonds = mol.getBondCount();
        int[][] dbsab = new int[nbonds][9];
        this.dbsActiveBonds = dbsab;
        boolean hasCTUnspecDoubleBond = false;
        for (int i2 = 0; i2 < nbonds; ++i2) {
            MolBond b = mol.getBond(this.smiToOrigBondIdx[i2]);
            int type = b.getType();
            int f = b.getFlags();
            if (SmilesExport.canBeCTBond(type) || type == 2 || type == 0) {
                dbsab[i2][0] = 2;
            }
            if (type != 2 || (f & 0x100) != 256) continue;
            hasCTUnspecDoubleBond = true;
        }
        int[][] ctab = this.origCtab;
        int natoms = ctab.length;
        this.dbsActiveAtoms = new int[natoms];
        this.dbsActiveRingAtomFlags = new int[natoms][];
        for (i = 0; i < natoms; ++i) {
            this.dbsActiveRingAtomFlags[i] = new int[rings[this.smilesAtoms[i]].length];
        }
        this.grabDBSActiveBonds(btab);
        for (i = 0; i < dbsab.length; ++i) {
            int[] nArray = dbsab[i];
            nArray[0] = nArray[0] & 0xFFFFFFFE;
        }
        this.walkIslands();
        if (this.cx) {
            SmilesExport.removeFCXCTFlag(dbsab, mol, this.smiToOrigBondIdx);
        }
        SmilesExport.removeActiveWithoutConn(dbsab);
        if (hasCTUnspecDoubleBond) {
            this.setupUnspecForSingleBonds();
            this.removeUnspecAroundDoubleBonds();
            this.removeUnnecessaryUnspec();
            if (!this.checkUnspecAtSingleBonds()) {
                System.err.println("Warning: \nThe molecule has double bond with unspec flag which is supressed in the SMARTS string.");
            }
        }
        for (i = 0; i < dbsab.length; ++i) {
            if (dbsab[i][1] == dbsab[i][2]) continue;
            int[] nArray = dbsab[i];
            nArray[0] = nArray[0] | 1;
        }
        this.writeRecipe();
    }

    private void grabDBSActiveBonds(BondTable btab) throws MolExportException {
        int f;
        int i;
        int[][] dbsab = this.dbsActiveBonds;
        Molecule mol = this.molecule;
        if (logger.isLoggable(FINE) && DEBUG_DB_FLAGS) {
            logger.fine("Mine active doublebonds from rings");
        }
        int[][] sssr = mol.getSSSR();
        for (int isr = 0; isr < sssr.length; ++isr) {
            int nn;
            int p;
            int n;
            int h;
            int[] sr = sssr[isr];
            boolean alternating = true;
            int nOfCisDB = 0;
            int nOfNRB = 0;
            int siz = sr.length;
            if (logger.isLoggable(FINEST) && DEBUG_DB_FLAGS) {
                logger.finest(isr + "th ring size:" + siz);
            }
            int prevType = -1;
            for (int ib = 0; ib < siz; ++ib) {
                h = sr[ib];
                n = sr[(ib + 1) % siz];
                int idx = btab.getBondIndex(h, n);
                int sidx = this.smilesBondIdx[idx];
                MolBond b = mol.getBond(idx);
                int typ = b.getType();
                if (alternating) {
                    if (prevType == -1) {
                        p = sr[siz - 1];
                        prevType = mol.getBond(btab.getBondIndex(p, h)).getType();
                    }
                    if (!(prevType == 1 && typ == 2 || prevType == 2 && typ == 1)) {
                        alternating = false;
                    }
                }
                int f2 = dbsab[sidx][0];
                f2 |= 0x10;
                int[] nArray = dbsab[sidx];
                nArray[8] = nArray[8] + 1;
                if (dbsab[sidx][8] == 2) {
                    f2 &= 0xFFFFFBFF;
                }
                if (siz < 8) {
                    f2 |= 0x40;
                }
                if (typ == 2) {
                    p = sr[(ib + siz - 1) % siz];
                    nn = sr[(ib + 2) % siz];
                    int b12Idx = btab.getBondIndex(p, h);
                    int b34Idx = btab.getBondIndex(n, nn);
                    int sb12Idx = this.smilesBondIdx[b12Idx];
                    int sb34Idx = this.smilesBondIdx[b34Idx];
                    MolBond b12 = mol.getBond(b12Idx);
                    MolBond b34 = mol.getBond(b34Idx);
                    this.setDBSProps4Bond(sidx);
                    f2 |= dbsab[sidx][0];
                    int b12Type = b12.getType();
                    int b34Type = b34.getType();
                    if (!(b12Type != 1 && b12Type != 4 || b34Type != 1 && b34Type != 4)) {
                        MolAtom a1 = mol.getAtom(p);
                        MolAtom a4 = mol.getAtom(nn);
                        if (dbsab[sidx][1] == h) {
                            dbsab[sidx][5] = sb12Idx;
                            dbsab[sidx][6] = sb34Idx;
                        } else {
                            dbsab[sidx][5] = sb34Idx;
                            dbsab[sidx][6] = sb12Idx;
                        }
                        int bf = (f2 & 0x40) != 0 ? (mol.canBeCT(h, n) ? 128 : 0) : mol.getStereo2(b, a1, a4, this.gInvCheck);
                        int stereo = bf & 0xC0;
                        if (logger.isLoggable(FINEST) && DEBUG_DB_FLAGS) {
                            logger.finest(ib + " bond stereo " + (mol.indexOf(b.getCTAtom1()) + 1) + "-" + (mol.indexOf(b.getAtom1()) + 1) + "=" + (mol.indexOf(b.getAtom2()) + 1) + "-" + (mol.indexOf(b.getCTAtom4()) + 1) + " " + ((stereo & 0x80) != 0 ? "CIS" : "") + ((stereo & 0x40) != 0 ? "TRANS" : ""));
                        }
                        if (stereo == 128) {
                            if (((f2 |= 0x400) & 0x80000) == 0) {
                                ++nOfCisDB;
                            }
                        } else if (stereo == 192 || stereo == 0) {
                            f2 |= 0x100000;
                            f2 &= 0xFFFFFFFD;
                        }
                        if ((bf & 0x100) == 256) {
                            f2 |= 0x200;
                        }
                    } else {
                        f2 &= 0xFFFFFFFD;
                    }
                }
                if ((f2 & 0x80000) != 0) {
                    ++nOfNRB;
                }
                dbsab[sidx][0] = f2;
                prevType = typ;
            }
            nOfNRB = (nOfNRB + 1) / 2;
            boolean nrdb = alternating && (nOfCisDB + nOfNRB) % 2 == 1;
            for (int ib = 0; ib < siz; ++ib) {
                h = sr[ib];
                n = sr[(ib + 1) % siz];
                int idx = btab.getBondIndex(h, n);
                int sidx = this.smilesBondIdx[idx];
                MolBond b = mol.getBond(idx);
                int typ = b.getType();
                int f3 = dbsab[sidx][0];
                if (typ == 2 && (f3 & 2) != 0) {
                    p = sr[(ib + siz - 1) % siz];
                    nn = sr[(ib + 2) % siz];
                    MolAtom a1 = mol.getAtom(p);
                    MolAtom a4 = mol.getAtom(nn);
                    int ct = (f3 & 0x400) != 0 ? 128 : 64;
                    f3 = (ct = b.transformCT(a1, a4, ct)) == 128 ? (f3 |= 0x20000) : (f3 |= 0x40000);
                }
                if (nrdb) {
                    f3 |= 0x80000;
                }
                dbsab[sidx][0] = f3;
                this.forceDoubleBondStereoOptions(sidx, b);
            }
        }
        SmilesExport.removeActiveFlag(dbsab, 68);
        if (logger.isLoggable(FINE) && DEBUG_DB_FLAGS) {
            logger.fine("Mine active doublebonds from chains");
        }
        int bondcount = dbsab.length;
        for (i = 0; i < bondcount; ++i) {
            int si = this.smilesBondIdx[i];
            MolBond b = mol.getBond(i);
            if (b.getType() != 2 || (dbsab[si][0] & 0x10) != 0) continue;
            this.setDBSProps4Bond(si);
            int f4 = dbsab[si][0];
            if ((f4 & 0x20) != 0) {
                int bf = mol.getStereo2(b, b.getCTAtom1(), b.getCTAtom4(), this.gInvCheck);
                int stereo = bf & 0xC0;
                if (logger.isLoggable(FINEST) && DEBUG_DB_FLAGS) {
                    logger.finest(i + " bond stereo " + (mol.indexOf(b.getCTAtom1()) + 1) + "-" + (mol.indexOf(b.getAtom1()) + 1) + "=" + (mol.indexOf(b.getAtom2()) + 1) + "-" + (mol.indexOf(b.getCTAtom4()) + 1) + " " + ((stereo & 0x80) != 0 ? "CIS" : "") + ((stereo & 0x40) != 0 ? "TRANS" : ""));
                }
                if (stereo == 192 || stereo == 0 || stereo == 512) {
                    f4 &= 0xFFFFFFFD;
                    f4 |= 0x60000;
                    f4 |= 0x100000;
                }
                if ((bf & 0x100) == 256) {
                    f4 |= 0x200;
                }
            } else {
                int i3;
                int i2;
                f4 &= 0xFFFFFFFD;
                if (this.cx && mol.canBeCT(i2 = mol.indexOf(b.getAtom1()), i3 = mol.indexOf(b.getAtom2()))) {
                    int bf = mol.getStereo2(b, b.getCTAtom1(), b.getCTAtom4(), this.gInvCheck);
                    int stereo = bf & 0xC0;
                    if (stereo == 128) {
                        f4 |= 0x20000;
                    } else if (stereo == 64) {
                        f4 |= 0x40000;
                    }
                }
            }
            dbsab[si][0] = f4;
            this.forceDoubleBondStereoOptions(si, b);
        }
        for (i = 0; i < bondcount; ++i) {
            f = dbsab[i][0];
            if ((f & 4) == 0) {
                this.setDBSProps4Bond(i);
                if ((f & 0x12) != 18) continue;
                this.setDBSASBARB(i);
                continue;
            }
            int[] nArray = dbsab[i];
            nArray[0] = nArray[0] | 1;
        }
        for (i = 0; i < bondcount; ++i) {
            this.setDBSADBARB(i);
            f = dbsab[i][0];
            if ((f & 0x436) != 1076) continue;
            int ia1 = dbsab[i][1];
            int l = this.origCtab[ia1].length;
            boolean active = false;
            for (int j = 0; j < l; ++j) {
                int ia0 = this.origCtab[ia1][j];
                if (!this.checkActiveDoubleBond(ia0)) continue;
                active = true;
                break;
            }
            if (!active) continue;
            int ia2 = dbsab[i][2];
            l = this.origCtab[ia2].length;
            active = false;
            for (int j = 0; j < l; ++j) {
                int ia3 = this.origCtab[ia2][j];
                if (!this.checkActiveDoubleBond(ia3)) continue;
                active = true;
                break;
            }
            if (!active) continue;
            int[] nArray = dbsab[i];
            nArray[0] = nArray[0] | 2;
        }
        SmilesExport.removeABFromDBWithouthASingle(dbsab, this.origCtab, this.origBtab, this.smilesBondIdx);
        for (i = 0; i < dbsab.length; ++i) {
            int fx = dbsab[i][0];
            int twobeetested = 7;
            if ((fx & 7) != 7) continue;
            this.uncrowd(i, 1);
            this.uncrowd(i, 2);
        }
        SmilesExport.removeABFromDBWithouthASingle(dbsab, this.origCtab, this.origBtab, this.smilesBondIdx);
        if (this.SMILES_strictness >= 7) {
            for (i = 0; i < bondcount; ++i) {
                f = dbsab[i][0];
                if ((f & 0x100000) == 0) continue;
                int testflag = 3;
                boolean BothSideActive = true;
                for (int k = 1; k < 3 && BothSideActive; ++k) {
                    int idx = dbsab[i][k];
                    int[] an = this.origCtab[idx];
                    int l = an.length;
                    boolean active = false;
                    for (int j = 0; j < l && BothSideActive; ++j) {
                        int ligandOrigIdx = an[j];
                        int bond = this.origBtab.getBondIndex(idx, ligandOrigIdx);
                        int sb = this.smilesBondIdx[bond];
                        int f_sb = dbsab[sb][0];
                        if (sb == i || (f_sb & 0x43) != 3) continue;
                        active = true;
                        break;
                    }
                    if (active) continue;
                    BothSideActive = false;
                }
                if (!BothSideActive) continue;
                throw new MolExportException("Nonstereo double bond between active CIS TRANS stereo bonds. Not possible to export it correctly to SMILES.");
            }
        }
        if (logger.isLoggable(FINE) && DEBUG_DB_FLAGS) {
            logger.fine("Flags \n" + SmilesExport.flagsToString(dbsab));
        }
    }

    static void removeActiveFlag(int[][] dbsab, int f) {
        for (int i = 0; i < dbsab.length; ++i) {
            int flg = dbsab[i][0];
            if ((flg & f) != f) continue;
            dbsab[i][0] = flg &= 0xFFFFFFFD;
        }
    }

    static void removeABFromDBWithouthASingle(int[][] dbsab, int[][] ctab, BondTable btab, int[] smilesBondIdx) {
        int bondCount = dbsab.length;
        for (int i = 0; i < bondCount; ++i) {
            int f = dbsab[i][0];
            if ((f & 0x24) != 36) continue;
            int ia1 = dbsab[i][1];
            int[] an = ctab[ia1];
            int l = an.length;
            boolean active = false;
            for (int j = 0; j < l; ++j) {
                int ia0 = an[j];
                int ib0 = btab.getBondIndex(ia0, ia1);
                int sb = smilesBondIdx[ib0];
                if (sb == i || (dbsab[sb][0] & 2) == 0) continue;
                active = true;
                break;
            }
            if (!active) {
                int[] nArray = dbsab[i];
                nArray[0] = nArray[0] & 0xFFFFFFDD;
                continue;
            }
            int ia2 = dbsab[i][2];
            an = ctab[ia2];
            l = an.length;
            active = false;
            for (int j = 0; j < l; ++j) {
                int ia3 = an[j];
                int ib3 = btab.getBondIndex(ia2, ia3);
                int sb = smilesBondIdx[ib3];
                if (sb == i || (dbsab[sb][0] & 2) == 0) continue;
                active = true;
                break;
            }
            if (active) continue;
            int[] nArray = dbsab[i];
            nArray[0] = nArray[0] & 0xFFFFFFDD;
        }
    }

    static void removeFCXCTFlag(int[][] dbsab, MoleculeGraph m, int[] smiToOrigBondIdx) {
        int FCXCT = 393216;
        for (int i = 0; i < dbsab.length; ++i) {
            int flg = dbsab[i][0];
            if ((flg & FCXCT) != FCXCT) continue;
            if ((flg & 0x20) == 0) {
                flg &= ~FCXCT;
            } else {
                MolBond b = m.getBond(smiToOrigBondIdx[i]);
                MolAtom a1 = b.getAtom1();
                MolAtom a2 = b.getAtom2();
                if (CleanUtil.hasWiggly(a1) || CleanUtil.hasWiggly(a2)) {
                    flg &= ~FCXCT;
                }
            }
            dbsab[i][0] = flg;
        }
    }

    static void removeActiveWithoutConn(int[][] dbsab) {
        int l = dbsab.length;
        for (int i = 0; i < l; ++i) {
            int i2;
            int i1;
            int f = dbsab[i][0];
            if ((f & 2) == 0 || SmilesExport.checkActive(i1 = dbsab[i][1], i2 = dbsab[i][2], dbsab, i, f)) continue;
            dbsab[i][0] = f & 0xFFFFFFFD;
        }
    }

    static boolean checkActive(int i1, int i2, int[][] dbsab, int idx, int flag) {
        int l = dbsab.length;
        for (int i = 0; i < l; ++i) {
            int f = dbsab[i][0];
            if (i == idx || (f & 2) == 0 || ((flag ^ f) & 4) == 0) continue;
            int e1 = dbsab[i][1];
            int e2 = dbsab[i][2];
            if (e1 != i1 && e1 != i2 && e2 != i1 && e2 != i2) continue;
            return true;
        }
        return false;
    }

    static boolean checkForSingleBonds(MolBond b) {
        int t;
        MolBond e;
        int i;
        MolAtom a1 = b.getAtom1();
        MolAtom a2 = b.getAtom2();
        int l = a1.getBondCount();
        for (i = 0; i < l; ++i) {
            e = a1.getBond(i);
            t = e.getType();
            if (e == b || SmilesExport.canBeCTBond(t) || t == 6 || t == 5 || t == 0) continue;
            return false;
        }
        l = a2.getBondCount();
        for (i = 0; i < l; ++i) {
            e = a2.getBond(i);
            t = e.getType();
            if (e == b || SmilesExport.canBeCTBond(t) || t == 6 || t == 5 || t == 0) continue;
            return false;
        }
        return true;
    }

    private void setDBSProps4Bond(int sidx) throws MolExportException {
        int idx = this.smiToOrigBondIdx[sidx];
        Molecule mol = this.molecule;
        int[][] ctab = this.smiCtab;
        BondTable btab = this.origBtab;
        MolBond b = mol.getBond(idx);
        int typ = b.getType();
        int[][] dbsab = this.dbsActiveBonds;
        int flg = dbsab[sidx][0];
        if ((flg & 1) == 0) {
            int y;
            boolean ctactive = true;
            MolAtom n = b.getAtom1();
            MolAtom a1 = null;
            int x = mol.indexOf(n);
            if (x < 0) {
                throw new MolExportException("The molecule doesn't contain the first atom of the bond");
            }
            dbsab[sidx][1] = x;
            int xs = this.ctab2smi[x];
            int[] an = ctab[xs];
            int se = an.length;
            int v = typ == 4 ? 1 : typ;
            boolean chaindouble = typ == 2 && (flg & 0x10) == 0;
            boolean bl = ctactive = se < 4;
            if (se == 1) {
                flg |= 8;
            }
            int doubleSmallringbondSide1 = 0;
            int dbbSide1 = 0;
            int doubleSmallringbondSide2 = 0;
            int dbbSide2 = 0;
            int smallRingDblBond = 68;
            for (int i = 0; i < se; ++i) {
                int o_idx = this.smilesAtoms[an[i]];
                int ibb = btab.getBondIndex(x, o_idx);
                int sibb = this.smilesBondIdx[ibb];
                MolBond bb = mol.getBond(ibb);
                if (b.equals(bb)) continue;
                int t = bb.getType();
                if (t == 2) {
                    ++dbbSide1;
                }
                v += t == 4 ? 1 : t;
                if (typ != 2) {
                    int f = dbsab[sibb][0];
                    if (t == 2 && (f & 2) != 0) {
                        int[] nArray = dbsab[sidx];
                        nArray[3] = nArray[3] + 1;
                    }
                    if (typ != 1 || (f & smallRingDblBond) != smallRingDblBond) continue;
                    ++doubleSmallringbondSide1;
                    continue;
                }
                if (t != 2 && t != 3) {
                    int[] nArray = dbsab[sidx];
                    nArray[3] = nArray[3] + 1;
                    if (!chaindouble || se != 2) continue;
                    a1 = bb.getOtherAtom(n);
                    continue;
                }
                flg |= 0x4000;
            }
            if (v > 4) {
                flg |= 0x8000;
            }
            if ((y = mol.indexOf(n = b.getAtom2())) < 0) {
                throw new MolExportException("The molecule doesn't contain the second atom of the bond");
            }
            dbsab[sidx][2] = y;
            int ys = this.ctab2smi[y];
            if (xs > ys) {
                dbsab[sidx][1] = y;
                dbsab[sidx][2] = x;
            }
            an = ctab[ys];
            se = an.length;
            int n2 = v = typ == 4 ? 1 : typ;
            boolean bl2 = ctactive ? se < 4 : (ctactive = false);
            if (se == 1) {
                flg |= 8;
            }
            for (int i = 0; i < se; ++i) {
                int o_idx = this.smilesAtoms[an[i]];
                int ibb = btab.getBondIndex(y, o_idx);
                int sibb = this.smilesBondIdx[ibb];
                MolBond bb = mol.getBond(ibb);
                if (b.equals(bb)) continue;
                int t = bb.getType();
                if (t == 2) {
                    ++dbbSide2;
                }
                v += t == 4 ? 1 : t;
                if (typ != 2) {
                    int f = dbsab[sibb][0];
                    if (t == 2 && (f & 2) != 0) {
                        int[] nArray = dbsab[sidx];
                        nArray[4] = nArray[4] + 1;
                    }
                    if (typ != 1 || (f & smallRingDblBond) != smallRingDblBond) continue;
                    ++doubleSmallringbondSide2;
                    continue;
                }
                if (t != 2 && t != 3) {
                    int[] nArray = dbsab[sidx];
                    nArray[4] = nArray[4] + 1;
                    if (!chaindouble || se != 2 || a1 == null) continue;
                    continue;
                }
                flg |= 0x4000;
            }
            if (v > 4) {
                flg |= 0x10000;
            }
            if ((flg & 0x4000) != 0) {
                flg = (flg & 0x18000) != 0 ? (flg &= 0xFFFFBFFF) : (flg &= 0xFFFFFFFD);
            }
            if (dbsab[sidx][3] == 0 && dbsab[sidx][4] == 0) {
                flg &= 0xFFFFFFFD;
            } else if (dbsab[sidx][3] > 0 && dbsab[sidx][4] > 0) {
                flg |= 0x20;
            }
            if (typ == 2) {
                if (!ctactive) {
                    flg &= 0xFFFFFFFD;
                }
                if ((flg & 8) != 0) {
                    flg &= 0xFFFFFFFD;
                }
                if ((b.getFlags() & 0x200) != 0) {
                    flg |= 0x800;
                }
                flg |= 4;
            }
            if (typ != 2 && (flg & 0x20) != 0) {
                flg |= 1;
            }
            if ((dbsab[sidx][0] & 2) == 0) {
                int[] nArray = dbsab[sidx];
                nArray[0] = nArray[0] | 1;
            }
            if (typ == 1 && doubleSmallringbondSide1 == dbbSide1 && doubleSmallringbondSide2 == dbbSide2) {
                flg &= 0xFFFFFFFD;
            }
        }
        dbsab[sidx][0] = flg;
    }

    private void setDBSASBARB(int sib) {
        int[][] rings = this.ringNumbers;
        int[][] dbsab = this.dbsActiveBonds;
        int in1 = dbsab[sib][1];
        int sin1 = this.ctab2smi[in1];
        int in2 = dbsab[sib][2];
        int sin2 = this.ctab2smi[in2];
        if (Math.abs(sin1 - sin2) == 1) {
            return;
        }
        for (int i = 0; i < rings[in1].length; ++i) {
            int r = rings[in1][i];
            if (r == -1) continue;
            for (int j = rings[in2].length - 1; j >= 0; --j) {
                if (r != rings[in2][j]) continue;
                int[] nArray = dbsab[sib];
                nArray[0] = nArray[0] | 0x80;
                dbsab[sib][7] = j;
                return;
            }
        }
    }

    private void setDBSADBARB(int sib) {
        int[][] ringA = this.ringAtoms;
        int[][] dbsab = this.dbsActiveBonds;
        int ia1 = dbsab[sib][1];
        int ia2 = dbsab[sib][2];
        int f = dbsab[sib][0];
        if ((f & 0x16) == 22) {
            int l = ringA[ia1].length;
            for (int j = 0; j < l; ++j) {
                int ra = ringA[ia1][j];
                if (ra != ia2) continue;
                int[] nArray = dbsab[sib];
                nArray[0] = nArray[0] | 0x80;
                return;
            }
        }
    }

    private boolean checkActiveDoubleBond(int idx) {
        int[][] dbsab = this.dbsActiveBonds;
        int l = this.origCtab[idx].length;
        for (int j = 0; j < l; ++j) {
            int ia1 = this.origCtab[idx][j];
            int sb = this.smilesBondIdx[this.origBtab.getBondIndex(ia1, idx)];
            if ((dbsab[sb][0] & 6) != 6) continue;
            return true;
        }
        return false;
    }

    private void forceDoubleBondStereoOptions(int sib, MolBond b) {
        boolean CTActive;
        int[] dbsab = this.dbsActiveBonds[sib];
        int f = dbsab[0];
        if ((f & 2) != 0 && (f & 0x80000) != 0) {
            f &= 0xFFFFFFFD;
        }
        boolean bl = CTActive = (f & 4) != 0 ? SmilesExport.checkForSingleBonds(b) : true;
        if ((f & 2) != 0 && !CTActive) {
            f &= 0xFFFFFFFD;
        }
        dbsab[0] = f;
    }

    private void uncrowd(int sdb, int ind) {
        BondTable btab = this.origBtab;
        int[][] dbsab = this.dbsActiveBonds;
        int ia = dbsab[sdb][ind];
        int[] an = this.smiCtab[this.ctab2smi[ia]];
        int sa = an.length;
        if (logger.isLoggable(FINEST) && DEBUG_UNCROWD) {
            int idx1 = dbsab[sdb][1] + 1;
            int idx2 = dbsab[sdb][2] + 1;
            logger.finest("uncrowd (original indexing) " + (ia + 1) + " at bond " + idx1 + "=" + idx2);
            for (int i = 0; i < sa; ++i) {
                int origIdx = this.smilesAtoms[an[i]];
                int ibi = btab.getBondIndex(ia, origIdx);
                int sibi = this.smilesBondIdx[ibi];
                int f = dbsab[sibi][0];
                idx1 = dbsab[sibi][1] + 1;
                idx2 = dbsab[sibi][2] + 1;
                logger.finest(i + "th: " + idx1 + " " + idx2 + " f " + SmilesExport.flagsToString(f));
            }
        }
        if (sa > 2) {
            int nSBfin = 0;
            int nSB = 0;
            int[] lofax = new int[sa];
            int theOO = -1;
            int lastChainSB = -1;
            for (int i = 0; i < sa; ++i) {
                int f;
                int origIdx = this.smilesAtoms[an[i]];
                int ibi = btab.getBondIndex(ia, origIdx);
                int sibi = this.smilesBondIdx[ibi];
                if (sibi == sdb || ((f = dbsab[sibi][0]) & 4) != 0 || (f & 2) == 0) continue;
                if ((f & 1) != 0) {
                    ++nSBfin;
                } else {
                    if ((f & 0x92) == 18) {
                        lastChainSB = nSB;
                    }
                    if ((f & 2) != 0 && lastChainSB == -1) {
                        int ion = dbsab[sibi][1];
                        if (ion == ia) {
                            ion = dbsab[sibi][2];
                        }
                        if (this.ctab2smi[ia] + (ind << 1) - 3 == this.ctab2smi[ion]) {
                            theOO = nSB;
                        }
                    }
                }
                lofax[nSB++] = sibi;
            }
            if (lastChainSB != -1) {
                theOO = lastChainSB;
            }
            if (nSBfin > 0) {
                theOO = -1;
            }
            boolean insearch = true;
            for (int i = 0; i < nSB; ++i) {
                int sidx = lofax[i];
                int f = dbsab[sidx][0];
                if ((f & 1) == 0) {
                    if (theOO != -1) {
                        if (theOO != i) {
                            f &= 0xFFFFFFFD;
                        }
                    } else if (nSBfin == 0) {
                        if (insearch) {
                            insearch = !insearch;
                        } else {
                            f &= 0xFFFFFFFD;
                        }
                    } else if (nSBfin != 1) {
                        f &= 0xFFFFFFFD;
                    }
                    f |= 1;
                }
                dbsab[sidx][0] = f;
            }
        } else {
            int origIdx = this.smilesAtoms[an[0]];
            int isb0 = btab.getBondIndex(ia, origIdx);
            int sisb0 = this.smilesBondIdx[isb0];
            if (sisb0 != sdb) {
                int[] nArray = dbsab[sisb0];
                nArray[0] = nArray[0] | 1;
            } else if (sa == 2) {
                origIdx = this.smilesAtoms[an[1]];
                int isb1 = btab.getBondIndex(ia, origIdx);
                int sisb1 = this.smilesBondIdx[isb1];
                int[] nArray = dbsab[sisb1];
                nArray[0] = nArray[0] | 1;
            }
        }
        if (logger.isLoggable(FINEST) && DEBUG_UNCROWD) {
            for (int i = 0; i < sa; ++i) {
                int origIdx = this.smilesAtoms[an[i]];
                int ibi = btab.getBondIndex(ia, origIdx);
                int sibi = this.smilesBondIdx[ibi];
                int f = dbsab[sibi][0];
                int idx1 = dbsab[sibi][1] + 1;
                int idx2 = dbsab[sibi][2] + 1;
                logger.finest(i + "th: " + idx1 + " " + idx2 + " f " + SmilesExport.flagsToString(f));
            }
        }
    }

    private void walkIslands() {
        int[][] ctab = this.smiCtab;
        BondTable btab = this.origBtab;
        int[][] dbsab = this.dbsActiveBonds;
        int sstart = this.findIslandEndDoubleBond();
        while (sstart > -1) {
            if ((dbsab[sstart][0] & 0x3000) == 0) {
                int iatom = dbsab[sstart][1];
                int siatom = this.ctab2smi[iatom];
                int[] san = ctab[siatom];
                for (int i = 0; i < san.length; ++i) {
                    int o_idx = this.smilesAtoms[san[i]];
                    int ib = btab.getBondIndex(iatom, o_idx);
                    int sib = this.smilesBondIdx[ib];
                    if ((dbsab[sib][0] & 7) != 2) continue;
                    this.finalizeSB(sib);
                    break;
                }
            }
            int snext = sstart;
            while (snext > -1) {
                this.setupDB(snext);
                snext = this.findNextDoublebondWithFixedEnd();
            }
            sstart = this.findIslandEndDoubleBond();
        }
    }

    int findIslandEndDoubleBond() {
        int sb4;
        int b4;
        int i4;
        int si4;
        int flagsb;
        int sb1;
        int b1;
        int i1;
        int si1;
        int j;
        boolean sbEnd;
        int si3;
        int i3;
        int si2;
        int i2;
        int f;
        int i;
        int[][] ctab = this.smiCtab;
        BondTable btab = this.origBtab;
        int[][] dbsab = this.dbsActiveBonds;
        int nbonds = dbsab.length;
        for (i = 0; i < nbonds; ++i) {
            f = dbsab[i][0];
            if ((f & 0x1C007) != 6) continue;
            i2 = dbsab[i][1];
            si2 = this.ctab2smi[i2];
            i3 = dbsab[i][2];
            si3 = this.ctab2smi[i3];
            sbEnd = true;
            for (j = 0; j < ctab[si2].length; ++j) {
                si1 = ctab[si2][j];
                i1 = this.smilesAtoms[si1];
                b1 = btab.getBondIndex(i1, i2);
                sb1 = this.smilesBondIdx[b1];
                flagsb = dbsab[sb1][0];
                if (i1 == i3 || (flagsb & 0x24) == 0) continue;
                sbEnd = false;
                break;
            }
            if (sbEnd) {
                return i;
            }
            sbEnd = true;
            for (j = 0; j < ctab[si3].length; ++j) {
                si4 = ctab[si3][j];
                i4 = this.smilesAtoms[si4];
                b4 = btab.getBondIndex(i3, i4);
                sb4 = this.smilesBondIdx[b4];
                flagsb = dbsab[sb4][0];
                if (i4 == i2 || (flagsb & 0x24) == 0) continue;
                sbEnd = false;
                break;
            }
            if (!sbEnd) continue;
            return i;
        }
        for (i = 0; i < nbonds; ++i) {
            f = dbsab[i][0];
            if ((f & 0x1C007) != 6) continue;
            i2 = dbsab[i][1];
            si2 = this.ctab2smi[i2];
            i3 = dbsab[i][2];
            si3 = this.ctab2smi[i3];
            sbEnd = true;
            for (j = 0; j < ctab[si2].length; ++j) {
                si1 = ctab[si2][j];
                i1 = this.smilesAtoms[si1];
                b1 = btab.getBondIndex(i1, i2);
                sb1 = this.smilesBondIdx[b1];
                flagsb = dbsab[sb1][0];
                if (i1 == i3 || (flagsb & 4) == 0) continue;
                sbEnd = false;
            }
            if (sbEnd) {
                return i;
            }
            sbEnd = true;
            for (j = 0; j < ctab[i3].length; ++j) {
                si4 = ctab[si3][j];
                i4 = this.smilesAtoms[si4];
                b4 = btab.getBondIndex(i3, i4);
                sb4 = this.smilesBondIdx[b4];
                flagsb = dbsab[sb4][0];
                if (i4 == i2 || (flagsb & 4) == 0) continue;
                sbEnd = false;
            }
            if (!sbEnd) continue;
            return i;
        }
        return -1;
    }

    int findNextDoublebondWithFixedEnd() {
        int[][] ctab = this.smiCtab;
        BondTable btab = this.origBtab;
        int[][] dbsab = this.dbsActiveBonds;
        int nbonds = dbsab.length;
        for (int i = 0; i < nbonds; ++i) {
            int flagsb;
            int j;
            int f = dbsab[i][0];
            if ((f & 0x1C005) != 4) continue;
            int i2 = dbsab[i][1];
            int si2 = this.ctab2smi[i2];
            int i3 = dbsab[i][2];
            int si3 = this.ctab2smi[i3];
            boolean sbFinal = false;
            for (j = 0; j < ctab[si2].length; ++j) {
                int si1 = ctab[si2][j];
                int i1 = this.smilesAtoms[si1];
                int b1 = btab.getBondIndex(i1, i2);
                int sb1 = this.smilesBondIdx[b1];
                flagsb = dbsab[sb1][0];
                if (i1 == i3 || (flagsb & 1) == 0) continue;
                sbFinal = true;
                break;
            }
            if (sbFinal) {
                return i;
            }
            sbFinal = false;
            for (j = 0; j < ctab[si3].length; ++j) {
                int si4 = ctab[si3][j];
                int i4 = this.smilesAtoms[si4];
                int b4 = btab.getBondIndex(i3, i4);
                int sb4 = this.smilesBondIdx[b4];
                flagsb = dbsab[sb4][0];
                if (i4 == i2 || (flagsb & 1) == 0) continue;
                sbFinal = true;
                break;
            }
            if (!sbFinal) continue;
            return i;
        }
        return -1;
    }

    private void setupDB(int sidb) {
        boolean node1;
        boolean aSBR;
        int flax;
        int iaa;
        int siaa;
        int sie;
        int ie;
        int i;
        Molecule mol = this.molecule;
        int[][] ctab = this.smiCtab;
        BondTable btab = this.origBtab;
        int[][] dbsab = this.dbsActiveBonds;
        int f = dbsab[sidb][0];
        int node = (f & 0x1000) != 0 ? 0 : 1;
        int[] nArray = dbsab[sidb];
        nArray[0] = nArray[0] | 0x3001;
        int ia1 = -1;
        int sia1 = -1;
        MolAtom a1 = null;
        int ia2 = dbsab[sidb][1 + node];
        int ia3 = dbsab[sidb][2 - node];
        int sia2 = this.ctab2smi[ia2];
        int sia3 = this.ctab2smi[ia3];
        int[] an = ctab[sia2];
        int ifsb = dbsab[sidb][5 + node];
        int refSBF = dbsab[ifsb][0];
        boolean refSBR = (refSBF & 0x80) != 0;
        boolean fsbslash = (refSBF & 0x100) != 0;
        for (i = 0; i < an.length; ++i) {
            int sial = an[i];
            int ial = this.smilesAtoms[sial];
            ie = btab.getBondIndex(ia2, ial);
            sie = this.smilesBondIdx[ie];
            if (sie != ifsb) continue;
            sia1 = sial;
            ia1 = ial;
            a1 = mol.getAtom(ia1);
            break;
        }
        if (logger.isLoggable(FINE) && DEBUG_DB_EXPORT) {
            logger.fine("Setup DB (orig idx): " + (ia1 + 1) + "-" + (ia2 + 1) + "=" + (ia3 + 1) + " is " + (fsbslash ? "/" : "\\") + " side 1");
            logger.fine("Setup DB (smi idx): " + sia1 + "-" + sia2 + "=" + sia3 + " " + (fsbslash ? "/" : "\\") + " side 1");
        }
        for (i = 0; i < an.length; ++i) {
            siaa = an[i];
            iaa = this.smilesAtoms[siaa];
            ie = btab.getBondIndex(ia2, iaa);
            sie = this.smilesBondIdx[ie];
            flax = dbsab[sie][0];
            boolean bl = aSBR = (flax & 0x80) != 0;
            if (logger.isLoggable(FINEST) && DEBUG_DB_EXPORT) {
                logger.fine("try side 1: " + siaa + "-" + sia2);
            }
            if (sie == ifsb || (flax & 3) != 2) continue;
            if ((flax & 4) == 0) {
                boolean flip = true;
                if (sia2 < sia3 && (!refSBR && sia1 < sia2 || !aSBR && siaa < sia2)) {
                    boolean bl2 = flip = !flip;
                }
                if (refSBR && sia1 > sia2) {
                    boolean bl3 = flip = !flip;
                }
                if (aSBR && siaa > sia2) {
                    boolean bl4 = flip = !flip;
                }
                flax = flip ? (flax |= fsbslash ? 0 : 256) : (flax |= fsbslash ? 256 : 0);
                if (logger.isLoggable(FINE) && DEBUG_DB_EXPORT) {
                    logger.fine("fixed (orig) " + (iaa + 1) + "-" + (ia2 + 1) + "=" + (ia3 + 1) + " " + ((flax & 0x100) != 0 ? "/" : "\\") + " side 1");
                }
                dbsab[sie][0] = flax;
                this.finalizeSB(sie);
                continue;
            }
            if ((dbsab[sie][0] & 0x18000) != 0) continue;
            node1 = dbsab[sie][1] == ia2;
            int[] nArray2 = dbsab[sie];
            nArray2[0] = nArray2[0] | (node1 ? 4096 : 8192);
            dbsab[sie][5 + (node1 ? 0 : 1)] = ifsb;
            this.setupDB(sie);
        }
        an = ctab[sia3];
        for (i = 0; i < an.length; ++i) {
            siaa = an[i];
            iaa = this.smilesAtoms[siaa];
            ie = btab.getBondIndex(ia3, iaa);
            sie = this.smilesBondIdx[ie];
            flax = dbsab[sie][0];
            boolean bl = aSBR = (flax & 0x80) != 0;
            if (sie == sidb || (flax & 3) != 2) continue;
            if ((flax & 4) == 0) {
                int ia4 = dbsab[sie][1];
                if (ia4 == ia3) {
                    ia4 = dbsab[sie][2];
                }
                MolAtom a4 = mol.getAtom(ia4);
                if (a1 != null) {
                    boolean flip;
                    int idb = this.smiToOrigBondIdx[sidb];
                    int dbs = mol.getStereo2(mol.getBond(idb), a1, a4, this.gInvCheck) & 0xC0;
                    int sia4 = this.ctab2smi[ia4];
                    boolean bl5 = flip = dbs == 128;
                    if (logger.isLoggable(FINEST) && DEBUG_DB_EXPORT) {
                        logger.finest("orig " + (ia1 + 1) + "-" + (ia2 + 1) + "=" + (ia3 + 1) + "-" + (ia4 + 1) + " cis " + (dbs == 128) + " flip " + flip);
                        logger.finest("SMI idx " + sia1 + "-" + sia2 + "=" + sia3 + "-" + sia4 + " " + " cis " + (dbs == 128) + " flip " + flip);
                        logger.finest(" reference single bond is ring " + refSBR + "\n actual single bond is ring " + aSBR);
                    }
                    boolean bl6 = (f & 0x80) != 0 ? !flip : (flip = flip);
                    if (logger.isLoggable(FINEST) && DEBUG_DB_EXPORT) {
                        logger.finest(" flip0 " + flip);
                    }
                    boolean bl7 = !refSBR && sia2 < sia3 && sia1 > sia2 || !aSBR && sia3 < sia2 && sia4 > sia3 ? !flip : (flip = flip);
                    if (logger.isLoggable(FINEST) && DEBUG_DB_EXPORT) {
                        logger.finest(" flip1 " + flip);
                    }
                    boolean bl8 = refSBR && (sia2 < sia3 && sia1 < sia2 || sia2 > sia3 && sia1 > sia2) ? !flip : (flip = flip);
                    if (logger.isLoggable(FINEST) && DEBUG_DB_EXPORT) {
                        logger.finest(" flip2 " + flip);
                    }
                    boolean bl9 = aSBR && (sia2 < sia3 && sia4 > sia3 || sia2 > sia3 && sia4 < sia3) ? !flip : (flip = flip);
                    if (logger.isLoggable(FINEST) && DEBUG_DB_EXPORT) {
                        logger.finest(" flip f " + flip);
                    }
                    flax = flip ? (flax |= fsbslash ? 0 : 256) : (flax |= fsbslash ? 256 : 0);
                    if (logger.isLoggable(FINEST) && DEBUG_DB_EXPORT) {
                        logger.finest("smi " + sia1 + "-" + sia2 + "=" + sia3 + "-" + sia4 + " side2 " + ((flax & 0x100) != 0 ? "/" : "\\"));
                    }
                }
                dbsab[sie][0] = flax;
                if (logger.isLoggable(FINE) && DEBUG_DB_EXPORT) {
                    logger.fine("fixed (orig) " + (ia1 + 1) + "-" + (ia2 + 1) + "=" + (ia3 + 1) + "-" + (ia4 + 1) + " side 2 " + ((flax & 0x100) != 0 ? "/" : "\\"));
                }
                this.finalizeSB(sie);
                continue;
            }
            if ((dbsab[sie][0] & 0x18000) != 0) continue;
            node1 = dbsab[sie][1] == ia3;
            int[] nArray3 = dbsab[sie];
            nArray3[0] = nArray3[0] | (node1 ? 4096 : 8192);
            dbsab[sie][5 + (node1 ? 0 : 1)] = ifsb;
            this.setupDB(sie);
        }
    }

    private void finalizeSB(int sb) {
        int[][] dbsab = this.dbsActiveBonds;
        int n1 = dbsab[sb][1];
        int n2 = dbsab[sb][2];
        for (int i = 0; i < dbsab.length; ++i) {
            if ((dbsab[i][0] & 4) != 4) continue;
            if (dbsab[i][1] == n1 || dbsab[i][1] == n2) {
                int[] nArray = dbsab[i];
                nArray[0] = nArray[0] | 0x1000;
                dbsab[i][5] = sb;
                continue;
            }
            if (dbsab[i][2] != n1 && dbsab[i][2] != n2) continue;
            int[] nArray = dbsab[i];
            nArray[0] = nArray[0] | 0x2000;
            dbsab[i][6] = sb;
        }
        int[] nArray = dbsab[sb];
        nArray[0] = nArray[0] | 1;
    }

    private void setupUnspecForSingleBonds() {
        int[][] dbsab = this.dbsActiveBonds;
        int doubleUnspec = 519;
        for (int i = 0; i < dbsab.length; ++i) {
            int tf = dbsab[i][0];
            if ((tf & doubleUnspec) != doubleUnspec) continue;
            int sb = dbsab[i][5];
            int[] nArray = dbsab[sb];
            nArray[0] = nArray[0] | 0x200;
            sb = dbsab[i][6];
            int[] nArray2 = dbsab[sb];
            nArray2[0] = nArray2[0] | 0x200;
        }
    }

    private void removeUnspecAroundDoubleBonds() {
        int[][] dbsab = this.dbsActiveBonds;
        int doubleSpec = 7;
        int doubleUnspec = 519;
        for (int i = 0; i < dbsab.length; ++i) {
            int tf = dbsab[i][0];
            if ((tf & doubleUnspec) != doubleSpec) continue;
            int sb = dbsab[i][5];
            int[] nArray = dbsab[sb];
            nArray[0] = nArray[0] & 0xFFFFFDFF;
            sb = dbsab[i][6];
            int[] nArray2 = dbsab[sb];
            nArray2[0] = nArray2[0] & 0xFFFFFDFF;
        }
    }

    private void removeUnnecessaryUnspec() throws MolExportException {
        int[][] dbsab = this.dbsActiveBonds;
        int finalMask = -12290;
        for (int i = 0; i < dbsab.length; ++i) {
            int[] nArray = dbsab[i];
            nArray[0] = nArray[0] & finalMask;
        }
        int sstart = this.findIslandEndDoubleBond();
        while (sstart > -1) {
            this.removeExtraUnspec(sstart);
            sstart = this.findIslandEndDoubleBond();
        }
    }

    private void removeExtraUnspec(int sidx) throws MolExportException {
        block13: {
            BondTable btab;
            int[][] ctab;
            Molecule mol;
            int b2;
            int sb2;
            int i2;
            int f;
            int[][] dbsab;
            block14: {
                boolean isb1between;
                int i1;
                int b1;
                int sb1;
                block12: {
                    int snextb;
                    int nextb;
                    int na;
                    int i;
                    int[] nn;
                    MolBond b;
                    boolean isb2between;
                    dbsab = this.dbsActiveBonds;
                    f = dbsab[sidx][0];
                    sb1 = dbsab[sidx][5];
                    b1 = this.smiToOrigBondIdx[sb1];
                    i1 = dbsab[sidx][1];
                    i2 = dbsab[sidx][2];
                    sb2 = dbsab[sidx][6];
                    b2 = this.smiToOrigBondIdx[sb2];
                    mol = this.molecule;
                    ctab = this.origCtab;
                    btab = this.origBtab;
                    if ((f & 0x3000) != 0) break block12;
                    boolean isb1unspec = (dbsab[sb1][0] & 0x200) != 0;
                    boolean isb2unspec = (dbsab[sb2][0] & 0x200) != 0;
                    boolean isb1between2 = (dbsab[sb1][0] & 0x20) != 0;
                    boolean bl = isb2between = (dbsab[sb2][0] & 0x20) != 0;
                    if (isb1unspec && isb2unspec) {
                        int[] nArray = dbsab[sb1];
                        nArray[0] = nArray[0] & 0xFFFFFDFF;
                    }
                    int[] nArray = dbsab[sidx];
                    nArray[0] = nArray[0] | 0x3001;
                    if (isb1between2) {
                        b = mol.getBond(b1);
                        int[] nArray2 = dbsab[sb1];
                        nArray2[0] = nArray2[0] | 1;
                        int i0 = mol.indexOf(b.getOtherAtom(mol.getAtom(i1)));
                        if (i0 < 0) {
                            throw new MolExportException("The molecule doesn't contain the atom of the bond");
                        }
                        nn = ctab[i0];
                        for (i = 0; i < nn.length; ++i) {
                            na = nn[i];
                            nextb = btab.getBondIndex(i0, na);
                            snextb = this.smilesBondIdx[nextb];
                            if (na == i1 || (dbsab[snextb][0] | 4) != 4) continue;
                            this.removeExtraUnspec(snextb);
                        }
                    }
                    if (!isb2between) break block13;
                    b = mol.getBond(b2);
                    int[] nArray3 = dbsab[sb2];
                    nArray3[0] = nArray3[0] | 1;
                    int i3 = mol.indexOf(b.getOtherAtom(mol.getAtom(i2)));
                    if (i3 < 0) {
                        throw new MolExportException("The molecule doesn't contain the atom of the bond");
                    }
                    nn = ctab[i3];
                    for (i = 0; i < nn.length; ++i) {
                        na = nn[i];
                        nextb = btab.getBondIndex(i3, na);
                        snextb = this.smilesBondIdx[nextb];
                        if (na == i2 || (dbsab[snextb][0] | 4) != 4) continue;
                        this.removeExtraUnspec(snextb);
                    }
                    break block13;
                }
                if ((f & 0x1000) != 0) break block14;
                boolean bl = isb1between = (dbsab[sb1][0] & 0x20) != 0;
                if (!isb1between) break block13;
                MolBond b = mol.getBond(b1);
                int[] nArray = dbsab[sb1];
                nArray[0] = nArray[0] | 1;
                int i0 = mol.indexOf(b.getOtherAtom(mol.getAtom(i1)));
                if (i0 < 0) {
                    throw new MolExportException("The molecule doesn't contain the atom of the bond");
                }
                int[] nn = ctab[i0];
                for (int i = 0; i < nn.length; ++i) {
                    int na = nn[i];
                    int nextb = btab.getBondIndex(i0, na);
                    int snextb = this.smilesBondIdx[nextb];
                    if (na == i1 || (dbsab[snextb][0] | 4) != 4) continue;
                    this.removeExtraUnspec(snextb);
                }
                break block13;
            }
            if ((f & 0x2000) == 0) {
                boolean isb2between;
                boolean bl = isb2between = (dbsab[sb2][0] & 0x20) != 0;
                if (isb2between) {
                    MolBond b = mol.getBond(b2);
                    int[] nArray = dbsab[sb2];
                    nArray[0] = nArray[0] | 1;
                    int i3 = mol.indexOf(b.getOtherAtom(mol.getAtom(i2)));
                    if (i3 < 0) {
                        throw new MolExportException("The molecule doesn't contain the atom of the bond");
                    }
                    int[] nn = ctab[i3];
                    for (int i = 0; i < nn.length; ++i) {
                        int na = nn[i];
                        int nextb = btab.getBondIndex(i3, na);
                        int snextb = this.smilesBondIdx[nextb];
                        if (na == i2 || (dbsab[snextb][0] | 4) != 4) continue;
                        this.removeExtraUnspec(snextb);
                    }
                }
            }
        }
    }

    private boolean checkUnspecAtSingleBonds() {
        int[][] dbsab = this.dbsActiveBonds;
        int doubleUnspec = 519;
        for (int i = 0; i < dbsab.length; ++i) {
            int f = dbsab[i][0];
            if ((f & doubleUnspec) != doubleUnspec) continue;
            boolean hasone = false;
            int sb = dbsab[i][5];
            if ((dbsab[sb][0] & 0x200) == 512) {
                hasone = true;
            }
            if ((dbsab[sb = dbsab[i][6]][0] & 0x200) == 512) {
                hasone = true;
            }
            if (hasone) continue;
            return false;
        }
        return true;
    }

    private void writeRecipe() {
        int[][] dbsab = this.dbsActiveBonds;
        for (int i = 0; i < dbsab.length; ++i) {
            int tf = dbsab[i][0];
            int f = 0;
            if ((tf & 7) == 3) {
                f = 1;
                if ((tf & 0x100) != 0) {
                    f |= 2;
                }
                if ((tf & 0x200) != 0) {
                    f |= 4;
                }
            }
            if (f == 0) continue;
            int ia = this.ctab2smi[dbsab[i][2]];
            if ((tf & 0x80) == 0) {
                this.dbsActiveAtoms[ia] = f;
                continue;
            }
            this.dbsActiveRingAtomFlags[ia][dbsab[i][7]] = f;
        }
    }

    private String exportReaction(RxnMolecule rxmol) throws MolExportException {
        int i;
        int nall = rxmol.getAtomCount();
        int nbonds = rxmol.getBondCount();
        this.smilesAtoms = new int[nall];
        this.ctab2smi = new int[nall];
        this.dbsActiveBonds = new int[nbonds][8];
        int nr = rxmol.getReactantCount();
        int np = rxmol.getProductCount();
        int na = rxmol.getAgentCount();
        int m = nr + na;
        int n = m + np;
        int smiIdxFrom = 0;
        int atomCount = 0;
        int bondCount = 0;
        this.smilesBondIdx = new int[rxmol.getBondCount()];
        int smiBondIdx = 0;
        SmilesExport export = new SmilesExport(this);
        SmilesExport.migrateOptions(this, export);
        for (i = 0; i < n; ++i) {
            if (i == nr) {
                this.stringBuffer.append(">");
            }
            if (i == m) {
                this.stringBuffer.append(">");
            }
            if (i > 0 && i != nr && i != m) {
                this.stringBuffer.append('.');
            }
            Molecule mol = null;
            mol = i < nr ? rxmol.getReactant(i) : (i < m ? rxmol.getAgent(i - nr) : rxmol.getProduct(i - m));
            String s = export.singleMolToSMILES(mol);
            if (s != null) {
                int j;
                this.stringBuffer.append(s.trim());
                if (!(this instanceof CxsmilesExport)) continue;
                int[] smidx = export.getOriginalAtomIndexes();
                if (this.smilesBondIdx != null) {
                    int[] molb = SmilesExport.generateSmilesBonds(mol, export.smilesAtoms, export.ringAtoms, export.ringNumbers, export.atomFlags);
                    j = 0;
                    while (j < molb.length) {
                        int n2 = j++;
                        molb[n2] = molb[n2] + smiBondIdx;
                    }
                    System.arraycopy(molb, 0, this.smilesBondIdx, smiBondIdx, molb.length);
                    smiBondIdx += molb.length;
                }
                if (smiIdxFrom > 0) {
                    int j2 = 0;
                    while (j2 < smidx.length) {
                        int n3 = j2++;
                        smidx[n3] = smidx[n3] + smiIdxFrom;
                    }
                }
                System.arraycopy(smidx, 0, this.smilesAtoms, smiIdxFrom, smidx.length);
                smiIdxFrom += smidx.length;
                int[][] dbsab = export.dbsActiveBonds;
                if (dbsab == null) continue;
                for (j = 0; j < dbsab.length; ++j) {
                    int[] nArray = dbsab[j];
                    nArray[1] = nArray[1] + atomCount;
                    int[] nArray2 = dbsab[j];
                    nArray2[2] = nArray2[2] + atomCount;
                    int[] nArray3 = dbsab[j];
                    nArray3[5] = nArray3[5] + bondCount;
                    int[] nArray4 = dbsab[j];
                    nArray4[6] = nArray4[6] + bondCount;
                }
                System.arraycopy(dbsab, 0, this.dbsActiveBonds, bondCount, dbsab.length);
                atomCount += mol.getAtomCount();
                bondCount += mol.getBondCount();
                continue;
            }
            return null;
        }
        if (this.convExpToHCount) {
            int[] tmp = new int[smiIdxFrom];
            System.arraycopy(this.smilesAtoms, 0, tmp, 0, tmp.length);
            this.smilesAtoms = tmp;
            nall = smiIdxFrom;
        }
        if (n == nr) {
            this.stringBuffer.append(">>");
        } else if (n == m) {
            this.stringBuffer.append(">");
        }
        if (this instanceof CxsmilesExport) {
            CxsmilesExport.correctSmiAtomIdx(this.smilesAtoms, rxmol);
            for (i = 0; i < nall; ++i) {
                this.ctab2smi[this.smilesAtoms[i]] = i;
            }
        }
        return this.stringBuffer.toString();
    }

    static void convertExplicitHToHCount(MoleculeGraph m) {
        MolAtom a;
        int i;
        int ac = m.getAtomCount();
        int[] queryHCount = new int[ac];
        boolean[] qarom = new boolean[ac];
        int n = 0;
        for (i = 0; i < ac; ++i) {
            a = m.getAtom(i);
            if (!a.isImplicitizableH(33)) {
                int qH = a.getQPropAsInt("H");
                int exph = a.getExplicitHcount();
                int n2 = queryHCount[n++] = qH == -1 ? exph : 0;
            }
            if (a.getValence() <= 3) continue;
            qarom[i] = true;
        }
        Hydrogenize.removeHAtoms(m, 33);
        if (m.getAtomCount() != n) {
            System.err.println("Error converting Explicit H to H count");
        }
        for (i = 0; i < m.getAtomCount(); ++i) {
            a = m.getAtom(i);
            int qhc = queryHCount[i];
            if (qhc <= 0) continue;
            StringBuffer sb = new StringBuffer("[!H0");
            if (qhc > 1) {
                sb.append("&!H1");
            }
            if (qhc > 2) {
                sb.append("&!H2");
            }
            if (qhc > 3) {
                sb.append("&!H3");
            }
            if (qhc > 4) {
                sb.append("&!H4");
            }
            sb.append("]");
            a.setQueryString(sb.toString());
            if (!qarom[i]) continue;
            a.setQueryAromaticity(3);
        }
    }

    private static String quoteIfNeeded(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c != ' ' && c != '\t' && c != '\n') continue;
            StringBuffer sb = new StringBuffer("\"");
            for (int j = 0; j < value.length(); ++j) {
                c = value.charAt(j);
                if (c == '\\' || c == '\"' || c == '\n') {
                    sb.append('\\');
                }
                if (c == '\n') {
                    sb.append("n");
                    continue;
                }
                sb.append(c);
            }
            sb.append("\"");
            return sb.toString();
        }
        return value;
    }

    static boolean checkQueryBond(MoleculeGraph m) {
        for (int i = 0; i < m.getBondCount(); ++i) {
            MolBond b = m.getBond(i);
            String qs = null;
            qs = b.getQuerystr();
            if (qs == null) continue;
            for (int j = 0; j < qs.length(); ++j) {
                char c = qs.charAt(j);
                if (c != '/' && c != '\\') continue;
                return true;
            }
        }
        return false;
    }

    static int checkFirstSlash(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '/') {
                return 1;
            }
            if (c != '\\') continue;
            return 2;
        }
        return 0;
    }

    public void rearrangeQueryBondString(int[] brasta, BondTable btab) {
        Molecule mol = this.molecule;
        int na = this.smilesAtoms.length;
        int bras = 0;
        for (int i = 0; i < na - 1; ++i) {
            int nextatom;
            int bondIdx;
            int here = i;
            int atom = this.smilesAtoms[i];
            long f = this.atomFlags[i];
            if ((f & 4L) != 0L) {
                if ((f & 8L) == 0L) {
                    brasta[bras++] = i;
                } else {
                    brasta[bras] = brasta[bras - 1];
                    ++bras;
                }
            }
            if ((f & 8L) != 0L) {
                here = bras - 1 >= 0 ? brasta[bras - 1] : brasta[bras];
                --bras;
                atom = this.smilesAtoms[here];
                f = this.atomFlags[here];
            }
            if ((bondIdx = btab.getBondIndex(atom, nextatom = this.smilesAtoms[i + 1])) == -1) continue;
            MolBond b = mol.getBond(bondIdx);
            String s = b.getQuerystr();
            int dbsf = this.dbsActiveAtoms[i + 1];
            if ((dbsf & 1) == 0 || s == null || b.getType() != 0) continue;
            int qStartCh = SmilesExport.checkFirstSlash(s);
            if ((dbsf & 2) != 0 && qStartCh == 2 || (dbsf & 2) == 0 && qStartCh == 1) {
                this.flipQueryString[bondIdx] = true;
                ((QueryBond)b).setQuerystr(SmilesExport.flipBondInString(s));
            }
            this.dbsActiveAtoms[i + 1] = 0;
        }
    }

    static String flipBondInString(String s) {
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '/') {
                chars[i] = 92;
                continue;
            }
            if (c != '\\') continue;
            chars[i] = 47;
        }
        return new String(chars);
    }

    static void writeSDFFields(MoleculeGraph mol, String[] incFields, StringBuffer sb, boolean writeName) {
        if (mol instanceof Molecule) {
            Molecule m = (Molecule)mol;
            if (writeName) {
                sb.append('\t');
                sb.append(m.getName());
            }
            if (incFields != null) {
                for (int i = 0; i < incFields.length; ++i) {
                    String field = incFields[i];
                    String propValue = MPropHandler.convertToString(m.properties(), field);
                    if (propValue != null) {
                        propValue = SmilesExport.quoteIfNeeded(propValue);
                        sb.append("\t");
                        sb.append(propValue);
                        continue;
                    }
                    if (field.equals("name")) {
                        if (writeName) continue;
                        sb.append("\t");
                        sb.append(m.getName());
                        continue;
                    }
                    sb.append("\t");
                }
            }
        }
    }

    static int[] generateSmilesBonds(MoleculeGraph m, int[] smilesAtoms, int[][] ringAtoms, int[][] ringNumbers, long[] atomFlags) {
        int[] sb = new int[m.getBondCount()];
        int na = smilesAtoms.length;
        int[] brasta = new int[na];
        BitSet openRings = new BitSet(na);
        BondTable btab = m.getBondTable();
        int smilesBondId = 0;
        int bras = 0;
        for (int i = 0; i < na; ++i) {
            int here = i;
            int atom = smilesAtoms[i];
            long f = atomFlags[i];
            int[] rings = ringNumbers[atom];
            for (int j = rings.length - 1; j >= 0; --j) {
                int r = rings[j];
                if (r == -1) continue;
                if (openRings.get(r)) {
                    int nextIdx = ringAtoms[atom][j];
                    int bondIdx = btab.getBondIndex(atom, nextIdx);
                    sb[bondIdx] = smilesBondId++;
                    openRings.clear(r);
                    continue;
                }
                openRings.set(r);
            }
            if ((f & 4L) != 0L) {
                if ((f & 8L) == 0L) {
                    brasta[bras++] = i;
                } else {
                    brasta[bras] = brasta[bras - 1];
                    ++bras;
                }
            }
            if ((f & 8L) != 0L) {
                here = bras - 1 >= 0 ? brasta[bras - 1] : brasta[bras];
                --bras;
                atom = smilesAtoms[here];
                f = atomFlags[here];
            }
            if ((f & 0x10L) != 0L || i >= na - 1) continue;
            int nextatom = smilesAtoms[i + 1];
            int bondIdx = btab.getBondIndex(atom, nextatom);
            sb[bondIdx] = smilesBondId++;
        }
        return sb;
    }

    private static void restoreMolecule(MoleculeGraph m, int[] origQA, boolean[] flip, boolean queryBondStrRearrange) {
        int i;
        for (i = 0; i < m.getAtomCount(); ++i) {
            MolAtom a = m.getAtom(i);
            if (a.getQueryAromaticity() == origQA[i]) continue;
            a.setQueryAromaticity(origQA[i]);
        }
        if (queryBondStrRearrange) {
            for (i = 0; i < m.getBondCount(); ++i) {
                if (!flip[i]) continue;
                MolBond b = m.getBond(i);
                String s = b.getQuerystr();
                ((QueryBond)b).setQuerystr(SmilesExport.flipBondInString(s));
            }
        }
    }

    static int getQueryBondCount(MolAtom a) {
        int n = 0;
        for (int i = a.getBondCount() - 1; i >= 0; --i) {
            MolBond b = a.getBond(i);
            if (b instanceof QueryBond && b.getType() == 0) {
                ++n;
                continue;
            }
            if (b.getType() != 0) continue;
            n -= 2;
        }
        return n;
    }

    static final boolean isAnyType(MolAtom a) {
        int atno = a.getAtno();
        return atno == 131 || atno == 137;
    }

    static final void migrateOptions(SmilesExport from, SmilesExport to) {
        to.querySmarts = from.querySmarts;
        to.cx = from.cx;
        to.wrdbsEnabled = from.wrdbsEnabled;
        to.wrparinfo = from.wrparinfo;
        to.gInvCheck = from.gInvCheck;
        to.forceQuerySmarts = from.forceQuerySmarts;
        to.simplestForm = from.simplestForm;
        to.compress = from.compress;
        to.writeMolName = from.writeMolName;
        to.convExpToHCount = from.convExpToHCount;
        to.aromatize = from.aromatize;
        to.ignoreMaps = from.ignoreMaps;
        to.setSMILESExportRigor(from.getSMILESExportRigor());
    }

    static final boolean canBeCTBond(int type) {
        return type == 1 || type == 4;
    }

    static final boolean isOrganicSubsetLowestNormalValence(MolAtom a, boolean smarts, long f) {
        int atno = a.getAtno();
        int v = smarts || (f & 2L) != 0L ? -1 : SmilesExport.getValence(a);
        return atno == 5 && (v == -1 || v == 3) || atno == 6 && (v == -1 || v == 4) || atno == 7 && (v == -1 || v == 3 || v == 5) || atno == 8 && (v == -1 || v == 2) || atno == 15 && (v == -1 || v == 3 || v == 5) || atno == 16 && (v == -1 || v == 2 || v == 4 || v == 6) || atno == 9 && (v == -1 || v == 1) || atno == 17 && (v == -1 || v == 1) || atno == 35 && (v == -1 || v == 1) || atno == 53 && (v == -1 || v == 1) || atno == 131 || atno == 137 || !smarts && atno == 136;
    }

    static final int getValence(MolAtom a) {
        int x;
        int v = a.getValenceProp();
        if (v != -1) {
            return v;
        }
        int h = a.getImplicitHcount();
        v = h * 2 + (x = a.twicesumbonds(true, false));
        v = v % 2 == 1 ? v + 1 : v;
        return v / 2;
    }

    static boolean enumerateLinkAndPosVarBonds(Molecule m, StringBuffer sb) {
        int ac = m.getAtomCount();
        boolean enumerate = false;
        for (int i = 0; i < ac && !enumerate; ++i) {
            MolAtom a = m.getAtom(i);
            if (!a.isLinkNode()) continue;
            enumerate = true;
        }
        int count = m.getBondCount();
        for (int i = 0; i < count && !enumerate; ++i) {
            MolBond b = m.getBond(i);
            if (!b.isPositionVariation()) continue;
            enumerate = true;
        }
        if (!enumerate) {
            return true;
        }
        Molecule pm = (Molecule)m.getParent();
        if (pm != null && pm instanceof RgMolecule) {
            m = pm;
        }
        int startPosition = sb.length();
        try {
            MarkushEnumeratorFactory ef = new MarkushEnumeratorFactory(6153);
            MolEnumerator me = ef.createEnumerator(m);
            me.setLicenseEnvironment("FreeMarkushEnumerationForInternalUseLicenseEnvironment");
            sb.append("[");
            int n = 0;
            while (me.hasMoreElements() && n++ < 100) {
                String s;
                Molecule mol = me.nextElement();
                try {
                    s = MolExporter.exportToFormat(mol, "smarts");
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
                sb.append("$(" + s + "),");
            }
            sb.setCharAt(sb.length() - 1, ']');
        }
        catch (IllegalArgumentException e) {
            sb.setLength(startPosition);
            return false;
        }
        return true;
    }

    static final int removeAttachmentAtoms(MoleculeGraph m) {
        MolAtom[] atoms = m.getAtomArray();
        MolAtom aP = null;
        int order = Integer.MAX_VALUE;
        for (int k = atoms.length - 1; k >= 0; --k) {
            MolAtom a = m.getAtom(k);
            if (a.getAtno() != 138) continue;
            int apo = a.getRgroupAttachmentPointOrder();
            if (apo < order) {
                apo = order;
                aP = a.getLigand(0);
            }
            m.removeAtom(a);
        }
        return aP == null ? -1 : m.indexOf(aP);
    }

    void throwMolExportExceptionSMILES(Molecule m) throws MolExportException {
        String molSmarts = this.getSimpleSmartsString(m);
        throw new MolExportException("\nSome features of " + molSmarts + " cannot be converted to smiles." + " Use the cxsmiles, smarts or cxsmarts format.");
    }

    String getSimpleSmartsString(Molecule m) {
        String molSmarts;
        SmilesExport exporter = new SmilesExport(this);
        exporter.forceQuerySmarts();
        exporter.rgToRecursiveSmarts = false;
        exporter.enumerateLinkAndPosVarBonds = false;
        try {
            molSmarts = (String)exporter.convert(m);
        }
        catch (Exception e) {
            return m.toString();
        }
        return molSmarts.trim();
    }

    void throwMolExportExceptionCXSMILES(Molecule m) throws MolExportException {
        String molSmarts = this.getSimpleSmartsString(m);
        throw new MolExportException("\nSome features of " + molSmarts + " cannot be converted to smiles." + " Use the smarts or cxsmarts format.");
    }

    void throwMolExportExceptionSMARTS(Molecule m) throws MolExportException {
        String molSmarts = this.getSimpleSmartsString(m);
        throw new MolExportException("\nSome features of " + molSmarts + " cannot be converted to smarts." + " Use cxsmarts format.");
    }

    void throwMolExportException(Molecule m) throws MolExportException {
        String molSmarts = this.getSimpleSmartsString(m);
        throw new MolExportException("\nSome features of " + molSmarts + " cannot be converted to the given format." + " Try mrv format.");
    }

    static final String toString(int[] n) {
        StringBuffer s = new StringBuffer();
        int l = n.length;
        for (int i = 0; i < l; ++i) {
            s.append(i + " " + n[i] + "\n");
        }
        return s.toString();
    }

    static final String toRowString(int[] n) {
        StringBuffer s = new StringBuffer();
        int l = n.length;
        for (int i = 0; i < l; ++i) {
            s.append(n[i] + " ");
        }
        return s.toString();
    }

    static final String toString(int[][] n) {
        StringBuffer s = new StringBuffer();
        int l = n.length;
        for (int i = 0; i < l; ++i) {
            s.append(i + ": ");
            for (int j = 0; j < n[i].length; ++j) {
                s.append(" " + n[i][j]);
            }
            s.append("\n");
        }
        return s.toString();
    }

    static final String toString(long[] n) {
        StringBuffer s = new StringBuffer();
        int l = n.length;
        for (int i = 0; i < l; ++i) {
            s.append(i + " " + n[i] + "\n");
        }
        return s.toString();
    }

    static final boolean differ(int[] x, int[] y) {
        int l = x.length;
        for (int i = 0; i < l; ++i) {
            if (x[i] == y[i]) continue;
            return true;
        }
        return false;
    }

    private static final String flagsToString(int f) {
        StringBuffer s = new StringBuffer();
        if ((f & 1) != 0) {
            s.append("FINAL ");
        }
        if ((f & 2) != 0) {
            s.append("FACTIVE ");
        }
        if ((f & 4) != 0) {
            s.append("FDOUBLE ");
        }
        if ((f & 8) != 0) {
            s.append("FTERMINAL ");
        }
        if ((f & 0x10) != 0) {
            s.append("FRING ");
        }
        if ((f & 0x20) != 0) {
            s.append("FBETWEEN ");
        }
        if ((f & 0x40) != 0) {
            s.append("FSMARI ");
        }
        if ((f & 0x80) != 0) {
            s.append("FWARIBO ");
        }
        if ((f & 0x400) != 0) {
            s.append("FDEFAULT ");
        }
        if ((f & 0x800) != 0) {
            s.append("FCARE ");
        }
        if ((f & 0x4000) != 0) {
            s.append("FALLEN ");
        }
        if ((f & 0x8000) != 0) {
            s.append("FN1HV ");
        }
        if ((f & 0x10000) != 0) {
            s.append("FN2HV ");
        }
        if ((f & 0x20000) != 0) {
            s.append("FCXCIS ");
        }
        if ((f & 0x40000) != 0) {
            s.append("FCXTRANS ");
        }
        if ((f & 0x80000) != 0) {
            s.append("FNRPDB ");
        }
        if ((f & 0x100000) != 0) {
            s.append("FDBINACTIVE ");
        }
        return s.toString();
    }

    private static final String flagsToString(int[][] dbsab) {
        StringBuffer s = new StringBuffer();
        int nbonds = dbsab.length;
        for (int i = 0; i < nbonds; ++i) {
            int f = dbsab[i][0];
            s.append(i + " smi bond " + (dbsab[i][1] + 1) + "-" + (dbsab[i][2] + 1) + "  " + SmilesExport.flagsToString(f) + "\n");
        }
        return s.toString();
    }

    static final boolean isHydrogen(MolAtom atom) {
        int atno = atom.getAtno();
        return atno == 1 && atom.getMassno() == 0;
    }

    static final boolean checkParityPossibility(MoleculeGraph m) {
        if (m.getDim() == 2) {
            int l = m.getBondCount();
            for (int i = 0; i < l; ++i) {
                MolBond b = m.getBond(i);
                int f = b.getFlags() & 0x30;
                if (f != 16 && f != 32) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    static final int[] numberOfNonNegativeRanks(long[] inv) {
        int n = 0;
        int lastnn = inv.length;
        for (int i = inv.length - 1; i >= 0; --i) {
            if (inv[i] != -1L) {
                ++n;
                continue;
            }
            if (n != 0) continue;
            --lastnn;
        }
        return new int[]{n, lastnn};
    }

    void setFields(SmilesExport classObject) {
        this.wrdbsEnabled = classObject.wrdbsEnabled;
        this.wrparEnabled = classObject.wrparEnabled;
        this.gInvCheck = classObject.gInvCheck;
        this.SMILES_strictness = classObject.SMILES_strictness;
        this.forceQuerySmarts = classObject.forceQuerySmarts;
        this.querySmarts = classObject.querySmarts;
        this.simplestForm = classObject.simplestForm;
        this.compress = classObject.compress;
        this.writeMolName = classObject.writeMolName;
        this.convExpToHCount = classObject.convExpToHCount;
        this.uniqueFormat = classObject.uniqueFormat;
        this.aromatize = classObject.aromatize;
        this.hydrogenize = classObject.hydrogenize;
        this.parityAndCTinCanon = classObject.parityAndCTinCanon;
        this.ignoreMaps = classObject.ignoreMaps;
        this.writeHeader = classObject.writeHeader;
        this.setTerminalAtomArom = classObject.setTerminalAtomArom;
        this.rgToRecursiveSmarts = classObject.rgToRecursiveSmarts;
        this.enumerateLinkAndPosVarBonds = classObject.enumerateLinkAndPosVarBonds;
    }
}

