/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.smiles;

import chemaxon.common.util.Base64InputStream;
import chemaxon.core.util.BondTable;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MolImportModule;
import chemaxon.marvin.io.formats.smiles.SmartsAtomQuerifier;
import chemaxon.marvin.io.formats.smiles.SmilesExport;
import chemaxon.marvin.io.formats.smiles.SmilesImportX;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.struc.Gearch;
import chemaxon.struc.MProp;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.PeriodicSystem;
import chemaxon.struc.QueryBond;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.Smolecule;
import chemaxon.struc.StereoConstants;
import chemaxon.struc.prop.MStringProp;
import chemaxon.util.SmilesCompressor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SmilesImport
extends MolImportModule
implements CallbackIface,
StereoConstants {
    private static final Logger logger;
    private static boolean DEBUG_PARSE;
    private static boolean DEBUG_SETUPQUERYSTR;
    private static boolean DEBUG_CHIRALITY;
    static final int H_ORDER = Integer.MAX_VALUE;
    static final int ALLENIC_IMPL_H2 = 0x7FFFFFFD;
    private boolean smartsImport = false;
    protected boolean querySmarts = false;
    private static final int QAROMATIC = 1;
    private static final int QALIPHATIC = 2;
    private static final int QAROMALIPH = 3;
    private static final int ANYATOM = 131;
    private static final int CHIRALITY_TETRAHEDRAL = 1;
    private static final int CHIRALITY_ALLENELIKE = 2;
    private static final int CHIRALITY_SQUAREPLANAR = 3;
    private static final int CHIRALITY_TRIGONALBIPYRAMIDAL = 4;
    private static final int CHIRALITY_OCTAHEDRAL = 5;
    private static final int[] ATNO_ARRAY;
    private static final int ATNO_ARRAY2_SIZE = 1508;
    private static final int[] ATNO_ARRAY2;
    private static final int[] BOND_TYPE_ARRAY;
    private static final int[] QUERY_PROPERTY_ARRAY;
    private static final boolean[] IS_AROMATIC;
    private static final boolean[] IS_QUERY_ONLY;
    private static final boolean[] IS_OPERATOR;
    private final int[] atomList = new int[256];
    private static final int S_START = 0;
    private static final int S_SYMBOL = 1;
    private static final int S_BOND = 2;
    private static final int S_NUMBER = 3;
    private static final int S_OPENSQUARE = 4;
    private static final int S_CLOSESQUARE = 5;
    private static final int S_BEGINBRANCH = 6;
    private static final int S_ENDBRANCH = 7;
    private static final int S_END = 8;
    private static final int T_SYMBOL = 0;
    private static final int T_BOND = 1;
    private static final int T_NUMBER = 2;
    private static final int T_OPENSQUARE = 3;
    private static final int T_CLOSESQUARE = 4;
    private static final int T_BEGINBRANCH = 5;
    private static final int T_ENDBRANCH = 6;
    private static final int T_END = 7;
    private static final int[][] NEXTSTATES;
    private static final int[] RING_NODE_INDEXES_INI;
    private MolInputStream istream;
    private String[] fieldNames;
    int fieldBeginIndex;
    private int[] ringNodeIndexes = new int[100];
    private int[] ringBonds = new int[100];
    private String[] queryBondStrings = new String[100];
    private int[] branchStack = new int[1024];
    private int branchStackPointer = 0;
    private int atomCount;
    private int currentAtomIndex;
    private int fragmentStartIdx;
    private int currentBondType;
    private char[] smilesBuffer = new char[1024];
    private static final int AROM_MASK = 3;
    boolean isSmartsAtom = false;
    private static final int SMARTSATOM_MASK = 4;
    private int[] atomFlags = new int[1024];
    private BitSet explicitBond;
    private boolean[] ringBondIsExplicit = new boolean[100];
    private boolean currentBondIsExplicit = false;
    private boolean parityCheckAllowed = false;
    private boolean stereo2CheckAllowed = false;
    boolean doubleBondFixes = false;
    boolean molHasRing = false;
    private boolean thisAtomIsChiral;
    private boolean hasAtomWithParity;
    private int chiralFlags = 0;
    private int nextChiralCenter = 0;
    private int[][] chiralNeighbours;
    private static final int CHI_READY = 8;
    private static final int IMPH = 16;
    private static final int FIRSTCHIRALATOM = 64;
    private static final int CH_INIT = -9999;
    private boolean lastBondIsDBSM;
    private int nextStereo2Modifier = 0;
    private int[][] doubleBondStereoModifiers;
    private String queryBondString = null;
    private boolean possibleQueryBond = false;
    int reactionIndex1;
    int reactionIndex2;
    int reactionIndex3;
    private int nextComponentLevel = 1;
    private int componentLevel = 0;
    private boolean upDownInQuery = false;
    private int[] smilesBondIndex = null;
    private int bondPosition;
    private boolean daylightCompatibility = false;
    private boolean fixSmallRingCIS_AromBond = true;
    private boolean compressed = false;
    private SmilesCompressor decompressor = null;
    private Base64InputStream decoder = null;

    @Override
    public void setOptions(String opts) {
        this.fieldNames = null;
        if (opts != null && opts.length() != 0) {
            ArrayList<String> fields = new ArrayList<String>();
            int i = 0;
            int k = 0;
            while (i < opts.length()) {
                k = i;
                if ((i = this.setOptions(opts, k, fields)) != k) continue;
                throw new IllegalArgumentException(opts.substring(i) + ": " + "unknown import option");
            }
            if (fields.size() != 0) {
                this.fieldNames = new String[fields.size()];
                fields.toArray(this.fieldNames);
            }
        }
    }

    int setOptions(String opts, int i, List<String> fields) {
        char c = opts.charAt(i);
        if (c == 'f') {
            int k;
            if ((k = opts.indexOf(44, ++i)) < 0) {
                k = opts.length();
            }
            if (k > i) {
                String s = opts.substring(i, k);
                fields.add(s);
                i = k;
            }
            ++i;
        } else if (c == 'd') {
            this.daylightCompatibility = true;
            ++i;
        } else if (c == 'c') {
            this.fixSmallRingCIS_AromBond = false;
            ++i;
        } else if (c == 'Z') {
            this.compressed = true;
            ++i;
        }
        return i;
    }

    void copyOptions(SmilesImport other) {
        this.daylightCompatibility = other.daylightCompatibility;
        this.fixSmallRingCIS_AromBond = other.fixSmallRingCIS_AromBond;
        this.compressed = other.compressed;
        this.decompressor = other.decompressor;
        this.decoder = other.decoder;
    }

    @Override
    public void initMolImport(MolInputStream is) throws IOException {
        String fmt = is.getFormat();
        this.smartsImport = fmt.equals("smarts") || fmt.equals("cxsmarts");
        this.istream = is;
    }

    @Override
    public boolean readMol(Molecule mol) throws IOException {
        String l;
        while ((l = this.istream.readLine()) != null && l.startsWith("#")) {
        }
        boolean r = this.readMol(l, mol);
        return r;
    }

    @Override
    public Molecule createMol() {
        return new RgMolecule();
    }

    public boolean readMol(String smiles, Molecule mol) throws IOException {
        RxnMolecule rxn;
        if (this.compressed) {
            smiles = this.decompressSmilesString(smiles);
        }
        if (smiles == null) {
            return false;
        }
        this.initLocalFields();
        mol.clearForImport(this.querySmarts ? "smarts" : "smiles");
        this.initReac(smiles);
        boolean ret = false;
        if (this.reactionIndex2 >= 0) {
            ret = this.readReac(smiles, mol);
        } else {
            this.initStereo(smiles);
            ret = this.readMol0(smiles, mol);
        }
        SmilesImport.removeFieldAddName(mol);
        if (this.fieldBeginIndex != 0) {
            int last = smiles.length();
            for (int i = this.fieldBeginIndex; i < last; ++i) {
                char c = smiles.charAt(i);
                if (c != '|') continue;
                this.fieldBeginIndex = i + 1;
                break;
            }
            this.readExtendedFeatures(this.fieldBeginIndex, smiles, mol);
        }
        if (this.fixSmallRingCIS_AromBond && this.doubleBondFixes && this.molHasRing) {
            SmilesImport.fixCisInSmallRings(mol);
        }
        if (this.reactionIndex2 >= 0 && (rxn = SmilesImport.getRxnMolecule(mol)) != null) {
            SmilesImportX.joinCommonRxnComponents(rxn);
        }
        mol.setInputFormat(this.querySmarts ? "smarts" : "smiles");
        return ret;
    }

    private void initLocalFields() {
        this.querySmarts = this.smartsImport;
        this.componentLevel = 0;
        this.nextComponentLevel = 1;
    }

    private static void removeFieldAddName(Molecule mol) {
        String field = "field_0";
        MProp field0 = mol.properties().get(field);
        if (field0 == null) {
            field = "name";
            field0 = mol.properties().get(field);
        }
        if (field0 instanceof MStringProp) {
            String name = ((MStringProp)field0).stringValue();
            mol.setName(name);
            mol.properties().set(field, null);
        }
    }

    private static RxnMolecule getRxnMolecule(Molecule mol) {
        RxnMolecule rxn = null;
        if (mol instanceof RgMolecule) {
            Molecule root = ((RgMolecule)mol).getRoot();
            if (root instanceof RxnMolecule) {
                rxn = (RxnMolecule)root;
            }
        } else if (mol instanceof RxnMolecule) {
            rxn = (RxnMolecule)mol;
        }
        return rxn;
    }

    String decompressSmilesString(String smiles) throws IOException, UnsupportedEncodingException {
        byte[] line;
        int l;
        if (this.decompressor == null) {
            this.decoder = new Base64InputStream(null);
            this.decompressor = new SmilesCompressor();
        }
        int len = (l = (line = smiles.getBytes()).length) > 0 ? (l - 1) / 4 + 1 : 0;
        int n = 0;
        int k = 0;
        for (int i = 0; i < len; ++i) {
            byte b3;
            byte b2;
            int[] d;
            k = i * 4;
            byte b0 = line[k++];
            byte b1 = line[k++];
            if ((d = this.decoder.decode(b0, b1, b2 = line[k++], b3 = line[k++]))[0] >= 0) {
                line[n++] = (byte)d[0];
            }
            if (d[1] >= 0) {
                line[n++] = (byte)d[1];
            }
            if (d[2] < 0) continue;
            line[n++] = (byte)d[2];
        }
        byte[] byteline = new byte[n];
        System.arraycopy(line, 0, byteline, 0, n);
        line = this.decompressor.decompress(byteline);
        smiles = new String(line, "ASCII");
        return smiles;
    }

    boolean readMol0(String smiles, Molecule mol) throws IOException {
        this.hasAtomWithParity = false;
        this.upDownInQuery = false;
        mol.setDim(0);
        System.arraycopy(RING_NODE_INDEXES_INI, 0, this.ringNodeIndexes, 0, RING_NODE_INDEXES_INI.length);
        this.branchStackPointer = 0;
        this.atomCount = 0;
        this.currentAtomIndex = -1;
        this.fragmentStartIdx = 0;
        int i = 0;
        int state = 0;
        int smilen = smiles.length();
        if (this.smilesBuffer.length < smilen + 1) {
            this.smilesBuffer = new char[smilen + 16];
        }
        smiles.getChars(0, smilen, this.smilesBuffer, 0);
        this.smilesBuffer[smilen] = 10;
        boolean branchBegan = false;
        boolean branchClosed = false;
        boolean afterChiralCenter = false;
        this.fieldBeginIndex = 0;
        while (state >= 0 && state != 8) {
            char c;
            char c2 = c = i < smilen ? this.smilesBuffer[i] : (char)'\n';
            if (logger.isLoggable(Level.FINE) && DEBUG_PARSE) {
                logger.fine("char " + c + " STATE " + state + " currentatomIdx " + this.currentAtomIndex);
            }
            try {
                int openBracket;
                int last;
                if (state == 0 && c == '(') {
                    int lc;
                    int stateAfterBranch;
                    last = -1;
                    openBracket = 1;
                    for (int j = i + 1; j < smilen; ++j) {
                        if (this.smilesBuffer[j] == '(') {
                            ++openBracket;
                            continue;
                        }
                        if (this.smilesBuffer[j] != ')' || --openBracket != 0) continue;
                        last = j;
                        break;
                    }
                    if ((stateAfterBranch = NEXTSTATES[lc = ++last < smilen ? this.smilesBuffer[last] : 10][7]) == -1 || stateAfterBranch == 8) {
                        this.componentLevel += this.nextComponentLevel;
                    } else {
                        this.branchStack[this.branchStackPointer++] = 0;
                        branchBegan = true;
                    }
                    ++i;
                    continue;
                }
                if ((state = NEXTSTATES[c][state]) == 1) {
                    i = this.readSymbolAndAddAtom(i, c, mol, smilen);
                    if (this.parityCheckAllowed) {
                        boolean bcacc;
                        boolean bl = bcacc = branchClosed || afterChiralCenter;
                        if (branchBegan || bcacc) {
                            this.devChiEntry(branchBegan, bcacc);
                        }
                    }
                    if (this.stereo2CheckAllowed && this.lastBondIsDBSM) {
                        this.finalizeLastDoubleBond(this.currentAtomIndex);
                    }
                    afterChiralCenter = false;
                    branchBegan = false;
                    branchClosed = false;
                    this.currentBondType = 1;
                    this.currentBondIsExplicit = false;
                    continue;
                }
                if (state == 4) {
                    last = -1;
                    openBracket = 1;
                    for (int j = i + 1; j < smilen; ++j) {
                        if (this.smilesBuffer[j] == '[') {
                            ++openBracket;
                            continue;
                        }
                        if (this.smilesBuffer[j] != ']' || --openBracket != 0) continue;
                        last = j;
                        break;
                    }
                    if (last >= 0) {
                        this.isSmartsAtom = true;
                        MolAtom a = mol.reuseAtom(0, this.atomCount);
                        int arom = this.readSmartsAtom(i + 1, last, a, smiles);
                        int la = this.addAtom(mol, arom);
                        if (this.parityCheckAllowed) {
                            boolean bcacc;
                            boolean bl = bcacc = branchClosed || afterChiralCenter;
                            if (branchBegan || bcacc) {
                                this.devChiEntry(branchBegan, bcacc);
                            }
                            if (this.thisAtomIsChiral) {
                                this.addChiEntry(la);
                                afterChiralCenter = true;
                            } else {
                                afterChiralCenter = false;
                            }
                        }
                        if (this.stereo2CheckAllowed && this.lastBondIsDBSM) {
                            this.finalizeLastDoubleBond(this.currentAtomIndex);
                        }
                    } else {
                        throw new MolFormatException("Unmatched square bracket in SMILES/SMARTS string: " + smiles);
                    }
                    i = last;
                    branchBegan = false;
                    branchClosed = false;
                    this.currentBondType = 1;
                    this.currentBondIsExplicit = false;
                    continue;
                }
                if (state == 3) {
                    i = this.readRingNumber(i, c, mol, smilen, smiles);
                    this.currentBondType = 1;
                    this.currentBondIsExplicit = false;
                    this.molHasRing = true;
                    continue;
                }
                if (state == 6) {
                    this.branchStack[this.branchStackPointer++] = this.currentAtomIndex;
                    branchBegan = true;
                    ++i;
                    continue;
                }
                if (state == 7) {
                    if (this.branchStackPointer == 0) {
                        if (this.componentLevel == 0) {
                            throw new MolFormatException("Unmatched closing branch bracket in SMILES string at character " + (i + 1) + " " + smiles);
                        }
                        this.componentLevel -= this.nextComponentLevel;
                        ++this.nextComponentLevel;
                        ++i;
                        continue;
                    }
                    this.currentAtomIndex = this.branchStack[--this.branchStackPointer];
                    branchClosed = true;
                    ++i;
                    continue;
                }
                if (state == 2) {
                    char cn;
                    this.currentBondType = BOND_TYPE_ARRAY[c];
                    int numberOfBondChars = 0;
                    do {
                        cn = this.smilesBuffer[i + ++numberOfBondChars];
                    } while (i < smilen && (cn == '!' || cn == '-' || cn == '=' || cn == '#' || cn == ':' || cn == '~' || cn == '/' || cn == '\\' || cn == '@' || cn == '?' || cn == ',' || cn == ';' || cn == '&'));
                    if (c == '!') {
                        if (numberOfBondChars == 2 && this.smilesBuffer[i + 1] == '@') {
                            this.currentBondType = 2048;
                        } else if (numberOfBondChars == 3 && this.smilesBuffer[i + 1] == '@') {
                            cn = this.smilesBuffer[i + 2];
                            int nextType = BOND_TYPE_ARRAY[cn];
                            if (nextType >= 0 && cn != '\\' && cn != '/') {
                                this.currentBondType = nextType | 0x800;
                            } else {
                                this.queryBondString = new String(this.smilesBuffer, i, numberOfBondChars);
                            }
                        } else {
                            this.queryBondString = new String(this.smilesBuffer, i, numberOfBondChars);
                        }
                        this.currentBondIsExplicit = true;
                        this.querySmarts = true;
                    } else if (numberOfBondChars == 1) {
                        if (c == '@') {
                            this.currentBondType = 1024;
                            this.querySmarts = true;
                            this.currentBondIsExplicit = true;
                        } else if (this.stereo2CheckAllowed) {
                            this.lastBondIsDBSM = this.checkUpDownBond(c, this.doubleBondStereoModifiers, this.smilesBuffer, i);
                            this.currentBondIsExplicit = !this.lastBondIsDBSM;
                        } else {
                            this.currentBondIsExplicit = true;
                        }
                        if (this.currentBondType < 1 || this.currentBondType > 4) {
                            this.querySmarts = true;
                        }
                    } else if (numberOfBondChars == 2) {
                        if (c == '@' && BOND_TYPE_ARRAY[cn = this.smilesBuffer[i + 1]] >= 0) {
                            if (this.stereo2CheckAllowed) {
                                this.lastBondIsDBSM = this.checkUpDownBond(cn, this.doubleBondStereoModifiers, this.smilesBuffer, i);
                            }
                            this.currentBondType = BOND_TYPE_ARRAY[cn] | 0x400;
                        } else if (this.currentBondType > 1 && this.smilesBuffer[i + 1] == '@') {
                            this.currentBondType |= 0x400;
                        } else if (this.currentBondType == 1 && this.smilesBuffer[i + 1] == '?') {
                            if (this.stereo2CheckAllowed) {
                                this.lastBondIsDBSM = this.checkUpDownBond(c, this.doubleBondStereoModifiers, this.smilesBuffer, i);
                            }
                        } else {
                            this.queryBondString = new String(this.smilesBuffer, i, numberOfBondChars);
                        }
                        this.currentBondIsExplicit = true;
                        this.querySmarts = true;
                    } else if (numberOfBondChars == 3) {
                        if (this.smilesBuffer[i + 1] == ',') {
                            cn = this.smilesBuffer[i + 2];
                            int nextBond = BOND_TYPE_ARRAY[cn];
                            if (this.currentBondType == 1 && nextBond == 2) {
                                if (this.stereo2CheckAllowed) {
                                    this.lastBondIsDBSM = this.checkUpDownBond(c, this.doubleBondStereoModifiers, this.smilesBuffer, i);
                                }
                                this.currentBondType = 5;
                            } else if (this.currentBondType == 2 && nextBond == 1) {
                                if (this.stereo2CheckAllowed) {
                                    this.lastBondIsDBSM = this.checkUpDownBond(cn, this.doubleBondStereoModifiers, this.smilesBuffer, i);
                                }
                                this.currentBondType = 5;
                            } else if (this.currentBondType == 1 && nextBond == 4) {
                                if (this.stereo2CheckAllowed) {
                                    this.lastBondIsDBSM = this.checkUpDownBond(c, this.doubleBondStereoModifiers, this.smilesBuffer, i);
                                }
                                this.currentBondType = 6;
                            } else if (this.currentBondType == 4 && nextBond == 1) {
                                if (this.stereo2CheckAllowed) {
                                    this.lastBondIsDBSM = this.checkUpDownBond(cn, this.doubleBondStereoModifiers, this.smilesBuffer, i);
                                }
                                this.currentBondType = 6;
                            } else if (this.currentBondType == 2 && nextBond == 4 || this.currentBondType == 4 && nextBond == 2) {
                                this.currentBondType = 7;
                            } else {
                                this.queryBondString = new String(this.smilesBuffer, i, numberOfBondChars);
                            }
                        } else {
                            this.queryBondString = new String(this.smilesBuffer, i, numberOfBondChars);
                        }
                        this.currentBondIsExplicit = true;
                        this.querySmarts = true;
                    } else {
                        this.queryBondString = new String(this.smilesBuffer, i, numberOfBondChars);
                        this.querySmarts = true;
                    }
                    i += numberOfBondChars;
                    if (this.queryBondString != null) {
                        int flag = SmilesImport.checkUpDownBondInQueryString(this.queryBondString);
                        if (flag != -1) {
                            this.upDownInQuery |= true;
                            int[] adbm = new int[]{this.currentAtomIndex, -1, flag};
                            this.doubleBondStereoModifiers[this.nextStereo2Modifier++] = adbm;
                            this.lastBondIsDBSM = true;
                        }
                        this.currentBondType = 0;
                    }
                    this.bondPosition = i - 1;
                    continue;
                }
                if (state == 8) {
                    if (this.atomCount == 0) {
                        if (c == '.') {
                            ++i;
                            state = 0;
                            this.fragmentStartIdx = this.currentAtomIndex;
                            continue;
                        }
                        int nonws = 0;
                        for (int j = 0; j < smiles.length(); ++j) {
                            char cc = smiles.charAt(j);
                            if (cc == ' ' || cc == '\t' || cc == '\r' || cc == '\n') continue;
                            ++nonws;
                        }
                        if (nonws != 0) {
                            throw new MolFormatException("SMILES string contains no atoms");
                        }
                    }
                    if (c == '.') {
                        ++i;
                        state = 0;
                        this.fragmentStartIdx = this.currentAtomIndex + 1;
                        this.currentAtomIndex = -1;
                        continue;
                    }
                    if (c != ' ' && c != 9) continue;
                    this.fieldBeginIndex = i;
                    continue;
                }
                if (state == -1) {
                    throw new MolFormatException("Error parsing SMILES string '" + smiles + "' at character " + (i + 1) + " ('" + c + "')");
                }
                ++i;
            }
            catch (IndexOutOfBoundsException e) {
                throw new MolFormatException("Error parsing SMILES string '" + smiles + "' at character " + i + " ('" + c + "')");
            }
        }
        if (state >= 0 && this.branchStackPointer > 0) {
            throw new MolFormatException("Unmatched brackets in SMILES string " + smiles);
        }
        for (i = 0; state >= 0 && i < 100; ++i) {
            if (this.ringNodeIndexes[i] == -1) continue;
            throw new MolFormatException("Unmatched ring closure number " + i + " in SMILES string " + smiles);
        }
        mol.endReuse(this.atomCount);
        if (this.querySmarts) {
            BondTable btab = mol.getBondTable();
            BitSet ringBonds = new BitSet();
            Gearch gearch = mol.smol().gearch();
            int sssrCount = gearch.getSSSRCount();
            for (int r = 0; r < sssrCount; ++r) {
                int siz = gearch.getSSSRAtomCount(r);
                for (int ib = 0; ib < siz; ++ib) {
                    int h = gearch.getSSSRAtom(r, ib);
                    int n = gearch.getSSSRAtom(r, (ib + 1) % siz);
                    int idx = btab.getBondIndex(h, n);
                    ringBonds.set(idx);
                }
            }
            SmilesImport.setBondTypes(mol, ringBonds, this.atomFlags, this.explicitBond);
        }
        if (this.parityCheckAllowed) {
            this.paritySmi2Mol(mol, smiles);
        }
        for (i = 0; i < mol.getAtomCount(); ++i) {
            boolean bracket;
            MolAtom a = mol.getAtom(i);
            int an = a.getAtno();
            boolean queryAtom = a.getQueryString() != null || an == 129;
            boolean bl = bracket = (this.atomFlags[i] & 4) != 0;
            if (!bracket) {
                a.setFlags(65536, 65536);
            } else {
                a.setFlags(65536, 65536);
                if (!this.querySmarts) {
                    int impH = a.getImplicitHcount();
                    int valence = a.getValence();
                    if (an == 1) {
                        a.setFlags(65536, 65536);
                    }
                    int radical = -1;
                    if (valence == 0 && impH == 0 && a.getCharge() == 0 && !PeriodicSystem.isNobleGas(a.getAtno())) {
                        a.valenceCheck();
                        if (impH != a.getImplicitHcount()) {
                            a.setValenceProp(0);
                            a.setImplicitHcount(impH);
                        }
                    } else {
                        radical = SmilesImport.radicalNumber(a);
                        if (radical != 0) {
                            a.setRadical(radical);
                        }
                        a.setImplicitHcount(0);
                        a.valenceCheck();
                        if (impH != a.getImplicitHcount()) {
                            if ((an <= 4 || an >= 8) && an != 15 || (this.atomFlags[i] & 3) != 1) {
                                a.setValenceProp(valence);
                            }
                            a.setImplicitHcount(impH);
                        }
                    }
                }
            }
            if (!queryAtom) {
                if ((this.atomFlags[i] & 3) == 1 && SmilesImport.hasAromaticBond(a)) {
                    a.setQueryAromaticity(0);
                } else if ((this.atomFlags[i] & 3) == 1 && !SmilesImport.hasAromaticBond(a)) {
                    a.setQueryAromaticity(1);
                } else if (this.querySmarts) {
                    int qArom;
                    int absOx = MolAtom.numoxstatesOf(an == 129 ? 128 : an) > 0 ? Math.abs(MolAtom.oxstateOf(an, 0)) : 4;
                    int twicesb = a.twicesumbonds(true, false) + SmilesImport.getQueryBondCount(a);
                    int charge = a.getCharge();
                    int freeValence = absOx - twicesb / 2 - charge;
                    if (an == 7 || an == 8 || an == 16) {
                        ++freeValence;
                    }
                    if (freeValence < 3) {
                        int explicitConnection = a.getQPropAsInt("D");
                        if (explicitConnection >= 0) {
                            freeValence = explicitConnection * 2;
                        } else {
                            int allConnection = a.getQPropAsInt("X");
                            if (allConnection >= 0) {
                                freeValence = allConnection - a.getBondCount();
                                freeValence = (int)((double)freeValence * 2.5);
                            }
                        }
                    }
                    if ((qArom = a.getQueryAromaticity()) == 0 && !SmilesImport.hasAromaticBond(a) && (freeValence > 2 && an != 131 && an != 132 && an != 129 && !SmilesImport.isHalogen(an, a) || an == 6 && SmilesImport.canBeAromC(a, freeValence))) {
                        a.setQueryAromaticity(2);
                    } else if (qArom == 3) {
                        a.setQueryAromaticity(0);
                    } else if (an != 131 && qArom == 2 && !SmilesImport.hasAromaticBond(a) && freeValence < 3) {
                        a.setQueryAromaticity(0);
                    }
                }
            } else if (SmilesImport.isHalogen(an, a)) {
                a.setQueryAromaticity(0);
            }
            a.valenceCheck();
        }
        if (this.doubleBondFixes) {
            this.finalizeDoubleBondStereo(mol);
        }
        if (this.fixSmallRingCIS_AromBond) {
            SmilesImport.correctAromaticSystems(mol, this.atomFlags, this.querySmarts, this.explicitBond);
        }
        if (this.upDownInQuery) {
            if (logger.isLoggable(Level.FINER) && DEBUG_SETUPQUERYSTR) {
                logger.finer("setupQueryStringsForCT init");
            }
            SmilesImport.setupQueryStringsForCT(mol, smiles, this.smilesBondIndex);
        }
        if (this.hasAtomWithParity) {
            this.setChiralFlag(mol);
            if (SmilesImport.hasNotSupportedChirality(this.chiralNeighbours, mol)) {
                System.err.println("Not supported chirality type in SMILES: " + smiles);
            }
        }
        return true;
    }

    boolean setChiralFlag(MoleculeGraph m) {
        int c;
        boolean hasChiralCenter = false;
        int ac = m.getAtomCount();
        for (int i = 0; i < ac && !hasChiralCenter; hasChiralCenter |= (c = m.getChirality(i) & 0x18) == 8 || c == 16, ++i) {
        }
        if (hasChiralCenter) {
            m.setAbsStereo(true);
        }
        return hasChiralCenter;
    }

    public static void fixCisInSmallRings(MoleculeGraph m) {
        int i;
        Gearch gearch = m.smol().gearch();
        BondTable btab = m.getBondTable();
        int[] dataToStore = new int[m.getBondCount() * 3];
        int z = 0;
        for (i = gearch.getSSSRCount() - 1; i >= 0; --i) {
            int l = gearch.getSSSRAtomCount(i);
            if (l >= 8) continue;
            for (int j = 0; j < l; ++j) {
                int n;
                int h = gearch.getSSSRAtom(i, (j + 1) % l);
                int bidx = btab.getBondIndex(h, n = gearch.getSSSRAtom(i, (j + 2) % l));
                MolBond b2 = m.getBond(bidx);
                if (b2.getType() != 2) continue;
                int p = gearch.getSSSRAtom(i, j);
                int bidx1 = btab.getBondIndex(p, h);
                MolBond b1 = m.getBond(bidx1);
                int nn = gearch.getSSSRAtom(i, (j + 3) % l);
                int bidx3 = btab.getBondIndex(n, nn);
                MolBond b3 = m.getBond(bidx3);
                if (b1.getType() == 2 || b3.getType() == 2) continue;
                dataToStore[z++] = bidx;
                dataToStore[z++] = p;
                dataToStore[z++] = nn;
            }
        }
        for (i = 0; i < z / 3; ++i) {
            MolBond b = m.getBond(dataToStore[i * 3]);
            int p = dataToStore[i * 3 + 1];
            int nn = dataToStore[i * 3 + 2];
            b.setStereo2Flags(m.getAtom(p), m.getAtom(nn), 128);
        }
    }

    private int readSymbolAndAddAtom(int i, char c, Molecule mol, int smilen) throws IOException {
        int atno;
        int c14;
        int arom = 0;
        int n = c14 = i < smilen - 1 ? (c << 7) + this.smilesBuffer[i + 1] : 0;
        if (c14 == 8684) {
            atno = 17;
            i += 2;
        } else if (c14 == 8562) {
            atno = 35;
            i += 2;
        } else {
            atno = ATNO_ARRAY[c];
            if (atno != 0) {
                arom = IS_AROMATIC[c] ? 1 : 0;
                ++i;
            } else if (c == 'A') {
                atno = 131;
                arom = 2;
                this.querySmarts = true;
                ++i;
            } else if (c == 'a') {
                atno = 131;
                arom = 1;
                this.querySmarts = true;
                ++i;
            } else if (c == '*') {
                atno = 131;
                arom = 3;
                ++i;
            } else {
                throw new MolFormatException("Unrecognized element type \"" + String.valueOf(c) + "\"");
            }
        }
        mol.reuseAtom(atno, this.atomCount);
        if (this.componentLevel > 0) {
            mol.getAtom(this.atomCount).setQProp("c", this.componentLevel);
        }
        if (atno == 131 && arom > 0 && this.querySmarts) {
            MolAtom a = mol.getAtom(this.atomCount);
            a.setQueryAromaticity(arom);
        }
        this.addAtom(mol, arom);
        return i;
    }

    private int readRingNumber(int i, char c, Molecule mol, int sml, String smiles) throws IOException {
        boolean repeatedRingDefinition;
        int ring;
        if (c == '%') {
            ring = 10 * (this.smilesBuffer[i + 1] - 48) + this.smilesBuffer[i + 2] - 48;
            i += 3;
        } else {
            ring = c - 48;
            ++i;
        }
        boolean bl = repeatedRingDefinition = this.ringNodeIndexes[ring] == this.currentAtomIndex;
        if (this.ringNodeIndexes[ring] == -1 || repeatedRingDefinition) {
            this.ringNodeIndexes[ring] = this.currentAtomIndex;
            this.ringBonds[ring] = this.currentBondType;
            this.queryBondStrings[ring] = this.queryBondString != null ? new String(this.queryBondString) : null;
            this.ringBondIsExplicit[ring] = this.currentBondIsExplicit;
            if (this.parityCheckAllowed && this.nextChiralCenter > 0) {
                for (int cc = this.nextChiralCenter - 1; cc >= 0; --cc) {
                    int[] achi = this.chiralNeighbours[cc];
                    if (achi[4] != this.currentAtomIndex || achi[7] >= achi[6]) continue;
                    int n = achi[7];
                    achi[7] = n + 1;
                    achi[n] = -ring;
                    break;
                }
            }
            if (this.stereo2CheckAllowed && this.lastBondIsDBSM) {
                int idx = this.nextStereo2Modifier - 1;
                int[] adbm = this.doubleBondStereoModifiers[idx];
                adbm[1] = ring;
                adbm[2] = adbm[2] | 8;
                this.lastBondIsDBSM = false;
            }
        } else {
            MolAtom a2;
            int i1 = this.ringNodeIndexes[ring];
            int i2 = this.currentAtomIndex;
            MolAtom a1 = mol.getAtom(i1);
            if (SmilesImport.isBoundTo(a1, a2 = mol.getAtom(i2))) {
                throw new MolFormatException("Ring (" + ring + ") formed from two" + " neighboring atoms at smiles " + smiles);
            }
            int t = this.currentBondType;
            if (this.currentBondIsExplicit) {
                t = this.currentBondType;
            } else if (this.ringBondIsExplicit[ring]) {
                t = this.ringBonds[ring];
                this.queryBondString = this.queryBondStrings[ring];
                this.queryBondStrings[ring] = null;
            } else if ((this.atomFlags[i1] & 3) == 1 && (this.atomFlags[i2] & 3) == 1) {
                a1.setQueryAromaticity(0);
                a2.setQueryAromaticity(0);
                t = 4;
            }
            this.currentBondIsExplicit = this.currentBondIsExplicit || this.ringBondIsExplicit[ring];
            MolBond b = null;
            if (this.queryBondString != null || this.possibleQueryBond) {
                t = this.possibleQueryBond ? t : 0;
                b = new QueryBond(a1, a2, t);
                ((QueryBond)b).setQuerystr(this.queryBondString);
            } else {
                b = new MolBond(a1, a2, t);
            }
            mol.add(b);
            if (this.currentBondIsExplicit || this.possibleQueryBond) {
                int bondIdx = mol.getBondCount() - 1;
                if (this.explicitBond == null) {
                    this.explicitBond = new BitSet();
                }
                this.explicitBond.set(bondIdx);
                if (this.smilesBondIndex != null) {
                    if (this.queryBondString != null) {
                        for (int j = 0; j < this.queryBondString.length(); ++j) {
                            this.smilesBondIndex[this.bondPosition - j] = bondIdx;
                        }
                    } else {
                        this.smilesBondIndex[this.bondPosition] = bondIdx;
                    }
                }
            }
            if (this.queryBondString != null) {
                this.queryBondString = null;
            }
            this.possibleQueryBond = false;
            if (this.parityCheckAllowed) {
                for (int tia = 0; tia < this.nextChiralCenter; ++tia) {
                    int[] achi = this.chiralNeighbours[tia];
                    if (achi[4] != i1) continue;
                    for (int mea = 0; mea < achi[7]; ++mea) {
                        if (achi[mea] != -ring) continue;
                        achi[mea] = i2;
                        break;
                    }
                    if (achi[7] < achi[6]) break;
                    achi[5] = achi[5] | 8;
                    break;
                }
                for (int k = this.nextChiralCenter - 1; k >= 0; --k) {
                    if ((this.chiralNeighbours[k][5] & 8) != 0 || this.chiralNeighbours[k][4] != i2) continue;
                    int[] achi = this.chiralNeighbours[k];
                    int n = achi[7];
                    achi[7] = n + 1;
                    achi[n] = i1;
                    if (achi[7] < achi[6]) continue;
                    achi[5] = achi[5] | 8;
                    break;
                }
            }
            if (this.stereo2CheckAllowed && t == 2) {
                int to = -1;
                for (int idx = 0; idx < this.nextStereo2Modifier; ++idx) {
                    int[] adbm = this.doubleBondStereoModifiers[idx];
                    int adbm0 = adbm[0];
                    int adbm1 = adbm[1];
                    if (adbm0 != i1 && adbm1 != i1 && adbm0 != i2 && adbm1 != i2) continue;
                    to = idx;
                    break;
                }
                if (to != -1) {
                    int[] nArray = this.doubleBondStereoModifiers[to];
                    nArray[2] = nArray[2] | 0x80;
                }
            }
            this.ringNodeIndexes[ring] = -1;
            this.ringBondIsExplicit[ring] = false;
            if (this.stereo2CheckAllowed) {
                if (this.lastBondIsDBSM) {
                    int idx = this.nextStereo2Modifier - 1;
                    int[] adbm = this.doubleBondStereoModifiers[idx];
                    adbm[1] = i1;
                    adbm[2] = adbm[2] | 1;
                    adbm[2] = adbm[2] | 0x20;
                    adbm[2] = adbm[2] | 0x40;
                    this.lastBondIsDBSM = false;
                } else {
                    int[] adbm = null;
                    int to = -1;
                    for (int idx = 0; idx < this.nextStereo2Modifier; ++idx) {
                        adbm = this.doubleBondStereoModifiers[idx];
                        if ((adbm[2] & 8) == 0 || adbm[1] != ring) continue;
                        to = idx;
                        break;
                    }
                    if (to != -1) {
                        adbm[1] = i2;
                        adbm[2] = adbm[2] | 1;
                        adbm[2] = adbm[2] | 0x40;
                    }
                }
            }
        }
        return i;
    }

    static boolean isBoundTo(MolAtom n1, MolAtom n2) {
        for (int i = n1.getBondCount() - 1; i >= 0; --i) {
            if (n1.getLigand(i) != n2) continue;
            return true;
        }
        return false;
    }

    private static void correctAromaticSystems(Molecule m, int[] atomFlags, boolean querySmarts, BitSet explicitBond) {
        boolean isChecked = false;
        boolean[] inAromRing = null;
        int nb = m.getBondCount();
        for (int i = 0; i < nb; ++i) {
            MolBond b = m.getBond(i);
            if (explicitBond.get(i) || b.getType() != 4) continue;
            MolAtom a1 = b.getAtom1();
            boolean isAromCount3 = SmilesImport.isAromBondCount3(a1);
            MolAtom a2 = b.getAtom2();
            boolean bl = isAromCount3 = isAromCount3 ? SmilesImport.isAromBondCount3(a2) : false;
            if (!isAromCount3) continue;
            if (!isChecked) {
                isChecked = true;
                inAromRing = new boolean[nb];
                BondTable btab = m.getBondTable();
                SmilesImport.findAromRings(m.smol(), btab, atomFlags, inAromRing);
            }
            if (inAromRing[i] != false) continue;
            if (querySmarts) {
                b.setFlags(6, 15);
                continue;
            }
            b.setFlags(1, 15);
        }
    }

    private static boolean findAromRings(Smolecule smol, BondTable btab, int[] aromAt, boolean[] inAromRing) {
        Gearch gearch = smol.gearch();
        int sssrCount = gearch.getSSSRCount();
        for (int i = 0; i < sssrCount; ++i) {
            int ib;
            int siz = gearch.getSSSRAtomCount(i);
            int nArom = 0;
            for (ib = 0; ib < siz; ++ib) {
                if ((aromAt[gearch.getSSSRAtom(i, ib)] & 3) != 1) continue;
                ++nArom;
            }
            if (nArom != siz) continue;
            for (ib = 0; ib < siz; ++ib) {
                int h = gearch.getSSSRAtom(i, ib);
                int n = gearch.getSSSRAtom(i, (ib + 1) % siz);
                int idx = btab.getBondIndex(h, n);
                inAromRing[idx] = true;
            }
        }
        return true;
    }

    private static boolean isAromBondCount3(MolAtom a) {
        if (a.getBondCount() != 3) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            if (a.getBond(i).getType() == 4) continue;
            return false;
        }
        return true;
    }

    private static boolean hasAromaticBond(MolAtom a) {
        for (int i = 0; i < a.getBondCount(); ++i) {
            if (a.getBond(i).getType() != 4) continue;
            return true;
        }
        return false;
    }

    private static boolean canBeAromC(MolAtom a, int freeVal) {
        if (freeVal != 2) {
            return false;
        }
        for (int i = 0; i < a.getBondCount(); ++i) {
            if (a.getBond(i).getType() != 2) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("readSmiles")) {
            Molecule mol = new Molecule();
            try {
                if (this.readMol((String)arg, mol)) {
                    return mol;
                }
            }
            catch (IOException ex) {}
        } else if (method.equals("readSmartsAtom")) {
            String s = (String)arg;
            MolAtom a = new MolAtom(6);
            if (this.readSmartsAtom(s, a)) {
                return a;
            }
            throw new IllegalArgumentException("Cannot read SMARTS string \"" + s + "\"");
        }
        return null;
    }

    private int addAtom(Molecule mol, int arom) {
        int atom;
        int la = this.currentAtomIndex;
        if (this.atomFlags.length < (atom = this.atomCount++) + 1) {
            int[] tmp = new int[atom + 256];
            System.arraycopy(this.atomFlags, 0, tmp, 0, this.atomFlags.length);
            this.atomFlags = tmp;
        }
        int f = 0;
        f |= arom;
        this.atomFlags[atom] = f |= this.isSmartsAtom ? 4 : 0;
        this.isSmartsAtom = false;
        if (this.currentAtomIndex >= 0) {
            int t = this.currentBondType;
            MolAtom a = mol.getAtom(atom);
            MolAtom lasta = mol.getAtom(this.currentAtomIndex);
            MolBond b = null;
            if (t == 2) {
                t = t | 0x80 | 0x40;
            } else if (!this.querySmarts && t == 1 && !this.currentBondIsExplicit && arom == 1 && (this.atomFlags[this.currentAtomIndex] & 3) == 1) {
                t = 4;
                a.setQueryAromaticity(0);
                lasta.setQueryAromaticity(0);
            }
            if (this.queryBondString != null || this.possibleQueryBond) {
                b = new QueryBond(lasta, a, this.queryBondString);
                if (this.possibleQueryBond) {
                    b.setFlags(t, 3087);
                }
            } else {
                b = new MolBond(lasta, a, t);
            }
            mol.add(b);
            if ((this.currentBondIsExplicit || this.possibleQueryBond) && this.querySmarts) {
                boolean betweenQueryAtoms;
                int bondIdx = mol.indexOf(b);
                this.explicitBond.set(bondIdx);
                if (this.smilesBondIndex != null) {
                    if (this.queryBondString != null) {
                        for (int i = 0; i < this.queryBondString.length(); ++i) {
                            this.smilesBondIndex[this.bondPosition - i] = bondIdx;
                        }
                    } else {
                        this.smilesBondIndex[this.bondPosition] = bondIdx;
                    }
                }
                boolean bl = betweenQueryAtoms = a.getQueryString() == null && lasta.getQueryString() == null;
                if (betweenQueryAtoms && t == 4) {
                    if ((this.atomFlags[atom] & 3) == 0) {
                        a.setQueryAromaticity(2);
                    }
                    if ((this.atomFlags[this.currentAtomIndex] & 3) == 0) {
                        lasta.setQueryAromaticity(2);
                    }
                }
            }
            if (this.queryBondString != null) {
                this.queryBondString = null;
            }
            this.possibleQueryBond = false;
        }
        this.currentAtomIndex = atom;
        return la;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int readSmartsAtom(int first, int last, MolAtom atom, String smiles) throws IOException {
        int arom = 0;
        int prevarom = -1;
        int implicitH = -1;
        int prevop = 44;
        boolean islist = false;
        boolean queryGeneration = false;
        boolean atomHadded = false;
        boolean hasANYatom = false;
        boolean explicitAnd = false;
        boolean atomWithQueryPropOnly = false;
        String querystr = null;
        int listcount = 0;
        int i = first;
        int c = this.smilesBuffer[i];
        int afterIsotope = -1;
        if (c >= 48 && c <= 57) {
            int A = 0;
            do {
                A = 10 * A + (c - 48);
            } while ((c = this.smilesBuffer[++i]) >= 48 && c <= 57);
            if (A == 0) {
                throw new MolFormatException("Atomic mass 0 is not allowed in SMILES string '" + smiles + "' at character " + i);
            }
            atom.setMassno(A);
            afterIsotope = i;
        }
        int op = 32;
        do {
            int x;
            int a;
            block88: {
                block94: {
                    int j;
                    block91: {
                        block92: {
                            block87: {
                                block93: {
                                    char cc;
                                    int j2;
                                    boolean isFirst;
                                    block90: {
                                        if (IS_OPERATOR[c = this.smilesBuffer[i]]) {
                                            op = c;
                                            if (++i >= last) break;
                                            if (c == 44) {
                                                this.querySmarts = true;
                                                if (prevop != 44) {
                                                    queryGeneration = true;
                                                    break;
                                                }
                                                islist = true;
                                                prevarom = arom;
                                                atom.setAtno(128);
                                            } else if (c == 38) {
                                                explicitAnd = true;
                                                if (islist) {
                                                    queryGeneration = true;
                                                    break;
                                                }
                                            } else if (c == 59) {
                                                this.querySmarts = true;
                                            }
                                            c = this.smilesBuffer[i];
                                            if (op == 58 && c >= 48 && c <= 57) {
                                                int aamap = 0;
                                                do {
                                                    aamap = 10 * aamap + (c - 48);
                                                } while ((c = this.smilesBuffer[++i]) >= 48 && c <= 57);
                                                atom.setAtomMap(aamap);
                                                continue;
                                            }
                                            prevop = op;
                                        }
                                        if (c == 33) {
                                            queryGeneration = true;
                                            break;
                                        }
                                        a = 0;
                                        int c14 = c - 65 + (this.smilesBuffer[i + 1] - 97) * 26;
                                        if (c14 <= 0 || c14 >= 1508 || (a = ATNO_ARRAY2[c14]) == 0 || (i + 2 >= last || this.smilesBuffer[i + 2] >= '0' && this.smilesBuffer[i + 2] <= '9') && i + 2 < last || op == 59 || op == 38) break block90;
                                        int n = arom = c >= 97 && c <= 122 ? 1 : 0;
                                        i = this.parityCheckAllowed ? this.getChiSyms(i + 2, smiles, a) : (i += 2);
                                        c = this.smilesBuffer[i];
                                        break block91;
                                    }
                                    a = ATNO_ARRAY[c];
                                    if (a <= 0) break block92;
                                    if (op == 38 && a != 1) {
                                        queryGeneration = true;
                                        break;
                                    }
                                    if (a == 131) {
                                        hasANYatom = true;
                                    }
                                    boolean bl = isFirst = i == first;
                                    if (c != 72 || i == afterIsotope || op == 44) break block93;
                                    int start = i;
                                    int x2 = 0;
                                    for (j2 = i + 1; j2 < last && (cc = this.smilesBuffer[j2]) >= '0' && cc <= '9'; ++j2) {
                                        x2 = 10 * x2 + (cc - 48);
                                    }
                                    if (j2 == i + 1) {
                                        x2 = 1;
                                    }
                                    i = j2 - 1;
                                    if (!isFirst) {
                                        if (op == 38 && explicitAnd || op == 59 || this.querySmarts) {
                                            i = start;
                                            a = 200;
                                        } else {
                                            implicitH = x2;
                                        }
                                        prevop = 38;
                                        break block87;
                                    } else if (start < j2 - 1) {
                                        i = start;
                                        a = 200;
                                        prevop = 38;
                                        break block87;
                                    } else {
                                        atomHadded = true;
                                    }
                                    break block87;
                                }
                                if (c == 72) {
                                    if (i == afterIsotope) {
                                        atomHadded = true;
                                        break block87;
                                    } else {
                                        queryGeneration = true;
                                        break;
                                    }
                                }
                                if (atomHadded) {
                                    queryGeneration = true;
                                    break;
                                }
                                int n = arom = IS_AROMATIC[c] ? 1 : 0;
                            }
                            if (c == 35) {
                                int an = 0;
                                c = this.smilesBuffer[++i];
                                while (c >= 48 && c <= 57) {
                                    an = 10 * an + (c - 48);
                                    c = this.smilesBuffer[++i];
                                }
                                if (an == 0) {
                                    queryGeneration = true;
                                    break;
                                }
                                a = an;
                                --i;
                                arom = 3;
                                this.querySmarts = true;
                            }
                            ++i;
                            if (this.parityCheckAllowed) {
                                i = this.getChiSyms(i, smiles, a);
                            }
                            c = this.smilesBuffer[i];
                            break block91;
                        }
                        if (!(c != 97 && c != 65 || i != first && i != afterIsotope)) {
                            arom = c == 97 ? 1 : 2;
                            a = 131;
                            atom.setAtno(131);
                            c = this.smilesBuffer[++i];
                            this.querySmarts = true;
                        } else if (c == 42 && (i == first || i == afterIsotope)) {
                            a = 131;
                            atom.setAtno(131);
                            c = this.smilesBuffer[++i];
                        } else if (c == 43 || c == 45) {
                            char cc;
                            int charge = c == 43 ? 1 : -1;
                            int x3 = 0;
                            for (j = i + 1; j < last; ++j) {
                                cc = this.smilesBuffer[j];
                                if (cc > '0' && cc <= '9') {
                                    x3 = 10 * x3 + (cc - 48);
                                    continue;
                                }
                                if (cc != '0') break;
                                queryGeneration = true;
                                break;
                            }
                            if (j == i + 1) {
                                ++x3;
                                while (j < last && ((cc = this.smilesBuffer[j]) == '+' || cc == '-')) {
                                    ++x3;
                                    ++j;
                                }
                            }
                            if (j > i + 1) {
                                charge *= x3;
                                i = j - 1;
                            }
                            a = 199;
                            atom.setCharge(charge);
                            prevop = 38;
                            ++i;
                        } else {
                            a = QUERY_PROPERTY_ARRAY[c];
                            if (a != 0) {
                                prevop = 38;
                                ++i;
                            } else {
                                queryGeneration = true;
                                break;
                            }
                        }
                    }
                    c = this.smilesBuffer[i];
                    x = 0;
                    for (j = i; j < last && (c = this.smilesBuffer[j]) >= 48 && c <= 57; ++j) {
                        x = 10 * x + (c - 48);
                    }
                    if (j != i) {
                        i = j;
                    } else {
                        x = -1;
                    }
                    if (a >= 109 && a != 131 && a != 136) break block94;
                    if (!islist) {
                        if (a != 1 || atom.getAtno() <= 0) {
                            atom.setAtno(a);
                            if (arom > 0) {
                                atom.setQueryAromaticity(arom);
                            }
                            this.atomList[listcount++] = a;
                        }
                        break block88;
                    } else {
                        this.atomList[listcount++] = a;
                        if (islist) {
                            if (hasANYatom) {
                                queryGeneration = true;
                                break;
                            }
                            if (prevarom >= 0 && arom != prevarom) {
                                queryGeneration = true;
                                break;
                            }
                            atom.setQueryAromaticity(arom);
                            break block88;
                        } else {
                            queryGeneration = true;
                            break;
                        }
                    }
                }
                if (listcount == 0 && !atomWithQueryPropOnly) {
                    atom.setAtno(131);
                    atomWithQueryPropOnly = true;
                }
            }
            if (a >= 200) {
                if (islist) {
                    queryGeneration = true;
                    break;
                }
                if (a != 200 && atomHadded) {
                    queryGeneration = true;
                    break;
                }
                switch (a) {
                    case 200: {
                        atom.setQProp("H", x >= 0 ? x : 1);
                        this.querySmarts = true;
                        break;
                    }
                    case 214: {
                        atom.setQProp("h", x >= 0 ? x : 1);
                        this.querySmarts = true;
                        break;
                    }
                    case 201: {
                        atom.setValenceProp(x >= 0 ? x : 1);
                        break;
                    }
                    case 202: {
                        atom.setQProp("X", x >= 0 ? x : 1);
                        this.querySmarts = true;
                        break;
                    }
                    case 212: {
                        atom.setQProp("rb", x >= 0 ? x : 1);
                        this.querySmarts = true;
                        break;
                    }
                    case 215: {
                        atom.setQProp("D", x >= 0 ? x : 1);
                        this.querySmarts = true;
                        break;
                    }
                    case 203: {
                        atom.setQProp("R", x >= 0 ? x : 256);
                        this.querySmarts = true;
                        break;
                    }
                    case 204: {
                        atom.setQProp("r", x >= 0 ? x : 256);
                        this.querySmarts = true;
                        break;
                    }
                    case 206: {
                        atom.setQueryAromaticity(1);
                        arom = 1;
                        this.querySmarts = true;
                        break;
                    }
                    case 205: {
                        atom.setQueryAromaticity(2);
                        arom = 2;
                        this.querySmarts = true;
                        break;
                    }
                }
            }
            if (islist) {
                prevarom = arom;
            }
            op = 38;
        } while (i < last);
        if (implicitH >= 0) {
            if (this.querySmarts) {
                queryGeneration = true;
            } else {
                atom.setImplicitHcount(implicitH);
            }
        }
        if (queryGeneration) {
            this.querySmarts = true;
            querystr = new String(this.smilesBuffer, first - 1, last - first + 2);
            atom.setAtno(131);
            atom.setMassno(0);
            atom.clear();
            try {
                if (this.daylightCompatibility) {
                    SmartsAtomQuerifier.setQuerystr(atom, querystr, 1);
                } else {
                    SmartsAtomQuerifier.setQuerystr(atom, querystr, 0);
                }
            }
            catch (IllegalArgumentException e) {
                throw new MolFormatException("Error in smarts atom expression '" + querystr + "'");
            }
            arom = atom.getQueryAromaticity();
        } else if (islist && listcount > 1) {
            if (SmilesImport.allHalogen(this.atomList)) {
                atom.setAtno(136);
                atom.setAliasstr("X");
            } else {
                atom.setList(this.atomList, listcount);
            }
        }
        if (this.componentLevel > 0) {
            atom.setQProp("c", this.componentLevel);
        }
        atom.setFlags(65536, 65536);
        return arom;
    }

    private int getChiSyms(int idx, String smiles, int atno) {
        if (this.smilesBuffer[idx] == '@') {
            this.thisAtomIsChiral = true;
            this.hasAtomWithParity = true;
            int chiralityType = 1;
            this.chiralFlags = 0;
            char chr_n = this.smilesBuffer[idx + 1];
            char chr_nn = this.smilesBuffer[idx + 2];
            if (chr_n == 'T' && chr_nn == 'H') {
                chiralityType = 1;
                idx += 2;
            } else if (chr_n == 'A' && chr_nn == 'L') {
                chiralityType = 2;
                idx += 2;
            } else if (chr_n == 'S' && chr_nn == 'P') {
                chiralityType = 3;
                idx += 2;
            } else if (chr_n == 'T' && chr_nn == 'B') {
                chiralityType = 4;
                idx += 2;
            } else if (chr_n == 'O' && chr_nn == 'H') {
                chiralityType = 5;
                idx += 2;
            }
            boolean numberRead = false;
            int cv = 0;
            char c = this.smilesBuffer[++idx];
            while (c >= '0' && c <= '9') {
                cv = 10 * cv + (c - 48);
                c = this.smilesBuffer[++idx];
                numberRead = true;
            }
            if (!numberRead) {
                if (c == '@') {
                    cv = 2;
                    ++idx;
                } else {
                    cv = 1;
                }
            }
            if (cv > 2 || cv < 1 || chiralityType != 1 && chiralityType != 2) {
                System.err.println("Not supported chirality type in SMILES: " + smiles);
                this.thisAtomIsChiral = false;
            } else {
                this.chiralFlags = cv - 1;
            }
            if (this.smilesBuffer[idx] == '?') {
                this.chiralFlags |= 2;
                ++idx;
                this.querySmarts = true;
            }
            if (this.smilesBuffer[idx] == 'H') {
                this.chiralFlags |= 4;
                ++idx;
            }
            if (this.smilesBuffer[idx] != '+' && atno == 7) {
                this.chiralFlags |= 4;
            }
        }
        return idx;
    }

    private void addChiEntry(int la) {
        if (logger.isLoggable(Level.FINE) && DEBUG_CHIRALITY) {
            logger.fine("chiral atom Idx " + this.currentAtomIndex + " fragment start idx " + this.fragmentStartIdx);
        }
        int[] achi = new int[]{-9999, -9999, -9999, -9999, this.currentAtomIndex, this.chiralFlags, 4, 0, this.branchStackPointer};
        if (this.currentAtomIndex > this.fragmentStartIdx) {
            achi[0] = la;
            achi[7] = 1;
            if ((this.chiralFlags & 4) != 0) {
                achi[5] = achi[5] | 0x10;
            }
        } else {
            achi[5] = achi[5] | 0x40;
        }
        if ((this.chiralFlags & 4) != 0) {
            achi[7] = achi[7] + 1;
        }
        this.chiralNeighbours[this.nextChiralCenter++] = achi;
        this.thisAtomIsChiral = false;
        this.chiralFlags = 0;
    }

    private void devChiEntry(boolean bbeg, boolean bcoac) {
        for (int tia = this.nextChiralCenter - 1; tia >= 0; --tia) {
            int[] achi = this.chiralNeighbours[tia];
            if ((achi[5] & 8) != 0) continue;
            boolean didit = false;
            if (bbeg) {
                if (achi[8] == this.branchStackPointer - 1 && achi[4] == this.branchStack[this.branchStackPointer - 1]) {
                    int n = achi[7];
                    achi[7] = n + 1;
                    achi[n] = this.currentAtomIndex;
                }
                didit = true;
            } else if (bcoac && achi[8] == this.branchStackPointer && achi[7] < achi[6]) {
                int n = achi[7];
                achi[7] = n + 1;
                achi[n] = this.currentAtomIndex;
                didit = true;
            }
            if (!didit) continue;
            if (achi[7] < achi[6]) break;
            achi[5] = achi[5] | 8;
            break;
        }
    }

    private void paritySmi2Mol(Molecule mol, String smiles) throws IOException {
        if (logger.isLoggable(Level.FINE) && DEBUG_CHIRALITY) {
            logger.fine("paritySmi2Mol called");
        }
        for (int i = 0; i < this.nextChiralCenter; ++i) {
            int[] achi = this.chiralNeighbours[i];
            int idx = achi[4];
            MolAtom a = mol.getAtom(idx);
            a.valenceCheck();
            int bc = a.getBondCount();
            if (bc == 2 && SmilesImport.hasOnlyDoubleBond(a)) {
                SmilesImport.allenicParitySMI2Mol(idx, achi, mol);
                continue;
            }
            SmilesImport.tetrahedralParitySmi2Mol(a, achi, mol, smiles);
        }
    }

    private static void tetrahedralParitySmi2Mol(MolAtom a, int[] achi, Molecule mol, String smiles) {
        int par;
        int atno = a.getAtno();
        if (logger.isLoggable(Level.FINER) && DEBUG_CHIRALITY) {
            logger.finer(" S or P " + (atno == 15 || atno == 16) + " bc " + a.getBondCount() + " implicitH " + ((achi[5] & 4) != 0));
        }
        if ((atno == 15 || atno == 16) && a.getBondCount() == 3 && (achi[5] & 4) == 0) {
            achi[5] = achi[5] | 0xC;
            if ((achi[5] & 0x40) == 0) {
                achi[5] = achi[5] | 0x10;
                achi[3] = achi[2];
                achi[2] = achi[1];
                achi[1] = -9999;
            } else {
                achi[3] = achi[2];
                achi[2] = achi[1];
                achi[1] = achi[0];
                achi[0] = -9999;
            }
        }
        if ((achi[5] & 8) != 0) {
            int hys;
            par = 0;
            if ((achi[5] & 1) != 0) {
                int tmp = achi[3];
                achi[3] = achi[2];
                achi[2] = tmp;
            }
            if (logger.isLoggable(Level.FINEST) && DEBUG_CHIRALITY) {
                logger.finest("centerIdx " + achi[4] + " from " + achi[0] + " ligands: " + achi[1] + " " + achi[2] + " " + achi[3] + " flags " + achi[5] + " neighbours " + achi[6] + " neighbours set " + achi[7]);
            }
            int pooh = (hys = (achi[5] & 4) >> 2) == 0 ? -1 : ((achi[5] & 0x10) != 0 ? 1 : 0);
            int largest = -1;
            int max = -1;
            for (int j = 0; j < achi[6]; ++j) {
                int achij = achi[j];
                a = null;
                if (achij >= 0 && (a = mol.getAtom(achij)).getAtno() == 1 && a.getMassno() == 0) {
                    if (++hys > 1) break;
                    pooh = j;
                }
                if (achij <= max) continue;
                largest = j;
                max = achij;
            }
            if (hys <= 1) {
                int smallest;
                int from;
                int n = from = hys == 1 ? pooh : largest;
                if (from != 0) {
                    int tmp = achi[0];
                    achi[0] = achi[from];
                    achi[from] = tmp;
                    int x = from == 1 ? 2 : 1;
                    int y = 6 - from - x;
                    tmp = achi[x];
                    achi[x] = achi[y];
                    achi[y] = tmp;
                }
                par = 1;
                int x = achi[1];
                int y = achi[2];
                int z = achi[3];
                int min = Math.min(Math.min(x, y), z);
                int n2 = x == min ? 1 : (smallest = y == min ? 2 : 3);
                if (smallest == 1 && y > z || smallest == 2 && z > x || smallest == 3 && x > y) {
                    par = 2;
                }
            }
            if ((achi[5] & 2) != 0) {
                par |= 4;
            }
        } else {
            System.err.println("WARNING: Chiral center has wrong connectivity at atom " + (achi[4] + 1) + " in smiles: " + smiles + "\nThe chirality is ignored.");
            par = 0;
        }
        mol.getAtom(achi[4]).setFlags(par, 7);
    }

    private static void allenicParitySMI2Mol(int idx, int[] achi, Molecule m) {
        int ac = m.getAtomCount();
        int[] catom = new int[]{-1, -1, -1, -1};
        int[] idxes = SmilesImport.getAllenicLigands(catom, idx, m);
        if (idxes == null) {
            return;
        }
        int implC = 0;
        for (int i = 0; i < 2; ++i) {
            int imp1 = idxes[i * 2];
            int imp2 = idxes[i * 2 + 1];
            if (imp1 > ac && imp2 > ac) {
                return;
            }
            if (imp1 <= ac && imp2 <= ac) continue;
            ++implC;
        }
        if (implC > 2) {
            return;
        }
        int par = (achi[5] & 1) == 1 ? 1 : 2;
        int pSignMol = MolAtom.paritySign(idxes[0], idxes[1], idxes[2], idxes[3]);
        int[] smiIdxs = new int[]{idxes[0] < ac ? idxes[0] : catom[0], idxes[1] < ac ? idxes[1] : catom[1], idxes[2] < ac ? idxes[2] : catom[2], idxes[3] < ac ? idxes[3] : catom[3]};
        int pSignSmi = MolAtom.paritySign(smiIdxs[0], smiIdxs[1], smiIdxs[2], smiIdxs[3]);
        if (pSignMol != pSignSmi) {
            par ^= 0xFFFFFFFF;
            par &= 3;
        }
        if ((achi[5] & 2) != 0) {
            par |= 4;
        }
        m.getAtom(idx).setFlags(par, 7);
    }

    static int[] getAllenicLigands(int[] clig, int idx, MoleculeGraph m) {
        MolAtom a = m.getAtom(idx);
        if (a.getBondCount() != 2 || !SmilesImport.hasOnlyDoubleBond(a)) {
            return null;
        }
        int[][] ctab = m.getCtab();
        int[] an = ctab[idx];
        int l = an.length;
        int[] o = new int[4];
        int n = 0;
        int cn = 0;
        int depth = 0;
        for (int i = 0; i < l; ++i) {
            int lig = an[i];
            int from = idx;
            int d = 0;
            BitSet used = new BitSet();
            do {
                used.set(lig);
                int[] an_l = ctab[lig];
                MolAtom ligand = m.getAtom(lig);
                int an_ll = an_l.length;
                if (an_ll == 2 && SmilesImport.hasOnlyDoubleBond(ligand)) {
                    int next = SmilesImport.getIndexNotTo(from, an_l);
                    from = lig;
                    lig = next;
                    ++d;
                    if (!used.get(lig)) continue;
                    return null;
                }
                if (an_ll < 4) {
                    for (int j = 0; j < an_ll; ++j) {
                        int index = an_l[j];
                        if (index == from) continue;
                        o[n] = SmilesImport.isHydrogen(m.getAtom(index)) ? (n < 2 ? Integer.MAX_VALUE : 0x7FFFFFFD) : index;
                        ++n;
                        if (clig == null) continue;
                        clig[cn++] = lig;
                    }
                    if (an_ll == 2) {
                        o[n] = n < 2 ? Integer.MAX_VALUE : 0x7FFFFFFD;
                        ++n;
                        if (clig != null) {
                            clig[cn++] = lig;
                        }
                    } else if (an_ll < 2) {
                        return null;
                    }
                    from = -1;
                    continue;
                }
                return null;
            } while (from >= 0);
            if (i == 0) {
                depth = d;
                continue;
            }
            if (depth == d) continue;
            return null;
        }
        return o;
    }

    private static boolean hasOnlyDoubleBond(MolAtom a) {
        int bc = a.getBondCount();
        for (int i = 0; i < bc; ++i) {
            MolBond b = a.getBond(i);
            if (b.getType() == 2) continue;
            return false;
        }
        return true;
    }

    private static int getIndexNotTo(int idx, int[] an) {
        int l = an.length;
        for (int i = 0; i < l; ++i) {
            if (an[i] == idx) continue;
            return an[i];
        }
        return -1;
    }

    static final boolean isHydrogen(MolAtom atom) {
        int atno = atom.getAtno();
        return atno == 1 && atom.getMassno() == 0;
    }

    private void finalizeLastDoubleBond(int la) {
        int idx = this.nextStereo2Modifier - 1;
        int[] adbm = this.doubleBondStereoModifiers[idx];
        adbm[1] = la;
        adbm[2] = adbm[2] | 1;
        this.lastBondIsDBSM = false;
    }

    private void finalizeDoubleBondStereo(Molecule mol) {
        int nbonds = mol.getBondCount();
        for (int i = 0; i < nbonds; ++i) {
            int ia;
            MolAtom a;
            int j;
            MolBond b = mol.getBond(i);
            if (b.getType() != 2) continue;
            MolAtom a2 = b.getAtom1();
            MolAtom a3 = b.getAtom2();
            if (a2.getBondCount() < 2 || a3.getBondCount() < 2) {
                b.setStereo2Flags(null, null, 0);
                continue;
            }
            if (!this.stereo2CheckAllowed) continue;
            int ia1 = -1;
            int ia2 = mol.indexOf(a2);
            int ia3 = mol.indexOf(a3);
            int ia4 = -1;
            int fNode1 = -1;
            int fNode2 = -1;
            boolean ringDoubleConn = false;
            boolean ringConnection1 = false;
            boolean ringEndConnection1 = false;
            boolean ringConnection2 = false;
            boolean ringEndConnection2 = false;
            for (j = 0; j < a2.getBondCount(); ++j) {
                a = a2.getLigand(j);
                ia = mol.indexOf(a);
                fNode1 = this.dbMod(ia, ia2);
                if (fNode1 == -1) continue;
                ia1 = ia;
                ringEndConnection1 = (fNode1 & 0x20) != 0;
                ringConnection1 = (fNode1 & 0x40) != 0;
                ringDoubleConn = (fNode1 & 0x80) != 0;
                break;
            }
            if (fNode1 != -1) {
                for (j = 0; j < a3.getBondCount(); ++j) {
                    a = a3.getLigand(j);
                    ia = mol.indexOf(a);
                    fNode2 = this.dbMod(ia, ia3);
                    if (fNode2 == -1) continue;
                    ia4 = ia;
                    ringEndConnection2 = (fNode2 & 0x20) != 0;
                    ringConnection2 = (fNode2 & 0x40) != 0;
                    ringDoubleConn = ringDoubleConn || (fNode1 & 0x80) != 0;
                    break;
                }
            }
            if (fNode1 == -1 || fNode2 == -1) {
                b.setStereo2Flags(null, null, 192);
                continue;
            }
            int stereo = 0;
            stereo |= (fNode1 & 2) == (fNode2 & 2) ? 64 : 128;
            if (ringDoubleConn) {
                if (ia1 < ia2 && !ringConnection1) {
                    int n = stereo = stereo == 64 ? 128 : 64;
                }
                if (ia4 > ia3 && !ringConnection2 || ringConnection2) {
                    stereo = stereo == 64 ? 128 : 64;
                }
            } else if (ia1 > ia2 && !ringConnection1) {
                int n = stereo = stereo == 64 ? 128 : 64;
            }
            if (ringConnection1 && (ia1 > ia2 && !ringEndConnection1 ^ ringDoubleConn || ia1 < ia2 && ringEndConnection1)) {
                int n = stereo = stereo == 64 ? 128 : 64;
            }
            if (ringConnection2 && (ia4 > ia3 && ringEndConnection2 || ia4 < ia3 && !ringEndConnection2)) {
                int n = stereo = stereo == 64 ? 128 : 64;
            }
            if (((fNode1 | fNode2) & 4) != 0) {
                stereo |= 0x100;
            }
            b.setStereo2Flags(mol.getAtom(ia1), mol.getAtom(ia4), stereo);
        }
    }

    private int dbMod(int a1, int a2) {
        int reply = -1;
        for (int i = 0; i < this.nextStereo2Modifier; ++i) {
            int[] adbm = this.doubleBondStereoModifiers[i];
            int adbm0 = adbm[0];
            int adbm1 = adbm[1];
            if ((adbm0 != a1 || adbm1 != a2) && (adbm0 != a2 || adbm1 != a1)) continue;
            return adbm[2];
        }
        return reply;
    }

    private void initReac(String smi) {
        this.reactionIndex1 = -1;
        this.reactionIndex2 = -1;
        this.reactionIndex3 = smi.length();
        boolean inBracket = false;
        for (int i = 0; i < smi.length(); ++i) {
            char c = smi.charAt(i);
            if (c == '>') {
                if (this.reactionIndex1 < 0) {
                    this.reactionIndex1 = i;
                    continue;
                }
                if (this.reactionIndex2 >= 0) continue;
                this.reactionIndex2 = i;
                continue;
            }
            if (c == ' ' || c == '\t') {
                this.reactionIndex3 = i;
                break;
            }
            if (c == '[') {
                inBracket = true;
                continue;
            }
            if (c == ']') {
                inBracket = false;
                continue;
            }
            if (inBracket) {
                if (c != '#') continue;
                this.querySmarts = true;
                continue;
            }
            if (c != ',' && c != '&' && c != ';' && c != '!') continue;
            this.querySmarts = true;
        }
    }

    boolean initStereo(String smi) {
        this.parityCheckAllowed = false;
        this.stereo2CheckAllowed = false;
        this.doubleBondFixes = false;
        this.molHasRing = false;
        int l = smi.length();
        int npars = 0;
        int ndbss = 0;
        int neb = 0;
        int numberOfBranches = 0;
        for (int i = 0; i < l; ++i) {
            char c = smi.charAt(i);
            if (c == '@') {
                ++npars;
                while (++i < l && (c = smi.charAt(i)) == '@') {
                }
                --i;
                continue;
            }
            if (c == '(') {
                neb = ++numberOfBranches > neb ? numberOfBranches : neb;
                continue;
            }
            if (c == ')') {
                --numberOfBranches;
                continue;
            }
            if (c == '\\' || c == '/') {
                ++ndbss;
                continue;
            }
            if (c != '=') continue;
            this.doubleBondFixes = true;
        }
        this.explicitBond = new BitSet();
        this.chiralNeighbours = null;
        this.doubleBondStereoModifiers = null;
        if (npars > 0 || ndbss > 0) {
            if (npars > 0) {
                this.parityCheckAllowed = true;
                this.chiralNeighbours = new int[npars][];
                this.nextChiralCenter = 0;
                this.thisAtomIsChiral = false;
            }
            if (ndbss > 0) {
                this.doubleBondFixes = true;
                this.stereo2CheckAllowed = true;
                this.doubleBondStereoModifiers = new int[ndbss][];
                this.nextStereo2Modifier = 0;
                this.lastBondIsDBSM = false;
                this.smilesBondIndex = new int[l];
            } else {
                this.smilesBondIndex = null;
            }
            return true;
        }
        this.smilesBondIndex = null;
        return false;
    }

    private static boolean setBondTypes(Molecule m, BitSet ringBonds, int[] atomFlags, BitSet explicitBond) {
        for (int i = 0; i < m.getBondCount(); ++i) {
            boolean aromaliph_2;
            boolean inR;
            MolBond b = m.getBond(i);
            int t = b.getType();
            MolAtom a1 = b.getAtom1();
            MolAtom a2 = b.getAtom2();
            int i1 = m.indexOf(a1);
            int i2 = m.indexOf(a2);
            int arom1 = atomFlags[i1] & 3;
            int arom2 = atomFlags[i2] & 3;
            boolean bl = inR = ringBonds != null ? ringBonds.get(i) : false;
            if (t != 1 || explicitBond != null && explicitBond.get(i)) continue;
            boolean aromaliph_1 = arom1 == 3 || (a1.getAtno() == 129 || a1.getAtno() == 131) && arom1 == 0;
            boolean bl2 = aromaliph_2 = arom2 == 3 || (a2.getAtno() == 129 || a2.getAtno() == 131) && arom2 == 0;
            if ((arom1 == 1 || aromaliph_1) && (arom2 == 1 || aromaliph_2)) {
                t = 6;
            }
            if (inR && arom1 == 1 && arom2 == 1) {
                t = 4;
            }
            b.setFlags(b.getFlags() & 0xFFFFFFF0 | t);
        }
        return true;
    }

    private boolean readReac(String smiles, Molecule mol) throws IOException {
        return SmilesImportX.readReac(this, smiles, mol);
    }

    int readExtendedFeatures(int beginIndex, String line, Molecule m) throws IOException {
        int last = line.length();
        for (int i = beginIndex; i < last; ++i) {
            char c = line.charAt(i);
            if (!(c == '|' | c == ' ' | c == '\t')) continue;
            return i;
        }
        return last;
    }

    static int checkUpDownBondInQueryString(String qs) {
        for (int i = 0; qs != null && i < qs.length(); ++i) {
            char c = qs.charAt(i);
            if (c != '/' && c != '\\') continue;
            return c == '/' ? 2 : 0;
        }
        return -1;
    }

    static void setupQueryStringsForCT(MoleculeGraph m, String smiles, int[] smilesBondIndex) {
        SmilesImportX.setupQueryStringsForCT(m, smiles, smilesBondIndex);
    }

    boolean checkUpDownBond(char c, int[][] dbsm, char[] smiBuff, int i) {
        int flag;
        int n = c == '/' ? 2 : (flag = c == '\\' ? 0 : -1);
        if (flag >= 0) {
            if (smiBuff.length > i + 1 && smiBuff[i + 1] == '?') {
                flag |= 4;
                this.querySmarts = true;
            }
            int[] adbm = new int[]{this.currentAtomIndex, -1, flag};
            dbsm[this.nextStereo2Modifier++] = adbm;
            this.possibleQueryBond = true;
            return true;
        }
        return false;
    }

    static int radicalNumber(MolAtom a) {
        if ((a.getFlags() & 7) != 0) {
            return 0;
        }
        int atno = a.getAtno();
        if (atno > 20 && atno < 31 || atno > 38 && atno < 49 || atno > 56 && atno < 81 || atno > 88 || atno == 2 || atno == 10 || atno == 18 || atno == 36 || atno == 54 || atno == 86) {
            return 0;
        }
        int valence = a.getValence();
        int charge = Math.abs(a.getCharge());
        int noxstate = MolAtom.numoxstatesOf(atno);
        int rad = -1;
        for (int i = 0; i < noxstate && rad < 0; ++i) {
            int vale = Math.abs(MolAtom.oxstateOf(atno, i));
            rad = vale - valence - charge;
        }
        rad = rad == 1 ? 1 : (rad == 2 ? 2 : 0);
        return rad;
    }

    private boolean readSmartsAtom(String s, MolAtom atom) {
        int smilen = s.length();
        if (this.smilesBuffer.length < smilen + 1) {
            this.smilesBuffer = new char[smilen + 16];
        }
        s.getChars(0, smilen, this.smilesBuffer, 0);
        try {
            this.querySmarts = true;
            this.readSmartsAtom(1, smilen - 1, atom, s);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static boolean hasNotSupportedChirality(int[][] chiralFlags, MoleculeGraph m) {
        if (chiralFlags == null) {
            return false;
        }
        for (int i = 0; i < chiralFlags.length; ++i) {
            if (chiralFlags[i] == null || m.getAtom(chiralFlags[i][4]).getBondCount() <= 4) continue;
            return true;
        }
        return false;
    }

    static boolean allHalogen(int[] an) {
        int h = 0;
        block7: for (int i = 0; i < 5; ++i) {
            switch (an[i]) {
                case 0: {
                    continue block7;
                }
                case 9: {
                    h |= 1;
                    continue block7;
                }
                case 17: {
                    h |= 2;
                    continue block7;
                }
                case 35: {
                    h |= 4;
                    continue block7;
                }
                case 53: {
                    h |= 8;
                    continue block7;
                }
                default: {
                    return false;
                }
            }
        }
        return h == 15;
    }

    static boolean isHalogen(int an, MolAtom a) {
        if (an == 129 || an == 128) {
            int[] n = a.getList();
            for (int i = 0; i < n.length; ++i) {
                if (SmilesImport.isHalogen(n[i], null)) continue;
                return false;
            }
            return true;
        }
        if (an == 136 && a.getAliasstr().equals("X")) {
            return true;
        }
        return an == 9 || an == 17 || an == 35 || an == 53 || an == 85;
    }

    static int getQueryBondCount(MolAtom a) {
        int n = 0;
        for (int i = a.getBondCount() - 1; i >= 0; --i) {
            MolBond b = a.getBond(i);
            if (b instanceof QueryBond && b.getType() == 0) {
                ++n;
                continue;
            }
            if (b.getType() != 0) continue;
            n -= 2;
        }
        return n;
    }

    static {
        int i;
        logger = Logger.getLogger(SmilesExport.class.getName());
        DEBUG_PARSE = false;
        DEBUG_SETUPQUERYSTR = false;
        DEBUG_CHIRALITY = false;
        ATNO_ARRAY = new int[128];
        ATNO_ARRAY2 = new int[1508];
        BOND_TYPE_ARRAY = new int[128];
        QUERY_PROPERTY_ARRAY = new int[128];
        IS_AROMATIC = new boolean[128];
        IS_QUERY_ONLY = new boolean[128];
        IS_OPERATOR = new boolean[128];
        NEXTSTATES = new int[128][8];
        RING_NODE_INDEXES_INI = new int[100];
        for (i = 0; i < BOND_TYPE_ARRAY.length; ++i) {
            SmilesImport.BOND_TYPE_ARRAY[i] = -1;
        }
        for (i = 0; i < RING_NODE_INDEXES_INI.length; ++i) {
            SmilesImport.RING_NODE_INDEXES_INI[i] = -1;
        }
        for (i = 1; i < 110; ++i) {
            String s = MolAtom.symbolOf(i);
            if (s.length() == 1) {
                SmilesImport.ATNO_ARRAY[s.charAt((int)0)] = i;
                continue;
            }
            SmilesImport.ATNO_ARRAY2[s.charAt((int)0) - 65 + (s.charAt((int)1) - 97) * 26] = i;
        }
        SmilesImport.ATNO_ARRAY[98] = 5;
        SmilesImport.IS_AROMATIC[98] = true;
        SmilesImport.ATNO_ARRAY[99] = 6;
        SmilesImport.IS_AROMATIC[99] = true;
        SmilesImport.ATNO_ARRAY[110] = 7;
        SmilesImport.IS_AROMATIC[110] = true;
        SmilesImport.ATNO_ARRAY[111] = 8;
        SmilesImport.IS_AROMATIC[111] = true;
        SmilesImport.ATNO_ARRAY[112] = 15;
        SmilesImport.IS_AROMATIC[112] = true;
        SmilesImport.ATNO_ARRAY[115] = 16;
        SmilesImport.IS_AROMATIC[115] = true;
        SmilesImport.ATNO_ARRAY[35] = 131;
        SmilesImport.ATNO_ARRAY2[258] = 14;
        SmilesImport.ATNO_ARRAY2[500] = 33;
        SmilesImport.ATNO_ARRAY2[154] = 34;
        SmilesImport.ATNO_ARRAY2[155] = 52;
        SmilesImport.BOND_TYPE_ARRAY[45] = 1;
        SmilesImport.BOND_TYPE_ARRAY[61] = 2;
        SmilesImport.BOND_TYPE_ARRAY[35] = 3;
        SmilesImport.BOND_TYPE_ARRAY[58] = 4;
        SmilesImport.BOND_TYPE_ARRAY[126] = 0;
        SmilesImport.BOND_TYPE_ARRAY[47] = 1;
        SmilesImport.BOND_TYPE_ARRAY[92] = 1;
        SmilesImport.BOND_TYPE_ARRAY[64] = 0;
        SmilesImport.QUERY_PROPERTY_ARRAY[118] = 201;
        SmilesImport.QUERY_PROPERTY_ARRAY[88] = 202;
        SmilesImport.QUERY_PROPERTY_ARRAY[120] = 212;
        SmilesImport.QUERY_PROPERTY_ARRAY[68] = 215;
        SmilesImport.QUERY_PROPERTY_ARRAY[104] = 214;
        SmilesImport.QUERY_PROPERTY_ARRAY[82] = 203;
        SmilesImport.QUERY_PROPERTY_ARRAY[114] = 204;
        SmilesImport.QUERY_PROPERTY_ARRAY[65] = 205;
        SmilesImport.QUERY_PROPERTY_ARRAY[97] = 206;
        SmilesImport.IS_OPERATOR[59] = true;
        SmilesImport.IS_OPERATOR[44] = true;
        SmilesImport.IS_OPERATOR[38] = true;
        SmilesImport.IS_OPERATOR[58] = true;
        SmilesImport.IS_QUERY_ONLY[33] = true;
        SmilesImport.IS_QUERY_ONLY[59] = true;
        SmilesImport.IS_QUERY_ONLY[44] = true;
        SmilesImport.IS_QUERY_ONLY[38] = true;
        SmilesImport.IS_QUERY_ONLY[48] = true;
        SmilesImport.IS_QUERY_ONLY[49] = true;
        SmilesImport.IS_QUERY_ONLY[36] = true;
        int[][] next = new int[][]{{1, -1, -1, 4, -1, -1, -1, 8}, {1, 2, 3, 4, -1, 6, 7, 8}, {1, -1, 3, 4, -1, -1, -1, -1}, {1, 2, 3, 4, -1, 6, 7, 8}, {5, -1, -1, -1, 5, -1, -1, -1}, {1, 2, 3, 4, -1, 6, 7, 8}, {1, 2, -1, 4, -1, 6, -1, -1}, {1, 2, 3, 4, -1, 6, 7, 8}};
        for (int c = 0; c < 128; ++c) {
            for (int state = 0; state < 8; ++state) {
                SmilesImport.NEXTSTATES[c][state] = ". \n\r\t{".indexOf(c) >= 0 ? next[state][7] : (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 42 ? next[state][0] : ("~-=#:/\\@!".indexOf(c) >= 0 ? next[state][1] : (c >= 48 && c <= 57 || c == 37 ? next[state][2] : (c == 91 ? next[state][3] : (c == 93 ? next[state][4] : (c == 40 ? next[state][5] : (c == 41 ? next[state][6] : -1)))))));
            }
        }
    }
}

