/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.tripos;

import chemaxon.license.LicenseHandler;
import chemaxon.marvin.calculations.ChargePlugin;
import chemaxon.marvin.io.MolExportModule;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.SelectionMolecule;

public class Mol2Export
extends MolExportModule {
    private static String[] ATOM_TYPES = new String[139];

    @Override
    public Object convert(Molecule mol) {
        mol = this.preconvert(mol);
        StringBuffer s = this.stringBuffer;
        s.setLength(0);
        double[] c = new double[mol.getAtomCount()];
        boolean hasCharges = Mol2Export.hasCharge(mol, c);
        SelectionMolecule[] frags = mol.findFrags();
        int[] atomToSubstructure = new int[mol.getAtomCount()];
        for (int i = 0; i < frags.length; ++i) {
            for (int j = 0; j < frags[i].getAtomCount(); ++j) {
                MolAtom a = frags[i].getAtom(j);
                int ai = mol.indexOf(a);
                atomToSubstructure[ai] = i;
            }
        }
        String[] substructureName = new String[frags.length];
        if (frags.length == 1) {
            substructureName[0] = "noname";
        } else {
            for (int i = 0; i < substructureName.length; ++i) {
                substructureName[i] = "fragment" + (i + 1);
            }
        }
        this.appendMoleculeRecord(mol, hasCharges, substructureName.length);
        this.appendAtomRecord(mol, hasCharges, c, atomToSubstructure, substructureName);
        this.appendBondRecord(mol);
        this.appendSubstructureRecord(atomToSubstructure, substructureName);
        return s.toString();
    }

    private void appendMoleculeRecord(Molecule mol, boolean hasCharges, int substructuresCount) {
        int na = mol.getAtomCount();
        StringBuffer s = this.stringBuffer;
        s.append("@<TRIPOS>MOLECULE\n");
        s.append(mol.getName());
        s.append('\n');
        s.append(na);
        s.append(' ');
        s.append(mol.getBondCount());
        if (substructuresCount >= 0) {
            s.append(' ');
            s.append(substructuresCount);
        }
        s.append('\n');
        s.append("SMALL\n");
        if (hasCharges) {
            s.append("USER_CHARGES\n");
        } else {
            s.append("NO_CHARGES\n");
        }
        String comment = null;
        if (comment != null && comment.length() != 0) {
            s.append("****\n");
            s.append(comment);
            s.append('\n');
        }
    }

    private void appendAtomRecord(Molecule mol, boolean hasCharges, double[] charges, int[] atomToSubstructure, String[] substructureName) {
        mol.calcHybridization();
        int na = mol.getAtomCount();
        StringBuffer s = this.stringBuffer;
        s.append("@<TRIPOS>ATOM\n");
        String[] names = Mol2Export.getAtomNames(mol);
        for (int i = 0; i < na; ++i) {
            MolAtom a = mol.getAtom(i);
            s.append(i + 1);
            s.append('\t');
            s.append(names[i]);
            s.append(' ');
            this.appendCoord(a.getX());
            s.append(' ');
            this.appendCoord(a.getY());
            s.append(' ');
            this.appendCoord(a.getZ());
            s.append('\t');
            s.append(Mol2Export.getAtomType(a));
            s.append('\t');
            s.append(atomToSubstructure[i] + 1);
            s.append('\t');
            s.append(substructureName[atomToSubstructure[i]]);
            if (hasCharges) {
                s.append('\t');
                s.append(Mol2Export.formatNumber(charges[i]));
            }
            s.append('\n');
        }
    }

    private void appendBondRecord(Molecule mol) {
        int nb = mol.getBondCount();
        StringBuffer s = this.stringBuffer;
        s.append("@<TRIPOS>BOND\n");
        for (int i = 0; i < nb; ++i) {
            MolBond b = mol.getBond(i);
            s.append(i + 1);
            MolAtom a1 = b.getAtom1();
            MolAtom a2 = b.getAtom2();
            int i1 = mol.indexOf(a1);
            int i2 = mol.indexOf(a2);
            s.append('\t');
            s.append(i1 + 1);
            s.append('\t');
            s.append(i2 + 1);
            s.append('\t');
            s.append(Mol2Export.getBondType(b));
            s.append('\n');
        }
    }

    private void appendSubstructureRecord(int[] atomToSubstructure, String[] substructureName) {
        StringBuffer s = this.stringBuffer;
        s.append("@<TRIPOS>SUBSTRUCTURE\n");
        for (int i = 0; i < substructureName.length; ++i) {
            s.append(i + 1);
            s.append('\t');
            s.append(substructureName[i]);
            s.append('\t');
            int ra = 0;
            for (int j = 0; j < atomToSubstructure.length; ++j) {
                if (atomToSubstructure[j] != i) continue;
                ra = j;
                break;
            }
            s.append(ra + 1);
            s.append('\n');
        }
    }

    @Deprecated
    private static boolean hasCharge(Molecule mol) {
        return Mol2Export.hasCharge(mol, null);
    }

    private static void zero(double[] d) {
        if (d == null) {
            return;
        }
        for (int i = 0; i < d.length; ++i) {
            d[i] = 0.0;
        }
    }

    private static boolean hasCharge(Molecule mol, double[] charges) {
        int na = mol.getAtomCount();
        if (charges == null || charges.length < na) {
            Mol2Export.zero(charges);
            return false;
        }
        try {
            if (!LicenseHandler.getInstance().isLicensed("Charge Plugin Group")) {
                System.err.println("Mol2Export: License not found for charge plugin group. No charges will be written.");
                Mol2Export.zero(charges);
                return false;
            }
            ChargePlugin p = new ChargePlugin(){

                @Override
                public boolean handlesMultiFragmentMolecules() {
                    return true;
                }
            };
            p.setMolecule(mol);
            p.run();
            boolean error = false;
            for (int i = 0; i < na; ++i) {
                double c = p.getTotalCharge(i);
                if (Double.isNaN(c)) {
                    error = true;
                    System.err.println("Mol2Export: Charge on atom " + i + " is NaN, write no charges");
                    break;
                }
                charges[i] = (double)Math.round(c * 10000.0) / 10000.0;
            }
            if (error) {
                Mol2Export.zero(charges);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            System.err.println("Mol2Export: Exception when calculating charges: " + e.getMessage());
            e.printStackTrace();
            System.err.println("No charges will be written to the exported molecule.");
            Mol2Export.zero(charges);
            return false;
        }
    }

    private static String[] getAtomNames(Molecule mol) {
        int na = mol.getAtomCount();
        String[] names = new String[na];
        int[] index = new int[139];
        for (int i = 0; i < na; ++i) {
            int atno;
            MolAtom a = mol.getAtom(i);
            int n = atno = a.getAtno();
            index[n] = index[n] + 1;
            names[i] = a.getSymbol() + index[atno];
        }
        return names;
    }

    private static String getAtomType(MolAtom a) {
        int atno = a.getAtno();
        int chg = a.getCharge();
        boolean arom = a.hasAromaticBond();
        int hs = a.getHybridizationState();
        if (atno == 6) {
            if (hs == 4) {
                return "C.3";
            }
            if (hs == 3) {
                return "C.2";
            }
            if (hs == 2) {
                return "C.1";
            }
            if (arom) {
                return "C.ar";
            }
            if (chg == 1) {
                return "C.cat";
            }
        } else if (atno == 7) {
            if (hs == 4) {
                if (chg > 0) {
                    return "N.4";
                }
                return "N.3";
            }
            if (hs == 3) {
                return "N.2";
            }
            if (hs == 2) {
                return "N.1";
            }
            if (arom) {
                return "N.ar";
            }
        } else if (atno == 8) {
            if (hs == 4) {
                return "O.3";
            }
            if (hs == 3) {
                return "O.2";
            }
        } else if (atno == 16) {
            if (hs == 4) {
                return "S.3";
            }
            if (hs == 3) {
                return "S.2";
            }
        } else if (atno == 15) {
            if (hs == 4) {
                return "P.3";
            }
        } else {
            if (atno == 128) {
                int[] list = a.getList();
                if (list.length == 4) {
                    boolean[] tmp = new boolean[139];
                    for (int i = 0; i < list.length; ++i) {
                        tmp[list[i]] = true;
                    }
                    if (tmp[7] && tmp[8] && tmp[15] && tmp[16]) {
                        return "Het";
                    }
                } else if (list.length == 5) {
                    boolean[] tmp = new boolean[139];
                    for (int i = 0; i < list.length; ++i) {
                        tmp[list[i]] = true;
                    }
                    if (tmp[9] && tmp[17] && tmp[35] && tmp[53] && tmp[85]) {
                        return "Hal";
                    }
                }
                return "Any";
            }
            if (atno == 129) {
                int[] list = a.getList();
                if (list.length == 1 && list[0] == 1) {
                    return "Hev";
                }
                return "Any";
            }
            if (ATOM_TYPES[atno] != null) {
                return ATOM_TYPES[atno];
            }
        }
        return a.getSymbol();
    }

    private static String getBondType(MolBond b) {
        int t = b.getType();
        if (t >= 1 && t <= 3) {
            return String.valueOf(t);
        }
        if (t == 4) {
            return "ar";
        }
        return "un";
    }

    private void appendCoord(double t) {
        StringBuffer sb = new StringBuffer(t < 0.0 ? "    -" : "     ");
        sb.append(Mol2Export.format4digitPosV2(Math.abs(t)));
        String s = sb.toString();
        int l = s.length();
        if (l > 14) {
            this.stringBuffer.append(s.substring(4, l));
        } else {
            this.stringBuffer.append(s.substring(l - 10, l));
        }
    }

    public static String formatNumber(double d) {
        double da = Math.abs(d);
        String s = Mol2Export.format4digitPosV2(da);
        if (s.equals("0.0000") || d >= 0.0) {
            return s;
        }
        return "-" + s;
    }

    private static String format4digitPosV2(double y) {
        StringBuffer sb = new StringBuffer();
        int iy = (int)y;
        int a = (int)(10000.0 * (y - (double)iy) + 0.5);
        if (a == 10000) {
            sb.append(iy + 1);
            sb.append(".0000");
        } else {
            String sa = "0000" + a;
            int l = sa.length();
            sb.append(iy);
            sb.append('.');
            sb.append(sa.substring(l - 4, l));
        }
        return sb.toString();
    }

    static {
        for (int i = 1; i <= 109; ++i) {
            Mol2Export.ATOM_TYPES[i] = MolAtom.symbolOf(i);
        }
        Mol2Export.ATOM_TYPES[131] = "Any";
        Mol2Export.ATOM_TYPES[132] = "Het";
        Mol2Export.ATOM_TYPES[130] = "LP";
    }
}

