/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.tripos;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MolImportModule;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.io.IOException;
import java.util.StringTokenizer;

public class Mol2Import
extends MolImportModule {
    private MolInputStream istream;

    @Override
    public void initMolImport(MolInputStream mis) {
        this.istream = mis;
    }

    @Override
    public boolean readMol(Molecule mol) throws IOException {
        String line;
        mol.clearForImport("mol2");
        int na = 0;
        int nb = 0;
        boolean reading = false;
        while ((line = this.istream.readLine()) != null) {
            if (line.startsWith("@<TRIPOS>MOLECULE")) {
                if (reading) {
                    this.istream.putBackLine();
                    break;
                }
                line = this.istream.readLine();
                mol.setName(line.trim());
                line = this.istream.readLine();
                StringTokenizer st = new StringTokenizer(line);
                String sna = st.nextToken();
                String snb = st.nextToken();
                na = Integer.parseInt(sna);
                nb = Integer.parseInt(snb);
                line = this.istream.readLine();
                line = this.istream.readLine();
                line = this.istream.readLine();
                if (line.startsWith("@<TRIPOS>")) {
                    this.istream.putBackLine();
                } else {
                    line = this.istream.readLine();
                    if (line.startsWith("@<TRIPOS>")) {
                        this.istream.putBackLine();
                    }
                }
                reading = true;
                continue;
            }
            if (line.startsWith("@<TRIPOS>ATOM")) {
                this.readAtomRecord(mol, na);
                continue;
            }
            if (!line.startsWith("@<TRIPOS>BOND")) continue;
            this.readBondRecord(mol, nb);
            mol.valenceCheck();
        }
        return reading;
    }

    private void readAtomRecord(Molecule mol, int na) throws IOException {
        int dim = 0;
        for (int i = 0; i < na; ++i) {
            String line = this.istream.readLine();
            StringTokenizer st = new StringTokenizer(line);
            st.nextToken();
            st.nextToken();
            String sx = st.nextToken();
            String sy = st.nextToken();
            String sz = st.nextToken();
            double x = Mol2Import.readCoord('X', sx);
            double y = Mol2Import.readCoord('Y', sy);
            double z = Mol2Import.readCoord('Z', sz);
            if (z != 0.0) {
                dim = 3;
            } else if (dim == 0 && (x != 0.0 || y != 0.0)) {
                dim = 2;
            }
            String type = st.nextToken();
            MolAtom a = Mol2Import.readAtom(mol, i, type);
            a.setXYZ(x, y, z);
            if (st.hasMoreTokens()) {
                String subst_id = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                String subst_name = st.nextToken();
            }
            if (!st.hasMoreTokens()) continue;
            String schg = st.nextToken();
            try {
                double fchg = Double.valueOf(schg);
                int chg = (int)Math.round(fchg);
                a.setCharge(chg);
                continue;
            }
            catch (NumberFormatException ex) {
                throw new MolFormatException("Invalid charge \"" + schg + "\"");
            }
        }
        mol.endReuse(na);
        mol.setDim(dim);
    }

    private void readBondRecord(Molecule mol, int nb) throws IOException {
        for (int i = 0; i < nb; ++i) {
            String line = this.istream.readLine();
            StringTokenizer st = new StringTokenizer(line);
            st.nextToken();
            int i1 = Mol2Import.readBondIndex(mol, st.nextToken());
            int i2 = Mol2Import.readBondIndex(mol, st.nextToken());
            int order = Mol2Import.readBondOrder(st.nextToken());
            MolBond b = new MolBond(mol.getAtom(i1), mol.getAtom(i2), order);
            mol.add(b);
        }
    }

    @Override
    public Molecule createMol() {
        return new Molecule();
    }

    private static double readCoord(char c, String s) throws MolFormatException {
        try {
            return Double.valueOf(s);
        }
        catch (NumberFormatException ex) {
            throw new MolFormatException("Invalid " + c + " coordinate \"" + s + "\"");
        }
    }

    private static MolAtom readAtom(Molecule mol, int i, String type) {
        int hs = 0;
        int atno = -1;
        int chg = 0;
        int l = type.length();
        String typelc = type.toLowerCase();
        int[] list = null;
        if (typelc.endsWith(".3")) {
            hs = 4;
            type = type.substring(0, l - 2);
        } else if (typelc.endsWith(".2")) {
            hs = 3;
            type = type.substring(0, l - 2);
        } else if (typelc.endsWith(".1")) {
            hs = 2;
            type = type.substring(0, l - 2);
        } else if (typelc.endsWith(".4")) {
            hs = 4;
            type = type.substring(0, l - 2);
            chg = 1;
        } else if (typelc.endsWith(".ar")) {
            type = type.substring(0, l - 3);
        } else if (typelc.endsWith(".co2")) {
            type = type.substring(0, l - 4);
        } else if (typelc.endsWith(".o")) {
            type = type.substring(0, l - 2);
        } else if (typelc.endsWith(".o2")) {
            type = type.substring(0, l - 3);
        } else if (typelc.endsWith(".pl3")) {
            type = type.substring(0, l - 4);
        } else if (typelc.endsWith(".spc")) {
            type = type.substring(0, l - 4);
        } else if (typelc.endsWith(".t3p")) {
            type = type.substring(0, l - 4);
        } else if (typelc.endsWith(".th")) {
            type = type.substring(0, l - 3);
        } else if (typelc.endsWith(".oh")) {
            type = type.substring(0, l - 3);
        }
        if (type.equals("C.cat")) {
            atno = 6;
            chg = 1;
        } else if (type.equals("N.am")) {
            atno = 7;
        } else if (type.equals("Any")) {
            atno = 131;
        } else if (type.equals("Het")) {
            atno = 128;
            list = new int[]{7, 8, 15, 16};
        } else if (type.equals("Hal")) {
            atno = 128;
            list = new int[]{9, 17, 35, 53, 85};
        } else if (type.equals("Hev")) {
            atno = 129;
            list = new int[]{1};
        } else {
            atno = type.equals("LP") ? 130 : (type.equals("Du") ? 131 : (type.equals("Du.C") ? 6 : MolAtom.numOf(type)));
        }
        MolAtom a = mol.reuseAtom(atno, i);
        if (hs != 0) {
            a.setHybridizationState(hs);
        }
        if (list != null) {
            a.setList(list);
        }
        if (chg != 0) {
            a.setCharge(chg);
        }
        return a;
    }

    private static int readBondIndex(Molecule mol, String s) throws MolFormatException {
        int na = mol.getAtomCount();
        try {
            int i = Integer.parseInt(s);
            if (i < 1 || i > na) {
                throw new MolFormatException("Atom index " + i + " is out of range [1.." + na + "] in bond definition");
            }
            return i - 1;
        }
        catch (NumberFormatException ex) {
            throw new MolFormatException("Invalid atom index \"" + s + "\" " + "in bond definition");
        }
    }

    private static int readBondOrder(String s) throws MolFormatException {
        if (s.equals("1")) {
            return 1;
        }
        if (s.equals("2")) {
            return 2;
        }
        if (s.equals("3")) {
            return 3;
        }
        if (s.equals("ar")) {
            return 4;
        }
        if (s.equals("un")) {
            return 0;
        }
        if (s.equals("am")) {
            return 1;
        }
        if (s.equals("du")) {
            return 0;
        }
        throw new MolFormatException("Invalid bond order \"" + s + "\"");
    }
}

