/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.tripos;

import chemaxon.marvin.io.MRecord;
import chemaxon.marvin.io.MRecordParseException;
import chemaxon.marvin.io.formats.AbstractMRecordReader;
import chemaxon.struc.MPropertyContainer;
import java.io.IOException;
import java.io.InputStream;

public class SybylRecordReader
extends AbstractMRecordReader {
    public SybylRecordReader(InputStream istr, String opts) throws IOException {
        super(istr, opts);
    }

    @Override
    public MRecord nextRecord() throws MRecordParseException, IOException {
        return this.nextRecord(false);
    }

    @Override
    public MRecord skipRecord() throws MRecordParseException, IOException {
        return this.nextRecord(true);
    }

    private MRecord nextRecord(boolean skip) throws MRecordParseException, IOException {
        int n0;
        int nb;
        int na;
        boolean insidemol = false;
        StringBuffer sb = skip ? null : new StringBuffer();
        long startpos = this.getFilePointer();
        int lineno = this.getLineCount();
        String line = this.readLine();
        if (line == null) {
            return null;
        }
        if (line.trim().length() < 4) {
            throw new MRecordParseException(this.getPosition(), "line too short");
        }
        this.appendLine(sb, line);
        int nlines = 1;
        try {
            na = this.atoi(line, 4);
        }
        catch (NumberFormatException ex) {
            throw new MRecordParseException(this.getPosition(), "invalid number of atoms in \"" + line + "\"");
        }
        for (int i = 0; i < na; ++i) {
            line = this.readLine();
            if (line == null) {
                return null;
            }
            this.appendLine(sb, line);
            ++nlines;
        }
        line = this.readLine();
        if (line == null || line.length() < 4) {
            throw new MRecordParseException(this.getPosition(), "line too short");
        }
        this.appendLine(sb, line);
        ++nlines;
        try {
            nb = this.atoi(line, 4);
        }
        catch (NumberFormatException ex) {
            throw new MRecordParseException(this.getPosition(), "invalid number of bonds in \"" + line + "\"");
        }
        for (int i = 0; i < nb; ++i) {
            line = this.readLine();
            if (line == null) {
                return null;
            }
            this.appendLine(sb, line);
            ++nlines;
        }
        line = this.readLine();
        if (line == null || line.length() < 4) {
            throw new MRecordParseException(this.getPosition(), "line too short");
        }
        this.appendLine(sb, line);
        ++nlines;
        try {
            n0 = this.atoi(line, 4);
        }
        catch (NumberFormatException ex) {
            throw new MRecordParseException(this.getPosition(), "invalid number in \"" + line + "\"");
        }
        if (n0 != 0) {
            throw new MRecordParseException(this.getPosition(), "wrong last line");
        }
        return nlines != 0 ? this.endMolecule(sb != null ? sb.toString() : null, startpos, lineno) : null;
    }

    private MRecord endMolecule(String str, long startpos, int lineno) {
        boolean skip = str == null;
        int[] map = this.endRecord(skip);
        MPropertyContainer pc = skip ? null : new MPropertyContainer();
        long endpos = this.getFilePointer();
        return new MRecord(startpos, endpos, lineno, str, pc, map);
    }

    private int atoi(String line, int w) {
        int i = 0;
        if (line.length() < i + w) {
            return 0;
        }
        String s = line;
        while (s.charAt(i) == ' ') {
            ++i;
            --w;
        }
        return Integer.parseInt(s.substring(i, i + w));
    }
}

