/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.vectgraphics;

import chemaxon.marvin.io.formats.vectgraphics.EmfOleGraphics2D;
import chemaxon.marvin.io.formats.vectgraphics.VectGraphicsExport;
import java.awt.Dimension;
import java.io.OutputStream;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.emf.EMFGraphics2D;

public class EmfExport
extends VectGraphicsExport {
    private boolean isOleEmf = false;

    public EmfExport() throws ClassNotFoundException, UnsupportedClassVersionError {
        super("EMF", "org.freehep.graphicsio.emf.EMFGraphics2D");
    }

    @Override
    protected VectorGraphics newVectorGraphics(OutputStream out, Dimension d) {
        if (this.isOleEmf) {
            return new EmfOleGraphics2D(out, d);
        }
        return new EMFGraphics2D(out, d);
    }

    @Override
    protected int parseOption(String opts, int i) throws IllegalArgumentException {
        int ii = super.parseOption(opts, i);
        if (ii != i) {
            return ii;
        }
        boolean k = opts.substring(i).startsWith("ole");
        if (k) {
            this.isOleEmf = true;
            return i + "ole".length();
        }
        return i;
    }
}

