/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.vectgraphics;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.image.exporter.ImageExport;
import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.paint.internal.MolPainterCommon;
import chemaxon.struc.Molecule;
import java.awt.Color;
import java.awt.Dimension;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SvgExport
extends ImageExport {
    private static String svgSystemId = "http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd";
    public boolean compressionEnabled;

    public static SVGGraphics2D createSvgGenerator() {
        DOMImplementation domImplementation = GenericDOMImplementation.getDOMImplementation();
        Document document = domImplementation.createDocument(null, "svg", null);
        SVGGeneratorContext context = SVGGeneratorContext.createDefault((Document)document);
        context.setComment("Generated by Marvin with Batik SVG Generator");
        SVGGraphics2D svgGenerator = new SVGGraphics2D(context, false);
        return svgGenerator;
    }

    @Override
    protected Object makeImage(Dimension d) throws MolExportException {
        SVGGraphics2D g = SvgExport.createSvgGenerator();
        g.setSVGCanvasSize(d);
        g.setBackground(this.backgroundColor);
        g.clearRect(0, 0, d.width, d.height);
        return g;
    }

    @Override
    public Object convert(Molecule mol) throws MolExportException {
        mol = this.preconvert(mol);
        SVGGraphics2D svgGenerator = SvgExport.createSvgGenerator();
        MolPainter p = new MolPainter(new MolPainterCommon());
        Dimension size = this.initPainter(p, mol);
        svgGenerator.setSVGCanvasSize(size);
        svgGenerator.setBackground(this.backgroundColor);
        if (this.backgroundColor != null) {
            svgGenerator.setColor(this.backgroundColor);
            if (!this.isAlphaChannelEnabled() && this.backgroundColor.getTransparency() == 1) {
                svgGenerator.fillRect(0, 0, size.width, size.height);
            }
            svgGenerator.setColor(new Color(0));
        }
        this.paint(mol, p, svgGenerator, size);
        return this.doExportImage(svgGenerator, null);
    }

    @Override
    public String modifyFormat(String fmt) {
        String lcfmt = fmt.toLowerCase();
        if (this.compressionEnabled) {
            if (lcfmt.equals("svgz") || lcfmt.equals("svg.gz")) {
                return fmt;
            }
            return "svgz";
        }
        return "svg";
    }

    @Override
    public byte[] doExportImage(Object g, MProgressMonitor pmon) throws MolExportException {
        if (this.saveSource) {
            String comment = ((SVGGraphics2D)g).getGeneratorContext().getComment();
            comment = comment + "\nMolSource:\n" + this.getMolSource();
            ((SVGGraphics2D)g).getGeneratorContext().setComment(comment);
        }
        StringWriter writer = new StringWriter();
        try {
            ((SVGGraphics2D)g).stream((Writer)writer);
            writer.close();
        }
        catch (IOException ex) {
            throw new MolExportException(ex.getMessage());
        }
        String s = writer.toString();
        int i = s.indexOf("http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd");
        if (i >= 0) {
            s = s.substring(0, i) + svgSystemId + s.substring(i + "http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd".length());
        }
        byte[] data = null;
        try {
            data = s.getBytes("UTF-8");
        }
        catch (Exception e) {
            data = s.getBytes();
            System.err.println("Warning: Encoded in the platform's default charset because UTF-8 encoding was failed.");
        }
        if (this.compressionEnabled) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(32768);
            try {
                GZIPOutputStream gzos = new GZIPOutputStream(baos);
                gzos.write(data);
                gzos.close();
            }
            catch (IOException ex) {
                throw new MolExportException(ex.getMessage());
            }
            return baos.toByteArray();
        }
        return data;
    }

    public static String getSystemId() {
        return svgSystemId;
    }

    public static void setSystemId(String s) {
        svgSystemId = s;
    }

    @Override
    protected int parseOption(String opts, int i) throws IllegalArgumentException {
        char c;
        int j;
        int ii = super.parseOption(opts, i);
        if (ii != i) {
            return ii;
        }
        for (j = i; j < opts.length() && " ,\n\r\t".indexOf(c = opts.charAt(j)) < 0; ++j) {
        }
        String lopt = opts.substring(i, j);
        if (lopt.equalsIgnoreCase("nosource")) {
            this.saveSource = false;
        }
        return i += lopt.length();
    }
}

