/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.vectgraphics;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.image.exporter.ImageExport;
import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.paint.internal.MolPainterCommon;
import chemaxon.marvin.swing.ExportGraphics;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.struc.Molecule;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.freehep.graphics2d.VectorGraphics;

public abstract class VectGraphicsExport
extends ImageExport
implements CallbackIface {
    private static Class<?> gcl = null;
    private static String gfmt = null;

    protected VectGraphicsExport(String gformat, String gclassname) throws ClassNotFoundException, UnsupportedClassVersionError {
        gfmt = gformat.toUpperCase();
        if (gcl == null) {
            try {
                gcl = Class.forName(gclassname);
            }
            catch (ClassNotFoundException ex) {
                String errmsg = "Error in " + gfmt + " export: " + ex.getMessage() + " is not found.";
                System.err.println(errmsg);
                throw ex;
            }
            catch (UnsupportedClassVersionError vererr) {
                String jver = System.getProperty("java.version");
                String errmsg = gfmt + " export is not supported in this Java " + "version: " + jver;
                System.err.println(errmsg);
                throw new UnsupportedClassVersionError(errmsg);
            }
        }
    }

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("getGraphics")) {
            Object[] args = (Object[])arg;
            OutputStream out = (OutputStream)args[0];
            Dimension size = (Dimension)args[1];
            Color bgColor = (Color)args[2];
            return this.createGraphics(out, size, bgColor);
        }
        if (method.equals("doExportImage")) {
            Object[] args = (Object[])arg;
            Object o = args[0];
            MProgressMonitor pmon = null;
            if (args.length > 1 && args[1] instanceof MProgressMonitor) {
                pmon = (MProgressMonitor)args[1];
            }
            try {
                return this.doExportImage(o, pmon);
            }
            catch (MolExportException mee) {
                mee.printStackTrace();
                return null;
            }
        }
        if (method.equals("close")) {
            try {
                if (arg instanceof VectorGraphics) {
                    ((VectorGraphics)arg).endExport();
                }
            }
            catch (Throwable thw) {
                System.err.println("Error in VectorGraphics.endExport():" + thw.getMessage());
            }
        }
        return null;
    }

    protected abstract VectorGraphics newVectorGraphics(OutputStream var1, Dimension var2);

    public Graphics createGraphics(OutputStream out, Dimension d, Color bgColor) {
        VectorGraphics g2d;
        try {
            g2d = this.newVectorGraphics(out, d);
            g2d.setDeviceIndependent(true);
            g2d.startExport();
            g2d.setColor(bgColor);
            g2d.setBackground(bgColor);
            if (bgColor.getTransparency() == 1) {
                g2d.fillRect(0, 0, d.width, d.height);
            }
        }
        catch (Throwable thw) {
            thw.printStackTrace();
            System.err.println("Error in the initalization of " + gfmt + "Graphics2D:" + thw.getMessage());
            return null;
        }
        return g2d;
    }

    @Override
    public Object convert(Molecule mol) throws MolExportException {
        mol = this.preconvert(mol);
        MolPainter p = new MolPainter(new MolPainterCommon());
        Dimension d = this.initPainter(p, mol);
        Color bgColor = p.getBackground();
        ExportGraphics eg = new ExportGraphics(d, bgColor);
        Graphics2D vg2 = eg.getGraphics2D(this);
        this.paint(mol, p, vg2, d);
        return this.doExportImage(eg, null);
    }

    @Override
    public byte[] doExportImage(Object o, MProgressMonitor pmon) throws MolExportException {
        Graphics2D vg = null;
        ByteArrayOutputStream out = null;
        if (o instanceof ExportGraphics) {
            vg = ((ExportGraphics)o).getGraphics2D(null);
            out = ((ExportGraphics)o).getOutputStream();
            try {
                if (vg instanceof VectorGraphics) {
                    ((VectorGraphics)vg).endExport();
                }
            }
            catch (Throwable thw) {
                System.err.println("Error in VectorGraphics.endExport():" + thw.getMessage());
            }
        }
        if (out != null) {
            return out.toByteArray();
        }
        return null;
    }
}

