/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.vmn;

import chemaxon.common.util.BasicEnvironment;
import chemaxon.enumeration.homology.StaticRgMoleculeUtil;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MRecord;
import chemaxon.marvin.io.MolImportModule;
import chemaxon.marvin.io.formats.peptide.PeptideReader;
import chemaxon.marvin.io.formats.vmn.VMNRecord;
import chemaxon.marvin.util.AbbrevGroupCollection;
import chemaxon.marvin.util.CleanUtil;
import chemaxon.marvin.util.MolImportUtil;
import chemaxon.marvin.util.VMNAttributeUtil;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.PeriodicSystem;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.MulticenterSgroup;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;
import chemaxon.util.ConfigUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VMNImport
extends MolImportModule {
    private static final String NL = "\n";
    private static final String TAB = "\t";
    private static final String VMN_ERROR_LOG_PREFIX = "VMN error";
    private static final String AMN_ERROR_LOG_PREFIX = "AMN error";
    private static final String ABBREVGROUP_ERROR_LOG_PREFIX = "Abbreviated group error";
    private static final String ATTACH_ATOM = "ATTACH_ATOM";
    private static final String ATTACH_BONDTYPE = "ATTACH_BONDTYPE";
    private static final String FRAGID = "FRAGID";
    private static final String ONC = "ONC";
    private static final String GROUPID = "GROUPID";
    private static final String ATTRIBUTE_PREFIX = "VMN_";
    private static final String REPUNIT_PREFIX = "M";
    private static final int ATTACH_ATOM_STRLEN = "ATTACH_ATOM".length();
    private static final int ATTACH_BONDTYPE_STRLEN = "ATTACH_BONDTYPE".length();
    private static final int ATTRIBUTE_PREFIX_STRLEN = "VMN_".length();
    private static final MolAtom UNKNOWN_PARENT_ATOM = new MolAtom(131);
    private static final String RLIGAND = "RLIGAND";
    private static final double SCALE = 1.2;
    private static final double X_SCALE = 0.08222399999999999;
    private static final double Y_SCALE = 0.06615599999999999;
    private static final Logger logger = Logger.getLogger(VMNImport.class.getName());
    private static volatile AbbrevGroupCollection abbrevGroups = null;
    private static final String ABBREV_GROUP_FILE = "vmn.abbrevgroup";
    private VMNRecord record = null;
    private String path = null;
    private static volatile PeptideReader peptideReader = new PeptideReader();
    private MolAtom[][] groupMolAtoms = null;
    private Molecule[] groupMols = null;
    ArrayList<RGroupAttachment> rgroupAttachments = new ArrayList();

    public static Level getLoggingLevel() {
        return logger.getLevel();
    }

    public static void setLoggingLevel(Level level) {
        logger.setLevel(level);
    }

    @Override
    public void initMolImport(MRecord record, String path) throws IOException {
        this.record = (VMNRecord)record;
        this.path = path;
    }

    @Override
    public void initMolImport(MolInputStream is) throws IOException {
    }

    @Override
    public void setOptions(String opts) {
    }

    @Override
    public boolean readMol(Molecule mol) throws MolFormatException, IOException {
        try {
            return this.read(mol);
        }
        catch (Exception e) {
            logger.throwing("VMNImport", "readMol", e);
            throw new MolFormatException("VMN import failed: " + e.getMessage(), e);
        }
    }

    private boolean read(Molecule mol) throws MolFormatException, IOException {
        logger.fine("molfile: " + this.path + "    molname: " + this.record.molID);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.record.toString());
        }
        this.setRecordAtomAttributes();
        mol.clearForImport("vmn");
        mol.setName(this.record.molID);
        mol.setValenceCheckEnabled(false);
        int groupCount = this.getMaxGroupID() + 1;
        this.groupMolAtoms = new MolAtom[groupCount][];
        this.groupMols = new Molecule[groupCount];
        this.readGroups(mol);
        mol.setGUIContracted(false);
        if (mol instanceof RgMolecule) {
            this.addRGroups((RgMolecule)mol);
            this.setRGroupAttachments((RgMolecule)mol);
        }
        mol.setGUIContracted(true);
        this.readPositionVariations(mol);
        CleanUtil.arrangeComponents(mol);
        this.readRepeatingUnits(mol);
        this.readMoieties(mol);
        VMNImport.clearQProps(mol);
        mol.setGUIContracted(false);
        mol.setValenceCheckEnabled(true);
        mol.valenceCheck();
        if (logger.isLoggable(Level.FINEST)) {
            VMNImport.fillAtomLabels(mol);
        }
        return true;
    }

    private void setRGroupAttachments(RgMolecule rgmol) throws MolFormatException {
        int i;
        boolean guiContracted = rgmol.isGUIContracted();
        rgmol.setGUIContracted(false);
        StaticRgMoleculeUtil srgm = new StaticRgMoleculeUtil(rgmol);
        MoleculeGraph origUnion = rgmol.getGraphUnion();
        while (!this.rgroupAttachments.isEmpty()) {
            int size = this.rgroupAttachments.size();
            for (i = size - 1; i >= 0; --i) {
                MolAtom connectedLigand;
                SgroupAtom sgroupAtom;
                RGroupAttachment rgroupAttachment = this.rgroupAttachments.get(i);
                MolAtom rgroupAtom = rgroupAttachment.rgroupAtom;
                if (rgroupAtom instanceof SgroupAtom && (rgroupAtom = VMNImport.findFreeSgroupAttachmentAtom(sgroupAtom = (SgroupAtom)rgroupAtom)) == null) {
                    logger.severe("VMN error\nNo free Sgroup attachment for: " + sgroupAtom + " in R" + rgmol.rgroupIdOf(sgroupAtom.getSgroup().getAtom(0)));
                    this.rgroupAttachments.remove(i);
                    continue;
                }
                assert (rgroupAtom.getParent() != null) : rgroupAtom;
                int rgroupAtomIndex = origUnion.indexOf(rgroupAtom);
                int rgroupAtomParentIndex = srgm.getParentIndexes(rgroupAtomIndex).get(0);
                MolAtom ratom = origUnion.getAtom(rgroupAtomParentIndex);
                assert (ratom != null);
                MolAtom ratomLigand = rgroupAttachment.ratomLigand;
                assert (ratomLigand != null);
                int order = rgroupAttachment.order;
                int bondType = rgroupAttachment.bondType;
                if (ratomLigand == UNKNOWN_PARENT_ATOM) {
                    if (bondType == 0) {
                        bondType = 0;
                    }
                    MolImportUtil.addCleanedRgroupAttachmentPoint(rgroupAtom, order, bondType);
                    this.rgroupAttachments.remove(i);
                    continue;
                }
                MolBond connection = VMNImport.getConnection(ratom, ratomLigand);
                if (connection == null || !ratom.setLigandOrder(order, connectedLigand = connection.getOtherAtom(ratom))) continue;
                int connectedBondType = connection.getType();
                if (bondType == 0) {
                    bondType = connectedBondType;
                } else if (bondType != connectedBondType) {
                    logger.warning("VMN error\nIncompatible attachment bond types: \nattachment: " + bondType + " R-ligand: " + connectedBondType + NL + "setting R-ligand bond type for attachment");
                    bondType = connectedBondType;
                }
                MolAtom attachment = MolImportUtil.addCleanedRgroupAttachmentPoint(rgroupAtom, order, bondType);
                if (rgroupAtom.getAtno() == 134) {
                    attachment.putProperty(RLIGAND, ratomLigand);
                }
                this.rgroupAttachments.remove(i);
            }
            if (size != this.rgroupAttachments.size()) continue;
            logger.warning("VMN error\nmolfile: " + this.path + " molname: " + this.record.molID + NL + "Number of problematic attachments: " + size + NL + "Problematic attachments: " + this.rgroupAttachments);
            break;
        }
        MoleculeGraph union = rgmol.getGraphUnion();
        for (i = union.getAtomCount() - 1; i >= 0; --i) {
            MolAtom atom = union.getAtom(i);
            if (atom.getAtno() != 138) continue;
            atom.removeProperty(RLIGAND);
        }
        rgmol.setGUIContracted(guiContracted);
    }

    private static MolAtom findFreeSgroupAttachmentAtom(SgroupAtom sgroupAtom) {
        MolAtom[] freeAttachAtoms;
        SuperatomSgroup sgroup = sgroupAtom.getSgroup();
        for (MolAtom atom : freeAttachAtoms = sgroup.getLegalAttachAtoms()) {
            if (MolImportUtil.getFreeRgroupAttachmentCount(atom, sgroup) <= 0) continue;
            return atom;
        }
        return null;
    }

    private static MolBond getConnection(MolAtom atom, MolAtom rligand) {
        MolBond bond = atom.getBondTo(rligand);
        if (bond != null) {
            return bond;
        }
        for (int i = atom.getBondCount() - 1; i >= 0; --i) {
            bond = atom.getBond(i);
            MolAtom ligand = bond.getOtherAtom(atom);
            if (ligand.getProperty(RLIGAND) != rligand) continue;
            return bond;
        }
        return null;
    }

    private static void clearQProps(Molecule mol) {
        MoleculeGraph union = mol.getGraphUnion();
        for (int i = union.getAtomCount() - 1; i >= 0; --i) {
            MolAtom ma = union.getAtom(i);
            ma.setQProp(FRAGID, null);
            ma.setQProp(GROUPID, null);
            ma.setQProp(ONC, null);
        }
    }

    private void setRecordAtomAttributes() {
        for (VMNRecord.AtomAttribute a : this.record.atomAttributes) {
            if (a.group < 0 || a.group >= this.record.groups.length) {
                logger.warning("VMN error\nSkipping atom attribute for non-existing group: " + a.group + NL + "attribute:" + NL + a);
                continue;
            }
            if (a.atom <= 0 || a.atom > this.record.groups[a.group].atoms.length) {
                logger.warning("VMN error\nSkipping atom attribute for non-existing atom: " + a.atom + " in group: " + a.group + NL + "attribute:" + NL + a);
                continue;
            }
            this.record.groups[a.group].atoms[a.atom - 1].addAttribute(a.type, a.value);
        }
    }

    private int getMaxGroupID() {
        int maxID = 0;
        for (VMNRecord.Group group : this.record.groups) {
            maxID = Math.max(group.ID, maxID);
        }
        return maxID;
    }

    private void readGroups(Molecule mol) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            VMNImport.logGroupConnections(this.record);
        }
        if (this.record.groups.length == 1 && this.record.groups[0].ID == 0) {
            this.readAtoms(mol, this.record.groups[0]);
            this.readBonds(this.record.groups[0]);
        } else if (mol instanceof RgMolecule) {
            RgMolecule rgmol = (RgMolecule)mol;
            for (VMNRecord.Group group : this.record.groups) {
                if (group.ID == 0) {
                    this.readAtoms(rgmol, group);
                    continue;
                }
                this.readRGroupAtoms(group);
            }
            for (VMNRecord.Group group : this.record.groups) {
                this.readBonds(group);
            }
        } else {
            throw new MolFormatException("Rgroups can only be added to an RgMolecule.");
        }
    }

    private void addRGroups(RgMolecule rgmol) throws IOException {
        for (VMNRecord.Group group : this.record.groups) {
            if (group.ID == 0) continue;
            this.readAttachments(rgmol, group);
            this.addRGroup(rgmol, group.ID);
        }
    }

    private void readAtoms(Molecule mol, VMNRecord.Group group) {
        MolAtom[] mas = new MolAtom[group.atoms.length];
        for (int i = 0; i < group.atoms.length; ++i) {
            mas[i] = this.createAtom(mol, group.atoms[i]);
            this.setAttributes(mas[i], group.atoms[i], group.ID);
        }
        this.groupMolAtoms[group.ID] = mas;
        this.groupMols[group.ID] = mol;
    }

    private void readRGroupAtoms(VMNRecord.Group group) {
        Molecule m = new Molecule();
        m.clearForImport("vmn");
        this.readAtoms(m, group);
    }

    private void readBonds(VMNRecord.Group group) throws MolFormatException {
        ArrayList<MolBond> aromBonds = new ArrayList<MolBond>();
        Molecule mol = this.groupMols[group.ID];
        MolAtom[] mas = this.groupMolAtoms[group.ID];
        for (int i = 0; i < group.atoms.length; ++i) {
            VMNRecord.Atom atom = group.atoms[i];
            if (i < 0 || i >= mas.length) {
                throw new MolFormatException("Invalid group atom index in R" + group.ID + ": " + i);
            }
            MolAtom ma1 = mas[i];
            for (VMNRecord.Bond bond : atom.bonds) {
                int id = bond.ligand - 1;
                if (id < 0 || id <= i) continue;
                if (id < 0 || id >= mas.length) {
                    throw new MolFormatException("Invalid group atom index in R" + group.ID + ": " + id);
                }
                MolAtom ma2 = mas[id];
                MolBond mb = new MolBond(ma1, ma2);
                int type = VMNImport.getMolBondType(bond.type);
                if (type == 4) {
                    aromBonds.add(mb);
                } else {
                    mb.setType(type);
                }
                boolean straight = mol.indexOf(ma1) < mol.indexOf(ma2);
                mb.setFlags(VMNImport.getMolBondStereo1(bond.stereo, straight), 48);
                mol.add(mb);
            }
        }
        for (MolBond mb : aromBonds) {
            mb.setType(4);
        }
    }

    private void readAttachments(RgMolecule rgmol, VMNRecord.Group group) throws MolFormatException {
        Molecule mol = this.groupMols[group.ID];
        int[] fragIds = mol.findComponentIds();
        for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
            mol.getAtom(i).setQProp(FRAGID, fragIds[i]);
        }
        MolAtom[] mas = this.groupMolAtoms[group.ID];
        for (int i = 0; i < group.atoms.length; ++i) {
            VMNRecord.Atom atom = group.atoms[i];
            MolAtom ma1 = mas[i];
            for (VMNRecord.Bond bond : atom.bonds) {
                if (bond.ligand != 0) continue;
                int onc = VMNImport.getONC(bond.type);
                int mbtype = VMNImport.getMolBondType(VMNImport.getBondType(bond.type));
                int g0 = this.findGroupConnections(group.ID, ma1.getQPropAsInt(FRAGID));
                ma1.setQProp(ONC, onc);
                ma1.setQProp(GROUPID, group.ID);
                this.readAttachment(ma1, group.ID, g0, onc, mbtype);
            }
        }
    }

    private void readAttachment(MolAtom ma1, int groupID, int g0, int onc, int mbtype) throws MolFormatException {
        if (g0 == -1) {
            logger.warning("VMN error\nmolfile: " + this.path + " molname: " + this.record.molID + NL + "groupID=" + groupID + " onc=" + onc + " - attachment point without parent R-atom ligand" + NL + "setting unknown attachment parent");
            this.setAttachment(ma1, UNKNOWN_PARENT_ATOM, mbtype, groupID);
            return;
        }
        logger.finest("readAttachment: groupID=" + groupID + " g0=" + g0 + " onc=" + onc);
        VMNRecord.GroupConnection conn = this.record.groupConnections[g0 + onc - 1];
        if (conn.child != groupID) {
            logger.warning("VMN error\nmolfile: " + this.path + " molname: " + this.record.molID + NL + "groupID=" + groupID + " g0=" + g0 + " onc=" + onc + " - inconsistent attachment data: conn.child (" + conn.child + ") != groupID (" + groupID + ")" + NL + "setting unknown attachment parent");
            this.setAttachment(ma1, UNKNOWN_PARENT_ATOM, mbtype, groupID);
            return;
        }
        int parentID = conn.parent;
        int ligandID = conn.parentAtom;
        assert (ligandID != 0);
        if (ligandID > 0) {
            MolAtom ma2 = this.groupMolAtoms[parentID][ligandID - 1];
            this.setAttachment(ma1, ma2, mbtype, groupID);
        } else {
            logger.finest("groupID=" + groupID + " - redirecting to parent table, parentID=" + parentID);
            this.readAttachment(ma1, parentID, this.findGroupConnections(parentID), -ligandID, mbtype);
        }
    }

    private void setAttachment(MolAtom ra, MolAtom pa, int mbtype, int parentID) {
        int groupID = ra.getQPropAsInt(GROUPID);
        int onc = ra.getQPropAsInt(ONC);
        if (pa instanceof SgroupAtom) {
            SuperatomSgroup sgroup = ((SgroupAtom)pa).getSgroup();
            pa = VMNImport.findRLigand(sgroup, parentID);
            assert (pa != null);
        }
        this.rgroupAttachments.add(new RGroupAttachment(ra, pa, onc, mbtype));
        if (logger.isLoggable(Level.FINER)) {
            ra.setQProp(ATTACH_ATOM + onc, pa);
            ra.setQProp(ATTACH_BONDTYPE + onc, mbtype);
        }
    }

    private static MolAtom findRLigand(SuperatomSgroup sgroup, int rid) {
        MolBond[] xbonds;
        for (MolBond xbond : xbonds = sgroup.findCrossingBonds()) {
            if (xbond.getAtom1().getRgroup() == rid) {
                return xbond.getAtom2();
            }
            if (xbond.getAtom2().getRgroup() != rid) continue;
            return xbond.getAtom1();
        }
        return null;
    }

    private void readPositionVariations(Molecule mol) {
        MolAtom[] mas = this.groupMolAtoms[0];
        for (VMNRecord.PositionVariation posvar : this.record.positionVariations) {
            for (int rid : posvar.groups) {
                MulticenterSgroup sg = new MulticenterSgroup(mol);
                for (int i : posvar.atoms) {
                    mol.setSgroupParent(mas[i - 1], sg, true);
                }
                sg.addCentralAtom();
                MolAtom ca = sg.getCentralAtom();
                MolAtom ra = VMNImport.getRAtom(rid, mol);
                if (ra != null) {
                    mol.add(new MolBond(ra, ca));
                    continue;
                }
                logger.warning("VMN error\nmolfile: " + this.path + " molname: " + this.record.molID + NL + "readPositionVariations: no R-atom with ID: " + rid);
            }
        }
    }

    private void readRepeatingUnits(Molecule mol) {
        this.readRepeatingUnits0(mol);
        if (mol instanceof RgMolecule) {
            RgMolecule rgmol = (RgMolecule)mol;
            for (int i = rgmol.getRgroupCount() - 1; i >= 0; --i) {
                for (int j = rgmol.getRgroupMemberCount(i) - 1; j >= 0; --j) {
                    Molecule m = rgmol.getRgroupMember(i, j);
                    this.readRepeatingUnits0(m);
                }
            }
        }
    }

    private void readRepeatingUnits0(Molecule mol) {
        int count = mol.getAtomCount();
        for (int i = 0; i < count; ++i) {
            int numerotation = mol.getAtom(i).getQPropAsInt("NU");
            if (numerotation == -1) continue;
            String key = REPUNIT_PREFIX + numerotation;
            String range = (String)mol.getAtom(i).getQProp(key);
            RepeatingUnitSgroup sg = new RepeatingUnitSgroup(mol, "ht", 2);
            for (int j = i; j < count; ++j) {
                MolAtom ma = mol.getAtom(j);
                if (numerotation != ma.getQPropAsInt("NU")) continue;
                mol.setSgroupParent(ma, sg, true);
                if (ma instanceof SgroupAtom) {
                    VMNImport.setParentSgroup(((SgroupAtom)ma).getSgroup(), sg);
                }
                ma.setQProp(key, null);
                ma.setQProp("NU", null);
            }
            VMNImport.addCentralAtoms(mol, sg);
            CleanUtil.generateBracketCoords(sg, 1);
            sg.setSubscript(range);
        }
    }

    private void readMoieties(Molecule mol) throws MolFormatException {
        MolAtom[] mas = this.groupMolAtoms[0];
        int[] fragIds = null;
        for (VMNRecord.Moiety moiety : this.record.moieties) {
            if (moiety.minCoefficient == 1 && moiety.maxCoefficient == 1) continue;
            if (fragIds == null) {
                fragIds = mol.getFragIds(1);
            }
            RepeatingUnitSgroup sg = new RepeatingUnitSgroup(mol, 2);
            if (moiety.firstAtom < 1 || moiety.firstAtom > fragIds.length) {
                throw new MolFormatException("Moiety atom reference is out of range.");
            }
            int id = fragIds[moiety.firstAtom - 1];
            for (int i = 0; i < mas.length; ++i) {
                if (fragIds[i] != id) continue;
                mol.setSgroupParent(mas[i], sg, true);
                if (!(mas[i] instanceof SgroupAtom)) continue;
                VMNImport.setParentSgroup(((SgroupAtom)mas[i]).getSgroup(), sg);
            }
            VMNImport.addCentralAtoms(mol, sg);
            CleanUtil.generateBracketCoords(sg, 1);
            sg.setSubscript("" + moiety.minCoefficient + "-" + moiety.maxCoefficient);
        }
    }

    private static void addCentralAtoms(Molecule mol, RepeatingUnitSgroup repunit) {
        for (int i = mol.getSgroupCount() - 1; i >= 0; --i) {
            Sgroup sgroup = mol.getSgroup(i);
            if (sgroup.getType() != 14) continue;
            boolean contains = true;
            for (int j = sgroup.getAtomCount() - 1; j >= 0; --j) {
                if (repunit.hasAtom(sgroup.getAtom(j))) continue;
                contains = false;
                break;
            }
            if (!contains) continue;
            mol.setSgroupParent(((MulticenterSgroup)sgroup).getCentralAtom(), repunit, true);
        }
    }

    private static MolAtom getRAtom(int rid, Molecule mol) {
        for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
            MolAtom atom = mol.getAtom(i);
            if (atom.getRgroup() != rid) continue;
            return atom;
        }
        return null;
    }

    private static void fillAtomLabels(Molecule mol) {
        MoleculeGraph graph = mol.getGraphUnion();
        for (int i = graph.getAtomCount() - 1; i >= 0; --i) {
            VMNImport.fillAtomLabel(mol, graph.getAtom(i));
        }
    }

    private static void fillAtomLabel(Molecule mol, MolAtom ma) {
        String[] keys;
        for (String key : keys = ma.getQPropNames()) {
            if (key.startsWith(ATTACH_ATOM)) {
                MolAtom pa = (MolAtom)ma.getQProp(key);
                int onc = Integer.parseInt(key.substring(ATTACH_ATOM_STRLEN));
                int mbtype = ma.getQPropAsInt(ATTACH_BONDTYPE + onc);
                VMNImport.fillAtomLabel(mol, ma, onc, pa, mbtype);
                continue;
            }
            if (!key.startsWith(ATTRIBUTE_PREFIX)) continue;
            VMNImport.fillAtomLabel(ma, key.substring(ATTRIBUTE_PREFIX_STRLEN), ma.getQPropAsInt(key));
        }
    }

    private static void fillAtomLabel(Molecule mol, MolAtom ma, int onc, MolAtom pa, int mbtype) {
        VMNImport.fillAtomLabel(ma, "" + onc + ":a" + (mol.indexOf(pa) + 1) + ":b" + mbtype);
    }

    private static void fillAtomLabel(MolAtom ma, String name, int value) {
        VMNImport.fillAtomLabel(ma, name + "=" + value);
    }

    private static void fillAtomLabel(MolAtom ma, String name, String value) {
        VMNImport.fillAtomLabel(ma, name + "=" + value);
    }

    private static void fillAtomLabel(MolAtom ma, String str) {
        StringBuffer b = new StringBuffer();
        String label = ma.getExtraLabel();
        if (label != null) {
            b.append(label + "; ");
        }
        b.append(str);
        ma.setExtraLabel(new String(b));
    }

    private void addRGroup(RgMolecule mol, int rid) {
        Molecule[] members;
        Molecule m = this.groupMols[rid];
        for (Molecule member : members = m.convertToFrags()) {
            mol.addRgroup(rid, member);
        }
        this.groupMols[rid] = null;
    }

    private MolAtom createAtom(Molecule mol, VMNRecord.Atom atom) {
        MolAtom ma = null;
        int atno = PeriodicSystem.getAtomicNumber(atom.type);
        if (atno == -1) {
            int rid = VMNImport.getRGroupID(atom.type);
            if (rid != 0) {
                ma = new MolAtom(134);
                ma.setRgroup(rid);
                mol.add(ma);
            } else {
                ma = VMNImport.convertToPeptide(mol, atom.type, atom.getAttributeValue("DL"));
                if (ma == null && (ma = VMNImport.convertToAbbrevGroup(mol, atom.type)) == null) {
                    ma = new MolAtom(136);
                    ma.setAliasstr(atom.type);
                    mol.add(ma);
                }
            }
        } else {
            ma = new MolAtom(atno);
            mol.add(ma);
        }
        ma.setCharge(atom.charge);
        ma.setImplicitHcount(atom.implHCount);
        ma.setX(VMNImport.normX(atom.X));
        ma.setY(VMNImport.normY(atom.Y));
        return ma;
    }

    private void setAttributes(MolAtom ma, VMNRecord.Atom atom, int gid) {
        int numerotation;
        int polymer;
        int carbonring;
        int deuteriumtritium;
        int position;
        int multiplier;
        int valence;
        int massno = atom.getAttributeValue("AM");
        if (massno != -1) {
            ma.setMassno(massno);
        }
        if ((valence = atom.getAttributeValue("AV")) != -1 && ma.getAtno() != 136) {
            ma.setValenceProp(valence);
        }
        if ((multiplier = atom.getAttributeValue("MU")) != -1) {
            VMNAttributeUtil.setMultiplier(ma, multiplier);
        }
        if ((position = atom.getAttributeValue("SP")) != -1) {
            VMNImport.fillAtomLabel(ma, "SP", position);
        }
        if ((deuteriumtritium = atom.getAttributeValue("DT")) != -1) {
            VMNAttributeUtil.setDeuteriumTritium(ma, deuteriumtritium);
        }
        if ((carbonring = atom.getAttributeValue("CR")) != -1) {
            VMNAttributeUtil.setCarbonRing(ma, carbonring);
        }
        if ((polymer = atom.getAttributeValue("PA")) != -1) {
            VMNImport.setCompositeAttributeInLabel(ma, polymer, "PA", new String[]{"MC", "XL", "EG", "DE", "GM"}, new int[]{16, 8, 4, 2, 1});
        }
        if ((numerotation = atom.getAttributeValue("NU")) != -1) {
            if (this.record.data != null) {
                String value;
                String key;
                if (ma.getAtno() == 136) {
                    assert (ma.getAliasstr() != null);
                    key = ma.getAliasstr() + numerotation;
                    value = this.record.data.getValue(gid, key);
                    if (value != null) {
                        VMNAttributeUtil.setTextNotes(ma, value);
                    } else {
                        logger.info("AMN error\nmolfile: " + this.path + " molname: " + this.record.molID + NL + "No AMN data in G" + gid + " for " + key + " File: " + this.path);
                    }
                }
                if (numerotation >= 100) {
                    key = REPUNIT_PREFIX + numerotation;
                    value = this.record.data.getValue(gid, key);
                    if (value != null) {
                        ma.setQProp(key, value);
                        ma.setQProp("NU", numerotation);
                    } else {
                        logger.info("AMN error\nmolfile: " + this.path + " molname: " + this.record.molID + NL + "No AMN data in G" + gid + " for " + key + " File: " + this.path);
                    }
                }
            } else {
                logger.info("AMN error\nmolfile: " + this.path + " molname: " + this.record.molID + NL + "AMN is missing, data cannot be set for NU=" + numerotation);
            }
        }
    }

    private static void setCompositeAttributeInLabel(MolAtom ma, int value, String name, String[] subnames, int[] subtypes) {
        StringBuffer b = new StringBuffer();
        b.append(name + ":");
        for (int i = 0; i < subnames.length; ++i) {
            if (VMNAttributeUtil.getAttributeValue(value, subtypes[i]) == 0) continue;
            b.append(" " + subnames[i]);
        }
        VMNImport.fillAtomLabel(ma, new String(b));
    }

    private static SgroupAtom convertToPeptide(Molecule mol, String name, int dl) {
        if (name.length() != 3) {
            return null;
        }
        char[] peptideLetters = name.toCharArray();
        peptideLetters[0] = Character.toUpperCase(peptideLetters[0]);
        peptideLetters[1] = Character.toLowerCase(peptideLetters[1]);
        peptideLetters[2] = Character.toLowerCase(peptideLetters[2]);
        name = new String(peptideLetters);
        int configuration = 0;
        switch (dl) {
            case 2: {
                configuration = 1;
                break;
            }
            case 4: {
                configuration = 2;
            }
        }
        try {
            return peptideReader.threeLetterStrToSgroup(mol, name, configuration);
        }
        catch (MolFormatException e) {
            return null;
        }
    }

    private static SgroupAtom convertToAbbrevGroup(Molecule mol, String name) {
        if (abbrevGroups == null) {
            VMNImport.loadAbbrevGroups();
        }
        Molecule m = null;
        try {
            m = abbrevGroups.getMolecule(name);
        }
        catch (Exception e) {
            logger.severe("Abbreviated group error\nCould not get abbreviated group.");
            logger.throwing("VMNImport", "convertToAbbrevGroup", e);
            throw new RuntimeException(e);
        }
        if (m == null) {
            return null;
        }
        m.contractSgroups();
        SgroupAtom atom = (SgroupAtom)m.getAtom(0);
        mol.fuse(m);
        return atom;
    }

    private static void loadAbbrevGroups() {
        InputStream is = null;
        String text = null;
        try {
            is = BasicEnvironment.getResourceAsStream(VMNImport.class, ABBREV_GROUP_FILE);
            assert (is != null);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            text = ConfigUtils.getContent(reader);
        }
        catch (IOException e) {
            logger.severe("Abbreviated group error\nloadAbbrevGroups: could not load abbrev group file: vmn.abbrevgroup");
            logger.throwing("VMNImport", "loadAbbrevGroups", e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                logger.severe("Abbreviated group error\nloadAbbrevGroups: could not close abbrev group file: vmn.abbrevgroup");
                logger.throwing("VMNImport", "loadAbbrevGroups", e);
                throw new RuntimeException(e);
            }
        }
        abbrevGroups = new AbbrevGroupCollection(text);
        abbrevGroups.setClean(2, null);
    }

    private static int getRGroupID(String str) {
        if (str.length() < 2 || str.charAt(0) != 'G') {
            return 0;
        }
        try {
            return Integer.parseInt(str.substring(1));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static int getMolBondType(int btype) {
        switch (btype) {
            case 1: 
            case 2: 
            case 3: {
                return btype;
            }
            case 4: {
                return 4;
            }
            case 5: 
            case 6: {
                return 1;
            }
        }
        return 0;
    }

    private static int getMolBondStereo1(int bstereo, boolean straight) {
        switch (bstereo) {
            case 1: 
            case 8: {
                return 0;
            }
            case 2: 
            case 16: {
                return straight ? 32 : 16;
            }
            case 27: {
                return 0;
            }
            case 4: 
            case 32: {
                return straight ? 16 : 32;
            }
            case 6: 
            case 48: {
                return 48;
            }
        }
        return 0;
    }

    private static int getONC(int x) {
        return -x >> 8;
    }

    private static int getBondType(int x) {
        return -x & 0x11;
    }

    private int findGroupConnections(int rid, int fid) throws MolFormatException {
        MolAtom[] mas = this.groupMolAtoms[rid];
        int i = this.findGroupConnections(rid);
        if (i == -1) {
            return -1;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("g0: findGroupConnections: rid=" + rid + " fid=" + fid);
            logger.finest("start index: " + i);
        }
        while (i < this.record.groupConnections.length) {
            int index = this.record.groupConnections[i].childAtom - 1;
            if (this.record.groupConnections[i].child != rid) {
                logger.warning("VMN error\nCould not find fragment ID: " + fid + " in group: R" + rid);
                return -1;
            }
            if (index < 0 || index >= mas.length) {
                throw new MolFormatException("Invalid connection table: child atom index = " + index);
            }
            if (mas[index].getQPropAsInt(FRAGID) == fid) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int findGroupConnections(int rid) {
        if (rid == 0) {
            return -1;
        }
        for (int i = 0; i < this.record.groupConnections.length; ++i) {
            if (this.record.groupConnections[i].child != rid) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Molecule createMol() {
        return new RgMolecule();
    }

    private static double normX(double x) {
        return x * 0.08222399999999999;
    }

    private static double normY(double y) {
        return (y - 50.0) * 0.06615599999999999;
    }

    private static void logGroupConnections(VMNRecord record) {
        StringBuffer b = new StringBuffer();
        b.append("\nChild\tChNode\tParent\tPNode\n");
        for (VMNRecord.GroupConnection conn : record.groupConnections) {
            b.append("" + conn.child + TAB + conn.childAtom + TAB + conn.parent + TAB + conn.parentAtom + NL);
        }
        logger.finer(new String(b));
    }

    private static void setParentSgroup(Sgroup child, Sgroup parent) {
        Sgroup oldParent = child.getParentSgroup();
        if (oldParent != null) {
            oldParent.removeChildSgroup(child);
        }
        parent.addChildSgroup(child);
    }

    private static class RGroupAttachment {
        MolAtom rgroupAtom = null;
        MolAtom ratomLigand = null;
        int order = 0;
        int bondType = 0;

        RGroupAttachment(MolAtom rgroupAtom, MolAtom ratomLigand, int order, int bondType) {
            this.rgroupAtom = rgroupAtom;
            this.ratomLigand = ratomLigand;
            this.order = order;
            this.bondType = bondType;
        }

        public String toString() {
            RgMolecule rgmol = null;
            for (MoleculeGraph parent = this.rgroupAtom.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof RgMolecule)) continue;
                rgmol = (RgMolecule)parent;
                break;
            }
            if (rgmol != null) {
                int rid1 = rgmol.rgroupIdOf(this.rgroupAtom);
                int rid2 = rgmol.rgroupIdOf(this.ratomLigand);
                return "atom " + this.rgroupAtom + " in R" + rid1 + " attached to: atom " + this.ratomLigand + " in " + (rid2 == -1 ? "scaffold" : "R" + rid2);
            }
            return "" + this.rgroupAtom + " attached to: " + this.ratomLigand;
        }
    }
}

