/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.xyz;

import chemaxon.marvin.io.MolExportModule;
import chemaxon.marvin.util.text.LocaleUtil;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.List;
import java.util.ResourceBundle;

public class XYZExport
extends MolExportModule {
    protected void getOptionDescriptors(String fmtname, String optnames, List l) {
        super.getOptionDescriptors(fmtname, "H -H", l);
        ResourceBundle rc = LocaleUtil.getResourceBundle(XYZExport.class.getName(), null);
        XYZExport.getOptionDescriptors(rc, fmtname, null, l);
    }

    @Override
    public Object convert(Molecule mol) {
        StringBuffer s = this.stringBuffer;
        s.setLength(0);
        mol = this.preconvert(mol);
        int na = mol.getAtomCount();
        s.append(String.valueOf(na));
        s.append("\n");
        String name = mol.getName();
        s.append(name);
        this.appendEnergy(mol);
        s.append('\n');
        for (int i = 0; i < na; ++i) {
            MolAtom a = mol.getAtom(i);
            String e = a.getSymbol();
            s.append("   ".substring(e.length()));
            s.append(e);
            double x = a.getX();
            double y = a.getY();
            double z = a.getZ();
            this.appendRight(x);
            this.appendRight(y);
            this.appendRight(z);
            s.append("\n");
        }
        return s.toString();
    }

    private void appendEnergy(Molecule mol) {
        StringBuffer s = this.stringBuffer;
        Double d = null;
        try {
            d = new Double(mol.getProperty("Energy"));
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (d != null) {
            s.append('\t');
            s.append(d.toString());
        }
    }

    @Override
    protected Molecule preconvert(Molecule mol) {
        Molecule m = mol;
        m = super.preconvert(mol);
        if (m == mol) {
            m = mol.cloneMolecule();
        }
        m.setDim(3);
        m.expandSgroups();
        return m;
    }

    private void appendRight(double t) {
        int iy;
        double y = Math.abs(t);
        int b = (int)(100000.0 * (y - (double)(iy = (int)y)) + 0.5);
        if (b == 100000) {
            ++iy;
        }
        String sb = "00000".concat(String.valueOf(b));
        int l = sb.length();
        String r = String.valueOf(iy).concat(".");
        r = r.concat(sb.substring(l - 5, l));
        r = (t < 0.0 ? "         -" : "          ").concat(r);
        l = r.length();
        r = r.substring(l - 15, l);
        this.stringBuffer.append(r);
    }
}

