/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.image.encoder;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ImageEncoder {
    public static final String JPEG_FORMAT_NAME = "jpg";
    public static final String PNG_FORMAT_NAME = "png";
    public static final String BMP_FORMAT_NAME = "bmp";
    public static final String PPM_FORMAT_NAME = "ppm";
    protected String writerFormatStr = "";
    private BufferedImage image = null;
    private String molSource = "";
    private String compressionType = null;
    private ImageWriter writer = null;
    private BufferedImage cachedImage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] encode() throws IOException {
        byte[] retval = null;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ImageOutputStream imgStream = ImageIO.createImageOutputStream(stream);
        try {
            ImageWriter w = this.getImageWriter();
            w.setOutput(imgStream);
            w.write(this.getIIOImage().getMetadata(), this.getIIOImage(), this.createImageWriterParam());
            retval = stream.toByteArray();
        }
        finally {
            imgStream.close();
            stream.close();
        }
        return retval;
    }

    protected BufferedImage createImage(BufferedImage img) {
        return img;
    }

    public BufferedImage getImage() {
        if (this.cachedImage == null) {
            this.cachedImage = this.createImage(this.image);
        }
        return this.cachedImage;
    }

    public void setImage(BufferedImage img) {
        this.image = img;
    }

    public void setMolSource(String source) {
        this.molSource = source;
    }

    public String getMolSource() {
        return this.molSource;
    }

    public List<String> getCompressionTypes() {
        try {
            return Arrays.asList(this.getImageWriter().getDefaultWriteParam().getCompressionTypes());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void setCompressionType(String type) {
        List<String> types = this.getCompressionTypes();
        if (types == null || !types.contains(type)) {
            throw new IllegalArgumentException("The compressionType " + type + " is invalid for " + JPEG_FORMAT_NAME + ".");
        }
        this.compressionType = type;
    }

    public String getCompressionType() {
        return this.compressionType;
    }

    protected ImageWriter createImageWriter(String formatName) throws IOException {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(formatName);
        if (iter.hasNext()) {
            this.writer = iter.next();
            return this.writer;
        }
        throw new IOException("The writer for " + formatName + " coud not be created.");
    }

    protected ImageWriter getImageWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        return this.createImageWriter(this.writerFormatStr);
    }

    protected ImageWriteParam createImageWriterParam() throws IOException {
        return this.getImageWriter().getDefaultWriteParam();
    }

    protected IIOMetadata createIIOMetaData() throws IOException {
        return this.createIIOMetaData(false);
    }

    protected IIOMetadata createIIOMetaData(boolean useCompression) throws IOException {
        IIOMetadata meta = this.getImageWriter().getDefaultImageMetadata(ImageTypeSpecifier.createFromRenderedImage(this.getImage()), this.createImageWriterParam());
        if (meta == null || this.molSource.equals("")) {
            return meta;
        }
        IIOMetadataNode metaroot = (IIOMetadataNode)meta.getAsTree("javax_imageio_1.0");
        for (int i = 0; i < metaroot.getChildNodes().getLength(); ++i) {
            if (metaroot.getChildNodes().item(i).getNodeName().equals("Text")) continue;
            metaroot.removeChild(metaroot.getChildNodes().item(i));
        }
        NodeList textNodes = metaroot.getElementsByTagName("Text");
        Node textNode = null;
        if (textNodes == null || textNodes.getLength() == 0) {
            textNode = new IIOMetadataNode("Text");
            metaroot.appendChild(textNode);
        } else {
            textNode = textNodes.item(0);
        }
        IIOMetadataNode textEntry = new IIOMetadataNode("TextEntry");
        textEntry.setAttribute("keyword", "molSource");
        textEntry.setAttribute("value", new String(this.getMolSource().getBytes("ascii")));
        textEntry.setAttribute("encoding", "ascii");
        textEntry.setAttribute("language", "EN-US");
        textEntry.setAttribute("compression", useCompression ? "zip" : "none");
        textNode.appendChild(textEntry);
        meta.setFromTree("javax_imageio_1.0", metaroot);
        return meta;
    }

    protected List<? extends BufferedImage> getThumbnails() {
        return null;
    }

    private IIOImage getIIOImage() throws IOException {
        return new IIOImage(this.getImage(), this.getThumbnails(), this.createIIOMetaData());
    }
}

