/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.image.encoder;

import chemaxon.marvin.io.image.encoder.ImageEncoder;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.NodeList;

public class PngEncoder
extends ImageEncoder {
    public static final int PNG_COLOR_GRAY = 0;
    public static final int PNG_COLOR_RGB = 2;
    public static final int PNG_COLOR_PALETTE = 3;
    public static final int PNG_COLOR_GRAY_ALPHA = 4;
    public static final int PNG_COLOR_RGB_ALPHA = 6;
    private static final String PNG_META_FORMAT_STR = "javax_imageio_png_1.0";
    public static final String[] IHDR_colorTypeNames = new String[]{"Grayscale", null, "RGB", "Palette", "GrayAlpha", null, "RGBAlpha"};
    private int bitDepth = 32;
    private int transColor;
    private boolean transparentColorPresent = false;

    public PngEncoder() {
        this.writerFormatStr = "png";
    }

    @Override
    protected IIOMetadata createIIOMetaData() throws IOException {
        IIOMetadata meta = super.createIIOMetaData(true);
        IIOMetadataNode root = (IIOMetadataNode)meta.getAsTree(PNG_META_FORMAT_STR);
        NodeList ihdr = root.getElementsByTagName("IHDR");
        IIOMetadataNode ihdrNode = null;
        if (ihdr == null || ihdr.getLength() == 0) {
            ihdrNode = new IIOMetadataNode("IHDR");
            root.appendChild(ihdrNode);
        } else {
            ihdrNode = (IIOMetadataNode)ihdr.item(0);
        }
        int depth = this.getBitDepth();
        if (depth == 24) {
            depth = 8;
        }
        if (depth == 32) {
            depth = 16;
        }
        ihdrNode.setAttribute("bitDepth", Integer.toString(depth));
        ihdrNode.setAttribute("filterMethod", "adaptive");
        ihdrNode.setAttribute("compressionMethod", "deflate");
        ihdrNode.setAttribute("width", Integer.toString(this.getImage().getWidth()));
        ihdrNode.setAttribute("height", Integer.toString(this.getImage().getHeight()));
        int IHDR_colorType = this.getBitDepth() == 1 && this.getBitDepth() == 8 ? 0 : (this.getBitDepth() <= 4 ? 3 : (this.getBitDepth() == 24 ? 2 : 6));
        ihdrNode.setAttribute("colorType", IHDR_colorTypeNames[IHDR_colorType]);
        if (IHDR_colorType != 6 && this.transparentColorPresent) {
            IIOMetadataNode tRNS_node = new IIOMetadataNode("tRNS");
            if (IHDR_colorType == 2) {
                IIOMetadataNode tRNS_RGB = new IIOMetadataNode("tRNS_RGB");
                int red = 0 | (this.transColor & 0xFF0000) >> 16;
                int green = 0 | (this.transColor & 0xFF00) >> 8;
                int blue = 0 | this.transColor & 0xFF;
                tRNS_RGB.setAttribute("red", Integer.toString(red));
                tRNS_RGB.setAttribute("green", Integer.toString(green));
                tRNS_RGB.setAttribute("blue", Integer.toString(blue));
                tRNS_node.appendChild(tRNS_RGB);
            } else if (IHDR_colorType == 3) {
                IIOMetadataNode tRNS_Palette = new IIOMetadataNode("tRNS_PaletteEntry");
                int index = this.getIndexOfTransParentColor();
                if (index >= 0 && index <= 15) {
                    tRNS_Palette.setAttribute("index", Integer.toString(index));
                    tRNS_Palette.setAttribute("alpha", Integer.toString(0));
                }
                tRNS_node.appendChild(tRNS_Palette);
            }
            root.appendChild(tRNS_node);
        }
        ihdrNode.setAttribute("interlaceMethod", "none");
        root.appendChild(ihdrNode);
        meta.setFromTree(PNG_META_FORMAT_STR, root);
        return meta;
    }

    @Override
    protected BufferedImage createImage(BufferedImage image) {
        BufferedImage img;
        if (this.getBitDepth() > 24) {
            return image;
        }
        if (this.getBitDepth() <= 8) {
            byte[][] arrs = this.getColorArrays();
            IndexColorModel cm = new IndexColorModel(this.getBitDepth(), 1 << this.getBitDepth(), arrs[0], arrs[1], arrs[2]);
            img = this.getBitDepth() <= 4 ? new BufferedImage(image.getWidth(), image.getHeight(), 12, cm) : new BufferedImage(image.getWidth(), image.getHeight(), 13, cm);
        } else {
            img = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        }
        img.getGraphics().drawImage(image, 0, 0, null);
        return img;
    }

    public int getBitDepth() {
        return this.bitDepth;
    }

    public void setBitDepth(int depth) {
        if (depth != 1 && depth != 2 && depth != 4 && depth != 8 && depth != 24 && depth != 32) {
            throw new IllegalArgumentException("Bad color depth value given for PNG export. Valid values are: 1, 2, 4, 8, 24, 32");
        }
        this.bitDepth = depth;
    }

    public int getTransparentColor() {
        if (!this.transparentColorPresent) {
            throw new IllegalStateException("Transparent color has not been set yet, or was deleted since it has been set.");
        }
        return this.transColor;
    }

    public void setTransparentColor(int rgb) {
        if (this.getBitDepth() == 1) {
            System.err.println("With color depth 1 the transparency is not supported.");
            return;
        }
        this.transColor = rgb;
        this.transparentColorPresent = true;
    }

    public void removeTransparentColor() {
        this.transparentColorPresent = false;
    }

    private int getIndexOfTransParentColor() {
        byte[][] arr = this.getColorArrays();
        for (int i = 0; i < 1 << this.getBitDepth(); ++i) {
            if (arr[0][i] != (byte)((this.transColor & 0xFF0000) >> 16) || arr[1][i] != (byte)((this.transColor & 0xFF00) >> 8) || arr[2][i] != (byte)(this.transColor & 0xFF)) continue;
            return i;
        }
        return -1;
    }

    private byte[][] getColorArrays() {
        if (this.getBitDepth() > 8) {
            return null;
        }
        byte[] r = new byte[1 << this.getBitDepth()];
        byte[] g = new byte[1 << this.getBitDepth()];
        byte[] b = new byte[1 << this.getBitDepth()];
        switch (this.getBitDepth()) {
            case 8: {
                byte[] reds = new byte[]{0, 34, 68, 102, -120, -86, -52, -1};
                byte[] greens = new byte[]{0, 51, 102, -103, -52, -1};
                byte[] blues = new byte[]{0, 68, 119, -86, -1};
                int index = 255;
                for (int i = 0; i < reds.length; ++i) {
                    for (int j = 0; j < greens.length; ++j) {
                        for (int k = 0; k < blues.length; ++k) {
                            r[index] = reds[i];
                            g[index] = greens[j];
                            b[index] = blues[k];
                            --index;
                        }
                    }
                }
            }
            case 4: {
                r[15] = -128;
                b[15] = 0;
                g[15] = 0;
                b[14] = 0;
                r[14] = 0;
                g[14] = -128;
                g[13] = -128;
                r[13] = -128;
                b[13] = 0;
                g[12] = 0;
                r[12] = 0;
                b[12] = -128;
                b[11] = -128;
                r[11] = -128;
                g[11] = 0;
                r[10] = 0;
                b[10] = -128;
                g[10] = -128;
                b[9] = 0;
                r[9] = 0;
                b[9] = -1;
                r[8] = -1;
                b[8] = 0;
                g[8] = 0;
                r[7] = 0;
                b[7] = -1;
                g[7] = -1;
                b[6] = -1;
                r[6] = -1;
                g[6] = 0;
                b[5] = 0;
                r[5] = 0;
                g[5] = -1;
                g[4] = -1;
                r[4] = -1;
                b[4] = 0;
            }
            case 2: {
                b[3] = -128;
                g[3] = -128;
                r[3] = -128;
                b[2] = -64;
                g[2] = -64;
                r[2] = -64;
            }
            case 1: {
                b[1] = -1;
                g[1] = -1;
                r[1] = -1;
                b[0] = 0;
                g[0] = 0;
                r[0] = 0;
            }
        }
        return new byte[][]{r, g, b};
    }
}

