/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.image.encoder;

import chemaxon.common.util.MProgressMonitor;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;

public class PpmEncoder
implements ImageConsumer {
    protected OutputStream out;
    private ImageProducer producer;
    private int width = -1;
    private int height = -1;
    private int hintflags = 0;
    private boolean started = false;
    private boolean encoding;
    private IOException iox;
    private static final ColorModel rgbModel = ColorModel.getRGBdefault();
    private MProgressMonitor progressMonitor = null;
    private int progressValue;
    private boolean accumulate = false;
    private int[] accumulator;

    public PpmEncoder(Image img, OutputStream o, MProgressMonitor pmon) {
        this(img.getSource(), o, pmon);
    }

    public PpmEncoder(ImageProducer p, OutputStream o, MProgressMonitor pmon) {
        this.producer = p;
        this.out = o;
        this.progressMonitor = pmon;
    }

    public synchronized void encode() throws IOException {
        this.encoding = true;
        this.iox = null;
        this.producer.startProduction(this);
        while (this.encoding) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.iox != null) {
            throw this.iox;
        }
    }

    private void encodePixelsWrapper(int x, int y, int w, int h, int[] rgbPixels, int off, int scansize) throws IOException {
        if (!this.started) {
            this.started = true;
            this.encodeStart(this.width, this.height);
            if ((this.hintflags & 2) == 0) {
                this.accumulate = true;
                this.accumulator = new int[this.width * this.height];
            }
        }
        if (this.accumulate) {
            for (int row = 0; row < h; ++row) {
                System.arraycopy(rgbPixels, row * scansize + off, this.accumulator, (y + row) * this.width + x, w);
            }
        } else {
            this.encodePixels(w, h, rgbPixels, off, scansize);
        }
    }

    private void encodeFinish() throws IOException {
        if (this.accumulate) {
            this.encodePixels(this.width, this.height, this.accumulator, 0, this.width);
            this.accumulator = null;
            this.accumulate = false;
        }
    }

    private synchronized void stop() {
        this.encoding = false;
        this.notifyAll();
    }

    @Override
    public void setDimensions(int width, int height) {
        this.width = width;
        this.height = height;
        if (this.progressMonitor != null) {
            this.progressMonitor.initProgressMonitor("Writing " + height + " scanlines", 0, height);
        }
        this.progressValue = 0;
    }

    @Override
    public void setProperties(Hashtable<?, ?> props) {
    }

    @Override
    public void setColorModel(ColorModel model) {
    }

    @Override
    public void setHints(int hintflags) {
        this.hintflags = hintflags;
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        int[] rgbPixels = new int[w];
        for (int row = 0; row < h; ++row) {
            int rowOff = off + row * scansize;
            for (int col = 0; col < w; ++col) {
                rgbPixels[col] = model.getRGB(pixels[rowOff + col] & 0xFF);
            }
            try {
                this.encodePixelsWrapper(x, y + row, w, 1, rgbPixels, 0, w);
                continue;
            }
            catch (IOException e) {
                this.iox = e;
                this.stop();
                return;
            }
        }
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        if (model == rgbModel) {
            try {
                this.encodePixelsWrapper(x, y, w, h, pixels, off, scansize);
            }
            catch (IOException e) {
                this.iox = e;
                this.stop();
                return;
            }
        } else {
            int[] rgbPixels = new int[w];
            for (int row = 0; row < h; ++row) {
                int rowOff = off + row * scansize;
                for (int col = 0; col < w; ++col) {
                    rgbPixels[col] = model.getRGB(pixels[rowOff + col]);
                }
                try {
                    this.encodePixelsWrapper(x, y + row, w, 1, rgbPixels, 0, w);
                    continue;
                }
                catch (IOException e) {
                    this.iox = e;
                    this.stop();
                    return;
                }
            }
        }
    }

    @Override
    public void imageComplete(int status) {
        if (this.progressMonitor != null) {
            this.progressValue = this.height;
            this.progressMonitor.setProgressValue(this.progressValue);
        }
        this.producer.removeConsumer(this);
        if (status == 4) {
            this.iox = new IOException("image aborted");
        } else {
            try {
                this.encodeFinish();
            }
            catch (IOException e) {
                this.iox = e;
            }
        }
        this.stop();
    }

    void encodeStart(int w, int h) throws IOException {
        PpmEncoder.writeString(this.out, "P6\n");
        PpmEncoder.writeString(this.out, w + " " + h + "\n");
        PpmEncoder.writeString(this.out, "255\n");
    }

    static void writeString(OutputStream out, String str) throws IOException {
        byte[] buf = str.getBytes();
        out.write(buf);
    }

    void encodePixels(int w, int h, int[] rgbPixels, int off, int scansize) throws IOException {
        byte[] ppmPixels = new byte[w * 3];
        for (int row = 0; row < h; ++row) {
            int rowOff = off + row * scansize;
            for (int col = 0; col < w; ++col) {
                int i = rowOff + col;
                int j = col * 3;
                ppmPixels[j] = (byte)((rgbPixels[i] & 0xFF0000) >> 16);
                ppmPixels[j + 1] = (byte)((rgbPixels[i] & 0xFF00) >> 8);
                ppmPixels[j + 2] = (byte)(rgbPixels[i] & 0xFF);
            }
            this.out.write(ppmPixels);
            if (this.progressMonitor == null) continue;
            ++this.progressValue;
            if ((this.progressValue & 3) != 0 || this.progressMonitor.setProgressValue(this.progressValue)) continue;
            this.producer.removeConsumer(this);
        }
    }
}

