/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.image.exporter;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.image.encoder.JpegEncoder;
import chemaxon.marvin.io.image.exporter.ImageExport;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.Molecule;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class JpegExport
extends ImageExport {
    public int qualityValue;

    @Override
    public Object convert(Molecule mol) throws MolExportException {
        BufferedImage img = (BufferedImage)super.convert(mol);
        return this.convert(img);
    }

    public Object convert(BufferedImage img) throws MolExportException {
        JpegEncoder encoder = new JpegEncoder();
        encoder.setImage(img);
        if (this.saveSource) {
            encoder.setMolSource(this.getMolSource());
        }
        encoder.setQuality(this.qualityValue);
        try {
            return encoder.encode();
        }
        catch (IOException e) {
            throw new MolExportException(e);
        }
    }

    @Override
    public Object open(String fmtopts, MPropertyContainer props) throws MolExportException {
        this.qualityValue = 90;
        return super.open(fmtopts, props);
    }

    @Override
    public byte[] doExportImage(Object img, MProgressMonitor pmon) {
        JpegEncoder encoder = new JpegEncoder();
        encoder.setImage((BufferedImage)img);
        if (this.saveSource) {
            encoder.setMolSource(this.getMolSource());
        }
        encoder.setQuality(this.qualityValue);
        try {
            return encoder.encode();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    @Override
    protected int parseOption(String opts, int i) throws IllegalArgumentException {
        int ii = super.parseOption(opts, i);
        if (ii != i) {
            return ii;
        }
        char c = opts.charAt(i);
        if (c == 'Q') {
            int j = JpegExport.findEndInt(opts, i + 1);
            long k = JpegExport.readLong(opts, i + 1, j, 10, "Quality (Q)");
            if (k < 0L || k > 100L) {
                throw new IllegalArgumentException("Invalid quality (Q) argument");
            }
            this.qualityValue = (int)k;
            i = j;
        } else {
            int j;
            for (j = i; j < opts.length() && " ,\n\r\t".indexOf(c = opts.charAt(j)) < 0; ++j) {
            }
            String lopt = opts.substring(i, j);
            if (lopt.equalsIgnoreCase("nosource")) {
                this.saveSource = false;
            }
            i += lopt.length();
        }
        return i;
    }
}

