/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.image.exporter;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.image.encoder.PpmEncoder;
import chemaxon.marvin.io.image.exporter.ImageExport;
import chemaxon.struc.Molecule;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PpmExport
extends ImageExport {
    @Override
    public Object convert(Molecule mol) throws MolExportException {
        Image img = (Image)super.convert(mol);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            PpmEncoder encoder = new PpmEncoder(img, (OutputStream)out, null);
            encoder.encode();
        }
        catch (IOException ex) {
            throw new MolExportException(ex.getMessage());
        }
        return out.toByteArray();
    }

    @Override
    public byte[] doExportImage(Object img, MProgressMonitor pmon) throws MolExportException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            PpmEncoder encoder = new PpmEncoder((Image)img, (OutputStream)baos, pmon);
            encoder.encode();
        }
        catch (IOException ex) {
            throw new MolExportException(ex.getMessage());
        }
        return baos.toByteArray();
    }
}

