/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;

public class OSRA {
    private static final String OSRA_EXECUTABLE;
    private static final String OSRA_PARAMETERS = "-ep -f sdf";
    private static final String FILE_SEPARATOR;
    private static boolean available;
    private static boolean checked;

    public static synchronized boolean isAvailable() {
        String osraEnvVar;
        if (checked) {
            return available;
        }
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(OSRA_EXECUTABLE + " --version");
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (p != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String line = null;
                while (!available && (line = reader.readLine()) != null) {
                    if (!line.toLowerCase().contains("osra")) continue;
                    available = true;
                }
                available &= 0 == p.waitFor();
            }
        }
        catch (IOException e) {
            available = false;
        }
        catch (InterruptedException e) {
            available = false;
        }
        if (!available && (osraEnvVar = System.getenv("OSRA")) != null) {
            File f = new File(osraEnvVar + (osraEnvVar.endsWith("/") || osraEnvVar.endsWith(FILE_SEPARATOR) ? "" : "/") + OSRA_EXECUTABLE);
            available = f.exists();
        }
        checked = true;
        return available;
    }

    public static byte[] readSDFFromStream(InputStream stream) throws IOException {
        int bytesRead;
        if (!OSRA.isAvailable()) {
            return new byte[0];
        }
        File f = File.createTempFile("chemaxon", ".tmp");
        f.deleteOnExit();
        BufferedOutputStream tempFileStream = new BufferedOutputStream(new FileOutputStream(f));
        BufferedInputStream wrappedStream = new BufferedInputStream(stream);
        if (stream.markSupported()) {
            stream.mark(Integer.MAX_VALUE);
        }
        byte[] buffer = new byte[256];
        while ((bytesRead = wrappedStream.read(buffer)) != -1) {
            tempFileStream.write(buffer, 0, bytesRead);
        }
        tempFileStream.flush();
        tempFileStream.close();
        if (stream.markSupported()) {
            stream.reset();
        }
        try {
            return OSRA.readSDFFromFile(f);
        }
        catch (InterruptedException e) {
            return new byte[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readSDFFromFile(File file) throws IOException, InterruptedException {
        if (file == null || !file.exists() || !OSRA.isAvailable()) {
            return new byte[0];
        }
        BufferedReader processOutputStreamReader = null;
        try {
            Object path;
            String OSRAEnvVar = System.getenv("OSRA");
            Process process = null;
            if (OSRAEnvVar != null && !OSRAEnvVar.isEmpty()) {
                path = new File(OSRAEnvVar);
                if (((File)path).exists()) {
                    process = Runtime.getRuntime().exec(OSRA.getOsraWithParamsAsArray((File)path, file), OSRA.getEnvironment(), (File)path);
                }
            } else {
                process = Runtime.getRuntime().exec(OSRA_EXECUTABLE + " " + OSRA_PARAMETERS + " " + file.getAbsolutePath());
            }
            if (process == null) {
                path = new byte[0];
                return path;
            }
            OSRA.startErrorReaderThread(process.getErrorStream());
            StringBuilder sdf = new StringBuilder();
            processOutputStreamReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            while ((line = processOutputStreamReader.readLine()) != null) {
                sdf.append(line);
                sdf.append("\n");
            }
            int retval = process.waitFor();
            if (retval == 0) {
                byte[] byArray = sdf.toString().getBytes();
                return byArray;
            }
            byte[] byArray = new byte[]{};
            return byArray;
        }
        finally {
            if (processOutputStreamReader != null) {
                processOutputStreamReader.close();
            }
        }
    }

    private static String[] getEnvironment() {
        Map<String, String> env = System.getenv();
        String[] ret = new String[env.size()];
        int i = 0;
        for (String key : env.keySet()) {
            ret[i++] = env.get(key).toString();
        }
        return ret;
    }

    private static String[] getOsraWithParamsAsArray(File path, File inputFile) {
        ArrayList<String> args = new ArrayList<String>();
        String[] retTypeHolder = new String[]{};
        args.add(path.getAbsolutePath() + FILE_SEPARATOR + OSRA_EXECUTABLE);
        for (String s : OSRA_PARAMETERS.split("\\s")) {
            args.add(s);
        }
        args.add(inputFile.getAbsolutePath());
        return args.toArray(retTypeHolder);
    }

    private static void startErrorReaderThread(final InputStream errorStream) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedReader errorStreamReader = null;
                try {
                    errorStreamReader = new BufferedReader(new InputStreamReader(errorStream));
                    String line = null;
                    while ((line = errorStreamReader.readLine()) != null) {
                        System.err.println(line);
                    }
                }
                catch (IOException e) {
                }
                finally {
                    if (errorStreamReader != null) {
                        try {
                            errorStreamReader.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }).start();
    }

    static {
        FILE_SEPARATOR = System.getProperty("file.separator");
        available = false;
        checked = false;
        String os = System.getProperty("os.name");
        OSRA_EXECUTABLE = os.startsWith("Windows") ? "osra.bat" : "osra";
    }
}

