/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.build;

import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.CleanSettings;
import chemaxon.marvin.modelling.build.BuildCommandBase;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.struc.FragmentPool;

public abstract class BuildCommand
extends BuildCommandBase {
    int mdcount = 0;
    int fallbackToOld = 200;
    int falsesBeforeMD = 10;
    int mdcountBeforeFallback = 20;
    boolean requestRebuildProxy = false;
    public boolean canFallFAST = false;
    public boolean fallFastOccured = false;
    int invokeBuildCallCounter = 0;
    int invokeBuildCallCounterMD = 0;
    BuildCommandBase.BuildEffort lastFailedEffort = null;
    FragmentPool tmpPoolForOptimization = null;

    int tryFastFallback() {
        throw new UnsupportedOperationException("FastFallBack is not supported.");
    }

    public BuildCommand(CleanSettings settings) {
        super(settings);
    }

    @Override
    protected int fetchCoordinates(int expectedConformers, boolean reportAll, boolean flushPreselect, boolean optimizeAll, debugPrintout debug, BuildCommandBase.BuildEffort effort) {
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("fetchCoordinates()", "expectedConformers=" + expectedConformers + " effor=" + effort.toString());
        }
        if (this.poolHardError == null) {
            this.poolHardError = new FragmentPool(this.getFragment());
        }
        if (this.poolSoftErrorBeforeOptimization == null) {
            this.poolSoftErrorBeforeOptimization = new FragmentPool(this.getFragment());
        }
        if (this.poolSoftErrorAfterOptimization == null) {
            this.poolSoftErrorAfterOptimization = new FragmentPool(this.getFragment());
        }
        if (this.tmpPoolForOptimization == null) {
            this.tmpPoolForOptimization = new FragmentPool(this.getFragment());
        }
        int maxLightBuildCount = 1;
        while (this.poolFilteredConformers.size() < expectedConformers) {
            int filtSizeAfter;
            int newConformers;
            int neededConformers = expectedConformers - this.poolFilteredConformers.size();
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Build loop started, needed=" + neededConformers);
            }
            if (this.verbosePrinter != null && this.verbosePrinter.isVerbosityLevelEnabled(1)) {
                this.verbosePrinter.print(1, "  " + this.poolFilteredConformers.size() + " conformers available, needed " + neededConformers + " more.");
            }
            if (this.isCancelled()) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("Cancelled");
                }
                return 3;
            }
            if (effort.isAllowOptimization() && this.poolSoftErrorBeforeOptimization.size() != 0) {
                if (debug != null) {
                    debug.println("Optimization allowed, try (pool size=" + this.poolSoftErrorBeforeOptimization.size() + ")");
                    this.poolSoftErrorBeforeOptimization.printout("Soft error before optimization pool", debug);
                }
                if (this.verbosePrinter != null && this.verbosePrinter.isVerbosityLevelEnabled(2)) {
                    this.verbosePrinter.print(2, "    Invoke optimization on soft errors");
                }
                newConformers = this.poolSoftErrorBeforeOptimization.filterOptimize(neededConformers, this.tmpPoolForOptimization, this.poolSoftErrorAfterOptimization, this.poolHardError, this.poolStereoError, this.getOptLimit(), this.cleanSettings);
                if (this.verbosePrinter != null && this.verbosePrinter.isVerbosityLevelEnabled(2)) {
                    this.verbosePrinter.print(2, "      " + newConformers + " new conformer(s) found");
                }
                if (newConformers != 0) {
                    if (debug != null) {
                        debug.println("NewConformers=" + newConformers + ", new loop");
                        this.tmpPoolForOptimization.printout("tmp pool afetr opt", debug);
                    }
                    int rc = this.tmpPoolForOptimization.removeDuplicates(this, this.poolFilteredConformers, this.getDenergyLimit(), this.getMinRMSD(), this.cleanSettings);
                    if (CleanArgs.doVerbose()) {
                        CleanArgs.verbose("Removed " + rc + " equivalents from new optimizeds");
                    }
                    if (this.verbosePrinter != null && this.verbosePrinter.isVerbosityLevelEnabled(2) && rc > 0) {
                        this.verbosePrinter.print(2, "      " + rc + " duplicate conformers ignored");
                    }
                    rc = this.tmpPoolForOptimization.moveAllTo(this.poolFilteredConformers);
                    if (!CleanArgs.doVerbose()) continue;
                    CleanArgs.verbose("Added " + rc + " new to filtered");
                    continue;
                }
            }
            if (maxLightBuildCount > 0) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("Try light build (max=" + maxLightBuildCount + ")");
                }
                --maxLightBuildCount;
                newConformers = 0;
                while (true) {
                    if (this.verbosePrinter != null && this.verbosePrinter.isVerbosityLevelEnabled(2)) {
                        this.verbosePrinter.print(2, "    Invoke light build");
                    }
                    int filtSizeBefore = this.poolFilteredConformers.size();
                    newConformers = this.callInvokeBuild(neededConformers, effort.LIGHTEST, reportAll);
                    filtSizeAfter = this.poolFilteredConformers.size();
                    if (this.verbosePrinter != null && this.verbosePrinter.isVerbosityLevelEnabled(2)) {
                        this.verbosePrinter.print(2, "      returned " + newConformers + " conformer(s) (" + (filtSizeAfter - filtSizeBefore) + " after filtering)");
                    }
                    if (CleanArgs.doVerbose()) {
                        CleanArgs.verbose("NewConformers=" + newConformers + " filtBef=" + filtSizeBefore + " filtAft=" + filtSizeAfter);
                    }
                    if (filtSizeAfter >= expectedConformers) {
                        if (!CleanArgs.doVerbose()) break;
                        CleanArgs.verbose("All conformers generated");
                        break;
                    }
                    if (filtSizeAfter <= filtSizeBefore) {
                        if (!CleanArgs.doVerbose()) break;
                        CleanArgs.verbose("No new filtered conformer generated");
                        break;
                    }
                    if (!CleanArgs.doVerbose()) continue;
                    CleanArgs.verbose("Valid, filtered conformer generated, new loop");
                }
                if (newConformers != 0) {
                    if (debug == null) continue;
                    debug.println("NewConformers=" + newConformers + ", new loop");
                    continue;
                }
                if (this.getStateLastInvokeBuild() == 1) {
                    if (!CleanArgs.doVerbose()) continue;
                    CleanArgs.verbose("Last invoke build succeed, new loop");
                    continue;
                }
            }
            if (!effort.equals(effort.LIGHTEST)) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("Try given build: " + effort.toString());
                }
                if (this.verbosePrinter != null && this.verbosePrinter.isVerbosityLevelEnabled(2)) {
                    this.verbosePrinter.print(2, "    Invoke heavier build");
                }
                int filtSizeBefore = this.poolFilteredConformers.size();
                int newConformers2 = this.callInvokeBuild(neededConformers, effort, reportAll);
                filtSizeAfter = this.poolFilteredConformers.size();
                if (this.verbosePrinter != null && this.verbosePrinter.isVerbosityLevelEnabled(2)) {
                    this.verbosePrinter.print(2, "      returned " + newConformers2 + " conformer(s) (" + (filtSizeAfter - filtSizeBefore) + " after filtering)");
                }
                if (newConformers2 != 0 || this.getStateLastInvokeBuild() == 1) {
                    if (debug == null) continue;
                    debug.println("nc=" + newConformers2 + ", s=" + this.getStateLastInvokeBuild() + ", new loop");
                    continue;
                }
            } else if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Effort==LIGHTEST, do not reinvoke build");
            }
            if (this.poolRawGeneratedConformers.size() != 0) continue;
            break;
        }
        if (this.poolFilteredConformers.size() == 0) {
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Filtered pool size is 0, report failed");
            }
            this.lastFailedEffort = effort;
            return 2;
        }
        return 1;
    }
}

