/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.build;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.CleanSettings;
import chemaxon.marvin.modelling.build.BuildCommand;
import chemaxon.marvin.modelling.build.FragmentLookup;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.struc.StereoCriteriaList;
import chemaxon.marvin.modelling.struc.Substructure3DSearch;
import chemaxon.marvin.modelling.struc.myMolecule;
import chemaxon.marvin.modelling.util.IntSet;
import chemaxon.marvin.modelling.util.U;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.BitSet;
import java.util.Vector;

public class BuildSequence {
    public Build tree;
    IntSet[] atomToSetsOnly;
    IntSet[] setsAtoms;
    IntSet[] setsAnchors;
    final IntSet[] setsNonAnchors;
    int setCount = 0;

    private void printSets(debugPrintout debug, myMolecule m, int setCount, IntSet[] setsAtoms, IntSet[] setsNonAnchors, IntSet[] setsAnchors) {
        if (debug == null) {
            return;
        }
        String[] sels = new String[3 * setCount];
        String[] descs = new String[3 * setCount];
        for (int i = 0; i < setCount; ++i) {
            sels[3 * i + 0] = U.sel(setsAtoms[i].get());
            descs[3 * i + 0] = "Set " + i + " atoms";
            sels[3 * i + 1] = U.sel(setsNonAnchors[i].get());
            descs[3 * i + 1] = "Set " + i + " non-anchors";
            sels[3 * i + 2] = U.sel(setsAnchors[i].get());
            descs[3 * i + 2] = "Set " + i + " anchors";
        }
        m.placeApplets("Identified sets", sels, descs);
    }

    private static void traverseTree(Build b, Vector[] v, boolean skipfirst, boolean doAdd, boolean doRemove, debugPrintout debug, CleanSettings settings) {
        if (b instanceof BuildFuse) {
            if (debug != null) {
                debug.println("Traverse down");
            }
            BuildFuse bf = (BuildFuse)b;
            BuildSequence.traverseTree(bf.getFrag1(), v, false, doAdd, doRemove, debug, settings);
            BuildSequence.traverseTree(bf.getFrag2(), v, false, doAdd, doRemove, debug, settings);
        }
        if (!skipfirst) {
            int siz = b.getAtomCount();
            if (siz >= b.getMol().a) {
                return;
            }
            if (v[siz] == null) {
                v[siz] = new Vector();
            }
            if (doAdd && !b.isFragmentStereoSpecified(settings)) {
                v[siz].add(b);
            }
            if (doRemove) {
                v[siz].remove(b);
            }
            if (doAdd == doRemove) {
                System.err.println("Warning! doAdd==doRemove.");
            }
        }
    }

    private static void substProxy(Build orig, Build base, Substructure3DSearch search) {
        int[] atomPerm = null;
        if (search == null) {
            if (orig != base) {
                System.err.println("Warning! orig != base");
            }
            atomPerm = U.gen(orig.getAtomCount());
        } else {
            if (orig == base) {
                System.err.println("Warning! orig == base");
            }
            atomPerm = search.getResult();
        }
        base.setSkipStereoCheck();
        ProxyBuild prox = new ProxyBuild(base, orig, atomPerm, orig.getAtoms(), orig.getAnchAtoms(), orig.getNonAnchAtoms());
        BuildSequence.verifyAutoeqTopology(orig.getFragMol(), base.getFragMol(), atomPerm);
        BuildFuse f = (BuildFuse)orig.getParent();
        base.unlinkParent();
        if (f.getFrag1().equals(orig)) {
            f.setFrag1(prox);
        } else if (f.getFrag2().equals(orig)) {
            f.setFrag2(prox);
        } else {
            System.err.println("Consistency error in proxy command substitution");
        }
    }

    public static void verifyAutoeqTopology(Molecule mi, Molecule mj, int[] perm) {
        debugPrintout debug = CleanArgs.getDebug();
        for (int i = 0; i < mi.getAtomCount(); ++i) {
            MolAtom ai = mi.getAtom(i);
            MolAtom aj = mj.getAtom(perm[i]);
            if (ai.getAtno() != aj.getAtno()) {
                System.err.println("mapped atom type mismatch");
                throw new IndexOutOfBoundsException();
            }
            if (ai.getBondCount() == aj.getBondCount()) continue;
            System.err.println("mapped atom bond count mismatch");
            throw new IndexOutOfBoundsException();
        }
    }

    public static void lookForProxy(Build root, CleanSettings settings) {
        debugPrintout debug = CleanArgs.getDebug();
        if (debug != null) {
            debug.incLevel("Fill frag vector");
        }
        myMolecule m = root.getMol();
        Vector[] fragv = new Vector[m.a];
        BuildSequence.traverseTree(root, fragv, true, true, false, debug, settings);
        if (debug != null) {
            debug.decLevel();
            debug.incLevel("Frag vector");
            for (int i = 0; i < fragv.length; ++i) {
                if (fragv[i] == null) continue;
                debug.printB("Size=" + i);
                String[] sels = new String[fragv[i].size()];
                for (int j = 0; j < sels.length; ++j) {
                    sels[j] = U.sel(((Build)fragv[i].get(j)).getAtoms());
                }
                m.placeApplets("Frags size=" + i, sels);
            }
            debug.decLevel();
            debug.printBC("Start tree matching");
        }
        for (int fragsize = fragv.length - 1; fragsize > 0; --fragsize) {
            if (fragv[fragsize] == null || fragv[fragsize].size() <= 1) continue;
            BitSet killed = new BitSet(fragv[fragsize].size());
            if (debug != null) {
                debug.printB("FragSize=" + fragsize);
            }
            for (int i = 0; i < fragv[fragsize].size() - 1; ++i) {
                if (killed.get(i)) continue;
                Vector<Build> collected = new Vector<Build>();
                Build ci = (Build)fragv[fragsize].get(i);
                Molecule mi = ci.getFragMol();
                Substructure3DSearch search = new Substructure3DSearch();
                search.setTarget(mi);
                search.setIgnoreExactMatching(false);
                myMolecule mmi = null;
                if (debug != null) {
                    mmi = new myMolecule(mi.findFrags()[0], null, settings);
                    mmi.placeApplet("Fragment mol i");
                }
                for (int j = i + 1; j < fragv[fragsize].size(); ++j) {
                    if (killed.get(j)) continue;
                    Build cj = (Build)fragv[fragsize].get(j);
                    Molecule mj = cj.getFragMol();
                    search.setQuery(mj);
                    myMolecule mmj = null;
                    if (debug != null) {
                        mmj = new myMolecule(mj.findFrags()[0], null, settings);
                        mmj.placeApplet("Fragment mol j");
                    }
                    if (!search.findFirst()) continue;
                    if (debug != null) {
                        debug.incLevel("SAME: " + i + " " + j);
                        m.placeApplets("Frag i and j", new String[]{U.sel(ci.getAtoms()), U.sel(cj.getAtoms())});
                        debug.decLevel();
                    }
                    if (collected.size() == 0) {
                        killed.set(i);
                        collected.add(ci);
                        BuildSequence.substProxy(ci, ci, null);
                    }
                    collected.add(cj);
                    killed.set(j);
                    BuildSequence.substProxy(cj, ci, search);
                }
                if (collected.size() == 0) continue;
                if (debug != null) {
                    debug.println("Equivalent group");
                }
                Object c0 = null;
                for (int j = 0; j < collected.size(); ++j) {
                    Build c = (Build)collected.get(j);
                    if (debug != null) {
                        debug.incLevel("#" + j);
                        c.printout(debug, m);
                        debug.decLevel();
                    }
                    if (j == 0) continue;
                    BuildSequence.traverseTree(c, fragv, false, false, true, null, settings);
                }
            }
        }
    }

    void removeSet(int id) {
        int lastid = this.setCount - 1;
        if (id < 0 || id > lastid) {
            return;
        }
        for (int i = 0; i < this.atomToSetsOnly.length; ++i) {
            this.atomToSetsOnly[i].clear(id);
            if (id == lastid || !this.atomToSetsOnly[i].contains(this.setCount - 1)) continue;
            this.atomToSetsOnly[i].clear(this.setCount - 1);
            this.atomToSetsOnly[i].add(id);
        }
        this.setsAtoms[id].removeAll();
        this.setsAnchors[id].removeAll();
        this.setsNonAnchors[id].removeAll();
        if (id != lastid) {
            this.setsAtoms[id].add(this.setsAtoms[lastid].get());
            this.setsAtoms[lastid].removeAll();
            this.setsAnchors[id].add(this.setsAnchors[lastid].get());
            this.setsAnchors[lastid].removeAll();
            this.setsNonAnchors[id].add(this.setsNonAnchors[lastid].get());
            this.setsNonAnchors[lastid].removeAll();
        }
        --this.setCount;
    }

    private static int[] extendWithSulfonyl(myMolecule m, int[] na) {
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Extend with sulfonyl: " + U.sel(na));
        }
        BitSet ret = null;
        for (int i = 0; i < na.length; ++i) {
            int j;
            int ai = na[i];
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Atom #" + na[i]);
            }
            if (m.anum[ai] != 16) {
                if (!CleanArgs.doVerbose()) continue;
                CleanArgs.verbose("!S");
                continue;
            }
            if (m.ctab[ai].length != 4) {
                if (!CleanArgs.doVerbose()) continue;
                CleanArgs.verbose("!4neigh.");
                continue;
            }
            int[] nfdbo = new int[2];
            int nfdboc = 0;
            int dboc = 0;
            for (j = 0; j < m.ctab[ai].length; ++j) {
                boolean nfa;
                int an = m.ctab[ai][j];
                boolean dbo = m.ctab[an].length == 1 && m.anum[an] == 8 && m.isDouble(ai, an);
                boolean bl = nfa = !U.contains(na, an);
                if (dbo) {
                    ++dboc;
                    if (!nfa || nfdboc >= 2) continue;
                    nfdbo[nfdboc++] = an;
                    continue;
                }
                if (!nfa) continue;
                dboc = 100;
            }
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("dboc=" + dboc);
            }
            if (dboc != 2) continue;
            for (j = 0; j < nfdboc; ++j) {
                if (ret == null) {
                    ret = new BitSet();
                    U.set(ret, na);
                }
                ret.set(nfdbo[j]);
            }
        }
        if (ret != null) {
            return U.collectSets(ret);
        }
        return na;
    }

    public BuildSequence(myMolecule m, StereoCriteriaList stereo, CleanSettings settings, boolean lookupFrags) {
        int j;
        int i;
        int i2;
        debugPrintout debug;
        if (CleanArgs.doVerbose()) {
            CleanArgs.verboseInc("Build sequence generation started");
        }
        if (settings.OPT_stopper_Buildsequence_construct != null) {
            settings.OPT_stopper_Buildsequence_construct.start();
        }
        if ((debug = CleanArgs.getDebug()) != null) {
            debug.printBC("Build sequence init");
        }
        Vector availables = null;
        if (lookupFrags) {
            if (debug != null) {
                debug.incLevel("Stored fragment lookup");
            }
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Fragment store lookup");
            }
            FragmentLookup fragmentLookup = new FragmentLookup(m, stereo, settings);
            availables = fragmentLookup.getAvailables();
            if (debug != null) {
                debug.println("Found " + availables.size() + " fragments");
                for (int i3 = 0; i3 < availables.size(); ++i3) {
                    debug.printB("FRAG " + i3);
                    BuildCommand f = (BuildCommand)availables.get(i3);
                    Build cmd = f.getCommand();
                    m.placeApplets("Fragment", new String[]{U.sel(cmd.getAtoms()), U.sel(cmd.getAnchAtoms()), U.sel(cmd.getNonAnchAtoms())}, new String[]{"All", "Anchor", "Non anchor"});
                }
            }
            if (debug != null) {
                debug.decLevel();
            }
        } else {
            if (debug != null) {
                debug.println("No fragment lookup.");
            }
            availables = new Vector();
        }
        int[][] ctab = m.getCtab();
        int[] ba1 = m.getBAtom1();
        int[] ba2 = m.getBAtom2();
        int atomct = ctab.length;
        this.atomToSetsOnly = new IntSet[atomct * 2];
        this.setsAtoms = new IntSet[atomct * 2];
        this.setsAnchors = new IntSet[atomct * 2];
        this.setsNonAnchors = new IntSet[atomct * 2];
        for (i2 = 0; i2 < atomct * 2; ++i2) {
            this.atomToSetsOnly[i2] = new IntSet(atomct * 2);
            this.setsAtoms[i2] = new IntSet(atomct * 2);
            this.setsAnchors[i2] = new IntSet(atomct * 2);
            this.setsNonAnchors[i2] = new IntSet(atomct * 2);
        }
        if (debug != null) {
            debug.printB("Add found fragments");
        }
        for (i2 = 0; i2 < availables.size(); ++i2) {
            BuildCommand f = (BuildCommand)availables.get(i2);
            Build cmd = f.getCommand();
            this.setsAtoms[this.setCount].add(cmd.getAtoms());
            this.setsAnchors[this.setCount].add(cmd.getAnchAtoms());
            this.setsNonAnchors[this.setCount].add(cmd.getNonAnchAtoms());
            int[] nanch = cmd.getNonAnchAtoms();
            for (int j2 = 0; j2 < nanch.length; ++j2) {
                this.atomToSetsOnly[nanch[j2]].add(this.setCount);
            }
            ++this.setCount;
        }
        if (debug != null) {
            this.printSets(debug, m, this.setCount, this.setsAtoms, this.setsNonAnchors, this.setsAnchors);
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Add rings");
        }
        int[][] SSSR2 = m.SSSR;
        if (debug != null) {
            debug.incLevel("Add uncovered rings");
        }
        for (i = 0; i < SSSR2.length; ++i) {
            int currentset;
            if (SSSR2[i].length > 10) continue;
            if (debug != null) {
                debug.println("RING " + i);
            }
            boolean found = false;
            for (int j3 = 0; j3 < this.setCount; ++j3) {
                if (!this.setsNonAnchors[j3].contains(SSSR2[i])) continue;
                found = true;
                break;
            }
            if (found) {
                if (debug == null) continue;
                debug.println("Ring found in previous sets, skipping ");
                continue;
            }
            ++this.setCount;
            int[] ering = BuildSequence.extendWithSulfonyl(m, SSSR2[i]);
            for (int j4 = 0; j4 < ering.length; ++j4) {
                int ca = ering[j4];
                this.atomToSetsOnly[ca].add(currentset);
                this.setsAtoms[currentset].add(ca);
                this.setsNonAnchors[currentset].add(ca);
            }
            boolean newloop = true;
            while (newloop) {
                int ca;
                newloop = false;
                for (j = 0; j < this.setsNonAnchors[currentset].getWeight(); ++j) {
                    ca = this.setsNonAnchors[currentset].get(j);
                    for (int k = 0; k < ctab[ca].length; ++k) {
                        int ac = ctab[ca][k];
                        if (this.setsAtoms[currentset].contains(ac)) continue;
                        this.setsAnchors[currentset].add(ac);
                        this.setsAtoms[currentset].add(ac);
                    }
                }
                for (j = 0; j < this.setsAnchors[currentset].getWeight(); ++j) {
                    ca = this.setsAnchors[currentset].get(j);
                    int count = 0;
                    for (int k = 0; k < ctab[ca].length; ++k) {
                        int ac = ctab[ca][k];
                        if (!this.setsNonAnchors[currentset].contains(ac)) continue;
                        ++count;
                    }
                    if (count == 0) {
                        System.err.println("Warning! Disconnected anchor!");
                    }
                    if (count <= true) continue;
                    this.setsAnchors[currentset].clear(ca);
                    this.setsNonAnchors[currentset].add(ca);
                    this.atomToSetsOnly[ca].add(currentset);
                    newloop = true;
                }
            }
        }
        if (debug != null) {
            this.printSets(debug, m, this.setCount, this.setsAtoms, this.setsNonAnchors, this.setsAnchors);
            debug.decLevel();
        }
        if (debug != null) {
            debug.incLevel("Identify other sets");
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Identify other fragments");
        }
        for (i = 0; i < atomct; ++i) {
            int currentset;
            if (this.atomToSetsOnly[i].getWeight() != 0 || m.anum[i] == 1 && m.ctab[i].length == 1) continue;
            if (debug != null) {
                debug.printBC("Set over atom " + i);
                m.placeApplet("Show atom " + i, "" + i);
            }
            ++this.setCount;
            int nonanchors = 1;
            this.atomToSetsOnly[i].add(currentset);
            this.setsAtoms[currentset].add(i);
            this.setsNonAnchors[currentset].add(i);
            IntSet wavefront = new IntSet(atomct);
            BitSet asAnchor = new BitSet();
            for (j = 0; j < ctab[i].length; ++j) {
                int na = ctab[i][j];
                if (m.anum[na] != 1 || m.ctab[na].length > 1) {
                    ++nonanchors;
                    wavefront.add(na);
                    continue;
                }
                wavefront.add(na);
                asAnchor.set(na);
            }
            while (wavefront.getWeight() > 0) {
                int a0;
                int j5;
                int basea = wavefront.removeLast();
                if (asAnchor.get(basea)) {
                    if (this.setsAtoms[currentset].contains(basea)) continue;
                    this.setsAtoms[currentset].add(basea);
                    this.setsAnchors[currentset].add(basea);
                    continue;
                }
                this.atomToSetsOnly[basea].add(currentset);
                this.setsAtoms[currentset].add(basea);
                this.setsNonAnchors[currentset].add(basea);
                boolean terminal = false;
                if (this.atomToSetsOnly[basea].getWeight() != 0) {
                    terminal = true;
                } else if (nonanchors >= 4) {
                    terminal = true;
                }
                if (!terminal) {
                    for (j5 = 0; j5 < ctab[basea].length; ++j5) {
                        a0 = ctab[basea][j5];
                        if (this.atomToSetsOnly[a0].contains(currentset)) continue;
                        if (m.anum[a0] != 1 || m.ctab[a0].length > 1) {
                            if (nonanchors >= 4) continue;
                            ++nonanchors;
                            wavefront.add(a0);
                            continue;
                        }
                        wavefront.add(a0);
                        asAnchor.set(a0);
                    }
                }
                if (!terminal) continue;
                for (j5 = 0; j5 < ctab[basea].length; ++j5) {
                    a0 = ctab[basea][j5];
                    if (this.setsAtoms[currentset].contains(a0)) continue;
                    this.setsAtoms[currentset].add(a0);
                    this.setsAnchors[currentset].add(a0);
                }
            }
        }
        if (debug != null) {
            this.printSets(debug, m, this.setCount, this.setsAtoms, this.setsNonAnchors, this.setsAnchors);
            debug.decLevel();
        }
        if (debug != null) {
            debug.incLevel("Add remaining single bonds");
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Add remaining single bonds");
        }
        for (i = 0; i < ba1.length; ++i) {
            int a;
            int j6;
            int currset;
            int a1 = ba1[i];
            int a2 = ba2[i];
            boolean ok = false;
            if (!ok) {
                int[] s1 = this.atomToSetsOnly[a1].get();
                for (int j7 = 0; j7 < s1.length; ++j7) {
                    if (!this.setsNonAnchors[s1[j7]].contains(a1) || !this.setsNonAnchors[s1[j7]].contains(a2)) continue;
                    ok = true;
                    break;
                }
                if (!ok && (m.anum[a1] == 1 && m.ctab[a1].length == 1 || m.anum[a2] == 1 && m.ctab[a2].length == 1)) {
                    if (m.anum[a2] == 1 && m.ctab[a2].length == 1) {
                        int tmp = a2;
                        a2 = a1;
                        a1 = tmp;
                    }
                    int[] s2 = this.atomToSetsOnly[a2].get();
                    for (int j8 = 0; j8 < s2.length; ++j8) {
                        if (!this.setsAtoms[s2[j8]].contains(a1) || !this.setsNonAnchors[s2[j8]].contains(a2)) continue;
                        ok = true;
                        break;
                    }
                }
            }
            if (ok) continue;
            ++this.setCount;
            this.atomToSetsOnly[a1].add(currset);
            this.atomToSetsOnly[a2].add(currset);
            this.setsAtoms[currset].add(a1);
            this.setsAtoms[currset].add(a2);
            this.setsNonAnchors[currset].add(a1);
            this.setsNonAnchors[currset].add(a2);
            for (j6 = 0; j6 < ctab[a1].length; ++j6) {
                a = ctab[a1][j6];
                if (a == a2) continue;
                this.setsAtoms[currset].add(a);
                this.setsAnchors[currset].add(a);
            }
            for (j6 = 0; j6 < ctab[a2].length; ++j6) {
                a = ctab[a2][j6];
                if (a == a1) continue;
                this.setsAtoms[currset].add(a);
                this.setsAnchors[currset].add(a);
            }
        }
        if (debug != null) {
            this.printSets(debug, m, this.setCount, this.setsAtoms, this.setsNonAnchors, this.setsAnchors);
            debug.decLevel();
        }
        Vector<Build> setvect = new Vector<Build>();
        BitSet setLive = new BitSet(this.setCount);
        for (int i4 = 0; i4 < this.setCount; ++i4) {
            BuildFrag b = new BuildFrag(this.setsAtoms[i4], this.setsAnchors[i4], this.setsNonAnchors[i4], m, stereo);
            if (i4 < availables.size()) {
                b.setOtherCommand((BuildCommand)availables.get(i4));
            }
            setvect.add(b);
            setLive.set(i4);
        }
        if (debug != null) {
            debug.incLevel("Start iterative fuses");
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verboseInc("Start iterative fuses");
        }
        int setvsize = setvect.size();
        while (setvsize > 1) {
            int i5;
            int i6;
            if (debug != null) {
                int i7;
                debug.printHR();
                int[] lives = U.collectSets(setLive);
                String[] sels = new String[3 * lives.length];
                String[] desc = new String[3 * lives.length];
                for (i7 = 0; i7 < lives.length; ++i7) {
                    Build b = (Build)setvect.get(lives[i7]);
                    desc[3 * i7 + 0] = lives[i7] + " set atoms";
                    desc[3 * i7 + 1] = " non anchors";
                    desc[3 * i7 + 2] = " anchors";
                    sels[3 * i7 + 0] = U.sel(b.getAtoms());
                    sels[3 * i7 + 1] = U.sel(b.getNonAnchAtoms());
                    sels[3 * i7 + 2] = U.sel(b.getAnchAtoms());
                }
                m.placeApplets("Set vector", sels, desc);
                debug.incLevel("Set vectors contents");
                for (i7 = 0; i7 < setvect.size(); ++i7) {
                    if (!setLive.get(i7)) continue;
                    debug.incLevel("Element " + i7);
                    debug.printBC("Element " + i7);
                    ((Build)setvect.get(i7)).printout(debug, m);
                    debug.decLevel();
                }
                debug.decLevel();
                debug.printB("Remove covereds");
            }
            boolean newloop = true;
            while (newloop) {
                if (debug != null) {
                    debug.println("New loop");
                }
                newloop = false;
                for (int i8 = 0; i8 < setvect.size(); ++i8) {
                    if (!setLive.get(i8)) continue;
                    Build ci = (Build)setvect.get(i8);
                    IntSet isi = new IntSet(ci.getNonAnchAtoms());
                    for (int j9 = 0; j9 < setvect.size(); ++j9) {
                        if (i8 == j9 || !setLive.get(j9)) continue;
                        Build cj = (Build)setvect.get(j9);
                        if (ci.getNonAnchAtoms().length < cj.getNonAnchAtoms().length || !isi.contains(cj.getNonAnchAtoms())) continue;
                        if (debug != null) {
                            debug.println("Set " + i8 + " holds set " + j9);
                        }
                        setLive.clear(j9);
                        for (int k = 0; k < this.atomToSetsOnly.length; ++k) {
                            this.atomToSetsOnly[k].clear(j9);
                        }
                        --setvsize;
                        newloop = true;
                    }
                }
            }
            if (setvsize == 1) break;
            if (setvsize < 1) {
                System.err.println("Error in BuildSequence; setvsize=" + setvsize);
                break;
            }
            IntSet possibleFuseAtoms = new IntSet(atomct);
            for (i6 = 0; i6 < atomct; ++i6) {
                int w = this.atomToSetsOnly[i6].getWeight();
                if (w <= 1) continue;
                possibleFuseAtoms.add(i6);
            }
            if (debug != null) {
                debug.printB("Fuse fragments");
                m.placeApplet("Possible fuse atoms", U.sel(possibleFuseAtoms.get()));
                debug.incLevel("Arom to sets only");
                debug.Tstart();
                for (i6 = 0; i6 < atomct; ++i6) {
                    debug.Trow();
                    debug.TprintBC(i6);
                    String s = "";
                    int[] sa = this.atomToSetsOnly[i6].get();
                    for (int j10 = 0; j10 < sa.length; ++j10) {
                        s = s + sa[j10] + " ";
                    }
                    debug.Tprint(s);
                }
                debug.Tstop();
                debug.decLevel();
            }
            int bf1 = -1;
            int bf2 = -1;
            int bfsize = -1;
            int bffusea = -1;
            int bfancha = -1;
            int baabcha = -1;
            boolean bOAsitu = false;
            for (int i9 = 0; i9 < possibleFuseAtoms.getWeight(); ++i9) {
                int pfa = possibleFuseAtoms.get(i9);
                for (int j11 = 0; j11 < this.atomToSetsOnly[pfa].getWeight(); ++j11) {
                    int f1 = this.atomToSetsOnly[pfa].get(j11);
                    Build b1 = (Build)setvect.get(f1);
                    int f1size = b1.getAtomCount();
                    int[] f1a = b1.getNonAnchAtoms();
                    int[] f1anch = b1.getAnchAtoms();
                    for (int k = j11 + 1; k < this.atomToSetsOnly[pfa].getWeight(); ++k) {
                        int kk;
                        int f2 = this.atomToSetsOnly[pfa].get(k);
                        Build b2 = (Build)setvect.get(f2);
                        int f2size = b2.getAtomCount();
                        int[] f2a = b2.getNonAnchAtoms();
                        int[] f2anch = b2.getAnchAtoms();
                        int[] fuseatoms = U.and(f1a, f2a);
                        int fanchors = U.and(f1anch, f2a).length + U.and(f2anch, f1a).length;
                        int aanchors = U.and(f1anch, f2anch).length;
                        int fsize = f1size + f2size - fuseatoms.length;
                        boolean update = false;
                        boolean OAsitu = false;
                        int[] commonA = U.and(f1anch, f2anch);
                        if (commonA != null) {
                            for (kk = 0; kk < commonA.length; ++kk) {
                                int comA = commonA[kk];
                                if (b1.getAnchorBase(comA) == b2.getAnchorBase(comA)) continue;
                                OAsitu = true;
                            }
                        }
                        if (bfsize == -1) {
                            update = true;
                        } else if (fuseatoms.length > bffusea) {
                            update = true;
                        } else if (fuseatoms.length == bffusea && !OAsitu && bOAsitu) {
                            update = true;
                        } else if (fuseatoms.length == bffusea && OAsitu == bOAsitu && fanchors > bfancha) {
                            update = true;
                        } else if (fuseatoms.length == bffusea && OAsitu == bOAsitu && fanchors == bfancha && aanchors > baabcha) {
                            update = true;
                        } else if (fuseatoms.length == bffusea && OAsitu == bOAsitu && fanchors == bfancha && aanchors == baabcha) {
                            if (CleanArgs.OPT_FRAGSEQUENCE == 1 && fsize < bfsize) {
                                update = true;
                            }
                            if (CleanArgs.OPT_FRAGSEQUENCE == 2 && fsize > bfsize) {
                                update = true;
                            }
                        }
                        if (update) {
                            for (kk = 0; update && kk < f1a.length; ++kk) {
                                if (U.contains(fuseatoms, f1a[kk])) continue;
                                for (int ll = 0; update && ll < m.ctab[f1a[kk]].length; ++ll) {
                                    int bac = m.ctab[f1a[kk]][ll];
                                    if (U.contains(fuseatoms, bac) || !U.contains(f2a, bac)) continue;
                                    update = false;
                                }
                            }
                        }
                        if (!update) continue;
                        bf1 = f1;
                        bf2 = f2;
                        bfsize = fsize;
                        bffusea = fuseatoms.length;
                        bfancha = fanchors;
                        baabcha = aanchors;
                        bOAsitu = OAsitu;
                    }
                }
            }
            Build frag1 = (Build)setvect.get(bf1);
            Build frag2 = (Build)setvect.get(bf2);
            if (debug != null) {
                debug.println("Best: " + bf1 + " " + bf2);
                debug.println("Best size: " + bfsize);
                debug.println("Best fuse atom count: " + bffusea);
                debug.incLevel("Constructing new fuse");
            }
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Fuse frags " + bf1 + " " + bf2);
            }
            BuildFuse newfrag = new BuildFuse(frag1, frag2);
            if (debug != null) {
                debug.decLevel();
            }
            setvect.add(newfrag);
            int[] newatoms = newfrag.getAtoms();
            int[] newnonancha = newfrag.getNonAnchAtoms();
            int nf = setvect.size() - 1;
            --setvsize;
            setLive.clear(bf1);
            setLive.clear(bf2);
            setLive.set(nf);
            for (i5 = 0; i5 < newatoms.length; ++i5) {
                this.atomToSetsOnly[newatoms[i5]].clear(bf1);
                this.atomToSetsOnly[newatoms[i5]].clear(bf2);
            }
            for (i5 = 0; i5 < newnonancha.length; ++i5) {
                this.atomToSetsOnly[newnonancha[i5]].add(nf);
            }
            if (debug == null) continue;
            debug.incLevel("New fragment");
            newfrag.printout(debug, m);
            debug.decLevel();
            debug.println("Anch: " + U.sel(newfrag.getAnchAtoms()));
        }
        if (debug != null) {
            debug.decLevel();
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verboseDec("Done");
        }
        this.tree = (Build)setvect.get(setvect.size() - 1);
        if (debug != null) {
            debug.incLevel("Final tree");
            this.tree.printout(debug, m);
            debug.decLevel();
            debug.incLevel("Look for proxy");
        }
        BuildSequence.lookForProxy(this.tree, settings);
        if (debug != null) {
            debug.decLevel();
            debug.incLevel("Final tree");
            this.tree.printout(debug, m);
            debug.decLevel();
        }
        if (debug != null) {
            // empty if block
        }
        if (settings.OPT_stopper_Buildsequence_construct != null) {
            settings.OPT_stopper_Buildsequence_construct.stop();
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verboseDec("Build sequence constructed.");
        }
    }

    public Build getTree() {
        return this.tree;
    }

    public static abstract class Build {
        boolean hasChiral = false;
        boolean hasChiralDecided = false;
        private boolean skipStereoCheck = false;
        private StereoCriteriaList stereo = null;
        private boolean stereoConstructed = false;
        private int[] fragmentGrinv = null;
        private int[][] fragmentCtab = null;
        private Molecule cxnmolecule = null;
        private Build parent = null;

        public abstract int[] getAtoms();

        public abstract int[] getAnchAtoms();

        public abstract int[] getNonAnchAtoms();

        public abstract int[] getAtomsInv();

        public abstract int getAtomCount();

        public abstract myMolecule getMol();

        public abstract StereoCriteriaList getWholeStereo();

        public abstract void printout(debugPrintout var1, myMolecule var2);

        public boolean isConsistencyOK() {
            return true;
        }

        public int[] getAtomsInv(int[] list) {
            int[] i = this.getAtomsInv();
            return U.genInverseFromLookup(i, list);
        }

        public int getAtomsInv(int a) {
            return this.getAtomsInv()[a];
        }

        public int[] getAtoms(int[] list) {
            int[] ret = new int[list.length];
            int[] a = this.getAtoms();
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = a[list[i]];
            }
            return ret;
        }

        public int getAtoms(int i) {
            return this.getAtoms()[i];
        }

        public boolean hasChiralAtom() {
            if (!this.hasChiralDecided) {
                this.hasChiralDecided = true;
                this.hasChiral = true;
            }
            return this.hasChiral;
        }

        public void setSkipStereoCheck() {
            this.skipStereoCheck = true;
        }

        public boolean isFragmentStereoSpecified(CleanSettings settings) {
            StereoCriteriaList s = this.getFragmentStereo(settings);
            return s != null && s.getSize() != 0;
        }

        public int[] getFragmentGrinv() {
            if (this.fragmentGrinv == null) {
                Molecule m = this.getFragMol();
                this.fragmentGrinv = new int[m.getAtomCount()];
                m.getGrinv(this.fragmentGrinv);
            }
            return this.fragmentGrinv;
        }

        private int[][] getFragmentCtab() {
            if (this.fragmentCtab == null) {
                Molecule m = this.getFragMol();
                this.fragmentCtab = m.getCtab();
            }
            return this.fragmentCtab;
        }

        public StereoCriteriaList getFragmentStereo(CleanSettings settings) {
            if (!this.stereoConstructed) {
                this.stereoConstructed = true;
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verboseInc("getFragmentStereo()");
                }
                if (this.skipStereoCheck) {
                    if (CleanArgs.doVerbose()) {
                        CleanArgs.verbose("Skip stereo check; construct empty list");
                    }
                    this.stereo = null;
                } else {
                    int i;
                    debugPrintout debug;
                    if (CleanArgs.doVerbose()) {
                        CleanArgs.verbose("Construct projected list");
                    }
                    if ((debug = CleanArgs.getDebug()) != null) {
                        debug.incLevel("Construct projected list");
                    }
                    StereoCriteriaList origs = this.getWholeStereo();
                    int[] perm = U.clone(this.getAtomsInv());
                    int[] anchs = this.getAnchAtoms();
                    int[][] fragctab = this.getFragmentCtab();
                    if (debug != null) {
                        debug.println("origs:");
                        origs.printout(debug, null);
                        debug.println("perm: " + U.sel(perm));
                        debug.println("anchs: " + U.sel(anchs));
                        debug.println("fragctab: " + U.toString(fragctab));
                    }
                    int[] fragStereoGrinv = new int[this.getFragmentGrinv().length];
                    for (i = 0; i < fragStereoGrinv.length; ++i) {
                        fragStereoGrinv[i] = i;
                    }
                    for (i = 0; i < anchs.length; ++i) {
                        int aif = perm[anchs[i]];
                        if (aif < 0) {
                            throw new UnsupportedOperationException();
                        }
                        if (fragctab[aif].length != 1) {
                            if (!CleanArgs.doVerbose()) continue;
                            CleanArgs.verbose("anchs[ " + i + " ]=" + anchs[i] + " aif=" + aif + " fragctab[ aif ]=" + U.sel(fragctab[aif]));
                            continue;
                        }
                        fragStereoGrinv[aif] = fragStereoGrinv[fragctab[aif][0]] + fragStereoGrinv.length + 1;
                    }
                    if (CleanArgs.doVerbose()) {
                        CleanArgs.verbose("Fragment grinv: " + U.sel(this.getFragmentGrinv()));
                        CleanArgs.verbose("FragStereoGrinv:" + U.sel(fragStereoGrinv));
                    }
                    this.stereo = origs.cloneWithProjection(perm, fragStereoGrinv, fragctab, CleanArgs.getDebug());
                    if (debug != null) {
                        debug.decLevel();
                    }
                }
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verboseDec("");
                }
            }
            return this.stereo;
        }

        public int[] getAnchorBase(int[] a) {
            int[] ret = new int[a.length];
            for (int i = 0; i < a.length; ++i) {
                ret[i] = this.getAnchorBase(a[i]);
            }
            return ret;
        }

        public int getAnchorBase(int a) {
            int[] res = null;
            BuildFuse bf = null;
            if (this instanceof BuildFuse) {
                bf = (BuildFuse)this;
                res = bf.getResolvedOA();
            }
            int[][] ctab = this.getMol().ctab;
            if (!U.contains(this.getAnchAtoms(), a)) {
                throw new IndexOutOfBoundsException("Given atom is not anchor");
            }
            int ret = -1;
            for (int i = 0; i < ctab[a].length; ++i) {
                if (!U.contains(this.getNonAnchAtoms(), ctab[a][i]) || res != null && U.contains(res, ctab[a][i]) || bf != null && bf.isGhostBond(a, ctab[a][i])) continue;
                if (ret != -1) {
                    debugPrintout debug = CleanArgs.getDebug();
                    if (debug != null) {
                        debug.printBC("ERROR: Multiple anchor bases");
                        debug.println("Anchor: " + a);
                        debug.println("Found bases: " + ret + ", " + ctab[a][i]);
                        debug.printHR();
                        debug.printHR();
                        this.printout(debug, this.getMol());
                    }
                    System.err.println("Multiple anchor bases");
                    throw new IndexOutOfBoundsException();
                }
                ret = ctab[a][i];
            }
            if (ret != -1) {
                return ret;
            }
            System.err.println("Disconnected anchor");
            throw new IndexOutOfBoundsException("Disconnected anchor");
        }

        public Molecule getFragMol() {
            if (this.cxnmolecule == null) {
                int i;
                debugPrintout debug = CleanArgs.getDebug();
                if (debug != null) {
                    debug.printBC("Constructing fragment molecule");
                }
                this.cxnmolecule = new Molecule();
                int[] selAtoms = this.getAtoms();
                myMolecule origmol = this.getMol();
                int[] atomToSel = this.getAtomsInv();
                BitSet atomIsAnchor = U.createSets(this.getAnchAtoms(), origmol.a);
                for (i = 0; i < selAtoms.length; ++i) {
                    int aid = selAtoms[i];
                    int anum = atomIsAnchor.get(aid) ? 1 : origmol.anum[aid];
                    MolAtom a = new MolAtom(anum);
                    this.cxnmolecule.add(a);
                }
                for (i = 0; i < origmol.bat[0].length; ++i) {
                    int oa1 = origmol.bat[0][i];
                    int oa2 = origmol.bat[1][i];
                    int fa1 = atomToSel[oa1];
                    int fa2 = atomToSel[oa2];
                    if (fa1 == -1 || fa2 == -1 || atomIsAnchor.get(oa1) && atomIsAnchor.get(oa2)) continue;
                    MolAtom a1 = this.cxnmolecule.getAtom(fa1);
                    MolAtom a2 = this.cxnmolecule.getAtom(fa2);
                    int f = 1;
                    switch (origmol.getBondOrder(i)) {
                        case 4: {
                            f = 2;
                            break;
                        }
                        case 6: {
                            f = 3;
                            break;
                        }
                        case 3: {
                            f = 4;
                        }
                    }
                    MolBond b = new MolBond(a1, a2, f);
                    this.cxnmolecule.add(b);
                }
            }
            return this.cxnmolecule;
        }

        public Build getParent() {
            return this.parent;
        }

        public void unlinkParent() {
            this.parent = null;
        }

        public void setParent(Build parent) {
            if (this.parent != null) {
                System.err.println("WARNING! Parent should set only once!");
                throw new UnsupportedOperationException();
            }
            this.parent = parent;
        }

        public void setParentForced(Build parent) {
            this.parent = parent;
        }
    }

    public static class SimpleBuild
    extends Build {
        private int[] atoms;
        private int[] anch;
        private int[] nanch;
        private int[] atomsInv = null;
        private int atomct;
        private myMolecule mol;
        BuildCommand otherCommand = null;
        private StereoCriteriaList wholeStereo = null;

        public BuildCommand getOtherCommand() {
            return this.otherCommand;
        }

        public void setOtherCommand(BuildCommand otherCommand) {
            this.otherCommand = otherCommand;
        }

        public SimpleBuild(int[] atoms, int[] anchors, int[] nonanchors, myMolecule m, StereoCriteriaList stereo) {
            this.atoms = atoms;
            this.anch = anchors;
            this.nanch = nonanchors;
            this.mol = m;
            this.atomct = atoms.length;
            this.wholeStereo = stereo;
        }

        @Override
        public int[] getAtoms() {
            return this.atoms;
        }

        @Override
        public int[] getAnchAtoms() {
            return this.anch;
        }

        @Override
        public int[] getNonAnchAtoms() {
            return this.nanch;
        }

        @Override
        public int[] getAtomsInv() {
            if (this.atomsInv == null) {
                this.atomsInv = U.genInverse(this.getAtoms(), this.getMol().a);
            }
            return this.atomsInv;
        }

        @Override
        public int getAtomCount() {
            return this.atomct;
        }

        @Override
        public myMolecule getMol() {
            return this.mol;
        }

        @Override
        public void printout(debugPrintout debug, myMolecule m) {
            debug.printB("Simple build");
            debug.println("getAtoms(): " + U.sel(this.getAtoms()));
            debug.println("getAnchAtoms(): " + U.sel(this.getAnchAtoms()));
            debug.println("getNonAnchAtoms(): " + U.sel(this.getNonAnchAtoms()));
            if (m != null) {
                m.placeApplets("Fragment atoms", new String[]{U.sel(this.getAtoms()), U.sel(this.getNonAnchAtoms()), U.sel(this.getAnchAtoms())}, new String[]{"Total atoms", "Non-anchors", "Anchors"});
            }
        }

        public void setEmptyStereo() {
            this.wholeStereo = new StereoCriteriaList(1);
        }

        @Override
        public StereoCriteriaList getWholeStereo() {
            return this.wholeStereo;
        }
    }

    public static class ProxyBuild
    extends Build {
        private int[] atoms;
        private int[] anch;
        private int[] nanch;
        private int[] atomsInv = null;
        private int[] atomperm = null;
        private int atomct;
        private myMolecule mol;
        private Build base = null;
        private Build orig = null;

        public Build getBase() {
            return this.base;
        }

        public int[] getAtomperm() {
            return this.atomperm;
        }

        public Build getOrig() {
            return this.orig;
        }

        public ProxyBuild(Build base, Build orig, int[] atomperm, int[] atoms, int[] anchors, int[] nonanchors) {
            this.atoms = atoms;
            this.anch = anchors;
            this.nanch = nonanchors;
            this.mol = base.getMol();
            this.atomct = atoms.length;
            this.atomperm = atomperm;
            this.base = base;
            this.setParent(base.getParent());
            this.orig = orig;
        }

        @Override
        public int[] getAtoms() {
            return this.atoms;
        }

        @Override
        public int[] getAnchAtoms() {
            return this.anch;
        }

        @Override
        public int[] getNonAnchAtoms() {
            return this.nanch;
        }

        @Override
        public int[] getAtomsInv() {
            if (this.atomsInv == null) {
                this.atomsInv = U.genInverse(this.getAtoms(), this.getMol().a);
            }
            return this.atomsInv;
        }

        @Override
        public int getAtomCount() {
            return this.atomct;
        }

        @Override
        public myMolecule getMol() {
            return this.mol;
        }

        @Override
        public void printout(debugPrintout debug, myMolecule m) {
            debug.printB("Proxy build");
            debug.println("getAtoms(): " + U.sel(this.getAtoms()));
            debug.println("getAnchAtoms(): " + U.sel(this.getAnchAtoms()));
            debug.println("getNonAnchAtoms(): " + U.sel(this.getNonAnchAtoms()));
            debug.println("atomperm: " + U.sel(this.atomperm));
            if (m != null) {
                m.placeApplets("Fragment atoms", new String[]{U.sel(this.getAtoms()), U.sel(this.getNonAnchAtoms()), U.sel(this.getAnchAtoms())}, new String[]{"Total atoms", "Non-anchors", "Anchors"});
            }
            debug.incLevel("Base build");
            this.getBase().printout(debug, m);
            debug.decLevel();
        }

        @Override
        public StereoCriteriaList getWholeStereo() {
            return this.base.getWholeStereo();
        }
    }

    public static class BuildFuse
    extends Build {
        Build frag1;
        Build frag2;
        int[] atoms = null;
        int[] anchors = null;
        int[] fuseatoms = null;
        int[] anchors1 = null;
        int[] anchors2 = null;
        int[] nonAnchors = null;
        int[] fuseInvolvedAtoms = null;
        private myMolecule wholemol = null;
        private int[] atomsInv = null;
        BuildFuse redirect = null;
        int[] resolvedOA = null;
        int[][] ghostBonds = null;
        private StereoCriteriaList emptyStereo = null;

        public int[] getFuseInvolvedAtoms() {
            if (this.fuseInvolvedAtoms == null) {
                this.fuseInvolvedAtoms = U.or(this.getAnchAtoms(), this.getFuseAtoms());
            }
            return this.fuseInvolvedAtoms;
        }

        @Override
        public myMolecule getMol() {
            return this.wholemol;
        }

        @Override
        public int[] getAtomsInv() {
            if (this.atomsInv == null) {
                this.atomsInv = U.genInverse(this.getAtoms(), this.getMol().a);
            }
            return this.atomsInv;
        }

        public void setFrag1(Build frag1) {
            this.frag1 = frag1;
        }

        public void setFrag2(Build frag2) {
            this.frag2 = frag2;
        }

        public Build getFrag1() {
            return this.frag1;
        }

        public Build getFrag2() {
            return this.frag2;
        }

        public int[] getFuseAtoms() {
            if (this.fuseatoms == null) {
                IntVector ret = new IntVector();
                int[] atoms1 = this.frag1.getNonAnchAtoms();
                int[] atoms2 = this.frag2.getNonAnchAtoms();
                for (int i = 0; i < atoms1.length; ++i) {
                    int cand = atoms1[i];
                    if (!U.contains(atoms2, cand)) continue;
                    ret.add(cand);
                }
                this.fuseatoms = ret.toArray();
            }
            return this.fuseatoms;
        }

        @Override
        public int[] getNonAnchAtoms() {
            if (this.nonAnchors == null) {
                int[] atoms1 = this.frag1.getNonAnchAtoms();
                int[] atoms2 = this.frag2.getNonAnchAtoms();
                this.nonAnchors = U.appendUnique(atoms1, atoms2);
                if (this.resolvedOA != null) {
                    this.nonAnchors = U.appendUnique(this.nonAnchors, this.resolvedOA);
                }
            }
            return this.nonAnchors;
        }

        @Override
        public int[] getAnchAtoms() {
            if (this.anchors == null) {
                int i;
                IntVector ret = new IntVector();
                int[] atoms1 = this.frag1.getNonAnchAtoms();
                int[] atoms2 = this.frag2.getNonAnchAtoms();
                int[] anc1 = this.frag1.getAnchAtoms();
                int[] anc2 = this.frag2.getAnchAtoms();
                for (i = 0; i < anc1.length; ++i) {
                    if (U.contains(atoms2, anc1[i]) || this.isAResolvedOA(anc1[i]) || ret.contains(anc1[i])) continue;
                    ret.add(anc1[i]);
                }
                for (i = 0; i < anc2.length; ++i) {
                    if (U.contains(atoms1, anc2[i]) || this.isAResolvedOA(anc2[i]) || ret.contains(anc2[i])) continue;
                    ret.add(anc2[i]);
                }
                this.anchors = ret.toArray();
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("getAnchAtoms() constructing");
                    CleanArgs.verbose("atoms1: " + U.sel(atoms1));
                    CleanArgs.verbose("atoms2: " + U.sel(atoms2));
                    CleanArgs.verbose("anc1: " + U.sel(anc1));
                    CleanArgs.verbose("anc2: " + U.sel(anc2));
                    CleanArgs.verbose("ResolvedOA: " + U.sel(this.resolvedOA));
                }
                for (i = 0; i < this.anchors.length; ++i) {
                    if (!this.isAResolvedOA(this.anchors[i])) continue;
                    System.err.println("ERROR! Inconsistency in getAnchAtoms()");
                    throw new IndexOutOfBoundsException();
                }
            }
            return this.anchors;
        }

        public int[] getAnc1() {
            if (this.anchors1 == null) {
                IntVector ret = new IntVector();
                int[] atoms2 = this.frag2.getAtoms();
                int[] anc1 = this.frag1.getAnchAtoms();
                for (int i = 0; i < anc1.length; ++i) {
                    int cand = anc1[i];
                    if (!U.contains(atoms2, cand)) continue;
                    ret.add(cand);
                }
                this.anchors1 = ret.toArray();
            }
            return this.anchors1;
        }

        public int[] getAnc2() {
            if (this.anchors2 == null) {
                IntVector ret = new IntVector();
                int[] atoms1 = this.frag1.getAtoms();
                int[] anc2 = this.frag2.getAnchAtoms();
                for (int i = 0; i < anc2.length; ++i) {
                    int cand = anc2[i];
                    if (!U.contains(atoms1, cand)) continue;
                    ret.add(cand);
                }
                this.anchors2 = ret.toArray();
            }
            return this.anchors2;
        }

        int[] getOverlappingAnchors() {
            return BuildFuse.calcOverlappingAnchors(this.getFrag1(), this.getFrag2(), this.resolvedOA);
        }

        public static int[][] calcGhsotBonds(Build frag1, Build frag2) {
            int nc;
            int j;
            int a;
            int i;
            IntSet anc1 = new IntSet(frag1.getAnchAtoms());
            IntSet anc2 = new IntSet(frag2.getAnchAtoms());
            Vector<int[]> ret = null;
            IntSet atoms1 = new IntSet(frag1.getNonAnchAtoms());
            IntSet atoms2 = new IntSet(frag2.getNonAnchAtoms());
            myMolecule m = frag1.getMol();
            for (i = 0; i < anc1.getWeight(); ++i) {
                a = anc1.get(i);
                if (anc2.contains(a) || atoms2.contains(a)) continue;
                for (j = 0; j < m.ctab[a].length; ++j) {
                    nc = m.ctab[a][j];
                    if (!atoms2.contains(nc) || atoms1.contains(nc)) continue;
                    if (ret == null) {
                        ret = new Vector<int[]>();
                    }
                    ret.add(new int[]{a, nc});
                }
            }
            block2: for (i = 0; i < anc2.getWeight(); ++i) {
                a = anc2.get(i);
                if (anc1.contains(a) || atoms1.contains(a)) continue;
                for (j = 0; j < m.ctab[a].length; ++j) {
                    nc = m.ctab[a][j];
                    if (!atoms1.contains(nc) || atoms2.contains(nc)) continue;
                    if (ret == null) {
                        ret = new Vector();
                    }
                    ret.add(new int[]{a, nc});
                    continue block2;
                }
            }
            if (ret == null) {
                return null;
            }
            int[][] ra = new int[ret.size()][];
            for (int i2 = 0; i2 < ra.length; ++i2) {
                ra[i2] = (int[])ret.get(i2);
            }
            return ra;
        }

        public static boolean isGhostBond(int a1, int a2, int[][] ghosts) {
            if (ghosts == null) {
                return false;
            }
            for (int i = 0; i < ghosts.length; ++i) {
                if (ghosts[i][0] == a1 && ghosts[i][1] == a2) {
                    return true;
                }
                if (ghosts[i][0] != a2 || ghosts[i][1] != a1) continue;
                return true;
            }
            return false;
        }

        public boolean isGhostBond(int a1, int a2) {
            return BuildFuse.isGhostBond(a1, a2, this.getGhostBonds());
        }

        public static int[] calcOverlappingAnchors(Build frag1, Build frag2, int[] resolvedOA) {
            IntSet anc1 = new IntSet(frag1.getAnchAtoms());
            IntSet anc2 = new IntSet(frag2.getAnchAtoms());
            BitSet ret = new BitSet();
            for (int i = 0; i < anc1.getWeight(); ++i) {
                int a = anc1.get(i);
                if (resolvedOA != null && U.contains(resolvedOA, a) || !anc2.contains(a) || frag1.getAnchorBase(a) == frag2.getAnchorBase(a)) continue;
                ret.set(a);
            }
            return U.collectSets(ret);
        }

        void checkOverlappingAnchors(Build frag1, Build frag2) {
            boolean newloop = true;
            while (newloop) {
                newloop = false;
                IntSet anc1 = new IntSet(frag1.getAnchAtoms());
                IntSet anc2 = new IntSet(frag2.getAnchAtoms());
                IntSet nanc1 = new IntSet(frag1.getNonAnchAtoms());
                IntSet nanc2 = new IntSet(frag2.getNonAnchAtoms());
                debugPrintout debug = CleanArgs.getDebug();
                for (int i = 0; i < anc1.getWeight() && !newloop; ++i) {
                    int a;
                    int j;
                    int a1 = anc1.get(i);
                    if (!anc2.contains(a1)) continue;
                    int b1 = -1;
                    int b2 = -1;
                    for (int j2 = 0; j2 < this.wholemol.ctab[a1].length; ++j2) {
                        if (nanc1.contains(this.wholemol.ctab[a1][j2])) {
                            b1 = this.wholemol.ctab[a1][j2];
                        }
                        if (!nanc2.contains(this.wholemol.ctab[a1][j2])) continue;
                        b2 = this.wholemol.ctab[a1][j2];
                    }
                    if (b1 == b2) continue;
                    System.err.println("Overlapping anchors!" + a1);
                    if (debug != null) {
                        debug.printBC("Overlapping anchors: " + a1);
                    }
                    BitSet bases1 = new BitSet();
                    BitSet bases2 = new BitSet();
                    bases1.set(a1);
                    bases2.set(a1);
                    IntSet fa1 = new IntSet(frag1.getNonAnchAtoms());
                    IntSet fa2 = new IntSet(frag2.getNonAnchAtoms());
                    for (int j3 = 0; j3 < this.wholemol.ctab[a1].length; ++j3) {
                        if (fa1.contains(this.wholemol.ctab[a1][j3])) {
                            bases1.set(this.wholemol.ctab[a1][j3]);
                        }
                        if (!fa2.contains(this.wholemol.ctab[a1][j3])) continue;
                        bases2.set(this.wholemol.ctab[a1][j3]);
                    }
                    if (debug != null) {
                        debug.println("Bases1: ");
                        debug.printVector(U.collectSets(bases1));
                        debug.println("Bases2: ");
                        debug.printVector(U.collectSets(bases2));
                    }
                    BuildFrag hf1 = new BuildFrag(new IntSet(this.wholemol.a, U.collectSets(bases1)), this.wholemol, this.getWholeStereo());
                    BuildFrag hf2 = new BuildFrag(new IntSet(this.wholemol.a, U.collectSets(bases2)), this.wholemol, this.getWholeStereo());
                    boolean newloop2 = true;
                    while (newloop2) {
                        newloop2 = false;
                        for (j = 0; j < anc1.getWeight(); ++j) {
                            a = anc1.get(j);
                            if (!hf1.getAnchSet().contains(a) || hf1.getAnchorBase(a) == frag1.getAnchorBase(a)) continue;
                            hf1.addAtom(anc1.get(j));
                            newloop2 = true;
                            if (debug == null) continue;
                            debug.println("Add to hf1: " + anc1.get(j));
                        }
                    }
                    newloop2 = true;
                    while (newloop2) {
                        newloop2 = false;
                        for (j = 0; j < anc2.getWeight(); ++j) {
                            a = anc2.get(j);
                            if (!hf2.getAnchSet().contains(a) || hf2.getAnchorBase(a) == frag2.getAnchorBase(a)) continue;
                            hf2.addAtom(anc2.get(j));
                            newloop2 = true;
                            if (debug == null) continue;
                            debug.println("Add to hf2: " + anc2.get(j));
                        }
                    }
                    if (debug != null) {
                        debug.incLevel("Frag1");
                        frag1.printout(debug, this.wholemol);
                        debug.decLevel();
                        debug.incLevel("HF1");
                        hf1.printout(debug, this.wholemol);
                        debug.decLevel();
                        debug.incLevel("Frag2");
                        frag2.printout(debug, this.wholemol);
                        debug.decLevel();
                        debug.incLevel("HF2");
                        hf2.printout(debug, this.wholemol);
                        debug.decLevel();
                    }
                    System.err.print("    HF1.anchors = ");
                    for (j = 0; j < hf1.getAnchAtoms().length; ++j) {
                        System.err.print(hf1.getAnchAtoms()[j] + " ");
                    }
                    System.err.println();
                    System.err.print("    HF1.nanchs   = ");
                    for (j = 0; j < hf1.getNonAnchAtoms().length; ++j) {
                        System.err.print(hf1.getNonAnchAtoms()[j] + " ");
                    }
                    System.err.println();
                    System.err.print("    frag1.anchors = ");
                    for (j = 0; j < frag1.getAnchAtoms().length; ++j) {
                        System.err.print(frag1.getAnchAtoms()[j] + " ");
                    }
                    System.err.println();
                    System.err.println("Create fuse1");
                    BuildFuse nf1 = new BuildFuse(frag1, hf1);
                    System.err.println("Returned.");
                    System.err.println("Create fuse2");
                    BuildFuse nf2 = new BuildFuse(frag2, hf2);
                    System.err.println("Returned.");
                    this.frag1 = frag1 = nf1;
                    this.frag1.setParentForced(this);
                    this.frag2 = frag2 = nf2;
                    this.frag2.setParentForced(this);
                    newloop = true;
                    this.anchors1 = null;
                    this.anchors2 = null;
                }
            }
        }

        public BuildFuse getRedirect() {
            return this.redirect;
        }

        public void setResolvedOA(int[] oa) {
            this.resolvedOA = oa;
            for (int i = 0; i < oa.length; ++i) {
                int oaib2;
                int oai = oa[i];
                int oaib1 = this.frag1.getAnchorBase(oai);
                if (oaib1 != (oaib2 = this.frag2.getAnchorBase(oai))) continue;
                System.err.println("ERROR! Inconsistency in setResolvedOA()");
                throw new IndexOutOfBoundsException();
            }
        }

        public int[] getResolvedOA() {
            return this.resolvedOA;
        }

        public boolean isAResolvedOA(int a) {
            if (this.resolvedOA == null) {
                return false;
            }
            return U.contains(this.resolvedOA, a);
        }

        public void setGhostBonds(int[][] ghostBonds) {
            this.ghostBonds = ghostBonds;
        }

        public int[][] getGhostBonds() {
            return this.ghostBonds;
        }

        public BuildFuse(Build frag1, Build frag2, int[] resolvedOA) {
            this.wholemol = frag1.getMol();
            this.resolvedOA = resolvedOA;
            debugPrintout debug = CleanArgs.getDebug();
            if (debug != null) {
                debug.printBC("FragFrag fuse init");
                this.wholemol.placeApplets("descriptors ", new String[]{U.sel(frag1.getNonAnchAtoms()), U.sel(frag1.getAnchAtoms()), U.sel(frag1.getAtoms()), U.sel(frag2.getNonAnchAtoms()), U.sel(frag2.getAnchAtoms()), U.sel(frag2.getAtoms())}, new String[]{"Frag1 non anchors", "Frag1 anchors", "Frag1 atoms", "Frag2 non anchors", "Frag2 anchors", "Frag2 atoms"});
            }
            if (frag1.getMol() != frag2.getMol()) {
                System.err.println("Inconsystency error: frag1.getMol() != frag2.getMol()");
                throw new UnsupportedOperationException();
            }
            int[] oa = null;
            if (resolvedOA == null || resolvedOA.length == 0) {
                if (debug != null) {
                    debug.println("Check overlapping anchors");
                }
                oa = BuildFuse.calcOverlappingAnchors(frag1, frag2, null);
            }
            if (oa == null || oa.length == 0) {
                if (debug != null) {
                    debug.println("No overlapping anchors or they are resolved");
                }
                this.frag1 = frag1;
                this.frag1.setParentForced(this);
                this.frag2 = frag2;
                this.frag2.setParentForced(this);
            } else {
                if (debug != null) {
                    this.wholemol.placeApplet("Overlapping anchors", U.sel(oa));
                    debug.printVector(oa);
                }
                if (debug != null) {
                    debug.incLevel("Construct OA fuse");
                }
                BuildFuse b = new BuildFuse(frag1, frag2, oa);
                if (debug != null) {
                    debug.decLevel();
                }
                if (debug != null) {
                    debug.println("Iterative add single atoms");
                }
                for (int i = 0; i < oa.length; ++i) {
                    if (debug != null) {
                        debug.incLevel("Add atom " + oa[i]);
                        debug.println("Construct atom fragment");
                    }
                    BuildFrag boa = new BuildFrag(new IntSet(new int[]{oa[i]}), this.getMol(), b.frag1.getWholeStereo());
                    if (debug != null) {
                        debug.println("Construct fuse");
                    }
                    b = new BuildFuse(b, boa);
                    if (debug == null) continue;
                    debug.decLevel();
                }
                this.frag1 = b.getFrag1();
                this.frag1.setParentForced(this);
                this.frag2 = b.getFrag2();
                this.frag2.setParentForced(this);
            }
            int[][] ghosts = BuildFuse.calcGhsotBonds(this.getFrag1(), this.getFrag2());
            if (ghosts != null && ghosts.length > 0) {
                this.setGhostBonds(ghosts);
                if (debug != null) {
                    String[] s = new String[ghosts.length];
                    for (int i = 0; i < ghosts.length; ++i) {
                        s[i] = U.sel(ghosts[i]);
                    }
                    this.wholemol.placeApplets("Ghost bonds", s);
                }
            }
            int[] anchors = this.getAnchAtoms();
            int[] nonAnchors = this.getNonAnchAtoms();
            for (int i = 0; i < anchors.length; ++i) {
                int ab = this.getAnchorBase(anchors[i]);
                if (U.contains(nonAnchors, ab)) continue;
                System.err.println("Consistency error in BuildFuse: anchor base not a member");
                throw new IndexOutOfBoundsException();
            }
            if (debug != null) {
                String[] sels = new String[]{U.sel(this.getAtoms()), U.sel(this.getAnchAtoms()), U.sel(this.getNonAnchAtoms()), U.sel(this.getFuseAtoms()), U.sel(this.getFrag1().getAtoms()), U.sel(this.getFrag2().getAtoms())};
                String[] desc = new String[]{"Atoms", "Anchors", "Non Anchors", "Fuse Atoms", "Frag1atoms", "Frag2Atoms"};
                this.getMol().placeApplets("Fuse tables", sels, desc);
            }
        }

        public BuildFuse(Build frag1, Build frag2) {
            this(frag1, frag2, null);
        }

        @Override
        public int[] getAtoms() {
            if (this.atoms == null) {
                this.atoms = this.frag1.getAtoms();
                int[] aa2 = this.frag2.getAtoms();
                this.atoms = U.appendUnique(this.atoms, aa2);
            }
            return this.atoms;
        }

        @Override
        public int getAtomCount() {
            if (this.atoms == null) {
                this.atoms = this.getAtoms();
            }
            return this.atoms.length;
        }

        @Override
        public void printout(debugPrintout debug, myMolecule m) {
            debug.printB("FUSE build");
            debug.println("getAtoms(): " + U.sel(this.getAtoms()));
            debug.println("getFuseAtoms(): " + U.sel(this.getFuseAtoms()));
            debug.println("getAnchAtoms(): " + U.sel(this.getAnchAtoms()));
            debug.println("getNonAnchAtoms(): " + U.sel(this.getNonAnchAtoms()));
            debug.println("getAnc1(): " + U.sel(this.getAnc1()));
            debug.println("getAnc2(): " + U.sel(this.getAnc2()));
            if (this.resolvedOA != null) {
                debug.println("Resolved OA: " + U.sel(this.resolvedOA));
            }
            if (this.ghostBonds != null) {
                debug.println("Ghost bonds present.");
            }
            if (m != null) {
                m.placeApplets("Atoms", new String[]{U.sel(this.getAtoms()), U.sel(this.getNonAnchAtoms()), U.sel(this.getFuseAtoms()), U.sel(this.getAnchAtoms()), U.sel(this.getAnc1()), U.sel(this.getAnc2())}, new String[]{"Total", "Non anchors", "Fuse", "Remaining anch", "Anch1", "Anch2"});
                if (this.ghostBonds != null && this.ghostBonds.length > 0) {
                    String[] s = new String[this.ghostBonds.length];
                    for (int i = 0; i < this.ghostBonds.length; ++i) {
                        s[i] = U.sel(this.ghostBonds[i]);
                    }
                    this.getMol().placeApplets("Ghost bonds", s);
                }
            }
            debug.print("<UL><LI>");
            this.frag1.printout(debug, m);
            debug.print("<LI>");
            this.frag2.printout(debug, m);
            debug.print("</UL>");
        }

        public void setEmptyStereo() {
            this.emptyStereo = new StereoCriteriaList(1);
        }

        @Override
        public StereoCriteriaList getWholeStereo() {
            if (this.emptyStereo != null) {
                return this.emptyStereo;
            }
            return this.frag1.getWholeStereo();
        }
    }

    public static class BuildFrag
    extends Build {
        IntSet atoms;
        IntSet anchors;
        IntSet nonanchors;
        BuildCommand otherCommand = null;
        private myMolecule wholemol = null;
        private int[] atomsInv = null;
        private StereoCriteriaList wholestereo = null;

        @Override
        public myMolecule getMol() {
            return this.wholemol;
        }

        @Override
        public int[] getAtomsInv() {
            if (this.atomsInv == null) {
                this.atomsInv = U.genInverse(this.getAtoms(), this.getMol().a);
            }
            return this.atomsInv;
        }

        void addAndCheckAnchors() {
            int[][] ctab = this.wholemol.ctab;
            boolean newloop = true;
            while (newloop) {
                int ca;
                int j;
                newloop = false;
                for (j = 0; j < this.nonanchors.getWeight(); ++j) {
                    ca = this.nonanchors.get(j);
                    for (int k = 0; k < ctab[ca].length; ++k) {
                        int ac = ctab[ca][k];
                        if (this.atoms.contains(ac)) continue;
                        this.anchors.add(ac);
                        this.atoms.add(ac);
                    }
                }
                for (j = 0; j < this.anchors.getWeight(); ++j) {
                    ca = this.anchors.get(j);
                    int count = 0;
                    for (int k = 0; k < ctab[ca].length; ++k) {
                        int ac = ctab[ca][k];
                        if (!this.nonanchors.contains(ac)) continue;
                        ++count;
                    }
                    if (count == 0) {
                        System.err.println("Warning! Disconnected anchor!");
                    }
                    if (count <= true) continue;
                    this.anchors.clear(ca);
                    this.nonanchors.add(ca);
                    newloop = true;
                }
            }
        }

        public BuildFrag(IntSet setsNonAnchors, myMolecule wholemol, StereoCriteriaList stereo) {
            this.atoms = new IntSet(wholemol.a, setsNonAnchors.get());
            this.anchors = new IntSet(wholemol.a);
            this.nonanchors = setsNonAnchors;
            this.wholemol = wholemol;
            this.wholestereo = stereo;
            this.addAndCheckAnchors();
        }

        public void addAtom(int a) {
            this.atoms.add(a);
            this.nonanchors.add(a);
            this.anchors.clear(a);
            this.addAndCheckAnchors();
        }

        public BuildFrag(IntSet atoms, IntSet anchors, IntSet nonanchors, myMolecule wholemol, StereoCriteriaList stereo) {
            this.atoms = atoms;
            this.anchors = anchors;
            this.nonanchors = nonanchors;
            this.wholemol = wholemol;
            this.wholestereo = stereo;
            IntSet newAnchors = new IntSet(4);
        }

        @Override
        public int[] getAtoms() {
            return this.atoms.get();
        }

        @Override
        public int[] getAnchAtoms() {
            return this.anchors.get();
        }

        public IntSet getAnchSet() {
            return this.anchors;
        }

        @Override
        public int[] getNonAnchAtoms() {
            return this.nonanchors.get();
        }

        @Override
        public int getAtomCount() {
            return this.atoms.getWeight();
        }

        @Override
        public void printout(debugPrintout debug, myMolecule m) {
            debug.printB("Fragment build");
            debug.println("getAtoms(): " + U.sel(this.getAtoms()));
            debug.println("getAnchAtoms(): " + U.sel(this.getAnchAtoms()));
            debug.println("getNonAnchAtoms(): " + U.sel(this.getNonAnchAtoms()));
            if (m != null) {
                m.placeApplets("Fragment atoms", new String[]{U.sel(this.getAtoms()), U.sel(this.getNonAnchAtoms()), U.sel(this.getAnchAtoms())}, new String[]{"Total atoms", "Non-anchors", "Anchors"});
            }
        }

        public BuildCommand getOtherCommand() {
            return this.otherCommand;
        }

        public void setOtherCommand(BuildCommand otherCommand) {
            this.otherCommand = otherCommand;
        }

        @Override
        public StereoCriteriaList getWholeStereo() {
            return this.wholestereo;
        }
    }
}

