/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.build;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.CleanSettings;
import chemaxon.marvin.modelling.build.BuildCommand;
import chemaxon.marvin.modelling.build.BuildCommandBase;
import chemaxon.marvin.modelling.build.BuildSequence;
import chemaxon.marvin.modelling.build.FragClean;
import chemaxon.marvin.modelling.build.FragFragFuser;
import chemaxon.marvin.modelling.debug.Drawer;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.geom.MultiAtomMapping;
import chemaxon.marvin.modelling.geom.MultiatomEquivalences;
import chemaxon.marvin.modelling.geom.Tetrahedron;
import chemaxon.marvin.modelling.linalg.JQuatFit;
import chemaxon.marvin.modelling.linalg.M;
import chemaxon.marvin.modelling.linalg.PrincipalAxes;
import chemaxon.marvin.modelling.linalg.V;
import chemaxon.marvin.modelling.struc.Fragment;
import chemaxon.marvin.modelling.struc.FragmentConformer;
import chemaxon.marvin.modelling.struc.Substructure3DSearch;
import chemaxon.marvin.modelling.struc.myMolecule;
import chemaxon.marvin.modelling.util.SimpleCanceller;
import chemaxon.marvin.modelling.util.U;
import java.util.BitSet;
import java.util.Vector;

class FragFragFuseBuildCommand
extends BuildCommand {
    private static final int FUSERTYPE_ODONFUSER = 1;
    private static final int FUSERTYPE_CONFUSER = 2;
    private static final int FUSERTOUSE = 2;
    myMolecule mol = null;
    int[] fragatomsInv = null;
    BuildCommand builder1 = null;
    BuildCommand builder2 = null;
    Vector allPlanar = null;
    int[] fuseInvolvedAtoms = null;
    BuildSequence.BuildFuse fcmd = null;
    MultiatomEquivalences maeq1 = null;
    MultiatomEquivalences maeq2 = null;
    MultiAtomMapping mam1 = null;
    MultiAtomMapping mam2 = null;
    boolean commandPrinted = false;
    int[] a1ad2;
    int[] a2ad1;
    int[] a1ad2in1;
    int[] a1ad2in2;
    int[] a2ad1in1;
    int[] a2ad1in2;
    int[] a1ad2ab;
    int[] a1ad2abIn1;
    int[] a1ad2abIn2;
    int[] a2ad1ab;
    int[] a2ad1abIn1;
    int[] a2ad1abIn2;
    int[] commons;
    int[] commonsIn1;
    int[] commonsIn2;
    int[] fuseAtomsInFused;
    int[] fuseAtoms;
    int[] fuseAtomsIn1;
    int[] fuseAtomsIn2;
    int[][] selpairs;
    int[] frag1inFused;
    int[] frag2inFused;
    FragFragFuser fffuser = null;
    BuildCommandBase.BuildEffort failed1effort = null;
    BuildCommandBase.BuildEffort failed2effort = null;
    int frag1procALL = 0;
    int frag2procALL = 0;
    int frag1procADDITIONAL = 0;
    int frag2procADDITIONAL = 0;
    int lastInvokedSubtree = 0;
    public static final int FUSEATOMLIST = 0;
    public static final int ANCHORLIST = 1;
    public static final int ADIRECTORLIST = 2;
    Vector permutationPairs = null;
    Vector independentPairs = null;
    Vector partialIndependentPairs = null;
    int[] hp1 = null;
    int[] hp2 = null;
    int[] hp1and2 = null;
    int[] hp1and2In1 = null;
    int[] hp1and2In2 = null;
    int[][] anchorsIn1forAG2 = null;
    int[][] adirectorsIn1forAG2 = null;
    int[][] anchorsIn2forAG1 = null;
    int[][] adirectorsIn2forAG1 = null;
    public static final int FUSESTRATEGY_ONESTEP = 1;
    public static final int FUSESTRATEGY_TWOSTEPFUSINGONLY = 2;

    @Override
    boolean hasDirectBuildChildFailed() {
        return this.builder1.hasDirectFragmentBuildChildFailed_0() || this.builder2.hasDirectFragmentBuildChildFailed_0();
    }

    @Override
    void initProgressMonitor() {
    }

    @Override
    myMolecule getOrigMol() {
        return this.mol;
    }

    @Override
    int invokeBuild(int expConfCt, BuildCommandBase.BuildEffort effort) {
        debugPrintout debug = CleanArgs.getDebug();
        if (debug != null && !this.commandPrinted) {
            debug.incLevel("Command");
            this.getCommand().printout(debug, this.getCommand().getMol());
            debug.decLevel();
            this.commandPrinted = true;
        }
        try {
            return this.invokeFuse(expConfCt, effort);
        }
        catch (Exception e) {
            System.err.println("ERROR! Exception: " + e.getMessage());
            System.err.println("This build will report FAIL, exception not thrown.");
            e.printStackTrace();
            if (debug != null) {
                debug.reportError("Exception in FragFragFuser " + e.getMessage());
                debug.println("Exception:");
                e.printStackTrace(debug.getPrintWriter());
            }
            if (effort.isAllowReThrow()) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("ReThrow exception");
                }
                throw new UnsupportedOperationException("Rethrow " + e.getMessage());
            }
            return 2;
        }
    }

    @Override
    BuildSequence.Build getCommand() {
        return this.fcmd;
    }

    public FragFragFuseBuildCommand(BuildCommand parent, CleanSettings settings, BuildSequence.BuildFuse command, myMolecule mol, debugPrintout debug) {
        super(settings);
        if (debug != null) {
            debug.println("Frag-Frag fuse command init");
            debug.incLevel("Command");
            command.printout(debug, command.getMol());
            debug.decLevel();
            debug.print("<UL>");
        }
        this.fcmd = command;
        this.mol = mol;
        BuildSequence.Build f1 = command.getFrag1();
        BuildSequence.Build f2 = command.getFrag2();
        this.setParentCommand(parent);
        if (debug != null) {
            this.getFragment().getFragMol().placeApplet("Fragment");
            debug.print("<LI>Create build command for left fragment<BR>");
        }
        this.builder1 = FragClean.createBuildCommand(this, settings, f1, mol, debug);
        this.addSubtree(this.builder1);
        if (debug != null) {
            debug.print("</LI><LI>Create build command for right fragment<BR>");
        }
        this.builder2 = FragClean.createBuildCommand(this, settings, f2, mol, debug);
        this.addSubtree(this.builder2);
        if (debug != null) {
            debug.print("</LI></UL>");
        }
    }

    boolean nextConformer(double[][][] c1, double[][][] c2, BuildCommandBase.BuildEffort effort) {
        block46: {
            debugPrintout debug = CleanArgs.getDebug();
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("nextConformer()", "Effort: " + effort);
            }
            boolean invoke1failed = false;
            boolean invoke2failed = false;
            int loopct = 0;
            do {
                int state;
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("New loop");
                }
                ++loopct;
                boolean invoke1 = false;
                boolean invoke2 = false;
                boolean invoke1or2 = false;
                if (this.builder1.getCoordinates() == null || this.builder1.getCoordinates().length == 0) {
                    invoke1 = true;
                } else if (this.builder2.getCoordinates() == null || this.builder2.getCoordinates().length == 0) {
                    invoke2 = true;
                } else {
                    if (this.builder1.getCoordinates().length > this.frag1procALL || this.builder2.getCoordinates().length > this.frag2procALL) break block46;
                    invoke1or2 = true;
                }
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("Internal status", "Invoke 1,2,1||2: " + invoke1 + "," + invoke2 + "," + invoke1or2 + "<BR>" + "builder1 conformers: " + (this.builder1.getCoordinates() == null ? "NULL" : "" + this.builder1.getCoordinates().length) + "<BR>" + "frag1proc1=" + this.frag1procALL + "<BR>" + "frag1proc2=" + this.frag1procADDITIONAL + "<BR>" + "builder2 conformers: " + (this.builder2.getCoordinates() == null ? "NULL" : "" + this.builder2.getCoordinates().length) + "<BR>" + "frag2proc1=" + this.frag2procALL + "<BR>" + "frag2proc2=" + this.frag2procADDITIONAL);
                }
                if (invoke1 || invoke1or2 && this.lastInvokedSubtree == 2) {
                    state = 0;
                    this.lastInvokedSubtree = 1;
                    if (this.failed1effort != null && !this.failed1effort.isNarrowerThan(effort)) {
                        state = 2;
                    } else {
                        if (CleanArgs.doVerbose()) {
                            CleanArgs.verbose("Invoke build #1", "confct=1 effort=" + effort);
                        }
                        state = this.builder1.build(1, effort);
                        if (CleanArgs.doVerbose()) {
                            CleanArgs.verbose("Returned: " + FragFragFuseBuildCommand.getStateString(state));
                        }
                        if (state == 3) {
                            return false;
                        }
                        if (state == 2) {
                            this.failed1effort = effort;
                        }
                        if (state == 1) {
                            this.failed1effort = null;
                        }
                    }
                    if (state != 1 && invoke1) {
                        return false;
                    }
                    if (state == 2) {
                        invoke1failed = true;
                    }
                    if (state == 1) {
                        invoke1 = false;
                        invoke1or2 = false;
                    }
                }
                if (invoke2 || invoke1or2 && this.lastInvokedSubtree == 1) {
                    state = 0;
                    this.lastInvokedSubtree = 2;
                    if (this.failed2effort != null && !this.failed2effort.isNarrowerThan(effort)) {
                        state = 2;
                    } else {
                        if (CleanArgs.doVerbose()) {
                            CleanArgs.verbose("Invoke build #2", "confct=1 effort=" + effort);
                        }
                        state = this.builder2.build(1, effort);
                        if (CleanArgs.doVerbose()) {
                            CleanArgs.verbose("Returned: " + FragFragFuseBuildCommand.getStateString(state));
                        }
                        if (state == 3) {
                            return false;
                        }
                        if (state == 2) {
                            this.failed2effort = effort;
                        }
                        if (state == 1) {
                            this.failed2effort = null;
                        }
                    }
                    if (state != 1 && invoke2) {
                        return false;
                    }
                    if (state == 2) {
                        invoke2failed = true;
                    }
                    if (state == 1) {
                        invoke2 = false;
                        invoke1or2 = false;
                    }
                }
                if (!invoke1or2 || !invoke1failed || !invoke2failed) continue;
                return false;
            } while (loopct <= 3);
            throw new UnsupportedOperationException("Invalid state in FragFragFuseBuildCommand.nextConformer()");
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Start conformer selection", "State:<BR>+builder1 conformers: " + (this.builder1.getCoordinates() == null ? "NULL" : "" + this.builder1.getCoordinates().length) + "<BR>" + "frag1procALL=" + this.frag1procALL + "<BR>" + "frag1procADDITIONAL=" + this.frag1procADDITIONAL + "<BR>" + "builder2 conformers: " + (this.builder2.getCoordinates() == null ? "NULL" : "" + this.builder2.getCoordinates().length) + "<BR>" + "frag2procALL=" + this.frag2procALL + "<BR>" + "frag2procADDITIONAL=" + this.frag2procADDITIONAL);
        }
        int ci1 = -1;
        int ci2 = -1;
        if (this.frag1procALL == 0 && this.frag2procALL == 0 && this.frag1procADDITIONAL == 0 && this.frag2procADDITIONAL == 0) {
            ci1 = 0;
            ci2 = 0;
            this.frag1procALL = 1;
            this.frag2procALL = 1;
        } else if (this.frag1procADDITIONAL == 0 && this.frag2procADDITIONAL > 0 && this.frag2procADDITIONAL < this.frag2procALL) {
            ci1 = this.frag1procALL++;
            ci2 = this.frag2procADDITIONAL++;
            if (this.frag2procADDITIONAL == this.frag2procALL) {
                this.frag1procADDITIONAL = 0;
                this.frag2procADDITIONAL = 0;
            }
        } else if (this.frag1procADDITIONAL > 0 && this.frag2procADDITIONAL == 0 && this.frag1procADDITIONAL < this.frag1procALL) {
            ci1 = this.frag1procADDITIONAL++;
            ci2 = this.frag2procALL++;
            if (this.frag1procADDITIONAL == this.frag1procALL) {
                this.frag1procADDITIONAL = 0;
                this.frag2procADDITIONAL = 0;
            }
        } else if (this.frag1procALL < this.builder1.getCoordinates().length && this.frag1procADDITIONAL == 0 && this.frag2procADDITIONAL == 0 && (this.frag2procALL >= this.builder2.getCoordinates().length || this.frag1procALL < this.frag2procALL)) {
            ci1 = this.frag1procALL++;
            ci2 = 0;
            this.frag1procADDITIONAL = 0;
            this.frag2procADDITIONAL = 1;
            if (this.frag2procADDITIONAL == this.frag2procALL) {
                this.frag1procADDITIONAL = 0;
                this.frag2procADDITIONAL = 0;
            }
        } else if (this.frag2procALL < this.builder2.getCoordinates().length && this.frag1procADDITIONAL == 0 && this.frag2procADDITIONAL == 0) {
            ci1 = 0;
            ci2 = this.frag2procALL++;
            this.frag1procADDITIONAL = 1;
            this.frag2procADDITIONAL = 0;
            if (this.frag1procADDITIONAL == this.frag1procALL) {
                this.frag1procADDITIONAL = 0;
                this.frag2procADDITIONAL = 0;
            }
        } else {
            throw new UnsupportedOperationException("Invalid state in FragFragFuseBuildCommand.nextConformer()");
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Select conformers " + ci1 + "," + ci2, "State:<BR>+builder1 conformers: " + (this.builder1.getCoordinates() == null ? "NULL" : "" + this.builder1.getCoordinates().length) + "<BR>" + "frag1proc1=" + this.frag1procALL + "<BR>" + "frag1proc2=" + this.frag1procADDITIONAL + "<BR>" + "builder2 conformers: " + (this.builder2.getCoordinates() == null ? "NULL" : "" + this.builder1.getCoordinates().length) + "<BR>" + "frag2proc1=" + this.frag2procALL + "<BR>" + "frag2proc2=" + this.frag2procADDITIONAL);
        }
        c1[0] = this.builder1.getCoordinates()[ci1];
        c2[0] = this.builder2.getCoordinates()[ci2];
        return true;
    }

    private void initMAMs() {
        int[] fuselist1 = this.builder1.getCommand().getAtomsInv(this.fcmd.getFuseAtoms());
        int[] anchlist1 = this.builder1.getCommand().getAtomsInv(this.fcmd.getAnc1());
        int[] adirlist1 = this.builder1.getCommand().getAtomsInv(this.fcmd.getAnc2());
        adirlist1 = U.remove(adirlist1, anchlist1);
        myMolecule fragmol1 = this.builder1.getFragment().getFragMol();
        this.mam1 = new MultiAtomMapping(fragmol1, fuselist1, anchlist1, adirlist1);
        int[] fuselist2 = this.builder2.getCommand().getAtomsInv(this.fcmd.getFuseAtoms());
        int[] anchlist2 = this.builder2.getCommand().getAtomsInv(this.fcmd.getAnc2());
        int[] adirlist2 = this.builder2.getCommand().getAtomsInv(this.fcmd.getAnc1());
        adirlist2 = U.remove(adirlist2, anchlist2);
        myMolecule fragmol2 = this.builder2.getFragment().getFragMol();
        this.mam2 = new MultiAtomMapping(fragmol2, fuselist2, anchlist2, adirlist2);
    }

    private void initIndependentPairs() {
        Object n;
        int i;
        debugPrintout debug = CleanArgs.getDebug();
        if (debug != null) {
            debug.incLevel("Identify independent pairs");
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Identify independent pairs");
        }
        this.independentPairs = new Vector();
        this.partialIndependentPairs = new Vector();
        BitSet alloc2 = new BitSet(this.mam2.getIndepgroupCount());
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Process indep groups in 1");
        }
        for (i = 0; i < this.mam1.getIndepgroupCount(); ++i) {
            int[] ag2;
            int[] ag1 = this.mam1.getIndepGroup(i);
            int[] ag1In2 = this.builder2.getCommand().getAtomsInv(this.builder1.getCommand().getAtoms(ag1));
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("AG1 #" + i + ": " + U.sel(ag1) + " AG1IN2: " + U.sel(ag1In2));
            }
            if ((ag2 = this.mam2.getOverlappingAnchorGroup(ag1In2)) == null || ag2.length == 0) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("Find other half");
                }
                int anchbasei = this.builder1.getCommand().getAnchorBase(this.builder1.getCommand().getAtoms(ag1[0]));
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("Anchbasei=" + anchbasei);
                }
                int bests = -1;
                int besti = -1;
                for (int j = 0; j < this.mam2.getIndepgroupCount(); ++j) {
                    int[] gjOAG;
                    int[] gj = this.mam2.getIndepGroup(j);
                    if (U.isAllSet(alloc2, gj)) continue;
                    if (U.isAnySet(alloc2, gj)) {
                        throw new UnsupportedOperationException("Partial anchor group allocated");
                    }
                    int anchbasej = this.builder2.getCommand().getAnchorBase(this.builder2.getCommand().getAtoms(gj[0]));
                    if (CleanArgs.doVerbose()) {
                        CleanArgs.verbose("G2 j=" + j + " anchbasej=" + anchbasej);
                    }
                    if (anchbasei != anchbasej) {
                        if (!CleanArgs.doVerbose()) continue;
                        CleanArgs.verbose("Anchor base mismatch");
                        continue;
                    }
                    int[] gjIn1 = this.builder1.getCommand().getAtomsInv(this.builder2.getCommand().getAtoms(gj));
                    if (CleanArgs.doVerbose()) {
                        CleanArgs.verbose("gjIn1: " + U.sel(gjIn1));
                    }
                    if ((gjOAG = this.mam1.getOverlappingAnchorGroup(gjIn1)) != null && gjOAG.length != 0) {
                        if (!CleanArgs.doVerbose()) continue;
                        CleanArgs.verbose("Has overlapping group, new loop");
                        continue;
                    }
                    if (bests >= 0 && bests >= gj.length) continue;
                    bests = gj.length;
                    besti = j;
                }
                if (bests > 0) {
                    ag2 = this.mam2.getIndepGroup(besti);
                    if (CleanArgs.doVerbose()) {
                        CleanArgs.verbose("New anchor group2: " + U.sel(ag2));
                    }
                }
            }
            int[] ag2In1 = this.builder1.getCommand().getAtomsInv(this.builder2.getCommand().getAtoms(ag2));
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("AG2: " + U.sel(ag2) + " AG2IN1: " + U.sel(ag2In1));
            }
            int[] ad2 = this.mam2.getAnchorDirectors(ag1In2);
            int[] ad1 = this.mam1.getAnchorDirectors(ag2In1);
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Group " + i, "Anchors in 1: " + U.sel(ag1) + "<BR>In 2:" + U.sel(ag1In2) + "<BR>Anchors in 2: " + U.sel(ag2) + "<BR>In 1:" + U.sel(ag2In1) + "<BR>Anchor directors in 1: " + U.sel(ad1) + "<BR>Anchor directors in 2: " + U.sel(ad2));
            }
            U.set(alloc2, ag2);
            if (new IPDimension(ag1, ag2, ad1, ad2).isPartial()) {
                n = new PartialIndependentPair(ag1, ag2, ad1, ad2);
                if (this.partialIndependentPairs == null) {
                    this.partialIndependentPairs = new Vector();
                }
                this.partialIndependentPairs.add(n);
                continue;
            }
            n = new IndependentPair(ag1, ag2, ad1, ad2);
            this.independentPairs.add(n);
            if (debug == null) continue;
            ((IndependentPair)n).printout(debug);
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Process remaining groups in 2");
        }
        for (i = 0; i < this.mam2.getIndepgroupCount(); ++i) {
            int[] ag2 = this.mam2.getIndepGroup(i);
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("G2 #" + i + ": " + U.sel(ag2));
            }
            if (U.hasCommon(alloc2, ag2)) {
                if (U.containsAllFromA(alloc2, ag2)) {
                    if (!CleanArgs.doVerbose()) continue;
                    CleanArgs.verbose("Group " + i + " processed", "Items: " + U.sel(ag2));
                    continue;
                }
                throw new UnsupportedOperationException("Independent anchor group error");
            }
            int[] ag2In1 = this.builder1.getCommand().getAtomsInv(this.builder2.getCommand().getAtoms(ag2));
            int[] ag1 = this.mam1.getOverlappingAnchorGroup(ag2In1);
            int[] ad1 = this.mam1.getAnchorDirectors(ag2In1);
            int[] ag1In2 = this.builder2.getCommand().getAtomsInv(this.builder1.getCommand().getAtoms(ag1));
            int[] ad2 = this.mam2.getAnchorDirectors(ag1In2);
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Group " + i, "Anchors in 1: " + U.sel(ag1) + "<BR>In 2:" + U.sel(ag1In2) + "<BR>Anchors in 2: " + U.sel(ag2) + "<BR>In 1:" + U.sel(ag2In1) + "<BR>Anchor directors in 1: " + U.sel(ad1) + "<BR>Anchor directors in 2: " + U.sel(ad2));
            }
            U.set(alloc2, ag2);
            if (new IPDimension(ag1, ag2, ad1, ad2).isPartial()) {
                n = new PartialIndependentPair(ag1, ag2, ad1, ad2);
                if (this.partialIndependentPairs == null) {
                    this.partialIndependentPairs = new Vector();
                }
                this.partialIndependentPairs.add(n);
                continue;
            }
            n = new IndependentPair(ag1, ag2, ad1, ad2);
            this.independentPairs.add(n);
            if (debug == null) continue;
            ((IndependentPair)n).printout(debug);
        }
        if (debug != null) {
            debug.decLevel();
        }
    }

    private void initPermutationPairs() {
        debugPrintout debug = CleanArgs.getDebug();
        if (debug != null) {
            debug.incLevel("Process permutation pairs");
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Create permutation pairs");
        }
        this.permutationPairs = new Vector();
        for (int i = 0; i < this.mam1.getHPPermCount(); ++i) {
            int[] p1 = this.mam1.getHPPerm(i);
            for (int j = 0; j < this.mam2.getHPPermCount(); ++j) {
                int[] p2 = this.mam2.getHPPerm(j);
                PermutationPair pp = new PermutationPair(p1, p2, i, j);
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("Check " + i + "-" + j, pp.toString());
                }
                if (!pp.foundSame(this.permutationPairs)) {
                    if (CleanArgs.doVerbose()) {
                        CleanArgs.verbose("New, add");
                    }
                    if (debug != null) {
                        pp.printout(debug);
                    }
                    this.permutationPairs.add(pp);
                    continue;
                }
                if (!CleanArgs.doVerbose()) continue;
                CleanArgs.verbose("Found same");
            }
        }
        if (debug != null) {
            debug.decLevel();
        }
    }

    private void initTopologicalDescriptors() {
        debugPrintout debug = CleanArgs.getDebug();
        if (debug != null) {
            debug.incLevel("Init topological descriptors");
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Anch1: " + U.sel(this.builder1.getCommand().getAnchAtoms()));
            CleanArgs.verbose("Anch2: " + U.sel(this.builder2.getCommand().getAnchAtoms()));
        }
        this.fuseAtoms = this.fcmd.getFuseAtoms();
        this.fuseAtomsIn1 = this.builder1.getCommand().getAtomsInv(this.fuseAtoms);
        this.fuseAtomsIn2 = this.builder2.getCommand().getAtomsInv(this.fuseAtoms);
        this.fuseAtomsInFused = this.fcmd.getAtomsInv(this.fuseAtoms);
        this.a1ad2 = U.and(U.remove(this.builder1.getCommand().getAnchAtoms(), this.builder2.getCommand().getAnchAtoms()), this.builder2.getCommand().getAtoms());
        this.a2ad1 = U.and(U.remove(this.builder2.getCommand().getAnchAtoms(), this.builder1.getCommand().getAnchAtoms()), this.builder1.getCommand().getAtoms());
        this.a1ad2in1 = this.builder1.getCommand().getAtomsInv(this.a1ad2);
        this.a1ad2in2 = this.builder2.getCommand().getAtomsInv(this.a1ad2);
        this.a2ad1in1 = this.builder1.getCommand().getAtomsInv(this.a2ad1);
        this.a2ad1in2 = this.builder2.getCommand().getAtomsInv(this.a2ad1);
        this.a1ad2ab = this.builder1.getCommand().getAnchorBase(this.a1ad2);
        this.a1ad2abIn1 = this.builder1.getCommand().getAtomsInv(this.a1ad2ab);
        this.a1ad2abIn2 = this.builder2.getCommand().getAtomsInv(this.a1ad2ab);
        this.a2ad1ab = this.builder2.getCommand().getAnchorBase(this.a2ad1);
        this.a2ad1abIn1 = this.builder1.getCommand().getAtomsInv(this.a2ad1ab);
        this.a2ad1abIn2 = this.builder2.getCommand().getAtomsInv(this.a2ad1ab);
        this.commons = U.and(this.builder1.getCommand().getAtoms(), this.builder2.getCommand().getAtoms());
        this.commonsIn1 = this.builder1.getCommand().getAtomsInv(this.commons);
        this.commonsIn2 = this.builder2.getCommand().getAtomsInv(this.commons);
        this.selpairs = new int[][]{this.commonsIn1, this.commonsIn2};
        this.frag1inFused = this.getCommand().getAtomsInv(this.builder1.getCommand().getAtoms());
        this.frag2inFused = this.getCommand().getAtomsInv(this.builder2.getCommand().getAtoms());
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("fuseAtoms: " + U.sel(this.fuseAtoms));
            CleanArgs.verbose("fuseAtomsIn1: " + U.sel(this.fuseAtomsIn1));
            CleanArgs.verbose("fuseAtomsIn2: " + U.sel(this.fuseAtomsIn2));
            CleanArgs.verbose("fuseAtomsInFused: " + U.sel(this.fuseAtomsInFused));
            CleanArgs.verbose("a1ad2: " + U.sel(this.a1ad2));
            CleanArgs.verbose("a1ad2in1: " + U.sel(this.a1ad2in1));
            CleanArgs.verbose("a1ad2in2: " + U.sel(this.a1ad2in2));
            CleanArgs.verbose("a2ad1: " + U.sel(this.a2ad1));
            CleanArgs.verbose("a2ad1in1: " + U.sel(this.a2ad1in1));
            CleanArgs.verbose("a2ad1in2: " + U.sel(this.a2ad1in2));
            CleanArgs.verbose("a1ad2ab: " + U.sel(this.a1ad2ab));
            CleanArgs.verbose("a1ad2abIn1: " + U.sel(this.a1ad2abIn1));
            CleanArgs.verbose("a1ad2abIn2: " + U.sel(this.a1ad2abIn2));
            CleanArgs.verbose("a2ad1ab: " + U.sel(this.a2ad1ab));
            CleanArgs.verbose("a2ad1abIn1: " + U.sel(this.a2ad1abIn1));
            CleanArgs.verbose("a2ad1abIn2: " + U.sel(this.a2ad1abIn2));
            CleanArgs.verbose("commons: " + U.sel(this.commons));
            CleanArgs.verbose("commonsIn1: " + U.sel(this.commonsIn1));
            CleanArgs.verbose("commonsIn2: " + U.sel(this.commonsIn2));
            CleanArgs.verbose("frag1inFused: " + U.sel(this.frag1inFused));
            CleanArgs.verbose("frag2inFused: " + U.sel(this.frag2inFused));
        }
        if (debug != null) {
            debug.decLevel();
        }
    }

    private void initDescriptors() {
        debugPrintout debug = CleanArgs.getDebug();
        if (debug != null) {
            debug.incLevel("Init descriptors");
        }
        this.initMAMs();
        this.initIndependentPairs();
        this.initPermutationPairs();
        this.initTopologicalDescriptors();
        if (debug != null) {
            debug.decLevel();
        }
    }

    int[] getHp1() {
        if (this.hp1 == null) {
            this.hp1 = this.mam1.getHPAtoms();
        }
        return this.hp1;
    }

    int[] getHp2() {
        if (this.hp2 == null) {
            this.hp2 = this.mam2.getHPAtoms();
        }
        return this.hp2;
    }

    int[] getHp1and2() {
        if (this.hp1and2 == null) {
            int[] hp1f = this.builder1.getCommand().getAtoms(this.getHp1());
            int[] hp2f = this.builder2.getCommand().getAtoms(this.getHp2());
            this.hp1and2 = U.and(hp1f, hp2f);
        }
        return this.hp1and2;
    }

    int[] getHp1and2In1() {
        if (this.hp1and2In1 == null) {
            this.hp1and2In1 = this.builder1.getCommand().getAtomsInv(this.hp1and2);
        }
        return this.hp1and2In1;
    }

    int[] getHp1and2In2() {
        if (this.hp1and2In2 == null) {
            this.hp1and2In2 = this.builder2.getCommand().getAtomsInv(this.hp1and2);
        }
        return this.hp1and2In2;
    }

    int[][] getIndepBestOverlaps(PermutationPair p, double[][] c1, double[][] c2) {
        debugPrintout debug = CleanArgs.getDebug();
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("<B>Check for best overlaps</B>");
        }
        double[][] permc1 = new double[c1.length][3];
        double[][] permc2 = new double[c2.length][3];
        U.copyTo(c1, permc1, p.perm1);
        U.copyTo(c2, permc2, p.perm2);
        if (debug != null) {
            this.builder1.getFragment().getFragMol().place3DApplet("Permutated c1", permc1);
            this.builder2.getFragment().getFragMol().place3DApplet("Permutated c2", permc2);
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Initial alignment");
        }
        JQuatFit jq1 = new JQuatFit(permc1);
        double d = jq1.quatfit(permc2, new int[][]{this.hp1and2In1, this.hp1and2In2});
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("HP alignment d: " + d);
        }
        if (debug != null) {
            this.builder1.getFragment().getFragMol().place3DApplets("Initial aligns", permc1, null, this.builder2.getFragment().getFragMol(), permc2);
        }
        int[][] ret = new int[this.independentPairs.size()][];
        for (int j = 0; j < ret.length; ++j) {
            IndependentPair ip = (IndependentPair)this.independentPairs.get(j);
            ret[j] = ip.findBestOverlaps(permc1, permc2);
        }
        return ret;
    }

    void stretchAnchors(double[][] permc1, double[][] permc2, int[] permv1, int[] permv2) {
        double[] av;
        double bl;
        double[] abase2;
        double[] anch2;
        double[] abase;
        double[] anch;
        int j;
        if (permv1 == null && permv2 != null || permv1 != null && permv2 == null) {
            throw new UnsupportedOperationException("permutation vector mismatch");
        }
        debugPrintout debug = CleanArgs.getDebug();
        for (j = 0; j < this.a1ad2in1.length; ++j) {
            if (permv1 != null && permv1[this.a1ad2in1[j]] < 0 && permv2[this.a1ad2in2[j]] < 0) continue;
            anch = permc1[permv1 == null ? this.a1ad2in1[j] : permv1[this.a1ad2in1[j]]];
            abase = permc1[permv1 == null ? this.a1ad2abIn1[j] : permv1[this.a1ad2abIn1[j]]];
            anch2 = permc2[permv2 == null ? this.a1ad2in2[j] : permv2[this.a1ad2in2[j]]];
            abase2 = permc2[permv2 == null ? this.a1ad2abIn2[j] : permv2[this.a1ad2abIn2[j]]];
            bl = Math.sqrt(V.vectLenSquare(anch2, abase2));
            av = V.minus(anch, abase);
            V.normalize(av);
            av = V.dot(bl, av);
            av = V.plus(abase, av);
            U.copyTo(anch, av);
        }
        for (j = 0; j < this.a2ad1in2.length; ++j) {
            if (permv1 != null && permv1[this.a2ad1in1[j]] < 0 && permv2[this.a2ad1in2[j]] < 0) continue;
            anch = permc2[permv2 == null ? this.a2ad1in2[j] : permv2[this.a2ad1in2[j]]];
            abase = permc2[permv2 == null ? this.a2ad1abIn2[j] : permv2[this.a2ad1abIn2[j]]];
            anch2 = permc1[permv1 == null ? this.a2ad1in1[j] : permv1[this.a2ad1in1[j]]];
            abase2 = permc1[permv1 == null ? this.a2ad1abIn1[j] : permv1[this.a2ad1abIn1[j]]];
            bl = Math.sqrt(V.vectLenSquare(anch2, abase2));
            av = V.minus(anch, abase);
            V.normalize(av);
            av = V.dot(bl, av);
            av = V.plus(abase, av);
            U.copyTo(anch, av);
        }
        if (debug != null) {
            this.builder1.getFragment().getFragMol().place3DApplet("Pc1-SA", permc1);
            this.builder2.getFragment().getFragMol().place3DApplet("Pc2-SA", permc2);
        }
    }

    double[][] mergeAligneds(double[][] c1, double[][] c2, double anchorWeight) {
        int j;
        double[][] c = new double[this.getCommand().getAtomCount()][3];
        for (j = 0; j < this.frag1inFused.length; ++j) {
            U.copyTo(c[this.frag1inFused[j]], c1[j]);
        }
        for (j = 0; j < this.frag2inFused.length; ++j) {
            U.copyTo(c[this.frag2inFused[j]], c2[j]);
        }
        for (j = 0; j < this.commons.length; ++j) {
            V.avgWriteBackToA(c[this.frag2inFused[this.commonsIn2[j]]], c1[this.commonsIn1[j]]);
        }
        if (anchorWeight != 0.5) {
            double[] res;
            for (j = 0; j < this.a1ad2.length; ++j) {
                double[] a1 = c1[this.a1ad2in1[j]];
                double[] ad2 = c2[this.a1ad2in2[j]];
                res = c[this.frag1inFused[this.a1ad2in1[j]]];
                V.linComb(res, a1, ad2, anchorWeight);
            }
            for (j = 0; j < this.a2ad1.length; ++j) {
                double[] ad1 = c1[this.a2ad1in1[j]];
                double[] a2 = c2[this.a2ad1in2[j]];
                res = c[this.frag2inFused[this.a2ad1in2[j]]];
                V.linComb(res, a2, ad1, anchorWeight);
            }
        }
        return c;
    }

    int fuseConformers(double[][] c1, double[][] c2, Vector finalc, BitSet redP1, BitSet redP2, int fusestrategy, boolean flipfr, double faweight, BuildCommandBase.BuildEffort effort) {
        debugPrintout debug = CleanArgs.getDebug();
        double[] selw = new double[this.selpairs[0].length];
        int[] faIn1 = this.builder1.getCommand().getAtomsInv(this.fcmd.getFuseAtoms());
        int[] faIn2 = this.builder2.getCommand().getAtomsInv(this.fcmd.getFuseAtoms());
        for (int i = 0; i < selw.length; ++i) {
            selw[i] = 1.0;
            if (!U.contains(faIn1, this.selpairs[0][i]) || !U.contains(faIn2, this.selpairs[1][i])) continue;
            selw[i] = faweight;
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("selw: " + U.sel(selw));
        }
        int[] permv1 = new int[this.builder1.getCommand().getAtomCount()];
        int[] permv2 = new int[this.builder2.getCommand().getAtomCount()];
        double[][] permc1 = new double[this.builder1.getCommand().getAtomCount()][3];
        double[][] permc2 = new double[this.builder2.getCommand().getAtomCount()][3];
        double[][] c1orig = c1;
        double[][] c2orig = c2;
        for (int i = 0; i < this.permutationPairs.size(); ++i) {
            for (int flipct = 0; flipct < (flipfr ? 4 : 1); ++flipct) {
                if (effort.isCancelled()) {
                    if (CleanArgs.doVerbose()) {
                        CleanArgs.verbose("CANCELLED");
                    }
                    return 3;
                }
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("Fusing ppair#" + i + " flipct=" + flipct);
                }
                PermutationPair p = (PermutationPair)this.permutationPairs.get(i);
                if (redP1.get(p.perm1index) || redP2.get(p.perm2index)) {
                    if (!CleanArgs.doVerbose()) continue;
                    CleanArgs.verbose("REDUNDANT");
                    continue;
                }
                if (flipfr) {
                    if (CleanArgs.doVerbose()) {
                        CleanArgs.verbose("Flip fuse region");
                    }
                    double f1f = (double)(30 * ((flipct & 2) == 0 ? 1 : -1)) * Math.PI / 180.0;
                    double f2f = (double)(30 * ((flipct & 1) == 0 ? 1 : -1)) * Math.PI / 180.0;
                    if (CleanArgs.doVerbose()) {
                        CleanArgs.verbose("Flip F1", "fuseAtomsIn1: " + U.sel(this.fuseAtomsIn1) + "<BR>" + "p.perm1: " + U.sel(p.perm1) + "<BR>" + "permutated: " + U.sel(U.permutate(this.fuseAtomsIn1, p.perm1)));
                    }
                    c1 = U.clone(c1orig);
                    PrincipalAxes pa1 = new PrincipalAxes(c1, U.permutate(this.fuseAtomsIn1, p.perm1));
                    if (debug != null) {
                        pa1.printout(debug, "pa1");
                    }
                    BitSet sel1 = new BitSet();
                    U.set(sel1, this.fuseAtomsIn1);
                    int[][] ctab1 = this.builder1.getFragment().getFragMol().ctab;
                    for (int j = 0; j < this.fuseAtomsIn1.length; ++j) {
                        int aj = this.fuseAtomsIn1[j];
                        for (int k = 0; k < ctab1[aj].length; ++k) {
                            int ak = ctab1[aj][k];
                            if (ctab1[ak].length != 1) continue;
                            sel1.set(ak);
                        }
                    }
                    pa1.bend(c1, U.collectSets(sel1), f1f, null);
                    if (debug != null) {
                        this.builder1.getFragment().getFragMol().place3DApplet("#1 bent", c1);
                    }
                    if (CleanArgs.doVerbose()) {
                        CleanArgs.verbose("Flip F2", "fuseAtomsIn2: " + U.sel(this.fuseAtomsIn2) + "<BR>" + "p.perm2: " + U.sel(p.perm2) + "<BR>" + "permutated: " + U.sel(U.permutate(this.fuseAtomsIn2, p.perm2)));
                    }
                    c2 = U.clone(c2orig);
                    PrincipalAxes pa2 = new PrincipalAxes(c2, U.permutate(this.fuseAtomsIn2, p.perm2));
                    if (debug != null) {
                        pa1.printout(debug, "pa1");
                    }
                    BitSet sel2 = new BitSet();
                    U.set(sel2, this.fuseAtomsIn2);
                    int[][] ctab2 = this.builder2.getFragment().getFragMol().ctab;
                    for (int j = 0; j < this.fuseAtomsIn2.length; ++j) {
                        int aj = this.fuseAtomsIn2[j];
                        for (int k = 0; k < ctab2[aj].length; ++k) {
                            int ak = ctab2[aj][k];
                            if (ctab2[ak].length != 1) continue;
                            sel2.set(ak);
                        }
                    }
                    pa2.bend(c2, U.collectSets(sel2), f2f, null);
                    if (debug != null) {
                        this.builder2.getFragment().getFragMol().place3DApplet("#2 bent", c2);
                    }
                }
                int[] pipc = new int[this.partialIndependentPairs.size()];
                int[] ipc = new int[this.independentPairs.size()];
                Object nripcGeom = null;
                Object nrpipcGeom = null;
                Object nripcChir4 = null;
                int[][] nripcBestOL = null;
                int[][] nrpipcBestOL = null;
                int[][] nripc = null;
                int[][] nrpipc = null;
                if (fusestrategy == 1) {
                    if (nripcGeom == null) {
                        if (CleanArgs.doVerbose()) {
                            CleanArgs.verbose("Identify geometric IPC redundancy");
                        }
                        nripcGeom = new int[this.independentPairs.size()][];
                        for (int j = 0; j < ipc.length; ++j) {
                            IndependentPair ip = (IndependentPair)this.independentPairs.get(j);
                            nripcGeom[j] = ip.findNonRedundants(c1, c2, p.perm1, p.perm2, effort);
                        }
                        if (CleanArgs.doVerbose()) {
                            CleanArgs.verbose("nripcGeom: " + U.toString(nripcGeom));
                        }
                    }
                    if (nripcChir4 == null) {
                        if (CleanArgs.doVerbose()) {
                            CleanArgs.verbose("Identify chirality4 based IPC redundancy");
                        }
                        nripcChir4 = new int[this.independentPairs.size()][];
                        for (int j = 0; j < ipc.length; ++j) {
                            IndependentPair ip = (IndependentPair)this.independentPairs.get(j);
                            BitSet chr = ip.checkChirality4(c1, c2, p.perm1, p.perm2, nripcGeom[j]);
                            if (chr == null) {
                                nripcChir4[j] = nripcGeom[j];
                                if (!CleanArgs.doVerbose()) continue;
                                CleanArgs.verbose("chr[" + j + "]: null");
                                continue;
                            }
                            nripcChir4[j] = U.and(nripcGeom[j], U.collectSets(chr));
                            if (!CleanArgs.doVerbose()) continue;
                            CleanArgs.verbose("chr[ " + j + " ]: " + U.sel(U.collectSets(chr)));
                        }
                        if (CleanArgs.doVerbose()) {
                            CleanArgs.verbose("nripcChir4: " + U.toString(nripcChir4));
                        }
                    }
                    nripc = nripcChir4;
                    if (nrpipcGeom == null) {
                        nrpipcGeom = new int[this.partialIndependentPairs.size()][];
                        for (int j = 0; j < ((int[][])nrpipcGeom).length; ++j) {
                            nrpipcGeom[j] = ((PartialIndependentPair)this.partialIndependentPairs.get(j)).getNonRedundantChoices(this.builder1.getFragment(), this.builder2.getFragment(), c1, c2, p.perm1, p.perm2);
                            if (!CleanArgs.doVerbose()) continue;
                            CleanArgs.verbose("nrpipcGeom[ " + j + " ]=" + U.sel(nrpipcGeom[j]));
                        }
                    }
                    nrpipc = nrpipcGeom;
                } else {
                    if (nripcBestOL == null) {
                        nripcBestOL = this.getIndepBestOverlaps(p, c1, c2);
                    }
                    nripc = nripcBestOL;
                    nrpipc = null;
                }
                boolean hasmoreipc = true;
                block10: while (hasmoreipc) {
                    int j;
                    if (CleanArgs.doVerbose()) {
                        CleanArgs.verbose("IPC: " + U.sel(ipc), "nripc: " + U.toString(nripc));
                        CleanArgs.verbose("PIPC: " + U.sel(pipc), "nrpipc: " + U.toString(nrpipc));
                    }
                    U.fill(permv1, -1);
                    U.fill(permv2, -1);
                    for (j = 0; j < this.hp1and2.length; ++j) {
                        permv1[this.hp1and2In1[j]] = p.perm1[this.hp1and2In1[j]];
                        permv2[this.hp1and2In2[j]] = p.perm2[this.hp1and2In2[j]];
                    }
                    if (CleanArgs.doVerbose()) {
                        CleanArgs.verbose("Filled HPHP map perm: " + U.sel(permv1) + "/" + U.sel(permv2), "hp1and2: " + U.sel(this.hp1and2) + "<BR>" + "hp1and2in1: " + U.sel(this.hp1and2In1) + "<BR>" + "hp1and2in2: " + U.sel(this.hp1and2In2));
                    }
                    for (j = 0; j < ipc.length; ++j) {
                        if (CleanArgs.doVerbose()) {
                            CleanArgs.verbose("Permutate ip#" + j, "nripc: " + U.toString(nripc) + "<BR>" + "ipc:   " + U.sel(ipc));
                        }
                        IndependentPair ip = (IndependentPair)this.independentPairs.get(j);
                        ip.permutate(nripc[j][ipc[j]], p.perm1, p.perm2, permv1, permv2);
                    }
                    if (CleanArgs.doVerbose()) {
                        CleanArgs.verbose("Permutate indeps: " + U.sel(permv1) + "/" + U.sel(permv2));
                    }
                    if (nrpipc != null) {
                        for (j = 0; j < pipc.length; ++j) {
                            PartialIndependentPair pip = (PartialIndependentPair)this.partialIndependentPairs.get(j);
                            pip.permutate(nrpipc[j][pipc[j]], p.perm1, p.perm2, permv1, permv2);
                        }
                        if (CleanArgs.doVerbose()) {
                            CleanArgs.verbose("Permutated partials: " + U.sel(permv1) + "/" + U.sel(permv2));
                        }
                    }
                    if (pipc.length > 0) {
                        int ct2;
                        int ct1;
                        if (CleanArgs.doVerbose()) {
                            CleanArgs.verbose("Identify remaining undetermined permutations");
                        }
                        if ((ct1 = U.countDifferent(permv1, -1)) != (ct2 = U.countDifferent(permv2, -1))) {
                            throw new UnsupportedOperationException("Atom map count mismatch");
                        }
                        int[][] pipmap = new int[2][ct1];
                        int j2 = 0;
                        for (int k = 0; k < this.commons.length; ++k) {
                            boolean d2;
                            boolean d1 = permv1[this.commonsIn1[k]] >= 0;
                            boolean bl = d2 = permv2[this.commonsIn2[k]] >= 0;
                            if (d1 != d2) {
                                throw new UnsupportedOperationException("Mapped atom mismatvh");
                            }
                            if (!d1) continue;
                            pipmap[0][j2] = permv1[this.commonsIn1[k]];
                            pipmap[1][j2] = permv2[this.commonsIn2[k]];
                            ++j2;
                        }
                        if (CleanArgs.doVerbose()) {
                            CleanArgs.verbose("pipmap: " + U.toString(pipmap));
                        }
                        double[][] c1clone = U.clone(c1);
                        double[][] c2clone = U.clone(c2);
                        this.stretchAnchors(c1clone, c2clone, permv1, permv2);
                        JQuatFit jq = new JQuatFit(c1clone);
                        double d = jq.quatfit(c2clone, pipmap);
                        if (CleanArgs.doVerbose()) {
                            CleanArgs.verbose("Fit d=" + d);
                        }
                        if (debug != null) {
                            this.builder1.getFragment().getFragMol().place3DApplets("PreAligns", c1clone, null, this.builder2.getFragment().getFragMol(), c2clone);
                        }
                        for (int k = 0; k < this.partialIndependentPairs.size(); ++k) {
                            if (CleanArgs.doVerbose()) {
                                CleanArgs.verbose("Permutate final #" + k);
                            }
                            PartialIndependentPair pip = (PartialIndependentPair)this.partialIndependentPairs.get(k);
                            pip.permutateFinal(c1clone, c2clone, p.perm1, p.perm2, permv1, permv2);
                        }
                    }
                    for (j = 0; j < permv1.length; ++j) {
                        if (permv1[j] >= 0) continue;
                        permv1[j] = p.perm1[j];
                    }
                    for (j = 0; j < permv2.length; ++j) {
                        if (permv2[j] >= 0) continue;
                        permv2[j] = p.perm2[j];
                    }
                    if (CleanArgs.doVerbose()) {
                        CleanArgs.verbose("Permutation: " + U.sel(permv1) + "/" + U.sel(permv2));
                    }
                    U.copyTo(c1, permc1, permv1);
                    U.copyTo(c2, permc2, permv2);
                    if (debug != null) {
                        this.builder1.getFragment().getFragMol().place3DApplet("Pc1", permc1);
                        this.builder2.getFragment().getFragMol().place3DApplet("Pc2", permc2);
                    }
                    if (CleanArgs.doVerbose()) {
                        CleanArgs.verbose("Stretch anchors");
                    }
                    this.stretchAnchors(permc1, permc2, null, null);
                    if (CleanArgs.doVerbose()) {
                        CleanArgs.verbose("SelPairs: " + U.toString(this.selpairs));
                    }
                    JQuatFit jq = new JQuatFit(permc1);
                    double d = jq.quatfit(permc2, selw, this.selpairs);
                    if (CleanArgs.doVerbose()) {
                        CleanArgs.verbose("d=" + d);
                    }
                    if (debug != null) {
                        this.builder1.getFragment().getFragMol().place3DApplet("Pc1-SAF", permc1);
                        this.builder2.getFragment().getFragMol().place3DApplet("Pc2-SAF", permc2);
                        this.builder1.getFragment().getFragMol().place3DApplets("Aligns", permc1, null, this.builder2.getFragment().getFragMol(), permc2);
                    }
                    double[][] c = this.mergeAligneds(permc1, permc2, 0.1);
                    if (debug != null) {
                        this.getFragment().getFragMol().place3DApplet("fused", c);
                    }
                    finalc.add(c);
                    if (effort.isCancelled()) {
                        return 3;
                    }
                    if (CleanArgs.doVerbose()) {
                        CleanArgs.verbose("Add +1 to PIPC");
                    }
                    if (nrpipc != null) {
                        boolean hasmorepipc = true;
                        if (pipc.length > 0) {
                            int pos;
                            int n = pos = pipc.length - 1;
                            pipc[n] = pipc[n] + 1;
                            while (pipc[pos] >= nrpipc[pos].length) {
                                pipc[pos] = 0;
                                if (--pos < 0) {
                                    hasmorepipc = false;
                                    break;
                                }
                                int n2 = pos;
                                pipc[n2] = pipc[n2] + 1;
                            }
                        } else {
                            hasmorepipc = false;
                        }
                        if (hasmorepipc) {
                            if (!CleanArgs.doVerbose()) continue;
                            CleanArgs.verbose("PIPC incremented, skip IPC increment");
                            continue;
                        }
                    }
                    if (CleanArgs.doVerbose()) {
                        CleanArgs.verbose("Add +1 to IPC");
                    }
                    if (ipc.length > 0) {
                        int pos;
                        int n = pos = ipc.length - 1;
                        ipc[n] = ipc[n] + 1;
                        while (ipc[pos] >= nripc[pos].length) {
                            ipc[pos] = 0;
                            if (--pos < 0) {
                                hasmoreipc = false;
                                continue block10;
                            }
                            int n3 = pos;
                            ipc[n3] = ipc[n3] + 1;
                        }
                        continue;
                    }
                    hasmoreipc = false;
                }
            }
        }
        return 1;
    }

    int invokeFuse(int confCt, BuildCommandBase.BuildEffort effort) {
        double[][] c;
        BuildSequence.BuildFuse cmd;
        boolean ret;
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("invokeFuse()");
        }
        if (this.allPlanar != null && this.allPlanar.size() > 0) {
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Report allplanars");
            }
            this.reportAllPlanars();
            return 1;
        }
        debugPrintout debug = CleanArgs.getDebug();
        if (debug != null) {
            debug.incLevel("invokeFuse()");
        }
        double[][][] c1 = new double[1][][];
        double[][][] c2 = new double[1][][];
        if (debug != null) {
            debug.println("Invoke nextConformer()");
        }
        if (!(ret = this.nextConformer(c1, c2, effort))) {
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("nextConformer() failed", "return from invokeFuse() with FAIL state");
            }
            if (debug != null) {
                debug.decLevel();
            }
            return 2;
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("nextConformer() returned");
        }
        if (debug != null) {
            this.builder1.getFragment().getFragMol().place3DApplet("c1", c1[0]);
            this.builder2.getFragment().getFragMol().place3DApplet("c2", c2[0]);
        }
        if (this.fuseInvolvedAtoms == null || this.fcmd == null) {
            this.fcmd = (BuildSequence.BuildFuse)this.getCommand();
            this.fuseInvolvedAtoms = this.fcmd.getFuseInvolvedAtoms();
        }
        if (this.mam1 == null) {
            this.initDescriptors();
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Look fo HP autoisomorphs");
        }
        BitSet redP1 = this.mam1.findAutoisomorphs(this.builder1.getFragment().getFragMol(), c1[0]);
        BitSet redP2 = this.mam2.findAutoisomorphs(this.builder2.getFragment().getFragMol(), c2[0]);
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Autoisomorphs in 1: " + U.sel(U.collectSets(redP1)));
            CleanArgs.verbose("Autoisomorphs in 2: " + U.sel(U.collectSets(redP2)));
        }
        int fusestrategy = 1;
        this.getHp1and2();
        this.getHp1and2In1();
        this.getHp1and2In2();
        if (this.hp1and2.length > 2) {
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Use two step fuse strategy");
            }
            fusestrategy = 2;
        }
        double faw = 1.0;
        if (this.fcmd.getFuseAtoms().length == 1) {
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("1 fuse atom");
            }
            faw = 100.0;
        }
        Vector finalc = new Vector();
        Vector finalcOptReq = null;
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Invoke fuseConformers, strat=" + fusestrategy);
        }
        this.fuseConformers(c1[0], c2[0], finalc, redP1, redP2, fusestrategy, false, faw, effort);
        boolean hasok = V.hasMinSep(finalc, 0.2);
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Returned. HasMinSep: " + hasok);
        }
        if (fusestrategy != 1 && !hasok) {
            fusestrategy = 1;
            finalc.removeAllElements();
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("New invoke using ONESTEP");
            }
            this.fuseConformers(c1[0], c2[0], finalc, redP1, redP2, fusestrategy, false, faw, effort);
            hasok = V.hasMinSep(finalc, 0.2);
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Returned. HasMinSep: " + hasok);
            }
        }
        if (!hasok) {
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Invoke onestep with fr bending");
            }
            if (finalcOptReq == null) {
                finalcOptReq = new Vector();
            }
            this.fuseConformers(c1[0], c2[0], finalcOptReq, redP1, redP2, fusestrategy, true, faw, effort);
            hasok = V.hasMinSep(finalc, 0.2);
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Returned. HasMinSep: " + hasok);
            }
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Check for planar fuse regions");
        }
        if ((cmd = (BuildSequence.BuildFuse)this.getCommand()).getFuseAtoms().length < 2) {
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("<2 fuse atoms, no planar hack");
            }
        } else {
            int i;
            Vector<PrincipalAxes> pv = null;
            int[] commonsInFused = this.getCommand().getAtomsInv(this.commons);
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("CommonsInFused: " + U.sel(commonsInFused));
            }
            for (i = 0; i < finalc.size(); ++i) {
                PrincipalAxes pa;
                StringBuffer vb = CleanArgs.doVerbose() ? new StringBuffer() : null;
                Drawer d = debug == null ? null : new Drawer();
                boolean planar = V.isPlanar(0.3, (double[][])finalc.get(i), commonsInFused, vb, d);
                if (vb != null) {
                    CleanArgs.verbose("planar: " + planar, vb.toString());
                }
                if (d != null) {
                    d.placeApplet(debug, "Planar check");
                }
                if (planar) {
                    pa = new PrincipalAxes((double[][])finalc.get(i), this.fuseAtomsInFused);
                    if (debug != null) {
                        pa.printout(debug, "PA for planar hack ");
                    }
                    if (pv == null) {
                        pv = new Vector<PrincipalAxes>();
                    }
                } else {
                    if (CleanArgs.doVerbose()) {
                        CleanArgs.verbose("Not all planar");
                    }
                    pv = null;
                    break;
                }
                pv.add(pa);
            }
            if (pv != null) {
                if (this.allPlanar == null) {
                    this.allPlanar = new Vector();
                }
                for (i = 0; i < pv.size(); ++i) {
                    this.allPlanar.add(pv.get(i));
                }
                this.reportAllPlanars();
            }
        }
        if (finalc != null) {
            for (int i = 0; i < finalc.size(); ++i) {
                c = (double[][])finalc.get(i);
                FragmentConformer fc = new FragmentConformer(this.getFragment(), c);
                this.registerConformer(fc);
            }
        }
        if (finalcOptReq != null) {
            for (int i = 0; i < finalcOptReq.size(); ++i) {
                c = (double[][])finalcOptReq.get(i);
                FragmentConformer fc = new FragmentConformer(this.getFragment(), c);
                fc.setOptimizationRequired();
                this.registerConformer(fc);
            }
        }
        if (debug != null) {
            debug.decLevel();
        }
        return 1;
    }

    void reportAllPlanars() {
        debugPrintout debug = CleanArgs.getDebug();
        int[] f1nc = U.remove(this.builder1.getCommand().getAtoms(), this.fuseAtoms);
        f1nc = U.remove(f1nc, this.a1ad2);
        f1nc = this.getCommand().getAtomsInv(f1nc);
        int[] f2nc = U.remove(this.builder2.getCommand().getAtoms(), this.fuseAtoms);
        f2nc = U.remove(f2nc, this.a2ad1);
        f2nc = this.getCommand().getAtomsInv(f2nc);
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("f1nc: " + U.sel(f1nc) + " f2nc: " + U.sel(f2nc) + " hp1and2: " + U.sel(this.hp1and2) + " fuseAtoms: " + this.fuseAtoms);
        }
        double f = 0.2617993877991494;
        for (int i = 0; i < this.allPlanar.size(); ++i) {
            PrincipalAxes pa = (PrincipalAxes)this.allPlanar.get(i);
            double[][] c = pa.getAllC();
            for (int j = 2; j < 4; ++j) {
                double[][] cc = U.clone(c);
                Drawer d = null;
                switch (j) {
                    case 0: {
                        throw new UnsupportedOperationException();
                    }
                    case 1: {
                        throw new UnsupportedOperationException();
                    }
                    case 2: {
                        if (debug != null) {
                            d = new Drawer();
                        }
                        pa.twist(cc, f1nc, f, d);
                        if (debug != null) {
                            d.placeApplet(debug, "twist1");
                        }
                        if (debug != null) {
                            d = new Drawer();
                        }
                        pa.twist(cc, f2nc, -f, d);
                        if (debug == null) break;
                        d.placeApplet(debug, "twist2");
                        break;
                    }
                    case 3: {
                        if (debug != null) {
                            d = new Drawer();
                        }
                        pa.twist(cc, f1nc, -f, d);
                        if (debug != null) {
                            d.placeApplet(debug, "twist3");
                        }
                        if (debug != null) {
                            d = new Drawer();
                        }
                        pa.twist(cc, f2nc, f, d);
                        if (debug == null) break;
                        d.placeApplet(debug, "twist4");
                    }
                }
                if (debug != null) {
                    this.getFragment().getFragMol().place3DApplet("Transformed", cc);
                }
                FragmentConformer fc = new FragmentConformer(this.getFragment(), cc);
                fc.setOptimizationRequired();
                this.registerConformer(fc);
            }
        }
        this.allPlanar.removeAllElements();
    }

    public class PermutationPair {
        int[] perm1;
        int[] perm2;
        int perm1index = -1;
        int perm2index = -1;
        int[][] hpMapPairs = null;

        int[][] getHpMapPairs() {
            if (this.hpMapPairs == null) {
                int[] hp12 = FragFragFuseBuildCommand.this.getHp1and2();
                int[] hp1 = FragFragFuseBuildCommand.this.getHp1and2In1();
                int[] hp2 = FragFragFuseBuildCommand.this.getHp1and2In2();
                this.hpMapPairs = new int[hp12.length][2];
                for (int i = 0; i < this.hpMapPairs.length; ++i) {
                    this.hpMapPairs[i][0] = this.perm1[hp1[i]];
                    this.hpMapPairs[i][1] = this.perm2[hp2[i]];
                }
            }
            return this.hpMapPairs;
        }

        public PermutationPair(int[] perm1, int[] perm2, int perm1i, int perm2i) {
            this.perm1 = perm1;
            this.perm2 = perm2;
            this.perm1index = perm1i;
            this.perm2index = perm2i;
        }

        public boolean sameMatch(PermutationPair o) {
            int[][] hpp1 = this.getHpMapPairs();
            int[][] hpp2 = o.getHpMapPairs();
            for (int i = 0; i < hpp1.length; ++i) {
                boolean found = false;
                for (int j = 0; j < hpp2.length; ++j) {
                    if (hpp1[i][0] != hpp2[j][0] || hpp1[i][1] != hpp2[j][1]) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }

        public boolean foundSame(Vector v) {
            for (int i = 0; i < v.size(); ++i) {
                if (!this.sameMatch((PermutationPair)v.get(i))) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return this.perm1index + ": { " + U.sel(this.perm1) + "}; " + this.perm2index + ": {" + U.sel(this.perm2) + "}";
        }

        public void printout(debugPrintout w) {
            int i;
            w.Tstart();
            w.Trow();
            w.TprintBC(this.perm1.length + 1, "Fragment 1 permutation (" + this.perm1index + ")");
            w.Trow();
            w.TprintBC("From");
            for (i = 0; i < this.perm1.length; ++i) {
                w.TprintC("" + i);
            }
            w.Trow();
            w.TprintBC("To");
            for (i = 0; i < this.perm1.length; ++i) {
                w.TprintC("" + this.perm1[i]);
            }
            w.Trow();
            w.TprintBC(this.perm2.length + 1, "Fragment 2 permutation (" + this.perm2index + ")");
            w.Trow();
            w.TprintBC("From");
            for (i = 0; i < this.perm2.length; ++i) {
                w.TprintC("" + i);
            }
            w.Trow();
            w.TprintBC("To");
            for (i = 0; i < this.perm2.length; ++i) {
                w.TprintC("" + this.perm2[i]);
            }
            this.getHpMapPairs();
            w.Trow();
            w.TprintBC(this.hpMapPairs.length, "HP map pairs");
            w.Trow();
            for (i = 0; i < this.hpMapPairs.length; ++i) {
                w.TprintC("" + this.hpMapPairs[i][0]);
            }
            w.Trow();
            for (i = 0; i < this.hpMapPairs.length; ++i) {
                w.TprintC("" + this.hpMapPairs[i][1]);
            }
            w.Tstop();
        }
    }

    public class IndependentPair {
        int ab;
        int ab1;
        int ab2;
        int[] ag1;
        int[] ag1in2;
        int[] involved1;
        int[] ag2;
        int[] ag2in1;
        int[] involved2;
        int[] ad1;
        int[] ad1in2;
        int[] ad2;
        int[] ad2in1;
        int aamapcount;
        BitSet ag1a2;
        BitSet ag2a1;
        Vector agperm;
        public static final int TYPE_FOURLIGANDS = 1;
        public static final int TYPE_FOURWITHADDITIONAL = 2;
        int type = -1;
        int[] aa = null;
        int[] aa1 = null;
        int[] aa2 = null;

        public BitSet checkChirality4(double[][] c1, double[][] c2, int[] perm1, int[] perm2, int[] nripc) {
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("CheckChirality4");
            }
            if (this.type != 1 && this.type != 2) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("Type can not be checked for chirality4");
                }
                return null;
            }
            int[] iv1 = this.involved1;
            int[] iv2 = this.involved2;
            if (this.type == 2) {
                int i;
                iv1 = new int[4];
                iv2 = new int[4];
                for (i = 0; i < this.involved1.length; ++i) {
                    iv1[i] = this.involved1[i];
                    iv2[i] = this.involved2[i];
                }
                for (i = this.involved1.length; i < 4; ++i) {
                    iv1[i] = this.aa1[i - this.involved1.length];
                    iv2[i] = this.aa2[i - this.involved2.length];
                }
            }
            int ct1 = Tetrahedron.checkConfiguration(c1[perm1[iv1[0]]], c1[perm1[iv1[1]]], c1[perm1[iv1[2]]], c1[perm1[iv1[3]]], c1[perm1[this.ab1]]);
            int ct2 = Tetrahedron.checkConfiguration(c2[perm2[iv2[0]]], c2[perm2[iv2[1]]], c2[perm2[iv2[2]]], c2[perm2[iv2[3]]], c2[perm2[this.ab2]]);
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("ct1=" + ct1 + " ct2=" + ct2);
            }
            if (ct1 == Tetrahedron.TYPE_NOPARITY || ct2 == Tetrahedron.TYPE_NOPARITY) {
                return null;
            }
            BitSet parb1 = new BitSet(this.getChoicesSize());
            BitSet parb2 = new BitSet(this.getChoicesSize());
            BitSet ret = new BitSet(this.getChoicesSize());
            for (int i = 0; i < (nripc == null ? this.getChoicesSize() : nripc.length); ++i) {
                int[][] p = (int[][])this.agperm.get(nripc == null ? i : nripc[i]);
                if (this.type == 1) {
                    iv1 = p[2];
                    iv2 = p[3];
                } else {
                    for (int j = 0; j < this.involved1.length; ++j) {
                        iv1[j] = p[2][j];
                        iv2[j] = p[3][j];
                    }
                }
                int t1 = Tetrahedron.checkConfiguration(c1[perm1[iv1[0]]], c1[perm1[iv1[1]]], c1[perm1[iv1[2]]], c1[perm1[iv1[3]]], c1[perm1[this.ab1]]);
                int t2 = Tetrahedron.checkConfiguration(c2[perm2[iv2[0]]], c2[perm2[iv2[1]]], c2[perm2[iv2[2]]], c2[perm2[iv2[3]]], c2[perm2[this.ab2]]);
                if (t1 == Tetrahedron.TYPE_PARITYB) {
                    parb1.set(i);
                }
                if (t2 == Tetrahedron.TYPE_PARITYB) {
                    parb2.set(i);
                }
                if (t1 == t2) {
                    ret.set(i);
                } else if (t1 == Tetrahedron.TYPE_NOPARITY || t2 == Tetrahedron.TYPE_NOPARITY) {
                    throw new UnsupportedOperationException("Chirality mismatch");
                }
                if (!CleanArgs.doVerbose()) continue;
                CleanArgs.verbose("C#" + i + " t1=" + t1 + " t2=" + t2);
            }
            if (ret.isEmpty()) {
                return null;
            }
            return ret;
        }

        public int getChoicesSize() {
            return this.agperm.size();
        }

        public void permutate(int choice, int[] srcPermA, int[] srcPermB, int[] targPermA, int[] targPermB) {
            int i;
            int[][] p = (int[][])this.agperm.get(choice);
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Permutate independent group", "choice    #" + choice + "<BR>" + "p:         " + U.toString(p) + "<BR>" + "ag1:       " + U.sel(this.ag1) + "<BR>" + "ag1in2:    " + U.sel(this.ag1in2) + "<BR>" + "ag1a2:     " + U.sel(this.ag1a2) + "<BR>" + "ag2:       " + U.sel(this.ag2) + "<BR>" + "ag2in1:    " + U.sel(this.ag2in1) + "<BR>" + "ag2a1:     " + U.sel(this.ag2a1) + "<BR>" + "srcPermA:  " + U.sel(srcPermA) + "<BR>" + "targPermA: " + U.sel(targPermA) + "<BR>" + "srcPermB:  " + U.sel(srcPermB) + "<BR>" + "targPermB: " + U.sel(targPermB));
            }
            for (i = 0; i < this.ag1.length; ++i) {
                if (targPermA[this.ag1[i]] >= 0) {
                    throw new IndexOutOfBoundsException("Target permutation overwritten.");
                }
                targPermA[this.ag1[i]] = srcPermA[this.ag1[p[0][i]]];
                if (this.ag1a2.get(i)) continue;
                if (targPermB[this.ag1in2[i]] >= 0) {
                    throw new IndexOutOfBoundsException("Target permutation overwritten.");
                }
                targPermB[this.ag1in2[i]] = srcPermB[this.ag1in2[i]];
            }
            for (i = 0; i < this.ag2.length; ++i) {
                if (targPermB[this.ag2[i]] >= 0) {
                    throw new IndexOutOfBoundsException("Target permutation overwritten.");
                }
                targPermB[this.ag2[i]] = srcPermB[this.ag2[p[1][i]]];
                if (this.ag2a1.get(i)) continue;
                if (targPermA[this.ag2in1[i]] >= 0) {
                    throw new IndexOutOfBoundsException("Target permutation overwritten.");
                }
                targPermA[this.ag2in1[i]] = srcPermA[this.ag2in1[i]];
            }
        }

        private double getOverlapError(double[][] ac1, double[][] ac2, int ch) {
            int j;
            int j2;
            int[][] perm = (int[][])this.agperm.get(ch);
            int[] f1p = U.gen(ac1.length);
            int[] f2p = U.gen(ac2.length);
            for (j2 = 0; j2 < this.ag1.length; ++j2) {
                f1p[this.ag1[j2]] = this.ag1[perm[0][j2]];
            }
            for (j2 = 0; j2 < this.ag2.length; ++j2) {
                f2p[this.ag2[j2]] = this.ag2[perm[1][j2]];
            }
            double err = 0.0;
            for (j = 0; j < this.ag1.length; ++j) {
                err += V.normDistSq(ac1[f1p[this.ag1[j]]], ac1[f1p[this.ab1]], ac2[f2p[this.ag1in2[j]]], ac2[f2p[this.ab2]]);
            }
            for (j = 0; j < this.ad1.length; ++j) {
                err += V.normDistSq(ac1[f1p[this.ad1[j]]], ac1[f1p[this.ab1]], ac2[f2p[this.ad1in2[j]]], ac2[f2p[this.ab2]]);
            }
            return err;
        }

        public void permutate(double[][] ac1, double[][] ac2, int ch) {
            int i;
            int i2;
            int j;
            int[][] perm = (int[][])this.agperm.get(ch);
            int[] f1p = U.gen(ac1.length);
            int[] f2p = U.gen(ac2.length);
            for (j = 0; j < this.ag1.length; ++j) {
                f1p[this.ag1[j]] = this.ag1[perm[0][j]];
            }
            for (j = 0; j < this.ag2.length; ++j) {
                f2p[this.ag2[j]] = this.ag2[perm[1][j]];
            }
            double[][] tmp1 = new double[ac1.length][];
            for (i2 = 0; i2 < tmp1.length; ++i2) {
                tmp1[i2] = ac1[i2];
            }
            for (i2 = 0; i2 < tmp1.length; ++i2) {
                ac1[i2] = tmp1[f1p[i2]];
            }
            double[][] tmp2 = new double[ac2.length][];
            for (i = 0; i < tmp2.length; ++i) {
                tmp2[i] = ac2[i];
            }
            for (i = 0; i < tmp2.length; ++i) {
                ac2[i] = tmp2[f2p[i]];
            }
        }

        public int[] findBestOverlaps(double[][] ac1, double[][] ac2) {
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Find best overlap permutations");
            }
            double[] errs = new double[this.getChoicesSize()];
            double besterr = -1.0;
            for (int i = 0; i < this.getChoicesSize(); ++i) {
                double err;
                errs[i] = err = this.getOverlapError(ac1, ac2, i);
                if (i == 0 || err < besterr) {
                    besterr = err;
                }
                if (!CleanArgs.doVerbose()) continue;
                CleanArgs.verbose("Err #" + i + ": " + err);
            }
            besterr = besterr * 1.1 + 0.5;
            IntVector ret = new IntVector();
            for (int i = 0; i < errs.length; ++i) {
                if (!(errs[i] <= besterr)) continue;
                ret.add(i);
            }
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Besterr: " + besterr + " ret: " + U.sel(ret.toArray()));
            }
            return ret.toArray();
        }

        public void findBestOverlap(double[][] ac1, double[][] ac2) {
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Find best overlap");
            }
            int[] bestp1 = new int[ac1.length];
            int[] bestp2 = new int[ac2.length];
            double besterr = -1.0;
            int bestch = -1;
            for (int i = 0; i < this.getChoicesSize(); ++i) {
                double err = this.getOverlapError(ac1, ac2, i);
                if (besterr < 0.0 || besterr > err) {
                    besterr = err;
                    bestch = i;
                }
                if (!CleanArgs.doVerbose()) continue;
                CleanArgs.verbose("Check choice " + i + " err=" + err);
            }
            this.permutate(ac1, ac2, bestch);
        }

        public int[] findNonRedundants(double[][] c1, double[][] c2, int[] perm1, int[] perm2, SimpleCanceller c) {
            debugPrintout debug = CleanArgs.getDebug();
            if (debug != null) {
                debug.incLevel("Find redundant IPC choices");
            }
            BitSet r1 = this.findAutoisomorphs(0, FragFragFuseBuildCommand.this.builder1.getFragment().getFragMol(), c1, FragFragFuseBuildCommand.this.mam1.getHPAtoms(), perm1, c);
            BitSet r2 = this.findAutoisomorphs(1, FragFragFuseBuildCommand.this.builder2.getFragment().getFragMol(), c2, FragFragFuseBuildCommand.this.mam2.getHPAtoms(), perm2, c);
            if (debug != null) {
                debug.decLevel();
            }
            r1.or(r2);
            int[] ret = U.remove(U.gen(this.getChoicesSize()), U.collectSets(r1));
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("IpcRedundant frag 1: " + (r1 == null ? "NULL" : U.sel(U.collectSets(r1))));
                CleanArgs.verbose("IpcRedundant frag 2: " + (r2 == null ? "NULL" : U.sel(U.collectSets(r2))));
                CleanArgs.verbose("ret: " + U.sel(ret));
            }
            return ret;
        }

        public BitSet findAutoisomorphs(int f, myMolecule frag, double[][] fc, int[] hpatoms, int[] hpperm, SimpleCanceller c) {
            int i;
            int[] ag;
            debugPrintout debug = CleanArgs.getDebug();
            int[] nArray = ag = f == 0 ? this.ag1 : this.ag2;
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Find autoisomorphs, ag=" + U.sel(ag));
                CleanArgs.verbose("HP atoms=" + U.sel(hpatoms));
                CleanArgs.verbose("HPperm=" + U.sel(hpperm));
            }
            BitSet ret = new BitSet();
            if (ag.length < 2) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("ag.length=" + ag.length + ", return null");
                }
                return ret;
            }
            Substructure3DSearch ss = new Substructure3DSearch();
            ss.setQuery(frag.getOriginalMolCopy());
            ss.setTarget(frag.getOriginalMolCopy());
            int[] fm = new int[fc.length];
            U.fill(fm, -1);
            for (i = 0; i < hpatoms.length; ++i) {
                fm[hpatoms[i]] = hpatoms[i];
            }
            for (i = 0; i < ag.length; ++i) {
                fm[hpperm[ag[i]]] = hpperm[ag[i]];
            }
            ss.setFrozenMatch(fm);
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("FM: " + U.sel(fm));
            }
            ss.setIgnoreGeometryMatching(false, 0.1);
            double[][] qc = new double[fc.length][3];
            double[][] tc = new double[fc.length][3];
            U.copyTo(fc, qc, hpperm);
            U.copyTo(fc, tc, hpperm);
            block2: for (int i2 = 1; i2 < this.getChoicesSize(); ++i2) {
                int j;
                if (c != null && c.isCancelled()) {
                    return new BitSet();
                }
                int[] pi = ((int[][])this.agperm.get(i2))[f];
                boolean pichecked = false;
                for (j = 0; j < i2; ++j) {
                    if (!U.equals(pi, ((int[][])this.agperm.get(j))[f])) continue;
                    pichecked = true;
                    if (!ret.get(j)) break;
                    ret.set(i2);
                    break;
                }
                if (pichecked) continue;
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("Check ch i=" + i2 + ": " + U.sel(pi));
                }
                U.copyTo(fc, tc, hpperm);
                for (j = 0; j < ag.length; ++j) {
                    U.copyTo(tc[hpperm[ag[j]]], fc[ag[pi[j]]]);
                }
                ss.setTargetCoordinates(tc);
                for (j = 0; j < i2; ++j) {
                    int k;
                    int[] pj = ((int[][])this.agperm.get(j))[f];
                    if (U.equals(pi, pj)) continue;
                    boolean pjchecked = false;
                    for (k = 0; k < j; ++k) {
                        if (!U.equals(pj, ((int[][])this.agperm.get(k))[f])) continue;
                        pjchecked = true;
                        break;
                    }
                    if (pjchecked) continue;
                    if (CleanArgs.doVerbose()) {
                        CleanArgs.verbose("Check ch j=" + j + ": " + U.sel(pj));
                    }
                    U.copyTo(fc, qc, hpperm);
                    for (k = 0; k < ag.length; ++k) {
                        U.copyTo(qc[hpperm[ag[k]]], fc[ag[pj[k]]]);
                    }
                    ss.setQueryCoordinates(qc);
                    if (debug != null) {
                        frag.place3DApplet("Q", qc);
                        frag.place3DApplet("T", tc);
                    }
                    if (!ss.findFirst()) continue;
                    ret.set(i2);
                    if (!CleanArgs.doVerbose()) continue block2;
                    CleanArgs.verbose("MATCH");
                    continue block2;
                }
            }
            return ret;
        }

        void fillPermV() {
            this.agperm = new Vector();
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("fillPermV()");
            }
            int[][] newp = new int[4][];
            newp[0] = new int[this.ag1.length];
            newp[1] = new int[this.ag2.length];
            int currp = 0;
            int currf = 0;
            if (newp[0].length == 0) {
                currf = 1;
            }
            int[] prevAg2a1 = new int[this.ag2.length];
            block0: for (int i = 0; i < prevAg2a1.length; ++i) {
                prevAg2a1[i] = -1;
                if (!this.ag2a1.get(i)) continue;
                for (int j = i - 1; j >= 0; --j) {
                    if (!this.ag2a1.get(j)) continue;
                    prevAg2a1[i] = j;
                    continue block0;
                }
            }
            while (true) {
                int i;
                boolean valid = false;
                while (true) {
                    if (newp[currf][currp] >= newp[currf].length) {
                        if (--currp < 0) {
                            if (currf == 0 || newp[0].length == 0) {
                                valid = false;
                                break;
                            }
                            currp = newp[--currf].length - 1;
                        }
                        int[] nArray = newp[currf];
                        int n = currp;
                        nArray[n] = nArray[n] + 1;
                        continue;
                    }
                    valid = true;
                    for (i = 0; i < currp; ++i) {
                        if (newp[currf][currp] != newp[currf][i]) continue;
                        valid = false;
                    }
                    if (currf == 1 && prevAg2a1[currp] >= 0 && newp[1][prevAg2a1[currp]] > newp[1][currp]) {
                        valid = false;
                    }
                    if (!valid) {
                        int[] nArray = newp[currf];
                        int n = currp;
                        nArray[n] = nArray[n] + 1;
                        continue;
                    }
                    if (++currp >= newp[currf].length) {
                        ++currf;
                        currp = 0;
                        while (currf < 2 && newp[currf].length == 0) {
                            ++currf;
                        }
                    }
                    if (currf >= 2) {
                        valid = true;
                        break;
                    }
                    newp[currf][currp] = 0;
                }
                if (valid) {
                    if (CleanArgs.doVerbose()) {
                        CleanArgs.verbose("Valid: ", U.toString(newp));
                    }
                } else {
                    if (!CleanArgs.doVerbose()) break;
                    CleanArgs.verbose("Not valid, exit loop");
                    break;
                }
                newp[2] = U.clone(this.involved1);
                newp[3] = U.clone(this.involved2);
                block6: for (i = 0; i < newp[2].length; ++i) {
                    int j;
                    for (j = 0; j < this.ag1.length; ++j) {
                        if (newp[2][i] != this.ag1[j]) continue;
                        newp[2][i] = this.ag1[newp[0][j]];
                        break;
                    }
                    for (j = 0; j < this.ag2.length; ++j) {
                        if (newp[3][i] != this.ag2[j]) continue;
                        newp[3][i] = this.ag2[newp[1][j]];
                        continue block6;
                    }
                }
                this.agperm.add(U.clone(newp));
                for (currf = 1; currf > 0 && newp[currf].length == 0; --currf) {
                }
                currp = newp[currf].length - 1;
                int[] nArray = newp[currf];
                int n = currp;
                nArray[n] = nArray[n] + 1;
            }
        }

        public void printout(debugPrintout debug) {
            int i;
            debug.printB("Independent pair");
            debug.println("aamapcount: " + this.aamapcount);
            debug.println("ab1: " + this.ab1);
            debug.println("ab2: " + this.ab2);
            debug.println("type: " + this.type);
            debug.Tstart();
            debug.Trow();
            debug.TprintBC("Involved1:");
            for (i = 0; i < this.involved1.length; ++i) {
                debug.Tprint("" + this.involved1[i]);
            }
            debug.Trow();
            debug.TprintBC("Involved2:");
            for (i = 0; i < this.involved2.length; ++i) {
                debug.Tprint("" + this.involved2[i]);
            }
            if (this.aa != null) {
                debug.Trow();
                debug.TprintBC("aa:");
                for (i = 0; i < this.aa.length; ++i) {
                    debug.Tprint("" + this.aa[i]);
                }
                debug.Trow();
                debug.TprintBC("aa1:");
                for (i = 0; i < this.aa.length; ++i) {
                    debug.Tprint("" + this.aa1[i]);
                }
                debug.Trow();
                debug.TprintBC("aa2:");
                for (i = 0; i < this.aa.length; ++i) {
                    debug.Tprint("" + this.aa2[i]);
                }
            } else {
                debug.Trow();
                debug.TprintBC("aa/aa1/aa2:");
                debug.Tprint("null");
            }
            debug.Trow();
            debug.TprintBC("ag1:");
            for (i = 0; i < this.ag1.length; ++i) {
                debug.Tprint("" + this.ag1[i]);
            }
            debug.Trow();
            debug.TprintBC("ag1a2:");
            for (i = 0; i < this.ag1.length; ++i) {
                debug.Tprint(this.ag1a2.get(i) ? "+" : ".");
            }
            debug.Trow();
            debug.TprintBC("ag1in2:");
            for (i = 0; i < this.ag1.length; ++i) {
                debug.Tprint("" + this.ag1in2[i]);
            }
            debug.Trow();
            debug.TprintBC("ag2:");
            for (i = 0; i < this.ag2.length; ++i) {
                debug.Tprint("" + this.ag2[i]);
            }
            debug.Trow();
            debug.TprintBC("ag2a1:");
            for (i = 0; i < this.ag2.length; ++i) {
                debug.Tprint(this.ag2a1.get(i) ? "+" : ".");
            }
            debug.Trow();
            debug.TprintBC("ag2in1:");
            for (i = 0; i < this.ag2.length; ++i) {
                debug.Tprint("" + this.ag2in1[i]);
            }
            debug.Trow();
            debug.TprintBC("ad1:");
            for (i = 0; i < this.ad1.length; ++i) {
                debug.Tprint("" + this.ad1[i]);
            }
            debug.Trow();
            debug.TprintBC("ad1in2:");
            for (i = 0; i < this.ad1in2.length; ++i) {
                debug.Tprint("" + this.ad1in2[i]);
            }
            debug.Trow();
            debug.TprintBC("ad2:");
            for (i = 0; i < this.ad2.length; ++i) {
                debug.Tprint("" + this.ad2[i]);
            }
            debug.Trow();
            debug.TprintBC("ad2in1:");
            for (i = 0; i < this.ad2.length; ++i) {
                debug.Tprint("" + this.ad2in1[i]);
            }
            debug.Tstop();
            debug.printB("Anchor group permutations");
            debug.Tstart();
            debug.Trow();
            debug.TprintBC(this.ag1.length, "AG 1");
            debug.TprintBC(this.ag2.length, "AG 2");
            debug.TprintBC(this.involved1.length, "Involved1 p");
            debug.TprintBC(this.involved1.length, "Involved2 p");
            debug.Trow();
            for (i = 0; i < this.ag1.length; ++i) {
                debug.TprintBC("" + i);
            }
            for (i = 0; i < this.ag2.length; ++i) {
                debug.TprintBC("" + i);
            }
            for (i = 0; i < this.agperm.size(); ++i) {
                debug.Trow();
                int[][] p = (int[][])this.agperm.get(i);
                for (int j = 0; j < 4; ++j) {
                    for (int k = 0; k < p[j].length; ++k) {
                        debug.Tprint("" + p[j][k]);
                    }
                }
            }
            debug.Tstop();
            FragFragFuseBuildCommand.this.builder1.getFragment().getFragMol().placeApplets("Frag1", new String[]{U.sel(this.ag1), U.sel(this.ad1)}, new String[]{"ag1", "ad1"});
            FragFragFuseBuildCommand.this.builder2.getFragment().getFragMol().placeApplets("Frag2", new String[]{U.sel(this.ag2), U.sel(this.ad2)}, new String[]{"ag2", "ad2"});
        }

        public IndependentPair(int[] ag1, int[] ag2, int[] ad1, int[] ad2) {
            int b;
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("<B>new IndependentPair()</B>", "ag1: " + U.sel(ag1) + "<BR>" + "ag2: " + U.sel(ag2) + "<BR>" + "ad1: " + U.sel(ad1) + "<BR>" + "ad2: " + U.sel(ad2));
            }
            this.ad1 = ad1;
            this.ad2 = ad2;
            this.ag1 = ag1;
            this.ag2 = ag2;
            this.aamapcount = ag1.length - ad2.length;
            this.ag1in2 = FragFragFuseBuildCommand.this.builder2.getCommand().getAtomsInv(FragFragFuseBuildCommand.this.builder1.getCommand().getAtoms(ag1));
            this.ag2in1 = FragFragFuseBuildCommand.this.builder1.getCommand().getAtomsInv(FragFragFuseBuildCommand.this.builder2.getCommand().getAtoms(ag2));
            this.ad1in2 = FragFragFuseBuildCommand.this.builder2.getCommand().getAtomsInv(FragFragFuseBuildCommand.this.builder1.getCommand().getAtoms(ad1));
            this.ad2in1 = FragFragFuseBuildCommand.this.builder1.getCommand().getAtomsInv(FragFragFuseBuildCommand.this.builder2.getCommand().getAtoms(ad2));
            this.involved1 = U.append(ag1, ad1);
            this.involved2 = FragFragFuseBuildCommand.this.builder2.getCommand().getAtomsInv(FragFragFuseBuildCommand.this.builder1.getCommand().getAtoms(this.involved1));
            if (ag1.length > 0) {
                b = FragFragFuseBuildCommand.this.builder1.getCommand().getAnchorBase(FragFragFuseBuildCommand.this.builder1.getCommand().getAtoms(ag1[0]));
                this.ab1 = FragFragFuseBuildCommand.this.builder1.getCommand().getAtomsInv(b);
                this.ab2 = FragFragFuseBuildCommand.this.builder2.getCommand().getAtomsInv(b);
            } else {
                b = FragFragFuseBuildCommand.this.builder2.getCommand().getAnchorBase(FragFragFuseBuildCommand.this.builder2.getCommand().getAtoms(ag2[0]));
                this.ab1 = FragFragFuseBuildCommand.this.builder1.getCommand().getAtomsInv(b);
                this.ab2 = FragFragFuseBuildCommand.this.builder2.getCommand().getAtomsInv(b);
            }
            this.ab = FragFragFuseBuildCommand.this.builder1.getCommand().getAtoms(this.ab1);
            if (this.ab != FragFragFuseBuildCommand.this.builder2.getCommand().getAtoms(this.ab2)) {
                throw new UnsupportedOperationException("Anchor base mismatch");
            }
            if (this.involved1.length == 4) {
                this.type = 1;
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("Type=4ligands");
                }
            } else if (this.involved1.length < 4) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("Check for additionals");
                }
                IntVector additionalCandidates = new IntVector(10);
                myMolecule basemol = FragFragFuseBuildCommand.this.builder1.getOrigMol();
                FragFragFuseBuildCommand.this.getHp1and2();
                for (int i = 0; i < basemol.ctab[this.ab].length; ++i) {
                    int nc = basemol.ctab[this.ab][i];
                    int nc1 = FragFragFuseBuildCommand.this.builder1.getCommand().getAtomsInv(nc);
                    int nc2 = FragFragFuseBuildCommand.this.builder2.getCommand().getAtomsInv(nc);
                    if (CleanArgs.doVerbose()) {
                        CleanArgs.verbose("Check #" + i + " nc=" + nc + " nc1=" + nc1 + " nc2=" + nc2);
                    }
                    if (nc1 < 0 && nc2 < 0) {
                        if (!CleanArgs.doVerbose()) continue;
                        CleanArgs.verbose("Out of fragments");
                        continue;
                    }
                    if (nc1 >= 0 && nc2 >= 0) {
                        if (CleanArgs.doVerbose()) {
                            CleanArgs.verbose("Involved in both fragments");
                        }
                        if (!U.contains(FragFragFuseBuildCommand.this.hp1and2, nc)) continue;
                        if (CleanArgs.doVerbose()) {
                            CleanArgs.verbose("HP candidate");
                        }
                        additionalCandidates.add(nc);
                        continue;
                    }
                    if (!CleanArgs.doVerbose()) continue;
                    CleanArgs.verbose("Involved in one of the fragments");
                }
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose(additionalCandidates.size() + " candidates found");
                }
                if (this.involved1.length + additionalCandidates.size() >= 4) {
                    this.type = 2;
                    this.aa = additionalCandidates.toArray();
                    this.aa1 = FragFragFuseBuildCommand.this.builder1.getCommand().getAtomsInv(this.aa);
                    this.aa2 = FragFragFuseBuildCommand.this.builder2.getCommand().getAtomsInv(this.aa);
                    if (CleanArgs.doVerbose()) {
                        CleanArgs.verbose("aa: " + U.sel(this.aa) + " aa1: " + U.sel(this.aa1) + " aa2: " + U.sel(this.aa2));
                    }
                }
            }
            if (ag1.length < 1 && ag2.length < 1) {
                throw new UnsupportedOperationException("Anchor group1 length=" + ag1.length + " group2 length=" + ag2.length);
            }
            if (ag1.length - ad2.length != ag2.length - ad1.length) {
                throw new UnsupportedOperationException("Anchor-anchor overlap count mismatch.");
            }
            if (U.hasCommon(ag1) || U.hasCommon(ag2) || U.hasCommon(ad1) || U.hasCommon(ad2)) {
                throw new UnsupportedOperationException("Duplicate item(s) in groups");
            }
            if (U.hasCommon(ag1, ad1) || U.hasCommon(ag2, ad2)) {
                throw new UnsupportedOperationException("Common items in anchor/director groups");
            }
            this.ag1a2 = new BitSet();
            this.ag2a1 = new BitSet();
            for (int i = 0; i < ag1.length; ++i) {
                int a1 = ag1[i];
                int a1in2 = this.ag1in2[i];
                if (!U.contains(ag2, a1in2)) continue;
                this.ag1a2.set(i);
                this.ag2a1.set(U.indexOf(ag2, a1in2));
            }
            this.fillPermV();
        }
    }

    public static final class IPDimension {
        private int aaMapCount;
        private int ad1MapCount;
        private int ad2MapCount;
        private boolean partial;

        public int getAaMapCount() {
            return this.aaMapCount;
        }

        public int getAd1MapCount() {
            return this.ad1MapCount;
        }

        public int getAd2MapCount() {
            return this.ad2MapCount;
        }

        public boolean isPartial() {
            return this.partial;
        }

        public IPDimension(int[] ag1, int[] ag2, int[] ad1, int[] ad2) {
            this.ad1MapCount = ad1.length;
            this.ad2MapCount = ad2.length;
            this.aaMapCount = ag1.length - ad2.length;
            this.partial = false;
            if (this.ad1MapCount <= 1 && this.ad2MapCount <= 1 && this.aaMapCount <= 2) {
                return;
            }
            if (this.ad1MapCount + this.ad2MapCount >= 2) {
                this.aaMapCount = 0;
                this.partial = true;
            }
            if (this.ad1MapCount >= 2) {
                this.ad1MapCount = 2;
                this.ad2MapCount = 0;
                this.partial = true;
            } else if (this.ad2MapCount >= 2) {
                this.ad1MapCount = 0;
                this.ad2MapCount = 2;
                this.partial = true;
            }
            if (this.aaMapCount >= 3) {
                this.aaMapCount = 2;
            }
        }
    }

    public class PartialIndependentPair {
        int ab;
        int abIn1;
        int abIn2;
        int[] ad1;
        int[] ad1In1;
        int[] ad1In2;
        int[] ad2;
        int[] ad2In2;
        int[] ad2In1;
        int[] aa;
        int[] aaIn1;
        int[] aaIn2;
        int[] ag1;
        int[] ag1In1;
        int[] ag2;
        int[] ag2In2;
        Vector agperm;
        IPDimension dim;

        public int[] getNonRedundantChoices(Fragment frag1, Fragment frag2, double[][] fc1, double[][] fc2, int[] hpperm1, int[] hpperm2) {
            int i;
            debugPrintout debug = CleanArgs.getDebug();
            if (debug != null) {
                debug.incLevel("getNonRedundantChoices");
            }
            Substructure3DSearch ss1 = new Substructure3DSearch();
            ss1.setQuery(frag1.getFragMol().getOriginalMolCopy());
            ss1.setTarget(frag1.getFragMol().getOriginalMolCopy());
            Substructure3DSearch ss2 = new Substructure3DSearch();
            ss2.setQuery(frag2.getFragMol().getOriginalMolCopy());
            ss2.setTarget(frag2.getFragMol().getOriginalMolCopy());
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("getNonRedundantChoices()");
            }
            BitSet nr = new BitSet(this.getChoicesSize());
            for (i = 0; i < this.getChoicesSize(); ++i) {
                nr.set(i);
            }
            for (i = 1; i < this.getChoicesSize(); ++i) {
                if (!nr.get(i)) continue;
                int[][] pi = (int[][])this.agperm.get(i);
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("Permutation i=" + i + ": " + U.toString(pi));
                }
                for (int j = 0; j < i; ++j) {
                    int k;
                    boolean same2;
                    boolean same1;
                    if (!nr.get(j)) continue;
                    int[][] pj = (int[][])this.agperm.get(j);
                    if (CleanArgs.doVerbose()) {
                        CleanArgs.verbose("Compare to j=" + j + ": " + U.toString(pj));
                    }
                    if (same1 = U.equals(pi[1], pj[1])) {
                        if (CleanArgs.doVerbose()) {
                            CleanArgs.verbose("frag1 same, skip check");
                        }
                    } else {
                        int k2;
                        ss1.setIgnoreGeometryMatching(false, 0.1);
                        ss1.setQueryCoordinates(fc1);
                        ss1.setTargetCoordinates(fc1);
                        int[] fm1 = new int[fc1.length];
                        U.fill(fm1, -1);
                        for (k2 = 0; k2 < FragFragFuseBuildCommand.this.hp1and2In1.length; ++k2) {
                            fm1[hpperm1[FragFragFuseBuildCommand.this.hp1and2In1[k2]]] = hpperm1[FragFragFuseBuildCommand.this.hp1and2In1[k2]];
                        }
                        for (k2 = 0; k2 < this.dim.getAaMapCount(); ++k2) {
                            fm1[hpperm1[this.aaIn1[k2]]] = hpperm1[this.aaIn1[k2]];
                        }
                        for (k2 = 0; k2 < this.dim.getAd2MapCount(); ++k2) {
                            fm1[hpperm1[this.ag1In1[pi[1][k2]]]] = hpperm1[this.ag1In1[pj[1][k2]]];
                        }
                        ss1.setFrozenMatch(fm1);
                        if (ss1.findFirst()) {
                            if (CleanArgs.doVerbose()) {
                                CleanArgs.verbose("MATCH! Kill later equivalents");
                            }
                            nr.clear(i);
                            for (k2 = i + 1; k2 < this.getChoicesSize(); ++k2) {
                                int[][] pk;
                                if (!nr.get(k2) || !U.equals(pi[1], (pk = (int[][])this.agperm.get(k2))[1])) continue;
                                nr.clear(k2);
                            }
                        }
                    }
                    if (!nr.get(i)) continue;
                    boolean bl = same2 = U.equals(pi[0], pj[0]) && U.equals(pi[2], pj[2]);
                    if (same2) {
                        if (!CleanArgs.doVerbose()) continue;
                        CleanArgs.verbose("frag2 same, skip check");
                        continue;
                    }
                    ss2.setIgnoreGeometryMatching(false, 0.1);
                    ss2.setQueryCoordinates(fc2);
                    ss2.setTargetCoordinates(fc2);
                    int[] fm2 = new int[fc2.length];
                    U.fill(fm2, -1);
                    for (k = 0; k < FragFragFuseBuildCommand.this.hp1and2In2.length; ++k) {
                        fm2[hpperm2[FragFragFuseBuildCommand.this.hp1and2In2[k]]] = hpperm2[FragFragFuseBuildCommand.this.hp1and2In2[k]];
                    }
                    for (k = 0; k < this.dim.getAaMapCount(); ++k) {
                        fm2[hpperm2[this.ag2In2[pi[2][k]]]] = hpperm2[this.ag2In2[pj[2][k]]];
                    }
                    for (k = 0; k < this.dim.getAd1MapCount(); ++k) {
                        fm2[hpperm2[this.ag2In2[pi[0][k]]]] = hpperm2[this.ag2In2[pj[0][k]]];
                    }
                    ss2.setFrozenMatch(fm2);
                    if (!ss2.findFirst()) continue;
                    if (CleanArgs.doVerbose()) {
                        CleanArgs.verbose("MATCH! Kill later equivalents");
                    }
                    nr.clear(i);
                    for (k = i + 1; k < this.getChoicesSize(); ++k) {
                        int[][] pk;
                        if (!nr.get(k) || !U.equals(pi[0], (pk = (int[][])this.agperm.get(k))[0]) || !U.equals(pi[2], pk[2])) continue;
                        nr.clear(k);
                    }
                }
            }
            if (debug != null) {
                debug.decLevel();
            }
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Return: " + U.sel(U.collectSets(nr)));
            }
            return U.collectSets(nr);
        }

        public int getChoicesSize() {
            return this.agperm.size();
        }

        public void permutateFinal(double[][] ac1, double[][] ac2, int[] srcPermA, int[] srcPermB, int[] targPermA, int[] targPermB) {
            double f;
            int j;
            int fbest;
            double fmin;
            boolean aap;
            boolean adp;
            int i;
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("<B>permutateFinal()</B>");
            }
            double[] b1 = ac1[targPermA[this.abIn1]];
            double[] b2 = ac2[targPermB[this.abIn2]];
            BitSet ag1assigned = new BitSet(this.ag1.length);
            for (int i2 = 0; i2 < this.ag1In1.length; ++i2) {
                if (!U.contains(targPermA, srcPermA[this.ag1In1[i2]])) continue;
                ag1assigned.set(i2);
            }
            BitSet ag2assigned = new BitSet(this.ag2.length);
            for (i = 0; i < this.ag2In2.length; ++i) {
                if (!U.contains(targPermB, srcPermB[this.ag2In2[i]])) continue;
                ag2assigned.set(i);
            }
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("ag1assigned: " + U.sel(U.collectSets(ag1assigned)) + " ag2assigned: " + U.sel(U.collectSets(ag2assigned)));
                CleanArgs.verbose("ad1MapCount=" + this.dim.getAd1MapCount() + " ad1.length=" + this.ad1.length + " ag1.length=" + this.ag1.length);
                CleanArgs.verbose("ad2MapCount=" + this.dim.getAd2MapCount() + " ad2.length=" + this.ad2.length + " ag2.length=" + this.ag2.length);
                CleanArgs.verbose("aaMapCount=" + this.dim.getAaMapCount() + " aa.length=" + this.aa.length);
            }
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Assign ad1 remaining");
            }
            for (i = 0; i < this.ad1.length; ++i) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("AD1#" + i + "=" + this.ad1In1[i] + " ag1assigned: " + U.sel(ag1assigned) + " ag2assigned: " + U.sel(ag2assigned));
                }
                adp = targPermA[this.ad1In1[i]] >= 0;
                boolean bl = aap = targPermB[this.ad1In2[i]] >= 0;
                if (adp && aap) {
                    if (!CleanArgs.doVerbose()) continue;
                    CleanArgs.verbose("Permutation assigned");
                    continue;
                }
                if (adp != aap) {
                    throw new UnsupportedOperationException("Consistency error");
                }
                double[] ad1i = ac1[srcPermA[this.ad1In1[i]]];
                fmin = -1.0;
                fbest = -1;
                for (j = 0; j < this.ag2In2.length; ++j) {
                    if (ag2assigned.get(j)) continue;
                    double[] ag2j = ac2[srcPermB[this.ag2In2[j]]];
                    f = M.sqr(V.angle(ad1i, b1, ag2j, b2));
                    if (fmin < 0.0 || f < fmin) {
                        fmin = f;
                        fbest = j;
                    }
                    if (!CleanArgs.doVerbose()) continue;
                    CleanArgs.verbose("anchor " + j + " f: " + f);
                }
                if (targPermA[this.ad1In1[i]] >= 0) {
                    throw new UnsupportedOperationException("Permutation overwriten");
                }
                if (targPermB[this.ad1In2[i]] >= 0) {
                    throw new UnsupportedOperationException("Permutation overwriten");
                }
                ag2assigned.set(fbest);
                targPermA[this.ad1In1[i]] = srcPermA[this.ad1In1[i]];
                targPermB[this.ad1In2[i]] = srcPermB[this.ag2In2[fbest]];
            }
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Assign ad2 remaining");
            }
            for (i = 0; i < this.ad2.length; ++i) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("AD2#" + i + "=" + this.ad2In2[i] + " ag1assigned: " + U.sel(ag1assigned) + " ag2assigned: " + U.sel(ag2assigned));
                }
                adp = targPermB[this.ad2In2[i]] >= 0;
                boolean bl = aap = targPermA[this.ad2In1[i]] >= 0;
                if (adp && aap) {
                    if (!CleanArgs.doVerbose()) continue;
                    CleanArgs.verbose("Permutation assigned");
                    continue;
                }
                if (adp != aap) {
                    throw new UnsupportedOperationException("Consistency error");
                }
                double[] ad2i = ac2[srcPermB[this.ad2In2[i]]];
                fmin = -1.0;
                fbest = -1;
                for (j = 0; j < this.ag1In1.length; ++j) {
                    if (ag1assigned.get(j)) continue;
                    double[] ag1j = ac1[srcPermA[this.ag1In1[j]]];
                    f = M.sqr(V.angle(ad2i, b2, ag1j, b1));
                    if (fmin < 0.0 || f < fmin) {
                        fmin = f;
                        fbest = j;
                    }
                    if (!CleanArgs.doVerbose()) continue;
                    CleanArgs.verbose("anchor " + j + " f: " + f);
                }
                if (targPermB[this.ad2In2[i]] >= 0) {
                    throw new UnsupportedOperationException("Permutation overwriten");
                }
                if (targPermA[this.ad2In1[i]] >= 0) {
                    throw new UnsupportedOperationException("Permutation overwriten");
                }
                ag1assigned.set(fbest);
                targPermB[this.ad2In2[i]] = srcPermB[this.ad2In2[i]];
                targPermA[this.ad2In1[i]] = srcPermA[this.ag1In1[fbest]];
            }
            for (i = 0; i < this.aa.length; ++i) {
                boolean a2m;
                int agitemIn1 = U.indexOf(this.ag1In1, this.aaIn1[i]);
                int agitemIn2 = U.indexOf(this.ag2In2, this.aaIn2[i]);
                boolean a1m = targPermA[this.ag1In1[agitemIn1]] >= 0;
                boolean bl = a2m = targPermB[this.ag2In2[agitemIn2]] >= 0;
                if (a1m && a2m) {
                    if (!CleanArgs.doVerbose()) continue;
                    CleanArgs.verbose("Permutation assigned");
                    continue;
                }
                if (a1m != a2m) {
                    throw new UnsupportedOperationException("Consistency error");
                }
                int a1i = ag1assigned.nextClearBit(0);
                double[] a1c = ac1[srcPermA[this.ag1In1[a1i]]];
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("AAmap i=" + i + " agitemIn1=" + agitemIn1 + " agitemIn2=" + agitemIn2 + " a1i=" + a1i, "ag1assigned: " + U.sel(ag1assigned) + " ag2assigned: " + U.sel(ag2assigned));
                }
                double fmin2 = -1.0;
                int fbest2 = -1;
                for (int j2 = 0; j2 < this.ag2.length; ++j2) {
                    if (ag2assigned.get(j2)) continue;
                    double[] ag2j = ac2[srcPermB[this.ag2In2[j2]]];
                    double f2 = M.sqr(V.angle(a1c, b1, ag2j, b2));
                    if (fmin2 < 0.0 || f2 < fmin2) {
                        fmin2 = f2;
                        fbest2 = j2;
                    }
                    if (!CleanArgs.doVerbose()) continue;
                    CleanArgs.verbose("anchor " + j2 + " f: " + f2);
                }
                ag1assigned.set(a1i);
                ag2assigned.set(fbest2);
                if (targPermA[this.ag1In1[agitemIn1]] >= 0) {
                    throw new UnsupportedOperationException("Permutation overwriten");
                }
                if (targPermB[this.ag2In2[agitemIn2]] >= 0) {
                    throw new UnsupportedOperationException("Permutation overwriten");
                }
                targPermA[this.ag1In1[agitemIn1]] = srcPermA[this.ag1In1[a1i]];
                targPermB[this.ag2In2[agitemIn2]] = srcPermB[this.ag2In2[fbest2]];
            }
        }

        public void permutate(int choice, int[] srcPermA, int[] srcPermB, int[] targPermA, int[] targPermB) {
            int i;
            int[][] p = (int[][])this.agperm.get(choice);
            for (i = 0; i < this.dim.getAd1MapCount(); ++i) {
                if (targPermB[this.ad1In2[i]] >= 0) {
                    throw new IndexOutOfBoundsException("Target permutation overwritten.");
                }
                if (targPermA[this.ad1In1[i]] >= 0) {
                    throw new IndexOutOfBoundsException("Target permutation overwritten.");
                }
                targPermA[this.ad1In1[i]] = srcPermA[this.ad1In1[i]];
                targPermB[this.ad1In2[i]] = srcPermB[this.ag2In2[p[0][i]]];
            }
            for (i = 0; i < this.dim.getAd2MapCount(); ++i) {
                if (targPermB[this.ad2In2[i]] >= 0) {
                    throw new IndexOutOfBoundsException("Target permutation overwritten.");
                }
                if (targPermA[this.ad2In1[i]] >= 0) {
                    throw new IndexOutOfBoundsException("Target permutation overwritten.");
                }
                targPermA[this.ad2In1[i]] = srcPermA[this.ag1In1[p[1][i]]];
                targPermB[this.ad2In2[i]] = srcPermB[this.ad2In2[i]];
            }
            for (i = 0; i < this.dim.getAaMapCount(); ++i) {
                if (targPermA[this.aaIn1[i]] >= 0) {
                    throw new IndexOutOfBoundsException("Target permutation overwritten.");
                }
                if (targPermB[this.aaIn2[i]] >= 0) {
                    throw new IndexOutOfBoundsException("Target permutation overwritten.");
                }
                targPermA[this.aaIn1[i]] = srcPermA[this.aaIn1[i]];
                targPermB[this.aaIn2[i]] = srcPermB[this.ag2In2[p[2][i]]];
            }
        }

        public PartialIndependentPair(int[] ag1, int[] ag2, int[] ad1, int[] ad2) {
            this.dim = new IPDimension(ag1, ag2, ad1, ad2);
            this.ad1 = FragFragFuseBuildCommand.this.builder1.getCommand().getAtoms(ad1);
            this.ad1In1 = FragFragFuseBuildCommand.this.builder1.getCommand().getAtomsInv(this.ad1);
            this.ad1In2 = FragFragFuseBuildCommand.this.builder2.getCommand().getAtomsInv(this.ad1);
            this.ad2 = FragFragFuseBuildCommand.this.builder2.getCommand().getAtoms(ad2);
            this.ad2In1 = FragFragFuseBuildCommand.this.builder1.getCommand().getAtomsInv(this.ad2);
            this.ad2In2 = FragFragFuseBuildCommand.this.builder2.getCommand().getAtomsInv(this.ad2);
            this.ag1 = FragFragFuseBuildCommand.this.builder1.getCommand().getAtoms(ag1);
            this.ag1In1 = FragFragFuseBuildCommand.this.builder1.getCommand().getAtomsInv(this.ag1);
            this.ag2 = FragFragFuseBuildCommand.this.builder2.getCommand().getAtoms(ag2);
            this.ag2In2 = FragFragFuseBuildCommand.this.builder2.getCommand().getAtomsInv(this.ag2);
            this.aa = U.remove(this.ag1, this.ad2);
            this.aaIn1 = FragFragFuseBuildCommand.this.builder1.getCommand().getAtomsInv(this.aa);
            this.aaIn2 = FragFragFuseBuildCommand.this.builder2.getCommand().getAtomsInv(this.aa);
            this.ab = this.ag1In1.length > 0 ? FragFragFuseBuildCommand.this.builder1.getCommand().getAnchorBase(this.ag1[0]) : FragFragFuseBuildCommand.this.builder2.getCommand().getAnchorBase(this.ag2[0]);
            this.abIn1 = FragFragFuseBuildCommand.this.builder1.getCommand().getAtomsInv(this.ab);
            this.abIn2 = FragFragFuseBuildCommand.this.builder2.getCommand().getAtomsInv(this.ab);
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("new ParitalIndependentPair()", "ag1param: " + U.sel(ag1) + "<BR>" + "ag2param: " + U.sel(ag2) + "<BR>" + "ad1param: " + U.sel(ad1) + "<BR>" + "ad2param: " + U.sel(ad2) + "<BR>" + "ad1:      " + U.sel(this.ad1) + "<BR>" + "ad1In1:   " + U.sel(this.ad1In1) + "<BR>" + "ad1In2:   " + U.sel(this.ad1In2) + "<BR>" + "ad2:      " + U.sel(this.ad2) + "<BR>" + "ad2In1:   " + U.sel(this.ad2In1) + "<BR>" + "ad2In2:   " + U.sel(this.ad2In2) + "<BR>" + "ag1:      " + U.sel(this.ag1) + "<BR>" + "ag1In1:   " + U.sel(this.ag1In1) + "<BR>" + "ag2:      " + U.sel(this.ag2) + "<BR>" + "ag2In2:   " + U.sel(this.ag2In2) + "<BR>" + "aa:       " + U.sel(this.aa) + "<BR>" + "aaIn1:    " + U.sel(this.aaIn1) + "<BR>" + "aaIn2:    " + U.sel(this.aaIn2) + "<BR>" + "ab:       " + this.ab + "<BR>" + "abIn1:    " + this.abIn1 + "<BR>" + "abIn2:    " + this.abIn2);
            }
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("aaMapCount: " + this.dim.getAaMapCount() + "<BR>" + "ad1MapCount: " + this.dim.getAd1MapCount() + "<BR>" + "ad2MapCount: " + this.dim.getAd2MapCount() + "<BR>");
            }
            int[] ad1map = new int[this.dim.getAd1MapCount()];
            int[] ad2map = new int[this.dim.getAd2MapCount()];
            int[] aamap = new int[this.dim.getAaMapCount()];
            int[][] maps = new int[][]{ad1map, ad2map, aamap};
            int[] maplengths = new int[]{ag2.length, ag1.length, this.aa.length};
            int arrp = 0;
            int itemp = 0;
            while (maps[arrp].length == 0) {
                ++arrp;
            }
            this.agperm = new Vector();
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Fill permutations");
            }
            boolean detailedVerbose = false;
            while (true) {
                if (CleanArgs.doVerbose() && detailedVerbose) {
                    CleanArgs.verbose("Loop start arrp: " + arrp + " itemp: " + itemp, "maps: " + U.toString(maps) + "<BR>" + "maplengths: " + U.sel(maplengths));
                }
                boolean valid = true;
                boolean stepBack = false;
                boolean increment = false;
                if (maps[arrp][itemp] >= maplengths[arrp]) {
                    stepBack = true;
                    increment = true;
                    valid = false;
                } else {
                    int i;
                    for (i = 0; i < itemp; ++i) {
                        if (maps[arrp][i] != maps[arrp][itemp]) continue;
                        increment = true;
                        valid = false;
                    }
                    if (arrp == 2) {
                        for (i = 0; i < maps[0].length; ++i) {
                            if (maps[0][i] != maps[arrp][itemp]) continue;
                            increment = true;
                            valid = false;
                        }
                    }
                }
                if (CleanArgs.doVerbose() && detailedVerbose) {
                    CleanArgs.verbose("arrp:itemp=" + arrp + ":" + itemp + " incr: " + increment + " stepb: " + stepBack + " valid: " + valid + " maps: " + U.toString(maps) + " maplens: " + U.sel(maplengths));
                }
                if (stepBack) {
                    if (--itemp < 0) {
                        while (--arrp >= 0 && maps[arrp].length == 0) {
                        }
                        if (arrp >= 0) {
                            itemp = maps[arrp].length - 1;
                        }
                    }
                    if (arrp < 0) break;
                }
                if (increment) {
                    int[] nArray = maps[arrp];
                    int n = itemp;
                    nArray[n] = nArray[n] + 1;
                    continue;
                }
                if (!valid) {
                    throw new UnsupportedOperationException("Error filling permutation vector");
                }
                if (++itemp < maps[arrp].length) {
                    maps[arrp][itemp] = 0;
                } else {
                    while (++arrp < maps.length && maps[arrp].length == 0) {
                    }
                    if (arrp < maps.length) {
                        itemp = 0;
                        maps[arrp][itemp] = 0;
                    }
                }
                if (arrp < maps.length) continue;
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("Valid permutation: " + U.toString(maps));
                }
                this.agperm.add(U.clone(maps));
                arrp = maps.length;
                while (--arrp > 0 && maps[arrp].length == 0) {
                }
                itemp = maps[arrp].length - 1;
                int[] nArray = maps[arrp];
                int n = itemp;
                nArray[n] = nArray[n] + 1;
                if (!CleanArgs.doVerbose() || !detailedVerbose) continue;
                CleanArgs.verbose("incremented");
            }
        }
    }
}

