/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.build;

import chemaxon.core.util.BondTable;
import chemaxon.marvin.modelling.build.FragmentMine;
import chemaxon.marvin.modelling.debug.ErrPrint;
import chemaxon.marvin.modelling.struc.ConformersDescriptor;
import chemaxon.marvin.modelling.struc.myMolecule;
import chemaxon.struc.Molecule;
import java.io.File;
import java.util.BitSet;
import java.util.Vector;

public class FragmentDistributor {
    String CXLib = FragmentDistributor.getChemaxonLib();
    public final String fragmentPath = this.CXLib + File.separator + "fragments";
    String centerPath = this.CXLib + File.separator + "fragments" + File.separator + "centers";
    String ringPath = this.CXLib + File.separator + "fragments" + File.separator + "rings";
    String chainPath = this.CXLib + File.separator + "fragments" + File.separator + "chains";
    public Vector targetVec = null;
    Vector[] fragIndexVec = null;
    BitSet[] atomInFrag = null;
    Vector retVec = null;
    public static FragmentMine fragmentMine = null;
    public Molecule m = null;
    public myMolecule myM = null;
    public int[][] cTab = null;
    public BondTable bTab = null;
    long lastTime;
    boolean molDump = false;
    boolean collectFragments = false;

    public FragmentDistributor(Molecule mol) {
        this.init(mol);
    }

    public FragmentDistributor(Molecule mol, boolean store) {
        this.collectFragments = store;
        this.init(mol);
    }

    public FragmentDistributor(myMolecule myMol) {
        this.myM = myMol;
        this.init(this.myM.getOriginalMolCopy());
    }

    public FragmentDistributor(myMolecule myMol, boolean store) {
        this.collectFragments = store;
        this.myM = myMol;
        this.init(this.myM.getOriginalMolCopy());
    }

    void init(Molecule mol) {
        this.lastTime = System.currentTimeMillis();
        boolean doInit = false;
        this.m = mol.cloneMolecule();
        this.cTab = this.m.getCtab();
        this.bTab = this.m.getBondTable();
        if (fragmentMine == null) {
            doInit = true;
            System.err.println("Common fragments read in Distributor initialization from " + this.fragmentPath);
            fragmentMine = new FragmentMine(this.fragmentPath);
            System.err.println("Total number of fragments is:" + FragmentDistributor.fragmentMine.fragVec.size());
        }
        if (doInit) {
            System.err.println("FragmentDistributor initialization done in " + (System.currentTimeMillis() - this.lastTime) + " ms.");
        }
    }

    void addToTarget(FragmentMine.SearchTarget sTarget) {
        boolean found = false;
        for (int i = 0; i < this.targetVec.size(); ++i) {
            FragmentMine.SearchTarget target = (FragmentMine.SearchTarget)this.targetVec.elementAt(i);
            if (target.match != sTarget.match) continue;
            target.matchVec.addElement(sTarget.matchList);
            found = true;
        }
        if (!found) {
            sTarget.matchVec = new Vector();
            sTarget.matchVec.addElement(sTarget.matchList);
            this.targetVec.addElement(sTarget);
        }
    }

    void fillAtomFlags(int index, FragmentMine.SearchTarget target) {
        for (int iT = 0; iT < target.matchVec.size(); ++iT) {
            int[] matchList = (int[])target.matchVec.elementAt(iT);
            for (int i = 0; i < matchList.length; ++i) {
                int iAtom = matchList[i];
                if (iAtom < 0) continue;
                int[] fragInd = new int[]{index, i};
                this.fragIndexVec[iAtom].addElement(fragInd);
                this.atomInFrag[iAtom].set(index);
            }
        }
    }

    public void findFragments() {
        int i;
        int i2;
        System.err.println("Enter findFragments.");
        this.lastTime = System.currentTimeMillis();
        this.targetVec = new Vector();
        this.fragIndexVec = new Vector[this.m.getAtomCount()];
        this.atomInFrag = new BitSet[this.m.getAtomCount()];
        for (i2 = 0; i2 < this.m.getAtomCount(); ++i2) {
            this.fragIndexVec[i2] = new Vector();
            this.atomInFrag[i2] = new BitSet();
        }
        for (i2 = 0; i2 < this.m.getAtomCount(); ++i2) {
            if (this.cTab[i2].length <= 4) continue;
            FragmentMine.SearchTarget target = fragmentMine.findFragment(this.m, new int[]{i2});
            if (target != null && target.match.mol.getDim() == 3) {
                this.addToTarget(target);
                continue;
            }
            if (!this.collectFragments || target != null) continue;
            fragmentMine.addFragment(this.m, new int[]{i2});
            target = fragmentMine.findFragment(this.m, new int[]{i2});
            if (target == null) {
                System.err.println("FragmentMine (center) error.");
                continue;
            }
            if (target.match.mol.getDim() != 3) continue;
            this.addToTarget(target);
        }
        System.err.println("Geting SSSR.");
        int[][] rSSSR = this.m.getSSSR();
        for (i = 0; i < rSSSR.length; ++i) {
            FragmentMine.SearchTarget target = fragmentMine.findFragment(this.m, rSSSR[i]);
            if (this.collectFragments && target == null && rSSSR[i].length < 8) {
                if (fragmentMine.addFragment(this.m, rSSSR[i])) {
                    target = fragmentMine.findFragment(this.m, rSSSR[i]);
                } else {
                    System.err.println("FragmentMine consistency error.");
                }
                if (target == null) {
                    System.err.println("FragmentMine (ring) error.");
                }
            }
            if (target == null) continue;
            if (this.molDump) {
                ErrPrint.errPrint("Next fragment:", target.match.mol);
                ErrPrint.errPrintAtomList("SSSR:", rSSSR[i]);
                ErrPrint.errPrintAtomList("matchList:", target.matchList);
            }
            this.addToTarget(target);
        }
        for (i = 0; i < this.targetVec.size(); ++i) {
            this.fillAtomFlags(i, (FragmentMine.SearchTarget)this.targetVec.elementAt(i));
        }
        System.err.println("FragmentDistributor.FindFragments done in " + (System.currentTimeMillis() - this.lastTime) + " ms.");
    }

    public Vector retrieveFragments() {
        if (this.retVec != null) {
            return this.retVec;
        }
        if (this.targetVec == null) {
            this.findFragments();
        }
        this.lastTime = System.currentTimeMillis();
        Molecule mol = this.m;
        if (this.molDump) {
            ErrPrint.errPrint("Original molecule:", mol);
        }
        int[][] molCTab = this.cTab;
        this.retVec = new Vector();
        for (int i = 0; i < this.targetVec.size(); ++i) {
            int j;
            FragmentMine.SearchTarget sTarget = (FragmentMine.SearchTarget)this.targetVec.elementAt(i);
            Molecule frag = sTarget.match.mol;
            if (this.molDump) {
                ErrPrint.errPrint("Fragment #" + i + ":", frag);
            }
            if (frag.getDim() != 3) continue;
            ConformersDescriptor cD = (ConformersDescriptor)frag.properties().get("Clean3DConformersDescriptor");
            double[][][] c0 = cD.getCoords();
            double[][][] coords = new double[c0[0].length][c0.length][3];
            for (int ii = 0; ii < c0[0].length; ++ii) {
                for (j = 0; j < c0.length; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        coords[ii][j][k] = c0[j][ii][k];
                    }
                }
            }
            int[][] fragCTab = frag.getCtab();
            for (j = 0; j < sTarget.matchVec.size(); ++j) {
                int k;
                int[] atomL = (int[])sTarget.matchVec.elementAt(j);
                int[] atomList = (int[])atomL.clone();
                int commonCount = 0;
                for (int k2 = 0; k2 < atomList.length; ++k2) {
                    if (atomList[k2] < 0) continue;
                    ++commonCount;
                }
                int[] commonList = new int[commonCount];
                int anchorCount = atomList.length - commonCount;
                int[] anchorList = new int[anchorCount];
                BitSet fragCommon = new BitSet(frag.getAtomCount());
                BitSet molCommon = new BitSet(mol.getAtomCount());
                commonCount = 0;
                for (k = 0; k < atomList.length; ++k) {
                    if (atomList[k] < 0) continue;
                    commonList[commonCount] = atomList[k];
                    fragCommon.set(k);
                    molCommon.set(atomList[k]);
                    ++commonCount;
                }
                anchorCount = 0;
                for (k = 0; k < atomL.length; ++k) {
                    if (atomL[k] < 0) continue;
                    int[] molList = molCTab[atomList[k]];
                    int[] fragList = fragCTab[k];
                    int mI = 0;
                    int fI = 0;
                    while (mI < molList.length && fI < fragList.length) {
                        while (mI < molList.length && molCommon.get(molList[mI])) {
                            if (!molCommon.get(molList[mI])) continue;
                            ++mI;
                        }
                        while (fI < fragList.length && fragCommon.get(fragList[fI])) {
                            if (!fragCommon.get(fragList[fI])) continue;
                            ++fI;
                        }
                        if (fI < fragList.length && mI < molList.length) {
                            int fAt = fragList[fI];
                            int mAt = molList[mI];
                            fragCommon.set(fAt);
                            molCommon.set(mAt);
                            atomList[fAt] = mAt;
                            anchorList[anchorCount] = mAt;
                            ++anchorCount;
                            ++fI;
                            ++mI;
                            continue;
                        }
                        if ((fI < fragList.length || mI >= molList.length || molCommon.get(molList[mI])) && (fI >= fragList.length || mI < molList.length || fragCommon.get(fragList[fI]))) continue;
                        System.err.println("Error: Fragment/molecule mismatch in FragmentDistributor:");
                        System.err.println("fragList: " + fI);
                        ErrPrint.errPrintAtomList(fragList);
                        System.err.println("molList: " + mI);
                        ErrPrint.errPrintAtomList(molList);
                        ErrPrint.errPrint("Fragment:", frag);
                        ErrPrint.errPrint("Molecule:", mol);
                        ++fI;
                        ++mI;
                        throw new UnsupportedOperationException("makeTarget");
                    }
                }
            }
        }
        System.err.println("FragmentDistributor.retrieveFragments done in " + (System.currentTimeMillis() - this.lastTime) + " ms.");
        throw new UnsupportedOperationException();
    }

    static String getChemaxonLib() {
        String home = System.getProperty("user.home");
        String fsep = File.separator;
        if (fsep.equals("/")) {
            return home + fsep + ".chemaxon" + fsep + "lib";
        }
        return home + fsep + "chemaxon" + fsep + "lib";
    }
}

