/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.build;

import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.CleanSettings;
import chemaxon.marvin.modelling.build.BuildCommand;
import chemaxon.marvin.modelling.build.BuildCommandBase;
import chemaxon.marvin.modelling.build.BuildSequence;
import chemaxon.marvin.modelling.build.FragmentDistributor;
import chemaxon.marvin.modelling.debug.Printouts;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.struc.StereoCriteriaList;
import chemaxon.marvin.modelling.struc.myMolecule;
import chemaxon.marvin.modelling.util.U;
import java.util.Vector;

public class FragmentLookup {
    Vector availables = null;
    myMolecule mol = null;
    StereoCriteriaList stereo = null;
    public FragmentDistributor fD = null;
    public static boolean storeNewFragments = false;
    debugPrintout debug = null;

    void lookSSSR() {
        if (this.debug != null) {
            this.debug.printBC("Look for SSSR rings");
        }
        int[][] SSSR2 = this.mol.SSSR;
        for (int rno = 0; rno < SSSR2.length; ++rno) {
            if (this.debug == null) continue;
            this.debug.println("Checking SSSR ring " + rno);
            this.mol.placeApplet("Ring atoms", U.sel(SSSR2[rno]));
        }
    }

    public FragmentLookup(myMolecule mol, boolean store) {
        throw new UnsupportedOperationException("unsupported FragmentLookup constructor");
    }

    public FragmentLookup(myMolecule mol, StereoCriteriaList stereo, CleanSettings settings) {
        long t0 = System.currentTimeMillis();
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("FragmentLookup initialization");
        }
        this.mol = mol;
        this.stereo = stereo;
        this.debug = CleanArgs.getDebug();
        if (this.debug != null) {
            this.debug.incLevel("Fragment lookup");
            mol.placeApplet("Structure");
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Check for biphenyl bridge");
        }
        for (int i = 0; i < mol.b; ++i) {
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("check bond " + i);
            }
            FragmentRetriever b = null;
            if (FragmentRetriever.checkBiphenylBridge(mol, i)) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("Construct biphenyl bridge");
                }
                if ((b = FragmentRetriever.constructBiphenylBridge(mol, stereo, settings, i)) != null) {
                    if (this.availables == null) {
                        this.availables = new Vector();
                    }
                    this.availables.add(b);
                }
            }
            if (b != null || !FragmentRetriever.checkSP2SP2(mol, false, i)) continue;
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Construct nrsp2sp2 bridge");
            }
            if ((b = FragmentRetriever.constructNRSP2SP2(mol, stereo, settings, i, 2)) == null) continue;
            if (this.availables == null) {
                this.availables = new Vector();
            }
            this.availables.add(b);
        }
        long t1 = System.currentTimeMillis();
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("FragmentLookup initialization was done in " + (t1 - t0) + " ms.");
        }
        if (this.debug != null) {
            this.debug.decLevel();
        }
    }

    public Vector getAvailables() {
        if (this.availables == null) {
            this.availables = new Vector();
        }
        return this.availables;
    }

    public static class FragmentRetriever
    extends BuildCommand {
        double[][][] coords = null;
        int[] atomlist;
        myMolecule mol;
        BuildSequence.Build cmd = null;
        boolean reported = false;
        public static final int NRSP2SP2TYPE_PLANARONLY = 1;
        public static final int NRSP2SP2TYPE_PLANAR_TWISTED = 2;
        public static final int NRSP2SP2TYPE_TWISTEDONLY = 3;

        @Override
        public void initProgressMonitor() {
        }

        @Override
        myMolecule getOrigMol() {
            return this.mol;
        }

        @Override
        BuildSequence.Build getCommand() {
            return this.cmd;
        }

        @Override
        int invokeBuild(int expectedConformers, BuildCommandBase.BuildEffort effort) {
            if (this.reported) {
                return 2;
            }
            this.reported = true;
            debugPrintout debug = CleanArgs.getDebug();
            if (debug != null) {
                debug.println("Fragment retrieve");
                if (this.mol != null) {
                    Printouts.place3DApplet("Retrieved fragment", this.mol.getOriginalMolCopy(), this.atomlist, this.coords);
                }
            }
            this.registerCoordinates(this.coords);
            return 1;
        }

        @Override
        boolean hasDirectBuildChildFailed() {
            return false;
        }

        public static boolean checkSP2SP2(myMolecule mol, boolean ringEnabled, int bi) {
            if (mol.getBondOrder(bi) != 2) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("!Single");
                }
                return false;
            }
            int ba1 = mol.bat[0][bi];
            int ba2 = mol.bat[1][bi];
            if (!mol.isHybSP2(ba1) || !mol.isHybSP2(ba2)) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("!SP2SP2");
                }
                return false;
            }
            if (mol.ctab[ba1].length != 3 || mol.ctab[ba2].length != 3) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("!3-3 ligands");
                }
                return false;
            }
            if (!ringEnabled || mol.bondToRing[bi].length != 0) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("Ringbond");
                }
                return false;
            }
            return true;
        }

        public static boolean checkPeptideBond() {
            return false;
        }

        public static boolean checkBiphenylBridge(myMolecule mol, int bi) {
            if (mol.getBondOrder(bi) != 2) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("!Single");
                }
                return false;
            }
            int ba1 = mol.bat[0][bi];
            int ba2 = mol.bat[1][bi];
            if (mol.anum[ba1] != 6 && mol.anum[ba1] != 7 || mol.anum[ba2] != 6 && mol.anum[ba2] != 7) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("!CC/CN/NN");
                }
                return false;
            }
            if (mol.ctab[ba1].length != 3 || mol.ctab[ba2].length != 3) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("!3-3 ligands");
                }
                return false;
            }
            int arct1 = 0;
            int arct2 = 0;
            for (int j = 0; j < 3; ++j) {
                if (mol.getBondOrder(mol.blist[ba1][j]) == 3) {
                    ++arct1;
                }
                if (mol.getBondOrder(mol.blist[ba2][j]) != 3) continue;
                ++arct2;
            }
            if (arct1 != 2 || arct2 != 2) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("No 2-2 aromatic bonds");
                }
                return false;
            }
            return true;
        }

        public static FragmentRetriever constructBiphenylBridge(myMolecule mol, StereoCriteriaList stereo, CleanSettings settings, int bi) {
            int[] cml = new int[]{mol.bat[0][bi], mol.bat[1][bi]};
            if (U.hasCommon(cml)) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("ConstructBridge: cml has common: " + U.sel(cml));
                }
                return null;
            }
            int[] anl = U.append(U.removeByValue(mol.ctab[cml[0]], cml[1]), U.removeByValue(mol.ctab[cml[1]], cml[0]));
            if (U.hasCommon(anl) || U.hasCommon(cml, anl)) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("ConstructBridge: anl/cml has common: " + U.sel(anl) + "/" + U.sel(cml));
                }
                return null;
            }
            int[] atl = U.append(cml, anl);
            int atno1 = mol.anum[mol.bat[0][bi]];
            int atno2 = mol.anum[mol.bat[1][bi]];
            double cc = 1.42;
            if (atno1 == 7 && atno2 == 6) {
                cc = 1.36;
            }
            if (atno1 == 6 && atno2 == 7) {
                cc = 1.36;
            }
            if (atno1 == 7 && atno2 == 7) {
                cc = 1.31;
            }
            double ch = 1.02;
            double fi = 0.5235987755982988;
            double cos60 = Math.cos(1.0471975511965976);
            double sin60 = Math.sin(1.0471975511965976);
            double cosfi = Math.cos(fi);
            double sinfi = Math.sin(fi);
            double[][][] c = new double[2][6][3];
            c[0][0][0] = 0.0;
            c[0][0][1] = 0.0;
            c[0][0][2] = 0.0;
            c[0][1][0] = cc;
            c[0][1][1] = 0.0;
            c[0][1][2] = 0.0;
            c[0][2][0] = -cos60 * ch;
            c[0][2][1] = cosfi * sin60 * ch;
            c[0][2][2] = sinfi * sin60 * ch;
            c[0][3][0] = -cos60 * ch;
            c[0][3][1] = -cosfi * sin60 * ch;
            c[0][3][2] = -sinfi * sin60 * ch;
            c[0][4][0] = cc + cos60 * ch;
            c[0][4][1] = cosfi * sin60 * ch;
            c[0][4][2] = -sinfi * sin60 * ch;
            c[0][5][0] = cc + cos60 * ch;
            c[0][5][1] = -cosfi * sin60 * ch;
            c[0][5][2] = sinfi * sin60 * ch;
            c[1][0][0] = 0.0;
            c[1][0][1] = 0.0;
            c[1][0][2] = 0.0;
            c[1][1][0] = cc;
            c[1][1][1] = 0.0;
            c[1][1][2] = 0.0;
            c[1][2][0] = -cos60 * ch;
            c[1][2][1] = cosfi * sin60 * ch;
            c[1][2][2] = -sinfi * sin60 * ch;
            c[1][3][0] = -cos60 * ch;
            c[1][3][1] = -cosfi * sin60 * ch;
            c[1][3][2] = sinfi * sin60 * ch;
            c[1][4][0] = cc + cos60 * ch;
            c[1][4][1] = cosfi * sin60 * ch;
            c[1][4][2] = sinfi * sin60 * ch;
            c[1][5][0] = cc + cos60 * ch;
            c[1][5][1] = -cosfi * sin60 * ch;
            c[1][5][2] = -sinfi * sin60 * ch;
            return new FragmentRetriever(mol, stereo, settings, atl, anl, cml, c);
        }

        public static FragmentRetriever constructNRSP2SP2(myMolecule mol, StereoCriteriaList stereo, CleanSettings settings, int bi, int nrsp2sp2type) {
            int[] cml = new int[]{mol.bat[0][bi], mol.bat[1][bi]};
            if (U.hasCommon(cml)) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("ConstructBridge: cml has common: " + U.sel(cml));
                }
                return null;
            }
            int[] anl = U.append(U.removeByValue(mol.ctab[cml[0]], cml[1]), U.removeByValue(mol.ctab[cml[1]], cml[0]));
            if (U.hasCommon(anl) || U.hasCommon(cml, anl)) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("ConstructBridge: anl/cml has common: " + U.sel(anl) + "/" + U.sel(cml));
                }
                return null;
            }
            int[] atl = U.append(cml, anl);
            double cc = mol.blen[bi];
            double ch = 1.02;
            double fi = 0.08726646259971647;
            double cos60 = Math.cos(1.0471975511965976);
            double sin60 = Math.sin(1.0471975511965976);
            double cosfi = Math.cos(fi);
            double sinfi = Math.sin(fi);
            double[][][] c = new double[3][6][3];
            switch (nrsp2sp2type) {
                case 1: {
                    c = new double[1][6][3];
                    break;
                }
                case 3: {
                    c = new double[2][6][3];
                    break;
                }
                case 2: {
                    c = new double[3][6][3];
                }
            }
            int i = 0;
            if (nrsp2sp2type == 2 || nrsp2sp2type == 3) {
                c[i][0][0] = 0.0;
                c[i][0][1] = 0.0;
                c[i][0][2] = 0.0;
                c[i][1][0] = cc;
                c[i][1][1] = 0.0;
                c[i][1][2] = 0.0;
                c[i][2][0] = -cos60 * ch;
                c[i][2][1] = cosfi * sin60 * ch;
                c[i][2][2] = -sinfi * sin60 * ch;
                c[i][3][0] = -cos60 * ch;
                c[i][3][1] = -cosfi * sin60 * ch;
                c[i][3][2] = sinfi * sin60 * ch;
                c[i][4][0] = cc + cos60 * ch;
                c[i][4][1] = cosfi * sin60 * ch;
                c[i][4][2] = sinfi * sin60 * ch;
                c[i][5][0] = cc + cos60 * ch;
                c[i][5][1] = -cosfi * sin60 * ch;
                c[i][5][2] = -sinfi * sin60 * ch;
                c[++i][0][0] = 0.0;
                c[i][0][1] = 0.0;
                c[i][0][2] = 0.0;
                c[i][1][0] = cc;
                c[i][1][1] = 0.0;
                c[i][1][2] = 0.0;
                c[i][2][0] = -cos60 * ch;
                c[i][2][1] = cosfi * sin60 * ch;
                c[i][2][2] = sinfi * sin60 * ch;
                c[i][3][0] = -cos60 * ch;
                c[i][3][1] = -cosfi * sin60 * ch;
                c[i][3][2] = -sinfi * sin60 * ch;
                c[i][4][0] = cc + cos60 * ch;
                c[i][4][1] = cosfi * sin60 * ch;
                c[i][4][2] = -sinfi * sin60 * ch;
                c[i][5][0] = cc + cos60 * ch;
                c[i][5][1] = -cosfi * sin60 * ch;
                c[i][5][2] = sinfi * sin60 * ch;
                ++i;
            }
            if (nrsp2sp2type == 2 || nrsp2sp2type == 3) {
                c[i][0][0] = 0.0;
                c[i][0][1] = 0.0;
                c[i][0][2] = 0.0;
                c[i][1][0] = cc;
                c[i][1][1] = 0.0;
                c[i][1][2] = 0.0;
                c[i][2][0] = -cos60 * ch;
                c[i][2][1] = sin60 * ch;
                c[i][2][2] = 0.0;
                c[i][3][0] = -cos60 * ch;
                c[i][3][1] = -sin60 * ch;
                c[i][3][2] = 0.0;
                c[i][4][0] = cc + cos60 * ch;
                c[i][4][1] = sin60 * ch;
                c[i][4][2] = 0.0;
                c[i][5][0] = cc + cos60 * ch;
                c[i][5][1] = -sin60 * ch;
                c[i][5][2] = 0.0;
                ++i;
            }
            return new FragmentRetriever(mol, stereo, settings, atl, anl, cml, c);
        }

        public FragmentRetriever(myMolecule mol, StereoCriteriaList stereo, CleanSettings settings, int[] atomlist, int[] anchorlist, int[] commonlist, double[][][] coordinates) {
            super(settings);
            this.mol = mol;
            this.atomlist = atomlist;
            this.coords = coordinates;
            this.cmd = new BuildSequence.SimpleBuild(atomlist, anchorlist, commonlist, mol, stereo);
        }
    }
}

