/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.build;

import chemaxon.calculations.clean.Clean3D;
import chemaxon.calculations.clean.DistanceMatrixCalculator;
import chemaxon.calculations.clean.Opt3D;
import chemaxon.calculations.clean.Optimization;
import chemaxon.core.util.BondTable;
import chemaxon.marvin.modelling.CleanSettings;
import chemaxon.marvin.modelling.TextUtils;
import chemaxon.marvin.modelling.build.fafuse.FragmentStore;
import chemaxon.marvin.modelling.build.fafuse.FuseCommandSequence;
import chemaxon.marvin.modelling.debug.VerbosePrinter;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.linalg.JacobiTransformation;
import chemaxon.marvin.modelling.linalg.M;
import chemaxon.marvin.modelling.linalg.Matrix;
import chemaxon.marvin.modelling.linalg.V;
import chemaxon.marvin.modelling.linalg.multiDim;
import chemaxon.marvin.modelling.linalg.subSpace;
import chemaxon.marvin.modelling.struc.myMolecule;
import chemaxon.marvin.modelling.util.ProgressMonitor;
import chemaxon.marvin.modelling.util.Stopper;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.SelectionMolecule;
import java.io.FileWriter;
import java.util.BitSet;

public class MinkowskiBuilder {
    int OPT_TO_USE = 48;
    public static final int SINGLE = 1;
    public static final int DOUBLE = 2;
    public static final int TRIPLE = 3;
    boolean disableDevelFeatures = false;
    boolean DOCLEANFORNON3D = false;
    static final int AROMATIC = 4;
    static final int SINGLE_OR_AROMATIC = 6;
    static final int DOUBLE_OR_AROMATIC = 7;
    static final int SINGLE_OR_DOUBLE = 5;
    static final int CIS = 128;
    static final int TRANS = 64;
    static final int STEREO_MASK = 1008;
    static final int PARITY_EVEN = 2;
    static final int PARITY_ODD = 1;
    static final int PARITY_MASK = 7;
    static final int PARITY_UNSPEC = 4;
    public static final double LINEAR = Math.PI;
    public static final double TRIGONAL = 2.0943951023931953;
    public static final double TETRAHEDRAL = 1.9106119;
    public static final double TRIGONAL_BIPYRAMIDAL_1 = 1.5707963267948966;
    public static final double TRIGONAL_BIPYRAMIDAL_2 = 2.0943951023931953;
    public static final double TRIGONAL_BIPYRAMIDAL_3 = Math.PI;
    public static final double OCTAHEDRAL_1 = 1.5707963267948966;
    public static final double OCTAHEDRAL_2 = Math.PI;
    SelectionMolecule molfrag;
    boolean OPT_DREIDING_MINKOWSKI = false;
    public static double MINEXT = 0.01;
    int PSEQGENSTRAT = 1;
    boolean MERGETOBUILDMOL = false;
    static double EPS = 1.0E-4;
    static final double EPSSQRT = 0.01;
    static final double EPSMETRIDCHECK = 0.01;
    static final double MINMET = 1.0;
    static final double MINORTHOGONALCANDIDATE = 0.2;
    static final double MIND2RES = 1.0;
    static final double SINGULARTRANS = 2.0;
    boolean DOOPTIMIZE = true;
    boolean SKIPFINALOPT = false;
    boolean KILLOVERDIM = false;
    boolean DOPARTIALOPT = true;
    boolean DOREARRANGE = true;
    boolean preoptAnytime = true;
    boolean NEWREFINE = false;
    boolean performanceLog = false;
    debugPrintout debug = null;
    double[][][] M;
    int pmonmax = 0;
    int pmonact = 0;

    public MinkowskiBuilder(debugPrintout debug, SelectionMolecule molfrag, int OPT_TO_USE, boolean disableDevelFeatures) {
        this.debug = debug;
        this.molfrag = molfrag;
        this.OPT_TO_USE = OPT_TO_USE;
        this.disableDevelFeatures = disableDevelFeatures;
    }

    double[][][] makeCoords(double[][] dMatrix, double[][] dMatrixFlags, BitSet[] distA, BondTable btab, int[][] ctab, SelectionMolecule molecule, ProgressMonitor pmon) {
        this.debug.setLevel(0);
        this.debug.println("makeCoords() invoked.");
        int nodes = dMatrix.length + 1;
        double[][] dmat = new double[nodes][nodes];
        double[][] dmatf = new double[nodes][nodes];
        this.debug.println("Total nodes: " + nodes);
        for (int i = 0; i < dMatrix.length; ++i) {
            for (int j = 0; j < dMatrix[i].length; ++j) {
                if (dMatrix[i][j] == 0.0) continue;
                this.setDistance(dmat, i, i + j + 1, dMatrix[i][j]);
                dmatf[i][i + j + 1] = dMatrixFlags[i][j];
                dmatf[i + j + 1][i] = dMatrixFlags[i][j];
            }
        }
        this.debug.incLevel("Given distance square matrix");
        this.debug.printMatrix(dmat);
        this.debug.decLevel();
        this.debug.incLevel("Given distance square matrix flags");
        this.debug.printMatrix(dmatf);
        this.debug.decLevel();
        multiDim system = new multiDim(nodes, 3 * nodes);
        system.addDim();
        system.n = nodes;
        subSpace subBaseSystem = new subSpace(system);
        int[] flag = new int[nodes];
        for (int i = 0; i < nodes; ++i) {
            flag[i] = -1;
        }
        coordGen cg0 = new coordGen(molecule, dmat, dmatf, system, flag);
        switch (this.PSEQGENSTRAT) {
            case 1: {
                cg0.generateSequence3();
                break;
            }
            case 0: {
                cg0.generateSequenceBasic(distA);
            }
        }
        int[] stepToNode = cg0.stepToNode;
        int[] nodeToStep = cg0.nodeToStep;
        boolean[] partialOptCanDo = cg0.partialFlag;
        if (nodes > 0) {
            system.setZero(stepToNode[0]);
            flag[stepToNode[0]] = 1;
            this.debug.incLevel("STEP 0 Place node #" + stepToNode[0]);
            this.debug.printVector(system.getV(stepToNode[0]));
            this.debug.decLevel();
            if (this.MERGETOBUILDMOL) {
                this.dumpMolecule(system, nodeToStep, 0, molecule);
            }
        }
        if (nodes > 1) {
            system.putV(stepToNode[1], 0, Math.sqrt(Math.abs(dmat[stepToNode[0]][stepToNode[1]])));
            flag[stepToNode[1]] = 1;
            system.putM(0, dmat[stepToNode[0]][stepToNode[1]] > 0.0 ? 1.0 : -1.0);
            this.debug.incLevel("STEP 1 Place node #" + stepToNode[1]);
            this.debug.printVector(system.getV(stepToNode[1]));
            this.debug.decLevel();
            if (this.MERGETOBUILDMOL) {
                this.dumpMolecule(system, nodeToStep, 1, molecule);
            }
        }
        boolean rearrangeCalled = false;
        for (int stepNo = 2; stepNo < nodes; ++stepNo) {
            int lastDim1;
            int lastDim0;
            int i;
            int pn;
            int iCenter;
            MolAtom At;
            int currentNode = stepToNode[stepNo];
            this.debug.setLevel(0);
            this.debug.incLevel("STEP " + stepNo + " Place node #" + currentNode);
            int[] cnodes = this.getNeighbours(currentNode, stepNo, dmat, ctab, nodeToStep);
            this.debug.incLevel("Connected and processed nodes");
            this.debug.printVector(cnodes);
            this.debug.decLevel();
            boolean doChkParity = false;
            if ((cnodes.length > 3 && dmatf[currentNode][cnodes[3]] >= 2.0 || cnodes.length == 3) && MinkowskiBuilder.getParity(At = molecule.getAtom(iCenter = cnodes[0])) != 0) {
                int nCNeighbours = 0;
                int[] ncnodes = new int[3];
                for (int i2 = 0; i2 < ctab[iCenter].length; ++i2) {
                    int iAt = ctab[iCenter][i2];
                    if (nodeToStep[iAt] >= stepNo || ++nCNeighbours > 2) continue;
                    ncnodes[nCNeighbours] = iAt;
                }
                if (nCNeighbours == 2) {
                    ncnodes[0] = iCenter;
                    cnodes = ncnodes;
                    this.debug.incLevel("New connected and processed nodes for chkParity");
                    this.debug.printVector(cnodes);
                    this.debug.decLevel();
                    doChkParity = true;
                }
            }
            int neighbours = cnodes.length;
            int[] nflag = new int[neighbours];
            for (int i3 = 0; i3 < neighbours; ++i3) {
                nflag[i3] = 0;
            }
            double[] Xi = system.getV(cnodes[0]);
            double d2res = dmat[cnodes[0]][currentNode];
            nflag[0] = 1;
            this.debug.incLevel("Xi placed to its first neighbour (#" + cnodes[0] + ")");
            this.debug.printVector(Xi);
            this.debug.decLevel();
            boolean needToRefine = false;
            double[][] subBase = new double[0][0];
            for (int n = 1; n < neighbours; ++n) {
                int nn;
                double orthogonalCandidateLength;
                double d2ij;
                int currentNeighbour = cnodes[n];
                this.debug.setLevel(1);
                this.debug.incLevel("Look for neighbor #" + currentNeighbour);
                this.debug.incLevel("coordinates");
                this.debug.printVector(system.getV(currentNeighbour));
                this.debug.decLevel();
                double d2ijBackup = d2ij = dmat[currentNode][currentNeighbour];
                this.debug.println("d2ij: " + TextUtils.formatNumber(d2ij) + " d2res: " + TextUtils.formatNumber(d2res));
                pn = 0;
                for (int i4 = 0; i4 < n; ++i4) {
                    if (nflag[i4] != 1) continue;
                    ++pn;
                }
                int[] nindex = new int[pn];
                int j = 0;
                for (int i5 = 0; i5 < n; ++i5) {
                    if (nflag[i5] != 1) continue;
                    nindex[j++] = cnodes[i5];
                }
                subBase = system.findBaseJacobi(nindex);
                this.debug.incLevel("Generate sub base");
                this.debug.println("Neighbour index for base generation:");
                this.debug.printVector(nindex);
                this.debug.println("Processed neighbors sub-space:");
                this.debug.printCoord(subBase, system.getM());
                this.debug.decLevel();
                double[] orthogonalCandidate = V.minus(system.getV(currentNeighbour), Xi);
                for (i = 0; i < subBase.length; ++i) {
                    double dXi = V.dotUsingMetric(subBase[i], orthogonalCandidate, system.getM());
                    orthogonalCandidate = V.minus(orthogonalCandidate, V.dot(dXi / V.dotUsingMetric(subBase[i], subBase[i], system.getM()), subBase[i]));
                    d2ij -= dXi * dXi / V.dotUsingMetric(subBase[i], subBase[i], system.getM());
                }
                this.debug.incLevel("Orthogonal candidate");
                this.debug.println("length: " + TextUtils.formatNumber(V.dotUsingMetric(orthogonalCandidate, system.getM())));
                this.debug.println("d2res:  " + TextUtils.formatNumber(d2res));
                this.debug.printVector(system.getM());
                this.debug.printVector(orthogonalCandidate);
                this.debug.decLevel();
                this.debug.println("Orthogonal candidate check.");
                boolean orthogonalityError = false;
                double[] origoNeighbour = system.getV(cnodes[0]);
                for (int i6 = 1; i6 < n; ++i6) {
                    int XXi;
                    double prod;
                    if (nflag[i6] != 1 || !(Math.abs(prod = V.dotUsingMetric(V.minus(system.getV(cnodes[i6]), origoNeighbour), orthogonalCandidate, system.getM())) > EPS)) continue;
                    this.debug.incLevel("Orthogonality error!");
                    this.debug.reportError("ORTHOGONAL CANDIDATE NOT ORTHOGONAL");
                    this.debug.println("TO " + cnodes[0] + "-" + cnodes[i6]);
                    this.debug.println("Scalar prod:" + debugPrintout.formatNumber(prod));
                    this.debug.println("Overlap matrix:");
                    double[][] Overlap = new double[subBase.length][subBase.length];
                    for (int ii = 0; ii < subBase.length; ++ii) {
                        for (int jj = 0; jj < subBase.length; ++jj) {
                            Overlap[ii][jj] = V.dotUsingMetric(subBase[ii], subBase[jj], system.getM());
                        }
                    }
                    this.debug.printMatrix(Overlap);
                    orthogonalityError = true;
                    this.debug.printHR();
                    int XXpn = 0;
                    for (int XXi2 = 0; XXi2 < n; ++XXi2) {
                        if (nflag[XXi2] != 1) continue;
                        ++XXpn;
                    }
                    int[] XXnindex = new int[XXpn + 1];
                    int XXj = 0;
                    for (int XXi3 = 0; XXi3 < n; ++XXi3) {
                        if (nflag[XXi3] != 1) continue;
                        XXnindex[XXj++] = cnodes[XXi3];
                    }
                    XXnindex[XXj] = currentNeighbour;
                    double[][] XXsubBase = this.findBaseJacobi(system.getV(), system.getM(), XXnindex);
                    this.debug.println("Generate sub base");
                    this.debug.println("Neighbour index for base generation:");
                    this.debug.printVector(XXnindex);
                    this.debug.println("sub-space:");
                    this.debug.printCoord(XXsubBase, system.getM());
                    this.debug.printHR();
                    multiDim XXsubB = new multiDim(XXsubBase, system.getM());
                    multiDim XXsystem = new multiDim(XXnindex.length - 1, XXsubBase.length);
                    for (XXi = 0; XXi < XXsubBase.length; ++XXi) {
                        XXsystem.putM(XXi, V.dotUsingMetric(XXsubBase[XXi], system.getM()));
                    }
                    for (XXi = 1; XXi < XXnindex.length; ++XXi) {
                        this.debug.println(XXnindex[0] + " -> " + XXnindex[XXi]);
                        double[] v = V.minus(system.getV(XXnindex[XXi]), system.getV(XXnindex[0]));
                        double[] b = XXsubB.doSchmidtOrthogonalisation(v);
                        this.debug.printVector(b);
                        XXsystem.putV(XXi - 1, b);
                    }
                    this.debug.printHR();
                    XXsystem.printDebug(this.debug);
                    this.debug.decLevel();
                }
                if (orthogonalityError) {
                    V.setZero(orthogonalCandidate);
                    d2ij = d2ijBackup;
                }
                if (Math.abs(orthogonalCandidateLength = V.dotUsingMetric(orthogonalCandidate, orthogonalCandidate, system.getM())) > 0.2) {
                    double s = (d2res - d2ij + orthogonalCandidateLength) / (2.0 * orthogonalCandidateLength);
                    Xi = V.plus(Xi, V.dot(s, orthogonalCandidate));
                    nflag[n] = 1;
                    d2res -= orthogonalCandidateLength * s * s;
                    this.debug.incLevel(" Xi after movement");
                    this.debug.printVector(Xi);
                    this.debug.decLevel();
                    system.putV(currentNode, Xi);
                } else if (Math.abs(d2ij - d2res) < 0.01) {
                    this.debug.println("d2ij == d2res, done for this node");
                    nflag[n] = 1;
                } else {
                    nflag[n] = 2;
                    needToRefine = true;
                    this.debug.println("ROUND1 failed, need to refine.");
                    this.debug.println("d2ij=" + TextUtils.formatNumber(d2ij) + " d2res=" + TextUtils.formatNumber(d2res) + " d2ij-d2res=" + (d2ij - d2res));
                }
                if (n != neighbours - 1) continue;
                this.debug.setLevel(1);
                this.debug.printHR();
                this.debug.incLevel("Looking for dist. mismatch");
                this.debug.println(" d2res:" + TextUtils.formatNumber(d2res));
                for (nn = 0; nn < neighbours; ++nn) {
                    double d2nn;
                    if (nflag[nn] != 1 || !(Math.abs((d2nn = V.dotUsingMetric(V.minus(system.getV(cnodes[nn]), Xi), system.getM()) + d2res) - dmat[currentNode][cnodes[nn]]) > 0.01)) continue;
                    this.debug.reportError("Metrid for node #" + cnodes[nn] + " (from actual #" + currentNode + ") doesnt match. Actual:" + TextUtils.formatNumber(d2nn) + " Required: " + TextUtils.formatNumber(dmat[currentNode][cnodes[nn]]));
                }
                this.debug.decLevel();
                this.debug.printHR();
                this.debug.incLevel("Looking for low metrides");
                this.debug.println("d2res: " + TextUtils.formatNumber(d2res));
                for (nn = 0; nn < nodes; ++nn) {
                    double d2nn;
                    if (nn == currentNode || MinkowskiBuilder.isConnected(dmat, nn, currentNode) || flag[nn] != 1 || !((d2nn = V.dotUsingMetric(V.minus(system.getV(nn), Xi), system.getM()) + d2res) < 1.0)) continue;
                    this.debug.println("Metrid for node #" + nn + " (from actual #" + currentNode + ") would be " + TextUtils.formatNumber(d2nn) + ". Set it to " + 1.0);
                    this.setDistance(dmat, nn, currentNode, 1.0);
                    int[] cnodesTEMP = new int[neighbours + 1];
                    int[] nflagTEMP = new int[neighbours + 1];
                    for (int i7 = 0; i7 < neighbours; ++i7) {
                        cnodesTEMP[i7] = cnodes[i7];
                        nflagTEMP[i7] = nflag[i7];
                    }
                    cnodesTEMP[neighbours] = nn;
                    cnodes = cnodesTEMP;
                    nflag = nflagTEMP;
                    ++neighbours;
                }
                this.debug.decLevel();
                this.debug.printHR();
            }
            this.debug.println("Finalize placement");
            this.debug.incLevel("Coordinates and metric for the system");
            this.debug.printCoordEnchanced(system.getV(), system.getM(), stepToNode, flag);
            this.debug.decLevel();
            if (!needToRefine) {
                if (Math.abs(d2res) < MINEXT) {
                    flag[currentNode] = 1;
                    this.debug.println("Placement done, no need to refine");
                } else {
                    int i8;
                    this.debug.incLevel("Try to find an in-space dir.");
                    boolean found = false;
                    double[] newXi = new double[1];
                    coordGen cg = new coordGen(molecule, dmat, dmatf, system, flag);
                    this.debug.println("Generating in-space orthogonals");
                    cg.findInSpaceOrthogonals(cnodes, nflag);
                    this.debug.println("Subspace base:");
                    cg.subSp.base.printDebug(this.debug);
                    this.debug.println("In-space orthogonals:");
                    cg.subSp.ortho.printDebug(this.debug);
                    this.debug.incLevel("Subspace dot orthogonals");
                    for (int i9 = 0; i9 < cg.subSp.base.n; ++i9) {
                        for (int j = 0; j < cg.subSp.ortho.n; ++j) {
                            this.debug.println(i9 + " " + j + " " + V.dotUsingMetric(cg.subSp.base.getV(i9), cg.subSp.ortho.getV(j), system.getM()));
                        }
                    }
                    this.debug.decLevel();
                    int[] errorFlag = new int[2 * cg.subSp.ortho.n];
                    for (i8 = 0; i8 < cg.subSp.ortho.n; ++i8) {
                        newXi = V.plus(Xi, V.dot(Math.sqrt(Math.abs(d2res)), cg.subSp.ortho.getV(i8)));
                        if (!doChkParity) {
                            errorFlag[2 * i8] = cg.checkPlace(newXi, currentNode);
                        } else {
                            errorFlag[2 * i8] = 0;
                            this.debug.println("Special parity preserving mode.");
                        }
                        if (!this.chkWayToGo(system.getV(), system.getM(), currentNode, Xi, cg.subSp.ortho.getV(i8), cg.getNindex(), cg.m.getBondTable(), cg.m.getCtab())) {
                            int n = 2 * i8;
                            errorFlag[n] = errorFlag[n] | 0x10;
                        }
                        newXi = V.minus(Xi, V.dot(Math.sqrt(Math.abs(d2res)), cg.subSp.ortho.getV(i8)));
                        if (!doChkParity) {
                            errorFlag[2 * i8 + 1] = cg.checkPlace(newXi, currentNode);
                        } else {
                            errorFlag[2 * i8 + 1] = 0;
                            this.debug.println("Special parity preserving mode.");
                        }
                        if (this.chkWayToGo(system.getV(), system.getM(), currentNode, Xi, V.minus(cg.subSp.ortho.getV(i8)), cg.getNindex(), cg.m.getBondTable(), cg.m.getCtab())) continue;
                        int n = 2 * i8 + 1;
                        errorFlag[n] = errorFlag[n] | 0x10;
                    }
                    this.debug.println("Error flag array:");
                    this.debug.printVector(errorFlag);
                    for (i8 = 0; i8 < errorFlag.length; ++i8) {
                        if (errorFlag[i8] != 0) continue;
                        int nn = i8 / 2;
                        if (i8 % 2 == 0) {
                            newXi = V.plus(Xi, V.dot(Math.sqrt(Math.abs(d2res)), cg.subSp.ortho.getV(nn)));
                            found = true;
                            continue;
                        }
                        newXi = V.minus(Xi, V.dot(Math.sqrt(Math.abs(d2res)), cg.subSp.ortho.getV(nn)));
                        found = true;
                    }
                    if (found) {
                        this.debug.println("Found in-space orthogonal:");
                        this.debug.printVector(newXi);
                    }
                    this.debug.decLevel();
                    if (found) {
                        system.putV(currentNode, newXi);
                        flag[currentNode] = 1;
                        this.debug.println("Found proper orthogonal way without opening new dim for d2res = " + TextUtils.formatNumber(d2res));
                    } else {
                        int lastDim = system.addDim();
                        system.putM(lastDim, d2res < 0.0 ? -1.0 : 1.0);
                        double[] newDirection = new double[system.getD()];
                        newDirection[lastDim] = Math.sqrt(Math.abs(d2res));
                        pn = 0;
                        int n = neighbours;
                        for (int i10 = 0; i10 < n; ++i10) {
                            if (nflag[i10] != 1) continue;
                            ++pn;
                        }
                        int[] nindex = new int[pn];
                        int j = 0;
                        for (i = 0; i < n; ++i) {
                            if (nflag[i] != 1) continue;
                            nindex[j++] = cnodes[i];
                        }
                        pn = 0;
                        n = neighbours;
                        for (i = 0; i < n; ++i) {
                            if (nflag[i] != 1) continue;
                            ++pn;
                        }
                        nindex = new int[pn];
                        j = 0;
                        for (i = 0; i < n; ++i) {
                            if (nflag[i] != 1) continue;
                            nindex[j++] = cnodes[i];
                        }
                        double[] XXi = system.getV(currentNode);
                        if (this.chkWayToGo(system.getV(), system.getM(), currentNode, XXi, newDirection, nindex, btab, ctab)) {
                            system.putV(currentNode, V.plus(system.getV(currentNode), newDirection));
                        } else {
                            system.putV(currentNode, V.minus(system.getV(currentNode), newDirection));
                        }
                        flag[currentNode] = 1;
                        this.debug.println("Open 1 new dimension for d2res = " + TextUtils.formatNumber(d2res));
                    }
                }
            } else if (this.NEWREFINE) {
                this.debug.incLevel("New refinement");
                this.debug.println("d2res = " + TextUtils.formatNumber(d2res));
                this.debug.println("Neighbor flag array:");
                this.debug.printVector(nflag);
                double[] dMi = new double[neighbours];
                for (int n = 0; n < neighbours; ++n) {
                    int currentNeighbour = cnodes[n];
                    if (nflag[n] != 2) continue;
                    double Mi = dmat[currentNode][currentNeighbour];
                    double M0i = V.dotUsingMetric(V.minus(system.getV(currentNode), system.getV(currentNeighbour)), system.getM());
                    dMi[n] = Mi - M0i - d2res;
                }
                double l = 0.0;
                for (int n = 0; n < neighbours; ++n) {
                    l += chemaxon.marvin.modelling.linalg.M.sqr(dMi[n]);
                }
                l += chemaxon.marvin.modelling.linalg.M.sqr(d2res);
                l = Math.sqrt(Math.sqrt(l));
                double a = 0.5 * l + d2res / (2.0 * l);
                double b = 0.5 * l - d2res / (2.0 * l);
                int lastDim02 = system.addDim();
                int lastDim12 = system.addDim();
                system.putM(lastDim02, 1.0);
                system.putM(lastDim12, -1.0);
                system.putV(currentNode, lastDim02, a);
                system.putV(currentNode, lastDim12, b);
                for (int n = 0; n < neighbours; ++n) {
                    int currentNeighbour = cnodes[n];
                    if (nflag[n] != 2) continue;
                    double xi = dMi[n] / (2.0 * l);
                    system.putV(currentNeighbour, lastDim02, -xi);
                    system.putV(currentNeighbour, lastDim12, xi);
                    this.debug.println("Refined neighbour node #" + currentNeighbour + " with coordinates " + TextUtils.formatNumber(xi));
                    nflag[n] = 1;
                }
                flag[currentNode] = 1;
                this.debug.decLevel();
                this.debug.incLevel("Looking for dist. mismatch");
                this.debug.println(" d2res:" + TextUtils.formatNumber(d2res));
                for (int nn = 0; nn < neighbours; ++nn) {
                    double d2nn;
                    if (nflag[nn] != 1 || !(Math.abs((d2nn = V.dotUsingMetric(V.minus(system.getV(cnodes[nn]), system.getV(currentNode)), system.getM())) - dmat[currentNode][cnodes[nn]]) > 0.01)) continue;
                    this.debug.reportError("Metrid for node #" + cnodes[nn] + " (from actual #" + currentNode + ") doesnt match. Actual:" + TextUtils.formatNumber(d2nn) + " Required: " + TextUtils.formatNumber(dmat[currentNode][cnodes[nn]]));
                }
                this.debug.decLevel();
            } else if (Math.abs(d2res) > 1.0) {
                this.debug.incLevel("Open 2 new dimensions");
                this.debug.println("d2res = " + TextUtils.formatNumber(d2res));
                lastDim0 = system.addDim();
                lastDim1 = system.addDim();
                double x = Math.sqrt(Math.abs(d2res));
                double Mi = d2res < 0.0 ? -1.0 : 1.0;
                system.putV(currentNode, lastDim0, x);
                system.putM(lastDim0, Mi);
                system.putM(lastDim1, -Mi);
                for (int n = 1; n < neighbours; ++n) {
                    int currentNeighbour = cnodes[n];
                    if (nflag[n] != 2) continue;
                    double d2ij = dmat[currentNode][currentNeighbour];
                    double d = V.dotUsingMetric(V.minus(system.getV(currentNode), system.getV(currentNeighbour)), system.getM());
                    double p = (d - d2ij) / (2.0 * Mi * x);
                    system.putV(currentNeighbour, lastDim0, p);
                    system.putV(currentNeighbour, lastDim1, p);
                    this.debug.println("Refined neighbour node #" + currentNeighbour + " with coordinates " + TextUtils.formatNumber(p));
                    nflag[n] = 1;
                }
                flag[currentNode] = 1;
                this.debug.decLevel();
            } else {
                this.debug.incLevel("open 3 new dimension");
                this.debug.println("d2res = " + TextUtils.formatNumber(d2res) + " and the refinement ");
                lastDim0 = system.addDim();
                lastDim1 = system.addDim();
                int lastDim2 = system.addDim();
                double x = d2res / 8.0;
                system.putV(currentNode, lastDim0, 2.0 + x);
                system.putV(currentNode, lastDim1, 2.0 - x);
                system.putM(lastDim0, 1.0);
                system.putM(lastDim1, -1.0);
                system.putM(lastDim2, 1.0);
                for (int n = 1; n < neighbours; ++n) {
                    int currentNeighbour = cnodes[n];
                    if (nflag[n] != 2) continue;
                    double d2ij = dmat[currentNode][currentNeighbour];
                    double d = V.dotUsingMetric(V.minus(system.getV(currentNode), system.getV(currentNeighbour)), system.getM());
                    double p = (d2ij - d) / (2.0 * system.getV(currentNode, lastDim1));
                    system.putV(currentNeighbour, lastDim1, p);
                    system.putV(currentNeighbour, lastDim2, p);
                    this.debug.println("Refined neighbour node #" + currentNeighbour + " with coordinates " + TextUtils.formatNumber(p));
                    nflag[n] = 1;
                }
                flag[currentNode] = 1;
                this.debug.decLevel();
            }
            if (this.debug.doCheck(2)) {
                this.debug.incLevel("Looking for distance mismatches:");
                for (int nn = 0; nn < neighbours; ++nn) {
                    double d2nn = V.dotUsingMetric(V.minus(system.getV(cnodes[nn]), system.getV(currentNode)), system.getM());
                    if (!(Math.abs(d2nn - dmat[currentNode][cnodes[nn]]) > 0.01)) continue;
                    this.debug.println("ERROR! Metrid for node #" + cnodes[nn] + " (from actual #" + currentNode + ") doesnt match. Actual:" + TextUtils.formatNumber(d2nn) + " Required: " + TextUtils.formatNumber(dmat[currentNode][cnodes[nn]]) + " difference=" + (d2nn - dmat[currentNode][cnodes[nn]]));
                }
                this.debug.decLevel();
            }
            this.debug.incLevel("Coordinates and metric for the system");
            this.debug.printCoordEnchanced(system.getV(), system.getM(), stepToNode, flag);
            this.debug.decLevel();
            if (this.DOPARTIALOPT && system.getD() > 3 && (partialOptCanDo[currentNode] || this.preoptAnytime)) {
                this.debug.incLevel("Doing partial optimization");
                if (!rearrangeCalled) {
                    double[][][] returnValue = new double[2][1][1];
                    returnValue[0] = system.getV();
                    returnValue[1][0] = system.getM();
                    if (this.DOREARRANGE) {
                        this.debug.incLevel("Call Jacobi rearrangement");
                        this.debug.println("Invoke Jacobi based system rearrangement.");
                        returnValue = this.rearrangeSystem(returnValue, stepToNode, flag);
                        this.debug.printCoordEnchanced(returnValue[0], returnValue[1][0], stepToNode, flag);
                        this.debug.decLevel();
                        system = new multiDim(returnValue[0], returnValue[1][0]);
                    }
                }
                this.debug.println("Invoke optimization");
                double[][] fakeCoordM = new double[1][0];
                double[][] fakeCoord = system.getV();
                fakeCoordM[0] = system.getM();
                this.debug.printCoordEnchanced(system.getV(), system.getM(), stepToNode, flag);
                this.debug.printHR();
                this.debug.printHR();
                this.partialOptimizatioToRedD(this.molfrag, fakeCoord, fakeCoordM, dMatrix, dMatrixFlags, distA, flag, fakeCoordM[0].length, 3);
                system = new multiDim(fakeCoord, fakeCoordM[0]);
                this.debug.printCoordEnchanced(system.getV(), system.getM(), stepToNode, flag);
                this.debug.decLevel();
            }
            if (this.MERGETOBUILDMOL) {
                this.dumpMolecule(system, nodeToStep, stepNo, molecule);
            }
            if (pmon == null) continue;
            pmon.set(++this.pmonact);
        }
        this.debug.decLevel();
        if (this.debug.doCheck(1)) {
            this.checkDistances(dmat, system.getV(), system.getM());
            double[][] dmatRecalc = new double[nodes][nodes];
            for (int i = 0; i < nodes; ++i) {
                for (int j = 0; j < nodes; ++j) {
                    double dr = V.dotUsingMetric(V.minus(system.getV(i), system.getV(j)), system.getM());
                    dmatRecalc[i][j] = (double)(dr < 0.0 ? -1 : 1) * Math.sqrt(Math.abs(dr));
                }
            }
            this.debug.incLevel("Recalculated distance square square root mx:");
            this.debug.printMatrix(dmatRecalc);
            this.debug.decLevel();
        }
        this.debug.incLevel("Coordinates and metric for the system:");
        this.debug.printCoordEnchanced(system.getV(), system.getM(), stepToNode, flag);
        this.debug.decLevel();
        double[][][] returnValue = new double[2][1][1];
        returnValue[0] = system.getV();
        returnValue[1][0] = system.getM();
        if (this.DOREARRANGE && !this.DOPARTIALOPT) {
            this.debug.println("Invoke Jacobi based system rearrangement.");
            returnValue = this.rearrangeSystem(returnValue, stepToNode, flag);
            this.debug.incLevel("Rearranged system:");
            this.debug.printCoordEnchanced(returnValue[0], returnValue[1][0], stepToNode, flag);
            this.debug.decLevel();
            if (this.OPT_DREIDING_MINKOWSKI) {
                this.debug.incLevel("Optimize system");
                myMolecule mol = new myMolecule(molecule, this.debug.getWillPrint() ? this.debug : null, null);
                this.debug.incLevel("Given molecule:");
                mol.printout(this.debug);
                this.debug.decLevel();
                FuseCommandSequence seq = new FuseCommandSequence(mol, null, this.debug, 3);
                if (this.debug.getWillPrint()) {
                    this.debug.incLevel("Generated sequence:");
                    seq.printout(this.debug);
                    this.debug.decLevel();
                }
                FragmentStore frags = new FragmentStore(seq, 1);
                Clean3D.FragmentOptimizer fopt = new Clean3D.FragmentOptimizer(frags, mol.a - 2, null, null);
                fopt.setStoreMultiDim(system, true, system.getD());
                this.debug.incLevel("Fragment optimizer:");
                fopt.printout(this.debug);
                this.debug.decLevel();
                Opt3D.MMOptimization oInterface = new Opt3D.MMOptimization(fopt, this.debug);
                Optimization opt = new Optimization(oInterface);
                opt.GradOpt(this.OPT_TO_USE);
                this.debug.decLevel();
            }
        }
        if (this.debug.doCheck(1)) {
            this.checkDistances(dmat, returnValue[0], returnValue[1][0]);
        }
        return returnValue;
    }

    void setDistance(double[][] dmat, int node1, int node2, double dist) {
        dmat[node1][node2] = dist;
        dmat[node2][node1] = dist;
    }

    public static boolean isConnected(double[][] dmat, int n, int m) {
        return Math.abs(dmat[n][m]) > EPS;
    }

    public int[] getConnectedNodes(double[][] dmat, int n) {
        int c = 0;
        for (int i = 0; i < dmat.length; ++i) {
            if (dmat[i][n] == 0.0) continue;
            ++c;
        }
        int[] cnodes = new int[c];
        int j = 0;
        for (int i = 0; i < dmat.length; ++i) {
            if (dmat[i][n] == 0.0) continue;
            cnodes[j] = i;
            ++j;
        }
        return cnodes;
    }

    public int[] getConnectedProcessedNodes(double[][] dmat, int[] flag, int n, double[][] dmatFlags) {
        int c = 0;
        for (int i = 0; i < dmat.length; ++i) {
            if (dmat[i][n] == 0.0 || flag[i] != 1) continue;
            ++c;
        }
        int[] cnodes = new int[c];
        double[] cnodesFlags = new double[c];
        int j = 0;
        for (int i = 0; i < dmat.length; ++i) {
            if (dmat[i][n] == 0.0 || flag[i] != 1) continue;
            cnodes[j] = i;
            cnodesFlags[j] = dmatFlags[i][n];
            ++j;
        }
        boolean change = true;
        int from = 0;
        int to = c - 1;
        while (change) {
            change = false;
            for (int i = from; i < to; ++i) {
                if (!(cnodesFlags[i] > cnodesFlags[i + 1])) continue;
                change = true;
                double k = cnodesFlags[i];
                cnodesFlags[i] = cnodesFlags[i + 1];
                cnodesFlags[i + 1] = k;
                int l = cnodes[i];
                cnodes[i] = cnodes[i + 1];
                cnodes[i + 1] = l;
            }
            --to;
        }
        return cnodes;
    }

    public double[][] startClean(ProgressMonitor pmon, SelectionMolecule mf, CleanSettings settings) {
        VerbosePrinter vp = settings.getVerbosePrinter("Minkowski builder startClean invoked");
        long T_0 = System.currentTimeMillis();
        if (this.performanceLog) {
            System.err.println(settings.getSourceSmiles());
        }
        Stopper cleanTimer = new Stopper();
        if (pmon != null) {
            this.pmonmax = mf.getAtomCount() - 1;
            this.pmonact = 0;
            pmon.init(this.pmonmax);
            pmon.set(this.pmonact);
        }
        this.debug.println("Start processing");
        this.molfrag = mf;
        int me = this.molfrag.getBondCount();
        int mn = this.molfrag.getAtomCount();
        Stopper sssrg = new Stopper();
        MolBond[][] rings = null;
        this.debug.println("Elapsed time for SSSR generation: " + sssrg.stop());
        DistanceMatrixCalculator.assignHybridizationStates(this.molfrag);
        this.printHybrydizationStates(this.molfrag);
        BitSet[] distA = new BitSet[mn];
        this.M = new double[2][mn - 1][];
        for (int i = 0; i < mn - 1; ++i) {
            this.M[0][i] = new double[mn - i - 1];
            this.M[1][i] = new double[mn - i - 1];
        }
        DistanceMatrixCalculator.parityToAtomFlags(this.molfrag, this.debug);
        BitSet[] cis = DistanceMatrixCalculator.getInitialCisPairs(this.molfrag, this.debug);
        this.molfrag.setDim(3);
        Stopper distMg = new Stopper();
        this.debug.incLevel("Generating distance matrix");
        DistanceMatrixCalculator.distanceMatrix(this.M, cis, distA, this.molfrag, this.debug);
        this.debug.decLevel();
        this.debug.println("Elapsed time for Distance square matrix generation: " + distMg.stop());
        BondTable btab = BondTable.createBondTable(mn);
        btab = this.molfrag.getBondTable();
        Object ctab = new int[mn][];
        ctab = this.molfrag.getCtab();
        if (vp != null) {
            vp.print("Invoke makeCoords()");
        }
        double[][][] returnValue = this.makeCoords(this.M[0], this.M[1], distA, btab, (int[][])ctab, this.molfrag, pmon);
        double[][] coords = returnValue[0];
        double[] csMetric = returnValue[1][0];
        this.debug.setLevel(0);
        this.debug.println("Elapsed time for makecoords: " + (System.currentTimeMillis() - T_0) + " msec.");
        if (vp != null) {
            vp.print("makeCoords() returned");
        }
        double[][] fragmentCoordinates = new double[this.molfrag.getAtomCount()][3];
        if (coords[0].length >= 3 && this.DOOPTIMIZE && !this.SKIPFINALOPT) {
            int i;
            this.debug.incLevel(" OPTIMIZATION ");
            int dim = coords[0].length;
            int[] optFlag = new int[coords.length];
            Opt3D optimize = new Opt3D(this.molfrag, this.M[0], this.M[1], distA, optFlag, dim, csMetric, 3, this.debug);
            double[] init = new double[coords.length * dim];
            for (i = 0; i < coords.length; ++i) {
                System.arraycopy(coords[i], 0, init, i * dim, dim);
            }
            coords = optimize.findMin(init, 5.0E-4, System.currentTimeMillis());
            this.debug.printVector(init);
            for (i = 0; i < coords.length; ++i) {
                for (int j = 0; j < 3; ++j) {
                    fragmentCoordinates[i][j] = coords[i][j];
                }
            }
            boolean parityMismatch = false;
            int iParChk = 0;
            for (int i2 = 0; i2 < coords.length; ++i2) {
                MolAtom a = this.molfrag.getAtom(i2);
                if (this.molfrag.getParity(i2) == 0) continue;
                if (MinkowskiBuilder.getParity(a) != this.molfrag.getParity(i2)) {
                    ++iParChk;
                    this.debug.println(" Parity mismatch found at atom No. " + i2 + " " + MinkowskiBuilder.getParity(a) + "!=" + this.molfrag.getParity(i2));
                    continue;
                }
                this.debug.println(" Parity is fine for atom No. " + i2 + " " + MinkowskiBuilder.getParity(a) + "!=" + this.molfrag.getParity(i2));
                --iParChk;
            }
            if (iParChk > 0) {
                for (int j = 0; j < coords.length; ++j) {
                    double[] dArray = fragmentCoordinates[j];
                    dArray[2] = dArray[2] * -1.0;
                }
            }
            this.debug.decLevel();
        } else {
            this.debug.println(" We have less than 3 dim ");
            for (int i = 0; i < coords.length; ++i) {
                for (int j = 0; j < 3; ++j) {
                    double[] p = coords[i];
                    fragmentCoordinates[i][j] = p.length <= j ? 0.0 : p[j];
                }
            }
        }
        if (this.performanceLog) {
            System.err.println(cleanTimer.stop() + "\n");
        }
        this.debug.println("Total elapsed time: " + (System.currentTimeMillis() - T_0) + " msec.");
        this.debug.printHR();
        this.debug.println("Fragments processed.");
        if (pmon != null) {
            pmon.set(this.pmonmax);
        }
        return fragmentCoordinates;
    }

    void dumpMolecule(multiDim coord, int[] nodeToStep, int currentStep, SelectionMolecule molecule) {
        if (this.MERGETOBUILDMOL) {
            int i;
            Molecule m = new Molecule();
            molecule.clonecopy(m);
            for (i = 0; i < nodeToStep.length; ++i) {
                if (nodeToStep[i] > currentStep) continue;
                double x = coord.getV(i, 0);
                double y = coord.getV(i, 1);
                double z = coord.getV(i, 2);
                m.getAtom(i).setXYZ(x, y, z);
            }
            for (i = nodeToStep.length - 1; i >= 0; --i) {
                if (nodeToStep[i] <= currentStep) continue;
                m.removeAtom(i);
            }
            String s = m.toFormat("mol");
            try {
                FileWriter f = new FileWriter("build.mol", true);
                f.write(s);
                f.close();
            }
            catch (Exception e) {
                System.err.println("Dump to build.mol failed!");
            }
        }
    }

    boolean chkWayToGo(double[][] coord, double[] coordM, int currentNode, double[] xCurr, double[] newDirection, int[] nindex, BondTable btab, int[][] ctab) {
        this.debug.println("Enter chkWayToGo");
        boolean posOK = true;
        int nAt = nindex.length + 1;
        int iCenter = 0;
        this.debug.println("Number of atoms: " + nAt);
        if (nAt == 4) {
            int i;
            int[] list = new int[]{nindex[0], nindex[1], nindex[2], currentNode, -1};
            double[][] cList = new double[][]{coord[list[0]], coord[list[1]], coord[list[2]], V.plus(xCurr, newDirection)};
            boolean center = false;
            for (int i2 = 0; i2 < nAt && !center; ++i2) {
                center = true;
                for (int j = 0; j < nAt; ++j) {
                    if (i2 == j) continue;
                    center = center && btab.getBondIndex(list[i2], list[j]) >= 0;
                }
                if (!center) continue;
                iCenter = i2;
            }
            if (center) {
                this.debug.println("Center for parity check found: " + list[iCenter]);
            }
            int cAt = list[iCenter];
            list[iCenter] = list[nAt - 1];
            list[nAt - 1] = cAt;
            double[] cCoord = cList[iCenter];
            cList[iCenter] = cList[nAt - 1];
            cList[nAt - 1] = cCoord;
            if (ctab[cAt].length == 4) {
                for (i = 0; i < ctab[cAt].length; ++i) {
                    boolean exist = false;
                    for (int j = 0; j < nAt - 1; ++j) {
                        exist = exist || ctab[cAt][i] == list[j];
                    }
                    if (exist) continue;
                    list[nAt] = ctab[cAt][i];
                }
            }
            this.debug.print(" (");
            for (i = 0; i < nAt - 1; ++i) {
                this.debug.print(" " + list[i]);
            }
            this.debug.println(" ) - ( " + list[nAt - 1] + " - " + list[nAt] + " )");
            int desParity = MinkowskiBuilder.getParity(this.molfrag.getAtom(cAt));
            if (desParity == 1 || desParity == 2) {
                boolean evenParity;
                if (desParity == 1) {
                    this.debug.println("Desired parity: ODD");
                } else {
                    this.debug.println("Desired parity: EVEN");
                }
                boolean bl = evenParity = 0.0 < V.dot(V.minus(cList[2], cCoord), V.vectProd(V.minus(cList[0], cCoord), V.minus(cList[1], cCoord)));
                if (!evenParity) {
                    this.debug.println("Starting parity: ODD");
                } else {
                    this.debug.println("Starting parity: EVEN");
                }
                int actualParity = this.chkParity(evenParity, list[nAt], list);
                boolean bl2 = posOK = desParity == actualParity;
                if (actualParity == 1) {
                    this.debug.println("Actual parity: ODD");
                } else {
                    this.debug.println("Actual parity: EVEN");
                }
            } else {
                this.debug.println("Desired parity: " + desParity);
            }
        }
        return posOK;
    }

    int[] getNeighbours(int iAt, int iStep, double[][] dMat, int[][] ctab, int[] nodeToStep) {
        int kAt;
        int j;
        int jAt;
        int i;
        int maxNeighbours = 3;
        int nodes = nodeToStep.length;
        BitSet used = new BitSet(nodes);
        int[] list = new int[nodes];
        used.set(iAt);
        int nNeighbour = 0;
        for (i = 0; i < ctab[iAt].length; ++i) {
            jAt = ctab[iAt][i];
            if (nodeToStep[jAt] < 0 || nodeToStep[jAt] >= iStep || used.get(jAt) || dMat[iAt][jAt] == 0.0) continue;
            used.set(jAt);
            list[nNeighbour] = jAt;
            ++nNeighbour;
        }
        for (i = 0; i < ctab[iAt].length; ++i) {
            jAt = ctab[iAt][i];
            if (!used.get(jAt)) continue;
            for (j = 0; j < ctab[jAt].length; ++j) {
                kAt = ctab[jAt][j];
                if (nodeToStep[kAt] < 0 || nodeToStep[kAt] >= iStep || used.get(kAt) || dMat[iAt][kAt] == 0.0) continue;
                used.set(kAt);
                list[nNeighbour] = kAt;
                ++nNeighbour;
            }
        }
        for (i = 0; i < ctab[iAt].length; ++i) {
            jAt = ctab[iAt][i];
            if (!used.get(jAt)) continue;
            for (j = 0; j < ctab[jAt].length; ++j) {
                kAt = ctab[jAt][j];
                if (!used.get(kAt) || kAt == iAt) continue;
                for (int k = 0; k < ctab[kAt].length; ++k) {
                    int lAt = ctab[kAt][k];
                    if (nodeToStep[lAt] < 0 || nodeToStep[lAt] >= iStep || used.get(lAt) || dMat[iAt][lAt] == 0.0) continue;
                    used.set(lAt);
                    list[nNeighbour] = lAt;
                    ++nNeighbour;
                }
            }
        }
        this.debug.println("Number of neighbours found in getNeighbours is:" + nNeighbour);
        nNeighbour = Math.min(3, nNeighbour);
        int[] finalList = new int[nNeighbour];
        for (int i2 = 0; i2 < nNeighbour; ++i2) {
            finalList[i2] = list[i2];
        }
        return finalList;
    }

    static int getParity(MolAtom a) {
        return a.getFlags() & 7;
    }

    int chkParity(boolean evenParity, int connectedAtom, int[] atoms) {
        int j;
        int i;
        int NOATOM = -1;
        int actualParity = 4;
        int[] iA = new int[]{atoms[0], atoms[1], atoms[2], connectedAtom};
        for (int i2 = 0; i2 < 4; ++i2) {
            if (iA[i2] == -1) {
                iA[i2] = Integer.MAX_VALUE;
                continue;
            }
            if (this.molfrag.getAtom(iA[i2]).getAtno() != 1 || this.molfrag.getAtom(iA[i2]).getMassno() != 0) continue;
            iA[i2] = Integer.MAX_VALUE;
        }
        int[] iO = new int[]{0, 0, 0, 0};
        int nAt = 4;
        for (i = 0; i < nAt; ++i) {
            for (j = 0; j < nAt; ++j) {
                if (i == j) continue;
                if (iA[i] == iA[j]) {
                    return actualParity;
                }
                if (iA[i] <= iA[j]) continue;
                int n = i;
                iO[n] = iO[n] + 1;
            }
        }
        for (i = 0; i < nAt - 1; ++i) {
            if (iO[i] == i) continue;
            for (j = i + 1; j < nAt; ++j) {
                if (iO[j] != i) continue;
                evenParity = !evenParity;
                int iOi = iO[i];
                iO[i] = iO[j];
                iO[j] = iOi;
            }
        }
        actualParity = evenParity ? 2 : 1;
        return actualParity;
    }

    double[][][] rearrangeSystem(double[][][] inputStructure, int[] stepToNode, int[] flag) {
        int i;
        double[][] coord = inputStructure[0];
        double[] metric = inputStructure[1][0];
        int dim = metric.length;
        int nodes = coord.length;
        if (nodes < 2) {
            return inputStructure;
        }
        double[] origo = new double[dim];
        for (int i2 = 0; i2 < nodes; ++i2) {
            origo = V.plus(coord[i2], origo);
        }
        origo = V.dot(1 / nodes, origo);
        double[][] vSet = new double[nodes][dim];
        for (int i3 = 0; i3 < nodes; ++i3) {
            vSet[i3] = V.minus(coord[i3], origo);
        }
        double vectors = nodes;
        double[][] oInit = new double[nodes][nodes];
        int i4 = 0;
        while ((double)i4 < vectors) {
            double[] Xi = vSet[i4];
            int j = 0;
            while ((double)j < vectors) {
                double[] Xj = vSet[j];
                oInit[i4][j] = V.dotUsingMetric(Xi, Xj, metric);
                ++j;
            }
            ++i4;
        }
        Matrix O = new Matrix(oInit);
        JacobiTransformation Odiag = new JacobiTransformation(O);
        double[] OdiagV = Odiag.d;
        double[][] OdiagM = Odiag.v;
        int bn = 0;
        int i5 = 0;
        while ((double)i5 < vectors) {
            if (Math.abs(OdiagV[i5]) > EPS) {
                ++bn;
            }
            ++i5;
        }
        double[][] base = new double[bn][dim];
        int[] baseIndex = new int[bn];
        int[] baseProjection = new int[bn];
        bn = 0;
        int i6 = 0;
        while ((double)i6 < vectors) {
            if (Math.abs(OdiagV[i6]) > EPS) {
                double[] combined = new double[dim];
                int j = 0;
                while ((double)j < vectors) {
                    combined = V.plus(combined, V.dot(OdiagM[j][i6], vSet[j]));
                    ++j;
                }
                base[bn] = combined;
                baseIndex[bn] = bn;
                baseProjection[bn] = i6;
                if (Math.abs(V.dotUsingMetric(combined, metric) - OdiagV[i6]) > EPS) {
                    return inputStructure;
                }
                base[bn] = V.dot(1.0 / Math.sqrt(Math.abs(OdiagV[i6])), base[bn]);
                ++bn;
            }
            ++i6;
        }
        if (!this.orthogonalityCheck(base, metric)) {
            return inputStructure;
        }
        boolean change = true;
        while (change) {
            change = false;
            for (int j = 0; j < bn - 1; ++j) {
                if (!(OdiagV[baseProjection[baseIndex[j]]] < OdiagV[baseProjection[baseIndex[j + 1]]])) continue;
                int temp = baseIndex[j];
                baseIndex[j] = baseIndex[j + 1];
                baseIndex[j + 1] = temp;
                change = true;
            }
        }
        for (int i7 = 0; i7 < bn - 1; ++i7) {
            if (!(OdiagV[baseProjection[baseIndex[i7]]] < OdiagV[baseProjection[baseIndex[i7 + 1]]])) continue;
            return inputStructure;
        }
        int realDimsRequired = 3;
        int realDims = 0;
        for (int i8 = 0; i8 < bn; ++i8) {
            if (!(OdiagV[baseProjection[baseIndex[i8]]] > 0.0)) continue;
            ++realDims;
        }
        double[][] baseTemp = new double[bn + (realDimsRequired - realDims > 0 ? realDimsRequired - realDims : 0)][dim];
        int oldB = 0;
        int newB = 0;
        for (oldB = 0; oldB < realDims; ++oldB) {
            baseTemp[newB++] = base[baseIndex[oldB]];
        }
        for (int k = realDims; k < realDimsRequired; ++k) {
            baseTemp[newB++] = baseTemp[bn + k - realDims];
        }
        while (oldB < bn) {
            baseTemp[newB++] = base[baseIndex[oldB]];
            ++oldB;
        }
        base = baseTemp;
        bn = baseTemp.length;
        double[][] newCoord = new double[nodes][bn];
        double[] newMetric = new double[bn];
        double[][][] returnValue = new double[2][1][1];
        returnValue[0] = newCoord;
        returnValue[1][0] = newMetric;
        int newDim = bn;
        for (i = 0; i < bn; ++i) {
            newMetric[i] = V.dotUsingMetric(base[i], metric);
            if (!(Math.abs(newMetric[i]) < 0.5)) continue;
            newMetric[i] = 1.0;
        }
        for (i = 0; i < nodes; ++i) {
            double[] Xi = V.minus(coord[i], origo);
            for (int j = 0; j < newDim; ++j) {
                double dXi;
                newCoord[i][j] = dXi = V.dotUsingMetric(Xi, base[j], metric) / newMetric[j];
                Xi = V.minus(Xi, V.dot(dXi, base[j]));
            }
            if (!(Math.abs(V.dotUsingMetric(Xi, metric)) > EPS)) continue;
            return inputStructure;
        }
        for (i = 0; i < nodes; ++i) {
            for (int j = 0; j < nodes; ++j) {
                if (!(Math.abs(V.dotUsingMetric(V.minus(coord[i], coord[j]), metric) - V.dotUsingMetric(V.minus(newCoord[i], newCoord[j]), newMetric)) > EPS)) continue;
                this.debug.reportError("ERROR - Jacobi based rearrangement - final distance squares mismatch");
                return inputStructure;
            }
        }
        if (!this.DOOPTIMIZE || this.KILLOVERDIM) {
            this.debug.println("WARNING! KILL OVER-3 DIMENSIONS!");
            this.debug.incLevel(" System before clipping:");
            this.debug.printCoordEnchanced(returnValue[0], returnValue[1][0], stepToNode, flag);
            this.debug.decLevel();
            double[][] CnewCoord = new double[nodes][3];
            double[] CnewMetric = new double[3];
            double[][][] CreturnValue = new double[2][1][1];
            CreturnValue[0] = CnewCoord;
            CreturnValue[1][0] = CnewMetric;
            for (int i9 = 0; i9 < 3; ++i9) {
                CnewMetric[i9] = newMetric[i9];
                for (int j = 0; j < nodes; ++j) {
                    CnewCoord[j][i9] = newCoord[j][i9];
                }
            }
            returnValue = CreturnValue;
        }
        return returnValue;
    }

    boolean orthogonalityCheck(double[][] base, double[][] vectors, double[] metric) {
        for (int i = 0; i < base.length; ++i) {
            for (int j = 0; j < vectors.length; ++j) {
                if (!(Math.abs(V.dotUsingMetric(base[i], vectors[j], metric)) > EPS)) continue;
                return false;
            }
        }
        return true;
    }

    boolean orthogonalityCheck(double[][] base, double[] metric) {
        for (int i = 0; i < base.length; ++i) {
            for (int j = i + 1; j < base.length; ++j) {
                if (!(Math.abs(V.dotUsingMetric(base[i], base[j], metric)) > EPS)) continue;
                return false;
            }
        }
        return true;
    }

    void partialOptimizatioToRedD(SelectionMolecule molecule, double[][] coord, double[][] coordM, double[][] M2, double[][] MFlags, BitSet[] distA, int[] optFlag, int dim, int redD) {
        Object ncoords;
        if (((SelectionMolecule[])molecule.findFrags(SelectionMolecule.class)).length > 1) {
            this.debug.println("ERROR more than 1 fragment");
            return;
        }
        if (this.DOOPTIMIZE) {
            Opt3D optimize = new Opt3D(molecule, M2, MFlags, distA, optFlag, dim, coordM[0], redD, this.debug);
            double[] init = new double[coord.length * dim];
            for (int i = 0; i < coord.length; ++i) {
                System.arraycopy(coord[i], 0, init, i * dim, dim);
            }
            this.debug.printVector(init);
            ncoords = optimize.gradMin(this.OPT_TO_USE, init, 0.01, System.currentTimeMillis());
        } else {
            ncoords = new double[coord.length][];
            for (int i = 0; i < coord.length; ++i) {
                ncoords[i] = new double[redD];
                System.arraycopy(coord[i], 0, ncoords[i], 0, redD);
            }
        }
        if (coord[0].length >= 3) {
            int noCAtom;
            int nNeigh;
            double[] mc;
            MolAtom a;
            int i;
            int i2;
            for (i2 = 0; i2 < coord.length; ++i2) {
                MolAtom a2 = molecule.getAtom(i2);
                if (optFlag[i2] == -1) continue;
                a2.setXYZ(coord[i2][0], coord[i2][1], coord[i2][2]);
            }
            for (i2 = 0; i2 < ((double[][])ncoords).length; ++i2) {
                coord[i2] = ncoords[i2];
            }
            this.debug.printHR();
            boolean parityMismatch = false;
            int[][] ctab = molecule.getCtab();
            int iParChk = 0;
            for (i = 0; i < coord.length; ++i) {
                a = molecule.getAtom(i);
                if (MinkowskiBuilder.getParity(a) == 0 || optFlag[i] == -1) continue;
                mc = new double[3];
                nNeigh = 0;
                noCAtom = -1;
                for (int j = 0; j < ctab[i].length; ++j) {
                    if (optFlag[ctab[i][j]] != -1) {
                        ++nNeigh;
                        mc[0] = mc[0] + coord[ctab[i][j]][0];
                        mc[1] = mc[1] + coord[ctab[i][j]][1];
                        mc[2] = mc[2] + coord[ctab[i][j]][2];
                        continue;
                    }
                    noCAtom = ctab[i][j];
                }
                if (nNeigh == 3 && ctab[i].length == 4) {
                    MolAtom b = molecule.getAtom(noCAtom);
                    b.setXYZ(2.0 * coord[i][0] - mc[0] / (double)nNeigh, 2.0 * coord[i][1] - mc[1] / (double)nNeigh, 2.0 * coord[i][2] - mc[2] / (double)nNeigh);
                    ++nNeigh;
                }
                if (nNeigh < 3 || ctab[i].length != nNeigh) continue;
                if (MinkowskiBuilder.getParity(a) != this.molfrag.getParity(i)) {
                    ++iParChk;
                    this.debug.println(" Parity mismatch found at atom No. " + i + " " + MinkowskiBuilder.getParity(a) + "!=" + this.molfrag.getParity(i));
                    continue;
                }
                this.debug.println(" Parity is fine for atom No. " + i + " " + MinkowskiBuilder.getParity(a) + "!=" + this.molfrag.getParity(i));
                --iParChk;
            }
            if (iParChk > 0) {
                for (int j = 0; j < coord.length; ++j) {
                    MolAtom b = this.molfrag.getAtom(j);
                    if (optFlag[j] == -1) continue;
                    b.setXYZ(b.getX(), b.getY(), -b.getZ());
                    double[] dArray = coord[j];
                    dArray[2] = dArray[2] * -1.0;
                }
            }
            for (i = 0; i < coord.length; ++i) {
                a = molecule.getAtom(i);
                if (MinkowskiBuilder.getParity(a) == 0 || optFlag[i] == -1) continue;
                mc = new double[3];
                nNeigh = 0;
                noCAtom = -1;
                for (int j = 0; j < ctab[i].length; ++j) {
                    if (optFlag[ctab[i][j]] != -1) {
                        ++nNeigh;
                        mc[0] = mc[0] + coord[ctab[i][j]][0];
                        mc[1] = mc[1] + coord[ctab[i][j]][1];
                        mc[2] = mc[2] + coord[ctab[i][j]][2];
                        continue;
                    }
                    noCAtom = ctab[i][j];
                }
                if (nNeigh == 3 && ctab[i].length == 4) {
                    MolAtom b = molecule.getAtom(noCAtom);
                    b.setXYZ(2.0 * coord[i][0] - mc[0] / (double)nNeigh, 2.0 * coord[i][1] - mc[1] / (double)nNeigh, 2.0 * coord[i][2] - mc[2] / (double)nNeigh);
                    ++nNeigh;
                }
                if (nNeigh < 3 || ctab[i].length != nNeigh) continue;
                if (MinkowskiBuilder.getParity(a) != this.molfrag.getParity(i)) {
                    ++iParChk;
                    this.debug.println(" Parity mismatch found at atom No. " + i + " " + MinkowskiBuilder.getParity(a) + "!=" + this.molfrag.getParity(i));
                    continue;
                }
                this.debug.println(" Parity is fine for atom No. " + i + " " + MinkowskiBuilder.getParity(a) + "!=" + this.molfrag.getParity(i));
                --iParChk;
            }
            this.debug.printHR();
        }
        coordM[0] = new double[redD];
        for (int i = 0; i < redD; ++i) {
            coordM[0][i] = 1.0;
        }
    }

    void checkDistances(double[][] dmat, double[][] coord, double[] metric) {
        double dev;
        double[] NodeIJ;
        int j;
        int i;
        this.debug.println("Complete. Now checking the max deviation from original distsq. matrix:");
        double maxdev = 0.0;
        int nodes = coord.length;
        for (i = 0; i < nodes; ++i) {
            for (j = i + 1; j < nodes; ++j) {
                if (dmat[i][j] == 0.0) continue;
                NodeIJ = V.minus(coord[i], coord[j]);
                dev = Math.abs(V.dotUsingMetric(NodeIJ, NodeIJ, metric) - dmat[i][j]);
                maxdev = dev > maxdev ? dev : maxdev;
            }
        }
        this.debug.println("Maximal deviation from the original matrix: " + maxdev);
        if (maxdev > EPS * EPS) {
            for (i = 0; i < nodes; ++i) {
                for (j = i + 1; j < nodes; ++j) {
                    if (dmat[i][j] == 0.0 || (dev = Math.abs(V.dotUsingMetric(NodeIJ = V.minus(coord[i], coord[j]), NodeIJ, metric) - dmat[i][j])) != maxdev) continue;
                    this.debug.println("   Beetween nodes: " + i + " " + j);
                }
            }
        }
        for (i = 0; i < nodes; ++i) {
            for (j = i + 1; j < nodes; ++j) {
                if (dmat[i][j] != 0.0 || !((dev = V.dotUsingMetric(NodeIJ = V.minus(coord[i], coord[j]), NodeIJ, metric)) < 1.0 - EPS)) continue;
                this.debug.println("Metrid too low for " + i + " - " + j + " diff is " + dev);
            }
        }
    }

    double[][] findBase(double[][] coord, double[] metric, int[] cnodes) {
        int dim = metric.length;
        double[][] base = new double[0][dim];
        double[] origo = coord[cnodes[0]];
        for (int i = 1; i < cnodes.length; ++i) {
            double[] baseCandidateBuffer = V.minus(coord[cnodes[i]], origo);
            for (int k = 0; k < 1; ++k) {
                int l;
                double[] baseCandidate = new double[dim];
                if (k == 0) {
                    for (l = 0; l < dim; ++l) {
                        baseCandidate[l] = baseCandidateBuffer[l];
                    }
                } else {
                    for (l = 0; l < dim; ++l) {
                        baseCandidate[l] = metric[l] < 0.0 ? baseCandidateBuffer[l] : 0.0;
                    }
                }
                for (int j = 0; j < base.length; ++j) {
                    double[] ithBase = base[j];
                    double dXi = V.dotUsingMetric(baseCandidate, ithBase, metric) / V.dotUsingMetric(ithBase, ithBase, metric);
                    baseCandidate = V.minus(baseCandidate, V.dot(dXi, ithBase));
                }
                double newBaseLen = V.dotUsingMetric(baseCandidate, baseCandidate, metric);
                if (!(Math.abs(newBaseLen) > EPS)) continue;
                baseCandidate = V.dot(1.0 / Math.sqrt(Math.abs(newBaseLen)), baseCandidate);
                double[][] baseBuffer = new double[base.length + 1][dim];
                for (int j = 0; j < base.length; ++j) {
                    baseBuffer[j] = base[j];
                }
                baseBuffer[base.length] = baseCandidate;
                base = baseBuffer;
            }
        }
        return base;
    }

    double[][] findBaseJacobi(double[][] coord, double[] metric, int[] cnodes) {
        int dim = metric.length;
        double[] origo = coord[cnodes[0]];
        int nodes = cnodes.length;
        if (nodes < 2) {
            return new double[0][0];
        }
        double[][] vSet = new double[nodes - 1][dim];
        for (int i = 1; i < nodes; ++i) {
            vSet[i - 1] = V.minus(coord[cnodes[i]], origo);
        }
        double vectors = nodes - 1;
        double[][] oInit = new double[nodes - 1][nodes - 1];
        int i = 0;
        while ((double)i < vectors) {
            double[] Xi = vSet[i];
            int j = 0;
            while ((double)j < vectors) {
                double[] Xj = vSet[j];
                oInit[i][j] = V.dotUsingMetric(Xi, Xj, metric);
                ++j;
            }
            ++i;
        }
        Matrix O = new Matrix(oInit);
        JacobiTransformation Odiag = new JacobiTransformation(O);
        double[] OdiagV = Odiag.d;
        double[][] OdiagM = Odiag.v;
        int bn = 0;
        int i2 = 0;
        while ((double)i2 < vectors) {
            if (Math.abs(OdiagV[i2]) > EPS) {
                ++bn;
            }
            ++i2;
        }
        double[][] base = new double[bn][dim];
        bn = 0;
        int i3 = 0;
        while ((double)i3 < vectors) {
            if (Math.abs(OdiagV[i3]) > EPS) {
                double[] combined = new double[dim];
                int j = 0;
                while ((double)j < vectors) {
                    combined = V.plus(combined, V.dot(OdiagM[j][i3], vSet[j]));
                    ++j;
                }
                base[bn] = combined;
                if (Math.abs(V.dotUsingMetric(combined, metric) - OdiagV[i3]) > EPS) {
                    this.debug.reportError("ERROR: Jacobi based basis generation failed - combined vector length mismatch.");
                    return new double[0][dim];
                }
                base[bn] = V.dot(1.0 / Math.sqrt(Math.abs(OdiagV[i3])), base[bn]);
                ++bn;
            }
            ++i3;
        }
        for (i3 = 0; i3 < bn; ++i3) {
            for (int j = i3 + 1; j < bn; ++j) {
                if (!(Math.abs(V.dotUsingMetric(base[i3], base[j], metric)) > EPS)) continue;
                this.debug.reportError("ERROR: Jacobi based basis generation failed - basis set not orthogonal.");
                return new double[0][dim];
            }
        }
        return base;
    }

    double[][] optim3d(double[][] coords, double[] metric, double[][] M2, BitSet[] distA, int[] flag) {
        if (coords[0].length > 3) {
            this.debug.incLevel(" OPTIMIZATION - Clean3D.optim3d() invoked");
            int dim = coords[0].length;
            int No = 0;
            int[] tmp = new int[flag.length];
            for (int i = 0; i < flag.length; ++i) {
                if (flag[i] != 1) continue;
                tmp[No] = i;
                ++No;
            }
            int[] list = new int[No];
            System.arraycopy(tmp, 0, list, 0, No);
            BitSet[] ndistA = new BitSet[No];
            Object ncoords = new double[No][];
            for (int i = 0; i < list.length; ++i) {
                ncoords[i] = coords[list[i]];
                ndistA[i] = new BitSet(No);
                for (int j = 0; j < list.length; ++j) {
                    if (!distA[i].get(list[j])) continue;
                    ndistA[i].set(list[j]);
                }
            }
            SelectionMolecule redmol = (SelectionMolecule)this.molfrag.clone();
            for (int i = flag.length - 1; i >= 0; --i) {
                if (flag[i] == 1) continue;
                this.debug.println(i + " leszedem " + redmol.getAtomCount());
                redmol.removeAtom(i);
            }
            if (((SelectionMolecule[])redmol.findFrags(SelectionMolecule.class)).length > 1) {
                this.debug.println("ERROR more than 1 fragment");
            }
            int[] optFlag = new int[dim];
            Opt3D optimize = new Opt3D(redmol, M2, M2, distA, optFlag, dim, metric, 3, this.debug);
            double[] init = new double[((double[][])ncoords).length * dim];
            for (int i = 0; i < ((double[][])ncoords).length; ++i) {
                System.arraycopy(ncoords[i], 0, init, i * dim, dim);
            }
            ncoords = optimize.gradMin(this.OPT_TO_USE, init, 5.0E-4, System.currentTimeMillis());
            double[][] coords3D = new double[coords.length][3];
            for (int i = 0; i < list.length; ++i) {
                coords3D[list[i]] = ncoords[i];
            }
            coords = coords3D;
            this.debug.decLevel();
        }
        return coords;
    }

    void processOldOptionString(String opts) {
        block17: for (int i = 0; i < opts.length(); ++i) {
            char c = opts.charAt(i);
            switch (c) {
                case '?': 
                case 'h': {
                    System.err.println("Clean3D options:");
                    System.err.println("  B  Merge build sequence to build.mol");
                    System.err.println("  j  do not skip 3D clean for non-3D molecules.");
                    System.err.println("  R  Use new refinement");
                    System.err.println("  S  Skip final optimization");
                    System.err.println("  P  Performance log. Echo to stderr the param string, molecule (SMILES) and times");
                    System.err.println("  M  Placement with no partial opt, Jacobi, Dreiding");
                    System.err.println("  L  Optimize with Dreiding after all.");
                    System.err.println("  J  Calculate JUST Dreiding energy with NO clean.");
                    System.err.println("  E  Calculate Dreiding energy after clean.");
                    System.err.println("  c  Clip dimensions higher than 3 at Jacobi based rearrangement");
                    System.err.println("  n  Do NOT optimize the rearranged system");
                    System.err.println("  N  Use the new default optimization algorithm");
                    System.err.println("  p  Skip partial optimization steps");
                    System.err.println("  r  Turn off system rearrangement");
                    System.err.println("  s  SKIP Advanced placement sequence generation strategy");
                    System.err.println("  l  Preopotimization only after a layer placed");
                    System.err.println("  OD Do 3D clean for non-3D molecules then optimize with Dreiding.");
                    if (this.disableDevelFeatures) {
                        System.err.println("The following options are disabled:");
                    }
                    System.err.println("  b  do backchecks");
                    System.err.println("  d  Make HTML debug printouts (1 level)");
                    System.err.println("  D  Make HTML debug printouts (all level)");
                    System.err.println("  e  Make HTML debug printout, echo messages to STDERR");
                    continue block17;
                }
                case 'B': {
                    this.debug.println("[B] Merge build sequence to build.mol");
                    this.MERGETOBUILDMOL = true;
                    continue block17;
                }
                case 'j': {
                    this.debug.println("[j] Do not skip 3D clean only for non-3D molecules.");
                    this.DOCLEANFORNON3D = true;
                    continue block17;
                }
                case 'R': {
                    this.debug.println("[R] Use new refinement");
                    this.NEWREFINE = true;
                    continue block17;
                }
                case 'S': {
                    this.debug.println("[S] Skip final optimization");
                    this.SKIPFINALOPT = true;
                    continue block17;
                }
                case 'P': {
                    this.debug.println("[P] Performance log. Echo to stderr all the processed fragments and times");
                    this.performanceLog = true;
                    System.err.println(opts);
                    continue block17;
                }
                case 'M': {
                    this.preoptAnytime = false;
                    this.DOOPTIMIZE = false;
                    this.DOPARTIALOPT = false;
                    this.DOREARRANGE = true;
                    this.OPT_DREIDING_MINKOWSKI = true;
                    this.debug.println("[M] Placement with no partial opt, Jacobi, Dreiding");
                    continue block17;
                }
                case 'l': {
                    this.preoptAnytime = false;
                    this.debug.println("[l] Preoptimiziation only after a layer placed");
                    continue block17;
                }
                case 's': {
                    this.PSEQGENSTRAT = 0;
                    this.debug.println("[s] SKIP Advanced placement sequence generation strategy");
                    continue block17;
                }
                case 'c': {
                    this.KILLOVERDIM = true;
                    this.debug.println("[c] Dimensions over first 3 real will clipped");
                    continue block17;
                }
                case 'n': {
                    this.DOOPTIMIZE = false;
                    this.debug.println("[n] Will NOT optimize the minkovski coordinate set");
                    continue block17;
                }
                case 'N': {
                    this.OPT_TO_USE = 1;
                    this.debug.println("[N] Will use new optimization defaults");
                    continue block17;
                }
                case 'p': {
                    this.DOPARTIALOPT = false;
                    this.debug.println("[p] NOT Do partial optimization");
                    continue block17;
                }
                case 'r': {
                    this.DOREARRANGE = false;
                    this.debug.println("[r] Turn off rearrangement");
                    continue block17;
                }
                case '0': 
                case '1': {
                    continue block17;
                }
                default: {
                    String msg = String.valueOf(c) + ": bad Clean3D option";
                    this.debug.println(msg);
                    System.err.println(msg);
                }
            }
        }
    }

    void printHybrydizationStates(SelectionMolecule m) {
        this.debug.incLevel("Hybridization states");
        int mn = this.molfrag.getAtomCount();
        for (int i = 0; i < mn; ++i) {
            int h = m.getAtom(i).getHybridizationState();
            String s = i + 1 + " atom hybr ";
            if (h == 0) {
                this.debug.println(s + " unknown ");
                continue;
            }
            if (h == 2) {
                this.debug.println(s + " sp1 ");
                continue;
            }
            if (h == 3) {
                this.debug.println(s + " sp2 ");
                continue;
            }
            if (h != 4) continue;
            this.debug.println(s + " sp3 ");
        }
        this.debug.decLevel();
    }

    public static void placeFragments(MoleculeGraph[] mols, MoleculeGraph ORIGM) {
        RgMolecule m;
        Molecule r;
        if (ORIGM instanceof RgMolecule && (r = (m = (RgMolecule)ORIGM).getRoot()) instanceof RxnMolecule) {
            System.err.println("RxnMolecule");
            MinkowskiBuilder.placeRxn((RxnMolecule)r);
            return;
        }
        MinkowskiBuilder.placeRaster(mols);
    }

    static void placeRaster(MoleculeGraph[] mols) {
        int rasz;
        int rasy;
        int rasx;
        int ras;
        double[] Wx = new double[mols.length];
        double[] Wy = new double[mols.length];
        double[] Wz = new double[mols.length];
        double maxCube = 0.0;
        for (int s = 0; s < mols.length; ++s) {
            int i;
            MoleculeGraph molfrag = mols[s];
            molfrag.setDim(3);
            int mn = molfrag.getAtomCount();
            for (i = 0; i < mn; ++i) {
                MolAtom a = molfrag.getAtom(i);
                int n = s;
                Wx[n] = Wx[n] + a.getX();
                int n2 = s;
                Wy[n2] = Wy[n2] + a.getY();
                int n3 = s;
                Wz[n3] = Wz[n3] + a.getZ();
            }
            int n = s;
            Wx[n] = Wx[n] / (mn > 0 ? (double)mn : 1.0);
            int n4 = s;
            Wy[n4] = Wy[n4] / (mn > 0 ? (double)mn : 1.0);
            int n5 = s;
            Wz[n5] = Wz[n5] / (mn > 0 ? (double)mn : 1.0);
            for (i = 0; i < mn; ++i) {
                MolAtom a = molfrag.getAtom(i);
                double cube = Math.abs(Wx[s] - a.getX());
                if (cube > maxCube) {
                    maxCube = cube;
                }
                if ((cube = Math.abs(Wy[s] - a.getY())) > maxCube) {
                    maxCube = cube;
                }
                if (!((cube = Math.abs(Wz[s] - a.getZ())) > maxCube)) continue;
                maxCube = cube;
            }
        }
        if (mols.length > 8) {
            rasx = ras = (int)Math.exp(0.0 * Math.log(mols.length));
            rasy = ras;
            rasz = ras;
        } else {
            rasx = ras = (int)Math.sqrt(mols.length);
            rasy = ras;
            rasz = 1;
        }
        while (rasx * rasy * rasz < mols.length) {
            if (rasx * rasy * rasz < mols.length) {
                ++rasx;
            }
            if (rasx * rasy * rasz < mols.length) {
                ++rasy;
            }
            if (rasx * rasy * rasz >= mols.length) continue;
            ++rasz;
        }
        int s = 0;
        double l = 2.0 * maxCube + 1.0 + 1.54;
        for (int zz = 0; zz < rasz; ++zz) {
            double oz = (double)zz * l;
            for (int yy = 0; yy < rasy; ++yy) {
                double oy = (double)yy * l;
                for (int xx = 0; xx < rasx; ++xx) {
                    double ox = (double)xx * l;
                    if (s >= mols.length) continue;
                    MoleculeGraph molfrag = mols[s];
                    int mn = molfrag.getAtomCount();
                    for (int i = 0; i < mn; ++i) {
                        MolAtom a = molfrag.getAtom(i);
                        a.setX(a.getX() - Wx[s] + ox);
                        a.setY(a.getY() - Wy[s] + oy);
                        a.setZ(a.getZ() - Wz[s] + oz);
                    }
                    ++s;
                }
            }
        }
    }

    static void placeRxn(RxnMolecule m) {
        double[][] b;
        int an = m.getAgentCount();
        MoleculeGraph[] amf = null;
        if (an > 0) {
            int i;
            int afn = 0;
            for (i = 0; i < an; ++i) {
                afn += m.getAgent(i).getFragCount();
            }
            amf = new MoleculeGraph[afn];
            afn = 0;
            for (i = 0; i < an; ++i) {
                int frags = m.getAgent(i).getFragCount();
                if (frags == 1) {
                    amf[afn++] = m.getAgent(i);
                    continue;
                }
                MoleculeGraph[] ag = m.getAgent(i).findFrags(SelectionMolecule.class);
                for (int j = 0; j < ag.length; ++j) {
                    amf[afn++] = ag[j];
                }
            }
            MinkowskiBuilder.placeRaster(amf);
        }
        int rn = m.getReactantCount();
        MoleculeGraph[] rmf = null;
        if (rn > 0) {
            int i;
            int rfn = 0;
            for (i = 0; i < rn; ++i) {
                rfn += m.getReactant(i).getFragCount();
            }
            rmf = new MoleculeGraph[rfn];
            rfn = 0;
            for (i = 0; i < rn; ++i) {
                int frags = m.getReactant(i).getFragCount();
                if (frags == 1) {
                    rmf[rfn++] = m.getReactant(i);
                    continue;
                }
                MoleculeGraph[] rg = m.getReactant(i).findFrags(SelectionMolecule.class);
                for (int j = 0; j < rg.length; ++j) {
                    rmf[rfn++] = rg[j];
                }
            }
            MinkowskiBuilder.placeRaster(rmf);
        }
        int pn = m.getProductCount();
        MoleculeGraph[] pmf = null;
        if (pn > 0) {
            int i;
            int pfn = 0;
            for (i = 0; i < pn; ++i) {
                pfn += m.getProduct(i).getFragCount();
            }
            pmf = new MoleculeGraph[pfn];
            pfn = 0;
            for (i = 0; i < pn; ++i) {
                int frags = m.getProduct(i).getFragCount();
                if (frags == 1) {
                    pmf[pfn++] = m.getProduct(i);
                    continue;
                }
                MoleculeGraph[] pg = m.getProduct(i).findFrags(SelectionMolecule.class);
                for (int j = 0; j < pg.length; ++j) {
                    pmf[pfn++] = pg[j];
                }
            }
            MinkowskiBuilder.placeRaster(pmf);
        }
        double arrowright = 0.0;
        if (amf == null) {
            arrowright = 1.54;
        } else {
            double[][] b2 = MinkowskiBuilder.calc3DBounds(amf);
            arrowright = 1.54 + b2[1][0] - b2[2][0];
            MinkowskiBuilder.Translate(-b2[2][0] + 0.77, -b2[2][1] + 1.54, -(b2[1][2] + b2[2][2]) / 2.0, amf);
        }
        DPoint3[] arrow = new DPoint3[]{new DPoint3(0.0, 0.0, 0.0), new DPoint3(arrowright, 0.0, 0.0)};
        m.setReactionArrow(arrow);
        if (rmf != null) {
            b = MinkowskiBuilder.calc3DBounds(rmf);
            MinkowskiBuilder.Translate(-b[1][0] - 3.08, -(b[1][1] + b[2][1]) / 2.0, -(b[1][2] + b[2][2]) / 2.0, rmf);
        }
        if (pmf != null) {
            b = MinkowskiBuilder.calc3DBounds(pmf);
            MinkowskiBuilder.Translate(arrowright - b[2][0] + 3.08, -(b[1][1] + b[2][1]) / 2.0, -(b[1][2] + b[2][2]) / 2.0, pmf);
        }
    }

    static void Translate(double x, double y, double z, MoleculeGraph[] molfrag) {
        for (int fn = 0; fn < molfrag.length; ++fn) {
            int an = molfrag[fn].getAtomCount();
            for (int i = 0; i < an; ++i) {
                MolAtom a = molfrag[fn].getAtom(i);
                a.setX(a.getX() + x);
                a.setY(a.getY() + y);
                a.setZ(a.getZ() + z);
            }
        }
    }

    static double[][] calc3DBounds(MoleculeGraph[] molfrag) {
        double[][] ret = new double[3][3];
        int tan = 0;
        for (int fn = 0; fn < molfrag.length; ++fn) {
            int an = molfrag[fn].getAtomCount();
            for (int i = 0; i < an; ++i) {
                MolAtom a = molfrag[fn].getAtom(i);
                double X = a.getX();
                double Y = a.getY();
                double Z = a.getZ();
                double[] dArray = ret[0];
                dArray[0] = dArray[0] + X;
                double[] dArray2 = ret[0];
                dArray2[1] = dArray2[1] + Y;
                double[] dArray3 = ret[0];
                dArray3[2] = dArray3[2] + Z;
                if (i == 0 && fn == 0 || X > ret[1][0]) {
                    ret[1][0] = X;
                }
                if (i == 0 && fn == 0 || Y > ret[1][1]) {
                    ret[1][1] = Y;
                }
                if (i == 0 && fn == 0 || Z > ret[1][2]) {
                    ret[1][2] = Z;
                }
                if (i == 0 && fn == 0 || X < ret[2][0]) {
                    ret[2][0] = X;
                }
                if (i == 0 && fn == 0 || Y < ret[2][1]) {
                    ret[2][1] = Y;
                }
                if (i == 0 && fn == 0 || Z < ret[2][2]) {
                    ret[2][2] = Z;
                }
                ++tan;
            }
        }
        if (tan != 0) {
            double[] dArray = ret[0];
            dArray[0] = dArray[0] / (double)tan;
            double[] dArray4 = ret[0];
            dArray4[1] = dArray4[1] / (double)tan;
            double[] dArray5 = ret[0];
            dArray5[2] = dArray5[2] / (double)tan;
        }
        return ret;
    }

    public class coordGen {
        public SelectionMolecule m = null;
        public multiDim system = null;
        public double[][] dmat = null;
        public double[][] dmatf = null;
        public int[] flag = null;
        public int nodes = 0;
        public int[] stepToNode = null;
        public int[] nodeToStep = null;
        public boolean[] partialFlag = null;
        static final int OK = 0;
        static final int CLOSE = 1;
        static final int MISMATCH = 2;
        static final int NEGATIVE = 4;
        public subSpace subSp = null;

        public coordGen(SelectionMolecule moleculeFragment, double[][] metridMatrix, double[][] metridMatrixFlags, multiDim coordinateSystem, int[] flagArray) {
            this.m = moleculeFragment;
            this.dmat = metridMatrix;
            this.system = coordinateSystem;
            this.flag = flagArray;
            this.dmatf = metridMatrixFlags;
            this.calcNodes();
        }

        boolean calcNodes() {
            if (this.m != null && this.dmat != null) {
                this.nodes = Math.min(this.dmat.length, this.m.getAtomCount());
                return true;
            }
            this.nodes = 0;
            return false;
        }

        public int checkPlace(double[] pos, int n) {
            int returnValue = 0;
            int allError = 7;
            for (int i = 0; i < this.nodes && returnValue != allError; ++i) {
                if (this.flag[i] != 1 || i == n) continue;
                double mm = V.dotUsingMetric(V.minus(pos, this.system.getV(i)), this.system.getM());
                if (MinkowskiBuilder.isConnected(this.dmat, i, n)) {
                    double err = Math.abs(mm - this.dmat[i][n]);
                    if (err > EPS) {
                        MinkowskiBuilder.this.debug.println(" Distance check mismatch: " + i + " " + n + " " + err);
                        returnValue |= 2;
                    }
                } else if (mm < 1.0) {
                    returnValue |= 1;
                }
                if (!(mm < 0.0)) continue;
                returnValue |= 4;
            }
            return returnValue;
        }

        public void findNeighborSubspace(int[] cnodes, int[] nflag) {
            if (cnodes != null && nflag != null) {
                if (this.subSp == null) {
                    this.subSp = new subSpace(this.system);
                } else {
                    this.subSp.sync(this.system);
                }
                for (int i = 0; i < nflag.length && i < cnodes.length; ++i) {
                    if (nflag[i] != 1) continue;
                    this.subSp.adminInsert(cnodes[i]);
                }
                this.subSp.doJacobi();
            }
        }

        public void findInSpaceOrthogonals(int[] cnodes, int[] nflag) {
            this.findNeighborSubspace(cnodes, nflag);
            this.subSp.generateOrthogonalSubspace();
        }

        public int[] getNindex() {
            int[] returnValue = new int[this.subSp.n];
            for (int i = 0; i < this.subSp.n; ++i) {
                returnValue[i] = this.subSp.nindex[i];
            }
            return returnValue;
        }

        boolean initSequence() {
            if (this.calcNodes()) {
                this.stepToNode = new int[this.nodes];
                this.nodeToStep = new int[this.nodes];
                this.partialFlag = new boolean[this.nodes];
                return true;
            }
            return false;
        }

        void generateSequence3() {
            if (this.initSequence()) {
                int i;
                int j;
                int i2;
                int i3;
                BondTable btab = this.m.getBondTable();
                int[][] ctab = this.m.getCtab();
                MinkowskiBuilder.this.debug.incLevel("Generate placement sequence");
                MinkowskiBuilder.this.debug.incLevel("Bond table");
                MinkowskiBuilder.this.debug.printMatrix(btab);
                MinkowskiBuilder.this.debug.decLevel();
                MinkowskiBuilder.this.debug.incLevel("Connection table");
                MinkowskiBuilder.this.debug.printMatrix(ctab);
                MinkowskiBuilder.this.debug.decLevel();
                for (int i4 = 0; i4 < this.nodes; ++i4) {
                    this.stepToNode[i4] = -1;
                    this.nodeToStep[i4] = -1;
                    this.partialFlag[i4] = false;
                }
                MinkowskiBuilder.this.debug.println("<CENTER><B>Locate initial central node</B></CENTER>");
                int centralCandidate = 0;
                int maxB = -1;
                int maxM = 0;
                for (int i5 = 0; i5 < this.nodes; ++i5) {
                    int metrids = 0;
                    for (int j2 = 0; j2 < this.nodes; ++j2) {
                        if (this.dmat[i5][j2] == 0.0) continue;
                        ++metrids;
                    }
                    if (ctab[i5].length <= maxB && (ctab[i5].length != maxB || metrids <= maxM)) continue;
                    centralCandidate = i5;
                    maxB = ctab[i5].length;
                    maxM = metrids;
                }
                MinkowskiBuilder.this.debug.println("Central cndidate atom: " + centralCandidate);
                MinkowskiBuilder.this.debug.println("All bonds defined:     " + maxB);
                MinkowskiBuilder.this.debug.println("All metrids defined:   " + maxM);
                MinkowskiBuilder.this.debug.println("<CENTER><B>Classify atoms</B></CENTER>");
                MinkowskiBuilder.this.debug.println("Layered clippping chain atoms and locate in-layer central candidates");
                boolean[] isChain = new boolean[this.nodes];
                boolean[] inNextLayer = new boolean[this.nodes];
                for (int i6 = 0; i6 < this.nodes; ++i6) {
                    isChain[i6] = false;
                }
                boolean found = true;
                while (found) {
                    found = false;
                    for (i3 = 0; i3 < this.nodes; ++i3) {
                        int ncNeigh = 0;
                        for (int j3 = 0; j3 < ctab[i3].length; ++j3) {
                            if (isChain[ctab[i3][j3]]) continue;
                            ++ncNeigh;
                        }
                        inNextLayer[i3] = ncNeigh <= 1;
                    }
                    boolean mflag = true;
                    for (i2 = 0; i2 < this.nodes; ++i2) {
                        if (!inNextLayer[i2] || isChain[i2]) continue;
                        isChain[i2] = true;
                        found = true;
                        int metrids = 0;
                        for (j = 0; j < this.nodes; ++j) {
                            if (this.dmat[i2][j] == 0.0) continue;
                            ++metrids;
                        }
                        if (!mflag && ctab[i2].length <= maxB && (ctab[i2].length != maxB || metrids <= maxM)) continue;
                        centralCandidate = i2;
                        maxB = ctab[i2].length;
                        maxM = metrids;
                        mflag = false;
                    }
                    MinkowskiBuilder.this.debug.print("Layer atoms: ");
                    for (i2 = 0; i2 < this.nodes; ++i2) {
                        if (!inNextLayer[i2]) continue;
                        MinkowskiBuilder.this.debug.print(i2 + " ");
                    }
                    MinkowskiBuilder.this.debug.println();
                    MinkowskiBuilder.this.debug.println("Central cndidate atom: " + centralCandidate);
                    MinkowskiBuilder.this.debug.println("All bonds defined:     " + maxB);
                    MinkowskiBuilder.this.debug.println("All metrids defined:   " + maxM);
                    MinkowskiBuilder.this.debug.println();
                }
                MinkowskiBuilder.this.debug.print("Chain atoms: ");
                for (i3 = 0; i3 < this.nodes; ++i3) {
                    if (!isChain[i3]) continue;
                    MinkowskiBuilder.this.debug.print(i3 + " ");
                }
                MinkowskiBuilder.this.debug.println();
                MinkowskiBuilder.this.debug.println("<CENTER><B>Ranging atoms</B></CENTER>");
                MinkowskiBuilder.this.debug.println("0:  in outer chain");
                MinkowskiBuilder.this.debug.println("1:  in inter-ring chain");
                MinkowskiBuilder.this.debug.println("2+: in ring");
                int[] atomRang = new int[this.nodes];
                for (i2 = 0; i2 < this.nodes; ++i2) {
                    atomRang[i2] = isChain[i2] ? 0 : 1;
                }
                int[][] SSSRatoms = this.m.getSSSR();
                for (i = 0; i < SSSRatoms.length; ++i) {
                    for (j = 0; j < SSSRatoms[i].length; ++j) {
                        int n = SSSRatoms[i][j];
                        atomRang[n] = atomRang[n] + 1;
                    }
                }
                MinkowskiBuilder.this.debug.println("Atom rangs:");
                MinkowskiBuilder.this.debug.print("<TABLE><TR>");
                for (i = 0; i < this.nodes; ++i) {
                    MinkowskiBuilder.this.debug.print("<TD>" + i + "</TD>");
                }
                MinkowskiBuilder.this.debug.print("</TR><TR>");
                for (i = 0; i < this.nodes; ++i) {
                    MinkowskiBuilder.this.debug.print("<TD>" + atomRang[i] + "</TD>");
                }
                MinkowskiBuilder.this.debug.println("</TR></TABLE>");
                MinkowskiBuilder.this.debug.println("<CENTER><B>Final centrum search</B></CENTER>");
                int centrumRang = 0;
                for (int i7 = 0; i7 < this.nodes; ++i7) {
                    int metrids = 0;
                    for (int j4 = 0; j4 < this.nodes; ++j4) {
                        if (this.dmat[i7][j4] == 0.0) continue;
                        ++metrids;
                    }
                    boolean update = false;
                    if (centrumRang < atomRang[i7]) {
                        update = true;
                    } else if (centrumRang == atomRang[i7] && centrumRang > 0) {
                        if (maxB < ctab[i7].length) {
                            update = true;
                        } else if (maxB == ctab[i7].length && metrids > maxM) {
                            update = true;
                        }
                    }
                    if (!update) continue;
                    centralCandidate = i7;
                    maxB = ctab[i7].length;
                    maxM = metrids;
                    centrumRang = atomRang[i7];
                }
                MinkowskiBuilder.this.debug.println("Central candidate atom: " + centralCandidate);
                MinkowskiBuilder.this.debug.println("All bonds defined:     " + maxB);
                MinkowskiBuilder.this.debug.println("All metrids defined:   " + maxM);
                MinkowskiBuilder.this.debug.println("Centrum rang:          " + centrumRang);
                MinkowskiBuilder.this.debug.println();
                MinkowskiBuilder.this.debug.println();
                MinkowskiBuilder.this.debug.println("<CENTER><B>Iterative layered placement</B></CENTER>");
                int stepPointer = 0;
                this.stepToNode[stepPointer] = centralCandidate;
                this.nodeToStep[centralCandidate] = stepPointer++;
                MinkowskiBuilder.this.debug.println("Place centrum");
                MinkowskiBuilder.this.debug.println();
                found = true;
                while (found) {
                    int i8;
                    MinkowskiBuilder.this.debug.println("Layer start");
                    found = false;
                    int maxRang = 0;
                    int absMaxRang = 0;
                    int metDef = 0;
                    MinkowskiBuilder.this.debug.println("<B>Atom parameters:</B>");
                    for (int i9 = 0; i9 < this.nodes; ++i9) {
                        int j5;
                        if (this.nodeToStep[i9] != -1) continue;
                        int mets = MinkowskiBuilder.this.getNeighbours(i9, stepPointer, this.dmat, ctab, this.nodeToStep).length;
                        int bonds = 0;
                        for (j5 = 0; j5 < ctab[i9].length; ++j5) {
                            if (this.nodeToStep[ctab[i9][j5]] <= -1) continue;
                            ++bonds;
                        }
                        if (bonds > 0) {
                            MinkowskiBuilder.this.debug.print("<TABLE>");
                            MinkowskiBuilder.this.debug.print("<TR><TD><B>Atom: " + i9 + "</B></TD><TD></B> Bonds: <B>" + bonds + "</B> Metrids: <B>" + mets + "</B> Rang: <B>" + atomRang[i9] + "</B></TD></TR>");
                            MinkowskiBuilder.this.debug.print("<TR><TD></TD><TD>");
                            for (j5 = 0; j5 < this.nodes; ++j5) {
                                if (this.nodeToStep[j5] == -1 || this.dmat[i9][j5] == 0.0) continue;
                                MinkowskiBuilder.this.debug.println("<B>to atom " + j5 + "</B> Placed: " + this.nodeToStep[j5] + " Metrif: " + this.dmat[i9][j5] + " (flag: " + this.dmatf[i9][j5] + ") ");
                            }
                            MinkowskiBuilder.this.debug.println("</TD></TR></TABLE>");
                        }
                        if (atomRang[i9] > maxRang) {
                            absMaxRang = atomRang[i9];
                        }
                        if ((mets < Math.min(3, stepPointer) && mets <= metDef || atomRang[i9] <= maxRang) && (metDef >= 3 || mets <= metDef) || bonds <= 0) continue;
                        maxRang = atomRang[i9];
                        metDef = mets;
                    }
                    MinkowskiBuilder.this.debug.println("Rang to place: " + maxRang);
                    boolean placed = false;
                    for (i8 = 0; i8 < this.nodes; ++i8) {
                        inNextLayer[i8] = false;
                        if (atomRang[i8] != maxRang || this.nodeToStep[i8] != -1 || absMaxRang != maxRang && placed) continue;
                        for (int j6 = 0; j6 < ctab[i8].length; ++j6) {
                            if (this.nodeToStep[ctab[i8][j6]] <= -1) continue;
                            inNextLayer[i8] = true;
                            j6 = this.nodes;
                            placed = true;
                        }
                    }
                    MinkowskiBuilder.this.debug.print("Atoms to place: ");
                    for (i8 = 0; i8 < this.nodes; ++i8) {
                        if (!inNextLayer[i8]) continue;
                        MinkowskiBuilder.this.debug.print(i8 + " ");
                    }
                    MinkowskiBuilder.this.debug.println();
                    while (placed) {
                        placed = false;
                        int atNo = 0;
                        int atB = 0;
                        int atM = 0;
                        for (int i10 = 0; i10 < this.nodes; ++i10) {
                            if (!inNextLayer[i10]) continue;
                            int metrids = 0;
                            for (int j7 = 0; j7 < this.nodes; ++j7) {
                                if (this.nodeToStep[j7] <= -1 || this.dmat[i10][j7] == 0.0) continue;
                                ++metrids;
                            }
                            int bonds = 0;
                            for (int j8 = 0; j8 < ctab[i10].length; ++j8) {
                                if (this.nodeToStep[ctab[i10][j8]] <= -1) continue;
                                ++bonds;
                            }
                            if (placed && atB >= bonds && (atB != bonds || atM >= metrids)) continue;
                            atB = bonds;
                            atM = metrids;
                            atNo = i10;
                            placed = true;
                        }
                        if (!placed) continue;
                        found = true;
                        MinkowskiBuilder.this.debug.println("Atom #" + atNo + " B:" + atB + " M: " + atM + "  step: " + stepPointer);
                        inNextLayer[atNo] = false;
                        this.stepToNode[stepPointer] = atNo;
                        this.nodeToStep[atNo] = stepPointer++;
                    }
                    this.partialFlag[stepPointer - 1] = true;
                    MinkowskiBuilder.this.debug.println("Partial flag set to step: " + (stepPointer - 1));
                    MinkowskiBuilder.this.debug.println("Sequence");
                    MinkowskiBuilder.this.debug.println("Node to step");
                    MinkowskiBuilder.this.debug.printVector(this.nodeToStep);
                    MinkowskiBuilder.this.debug.println("Step to Node");
                    MinkowskiBuilder.this.debug.printVector(this.stepToNode);
                    MinkowskiBuilder.this.debug.printHR();
                }
                MinkowskiBuilder.this.debug.decLevel();
            }
        }

        void generateSequence4() {
            if (this.initSequence()) {
                int i;
                int j;
                int i2;
                int i3;
                BondTable btab = this.m.getBondTable();
                int[][] ctab = this.m.getCtab();
                MinkowskiBuilder.this.debug.incLevel("Generate placement sequence");
                MinkowskiBuilder.this.debug.incLevel("Bond table");
                MinkowskiBuilder.this.debug.printMatrix(btab);
                MinkowskiBuilder.this.debug.decLevel();
                MinkowskiBuilder.this.debug.incLevel("Connection table");
                MinkowskiBuilder.this.debug.printMatrix(ctab);
                MinkowskiBuilder.this.debug.decLevel();
                for (int i4 = 0; i4 < this.nodes; ++i4) {
                    this.stepToNode[i4] = -1;
                    this.nodeToStep[i4] = -1;
                    this.partialFlag[i4] = false;
                }
                MinkowskiBuilder.this.debug.println("<CENTER><B>Locate initial central node</B></CENTER>");
                int centralCandidate = 0;
                int maxB = -1;
                int maxM = 0;
                for (int i5 = 0; i5 < this.nodes; ++i5) {
                    int metrids = 0;
                    for (int j2 = 0; j2 < this.nodes; ++j2) {
                        if (this.dmat[i5][j2] == 0.0) continue;
                        ++metrids;
                    }
                    if (ctab[i5].length <= maxB && (ctab[i5].length != maxB || metrids <= maxM)) continue;
                    centralCandidate = i5;
                    maxB = ctab[i5].length;
                    maxM = metrids;
                }
                MinkowskiBuilder.this.debug.println("Central cndidate atom: " + centralCandidate);
                MinkowskiBuilder.this.debug.println("All bonds defined:     " + maxB);
                MinkowskiBuilder.this.debug.println("All metrids defined:   " + maxM);
                MinkowskiBuilder.this.debug.println("<CENTER><B>Classify atoms</B></CENTER>");
                MinkowskiBuilder.this.debug.println("Layered clippping chain atoms and locate in-layer central candidates");
                boolean[] isChain = new boolean[this.nodes];
                boolean[] inNextLayer = new boolean[this.nodes];
                for (int i6 = 0; i6 < this.nodes; ++i6) {
                    isChain[i6] = false;
                }
                boolean found = true;
                while (found) {
                    found = false;
                    for (i3 = 0; i3 < this.nodes; ++i3) {
                        int ncNeigh = 0;
                        for (int j3 = 0; j3 < ctab[i3].length; ++j3) {
                            if (isChain[ctab[i3][j3]]) continue;
                            ++ncNeigh;
                        }
                        inNextLayer[i3] = ncNeigh <= 1;
                    }
                    boolean mflag = true;
                    for (i2 = 0; i2 < this.nodes; ++i2) {
                        if (!inNextLayer[i2] || isChain[i2]) continue;
                        isChain[i2] = true;
                        found = true;
                        int metrids = 0;
                        for (j = 0; j < this.nodes; ++j) {
                            if (this.dmat[i2][j] == 0.0) continue;
                            ++metrids;
                        }
                        if (!mflag && ctab[i2].length <= maxB && (ctab[i2].length != maxB || metrids <= maxM)) continue;
                        centralCandidate = i2;
                        maxB = ctab[i2].length;
                        maxM = metrids;
                        mflag = false;
                    }
                    MinkowskiBuilder.this.debug.print("Layer atoms: ");
                    for (i2 = 0; i2 < this.nodes; ++i2) {
                        if (!inNextLayer[i2]) continue;
                        MinkowskiBuilder.this.debug.print(i2 + " ");
                    }
                    MinkowskiBuilder.this.debug.println();
                    MinkowskiBuilder.this.debug.println("Central cndidate atom: " + centralCandidate);
                    MinkowskiBuilder.this.debug.println("All bonds defined:     " + maxB);
                    MinkowskiBuilder.this.debug.println("All metrids defined:   " + maxM);
                    MinkowskiBuilder.this.debug.println();
                }
                MinkowskiBuilder.this.debug.print("Chain atoms: ");
                for (i3 = 0; i3 < this.nodes; ++i3) {
                    if (!isChain[i3]) continue;
                    MinkowskiBuilder.this.debug.print(i3 + " ");
                }
                MinkowskiBuilder.this.debug.println();
                MinkowskiBuilder.this.debug.println("<CENTER><B>Ranging atoms</B></CENTER>");
                MinkowskiBuilder.this.debug.println("0:  in outer chain");
                MinkowskiBuilder.this.debug.println("1:  in inter-ring chain");
                MinkowskiBuilder.this.debug.println("2+: in ring");
                int[] atomRang = new int[this.nodes];
                for (i2 = 0; i2 < this.nodes; ++i2) {
                    atomRang[i2] = isChain[i2] ? 0 : 1;
                }
                int[][] SSSRatoms = this.m.getSSSR();
                for (int i7 = 0; i7 < SSSRatoms.length; ++i7) {
                    for (j = 0; j < SSSRatoms[i7].length; ++j) {
                        int n = SSSRatoms[i7][j];
                        atomRang[n] = atomRang[n] + 1;
                    }
                }
                MinkowskiBuilder.this.debug.println("<CENTER><B>Locate chirality centers</B></CENTER>");
                boolean[] isChiral = new boolean[this.nodes];
                for (i = 0; i < this.nodes; ++i) {
                    isChiral[i] = MinkowskiBuilder.getParity(this.m.getAtom(i)) != 0;
                }
                MinkowskiBuilder.this.debug.println("Atom rangs and chirality:");
                MinkowskiBuilder.this.debug.print("<TABLE><TR>");
                for (i = 0; i < this.nodes; ++i) {
                    MinkowskiBuilder.this.debug.print("<TD>" + i + "</TD>");
                }
                MinkowskiBuilder.this.debug.print("</TR><TR>");
                for (i = 0; i < this.nodes; ++i) {
                    MinkowskiBuilder.this.debug.print("<TD>" + atomRang[i] + "</TD>");
                }
                MinkowskiBuilder.this.debug.print("</TR><TR>");
                for (i = 0; i < this.nodes; ++i) {
                    MinkowskiBuilder.this.debug.print("<TD>" + (isChiral[i] ? "C" : "") + "</TD>");
                }
                MinkowskiBuilder.this.debug.println("</TR></TABLE>");
                MinkowskiBuilder.this.debug.println("<CENTER><B>Final centrum search</B></CENTER>");
                int centrumRang = 0;
                for (int i8 = 0; i8 < this.nodes; ++i8) {
                    int metrids = 0;
                    for (int j4 = 0; j4 < this.nodes; ++j4) {
                        if (this.dmat[i8][j4] == 0.0) continue;
                        ++metrids;
                    }
                    boolean update = false;
                    if (centrumRang < atomRang[i8]) {
                        update = true;
                    } else if (centrumRang == atomRang[i8] && centrumRang > 0) {
                        if (maxB < ctab[i8].length) {
                            update = true;
                        } else if (maxB == ctab[i8].length && metrids > maxM) {
                            update = true;
                        }
                    }
                    if (!update) continue;
                    centralCandidate = i8;
                    maxB = ctab[i8].length;
                    maxM = metrids;
                    centrumRang = atomRang[i8];
                }
                MinkowskiBuilder.this.debug.println("Central cndidate atom: " + centralCandidate);
                MinkowskiBuilder.this.debug.println("All bonds defined:     " + maxB);
                MinkowskiBuilder.this.debug.println("All metrids defined:   " + maxM);
                MinkowskiBuilder.this.debug.println("Centrum rang:          " + centrumRang);
                MinkowskiBuilder.this.debug.println();
                MinkowskiBuilder.this.debug.println();
                MinkowskiBuilder.this.debug.println("<CENTER><B>Iterative layered placement</B></CENTER>");
                int stepPointer = 0;
                this.stepToNode[stepPointer] = centralCandidate;
                this.nodeToStep[centralCandidate] = stepPointer++;
                MinkowskiBuilder.this.debug.println("Place centrum");
                MinkowskiBuilder.this.debug.println();
                found = true;
                while (found) {
                    int i9;
                    int j5;
                    MinkowskiBuilder.this.debug.println("Layer start");
                    found = false;
                    int maxRang = 0;
                    int metDef = 0;
                    for (int i10 = 0; i10 < this.nodes; ++i10) {
                        int mets = 0;
                        for (j5 = 0; j5 < this.nodes; ++j5) {
                            if (this.nodeToStep[j5] == -1 || this.dmat[i10][j5] == 0.0) continue;
                            ++mets;
                        }
                        if ((mets < Math.min(3, stepPointer) && mets <= metDef || atomRang[i10] <= maxRang) && (metDef >= 3 || mets <= metDef) || this.nodeToStep[i10] != -1) continue;
                        for (j5 = 0; j5 < ctab[i10].length; ++j5) {
                            if (this.nodeToStep[ctab[i10][j5]] <= -1) continue;
                            maxRang = atomRang[i10];
                            metDef = mets;
                            j5 = this.nodes;
                        }
                    }
                    MinkowskiBuilder.this.debug.println("Rang to place: " + maxRang);
                    boolean placed = false;
                    for (i9 = 0; i9 < this.nodes; ++i9) {
                        inNextLayer[i9] = false;
                        if (atomRang[i9] != maxRang || this.nodeToStep[i9] != -1) continue;
                        for (j5 = 0; j5 < ctab[i9].length; ++j5) {
                            if (this.nodeToStep[ctab[i9][j5]] <= -1) continue;
                            inNextLayer[i9] = true;
                            j5 = this.nodes;
                            placed = true;
                        }
                    }
                    MinkowskiBuilder.this.debug.print("Atoms to place: ");
                    for (i9 = 0; i9 < this.nodes; ++i9) {
                        if (!inNextLayer[i9]) continue;
                        MinkowskiBuilder.this.debug.print(i9 + " ");
                    }
                    MinkowskiBuilder.this.debug.println();
                    while (placed) {
                        placed = false;
                        int atNo = 0;
                        int atB = 0;
                        int atM = 0;
                        for (int i11 = 0; i11 < this.nodes; ++i11) {
                            if (!inNextLayer[i11]) continue;
                            int metrids = 0;
                            for (int j6 = 0; j6 < this.nodes; ++j6) {
                                if (this.nodeToStep[j6] <= -1 || this.dmat[i11][j6] == 0.0) continue;
                                ++metrids;
                            }
                            int bonds = 0;
                            for (int j7 = 0; j7 < ctab[i11].length; ++j7) {
                                if (this.nodeToStep[ctab[i11][j7]] <= -1) continue;
                                ++bonds;
                            }
                            if (placed && atB >= bonds && (atB != bonds || atM >= metrids)) continue;
                            atB = bonds;
                            atM = metrids;
                            atNo = i11;
                            placed = true;
                        }
                        if (!placed) continue;
                        found = true;
                        MinkowskiBuilder.this.debug.println("Atom #" + atNo + " B:" + atB + " M: " + atM + "  step: " + stepPointer);
                        inNextLayer[atNo] = false;
                        this.stepToNode[stepPointer] = atNo;
                        this.nodeToStep[atNo] = stepPointer++;
                    }
                    this.partialFlag[stepPointer - 1] = true;
                    MinkowskiBuilder.this.debug.println("Partial flag set to step: " + (stepPointer - 1));
                    MinkowskiBuilder.this.debug.println("Sequence");
                    MinkowskiBuilder.this.debug.println("Node to step");
                    MinkowskiBuilder.this.debug.printVector(this.nodeToStep);
                    MinkowskiBuilder.this.debug.println("Step to Node");
                    MinkowskiBuilder.this.debug.printVector(this.stepToNode);
                    MinkowskiBuilder.this.debug.printHR();
                }
                MinkowskiBuilder.this.debug.decLevel();
            }
        }

        void generateSequenceAdvanced() {
            if (this.initSequence()) {
                int i;
                int j;
                BondTable btab = this.m.getBondTable();
                int[][] ctab = this.m.getCtab();
                MinkowskiBuilder.this.debug.incLevel("Generate placement sequence");
                MinkowskiBuilder.this.debug.incLevel("Bond table");
                MinkowskiBuilder.this.debug.printMatrix(btab);
                MinkowskiBuilder.this.debug.decLevel();
                MinkowskiBuilder.this.debug.incLevel("Connection table");
                MinkowskiBuilder.this.debug.printMatrix(ctab);
                MinkowskiBuilder.this.debug.decLevel();
                for (int i2 = 0; i2 < this.nodes; ++i2) {
                    this.stepToNode[i2] = -1;
                    this.nodeToStep[i2] = -1;
                    this.partialFlag[i2] = false;
                }
                MinkowskiBuilder.this.debug.incLevel("Clipping chain atoms");
                boolean clipped = true;
                int stepPointer = this.nodes - 1;
                int stepPointerPrevious = this.nodes;
                boolean[] toClip = new boolean[this.nodes];
                while (clipped) {
                    clipped = false;
                    if (stepPointer >= 0) {
                        this.partialFlag[stepPointer] = true;
                    }
                    int toClips = 0;
                    for (int i3 = 0; i3 < this.nodes; ++i3) {
                        int nonClippedNeighbors = 0;
                        if (this.nodeToStep[i3] == -1) {
                            for (j = 0; j < ctab[i3].length; ++j) {
                                if (this.nodeToStep[ctab[i3][j]] != -1) continue;
                                ++nonClippedNeighbors;
                            }
                        }
                        if (nonClippedNeighbors == 1) {
                            toClip[i3] = true;
                            ++toClips;
                            continue;
                        }
                        toClip[i3] = false;
                    }
                    int tc = toClips;
                    while (tc > 0) {
                        int maxMetrids = -1;
                        int maxMetridsA = -1;
                        int maxMetridsI = -1;
                        for (i = 0; i < this.nodes; ++i) {
                            if (!toClip[i]) continue;
                            int metrids = 0;
                            int metridsA = 0;
                            for (int j2 = 0; j2 < this.nodes; ++j2) {
                                if (this.nodeToStep[j2] == -1 && this.dmat[i][j2] != 0.0) {
                                    ++metrids;
                                }
                                if (this.dmat[i][j2] == 0.0) continue;
                                ++metridsA;
                            }
                            if (maxMetrids != -1 && maxMetrids >= metrids && (maxMetrids != metrids || maxMetridsA >= metridsA)) continue;
                            maxMetrids = metrids;
                            maxMetridsI = i;
                            maxMetridsA = metridsA;
                        }
                        MinkowskiBuilder.this.debug.println("sp " + stepPointer + " tc " + tc);
                        this.stepToNode[stepPointer - tc + 1] = maxMetridsI;
                        this.nodeToStep[this.stepToNode[stepPointer - tc + 1]] = maxMetridsI;
                        toClip[maxMetridsI] = false;
                        clipped = true;
                        MinkowskiBuilder.this.debug.println("Clipped node: " + maxMetridsI + "stepPointer: " + (stepPointer - --tc + 1));
                    }
                    stepPointer -= toClips;
                    MinkowskiBuilder.this.debug.incLevel("Sequence");
                    MinkowskiBuilder.this.debug.println("Node to step");
                    MinkowskiBuilder.this.debug.printVector(this.nodeToStep);
                    MinkowskiBuilder.this.debug.println("Step to Node");
                    MinkowskiBuilder.this.debug.printVector(this.stepToNode);
                    MinkowskiBuilder.this.debug.decLevel();
                    stepPointerPrevious = stepPointer + 1;
                    MinkowskiBuilder.this.debug.printHR();
                }
                MinkowskiBuilder.this.debug.decLevel();
                if (stepPointer >= 0) {
                    MinkowskiBuilder.this.debug.incLevel("Generate sequence for ring set.");
                    MinkowskiBuilder.this.debug.incLevel("Ranging ring atoms");
                    int[] ringNumber = new int[this.nodes];
                    int[][] sssrAtoms = this.m.getSSSR();
                    for (int i4 = 0; i4 < sssrAtoms.length; ++i4) {
                        for (j = 0; j < sssrAtoms[i4].length; ++j) {
                            int n = sssrAtoms[i4][j];
                            if (n >= this.nodes) {
                                MinkowskiBuilder.this.debug.reportError("sssrAtoms[i][j] >= nodes");
                                continue;
                            }
                            int n2 = n;
                            ringNumber[n2] = ringNumber[n2] + 1;
                        }
                    }
                    MinkowskiBuilder.this.debug.println("Ring rangs:");
                    MinkowskiBuilder.this.debug.printVector(ringNumber);
                    MinkowskiBuilder.this.debug.decLevel();
                    MinkowskiBuilder.this.debug.println("Looking for centrum node");
                    int centrumCandidate = -1;
                    int centrumRingNo = 0;
                    int centrumConnections = 0;
                    for (i = 0; i < this.nodes; ++i) {
                        int connRang = ctab[i].length;
                        if (centrumRingNo > ringNumber[i] && (centrumRingNo != ringNumber[i] || connRang <= centrumConnections)) continue;
                        centrumCandidate = i;
                        centrumRingNo = ringNumber[i];
                        centrumConnections = connRang;
                    }
                    if (centrumCandidate == -1) {
                        MinkowskiBuilder.this.debug.reportError("Not found a centrum.");
                    }
                    MinkowskiBuilder.this.debug.println("Centrum node: " + centrumCandidate);
                    stepPointer = 0;
                    this.stepToNode[stepPointer] = centrumCandidate;
                    this.nodeToStep[this.stepToNode[stepPointer]] = stepPointer;
                    ++stepPointer;
                    MinkowskiBuilder.this.debug.println("Generate sequence for the ringset");
                    boolean placed = true;
                    while (placed) {
                        int i5;
                        MinkowskiBuilder.this.debug.println("Placement round start.");
                        placed = false;
                        int maxRingNumber = -1;
                        for (int i6 = 0; i6 < this.nodes; ++i6) {
                            if (this.nodeToStep[i6] != -1 || ringNumber[i6] <= maxRingNumber) continue;
                            boolean proper = false;
                            for (int j3 = 0; j3 < ctab[i6].length && !proper; ++j3) {
                                if (this.nodeToStep[ctab[i6][j3]] >= stepPointer || this.nodeToStep[ctab[i6][j3]] < 0) continue;
                                proper = true;
                            }
                            if (!proper) continue;
                            maxRingNumber = ringNumber[i6];
                        }
                        if (maxRingNumber <= -1) continue;
                        MinkowskiBuilder.this.debug.println("Placing atoms with ringnumber: " + maxRingNumber);
                        stepPointerPrevious = stepPointer;
                        int maxConnI = -1;
                        int maxBonds = -1;
                        int maxMetrids = -1;
                        for (i5 = 0; i5 < this.nodes; ++i5) {
                            if (this.nodeToStep[i5] != -1 || ringNumber[i5] != maxRingNumber) continue;
                            boolean proper = false;
                            int bonds = 0;
                            for (int j4 = 0; j4 < ctab[i5].length && !proper; ++j4) {
                                if (this.nodeToStep[ctab[i5][j4]] >= stepPointer || this.nodeToStep[ctab[i5][j4]] < 0) continue;
                                proper = true;
                                ++bonds;
                            }
                            if (!proper) continue;
                            int metrids = 0;
                            for (int j5 = 0; j5 < stepPointer; ++j5) {
                                if (this.nodeToStep[j5] < 0 || this.dmat[i5][j5] == 0.0) continue;
                                ++metrids;
                            }
                            if (maxConnI != -1 && maxBonds >= bonds && (maxBonds != bonds || maxMetrids >= metrids)) continue;
                            maxConnI = i5;
                            maxBonds = bonds;
                            maxMetrids = metrids;
                        }
                        if (maxConnI >= 0) {
                            placed = true;
                            MinkowskiBuilder.this.debug.println("Place #" + maxConnI + " rn:" + ringNumber[maxConnI]);
                            this.stepToNode[stepPointer++] = maxConnI;
                        }
                        for (i5 = stepPointerPrevious; i5 < stepPointer; ++i5) {
                            this.nodeToStep[this.stepToNode[i5]] = i5;
                        }
                        this.partialFlag[stepPointer - 1] = true;
                        MinkowskiBuilder.this.debug.incLevel("Sequence");
                        MinkowskiBuilder.this.debug.println("Node to step");
                        MinkowskiBuilder.this.debug.printVector(this.nodeToStep);
                        MinkowskiBuilder.this.debug.println("Step to Node");
                        MinkowskiBuilder.this.debug.printVector(this.stepToNode);
                        MinkowskiBuilder.this.debug.decLevel();
                        stepPointerPrevious = stepPointer;
                        MinkowskiBuilder.this.debug.printHR();
                    }
                    MinkowskiBuilder.this.debug.decLevel();
                    MinkowskiBuilder.this.debug.decLevel();
                }
                MinkowskiBuilder.this.debug.decLevel();
            }
        }

        void generateSequenceBasic(BitSet[] distA) {
            if (this.initSequence()) {
                int i;
                BondTable btab = this.m.getBondTable();
                int[][] ctab = this.m.getCtab();
                MinkowskiBuilder.this.debug.incLevel("Generate placement sequence");
                MinkowskiBuilder.this.debug.incLevel("Bond table");
                MinkowskiBuilder.this.debug.printMatrix(btab);
                MinkowskiBuilder.this.debug.decLevel();
                for (int i2 = 0; i2 < this.nodes; ++i2) {
                    this.partialFlag[i2] = true;
                    this.stepToNode[i2] = 0;
                    this.nodeToStep[i2] = -2;
                }
                int maxCon = 0;
                int iNext = 0;
                for (i = 0; i < this.nodes; ++i) {
                    if (ctab[i].length <= maxCon) continue;
                    maxCon = ctab[i].length;
                    iNext = i;
                }
                this.nodeToStep[iNext] = 0;
                this.stepToNode[iNext] = 0;
                i = 1;
                while (i < this.nodes) {
                    int j;
                    for (j = 0; j < this.nodes; ++j) {
                        if (distA[iNext].get(j)) {
                            int n = j;
                            this.stepToNode[n] = this.stepToNode[n] + 1;
                        }
                        if (btab.getBondIndex(iNext, j) == -1 || this.nodeToStep[j] != -2) continue;
                        int n = j;
                        this.nodeToStep[n] = this.nodeToStep[n] + 1;
                    }
                    maxCon = -1;
                    iNext = -1;
                    for (j = 0; j < this.nodes; ++j) {
                        if (this.stepToNode[j] <= maxCon || this.nodeToStep[j] != -1) continue;
                        maxCon = this.stepToNode[j];
                        iNext = j;
                    }
                    if (iNext == -1) {
                        MinkowskiBuilder.this.debug.println("ERROR! placement sequence cannot generated. exiting.");
                        System.exit(1);
                    }
                    this.nodeToStep[iNext] = i++;
                }
                MinkowskiBuilder.this.debug.incLevel("Atom hierarchy");
                MinkowskiBuilder.this.debug.printVector(this.nodeToStep);
                MinkowskiBuilder.this.debug.decLevel();
                for (i = 0; i < this.nodes; ++i) {
                    this.stepToNode[this.nodeToStep[i]] = i;
                }
                MinkowskiBuilder.this.debug.incLevel("Placement sequence");
                MinkowskiBuilder.this.debug.printVector(this.stepToNode);
                MinkowskiBuilder.this.debug.decLevel();
                MinkowskiBuilder.this.debug.decLevel();
            }
        }
    }
}

