/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.build;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.CleanSettings;
import chemaxon.marvin.modelling.build.BuildCommand;
import chemaxon.marvin.modelling.build.BuildCommandBase;
import chemaxon.marvin.modelling.build.BuildSequence;
import chemaxon.marvin.modelling.build.FragClean;
import chemaxon.marvin.modelling.build.FragFragFuseBuildCommand;
import chemaxon.marvin.modelling.build.PermutateBuildCommand;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.linalg.V;
import chemaxon.marvin.modelling.struc.myMolecule;
import chemaxon.marvin.modelling.util.U;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.SelectionMolecule;

public class OABuildCommand
extends BuildCommand {
    BuildSequence.Build cmd = null;
    BuildCommand fusec = null;
    int[] oa1InExtMol = null;
    int[] oa1BaseInExt = null;
    int[] oa2InExtMol = null;
    int[] oa2BaseInExt = null;
    IntVector[] oa1set = null;
    IntVector[] oa2set = null;
    int[] extmolToFused = null;
    boolean hasOA = false;

    @Override
    boolean hasDirectBuildChildFailed() {
        return this.fusec.hasDirectFragmentBuildChildFailed_0();
    }

    public OABuildCommand(BuildCommand parent, CleanSettings settings, BuildSequence.BuildFuse cmd) {
        super(settings);
        int i;
        int i2;
        debugPrintout debug = CleanArgs.getDebug();
        int[] oa = cmd.getResolvedOA();
        int[][] ghosts = cmd.getGhostBonds();
        if (oa != null && oa.length > 0) {
            this.hasOA = true;
        }
        if (oa == null) {
            oa = new int[]{};
        }
        if (debug != null) {
            debug.println("OA fuse command init");
            debug.print("<UL>");
            debug.print("<LI>Construct extended fragment molecule<BR>");
        }
        this.cmd = new BuildSequence.SimpleBuild(cmd.getAtoms(), U.remove(cmd.getAnchAtoms(), oa), U.appendUnique(cmd.getNonAnchAtoms(), oa), cmd.getMol(), cmd.getWholeStereo());
        BuildSequence.Build f1 = cmd.getFrag1();
        BuildSequence.Build f2 = cmd.getFrag2();
        this.setParentCommand(parent);
        Molecule m = cmd.getFragMol();
        myMolecule basemol = f1.getMol();
        if (debug != null) {
            f1.getMol().placeApplet("basemol/f1");
        }
        Molecule extmol = new Molecule();
        m.clonecopy(extmol);
        if (m.getAtomCount() != cmd.getAtoms().length) {
            System.err.println("Error! Atom count mismatch in OABuildCommand");
        }
        int[] cmdatomlist = cmd.getAtoms();
        this.oa1InExtMol = new int[oa.length];
        this.oa1BaseInExt = new int[oa.length];
        this.oa2InExtMol = new int[oa.length];
        this.oa2BaseInExt = new int[oa.length];
        int[] cmdai = cmd.getAtomsInv();
        for (i2 = 0; i2 < oa.length; ++i2) {
            this.oa1InExtMol[i2] = cmdai[oa[i2]];
            this.oa1BaseInExt[i2] = cmdai[f1.getAnchorBase(oa[i2])];
            this.oa2BaseInExt[i2] = cmdai[f2.getAnchorBase(oa[i2])];
        }
        if (ghosts != null) {
            for (i2 = 0; i2 < ghosts.length; ++i2) {
                extmol.removeBond(extmol.getBondTable().getBondIndex(cmdai[ghosts[i2][0]], cmdai[ghosts[i2][1]]));
            }
        }
        for (i2 = 0; i2 < oa.length; ++i2) {
            MolAtom na = new MolAtom(1);
            extmol.add(na);
            this.oa2InExtMol[i2] = extmol.getAtomCount() - 1;
            extmol.add(new MolBond(extmol.getAtom(this.oa2BaseInExt[i2]), na));
            extmol.removeBond(extmol.getBondTable().getBondIndex(this.oa2BaseInExt[i2], this.oa1InExtMol[i2]));
        }
        for (i2 = 0; i2 < oa.length; ++i2) {
            MolAtom aa = extmol.getAtom(this.oa1InExtMol[i2]);
            aa.setAtno(1);
            int[] neighs = extmol.getCtab()[this.oa1InExtMol[i2]];
            for (int j = 0; j < neighs.length; ++j) {
                if (neighs[j] == this.oa1BaseInExt[i2]) continue;
                extmol.removeBond(extmol.getBondTable().getBondIndex(neighs[j], this.oa1InExtMol[i2]));
            }
        }
        SelectionMolecule sextm = new SelectionMolecule();
        extmol.clonecopy(sextm);
        myMolecule extm = new myMolecule(sextm, debug, this.cleanSettings);
        if (debug != null) {
            extm.placeApplet("Extended molecule");
        }
        int[] perm1 = new int[basemol.a];
        int[] perm2 = new int[basemol.a];
        for (i = 0; i < perm1.length; ++i) {
            perm1[i] = -1;
            perm2[i] = -1;
        }
        for (i = 0; i < perm1.length; ++i) {
            perm1[i] = cmdai[i];
        }
        for (i = 0; i < perm2.length; ++i) {
            perm2[i] = cmdai[i];
        }
        for (i = 0; i < oa.length; ++i) {
            perm2[oa[i]] = this.oa2InExtMol[i];
        }
        if (debug != null) {
            debug.printBC("Fill anchor sets");
        }
        this.oa1set = new IntVector[oa.length];
        this.oa2set = new IntVector[oa.length];
        for (i = 0; i < oa.length; ++i) {
            int s;
            int j;
            if (debug != null) {
                debug.printB("OA nchor #" + i);
            }
            this.oa1set[i] = new IntVector();
            this.oa2set[i] = new IntVector();
            int b = extm.bdesc[extm.bonds[this.oa1BaseInExt[i]][this.oa1InExtMol[i]]];
            if (debug != null) {
                debug.println("Fill set 1");
                debug.println("1 In extmol: " + this.oa1InExtMol[i]);
                debug.println("bdesc=" + b);
            }
            for (j = 0; j < extm.ctab[this.oa1BaseInExt[i]].length; ++j) {
                s = extm.ctab[this.oa1BaseInExt[i]][j];
                if (extm.ctab[s].length != 1 || extm.anum[s] != 1 || b != extm.bdesc[extm.bonds[s][this.oa1BaseInExt[i]]]) continue;
                if (debug != null) {
                    debug.println("Add " + s);
                }
                this.oa1set[i].add(s);
            }
            b = extm.bdesc[extm.bonds[this.oa2BaseInExt[i]][this.oa2InExtMol[i]]];
            if (debug != null) {
                debug.println("Fill set 2");
                debug.println("2 In extmol: " + this.oa2InExtMol[i]);
                debug.println("bdesc=" + b);
            }
            for (j = 0; j < extm.ctab[this.oa2BaseInExt[i]].length; ++j) {
                s = extm.ctab[this.oa2BaseInExt[i]][j];
                if (extm.ctab[s].length != 1 || extm.anum[s] != 1 || b != extm.bdesc[extm.bonds[s][this.oa2BaseInExt[i]]]) continue;
                if (debug != null) {
                    debug.println("Add " + s);
                }
                this.oa2set[i].add(s);
            }
        }
        if (debug != null) {
            this.getFragment().getFragMol().placeApplet("Fragment");
            debug.print("<LI>Create build command for left fragment<BR>");
            debug.println("Create base build command");
        }
        BuildCommand builder1 = FragClean.createBuildCommand(this, settings, f1, cmd.getMol(), debug);
        if (debug != null) {
            debug.println("Create permutate command");
        }
        PermutateBuildCommand p1 = new PermutateBuildCommand(builder1, settings, extm, perm1, true);
        if (debug != null) {
            debug.print("</LI><LI>Create build command for right fragment<BR>");
            debug.println("Create base build command");
        }
        BuildCommand builder2 = FragClean.createBuildCommand(this, settings, f2, cmd.getMol(), debug);
        if (debug != null) {
            debug.println("Create permutate command");
        }
        PermutateBuildCommand p2 = new PermutateBuildCommand(builder2, settings, extm, perm2, true);
        if (debug != null) {
            debug.print("</LI><LI>Construct fuse<BR>");
        }
        BuildSequence.BuildFuse fcmd = new BuildSequence.BuildFuse(p1.getCommand(), p2.getCommand());
        fcmd.setEmptyStereo();
        this.fusec = new FragFragFuseBuildCommand(null, settings, fcmd, extm, debug);
        this.extmolToFused = this.fusec.getCommand().getAtomsInv();
        if (debug != null) {
            debug.printB("Constructing OABuildCommand");
        }
        if (debug != null) {
            debug.print("</LI></UL>");
        }
    }

    @Override
    void initProgressMonitor() {
        throw new UnsupportedOperationException();
    }

    @Override
    myMolecule getOrigMol() {
        return this.getCommand().getMol();
    }

    @Override
    BuildSequence.Build getCommand() {
        return this.cmd;
    }

    @Override
    int invokeBuild(int expectedConformerCount, BuildCommandBase.BuildEffort effort) {
        debugPrintout debug = CleanArgs.getDebug();
        if (debug != null) {
            debug.printBC("InvokeBuild in OA");
            debug.println("Invoke underlying");
        }
        this.fusec.doSkipProxBlenEqCheck();
        int ret = this.fusec.build(expectedConformerCount, true, true, false, effort);
        if (ret != 1) {
            return ret;
        }
        double[][][] nc = U.clone(this.fusec.getMoreCoordinates());
        double[][][] c = new double[nc.length][][];
        int atct = this.getAtomList().length;
        if (debug != null) {
            debug.println("Generated: " + nc.length + " new conformers");
        }
        for (int i = 0; i < c.length; ++i) {
            int j;
            if (debug != null) {
                debug.printB("Match in conformer " + i);
            }
            for (j = 0; j < this.oa1BaseInExt.length; ++j) {
                if (debug != null) {
                    debug.println("Match oa " + j);
                    debug.println("anchor 1 group size: " + this.oa1set[j].size());
                    debug.println("anchor 2 group size: " + this.oa2set[j].size());
                }
                double[] best = null;
                double mind = -1.0;
                int best1index = -1;
                int best2index = -1;
                double[] base1 = nc[i][this.extmolToFused[this.oa1BaseInExt[j]]];
                double[] base2 = nc[i][this.extmolToFused[this.oa2BaseInExt[j]]];
                for (int a = 0; a < this.oa1set[j].size(); ++a) {
                    double[] h1 = nc[i][this.extmolToFused[this.oa1set[j].get(a)]];
                    double[] h1v = V.minus(h1, base1);
                    V.normalize(h1v);
                    h1v = V.dot(1.5, h1v);
                    h1 = V.plus(h1v, base1);
                    for (int b = 0; b < this.oa2set[j].size(); ++b) {
                        double[] h2 = nc[i][this.extmolToFused[this.oa2set[j].get(b)]];
                        double[] h2v = V.minus(h2, base2);
                        V.normalize(h2v);
                        h2v = V.dot(1.5, h2v);
                        h2 = V.plus(h2v, base2);
                        double d = V.dot(V.minus(h1, h2));
                        if (!(mind < 0.0) && !(d < mind)) continue;
                        mind = d;
                        best = V.dot(0.5, V.plus(h1, h2));
                        best1index = this.oa1set[j].get(a);
                        best2index = this.oa2set[j].get(b);
                    }
                }
                if (debug != null) {
                    debug.println("Best1 in ext: " + best1index);
                    debug.println("Best2 in ext: " + best2index);
                }
                if (best1index != this.oa1InExtMol[j]) {
                    double[] tmp = nc[i][this.extmolToFused[best1index]];
                    nc[i][this.extmolToFused[best1index]] = nc[i][this.extmolToFused[this.oa1InExtMol[j]]];
                    nc[i][this.extmolToFused[this.oa1InExtMol[j]]] = tmp;
                }
                if (best2index != this.oa2InExtMol[j]) {
                    double[] tmp = nc[i][this.extmolToFused[best2index]];
                    nc[i][this.extmolToFused[best2index]] = nc[i][this.extmolToFused[this.oa2InExtMol[j]]];
                    nc[i][this.extmolToFused[this.oa2InExtMol[j]]] = tmp;
                }
                nc[i][this.oa1InExtMol[j]] = best;
            }
            c[i] = new double[atct][];
            for (j = 0; j < atct; ++j) {
                c[i][j] = U.clone(nc[i][this.extmolToFused[j]]);
            }
        }
        this.registerCoordinates(c);
        return 1;
    }
}

