/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.build.fafuse;

import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.linalg.multiDim;

public class FragmentAtomFinalItem {
    public int no = -1;
    public boolean opt_required = false;
    public boolean[] opt_required_selection = null;
    public static final int P_DONE = 1;
    public static final int P_INSP = 2;
    public static final int P_NEWD_PLUS = 3;
    public static final int P_NEWD_PLUSMINUS = 4;
    public static final int P_OPTIMIZED = 5;
    public int state = 0;
    public double[] extraAtomC = null;
    public double[][] optimizedC = null;
    public double[] optimizedM = null;
    public multiDim extrac = null;
    public multiDim orthoBase = null;
    public multiDim orthoC = null;

    public boolean isOptRequired() {
        return this.opt_required;
    }

    public boolean isOptRequired(int s) {
        if (this.opt_required_selection == null || s < 0 || s >= this.opt_required_selection.length) {
            return this.opt_required;
        }
        return this.opt_required_selection[s];
    }

    public void setOptRequired(int s) {
        this.opt_required = true;
        if (this.opt_required_selection == null || this.opt_required_selection.length <= s) {
            int l = 0;
            if (this.opt_required_selection != null) {
                l = this.opt_required_selection.length;
            }
            boolean[] tmp = new boolean[Math.max(l, Math.max(s * 2, this.getSelections() * 2))];
            if (this.opt_required_selection != null) {
                for (int i = 0; i < l; ++i) {
                    tmp[i] = this.opt_required_selection[i];
                }
            }
            tmp[s] = true;
            this.opt_required_selection = tmp;
        } else {
            this.opt_required_selection[s] = true;
        }
    }

    public FragmentAtomFinalItem() {
    }

    public FragmentAtomFinalItem(int a) {
        this.no = a;
        this.state = 1;
    }

    public FragmentAtomFinalItem(int a, multiDim extrac, double[] extraac, boolean plusminus) {
        this.no = a;
        this.state = plusminus ? 4 : 3;
        this.extraAtomC = extraac;
        this.extrac = extrac;
    }

    public FragmentAtomFinalItem(int a, multiDim obase, multiDim c) {
        this.no = a;
        this.state = 2;
        this.orthoBase = obase;
        this.orthoC = c;
    }

    public FragmentAtomFinalItem(int a, double[][] oc, double[] om) {
        this.no = a;
        this.state = 5;
        this.optimizedC = oc;
        this.optimizedM = om;
    }

    public int getSelections() {
        switch (this.state) {
            case 1: {
                return 1;
            }
            case 2: {
                return this.orthoC.size();
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 1;
            }
        }
        return 0;
    }

    public void printout(debugPrintout debug) {
        debug.println("Target atom: " + this.no);
        debug.println("Selections:  " + this.getSelections());
        debug.println("Optimization required: " + this.opt_required);
        debug.println("Optimization required for selections:");
        if (this.opt_required_selection == null) {
            debug.println("null");
        } else {
            for (int i = 0; i < this.opt_required_selection.length; ++i) {
                debug.println(i + ": " + this.opt_required_selection[i]);
            }
        }
        switch (this.state) {
            case 1: {
                debug.println("State: DONE");
                break;
            }
            case 2: {
                debug.println("STATE: In-Space placement");
                debug.println("Orthogonal base:");
                this.orthoBase.printDebug(debug);
                debug.println("In space vectors (base linear combinations):");
                this.orthoC.printDebug(debug);
                break;
            }
            case 3: 
            case 4: {
                debug.println("Extra atom coordinates. Placement:" + (this.state == 3 ? "PLUS" : "PLUS/MINUS"));
                debug.println("Extra atom coordinates:");
                debug.printVector(this.extraAtomC);
                debug.println("Extra refinement coordniates:");
                this.extrac.printDebug(debug);
                break;
            }
            case 5: {
                debug.println("Optimized");
                debug.println("Optimized metric and coordinates:");
                debug.printCoord(this.optimizedC, this.optimizedM);
            }
        }
    }
}

