/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.build.fafuse;

import chemaxon.calculations.clean.Clean3D;
import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.CleanSettings;
import chemaxon.marvin.modelling.build.fafuse.FragmentAtomFinalItem;
import chemaxon.marvin.modelling.build.fafuse.FragmentAtomFuseItem;
import chemaxon.marvin.modelling.build.fafuse.FragmentAtomFuseStore;
import chemaxon.marvin.modelling.build.fafuse.FragmentStore;
import chemaxon.marvin.modelling.build.fafuse.FuseCommandSequence;
import chemaxon.marvin.modelling.build.fafuse.FuseStep;
import chemaxon.marvin.modelling.build.fafuse.SelectionTableItem;
import chemaxon.marvin.modelling.build.fafuse.WishList;
import chemaxon.marvin.modelling.debug.Printouts;
import chemaxon.marvin.modelling.debug.Tracer;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.linalg.V;
import chemaxon.marvin.modelling.struc.Fragment;
import chemaxon.marvin.modelling.struc.StereoCriteriaList;
import chemaxon.marvin.modelling.struc.myMolecule;
import chemaxon.marvin.modelling.util.ProgressMonitor;
import chemaxon.marvin.modelling.util.SimpleCanceller;
import java.util.BitSet;
import java.util.Vector;

public class FuseBuilder {
    public static final int MAKECOORDS_OK = 1;
    public static final int MAKECOORDS_FAILED = 2;
    public static final int MAKECOORDS_CANCELLED = 3;
    myMolecule mol = null;
    StereoCriteriaList stereo = null;
    int lastResult = 0;
    double[][][] lastCoords = null;
    double[] lastEnergy = null;
    private boolean maxConfCountReached = false;
    private double optimizationLimit = 0.01;
    FuseCommandSequence seq = null;

    public void setOptimizationLimit(double l) {
        this.optimizationLimit = l;
    }

    public double[] getEnergies() {
        return this.lastEnergy;
    }

    public double[][][] getCoordinates() {
        return this.lastCoords;
    }

    public double[][] getCoordinates(int confid) {
        return this.lastCoords[confid];
    }

    public int getAtomCount() {
        return this.mol.a;
    }

    public int getConfCount() {
        return this.lastCoords.length;
    }

    public FuseBuilder(myMolecule mol, StereoCriteriaList stereo) {
        this.mol = mol;
        this.stereo = stereo;
    }

    public int getLastResult() {
        return this.lastResult;
    }

    public int makeCoords2(CleanParams cparams, ProgressMonitor pmon, CleanSettings settings, boolean doConfAnal) {
        if (settings.OPT_stopper_Fusebuilder_makecoords != null) {
            settings.OPT_stopper_Fusebuilder_makecoords.start();
        }
        this.lastResult = 0;
        int ret = 0;
        if (this.mol.a == 0) {
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Empty structure");
            }
            this.lastResult = 1;
            this.lastCoords = null;
            this.lastEnergy = null;
            ret = 1;
        } else if (this.mol.a == 1) {
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("One-atom structure");
            }
            this.mol.coord[0][0] = 0.0;
            this.mol.coord[0][1] = 0.0;
            this.mol.coord[0][2] = 0.0;
            this.lastResult = 1;
            this.lastCoords = new double[1][1][3];
            this.lastEnergy = new double[1];
            ret = 1;
        } else {
            if (CleanArgs.doVerbose()) {
                CleanArgs.verboseInc("Entering method makeCoords2_0()");
            }
            ret = this.makeCoords2_0(cparams, pmon, settings, doConfAnal);
            if (CleanArgs.doVerbose()) {
                CleanArgs.verboseDec("Method makeCoords2_0() returned with " + ret);
            }
            this.lastResult = ret;
        }
        if (settings.OPT_stopper_Fusebuilder_makecoords != null) {
            settings.OPT_stopper_Fusebuilder_makecoords.stop();
        }
        return ret;
    }

    int makeCoords2_0(CleanParams cparams, ProgressMonitor pmon, CleanSettings settings, boolean doConfAnal) {
        debugPrintout debug = CleanArgs.getDebug();
        this.maxConfCountReached = false;
        SimpleCanceller canceller = settings.getCanceller();
        if (canceller != null && canceller.isCancelled()) {
            this.lastResult = 3;
            return 3;
        }
        if (debug != null && debug.getWillPrint()) {
            debug.incLevel("Parameters");
            cparams.printout(debug);
            debug.decLevel();
            debug.println("doConfAnal=" + doConfAnal);
            if (this.stereo != null) {
                this.stereo.printout(debug, this.mol);
            } else {
                debug.println("Stereo = null");
            }
        }
        if (this.seq == null) {
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Construct FuseCommandSequence");
            }
            this.seq = new FuseCommandSequence(this.mol, this.stereo, debug, 3);
        }
        if (debug != null && debug.getWillPrint()) {
            debug.incLevel("Given molecule");
            this.mol.printout(debug);
            debug.decLevel();
            debug.incLevel("Generated sequence:");
            this.seq.printout(debug);
            debug.decLevel();
        }
        if (canceller != null && canceller.isCancelled()) {
            this.lastResult = 3;
            return 3;
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Construct FragmentStore for " + cparams.OPT_CP_FRAGMULTI_MAX);
        }
        FragmentStore frags = new FragmentStore(this.seq, cparams.OPT_CP_FRAGMULTI_MAX);
        if (debug != null && debug.getWillPrint()) {
            debug.printBC("Start fusing");
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Start fusing");
        }
        if (pmon != null) {
            pmon.init(this.seq.cmds);
            pmon.set(0);
        }
        if (!Clean3D.OPT_DEBUG_SKIPBUILD) {
            for (int currentFuseStep = 0; currentFuseStep < this.seq.cmds; ++currentFuseStep) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("Fuse step " + currentFuseStep);
                }
                long timeBeforeStep = System.currentTimeMillis();
                if (canceller != null && canceller.isCancelled()) {
                    this.lastResult = 3;
                    return 3;
                }
                if (debug != null && debug.getWillPrint()) {
                    debug.printHR();
                }
                if (this.seq.OP_Type[currentFuseStep] == -1) {
                    this.doAtomAtomFusingStep(this.seq, frags, debug, currentFuseStep);
                } else if (this.seq.OP_Type[currentFuseStep] == -2) {
                    int i;
                    int atomToPlace;
                    int i2;
                    int a1 = this.seq.OP1_Ref[currentFuseStep];
                    int f1 = this.seq.OP2_Ref[currentFuseStep];
                    int tmp_trace_fusestep = 0;
                    if (CleanArgs.cltracer != null) {
                        tmp_trace_fusestep = CleanArgs.cltracer.getNodeID();
                        CleanArgs.cltracer.incDetail(5, Tracer.getNewIntID());
                        debug = CleanArgs.getDebug();
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.println("Fuse atom " + a1);
                        debug.println("To fragment " + f1);
                        debug.printHR();
                        debug.println("<CENTER><B>Initialization</B></CENTER>");
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.incLevel("Generate wishlists info");
                    }
                    WishList wishl = new WishList(this.mol, a1, f1, frags, debug);
                    wishl.saveParticipants();
                    if (debug != null && debug.getWillPrint()) {
                        debug.decLevel();
                    }
                    int SUMMARY_RICT = 0;
                    int SUMMARY_NEWD = 0;
                    int SUMMARY_OPT = 0;
                    if (debug != null && debug.getWillPrint()) {
                        debug.incLevel("Whistlist generated:");
                        wishl.printout();
                        debug.decLevel();
                    }
                    if (canceller != null && canceller.isCancelled()) {
                        this.lastResult = 3;
                        return 3;
                    }
                    FragmentAtomFuseStore store = new FragmentAtomFuseStore(frags, this.seq, wishl, a1, f1, frags.multi * 12);
                    Fragment currentFuseStepFrag = store.getFragment(this.stereo, settings);
                    int[] fragatoms = this.seq.getAtomsForCommand(f1);
                    FuseStep fuseStep = new FuseStep(this.mol, fragatoms, a1);
                    fuseStep.setBaseFragmentCoordinates(frags.getCoordinateArray(fragatoms));
                    if (debug != null && debug.getWillPrint()) {
                        fuseStep.getBaseFrag(settings).placeApplet("Base fragment 2D");
                        fuseStep.getBaseFrag(settings).getFragMol().place3DApplets("Base Fragment 3D", fuseStep.getBaseFragmentCoordinates(), null);
                    }
                    boolean Hin2 = false;
                    boolean Hin3 = false;
                    if (debug != null) {
                        debug.incLevel("Look for Hin2/3 hack");
                    }
                    if (this.mol.anum[a1] == 1 && this.mol.ctab[a1].length == 1) {
                        if (debug != null) {
                            debug.println("This is an H atom with 1 neighbor");
                        }
                        int Hcount = 0;
                        int base = this.mol.ctab[a1][0];
                        for (int i3 = 0; i3 < this.mol.ctab[base].length; ++i3) {
                            if (this.mol.anum[this.mol.ctab[base][i3]] != 1 || this.mol.ctab[this.mol.ctab[base][i3]].length != 1 || (this.mol.bdesc[this.mol.blist[base][i3]] & 1) == 0) continue;
                            ++Hcount;
                        }
                        if (debug != null) {
                            debug.println("Hcount=" + Hcount);
                        }
                        if (Hcount == 2) {
                            Hin2 = true;
                        }
                        if (Hcount == 3 && this.mol.ctab[base].length == 4) {
                            Hin3 = true;
                        }
                    }
                    if (debug != null) {
                        debug.decLevel();
                    }
                    store.initStore(Hin2, Hin3);
                    if (this.seq.OP_Flags[currentFuseStep] == 3) {
                        boolean in3_4_ring = false;
                        for (i2 = 0; i2 < this.seq.mol.atomToRing[a1].length; ++i2) {
                            if (this.seq.mol.SSSR[this.seq.mol.atomToRing[a1][i2]].length >= 5) continue;
                            in3_4_ring = true;
                        }
                        if (!in3_4_ring) {
                            if (debug != null && debug.getWillPrint()) {
                                debug.incLevel("Make wish group:");
                            }
                            wishl.groupByTarget(debug, store);
                            if (debug != null && debug.getWillPrint()) {
                                debug.decLevel();
                                debug.incLevel("Wishlist after");
                                wishl.printout();
                                debug.decLevel();
                            }
                        }
                    }
                    if (CleanArgs.cltracer != null) {
                        CleanArgs.cltracer.changeTaskID(6);
                        debug = CleanArgs.cltracer.getDebug();
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.printHR();
                        debug.println("<CENTER><B>Start atom placement</B></CENTER>");
                        debug.printBC("ROUND I: triangulations (and in-space place)");
                        debug.Tstart();
                        debug.Trow();
                        debug.TprintBC("#");
                        debug.TprintBC("Conf");
                        debug.TprintBC("Ready");
                        debug.TprintBC("Optreq");
                        debug.TprintBC("Fin.");
                    }
                    for (atomToPlace = 0; atomToPlace < store.getSize(); ++atomToPlace) {
                        if (canceller != null && canceller.isCancelled()) {
                            this.lastResult = 3;
                            return 3;
                        }
                        if (debug != null && debug.getWillPrint()) {
                            debug.Trow();
                        }
                        FragmentAtomFuseItem atom = store.get(atomToPlace);
                        if (debug != null && debug.getWillPrint()) {
                            debug.TprintBC("" + atomToPlace);
                            debug.print("<TD><CENTER>");
                            debug.incLevel("" + atom.confNo);
                            debug.print("</CENTER></TD>");
                        }
                        if (debug != null && debug.getWillPrint()) {
                            debug.println("<CENTER><B>Start triangulation</B></CENTER>");
                        }
                        atom.doTriangulation(wishl, store, debug);
                        atom.doInSpacePlacement(store, wishl, debug);
                        if (debug != null && debug.getWillPrint()) {
                            debug.decLevel();
                        }
                        if (debug != null && debug.getWillPrint()) {
                            debug.TprintC("" + atom.getReady());
                        }
                        if (atom.getReady()) {
                            if (debug != null && debug.getWillPrint()) {
                                debug.TprintBC("" + store.getLastFinal().isOptRequired());
                            }
                            FragmentAtomFinalItem fin = store.getLastFinal();
                            if (debug != null && debug.getWillPrint()) {
                                debug.print("<TD><CENTER>");
                            }
                            if (debug != null && debug.getWillPrint()) {
                                debug.incLevel("" + (store.getFinalSize() - 1));
                            }
                            if (debug != null && debug.getWillPrint()) {
                                fin.printout(debug);
                            }
                            if (debug != null && debug.getWillPrint()) {
                                debug.decLevel();
                            }
                            if (debug == null || !debug.getWillPrint()) continue;
                            debug.print("</CENTER></TD>");
                            continue;
                        }
                        if (debug != null && debug.getWillPrint()) {
                            debug.TprintBC("");
                        }
                        if (debug == null || !debug.getWillPrint()) continue;
                        debug.TprintBC("");
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.Tstop();
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.printBC("ROUND II: Place +/- mres in space");
                    }
                    for (atomToPlace = 0; atomToPlace < store.getSize(); ++atomToPlace) {
                        FragmentAtomFuseItem atom = store.get(atomToPlace);
                        if (atom.getReady()) continue;
                        if (debug != null && debug.getWillPrint()) {
                            debug.incLevel("Step: " + atomToPlace);
                        }
                        atom.placeMresInSpace(store, debug);
                        if (debug == null || !debug.getWillPrint()) continue;
                        debug.decLevel();
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.printBC("ROUND II-2: try RICT finalization");
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.printB("Create list");
                    }
                    FragmentAtomFuseItem.RICTdescList rdl = new FragmentAtomFuseItem.RICTdescList(store);
                    rdl.fillRMSDs(store, wishl, frags);
                    rdl.sortByRMSD();
                    if (debug != null && debug.getWillPrint()) {
                        debug.incLevel("RICT list");
                        rdl.printout(debug);
                        debug.decLevel();
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.incLevel("RICT list after clip");
                        rdl.printout(debug);
                        debug.decLevel();
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.printBC("ROUND II-2: try RICT finalization");
                        debug.Tstart();
                        debug.Trow();
                        debug.TprintBC("A#");
                        debug.TprintBC("Conf");
                        debug.TprintBC("Success");
                    }
                    for (i2 = 0; i2 < rdl.valids; ++i2) {
                        int steps;
                        if (canceller != null && canceller.isCancelled()) {
                            this.lastResult = 3;
                            return 3;
                        }
                        int atomToPlace2 = rdl.it[i2].a;
                        FragmentAtomFuseItem atom = store.get(atomToPlace2);
                        if (atom.getReady()) continue;
                        if (debug != null && debug.getWillPrint()) {
                            debug.Trow();
                            debug.TprintBC("" + atomToPlace2);
                            debug.TprintBC("" + atom.confNo);
                            debug.print("<TD><CENTER>");
                            debug.incLevel("xxxx");
                        }
                        rdl.it[i2].steps = steps = atom.doRICT(this.seq, frags, store, wishl, debug);
                        if (debug != null && debug.getWillPrint()) {
                            debug.decLevel("" + (atom.getReady() ? "in " + steps : "-"));
                            debug.print("</CENTER></TD>");
                        }
                        if (!atom.getReady()) continue;
                        ++SUMMARY_RICT;
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.Tstop();
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.incLevel("RICT list after RICTS");
                        rdl.printout(debug);
                        debug.decLevel();
                    }
                    if (store.getFinalSize() == 0) {
                        if (CleanArgs.cltracer != null) {
                            CleanArgs.cltracer.reportError(5, "Makecoords failed");
                            CleanArgs.cltracer.decDetail(tmp_trace_fusestep);
                            debug = CleanArgs.getDebug();
                        }
                        this.lastResult = 2;
                        return 2;
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.println("Atom candidates placed.");
                    }
                    if (CleanArgs.cltracer != null) {
                        CleanArgs.cltracer.changeTaskID(7);
                        debug = CleanArgs.getDebug();
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.printHR();
                        debug.printBC("Selection");
                    }
                    if (debug != null && debug.getWillPrint()) {
                        currentFuseStepFrag.placeApplet("Current fuse step fragment");
                    }
                    Vector<SelectionTableItem> stab = new Vector<SelectionTableItem>();
                    Vector<double[][]> coordsv = null;
                    Vector<String> labels = null;
                    if (debug != null && debug.getWillPrint()) {
                        coordsv = new Vector<double[][]>();
                        labels = new Vector<String>();
                    }
                    for (int i4 = 0; i4 < store.getFinalSize(); ++i4) {
                        FragmentAtomFinalItem fit = store.getFinal(i4);
                        for (int j = 0; j < fit.getSelections(); ++j) {
                            double[][] cc = store.getFinalCoordArray3D(fit, j);
                            SelectionTableItem stit = new SelectionTableItem(currentFuseStepFrag, cc);
                            stit.setOptReq(fit.isOptRequired(j));
                            if (debug != null && debug.getWillPrint()) {
                                labels.add("Final " + i4 + " sel " + j);
                                coordsv.add(stit.getCoordinates());
                            }
                            stab.add(stit);
                        }
                    }
                    if (debug != null && debug.getWillPrint()) {
                        Printouts.place3DApplet("Finals", currentFuseStepFrag.getFragMol().getOriginalMolCopy(), coordsv, labels);
                    }
                    SelectionTableItem.removeDuplicates(stab, debug);
                    BitSet toucheds = null;
                    for (i = 0; i < stab.size(); ++i) {
                        SelectionTableItem ii = stab.get(i);
                        if (!ii.getOptReq()) continue;
                        if (debug != null && debug.getWillPrint()) {
                            debug.println("Optimize #" + i + " limit: " + this.optimizationLimit);
                            ii.placeApplet("Before opt", debug);
                        }
                        double[][] coords = ii.getCoordinates();
                        for (int j = 1; j < coords.length; ++j) {
                            for (int k = 0; k < j; ++k) {
                                if (!(V.vectLenSquare(coords[j], coords[k]) < 0.001)) continue;
                                double[] dArray = coords[j];
                                dArray[0] = dArray[0] + 0.1;
                            }
                        }
                        ii.getFragment().optimizeDreiding(ii.getCoordinates(), this.optimizationLimit);
                        ii.notifyCoordinateChange();
                        if (debug != null && debug.getWillPrint()) {
                            ii.placeApplet("After opt", debug);
                        }
                        if (toucheds == null) {
                            toucheds = new BitSet();
                        }
                        toucheds.set(i);
                    }
                    if (toucheds != null) {
                        SelectionTableItem.removeDuplicates(stab, toucheds, debug);
                    }
                    SelectionTableItem.removeStereoNoks(stab, debug);
                    SelectionTableItem.sortByEnergy(stab, debug);
                    if (stab.size() > frags.multi) {
                        this.maxConfCountReached = true;
                        for (i = stab.size() - 1; i >= frags.multi; --i) {
                            stab.remove(i);
                        }
                    }
                    store.mergeFinalAtoms(stab, debug);
                    frags.updateFcmd(currentFuseStep);
                    if (debug != null && debug.getWillPrint()) {
                        frags.printOut(debug);
                        frags.printInnerCoordinates(debug);
                    }
                    if (CleanArgs.cltracer != null) {
                        CleanArgs.cltracer.decDetail(tmp_trace_fusestep);
                        debug = CleanArgs.getDebug();
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.println("Confs: <B>" + store.conformers + "</B>");
                        debug.println("Finals: <B>" + store.getFinalSize() + "</B>");
                        debug.println("Mergeds: <B>" + frags.confs[a1] + "</B>");
                        switch (this.seq.OP_Flags[currentFuseStep]) {
                            case 1: {
                                debug.println("<B>Chain</B>");
                                break;
                            }
                            case 5: {
                                debug.println("<B>Ringset center</B>");
                                break;
                            }
                            case 4: {
                                debug.println("<B>Interring BB</B>");
                                break;
                            }
                            case 3: {
                                debug.println("<B>Ring close</B>");
                                break;
                            }
                            case 2: {
                                debug.println("<B>Ring</B>");
                            }
                        }
                        if (SUMMARY_RICT != 0) {
                            debug.println("RICTs: " + SUMMARY_RICT);
                        }
                        if (SUMMARY_NEWD != 0) {
                            debug.println("NEWDs: " + SUMMARY_NEWD);
                        }
                        if (SUMMARY_OPT != 0) {
                            debug.println("OPTs: " + SUMMARY_OPT);
                        }
                    }
                    if (canceller != null && canceller.isCancelled()) {
                        this.lastResult = 3;
                        return 3;
                    }
                }
                if (this.seq.OP_Type[currentFuseStep] == -3) {
                    int f1 = this.seq.OP1_Ref[currentFuseStep];
                    int f2 = this.seq.OP2_Ref[currentFuseStep];
                    if (debug != null && debug.getWillPrint()) {
                        debug.incLevel("FUSE step " + currentFuseStep + " F " + f1 + " - F " + f2);
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.println("NOT IMPLEMENTED.");
                    }
                    if (debug != null && debug.getWillPrint()) {
                        frags.printInnerCoordinates(debug);
                    }
                    if (debug != null && debug.getWillPrint()) {
                        frags.printOut(debug);
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.decLevel();
                    }
                }
                String sel = null;
                if (this.seq.OP_Type[currentFuseStep] == -2) {
                    sel = "" + this.seq.OP1_Ref[currentFuseStep];
                }
                if (CleanArgs.cltracer != null) {
                    CleanArgs.cltracer.changeTaskID(4, currentFuseStep);
                    CleanArgs.getDebug();
                }
                if (CleanArgs.cltracer != null && CleanArgs.cltracer.getVisualisationState() && debug != null && debug.getWillPrint()) {
                    frags.writeConformersApplet(sel, "State of fragment store after fuseStep <B>" + currentFuseStep + "</B>:");
                }
                long timeNow = System.currentTimeMillis();
                if (debug != null && debug.getWillPrint()) {
                    debug.println("Last step time: " + (timeNow - timeBeforeStep));
                }
                if (pmon == null) continue;
                pmon.set(currentFuseStep + 1);
            }
        }
        if (debug != null && debug.getWillPrint()) {
            debug.printHR();
            debug.println("Fuse sequence processed");
            frags.printOut(debug);
            frags.printInnerCoordinates(debug);
        }
        if (!cparams.ACCEPT_STEREO_NOK) {
            boolean blerror = false;
            for (int i = 0; i < this.seq.mol.b; ++i) {
                int a1 = this.seq.mol.bat[0][i];
                int a2 = this.seq.mol.bat[1][i];
                double desBLen = this.seq.mol.blen[i];
                double m = V.dot(V.minus(frags.getCoordinate(0, a1), frags.getCoordinate(0, a2)));
                if (!(m > desBLen * desBLen * 4.0)) continue;
                System.err.println("Metrid (bond) mismatch: " + a1 + " " + a2);
                if (CleanArgs.cltracer != null) {
                    CleanArgs.cltracer.reportError(5, "Makecoords failed - bond length error");
                }
                this.lastResult = 2;
                return 2;
            }
        }
        this.lastCoords = frags.getCoordArray();
        this.lastEnergy = frags.getEnergyArray();
        for (int i = 0; i < this.mol.a; ++i) {
            this.mol.coord[i][0] = frags.coords[0].getV(i, 0);
            this.mol.coord[i][1] = frags.coords[0].getV(i, 1);
            this.mol.coord[i][2] = frags.coords[0].getV(i, 2);
        }
        this.lastResult = 1;
        return 1;
    }

    private void doAtomAtomFusingStep(FuseCommandSequence seq, FragmentStore frags, debugPrintout debug, int step) {
        if (seq.OP_Type[step] != -1) {
            throw new UnsupportedOperationException("Not an atom-atom fuse step");
        }
        int a1 = seq.OP1_Ref[step];
        int a2 = seq.OP2_Ref[step];
        int e = seq.mol.bonds[a1][a2];
        double l = 1.5;
        if (e >= 0) {
            l = seq.mol.blen[e];
        }
        frags.confs[a1] = 1;
        frags.confs[a2] = 1;
        frags.dims[0][a1] = 3;
        frags.dims[0][a2] = 3;
        frags.updateFcmd(step);
        frags.coords[0].putV(a1, 0, 0.0);
        frags.coords[0].putV(a1, 1, 0.0);
        frags.coords[0].putV(a1, 2, 0.0);
        frags.coords[0].putV(a2, 0, l);
        frags.coords[0].putV(a2, 1, 0.0);
        frags.coords[0].putV(a2, 2, 0.0);
        if (debug != null && debug.getWillPrint()) {
            debug.incLevel("FUSE step " + step + " A " + a1 + " - A " + a2);
            debug.println("Bond number: " + e);
            debug.println("Bond length: " + l);
            debug.println("A " + a1 + " - A " + a2);
            frags.printOut(debug);
            frags.printInnerCoordinates(debug);
            debug.decLevel();
        }
    }

    public boolean isMaxConfCountReached() {
        return this.maxConfCountReached;
    }

    public static class CleanParams
    implements Cloneable {
        public int OPT_CP_FRAGMULTI_MAX = 50;
        public int OPT_CP_FRAGMULTI_RINGBEFORECLOSE = 50;
        public int OPT_CP_FRAGMULTI_RING = 50;
        public int OPT_CP_FRAGMULTI_CHAIN = 20;
        public boolean ACCEPT_STEREO_NOK = false;

        public void setAllConfCount(int c) {
            this.OPT_CP_FRAGMULTI_CHAIN = c;
            this.OPT_CP_FRAGMULTI_MAX = c;
            this.OPT_CP_FRAGMULTI_RING = c;
            this.OPT_CP_FRAGMULTI_RINGBEFORECLOSE = c;
        }

        public int getMaxConfCount() {
            return this.OPT_CP_FRAGMULTI_MAX;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (Exception e) {
                return null;
            }
        }

        public void printout(debugPrintout debug) {
            debug.printB("CleanParams:");
            debug.println("FRAGMULTI CHAIN: " + this.OPT_CP_FRAGMULTI_CHAIN);
            debug.println("FRAGMULTI RING: " + this.OPT_CP_FRAGMULTI_RING);
            debug.println("FRAGMULTI RING before close: " + this.OPT_CP_FRAGMULTI_RINGBEFORECLOSE);
            debug.println("Accept stereo NOK: " + this.ACCEPT_STEREO_NOK);
        }
    }

    public static class CleanPreferences {
        int initialConformersCount = CleanArgs.OPT_FUSEBUILD_DEFAULT_INIT_CONFCOUNT;
        int conformerMultiplication = 3;
        int maxConfCount = CleanArgs.OPT_FUSEBUILD_DEFAULT_MAX_CONFCOUNT;

        public CleanParams iterateActualParam(CleanParams param, int expectedConformerCount) {
            CleanParams newp = null;
            if (param == null) {
                newp = new CleanParams();
                int ct = this.initialConformersCount;
                if (ct < expectedConformerCount) {
                    ct = expectedConformerCount;
                }
                if (ct >= this.maxConfCount) {
                    ct = this.maxConfCount;
                }
                newp.setAllConfCount(ct);
            } else {
                int ct = param.getMaxConfCount();
                if (ct >= this.maxConfCount) {
                    return null;
                }
                if ((ct *= this.conformerMultiplication) < expectedConformerCount) {
                    ct = expectedConformerCount;
                }
                if (ct >= this.maxConfCount) {
                    ct = this.maxConfCount;
                }
                newp = new CleanParams();
                newp.setAllConfCount(ct);
            }
            return newp;
        }
    }
}

