/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.build.fafuse;

import chemaxon.marvin.modelling.CleanSettings;
import chemaxon.marvin.modelling.struc.Fragment;
import chemaxon.marvin.modelling.struc.myMolecule;

public class FuseStep {
    myMolecule basemol = null;
    int[] baseFragAtoms = null;
    int[] fullFragAtoms = null;
    Fragment baseFrag = null;
    int fusingAtom = 0;
    double[][][] baseFragmentCoordinates = null;

    public FuseStep(myMolecule basemol, int[] baseFragAtoms, int fusingAtom) {
        this.basemol = basemol;
        this.baseFragAtoms = baseFragAtoms;
        this.fusingAtom = fusingAtom;
    }

    public void setBaseFragmentCoordinates(double[][][] bfc) {
        this.baseFragmentCoordinates = bfc;
    }

    public double[][][] getBaseFragmentCoordinates() {
        return this.baseFragmentCoordinates;
    }

    public Fragment getBaseFrag(CleanSettings settings) {
        if (this.baseFrag == null) {
            this.baseFrag = new Fragment(this.basemol, this.baseFragAtoms, null, null, settings);
        }
        return this.baseFrag;
    }

    public int[] getFullFragAtoms() {
        if (this.fullFragAtoms == null) {
            this.fullFragAtoms = new int[this.baseFragAtoms.length + 1];
            for (int i = 0; i < this.baseFragAtoms.length; ++i) {
                this.fullFragAtoms[i] = this.baseFragAtoms[i];
            }
            this.fullFragAtoms[this.fullFragAtoms.length - 1] = this.fusingAtom;
        }
        return this.fullFragAtoms;
    }

    public static class FusingAtom {
        FuseStep fuseStep = null;
        int baseFragmentConformer = -1;
        double[] coords = null;

        public FusingAtom(FuseStep fuseStep, int baseFragmentConformer) {
            this.fuseStep = fuseStep;
            this.baseFragmentConformer = baseFragmentConformer;
        }

        public void setCoordinates(double[] c) {
            this.coords = new double[3];
            for (int i = 0; i < 3; ++i) {
                this.coords[i] = c[i];
            }
        }

        public void getFullFragmentCoordinates(double[][] c) {
            int j;
            double[][][] bfc = this.fuseStep.getBaseFragmentCoordinates();
            int i = 0;
            for (i = 0; i < bfc[this.baseFragmentConformer].length; ++i) {
                for (j = 0; j < 3; ++j) {
                    c[i][j] = bfc[this.baseFragmentConformer][i][j];
                }
            }
            for (j = 0; j < 3; ++j) {
                c[i][j] = this.coords[j];
            }
        }

        public double[][] getFullFragmentCoordinates() {
            double[][] ret = new double[this.fuseStep.getFullFragAtoms().length][];
            this.getFullFragmentCoordinates(ret);
            return ret;
        }
    }
}

