/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.build.fafuse;

import chemaxon.calculations.clean.Optimization;
import chemaxon.marvin.modelling.debug.Printouts;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.struc.Fragment;
import chemaxon.marvin.modelling.util.IntSet;
import java.util.BitSet;
import java.util.Vector;

public class SelectionTableItem {
    Fragment f;
    double[][] c;
    boolean optReq = false;
    double e = 0.0;
    boolean evalid = false;

    public SelectionTableItem(Fragment f, double[][] c) {
        this.f = f;
        this.c = c;
        this.evalid = false;
    }

    public boolean getOptReq() {
        return this.optReq;
    }

    public void setOptReq(boolean r) {
        this.optReq = r;
    }

    public double getEnergy() {
        if (!this.evalid) {
            this.e = this.f.calcDreiding(this.c);
            this.evalid = true;
        }
        return this.e;
    }

    public Fragment getFragment() {
        return this.f;
    }

    public double[][] getCoordinates() {
        return this.c;
    }

    public void notifyCoordinateChange() {
        this.evalid = false;
    }

    public void placeApplet(String s, debugPrintout debug) {
        if (debug == null || !debug.getWillPrint()) {
            return;
        }
        Printouts.place3DApplet(s, this.getFragment().getFragMol().getOriginalMolCopy(), new double[][][]{this.getCoordinates()});
    }

    public static void sortByEnergy(final Vector<SelectionTableItem> v, debugPrintout debug) {
        if (v.size() < 1) {
            return;
        }
        if (debug != null && debug.getWillPrint()) {
            debug.incLevel("Sort by enegrgy");
        }
        Optimization.quickSort(0, v.size() - 1, new Optimization.Sortable(){

            @Override
            public boolean isGreater(int i, int j) {
                return ((SelectionTableItem)v.get(i)).getEnergy() > ((SelectionTableItem)v.get(j)).getEnergy();
            }

            @Override
            public void swap(int i, int j) {
                SelectionTableItem oldi = (SelectionTableItem)v.get(i);
                SelectionTableItem oldj = (SelectionTableItem)v.get(j);
                v.setElementAt(oldj, i);
                v.setElementAt(oldi, j);
            }
        });
    }

    public static void removeStereoNoks(Vector<SelectionTableItem> v, debugPrintout debug) {
        if (v.size() < 1) {
            return;
        }
        if (debug != null && debug.getWillPrint()) {
            debug.incLevel("remove stereo NOKs from sel table");
        }
        Fragment f0 = v.get(0).getFragment();
        for (int i = v.size() - 1; i >= 0; --i) {
            int sres;
            SelectionTableItem ti = v.get(i);
            if (debug != null && debug.getWillPrint()) {
                debug.println("Check #" + i);
            }
            if (((sres = f0.checkStereo(ti.getCoordinates(), true, 0.1, debug)) & 8) != 0) {
                if (debug != null && debug.getWillPrint()) {
                    debug.println("Stereo permutated");
                }
                ti.notifyCoordinateChange();
            }
            if ((sres & 1) != 0) {
                if (debug == null || !debug.getWillPrint()) continue;
                debug.println("Stereo OK");
                continue;
            }
            if ((sres & 6) != 0) {
                if (debug != null && debug.getWillPrint()) {
                    debug.println("Stereo error, remove");
                }
                v.remove(i);
                continue;
            }
            throw new UnsupportedOperationException();
        }
        if (debug != null && debug.getWillPrint()) {
            debug.decLevel();
        }
    }

    public static void removeDuplicates(Vector<SelectionTableItem> v, debugPrintout debug) {
        SelectionTableItem.removeDuplicates(v, null, debug);
    }

    public static void removeDuplicates(Vector<SelectionTableItem> v, BitSet touched, debugPrintout debug) {
        int i;
        if (v.size() < 2) {
            return;
        }
        if (debug != null && debug.getWillPrint()) {
            debug.incLevel("remove duplicaes from sel table");
        }
        Fragment f0 = v.get(0).getFragment();
        IntSet removeds = new IntSet(v.size());
        for (i = 1; i < v.size(); ++i) {
            if (removeds.contains(i)) continue;
            double[][] ci = v.get(i).getCoordinates();
            for (int j = 0; j < i; ++j) {
                double ej;
                if (removeds.contains(j) || touched != null && !touched.get(i) && !touched.get(j)) continue;
                double[][] cj = v.get(j).getCoordinates();
                boolean same = f0.isEquivalent(ci, cj, 0.1);
                if (debug != null && debug.getWillPrint()) {
                    debug.println("Check " + i + " vs " + j + " : same=" + same);
                }
                if (!same) continue;
                double ei = v.get(i).getEnergy();
                if (ei < (ej = v.get(j).getEnergy())) {
                    removeds.add(j);
                } else {
                    removeds.add(i);
                }
                if (debug == null || !debug.getWillPrint()) continue;
                debug.println("ei=" + ei + " ej=" + ej);
            }
        }
        if (debug != null && debug.getWillPrint()) {
            debug.println("Removeds: " + removeds.toString());
        }
        for (i = v.size() - 1; i >= 0; --i) {
            if (!removeds.contains(i)) continue;
            v.remove(i);
        }
        if (debug != null && debug.getWillPrint()) {
            debug.decLevel();
        }
    }
}

