/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.build.fafuse;

import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.linalg.M;
import chemaxon.marvin.modelling.linalg.V;
import chemaxon.marvin.modelling.linalg.multiDim;
import chemaxon.marvin.modelling.struc.StereoCriteriaList;
import chemaxon.marvin.modelling.struc.myMolecule;

public class WishListItem {
    public static final int T_BLEN = 1;
    public static final int T_BANGL = 2;
    public static final int T_TORSION = 3;
    public static final int PT_CISTRANS = -1;
    public static final int PT_FORCHAIN = -2;
    public static final int PT_SP2SP3 = -3;
    public static final int PT_FORSMALLRING = -4;
    public static final int PT_CIS = -5;
    public static final int PT_TRANS = -6;
    public static final int PT_CISSPAN = -9;
    public static final int PT_TRANSSPAN = -10;
    public static final int PT_SSP2SP2_30_180 = -11;
    public static final int PT_FORAROMATICRING = -7;
    public static final int PT_FORSMALLAROMATICRING = -8;
    public int type = -1;
    public int priority = 0;
    public int[] atoms = null;
    public static final int A_TOPLACE = 1;
    public static final int A_INFRAG = 2;
    public static final int A_NONPLACED = 3;
    public int[] coordinfo = null;
    public double[] d = null;

    public WishListItem(int a0, int a1, double l) {
        this.type = 1;
        this.atoms = new int[2];
        this.atoms[0] = a0;
        this.atoms[1] = a1;
        this.coordinfo = new int[2];
        this.coordinfo[0] = 1;
        this.coordinfo[1] = 2;
        this.d = new double[1];
        this.d[0] = l;
    }

    public WishListItem(int a0, int a1, int a2, boolean af, double a) {
        this.type = 2;
        this.atoms = new int[3];
        this.atoms[0] = a0;
        this.atoms[1] = a1;
        this.atoms[2] = a2;
        this.coordinfo = new int[3];
        this.coordinfo[0] = 1;
        this.coordinfo[1] = af ? 2 : 3;
        this.coordinfo[2] = 2;
        this.d = new double[1];
        this.d[0] = a;
    }

    public WishListItem(int a0, int a1, int a2, double a) {
        this.type = 2;
        this.atoms = new int[3];
        this.atoms[0] = a0;
        this.atoms[1] = a1;
        this.atoms[2] = a2;
        this.coordinfo = new int[3];
        this.coordinfo[0] = 2;
        this.coordinfo[1] = 1;
        this.coordinfo[2] = 2;
        this.d = new double[1];
        this.d[0] = a;
    }

    public void initTorsionAtoms(int a0, int a1, int a2, int a3, int a0f, int a1f, int a2f, int a3f) {
        this.type = 3;
        this.atoms = new int[4];
        this.atoms[0] = a0;
        this.atoms[1] = a1;
        this.atoms[2] = a2;
        this.atoms[3] = a3;
        this.coordinfo = new int[4];
        this.coordinfo[0] = a0f;
        this.coordinfo[1] = a1f;
        this.coordinfo[2] = a2f;
        this.coordinfo[3] = a3f;
    }

    public void initTorsionData(double a) {
        this.d = new double[1];
        this.d[0] = a;
    }

    public void initTorsionData(int l) {
        if (l > 0) {
            this.d = new double[l];
        } else {
            switch (l) {
                case -1: {
                    this.d = new double[2];
                    this.d[0] = 0.0;
                    this.d[1] = 180.0;
                    break;
                }
                case -11: {
                    this.d = new double[3];
                    this.d[0] = 30.0;
                    this.d[1] = 150.0;
                    this.d[2] = 180.0;
                    break;
                }
                case -5: {
                    this.d = new double[1];
                    this.d[0] = 0.0;
                    break;
                }
                case -9: {
                    this.d = new double[2];
                    this.d[0] = 0.0;
                    this.d[1] = 15.0;
                    break;
                }
                case -6: {
                    this.d = new double[1];
                    this.d[0] = 180.0;
                    break;
                }
                case -10: {
                    this.d = new double[2];
                    this.d[0] = 180.0;
                    this.d[1] = 165.0;
                    break;
                }
                case -2: {
                    this.d = new double[2];
                    this.d[0] = 60.0;
                    this.d[1] = 180.0;
                    break;
                }
                case -4: {
                    this.d = new double[2];
                    this.d[0] = 0.0;
                    this.d[1] = 60.0;
                    break;
                }
                case -7: {
                    this.d = new double[4];
                    this.d[0] = 0.0;
                    this.d[1] = 30.0;
                    this.d[2] = 150.0;
                    this.d[3] = 180.0;
                    break;
                }
                case -8: {
                    this.d = new double[1];
                    this.d[0] = 0.0;
                    break;
                }
                case -3: {
                    this.d = new double[7];
                    this.d[0] = 0.0;
                    this.d[1] = 30.0;
                    this.d[2] = 60.0;
                    this.d[3] = 90.0;
                    this.d[4] = 120.0;
                    this.d[5] = 150.0;
                    this.d[6] = 180.0;
                }
            }
        }
    }

    public WishListItem(int a0, int a1, int a2, int a3, double a) {
        this.initTorsionAtoms(a0, a1, a2, a3, 2, 1, 2, 2);
        this.initTorsionData(a);
    }

    public WishListItem(int a0, int a1, int a2, int a3, int l) {
        this.initTorsionAtoms(a0, a1, a2, a3, 2, 1, 2, 2);
        this.initTorsionData(l);
    }

    public WishListItem(int a0, int a1, int a2, int a3, boolean a1f, boolean a2f, double a) {
        this.initTorsionAtoms(a0, a1, a2, a3, 1, a1f ? 2 : 3, a2f ? 2 : 3, 2);
        this.initTorsionData(a);
    }

    public WishListItem(int a0, int a1, int a2, int a3, boolean a1f, boolean a2f, int l) {
        this.initTorsionAtoms(a0, a1, a2, a3, 1, a1f ? 2 : 3, a2f ? 2 : 3, 2);
        this.initTorsionData(l);
    }

    public int getTargetAtom() {
        if (this.atoms == null || this.atoms.length == 0) {
            return -1;
        }
        return this.atoms[this.atoms.length - 1];
    }

    public int getConnectedAtom() {
        return this.atoms[1];
    }

    public int getChoiceCount() {
        return this.d.length;
    }

    public static double calcBondAngle(double[] a1, double[] a2, double[] a3) {
        double l12 = Math.sqrt(Math.abs(V.dot(V.minus(a1, a2))));
        double l23 = Math.sqrt(Math.abs(V.dot(V.minus(a2, a3))));
        double l13 = Math.sqrt(Math.abs(V.dot(V.minus(a1, a3))));
        double a = Math.acos((l12 * l12 + l23 * l23 - l13 * l13) / (2.0 * l12 * l23));
        return a * 180.0 / Math.PI;
    }

    public static double calcDihedralAngle(double[] a1, double[] a2, double[] a3, double[] a4) {
        double[] a = V.minus(a2, a1);
        double[] b = V.minus(a3, a2);
        double[] c = V.minus(a4, a3);
        double[] e1 = V.vectProd(a, b);
        double e1l = Math.sqrt(Math.abs(V.dot(e1)));
        double[] e2 = V.vectProd(b, c);
        double e2l = Math.sqrt(Math.abs(V.dot(e2)));
        double cosAngle = V.dot(e1, e2) / (e1l * e2l);
        cosAngle = Math.max(-1.0, Math.min(1.0, cosAngle));
        double value = Math.acos(cosAngle) * 180.0 / Math.PI;
        if (V.dot(b, V.vectProd(e1, e2)) > 0.0) {
            value *= -1.0;
        }
        return value;
    }

    public static double calcGeneralParity(double[] a1, double[] a2, double[] a3, double[] a4) {
        double[] a = V.minus(a2, a1);
        double[] b = V.minus(a3, a1);
        double[] c = V.vectProd(a, b);
        double[] d = V.minus(a4, a1);
        return V.dot(c, d);
    }

    public static double calcTorsion14MD(double bl1, double bl2, double bl3, double fi1, double fi2, double omega) {
        double bl1s = bl1 * bl1;
        double bl2s = bl2 * bl2;
        double bl3s = bl3 * bl3;
        double a1s = bl1s + bl2s - 2.0 * bl1 * bl2 * Math.cos(M.deg2rad(fi1));
        double a2s = bl2s + bl3s - 2.0 * bl2 * bl3 * Math.cos(M.deg2rad(fi2));
        double x1 = (a1s - bl1s - bl2s) / (2.0 * bl2);
        double x2 = (a2s - bl3s - bl2s) / (2.0 * bl2);
        double y1 = Math.sqrt(bl1s - M.sqr(x1));
        double y2 = Math.sqrt(bl3s - M.sqr(x2));
        double x = x1 + bl2 + x2;
        double y = y2 * Math.sin(M.deg2rad(omega));
        double z = y2 * Math.cos(M.deg2rad(omega)) - y1;
        return Math.sqrt(M.sqr(x) + M.sqr(y) + M.sqr(z));
    }

    public double getDistanceM(int c, final multiDim f, double[] a, myMolecule m, final int[] afa) {
        debugPrintout debug = null;
        if (CleanArgs.cltracer != null && CleanArgs.cltracer.getExtensiveDebug()) {
            debug = CleanArgs.cltracer.getDebug();
        }
        if (c < 0) {
            c = 0;
        }
        if (c > this.d.length) {
            c = this.d.length - 1;
        }
        StereoCriteriaList.coordinateQuery q = null;
        if (afa != null && f != null) {
            q = new StereoCriteriaList.coordinateQuery(){

                @Override
                public boolean isPlaced(int i) {
                    return afa[i] != -1;
                }

                @Override
                public double[] get(int i) {
                    if (this.isPlaced(i)) {
                        return f.getV(i);
                    }
                    return null;
                }
            };
        }
        if (this.type == 1) {
            return M.sqr(this.d[c]);
        }
        if (this.type == 2) {
            double bl1 = 1.54;
            boolean usedesired = false;
            if (a == null) {
                bl1 = m.getBlen(this.atoms[0], this.atoms[1]);
            } else {
                double ml1;
                double[] ac0 = null;
                double[] ac1 = null;
                if (this.coordinfo[0] == 1) {
                    ac0 = a;
                }
                if (this.coordinfo[0] == 2) {
                    ac0 = f.getV(this.atoms[0]);
                }
                if (this.coordinfo[1] == 1) {
                    ac1 = a;
                }
                if (this.coordinfo[1] == 2) {
                    ac1 = f.getV(this.atoms[1]);
                }
                if ((ml1 = V.dot(V.minus(ac0, ac1))) < 0.0) {
                    System.err.println("Negative metrid error in wish->metrid conversion!");
                }
                bl1 = Math.sqrt(ml1);
            }
            double bl2 = 1.54;
            usedesired = false;
            if (a == null) {
                if (this.coordinfo[1] == 2) {
                    double ml2 = V.dot(V.minus(f.getV(this.atoms[1]), f.getV(this.atoms[2])));
                    if (ml2 < 0.0) {
                        System.err.println("Negative metrid error in wish->metrid conversion!");
                    }
                    bl2 = Math.sqrt(ml2);
                } else {
                    bl2 = m.getBlen(this.atoms[1], this.atoms[2]);
                }
            } else {
                double ml2;
                double[] ac1 = null;
                double[] ac2 = null;
                if (this.coordinfo[1] == 1) {
                    ac1 = a;
                }
                if (this.coordinfo[1] == 2) {
                    ac1 = f.getV(this.atoms[0]);
                }
                if (this.coordinfo[2] == 1) {
                    ac2 = a;
                }
                if (this.coordinfo[2] == 2) {
                    ac2 = f.getV(this.atoms[1]);
                }
                if ((ml2 = V.dot(V.minus(ac1, ac2))) < 0.0) {
                    System.err.println("Negative metrid error in wish->metrid conversion!");
                }
                bl2 = Math.sqrt(ml2);
            }
            double fi = m.getBangl(this.atoms[0], this.atoms[1], this.atoms[2], q);
            if (debug != null) {
                debug.println("Bond angle");
                debug.println("bl1=" + bl1);
                debug.println("bl2=" + bl2);
                debug.println("fi=" + fi);
            }
            return M.sqr(bl1) + M.sqr(bl2) - 2.0 * bl1 * bl2 * Math.cos(M.deg2rad(fi));
        }
        if (this.type == 3) {
            double b1 = m.getBlen(this.atoms[0], this.atoms[1]);
            double b1s = M.sqr(b1);
            double b2 = 1.54;
            double b2s = M.sqr(b2);
            if (this.coordinfo[1] == 2 && this.coordinfo[2] == 2) {
                b2s = V.dot(V.minus(f.getV(this.atoms[1]), f.getV(this.atoms[2])));
                b2 = Math.sqrt(b2s);
            } else {
                b2 = m.getBlen(this.atoms[1], this.atoms[2]);
                b2s = M.sqr(b2);
            }
            double b3 = 1.54;
            double b3s = M.sqr(b3);
            if (this.coordinfo[2] == 2) {
                b3s = V.dot(V.minus(f.getV(this.atoms[2]), f.getV(this.atoms[3])));
                b3 = Math.sqrt(b3);
            } else {
                b3 = m.getBlen(this.atoms[2], this.atoms[3]);
                b3s = M.sqr(b3);
            }
            double fi_b1b2 = m.getBangl(this.atoms[0], this.atoms[1], this.atoms[2]);
            double a1s = M.sqr(b1) + M.sqr(b2) - 2.0 * b1 * b2 * Math.cos(M.deg2rad(fi_b1b2));
            double a2s = 1.0;
            if (this.coordinfo[1] == 2) {
                a2s = V.dot(V.minus(f.getV(this.atoms[1]), f.getV(this.atoms[3])));
            } else {
                double fi_b2b3 = m.getBangl(this.atoms[1], this.atoms[2], this.atoms[3]);
                a2s = b2s + b3s - 2.0 * b2 * b3 * Math.cos(M.deg2rad(fi_b2b3));
            }
            double x1 = (a1s - b1s - b2s) / (2.0 * b2);
            double x2 = (a2s - b3s - b2s) / (2.0 * b2);
            double y1 = Math.sqrt(b1s - M.sqr(x1));
            double y2 = Math.sqrt(b3s - M.sqr(x2));
            double x = x1 + b2 + x2;
            double y = y2 * Math.sin(M.deg2rad(this.d[c]));
            double z = y2 * Math.cos(M.deg2rad(this.d[c])) - y1;
            return M.sqr(x) + M.sqr(y) + M.sqr(z);
        }
        return 0.0;
    }

    public String getType() {
        if (this.type == 1) {
            return "Bond length";
        }
        if (this.type == 2) {
            return "Bond angle";
        }
        if (this.type == 3) {
            return "Torsion";
        }
        return "UNKNOWN or UNDEFINED";
    }

    public void printout(debugPrintout debug) {
        if (debug != null && debug.getWillPrint()) {
            int i;
            debug.println("Priotity: " + this.priority);
            debug.print("<TABLE BORDER = 1 ><TR><TD><B>Type:</B></TD><TD colspan=2>");
            debug.print(this.getType());
            debug.print("</TD></TR>");
            debug.print("<TR><TD rowspan=" + this.atoms.length + "><B>Atoms:</B></TD><TD>");
            for (i = 0; i < this.atoms.length; ++i) {
                if (i != 0) {
                    debug.print("<TR><TD>");
                }
                debug.print(this.atoms[i] + "</TD><TD>");
                if (this.coordinfo[i] == 2) {
                    debug.print("INFRAG");
                }
                if (this.coordinfo[i] == 3) {
                    debug.print("NONPLACED");
                }
                if (this.coordinfo[i] == 1) {
                    debug.print("TOPLACE");
                }
                debug.print("</TD></TR>");
            }
            debug.print("</TD></TR>");
            debug.print("<TR><TD><B>Data(s):</B></TD><TD colspan=2>");
            for (i = 0; i < this.d.length; ++i) {
                debug.print(this.d[i] + " ");
            }
            debug.print("</TD></TR></TABLE>");
            debug.println();
        }
    }
}

