/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.debug;

import chemaxon.marvin.modelling.debug.debugPrintHTML;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.util.myList;

public class CleanDebug {
    private static int ASSIGNEDSTRIDCOUNT = 0;

    public static String getNewStringID() {
        String ret = "uid_" + ASSIGNEDSTRIDCOUNT;
        ++ASSIGNEDSTRIDCOUNT;
        return ret;
    }

    public static class MolAppletRecorder {
        myList mfilenames = new myList(50);
        myList sels = new myList(50);
        myList labels = new myList(50);
        int items = 0;
        String btnmsg = "";
        String popupmsg = "";

        public MolAppletRecorder(String btnmessage, String popupmessage) {
            if (btnmessage != null) {
                this.btnmsg = btnmessage;
            }
            if (popupmessage != null) {
                popupmessage = this.popupmsg;
            }
        }

        public void add(String fname, String sel, String label) {
            if (fname != null) {
                this.mfilenames.add(fname);
                if (sel != null) {
                    this.sels.add(sel);
                } else {
                    this.sels.add("");
                }
                if (label != null) {
                    this.labels.add(label);
                } else {
                    this.labels.add("");
                }
                ++this.items;
            }
        }

        public void placeButtonApplet(debugPrintout debug) {
            int vrows;
            int confCount = this.items;
            int rows = confCount % 3 == 0 ? confCount / 3 : confCount / 3 + 1;
            if (rows < (vrows = 2)) {
                vrows = rows;
            }
            int cols = 3;
            if (confCount < 3) {
                cols = confCount;
            }
            String prefix = CleanDebug.getNewStringID();
            debug.print("<script type=\"text/javascript\">\n");
            debug.print("<!--\n");
            debug.print("function NewWindow_" + prefix + "( ){\n");
            debug.print("    MyExample=window.open(\"" + prefix + ".html\",\"xname\",\"directories=no,location=no,menubar=no,resizable=yes,status=no,toolbar=no,scrollbars=yes,width=" + (300 * cols + 50) + ",height=" + (300 * vrows + 120) + "\");\n");
            debug.print("}\n");
            debug.print("// -->\n");
            debug.print("</script>\n");
            debug.print("<FORM>");
            debug.print("<input type=\"button\" value=\"" + this.btnmsg + "\" OnClick=\"NewWindow_" + prefix + "()\")\">");
            debug.print("</FORM>");
            debugPrintHTML ap = new debugPrintHTML("DEBUG/" + prefix + ".html");
            ap.print("<CENTER>" + this.popupmsg + "</CENTER><BR>");
            ap.print("<CENTER><applet CODEBASE=\"marvin\" ARCHIVE=\"marvin.jar\" CODE=\"MView\" WIDTH=" + (cols * 300 + 22) + " HEIGHT=" + (vrows * 300 + 42) + ">\n");
            ap.print("<param NAME=\"rows\" VALUE=\"" + rows + "\">\n");
            ap.print("<param NAME=\"border\" VALUE=\"1\">\n");
            ap.print("<param NAME=\"molbg\" VALUE=\"#000000\">\n");
            ap.print("<param NAME=\"cols\" VALUE=\"" + cols + "\">\n");
            ap.print("<param NAME=\"visibleRows\" VALUE=\"" + vrows + "\">\n");
            ap.print("<param NAME=\"implicitH\" VALUE=\"off\">\n");
            ap.print("<param NAME=\"navmode\" VALUE=\"rot3d\">\n");
            ap.print("<param NAME=\"atomNumbersVisible\" VALUE=\"true\">\n");
            ap.print("<param NAME=\"layout\" VALUE=\":2:1:M:1:0:1:1:L:0:0\">\n");
            ap.print("<param NAME=\"param\" VALUE=\":M:300:300:L:10\">\n");
            for (int i = 0; i < confCount; ++i) {
                String fname = prefix + "_conf" + i + ".mol";
                String desc = (String)this.labels.get(i);
                ap.print("<param NAME=\"cell" + i + "\" VALUE=\"|" + (String)this.mfilenames.get(i) + "|" + desc + "\">\n");
                String sel = (String)this.sels.get(i);
                if (sel == "") continue;
                ap.print("<param NAME=\"selection" + i + "\" VALUE=\"" + sel + "\">\n");
            }
            ap.print("<strong>(YOU CANNOT SEE A JAVA APPLET HERE)</strong>\n");
            ap.print("</applet></CENTER>\n");
            ap.print("<CENTER><A HREF=\"javascript:self.close()\">Close this window</A></CENTER>");
            ap.close();
        }
    }
}

