/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.debug;

import chemaxon.marvin.modelling.util.StringConversionUtility;
import chemaxon.struc.DPoint3;
import chemaxon.struc.Molecule;
import java.util.BitSet;

public class ErrPrint {
    static int molID = 0;

    public static void errPrint(Molecule m) {
        ErrPrint.errPrint(null, m);
    }

    public static void errPrint(Molecule m, double[][] coordinates) {
        ErrPrint.errPrint(null, m, coordinates);
    }

    public static void errPrint(String title, Molecule m) {
        ErrPrint.errPrint(title, m, null);
    }

    public static void errPrint(String title, Molecule m, double[][] coordinates) {
        Molecule mol = null;
        ++molID;
        if (title != null) {
            System.err.println(title + "[" + molID + "]");
        } else {
            System.err.println("[" + molID + "]");
        }
        if (coordinates != null) {
            mol = m.cloneMolecule();
            ErrPrint.setMolCoordinates(mol, coordinates);
        } else {
            mol = m;
        }
        try {
            System.out.print(mol.exportToFormat("sdf"));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public static void setMolCoordinates(Molecule m, double[][] coord) {
        DPoint3 c = new DPoint3();
        for (int i = 0; i < coord.length; ++i) {
            c.x = coord[i][0];
            c.y = coord[i][1];
            c.z = coord[i][2];
            m.getAtom(i).setLocation(c);
        }
    }

    public static void errPrint(int[] list) {
        ErrPrint.errPrint(null, list);
    }

    public static void errPrint(String title, int[] list) {
        if (title != null) {
            System.err.println(title);
        }
        for (int i = 0; i < list.length; ++i) {
            System.err.print(ErrPrint.int2Str(4, list[i]));
        }
        System.err.println();
    }

    public static void errPrint(double[] list) {
        ErrPrint.errPrint(null, list);
    }

    public static void errPrint(String title, double[] list) {
        if (title != null) {
            System.err.println(title);
        }
        for (int i = 0; i < list.length; ++i) {
            System.err.print(" " + ErrPrint.double2Str(9, list[i]));
        }
        System.err.println();
    }

    public static void errPrintAtomList(int[] list) {
        ErrPrint.errPrintAtomList(null, list);
    }

    public static void errPrintAtomList(String title, int[] list) {
        if (title != null) {
            System.err.println(title);
        }
        for (int i = 0; i < list.length; ++i) {
            System.err.print(ErrPrint.int2Str(4, list[i] + 1));
        }
        System.err.println();
    }

    public static String int2Str(int nChr, int intVal) {
        String resStr = String.valueOf(intVal);
        while (resStr.length() < nChr) {
            resStr = " " + resStr;
        }
        return resStr;
    }

    public static String double2Str(int nChr, double doubleVal) {
        String resStr = String.valueOf(doubleVal);
        while (resStr.length() < nChr) {
            resStr = " " + resStr;
        }
        resStr = ErrPrint.nDigit(doubleVal, nChr, nChr - 4);
        return resStr;
    }

    public static void errPrint(String[] stringArray) {
        for (String s : stringArray) {
            System.err.print(s + " ");
        }
        System.err.println();
    }

    public static void errPrint(String title, String[] stringArray) {
        if (title != null) {
            System.err.println(title);
        }
        for (String s : stringArray) {
            System.err.print(s + " ");
        }
        System.err.println();
    }

    public static void errPrintAtomList(String title, BitSet bSet) {
        String bSetOut = StringConversionUtility.bitSetToString(bSet);
        System.err.println(title + ": " + bSetOut);
    }

    public static String nDigit(double a, int len, int n) {
        int nDig = 1;
        for (int i = 0; i < n; ++i) {
            nDig *= 10;
        }
        double invnDig = 1.0 / (double)nDig;
        String nD = "";
        if (nDig > 0) {
            double d = Math.round(a * (double)nDig);
            nD = Double.toString(d /= (double)nDig);
        } else {
            nD = Integer.toString((int)Math.round(a));
        }
        while (nD.length() < len) {
            nD = " " + nD;
        }
        return nD;
    }
}

