/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.debug;

import chemaxon.formats.MolExporter;
import chemaxon.marvin.modelling.linalg.GradientOptimization;
import chemaxon.marvin.modelling.linalg.V;
import chemaxon.marvin.modelling.mm.ForceField;
import chemaxon.marvin.modelling.struc.ConformersDescriptor;
import chemaxon.marvin.modelling.util.U;
import chemaxon.struc.Molecule;
import java.io.FileOutputStream;

public class ForceFieldChecker
implements GradientOptimization.FunctionToMinimize {
    private boolean molSaved = false;
    private GradientOptimization.FunctionToMinimize base = null;
    private ForceField baseff = null;
    private Molecule fragmol = null;
    private double[] lastVarSet = null;
    private boolean printAll = false;
    private boolean skipNum = false;
    private double[] varbf = null;
    private double[] gradb = null;
    private double[] stepeps = new double[]{0.001, 1.0E-4, 1.0E-5, 1.0E-6, 1.0E-7, 1.0E-8, 1.0E-9, 1.0E-10, 1.0E-11};
    private int stepepsToWatch = 2;

    public ForceFieldChecker(GradientOptimization.FunctionToMinimize base, Molecule fragmol, boolean printAll, boolean skipNum) {
        this.base = base;
        this.fragmol = fragmol;
        this.printAll = printAll;
        this.skipNum = skipNum;
        if (base instanceof ForceField) {
            this.baseff = (ForceField)base;
        }
    }

    @Override
    public boolean isCancelled() {
        return this.base.isCancelled();
    }

    @Override
    public double[] getVariables() {
        return this.base.getVariables();
    }

    @Override
    public double getFunctionValue() {
        return this.base.getFunctionValue();
    }

    private void checkFFVars() {
        if (this.lastVarSet == null) {
            return;
        }
        double[] v = this.base.getVariables();
        if (v.length != this.lastVarSet.length) {
            throw new UnsupportedOperationException("Variable size mismatch");
        }
        for (int i = 0; i < v.length; ++i) {
            if (v[i] == this.lastVarSet[i]) continue;
            throw new UnsupportedOperationException("Variable mismatch");
        }
    }

    public static double[] getNumericGradient(GradientOptimization.FunctionToMinimize base, double eps) {
        double[] v = base.getVariables();
        double f = base.getFunctionValue();
        double[] ret = new double[v.length];
        ForceFieldChecker.fillNumericGradient(base, eps, f, v, ret);
        return ret;
    }

    private static void fillNumericGradient(GradientOptimization.FunctionToMinimize base, double eps, double f, double[] v, double[] gradb) {
        for (int i = 0; i < gradb.length; ++i) {
            double vi = v[i];
            v[i] = v[i] + eps;
            base.setVariables(v);
            double f2 = base.getFunctionValue();
            gradb[i] = (f2 - f) / eps;
            v[i] = vi;
            base.setVariables(v);
            double f3 = base.getFunctionValue();
            if (f3 == f) continue;
            throw new UnsupportedOperationException("Energy mismatch. Before: " + f + " after: " + f3);
        }
    }

    @Override
    public double[] getFunctionGradient() {
        this.checkFFVars();
        double[] v = this.base.getVariables();
        this.checkFFVars();
        double f = this.base.getFunctionValue();
        this.checkFFVars();
        if (this.varbf == null) {
            this.varbf = U.clone(v);
            this.gradb = new double[v.length];
        } else {
            U.copyTo(this.varbf, v);
        }
        double[] g = this.base.getFunctionGradient();
        this.checkFFVars();
        boolean err = false;
        if (!U.isDoubleOK(f)) {
            err = true;
        }
        if (!this.skipNum) {
            ForceFieldChecker.fillNumericGradient(this.base, this.stepeps[this.stepepsToWatch], f, v, this.gradb);
            this.checkFFVars();
        }
        if (!(U.isDoubleOK(f) && U.isDoubleOK(g) && U.isDoubleOK(this.gradb))) {
            err = true;
        } else if (!this.skipNum && U.maxDiff(g, this.gradb) > 0.01) {
            err = true;
        }
        if (err) {
            Molecule mcopy = null;
            if (this.fragmol != null && (this.printAll || !this.molSaved)) {
                this.molSaved = true;
                mcopy = this.fragmol.cloneMolecule();
            }
            double agabs = V.vectLen(g);
            long timenow = System.currentTimeMillis();
            System.err.println("Gradient error.\tagabs=" + agabs + "\tf=" + f + "\ttimestamp=" + timenow);
            for (int i = 0; i < this.stepeps.length; ++i) {
                ForceFieldChecker.fillNumericGradient(this.base, this.stepeps[i], f, v, this.gradb);
                double ngabs = V.vectLen(this.gradb);
                double dabs = V.vectLen(g, this.gradb);
                System.err.println("\t" + (i == this.stepepsToWatch ? "*" : " ") + "eps=" + this.stepeps[i] + "\tngabs=" + ngabs + "\tdabs=" + dabs);
                if (mcopy == null) continue;
                mcopy.setProperty("CLEAN3D.EPS" + i, "" + this.stepeps[i]);
                mcopy.setProperty("CLEAN3D.NGRADABS" + i, "" + ngabs);
                mcopy.setProperty("CLEAN3D.ANGRDDIFFABS" + i, "" + dabs);
                mcopy.setProperty("CLEAN3D.AGRAD" + i, U.sel(g));
                mcopy.setProperty("CLEAN3D.NGRAD" + i, U.sel(this.gradb));
                mcopy.setProperty("CLEAN3D.ANGRADDIFF" + i, U.sel(V.minus(g, this.gradb)));
            }
            if (mcopy != null) {
                mcopy.setProperty("CLEAN3D.timestamp", "" + timenow);
                mcopy.setProperty("CLEAN3D.AGRADABS", "" + agabs);
                mcopy.setProperty("CLEAN3D.FVALUE", "" + f);
                if (this.baseff != null) {
                    mcopy.setProperty("CLEAN3D.ENERGY", "" + this.baseff.getEnergy());
                    mcopy.setProperty("CLEAN3D.FORCEFIELDGRAD", U.sel(this.baseff.getForceFieldGradient()));
                }
                ConformersDescriptor.writeCoords(mcopy, U.splitTo3D(v));
                String fileName = "gradientMismatch.mrvmultiple";
                System.err.println("Appending molecule to \"" + fileName + "\".");
                try {
                    FileOutputStream molOut = new FileOutputStream(fileName, true);
                    MolExporter mExporter = new MolExporter(molOut, "mrv");
                    mExporter.write(mcopy);
                    molOut.flush();
                    molOut.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return g;
    }

    public GradientOptimization.FunctionToMinimize getBase() {
        return this.base;
    }

    @Override
    public boolean setVariables(double[] var) {
        if (this.lastVarSet == null) {
            this.lastVarSet = new double[var.length];
        }
        if (var.length != this.lastVarSet.length) {
            throw new UnsupportedOperationException("Variable size mismatch");
        }
        U.copyTo(this.lastVarSet, var);
        return this.base.setVariables(var);
    }

    @Override
    public void print() {
        this.base.print();
    }

    @Override
    public void print(String comment) {
        this.base.print(comment);
    }
}

