/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.debug;

import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.TextUtils;
import chemaxon.marvin.modelling.debug.Tracer;
import chemaxon.marvin.modelling.debug.debugPrintHTML;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.util.U;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Vector;

public class Printouts {
    public static void placeJpeg(Molecule m) {
        Printouts.placeJpeg(m, null);
    }

    public static void placeJpeg(Molecule m, String sel) {
        String[] sel2 = null;
        if (sel != null) {
            sel2 = new String[]{sel};
        }
        Printouts.placeJpegs(m, sel2);
    }

    public static void placeJpeg(Molecule m, String sel, String desc) {
        String[] sel2 = null;
        String[] desc2 = null;
        if (sel != null) {
            sel2 = new String[]{sel};
        }
        if (desc != null) {
            desc2 = new String[]{desc};
        }
        Printouts.placeJpegs(m, sel2, desc2);
    }

    public static void placeJpegs(Molecule m, String[] sel) {
        Printouts.placeJpegs(m, sel, null);
    }

    public static void placeJpegs(CallbackIface m, String[] sel, String[] desc) {
        if (CleanArgs.cltracer == null || !CleanArgs.cltracer.getVisualisationStateWithNotification(3)) {
            return;
        }
        Printouts.placeJpegs((Molecule)m.callback(null, null), sel, desc);
    }

    public static void placeJpegs(Molecule m, String[] sel, String[] desc) {
        if (CleanArgs.cltracer == null || !CleanArgs.cltracer.getVisualisationStateWithNotification(3)) {
            return;
        }
        debugPrintout debug = CleanArgs.getDebug();
        try {
            int cells = 1;
            if (sel != null) {
                cells = sel.length;
            }
            debug.Tstart();
            for (int cellCount = 0; cellCount < cells; ++cellCount) {
                if (cellCount % 3 == 0) {
                    debug.Trow();
                }
                String fname = Tracer.getNewID() + ".jpeg";
                for (int i = 0; i < m.getAtomCount(); ++i) {
                    MolAtom a = m.getAtom(i);
                    a.setSelected(false);
                }
                if (sel != null && sel[cellCount] != null) {
                    String[] sels = TextUtils.split(sel[cellCount]);
                    for (int i = 0; i < sels.length; ++i) {
                        MolAtom a = m.getAtom(Integer.parseInt(sels[i]));
                        a.setSelected(true);
                    }
                }
                byte[] d = m.toBinFormat("jpeg:w300,h300");
                FileOutputStream fos = new FileOutputStream("DEBUG/struc/" + fname);
                fos.write(d);
                fos.close();
                String tstring = "<IMG src=\"../struc/" + fname + "\" width=300 height=300 border=1>";
                if (desc != null && desc.length > cellCount) {
                    tstring = tstring + "<BR>" + desc[cellCount];
                }
                debug.Tprint(tstring);
            }
            debug.Tstop();
        }
        catch (Exception e) {
            debug.println("Exception: " + e.getMessage());
            debug.print("<PRE>");
            e.printStackTrace(debug.getPrintWriter());
            debug.print("</PRE>");
        }
    }

    public static Molecule narrowMol(Molecule orig, int[] sels) {
        return Printouts.narrowMol(orig, sels, null);
    }

    public static Molecule narrowMol(Molecule orig, int[] sels, int[] substToH) {
        int i;
        Molecule ret = new Molecule();
        if (sels == null) {
            orig.clonecopy(ret);
            return ret;
        }
        int[] selInv = U.genInverse(sels, orig.getAtomCount());
        int[] substInv = null;
        if (substToH != null) {
            substInv = U.genInverse(substToH, orig.getAtomCount());
        }
        for (i = 0; i < sels.length; ++i) {
            int atndx = sels[i];
            int atno = substInv != null && substInv[atndx] != -1 ? 1 : orig.getAtom(atndx).getAtno();
            ret.add(new MolAtom(atno));
        }
        for (i = 0; i < orig.getBondCount(); ++i) {
            MolBond b = orig.getBond(i);
            int ba1 = orig.indexOf(b.getAtom1());
            int ba2 = orig.indexOf(b.getAtom2());
            if (selInv[ba1] == -1 || selInv[ba2] == -1) continue;
            int na1 = selInv[ba1];
            int na2 = selInv[ba2];
            MolBond nb = new MolBond(ret.getAtom(na1), ret.getAtom(na2), b.getFlags());
            ret.add(nb);
        }
        return ret;
    }

    public static void place3DApplet(String btnlabel, Molecule m, int[] selAtoms, double[][][] coordinates) {
        Printouts.place3DApplet(btnlabel, m, selAtoms, null, coordinates, null);
    }

    public static void place3DApplet(String btnlabel, Molecule m, double[][][] coordinates) {
        Printouts.place3DApplet(btnlabel, m, null, null, coordinates, null);
    }

    public static void place3DApplet(String btnlabel, Molecule m, int[] selAtoms, int[] selects, double[][][] coordinates) {
        Printouts.place3DApplet(btnlabel, m, selAtoms, selects, null, coordinates, null);
    }

    public static void place3DApplet(String btnlabel, Molecule m, int[] selAtoms, double[][][] coordinates, int[] substH) {
        Printouts.place3DApplet(btnlabel, m, selAtoms, null, coordinates, substH);
    }

    public static void place3DApplet(String btnlabel, Molecule m, int[] selAtoms, int[] selects, double[][][] coordinates, int[] substH) {
        Printouts.place3DApplet(btnlabel, m, selAtoms, selects, null, coordinates, substH);
    }

    public static void place3DApplet(String btnlabel, Molecule m) {
        Printouts.place3DApplet(btnlabel, m, null);
    }

    public static void place3DApplet(String btnlabel, Molecule m, int[] selAtoms, int[] selects, int[] selects2, double[][][] coordinates, int[] substH) {
        Printouts.place3DApplet(btnlabel, m, selAtoms, selects, selects2, coordinates, substH, null);
    }

    public static void place3DApplet(String btnlabel, Molecule m, Vector<double[][]> coords, Vector<String> desc) {
        double[][][] c = new double[coords.size()][][];
        for (int i = 0; i < c.length; ++i) {
            c[i] = coords.get(i);
        }
        String[] d = new String[desc.size()];
        for (int i = 0; i < d.length; ++i) {
            d[i] = desc.get(i);
        }
        Printouts.place3DApplet(btnlabel, m, null, null, null, c, null, d);
    }

    public static void place3DApplet(String btnlabel, Molecule m, int[] selAtoms, int[] selects, int[] selects2, double[][][] coordinates, int[] substH, String[] desc) {
        int i;
        String s;
        if (CleanArgs.cltracer == null) {
            return;
        }
        if (!CleanArgs.cltracer.getVisualisationStateWithNotification(2)) {
            return;
        }
        debugPrintout debug = CleanArgs.cltracer.getDebug();
        if (debug == null) {
            return;
        }
        Molecule nm = Printouts.narrowMol(m, selAtoms, substH);
        nm.setDim(3);
        int count = coordinates == null ? 1 : coordinates.length;
        String[] mnames = new String[count];
        String[] sels = null;
        String[] sels2 = null;
        if (selects != null) {
            sels = new String[count];
            s = U.sel(U.genInverse(selAtoms, selects));
            for (i = 0; i < count; ++i) {
                sels[i] = s;
            }
        }
        if (selects2 != null) {
            sels2 = new String[count];
            s = U.sel(U.genInverse(selAtoms, selects2));
            for (i = 0; i < count; ++i) {
                sels2[i] = s;
            }
        }
        for (int i2 = 0; i2 < count; ++i2) {
            if (coordinates != null) {
                for (int j = 0; j < coordinates[i2].length; ++j) {
                    MolAtom a = nm.getAtom(j);
                    a.setXYZ(coordinates[i2][j][0], coordinates[i2][j][1], coordinates[i2][j][2]);
                }
            }
            mnames[i2] = Printouts.storeStructure(nm.toFormat("sdf"), null, ".sdf");
        }
        Printouts.placeApplet(mnames, null, desc, sels, sels2, count, btnlabel, debug);
    }

    public static String storeStructure(String structure, String prefix, String suffix) {
        StringBuffer ret = new StringBuffer(50);
        if (prefix != null) {
            ret.append(prefix);
        }
        ret.append(Tracer.getNewID());
        if (suffix != null) {
            ret.append(suffix);
        }
        try {
            PrintStream ps = new PrintStream(new FileOutputStream("DEBUG/struc/" + ret.toString()));
            ps.print(structure);
            ps.flush();
            ps.close();
        }
        catch (Exception e) {
            System.err.println("Exception");
            e.printStackTrace();
        }
        return ret.toString();
    }

    public static void placeApplet(CallbackIface mfcb, String msg, String[] desc, String[] sel, int fields, String btnlabel) {
        if (CleanArgs.cltracer == null) {
            return;
        }
        if (!CleanArgs.cltracer.getVisualisationStateWithNotification(2)) {
            return;
        }
        debugPrintout debug = CleanArgs.cltracer.getDebug();
        if (debug == null) {
            return;
        }
        String mfname = (String)mfcb.callback(null, null);
        Printouts.placeApplet(new String[]{mfname}, msg, desc, sel, fields, btnlabel, debug);
    }

    public static void placeApplets(CallbackIface mfcb, String msg, String[] desc, String[] sel, int fields, String btnlabel) {
        if (CleanArgs.cltracer == null) {
            return;
        }
        if (!CleanArgs.cltracer.getVisualisationStateWithNotification(2)) {
            return;
        }
        debugPrintout debug = CleanArgs.cltracer.getDebug();
        if (debug == null) {
            return;
        }
        String[] mfnames = (String[])mfcb.callback(null, null);
        Printouts.placeApplet(mfnames, msg, desc, sel, fields, btnlabel, debug);
    }

    public static void placeApplet(String[] mfnames, String msg, String[] desc, String[] sel, int fields, String btnlabel, debugPrintout debug) {
        Printouts.placeApplet(mfnames, msg, desc, sel, null, fields, btnlabel, debug);
    }

    public static void placeApplet(String[] mfnames, String msg, String[] desc, String[] sel, String[] sel2, int fields, String btnlabel, debugPrintout debug) {
        String prefix = Tracer.getNewID();
        String hfname = prefix + ".html";
        int rows = (int)Math.ceil((double)fields / 3.0);
        int vrows = rows > 2 ? 2 : rows;
        int cols = fields < 3 ? fields : 3;
        debugPrintHTML ap = new debugPrintHTML("DEBUG/popup/" + hfname);
        ap.print("<CENTER>" + (msg == null ? "" : msg) + "</CENTER><BR>\n");
        int w = cols * 300 + 22;
        int h = vrows * 300 + 42;
        ap.print("<!-- fields=" + fields + " rows=" + rows + " cols=" + cols + " vrows=" + vrows + "-->\n");
        ap.print("<CENTER>");
        ap.print("<script LANGUAGE=\"JavaScript1.1\" SRC=\"marvin/marvin.js\"></script>");
        ap.print("<script LANGUAGE=\"JavaScript1.1\">");
        ap.print("mview_name = \"MView\";");
        ap.print("mview_begin(\"marvin\", " + w + ", " + h + "); ");
        ap.print("mview_param(\"preload\",\"SmilesExport,MolExport,Clean2D,Clean3D,Parity\");");
        ap.print("mview_param(\"rows\",\"" + rows + "\")\n");
        ap.print("mview_param(\"border\",\"1\")\n");
        ap.print("mview_param(\"molbg\",\"#000000\")\n");
        ap.print("mview_param(\"cols\",\"" + cols + "\")\n");
        ap.print("mview_param(\"visibleRows\",\"" + vrows + "\")\n");
        ap.print("mview_param(\"implicitH\",\"off\")\n");
        ap.print("mview_param(\"navmode\",\"rot3d\")\n");
        ap.print("mview_param(\"atomNumbersVisible\",\"true\")\n");
        ap.print("mview_param(\"atomSize\",\"0.2\")\n");
        ap.print("mview_param(\"layout\",\":2:1:M:1:0:1:1:L:0:0\")\n");
        ap.print("mview_param(\"param\",\":M:300:300:L:10\")\n");
        ap.print("mview_param(\"colorScheme\",\"mono\")\n");
        ap.print("mview_param(\"rendering\",\"wireframe\")\n");
        ap.print("mview_param(\"editable\",2)\n");
        if (sel != null) {
            ap.print("mview_param(\"atomSetColor1\",\"#00FF00\")\n");
        }
        if (sel2 != null) {
            ap.print("mview_param(\"atomSetColor2\",\"#A0FFA0\")\n");
        }
        for (int i = 0; i < fields; ++i) {
            String descs = "";
            if (desc != null && i < desc.length) {
                descs = desc[i];
            }
            String mfname = mfnames.length > i ? mfnames[i] : mfnames[mfnames.length - 1];
            ap.print("mview_param(\"cell" + i + "\",\"|../struc/" + mfname + "|" + descs + "\")\n");
            if (sel != null && i < sel.length && sel[i] != null) {
                ap.print("mview_param(\"atomSet" + i + ".1\",\"" + sel[i] + "\")\n");
            }
            if (sel2 == null || i >= sel2.length || sel2[i] == null) continue;
            ap.print("mview_param(\"atomSet" + i + ".2\",\"" + sel2[i] + "\")\n");
        }
        ap.print("mview_end();");
        ap.print("</script>");
        ap.print("</CENTER>");
        String links = "Structures: ";
        for (int i = 0; i < mfnames.length; ++i) {
            if (mfnames[i] == null) continue;
            links = links + "<A HREF=\"../struc/" + mfnames[i] + "\">[" + i + "]</a> ";
        }
        links = links + "<BR>";
        ap.print(links);
        ap.print("<CENTER><A HREF=\"javascript:self.close()\">Close this window</A></CENTER>");
        ap.close();
        String htmlcontent = "<FORM><input type=\"button\" value=\"" + btnlabel + "\" OnClick=window.open(\"../popup/" + prefix + ".html\",\"" + Tracer.getNewID() + "\",\"directories=no,location=no,menubar=no,resizable=yes,status=no,toolbar=no,scrollbars=yes,width=" + (300 * cols + 50) + ",height=" + (300 * vrows + 160) + "\")>" + "</FORM>";
        if (CleanArgs.cltracer != null) {
            CleanArgs.cltracer.placeVisualisationContent(2, htmlcontent);
        } else {
            debug.print(htmlcontent);
        }
    }
}

