/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.debug;

import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.debug.Tracer;
import chemaxon.marvin.modelling.debug.VerbosePrinter;
import chemaxon.marvin.modelling.debug.debugPrintout;

public class StdErrVerbosePrinter
implements VerbosePrinter {
    private int level = 0;
    private boolean closed = false;
    private StdErrVerbosePrinter child = null;
    private StdErrVerbosePrinter parent = null;
    private debugPrintout debug = null;
    private String indents = null;
    private String id = null;

    private void setLevel(int l) {
        this.level = l;
        if (l == 0) {
            this.indents = "";
        } else {
            StringBuffer ib = new StringBuffer(2 * l + 2);
            for (int i = 0; i < l; ++i) {
                ib.append(' ');
                ib.append(' ');
            }
            this.indents = ib.toString();
        }
    }

    private StdErrVerbosePrinter(int level, StdErrVerbosePrinter parent, debugPrintout debug) {
        this.setLevel(level);
        this.debug = debug;
        this.id = Tracer.getNewID();
        this.parent = parent;
    }

    public StdErrVerbosePrinter() {
        this.setLevel(0);
        this.id = Tracer.getNewID();
    }

    private void printIndents() {
        System.err.print(this.indents);
    }

    public StdErrVerbosePrinter(debugPrintout debug) {
        this.setLevel(0);
        this.debug = debug;
        this.id = Tracer.getNewID();
    }

    public void setDebugPrinter(debugPrintout debug) {
        this.debug = debug;
    }

    private void arriveBack(String s, String detail) {
        if (this.closed) {
            throw new UnsupportedOperationException("ArriveBack() on closed verbose printer");
        }
        if (s != null) {
            this.printIndents();
            System.err.print("<<<");
            System.err.print(s);
            if (detail != null) {
                System.err.print(detail);
            }
            System.err.println();
        }
        this.child = null;
    }

    private void prePrintCheck() {
        if (this.closed) {
            throw new UnsupportedOperationException("Printing attempt on closed verbose printer ID=" + this.id);
        }
        if (this.child != null) {
            this.child.closeFromParent();
            this.child = null;
        }
    }

    @Override
    public void print(String s) {
        this.prePrintCheck();
        if (this.debug != null) {
            this.debug.println(s, true, this.id);
        }
        this.printIndents();
        System.err.println(s);
    }

    @Override
    public void print(String s, String detail) {
        this.prePrintCheck();
        if (this.debug != null) {
            this.debug.println(s, true, detail == null ? this.id : detail + "<BR>" + this.id);
        }
        this.printIndents();
        System.err.println(s + " " + detail);
    }

    @Override
    public VerbosePrinter incDetail(String s) {
        return this.incDetail(s, false);
    }

    public VerbosePrinter incDetail(String s, boolean nodebug) {
        this.prePrintCheck();
        this.printIndents();
        System.err.println(">>>" + s);
        if (this.debug != null && !nodebug) {
            this.debug.incLevel(s);
        }
        this.child = new StdErrVerbosePrinter(this.level + 1, this, nodebug ? null : this.debug);
        CleanArgs.setVP(this.child);
        this.child.print("Opened by " + this.id);
        return this.child;
    }

    @Override
    public void close(String s, String detail) {
        this.print("(close)");
        if (s != null) {
            this.printIndents();
            System.err.print("<<<");
            System.err.print(s);
            if (detail != null) {
                System.err.println(" " + detail);
            }
            if (this.debug != null) {
                this.debug.println(s, true, detail);
                this.debug.decLevel(s);
            }
        } else if (this.debug != null) {
            this.debug.decLevel();
        }
        this.closed = true;
        this.child = null;
        if (this.parent != null) {
            this.parent.arriveBack(s, detail);
        }
    }

    @Override
    public void close(String s) {
        this.close(s, null);
    }

    @Override
    public void close() {
        this.close(null, null);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public StdErrVerbosePrinter getParent() {
        return this.parent;
    }

    private void closeFromParent() {
        this.prePrintCheck();
        this.print("Close from parent");
        if (this.debug != null) {
            this.debug.decLevel();
        }
        this.child = null;
        this.closed = true;
    }
}

