/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.debug;

import chemaxon.marvin.modelling.debug.debugPrintout;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;

public class Tracer {
    static final int INITIAL_CHAIN_ELEMENTS = 20;
    DetailDesc[] chain = new DetailDesc[20];
    int chainp = -1;
    int nextNodeID = 0;
    static boolean showStackTraces = true;
    Select newLevelOpen = null;
    Select enablePrintouts = null;
    Select showVisualisations = null;
    Select maxVisLevels = null;
    int defVisLevel = 0;
    debugPrintout legacyDebug = null;
    boolean doExtensiveDebug = false;
    static int IDcounter = 0;

    public static boolean isShowStackStraces() {
        return showStackTraces;
    }

    public debugPrintout getDebug() {
        if (this.chain[this.chainp].blind || !this.chain[this.chainp].getMsgShowState()) {
            return null;
        }
        return this.legacyDebug;
    }

    public void setExtensiveDebug(boolean b) {
        this.doExtensiveDebug = b;
    }

    public boolean getExtensiveDebug() {
        return this.doExtensiveDebug;
    }

    public void close() {
        if (this.legacyDebug != null) {
            this.legacyDebug.close();
        }
    }

    public Tracer() {
        for (int i = 0; i < this.chain.length; ++i) {
            this.chain[i] = new DetailDesc(-1);
        }
        this.chainp = 0;
        this.chain[0].reset(this.nextNodeID++);
        this.chain[0].incLabel = "Tracer root";
        this.chain[0].blind = false;
        this.chain[0].ms_show = 1;
        new File("DEBUG" + File.separator + "htmls").mkdirs();
        new File("DEBUG" + File.separator + "frames").mkdirs();
        new File("DEBUG" + File.separator + "struc").mkdirs();
        new File("DEBUG" + File.separator + "popup").mkdirs();
        this.legacyDebug = new debugPrintout();
        this.legacyDebug.setDebugLevel(999);
        this.legacyDebug.init();
        this.legacyDebug.println("Started in Tracer()");
    }

    public static void checkTracehelp(String[][] opts) {
        for (int i = 0; i < opts.length; ++i) {
            if (opts[i].length < 1 || !opts[i][0].equalsIgnoreCase("tracehelp")) continue;
            System.err.println(Tracer.getHelpString());
        }
    }

    public static String getHelpString() {
        String helpstr = "\n\nDetailed help on [trace] feature for Clean3D invoked by [tracehelp].\n\nCode offline trace switched on by using option [trace]. The code execution will\nbe followed with HTML log files. In order to achieve efficient logging, several\nrestrictive options can be used to alter logging. In general, code execution\nstructured with detail expansions and checkpoint-like task switches. A task ID\nis assigned to the key points (which are listed below). Some keypoint can have\nnonnegative integer parameter, which can be interpreted as a slave-ID.\n\nThree area can be affected with the restrictive option parameters:\n  - Detail expansion; implemented as a detailed hierarchical level\n  - Messages, which are HTML textual printouts\n  - Visualisations, which can be resource-consuming operations (like exporting\n    a structure in .mol format and putting a viewer applet)\n\nRestrictive parameter format:\n  {LVM<taskID>} or {LVM<taskID>-<taskParam>}\n  {LVM<taskID>_<visLevel>} or {LVM<taskID>-<taskParam>_<visLevel>}\n  where the presence the following characters affects\n    character L for level open\n    character V visualisation\n    character M messages\n\nIf no parameter given for an area (L,V, or M), all activities will be enabled.\nIf at least one parameter given, only the given taskIDs will be enabled\nIf no taskParam given, all task parameters enabled for that taskID\nIf taskParam given, only task with matching taskID and taskParam enabled\n\nVisualisation levels can be handled using optional <visLevel> argument. If it\npresents, the execution with the preceding <taskID> and if present, <taskParam>\nparameters will use the given <visLevel> visualisation level. All other execution\npoints will use the default visualisation level.\n\nSome dependency relations handled when using L level open restrictions.\n\nTask IDs and their dependency relations:\n";
        for (int k = 0; k < 10000; ++k) {
            String n = TIDS.getTaskDesc(k);
            int[] dep = TIDS.getDependency(k);
            if (n == null && dep == null) continue;
            helpstr = helpstr + "  taskID=" + k + "\n";
            if (n != null) {
                helpstr = helpstr + "      function:   " + n + "\n";
            }
            helpstr = helpstr + "      label:      Tracer.TIDS." + TIDS.getTaskLabel(k) + "\n";
            if (dep != null) {
                helpstr = helpstr + "      depends on: ";
                for (int l = 0; l < dep.length; ++l) {
                    String n2 = TIDS.getTaskDesc(dep[l]);
                    if (l != 0) {
                        helpstr = helpstr + ", ";
                    }
                    helpstr = helpstr + dep[l];
                    if (n2 == null) continue;
                    helpstr = helpstr + " (" + n2 + ")";
                }
                helpstr = helpstr + "\n";
            }
            helpstr = helpstr + "\n";
        }
        return helpstr;
    }

    public void parseOptionParameters(String[] params) {
        this.newLevelOpen = new Select(10);
        this.newLevelOpen.maxDepth = 999;
        this.showVisualisations = new Select(10);
        this.showVisualisations.maxDepth = 999;
        this.enablePrintouts = new Select(10);
        this.enablePrintouts.maxDepth = 999;
        debugPrintout debug = this.getDebug();
        if (debug != null) {
            debug.incLevel("Parse tracer settings");
        }
        for (int j = 1; j < params.length; ++j) {
            boolean level = false;
            boolean visual = false;
            boolean msg = false;
            int taskID = -1;
            int taskP = -1;
            int visLevel = -1;
            String s = params[j];
            for (int k = 0; k < s.length(); ++k) {
                char c = s.charAt(k);
                if (c == 'L') {
                    level = true;
                    continue;
                }
                if (c == 'V') {
                    visual = true;
                    continue;
                }
                if (c == 'M') {
                    msg = true;
                    continue;
                }
                if (c == '-') {
                    taskP = 0;
                    continue;
                }
                if (c == '_') {
                    visLevel = 0;
                    continue;
                }
                int n = Integer.parseInt(String.valueOf(c));
                if (taskID == -1 && visLevel == -1) {
                    taskID = n;
                    continue;
                }
                if (taskP == -1 && visLevel == -1) {
                    taskID *= 10;
                    taskID += n;
                    continue;
                }
                if (taskP != -1 && visLevel == -1) {
                    taskP *= 10;
                    taskP += n;
                    continue;
                }
                visLevel *= 10;
                visLevel += n;
            }
            if (debug != null) {
                debug.println("Allow/Deny for " + (level ? "LEVEL " : "") + (visual ? "VISUAL " : "") + (msg ? "MSG " : "") + " taskID: " + taskID + " taskParam: " + taskP);
            }
            if (level) {
                this.newLevelOpen.add(taskID, taskP);
            }
            if (visual) {
                this.showVisualisations.add(taskID, taskP);
            }
            if (msg) {
                this.enablePrintouts.add(taskID, taskP);
            }
            if (visLevel == -1) continue;
            if (this.maxVisLevels == null) {
                this.maxVisLevels = new Select(10);
                this.maxVisLevels.maxDepth = 999;
            }
            if (taskID == -1) {
                this.maxVisLevels.defIParam = visLevel;
                this.chain[0].vislevel = visLevel;
                if (debug == null) continue;
                debug.println("default visLevel : " + visLevel);
                continue;
            }
            this.maxVisLevels.add(taskID, taskP, visLevel);
            if (debug == null) continue;
            debug.println("MaxVisLevels: for ID=" + taskID + " P=" + taskP + " : " + visLevel);
        }
        if (debug != null) {
            debug.decLevel();
        }
    }

    void touch(int n, int nodeID) {
        if (this.chain.length <= n) {
            DetailDesc[] tmp = new DetailDesc[n + 20];
            for (int i = 0; i < this.chain.length; ++i) {
                tmp[i] = this.chain[i];
            }
            this.chain = tmp;
            this.chain[n] = new DetailDesc(nodeID);
        } else {
            this.chain[n].reset(nodeID);
        }
    }

    public void printout(debugPrintout debug) {
        if (debug != null && debug.getWillPrint()) {
            debug.incLevel("State of tracer");
            debug.println("Chainp=" + this.chainp);
            debug.printHR();
            for (int i = 0; i <= this.chainp; ++i) {
                debug.printB("Chain element " + i);
                debug.println("blind: " + this.chain[this.chainp].blind);
                debug.println("ms_show: " + this.chain[this.chainp].ms_show);
                debug.println("getMsgShowState: " + this.chain[this.chainp].getMsgShowState());
                debug.println("getVisualisationsState: " + this.chain[this.chainp].getVisualisationsState());
            }
            debug.printHR();
            debug.printB("newLevelOpen selector");
            this.newLevelOpen.printout(debug);
            debug.printHR();
            debug.printB("showVisualisations selector");
            this.showVisualisations.printout(debug);
            debug.printHR();
            debug.printB("enablePrintouts selector");
            this.enablePrintouts.printout(debug);
            debug.decLevel();
        }
    }

    public boolean incDetail(int taskID, int taskParam) {
        this.touch(this.chainp + 1, this.nextNodeID++);
        boolean blind = this.chain[this.chainp].blind;
        ++this.chainp;
        if (!blind) {
            if (this.newLevelOpen == null || this.newLevelOpen.isAllowed(this.chain, this.chainp, taskID, taskParam)) {
                int newVislevel;
                int newMsgStatus;
                DetailDesc nd = this.chain[this.chainp];
                nd.setNonBlind();
                nd.ms_show = newMsgStatus = (showStackTraces ? 2 : 0) | (this.showVisualisations == null || this.showVisualisations.isAllowed(this.chain, this.chainp, taskID, taskParam) ? 8 : 0) | (this.enablePrintouts == null || this.enablePrintouts.isAllowed(this.chain, this.chainp, taskID, taskParam) ? 1 : 0) | 4;
                nd.vislevel = newVislevel = this.maxVisLevels == null ? this.defVisLevel : this.maxVisLevels.getIParam(taskID, taskParam);
                if (this.legacyDebug != null && this.legacyDebug.getWillPrint()) {
                    String altStr = "incDetail";
                    String tstr = "";
                    if (taskID != -1) {
                        altStr = altStr + " to ID " + taskID + " ";
                        String idstr = TIDS.getTaskDesc(taskID);
                        if (idstr != null) {
                            altStr = altStr + "(" + idstr + ")";
                            tstr = tstr + idstr;
                        }
                        if (taskParam != -1) {
                            altStr = altStr + " param: " + taskParam;
                            tstr = tstr + " " + taskParam;
                        }
                    }
                    nd.legacyDebugPrinterDEC = this.legacyDebug;
                    this.chain[this.chainp - 1].legacyDebugPrinterTAB = this.legacyDebug;
                    this.legacyDebug.print("<TABLE border=0 width=100% BGCOLOR=lightgrey>\n  <TR><TD><img border=1 width=30 height=15 src=\"img/incDetail.gif\" title=\"" + altStr + "\">" + "</TD>\n" + "  <TD width=100%>");
                    this.legacyDebug.incLevel(tstr);
                }
                return true;
            }
            String altStr = "incDetail";
            String tstr = "";
            if (taskID != -1) {
                altStr = altStr + " to ID " + taskID + " ";
                String idstr = TIDS.getTaskDesc(taskID);
                if (idstr != null) {
                    altStr = altStr + "(" + idstr + ")";
                    tstr = tstr + idstr;
                }
                if (taskParam != -1) {
                    altStr = altStr + " param: " + taskParam;
                    tstr = tstr + " " + taskParam;
                }
            }
            this.legacyDebug.print("<TABLE border=0 width=100% BGCOLOR=lightgrey>\n  <TR><TD><img border=1 width=30 height=15 src=\"img/incDetail-notFollow.gif\" title=\"" + altStr + "\">" + "</TD>\n" + "  <TD width=100%>" + tstr + "</TD></TR>\n" + "</TABLE>");
            return false;
        }
        return false;
    }

    public void changeTaskID(int taskID, int taskParam) {
        if (!(this.chainp != 0 && this.chain[this.chainp - 1].blind || this.chain[this.chainp].blind)) {
            int newVislevel;
            int newMsgStatus;
            boolean prn;
            DetailDesc nd = this.chain[this.chainp];
            boolean vis = this.showVisualisations == null || this.showVisualisations.isAllowed(this.chain, this.chainp, taskID, taskParam);
            boolean bl = prn = this.enablePrintouts == null || this.enablePrintouts.isAllowed(this.chain, this.chainp, taskID, taskParam);
            nd.ms_show = newMsgStatus = (showStackTraces ? 2 : 0) | (vis ? 8 : 0) | (prn ? 1 : 0) | 4;
            nd.vislevel = newVislevel = this.maxVisLevels == null ? this.defVisLevel : this.maxVisLevels.getIParam(taskID, taskParam);
            if (this.legacyDebug != null && this.legacyDebug.getWillPrint()) {
                String altStr = "change task";
                String tstr = "";
                if (taskID != -1) {
                    altStr = altStr + " to ID " + taskID + " ";
                    String idstr = TIDS.getTaskDesc(taskID);
                    if (idstr != null) {
                        altStr = altStr + "(" + idstr + ")";
                        tstr = tstr + idstr;
                    }
                    if (taskParam != -1) {
                        altStr = altStr + " param: " + taskParam;
                        tstr = tstr + " " + taskParam;
                    }
                }
                this.legacyDebug.print("<TABLE border=0 width=100% BGCOLOR=#B0B0B0>\n  <TR><TD><img border=1 width=30 height=15 src=\"img/switchTask.gif\" title=\"" + altStr + "\">" + "</TD>\n" + "  <TD width=100%>" + tstr + "</TD></TR>\n" + "</TABLE>");
            }
        }
    }

    public void changeTaskID(int taskID) {
        this.changeTaskID(taskID, -1);
    }

    public void decDetail(int nodeID) {
        if (nodeID == -1) {
            if (this.chainp <= 0) {
                this.reportError(0, "Tried to close top level");
            } else if (!this.chain[this.chainp - 1].blind) {
                this.chain[this.chainp--].closeLevel();
                this.chain[this.chainp].arriveBack();
            } else {
                --this.chainp;
            }
        } else {
            while (this.chainp >= 0 && this.chain[this.chainp].nodeID != nodeID) {
                if (this.chainp == 0) {
                    this.reportError(0, "Tried to close top level");
                    break;
                }
                this.chain[this.chainp--].closeLevel();
                this.chain[this.chainp].arriveBack();
            }
        }
    }

    public boolean incDetail() {
        return this.incDetail(-1, -1);
    }

    public boolean incDetail(int taskID) {
        return this.incDetail(taskID, Tracer.getNewIntID());
    }

    public void decDetail() {
        this.decDetail(-1);
    }

    public int getNodeID() {
        return this.chain[this.chainp].nodeID;
    }

    public debugPrintout switchDebug(debugPrintout debug_on, debugPrintout debug_off) {
        if (this.getMsgShowState()) {
            return debug_on;
        }
        return debug_off;
    }

    public boolean isBlind() {
        return this.chain[this.chainp].blind;
    }

    public boolean getVisualisationState() {
        return !this.chain[this.chainp].blind && this.chain[this.chainp].getVisualisationsState();
    }

    public boolean getVisualisationState(int l) {
        return !this.chain[this.chainp].blind && this.chain[this.chainp].getVisualisationState(l);
    }

    public boolean getVisualisationStateWithNotification(int l) {
        if (this.chain[this.chainp].blind) {
            return false;
        }
        boolean ret = this.getVisualisationState(l);
        if (!ret && this.legacyDebug != null && this.legacyDebug.willPrint) {
            String altStr = "Visualisation not shown for level ID " + l + " (current=" + this.chain[this.chainp].vislevel + ")";
            String tstr = "no visualisation";
            this.legacyDebug.print("<TABLE border=0 width=100% BGCOLOR=#F0F0FF>\n  <TR><TD><img border=1 width=30 height=15 src=\"img/incLevel-noinfovis.gif\" title=\"" + altStr + "\">" + "</TD>\n" + "  <TD width=100%>" + tstr + "</TD></TR>\n" + "</TABLE>");
        }
        return ret;
    }

    public void placeVisualisationContent(int l, String s) {
        if (this.chain[this.chainp].blind) {
            return;
        }
        if (this.legacyDebug != null && this.legacyDebug.willPrint) {
            String altStr = "Visualisation shown for level ID " + l;
            this.legacyDebug.print("<TABLE border=0 width=100% BGCOLOR=#F0F0FF>\n  <TR><TD><img border=1 width=30 height=15 src=\"img/incLevel-infovis.gif\" title=\"" + altStr + "\">" + "</TD>\n" + "  <TD width=100%>" + s + "</TD></TR>\n" + "</TABLE>");
        }
    }

    public static String getNewID() {
        String ret = "trid_" + IDcounter;
        ++IDcounter;
        return ret;
    }

    public static int getNewIntID() {
        return IDcounter++;
    }

    public void dumpObject(int l, Serializable o, String msg) {
        if (this.getVisualisationStateWithNotification(l)) {
            String ID = Tracer.getNewID();
            String s = ID + ".serbin";
            try {
                ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(s));
                oos.writeObject(o);
                oos.close();
                s = "<script type=\"text/javascript\">\n<!--\nfunction NewWindow_" + ID + "( ){\n" + "xx=window.open(\"" + ID + ".html\",\"xname\",\"directories=no,location=no,menubar=no,resizable=yes,status=no,toolbar=no,scrollbars=yes,width=350,height=420\");\n" + "}\n" + "// -->\n" + "</script>\n" + "<FORM><input type=\"button\" value=\"" + msg + "\" OnClick=\"NewWindow_" + ID + "()\")\"></FORM>\n";
                this.placeVisualisationContent(l, msg + ": " + s);
            }
            catch (Exception e) {
                this.reportError(20, "Failed dumpObject(): " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public boolean getMsgShowState() {
        return this.chain[this.chainp].getMsgShowState();
    }

    public void detailLabel(String s) {
        if (!this.chain[this.chainp].blind) {
            this.chain[this.chainp].incLabel = s;
        }
    }

    public void println(String s) {
        this.chain[this.chainp].println(s);
    }

    public void reportError(int severity, String message) {
        System.err.println("Error message: " + message);
        debugPrintout debug = this.getDebug();
        if (debug != null && debug.getWillPrint()) {
            debug.print("<TABLE border=0 width=100% BGCOLOR=#FFB0B0>\n  <TR><TD><img border=1 width=30 height=15 src=\"img/reportError.gif\" title=\"Error reported: " + message + " Severity=" + severity + "\">" + "</TD>\n" + "  <TD width=100%>(" + severity + ") " + message + "</TD></TR>\n" + "</TABLE>");
        }
    }

    public void reportException(Exception e) {
        System.err.println("Exception reported. Message: " + e.getMessage());
        e.printStackTrace();
        debugPrintout debug = this.getDebug();
        if (debug != null) {
            debug.reportError("Exception");
            try {
                debug.printHR();
                debug.println("Runtime exception caught: ");
                debug.println(e.getMessage());
                debug.print("<PRE>");
                e.printStackTrace(debug.getPrintWriter());
                debug.println("</PRE>");
                debug.setLevel(0);
                debug.printHR();
                debug.println("Runtime exception caught: ");
                debug.println(e.getMessage());
                debug.print("<PRE>");
                e.printStackTrace(debug.getPrintWriter());
                debug.println("</PRE>");
            }
            catch (Exception ee) {
                System.err.println(ee.getMessage());
                ee.printStackTrace();
            }
        }
    }

    public static class TIDS {
        public static final int TIDLIMIT = 10000;
        public static final int MODFUNC = 1;
        public static final int STARTCLEAN = 2;
        public static final int MAKECOORD = 3;
        public static final int MAKECOORDS_STEPDONE = 4;
        public static final int FUSESTEP = 5;
        public static final int FUSE_STARTPLACE = 6;
        public static final int FUSE_START_SELECTION = 7;
        public static final int FUSE_SEQ_GEN = 8;
        public static final int OPTIMIZATION = 9;
        public static final int FUSEBUILDER_INVOKECLEAN = 10;
        public static final int DREIDINGENERGY = 11;

        public static String getTaskLabel(int taskID) {
            Field[] f = TIDS.class.getFields();
            if (f != null && f.length != 0) {
                for (int i = 0; i < f.length; ++i) {
                    try {
                        if (f[i].getInt(null) == taskID) {
                            return f[i].getName();
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return null;
        }

        public static String getTaskDesc(int taskID) {
            switch (taskID) {
                case 1: {
                    return "modfunc()";
                }
                case 2: {
                    return "startClean()";
                }
                case 3: {
                    return "makeCoord()";
                }
                case 4: {
                    return "inside makeCoord() step done";
                }
                case 5: {
                    return "fuse step";
                }
                case 6: {
                    return "start placement";
                }
                case 7: {
                    return "start selection";
                }
                case 8: {
                    return "fuse sequence generation";
                }
                case 9: {
                    return "optimization";
                }
                case 10: {
                    return "Invoke clean";
                }
                case 11: {
                    return "Calc Dreiding energy";
                }
            }
            return null;
        }

        public static int[] getDependency(int taskID) {
            switch (taskID) {
                case 2: {
                    return new int[]{1};
                }
                case 3: {
                    return new int[]{2};
                }
                case 4: {
                    return new int[]{3};
                }
                case 6: {
                    return new int[]{5};
                }
                case 7: {
                    return new int[]{5};
                }
                case 8: {
                    return new int[]{3};
                }
            }
            return null;
        }
    }

    public static class Select {
        public int maxDepth = 0;
        public int[] allowedTaskIDs = null;
        public int[] allowedTaskParams = null;
        public int allowedTaskIDcount = 0;
        public int defIParam = 0;
        public int[] iParams = null;

        public Select(int n) {
            this.allowedTaskIDs = new int[n];
            this.allowedTaskParams = new int[n];
            this.iParams = new int[n];
        }

        void touch(int n) {
            if (this.allowedTaskIDs.length <= n) {
                int[] tmp1 = new int[n * 2];
                int[] tmp2 = new int[n * 2];
                int[] tmp3 = new int[n * 2];
                for (int i = 0; i < this.allowedTaskIDs.length; ++i) {
                    tmp1[i] = this.allowedTaskIDs[i];
                    tmp2[i] = this.allowedTaskParams[i];
                    tmp3[i] = this.iParams[i];
                }
                this.allowedTaskIDs = tmp1;
                this.allowedTaskParams = tmp2;
                this.iParams = tmp3;
            }
        }

        public void add(int ID, int P, int iP) {
            this.touch(this.allowedTaskIDcount);
            this.allowedTaskIDs[this.allowedTaskIDcount] = ID;
            this.allowedTaskParams[this.allowedTaskIDcount] = P;
            this.iParams[this.allowedTaskIDcount] = iP;
            ++this.allowedTaskIDcount;
        }

        public void add(int ID, int P) {
            this.add(ID, P, this.defIParam);
        }

        public void add(int ID) {
            this.add(ID, -1);
        }

        public void setLastIParam(int iP) {
            this.iParams[this.allowedTaskIDcount - 1] = iP;
        }

        public int getIParam() {
            return this.defIParam;
        }

        public int getIParam(int taskID) {
            if (taskID == -1) {
                return this.defIParam;
            }
            for (int i = 0; i < this.allowedTaskIDcount; ++i) {
                if (this.allowedTaskIDs[i] != taskID || this.allowedTaskParams[i] != -1) continue;
                return this.iParams[i];
            }
            return this.defIParam;
        }

        public int getIParam(int taskID, int taskParam) {
            if (taskParam == -1) {
                return this.getIParam(taskID);
            }
            int ret = this.defIParam;
            for (int i = 0; i < this.allowedTaskIDcount; ++i) {
                if (this.allowedTaskIDs[i] != taskID) continue;
                if (this.allowedTaskParams[i] == taskParam) {
                    return this.iParams[i];
                }
                if (this.allowedTaskParams[i] != -1) continue;
                ret = this.iParams[i];
            }
            return ret;
        }

        public void printout(debugPrintout debug) {
            debug.println("Max depth: " + this.maxDepth);
            debug.println("Allowed id count: " + this.allowedTaskIDcount);
            for (int i = 0; i < this.allowedTaskIDcount; ++i) {
                String s = "ID" + i + " " + this.allowedTaskIDs[i] + " (" + TIDS.getTaskDesc(this.allowedTaskIDs[i]) + ")";
                if (this.allowedTaskParams == null) continue;
                s = s + " param: " + this.allowedTaskParams[i];
                debug.println(s);
            }
        }

        boolean isPresentTID(int taskID) {
            if (this.allowedTaskIDcount > 0) {
                for (int i = 0; i < this.allowedTaskIDcount; ++i) {
                    if (this.allowedTaskIDs[i] != taskID) continue;
                    return true;
                }
                return false;
            }
            return true;
        }

        public void checkDependency(boolean echo) {
            if (echo) {
                System.err.println("Checking dependency");
            }
            if (this.allowedTaskIDcount > 0) {
                boolean added = true;
                while (added) {
                    added = false;
                    for (int i = 0; i < this.allowedTaskIDcount; ++i) {
                        int tid = this.allowedTaskIDs[i];
                        int[] dep = TIDS.getDependency(tid);
                        if (dep == null) continue;
                        for (int j = 0; j < dep.length; ++j) {
                            if (this.isPresentTID(dep[j])) continue;
                            if (echo) {
                                System.err.println("  " + TIDS.getTaskDesc(tid) + " requires to add " + TIDS.getTaskDesc(dep[j]));
                            }
                            this.add(dep[j]);
                            added = true;
                        }
                    }
                }
            }
        }

        boolean isAllowed(DetailDesc[] chain, int chainp, int taskID, int taskParam) {
            if (this.maxDepth <= chainp) {
                return false;
            }
            if (this.allowedTaskIDcount > 0) {
                for (int i = 0; i < this.allowedTaskIDcount; ++i) {
                    if (this.allowedTaskIDs[i] != taskID || this.allowedTaskParams != null && this.allowedTaskParams[i] != -1 && this.allowedTaskParams[i] != taskParam) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
    }

    public static class DetailDesc {
        public int taskID = -1;
        public int nodeID = -1;
        public int iParam = -1;
        boolean blind = true;
        public static final int MS_SHOW_MSG = 1;
        public static final int MS_SHOW_STACKTRACE = 2;
        public static final int MS_SHOW_ERROR_REPORT = 4;
        public static final int MS_SHOW_VISUALISATION = 8;
        public int ms_show = 0;
        public int vislevel = -1;
        debugPrintout legacyDebugPrinterDEC = null;
        debugPrintout legacyDebugPrinterTAB = null;
        public String incLabel = null;

        public DetailDesc(int nodeID) {
            this.nodeID = nodeID;
        }

        public void reset(int nodeID) {
            this.blind = true;
            this.nodeID = nodeID;
            this.legacyDebugPrinterDEC = null;
            this.legacyDebugPrinterTAB = null;
        }

        public void setNonBlind() {
            this.blind = false;
        }

        public void setMsgShowStatus(int newStatus) {
            this.ms_show |= newStatus;
        }

        public void closeLevel() {
            if (this.legacyDebugPrinterDEC != null) {
                this.legacyDebugPrinterDEC.decLevel();
            }
        }

        public void arriveBack() {
            if (this.legacyDebugPrinterTAB != null) {
                this.legacyDebugPrinterTAB.print("</TD></TR>\n</TABLE>");
            }
        }

        public boolean getVisualisationsState() {
            if (!this.blind) {
                return (this.ms_show & 8) != 0;
            }
            return false;
        }

        public boolean getVisualisationState(int l) {
            return this.getVisualisationsState() && this.vislevel >= l;
        }

        public boolean getMsgShowState() {
            if (!this.blind) {
                return (this.ms_show & 1) != 0;
            }
            return false;
        }

        public void println(String s) {
        }
    }
}

