/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.diag;

import chemaxon.marvin.modelling.build.fafuse.FragmentAtomFuseItem;
import chemaxon.marvin.modelling.build.fafuse.FragmentAtomFuseStore;
import chemaxon.marvin.modelling.build.fafuse.FragmentStore;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.util.myList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class CleanCheck {

    public static class BuildParamLog
    implements Serializable {
        static final long serialVersionUID = -582320810599834827L;
        public LDAG dagstore = null;
        public static final int PROP_STEPNO = 0;
        public static final int PROP_TYPE = 1;
        public static final int PROP_TYPE_FRAGCONFID = 0;
        public static final int PROP_TYPE_FINALID = 1;
        public static final int PROP_ID = 2;
        public static final int PROP_ENERGY = 3;
        public static final int EPROP_TYPE = 0;
        public static final int EPROP_TYPE_CONFCONFID = 0;
        public static final int EPROP_TYPE_PLACETRIANGID = 1;
        public static final int EPROP_TYPE_OPTIMIZATIONID = 2;
        public static final int EPROP_TYPE_PLACERICTID = 3;
        public static final int EPROP_TYPE_MERGETOSTOREID = 4;
        public static final int EPROP_RICT_DESCRIPTOR = 1;
        public static final int EPROP_OPT_BEFORE = 1;
        public static final int EPROP_OPT_AFTER = 2;

        public int getNodeType(int n) {
            return (Integer)this.dagstore.getNodeProperty(n, 1);
        }

        public int getBondType(int n) {
            return (Integer)this.dagstore.getBondProperty(n, 0);
        }

        public int getNodeID(int n) {
            return (Integer)this.dagstore.getNodeProperty(n, 2);
        }

        public int getNodeStep(int n) {
            return (Integer)this.dagstore.getNodeProperty(n, 0);
        }

        public FragmentAtomFuseItem.RICTdescItem getBondRICTdesc(int n) {
            return (FragmentAtomFuseItem.RICTdescItem)this.dagstore.getBondProperty(n, 1);
        }

        public pstore evalParamLog() {
            pstore ret = new pstore();
            int maxstep = -1;
            int nid = 0;
            int[][] BCLIST = this.dagstore.getBCLIST();
            for (int i = 0; i < this.dagstore.getNodes(); ++i) {
                if ((Integer)this.dagstore.getNodeProperty(i, 1) != 0) continue;
                int step = (Integer)this.dagstore.getNodeProperty(i, 0);
                int id = (Integer)this.dagstore.getNodeProperty(i, 2);
                if (id != 0 || maxstep >= step) continue;
                nid = i;
                maxstep = step;
            }
            int next = nid;
            while (next != -1) {
                int id = (Integer)this.dagstore.getNodeProperty(next, 2);
                switch ((Integer)this.dagstore.getNodeProperty(next, 1)) {
                    case 1: {
                        if (this.getBondType(BCLIST[next][0]) == 2) break;
                        ret.mergeFinNode(id);
                        break;
                    }
                    case 0: {
                        ret.mergeConfNode(id);
                    }
                }
                int eno = -1;
                for (int i = 0; i < BCLIST[next].length; ++i) {
                    int j = BCLIST[next][i];
                    if ((Integer)this.dagstore.getBondProperty(j, 0) == 0) continue;
                    eno = j;
                    break;
                }
                if (eno != -1) {
                    int step = this.getNodeStep(next);
                    int[] qi = new int[]{0};
                    Object[] qo = new Object[]{new Integer(step)};
                    int[] csn = this.dagstore.queryAllNodes(qi, qo);
                    ret.initBest();
                    for (int i = 0; i < csn.length; ++i) {
                        block16: for (int j = 0; j < BCLIST[csn[i]].length; ++j) {
                            int e = BCLIST[csn[i]][j];
                            switch (this.getBondType(e)) {
                                case 3: {
                                    ret.mergeBestRICTedge((FragmentAtomFuseItem.RICTdescItem)this.dagstore.getBondProperty(e, 1));
                                    continue block16;
                                }
                                case 2: {
                                    ret.mergeBestOPTedge((FragmentAtomFuseStore.FinalDescriptor)this.dagstore.getBondProperty(e, 1), null);
                                }
                            }
                        }
                    }
                }
                next = -1;
                if (eno == -1) continue;
                switch ((Integer)this.dagstore.getBondProperty(eno, 0)) {
                    case 3: {
                        ret.mergeRICTedge((FragmentAtomFuseItem.RICTdescItem)this.dagstore.getBondProperty(eno, 1));
                        break;
                    }
                    case 2: {
                        ret.mergeOPTedge((FragmentAtomFuseStore.FinalDescriptor)this.dagstore.getBondProperty(eno, 1), null);
                    }
                }
                next = this.dagstore.getBondSrc(eno);
            }
            return ret;
        }

        public BuildParamLog(int n) {
            int ne;
            int ee = ne = n * 200;
            int pe = ne;
            this.dagstore = new LDAG(ne, ee, pe);
        }

        public void initFromFragmentStore(int stepno, FragmentStore frags) {
            this.dagstore.empty();
            int c = frags.getConformerCount(stepno);
            for (int i = 0; i < c; ++i) {
                int nnode = this.dagstore.addNode(4);
                this.dagstore.addNodeProperty(nnode, 0, new Integer(stepno));
                this.dagstore.addNodeProperty(nnode, 1, new Integer(0));
                this.dagstore.addNodeProperty(nnode, 2, new Integer(i));
                this.dagstore.addNodeProperty(nnode, 3, new Double(0.0));
            }
        }

        public void mergeSelASelC(int stepno, FragmentAtomFuseStore store, int n, int[] selA, int[] selC) {
            for (int i = 0; i < n; ++i) {
                int nnode = this.dagstore.addNode(4);
                this.dagstore.addNodeProperty(nnode, 0, new Integer(stepno));
                this.dagstore.addNodeProperty(nnode, 1, new Integer(0));
                this.dagstore.addNodeProperty(nnode, 2, new Integer(i));
                this.dagstore.addNodeProperty(nnode, 3, new Double(0.0));
                int c = store.getTargetConfNo(store.getFinal(selA[i]));
                int[] qi = new int[]{0, 1, 2};
                Object[] qo = new Object[]{new Integer(stepno - 1), new Integer(0), new Integer(c)};
                int src = this.dagstore.queryFirstNode(qi, qo);
                int nedge = this.dagstore.addEdge(src, nnode, 1);
                this.dagstore.addEdgeProperty(nedge, 0, new Integer(0));
                int[] qi2 = new int[]{0, 1, 2};
                Object[] qo2 = new Object[]{new Integer(stepno), new Integer(1), new Integer(selA[i])};
                int src2 = this.dagstore.queryFirstNode(qi2, qo2);
                int nedge2 = this.dagstore.addEdge(src2, nnode, 1);
                this.dagstore.addEdgeProperty(nedge2, 0, new Integer(4));
            }
        }

        public void mergeAtomPlaceTriangFinalization(int stepno, int conf, int fin) {
            int nnode = this.dagstore.addNode(4);
            this.dagstore.addNodeProperty(nnode, 0, new Integer(stepno));
            this.dagstore.addNodeProperty(nnode, 1, new Integer(1));
            this.dagstore.addNodeProperty(nnode, 2, new Integer(fin));
            this.dagstore.addNodeProperty(nnode, 3, new Double(0.0));
            int[] qi = new int[]{0, 1, 2};
            Object[] qo = new Object[]{new Integer(stepno - 1), new Integer(0), new Integer(conf)};
            int src = this.dagstore.queryFirstNode(qi, qo);
            int nedge = this.dagstore.addEdge(src, nnode, 1);
            this.dagstore.addEdgeProperty(nedge, 0, new Integer(1));
        }

        public void mergeAtomRICTFinalization(int stepno, int conf, int fin, FragmentAtomFuseItem.RICTdescItem desc) {
            int nnode = this.dagstore.addNode(4);
            this.dagstore.addNodeProperty(nnode, 0, new Integer(stepno));
            this.dagstore.addNodeProperty(nnode, 1, new Integer(1));
            this.dagstore.addNodeProperty(nnode, 2, new Integer(fin));
            this.dagstore.addNodeProperty(nnode, 3, new Double(0.0));
            int[] qi = new int[]{0, 1, 2};
            Object[] qo = new Object[]{new Integer(stepno - 1), new Integer(0), new Integer(conf)};
            int src = this.dagstore.queryFirstNode(qi, qo);
            int nedge = this.dagstore.addEdge(src, nnode, 2);
            this.dagstore.addEdgeProperty(nedge, 0, new Integer(3));
            this.dagstore.addEdgeProperty(nedge, 1, desc);
        }

        public int mergeOptimizationStep(int stepno, int fin, int fin2, FragmentAtomFuseStore.FinalDescriptor desc) {
            int nnode = this.dagstore.addNode(4);
            this.dagstore.addNodeProperty(nnode, 0, new Integer(stepno));
            this.dagstore.addNodeProperty(nnode, 1, new Integer(1));
            this.dagstore.addNodeProperty(nnode, 2, new Integer(fin2));
            this.dagstore.addNodeProperty(nnode, 3, new Double(0.0));
            int[] qi = new int[]{0, 1, 2};
            Object[] qo = new Object[]{new Integer(stepno), new Integer(1), new Integer(fin)};
            int src = this.dagstore.queryFirstNode(qi, qo);
            int nedge = this.dagstore.addEdge(src, nnode, 3);
            this.dagstore.addEdgeProperty(nedge, 0, new Integer(2));
            this.dagstore.addEdgeProperty(nedge, 1, desc);
            return nedge;
        }

        public void reportOptimizedFinalDescriptor(int edgeno, FragmentAtomFuseStore.FinalDescriptor desc) {
            this.dagstore.addEdgeProperty(edgeno, 2, desc);
        }

        public void renderToHTML(debugPrintout debug) {
            int k;
            int j;
            int id;
            int step;
            int i;
            int maxstep = 0;
            int maxindex = 0;
            for (int i2 = 0; i2 < this.dagstore.getNodes(); ++i2) {
                int step2 = (Integer)this.dagstore.getNodeProperty(i2, 0);
                int id2 = (Integer)this.dagstore.getNodeProperty(i2, 2);
                if (step2 > maxstep) {
                    maxstep = step2;
                }
                if (id2 <= maxindex) continue;
                maxindex = id2;
            }
            int[][][] r = new int[maxstep + 1][][];
            int[] sublevel = this.dagstore.createSublevel(0);
            for (i = 0; i <= maxstep; ++i) {
                int ni = this.dagstore.queryFirstNode(0, new Integer(i));
                int subs = this.dagstore.getSublevelCount(ni, 0);
                r[i] = new int[subs][1];
            }
            for (i = 0; i < this.dagstore.getNodes(); ++i) {
                step = (Integer)this.dagstore.getNodeProperty(i, 0);
                if (r[step][sublevel[i]][0] >= (id = ((Integer)this.dagstore.getNodeProperty(i, 2)).intValue())) continue;
                r[step][sublevel[i]][0] = id;
            }
            for (i = 0; i <= maxstep; ++i) {
                for (j = 0; j < r[i].length; ++j) {
                    r[i][j] = new int[r[i][j][0] + 1];
                    for (k = 0; k < r[i][j].length; ++k) {
                        r[i][j][k] = -1;
                    }
                }
            }
            for (i = 0; i < this.dagstore.getNodes(); ++i) {
                step = (Integer)this.dagstore.getNodeProperty(i, 0);
                id = (Integer)this.dagstore.getNodeProperty(i, 2);
                r[step][sublevel[i]][id] = i;
            }
            debug.Tstart();
            debug.Trow();
            debug.TprintBC(1, 1, "");
            for (i = 0; i <= maxstep; ++i) {
                debug.TprintBC(1, 2 * r[i].length, "Step: " + i);
            }
            this.dagstore.getCTAB();
            for (i = 0; i <= maxindex; ++i) {
                int ci;
                int l;
                String np;
                int ni;
                debug.Trow();
                debug.TprintBC(2, 1, "" + i);
                for (j = 0; j <= maxstep; ++j) {
                    for (k = 0; k < r[j].length; ++k) {
                        if (r[j][k].length <= i || r[j][k][i] == -1) {
                            debug.TprintBC(2, 1, "");
                            debug.Tprint("");
                            continue;
                        }
                        ni = r[j][k][i];
                        np = "<B>" + ni + "</B> ";
                        switch ((Integer)this.dagstore.getNodeProperty(ni, 1)) {
                            case 1: {
                                np = np + "<B>f</B>";
                                break;
                            }
                            case 0: {
                                np = np + "<B>C</B>";
                            }
                        }
                        debug.TprintBC(2, 1, np);
                        debug.print("<TD><CENTER>&nbsp;");
                        for (l = 0; l < this.dagstore.CLIST[ni].length; ++l) {
                            ci = this.dagstore.CLIST[ni][l];
                            if ((Integer)this.dagstore.getBondProperty(ci, 0) == 0) continue;
                            int dst = this.dagstore.getBondDest(ci);
                            switch ((Integer)this.dagstore.getBondProperty(ci, 0)) {
                                case 4: {
                                    debug.print("(" + dst + ":M) ");
                                    break;
                                }
                                case 2: {
                                    debug.incLevel("(" + dst + ":O) ");
                                    FragmentAtomFuseStore.FinalDescriptor fdi1 = (FragmentAtomFuseStore.FinalDescriptor)this.dagstore.getBondProperty(ci, 1);
                                    FragmentAtomFuseStore.FinalDescriptor fdi2 = (FragmentAtomFuseStore.FinalDescriptor)this.dagstore.getBondProperty(ci, 2);
                                    debug.Tstart();
                                    FragmentAtomFuseStore.FinalDescriptor.printoutHeaderRow(debug);
                                    fdi1.printoutRow(0, debug);
                                    fdi2.printoutRow(1, debug);
                                    debug.Tstop();
                                    debug.decLevel();
                                    break;
                                }
                                case 3: {
                                    debug.incLevel("(" + dst + ":R) ");
                                    debug.println("RICT descriptor");
                                    FragmentAtomFuseItem.RICTdescItem rdi = (FragmentAtomFuseItem.RICTdescItem)this.dagstore.getBondProperty(ci, 1);
                                    debug.Tstart();
                                    FragmentAtomFuseItem.RICTdescItem.printoutHeaderRow(debug);
                                    rdi.printoutRow(0, debug);
                                    debug.Tstop();
                                    debug.decLevel();
                                    break;
                                }
                                case 1: {
                                    debug.print("(" + dst + ":T) ");
                                }
                            }
                            np = np + ")";
                        }
                        if (np == "") {
                            np = "...";
                        }
                        debug.print("</CENTER></TD>");
                    }
                }
                debug.Trow();
                for (j = 0; j <= maxstep; ++j) {
                    for (k = 0; k < r[j].length; ++k) {
                        if (r[j][k].length <= i || r[j][k][i] == -1) {
                            debug.Tprint("");
                            continue;
                        }
                        ni = r[j][k][i];
                        np = "";
                        for (l = 0; l < this.dagstore.CLIST[ni].length; ++l) {
                            ci = this.dagstore.CLIST[ni][l];
                            if ((Integer)this.dagstore.getBondProperty(ci, 0) != 0) continue;
                            np = np + "(" + this.dagstore.getBondDest(ci) + ":";
                            switch ((Integer)this.dagstore.getBondProperty(ci, 0)) {
                                case 0: {
                                    np = np + "CC";
                                }
                            }
                            np = np + ") ";
                        }
                        if (np == "") {
                            np = "...";
                        }
                        debug.Tprint(np);
                    }
                }
            }
            debug.Tstop();
        }

        public void print() {
            int i;
            System.err.println("Nodes");
            for (i = 0; i < this.dagstore.getNodes(); ++i) {
                System.err.print("    " + i + "  ");
                System.err.print(" Step: " + (Integer)this.dagstore.getNodeProperty(i, 0));
                System.err.print(" Conf: " + (Integer)this.dagstore.getNodeProperty(i, 2));
                System.err.print(" Type: ");
                switch ((Integer)this.dagstore.getNodeProperty(i, 1)) {
                    case 1: {
                        System.err.print("Final");
                        break;
                    }
                    case 0: {
                        System.err.print("FRAGC");
                    }
                }
                System.err.println();
            }
            System.err.println("Edges");
            for (i = 0; i < this.dagstore.getBonds(); ++i) {
                System.err.print("    " + i + "  ");
                System.err.print(" Src: " + this.dagstore.getBondSrc(i));
                System.err.print(" Dst: " + this.dagstore.getBondDest(i));
                System.err.print(" Type: ");
                switch ((Integer)this.dagstore.getBondProperty(i, 0)) {
                    case 0: {
                        System.err.print("CONF-CONF");
                        break;
                    }
                    case 4: {
                        System.err.print("MERGE to store");
                        break;
                    }
                    case 2: {
                        System.err.print("optimizationF");
                        break;
                    }
                    case 3: {
                        System.err.print("RICT");
                        break;
                    }
                    case 1: {
                        System.err.print("TRIANG");
                    }
                }
                System.err.println();
            }
        }

        public static class pstore
        implements Cloneable {
            public int maxconfno = 0;
            public int maxfinalid = 0;
            public double maxRICTRMSD0 = 0.0;
            public double maxRICTRMSD1 = 0.0;
            public double maxDEBefore = 0.0;
            public double maxDRICTRMSD0 = 0.0;
            public double maxDRICTRMSD1 = 0.0;
            public double maxDDEBefore = 0.0;
            double bestRICTRMSD0 = Double.MAX_VALUE;
            double bestRICTRMSD1 = Double.MAX_VALUE;
            double bestDEBefore = Double.MAX_VALUE;
            public int maxRICTRMSD0pos = 0;
            public int maxRICTRMSD1pos = 0;
            public int maxDEBeforepos = 0;

            public void initBest() {
                this.bestRICTRMSD0 = Double.MAX_VALUE;
                this.bestRICTRMSD1 = Double.MAX_VALUE;
                this.bestDEBefore = Double.MAX_VALUE;
            }

            public void mergeRICTedge(FragmentAtomFuseItem.RICTdescItem desc) {
                if (this.maxRICTRMSD0 < desc.RMSD0) {
                    this.maxRICTRMSD0 = desc.RMSD0;
                }
                if (this.maxRICTRMSD1 < desc.RMSD1) {
                    this.maxRICTRMSD1 = desc.RMSD1;
                }
                if (this.maxRICTRMSD0pos < desc.RMSD0p) {
                    this.maxRICTRMSD0pos = desc.RMSD0p;
                }
                if (this.maxRICTRMSD1pos < desc.RMSD1p) {
                    this.maxRICTRMSD1pos = desc.RMSD1p;
                }
                if (this.maxDRICTRMSD0 < desc.RMSD0 - this.bestRICTRMSD0) {
                    this.maxDRICTRMSD0 = desc.RMSD0 - this.bestRICTRMSD0;
                }
                if (this.maxDRICTRMSD1 < desc.RMSD1 - this.bestRICTRMSD1) {
                    this.maxDRICTRMSD1 = desc.RMSD1 - this.bestRICTRMSD1;
                }
            }

            public void mergeBestRICTedge(FragmentAtomFuseItem.RICTdescItem desc) {
                if (this.bestRICTRMSD0 > desc.RMSD0) {
                    this.bestRICTRMSD0 = desc.RMSD0;
                }
                if (this.bestRICTRMSD1 > desc.RMSD1) {
                    this.bestRICTRMSD1 = desc.RMSD1;
                }
            }

            public void mergeOPTedge(FragmentAtomFuseStore.FinalDescriptor before, FragmentAtomFuseStore.FinalDescriptor after) {
                if (this.maxDEBefore < before.denergy) {
                    this.maxDEBefore = before.denergy;
                }
                if (this.maxDEBeforepos < before.listpos) {
                    this.maxDEBeforepos = before.listpos;
                }
                if (this.maxDDEBefore < before.denergy - this.bestDEBefore) {
                    this.maxDDEBefore = before.denergy - this.bestDEBefore;
                }
            }

            public void mergeBestOPTedge(FragmentAtomFuseStore.FinalDescriptor before, FragmentAtomFuseStore.FinalDescriptor after) {
                if (this.bestDEBefore > before.denergy) {
                    this.bestDEBefore = before.denergy;
                }
            }

            public void mergeConfNode(int id) {
                if (this.maxconfno < id) {
                    this.maxconfno = id;
                }
            }

            public void mergeFinNode(int id) {
                if (this.maxfinalid < id) {
                    this.maxfinalid = id;
                }
            }

            public void printout() {
                System.err.println("Tightest limits to reach low-energy result:");
                System.err.println("   Conformers:      " + this.maxconfno);
                System.err.println("   Finals:          " + this.maxfinalid);
                System.err.println("  Absolute values:");
                System.err.println("   RMSD0:           " + this.maxRICTRMSD0);
                System.err.println("   RMSD1:           " + this.maxRICTRMSD1);
                System.err.println("   DE before opt.:  " + this.maxDEBefore);
                System.err.println("  Relative values:");
                System.err.println("   DRMSD0:          " + this.maxDRICTRMSD0);
                System.err.println("   DRMSD1:          " + this.maxDRICTRMSD1);
                System.err.println("   DDE before opt.: " + this.maxDDEBefore);
                System.err.println("  Max list positions:");
                System.err.println("   RMSD0:           " + this.maxRICTRMSD0pos);
                System.err.println("   RMSD1:           " + this.maxRICTRMSD1pos);
                System.err.println("   DE before opt.:  " + this.maxDEBeforepos);
            }
        }
    }

    public static class LDAG
    implements Serializable {
        static final long serialVersionUID = -582320810599834827L;
        static final int N_DESCCOUNT = 2;
        static final int N_FIRSTPROP = 0;
        static final int N_LASTAVAIL = 1;
        static final int E_DESCCOUNT = 4;
        static final int E_SOURCE = 0;
        static final int E_DESTINATION = 1;
        static final int E_FIRSTPROP = 2;
        static final int E_LASTAVAIL = 3;
        transient myList nodes = null;
        transient myList edges = null;
        transient myList props = null;
        transient int[] sublevel = null;
        transient int sublevelGroupIndex = -1;
        transient int[][] CTAB = null;
        transient int[][] CLIST = null;
        transient int[][] BCTAB = null;
        transient int[][] BCLIST = null;

        int[] createSublevel(int groupIndex) {
            if (this.sublevel != null && groupIndex == this.sublevelGroupIndex) {
                return this.sublevel;
            }
            this.sublevel = new int[this.getNodes()];
            this.sublevelGroupIndex = groupIndex;
            boolean done = false;
            while (!done) {
                done = true;
                for (int i = 0; i < this.getBonds(); ++i) {
                    int src = this.getBondSrc(i);
                    int dst = this.getBondDest(i);
                    if (groupIndex >= 0 && !this.getNodeProperty(src, groupIndex).equals(this.getNodeProperty(dst, groupIndex)) || this.sublevel[src] < this.sublevel[dst]) continue;
                    this.sublevel[dst] = this.sublevel[src] + 1;
                    done = false;
                }
            }
            return this.sublevel;
        }

        int getSublevelCount(int ni, int groupIndex) {
            int[] sublevel = this.createSublevel(groupIndex);
            Object o = null;
            if (groupIndex >= 0) {
                o = this.getNodeProperty(ni, groupIndex);
            }
            int cnt = 0;
            for (int i = 0; i < this.getNodes(); ++i) {
                if (o != null && !o.equals(this.getNodeProperty(i, groupIndex)) || sublevel[i] <= cnt) continue;
                cnt = sublevel[i];
            }
            return cnt + 1;
        }

        int[][] getCLIST() {
            if (this.CLIST != null) {
                return this.CLIST;
            }
            this.getCTAB();
            return this.CLIST;
        }

        int[][] getBCLIST() {
            if (this.BCLIST != null) {
                return this.BCLIST;
            }
            this.getBCTAB();
            return this.BCLIST;
        }

        int[][] getBCTAB() {
            int i;
            if (this.BCTAB != null) {
                return this.BCTAB;
            }
            this.BCTAB = new int[this.getNodes()][];
            this.BCLIST = new int[this.getNodes()][];
            int[] ncount = new int[this.getNodes()];
            for (i = 0; i < this.getBonds(); ++i) {
                int n = this.getBondDest(i);
                ncount[n] = ncount[n] + 1;
            }
            for (i = 0; i < this.getNodes(); ++i) {
                this.BCTAB[i] = new int[ncount[i]];
                this.BCLIST[i] = new int[ncount[i]];
                ncount[i] = 0;
            }
            for (i = 0; i < this.getBonds(); ++i) {
                this.BCTAB[this.getBondDest((int)i)][ncount[this.getBondDest((int)i)]] = this.getBondSrc(i);
                this.BCLIST[this.getBondDest((int)i)][ncount[this.getBondDest((int)i)]] = i;
                int n = this.getBondDest(i);
                ncount[n] = ncount[n] + 1;
            }
            return this.BCTAB;
        }

        int[][] getCTAB() {
            int i;
            if (this.CTAB != null) {
                return this.CTAB;
            }
            this.CTAB = new int[this.getNodes()][];
            this.CLIST = new int[this.getNodes()][];
            int[] ncount = new int[this.getNodes()];
            for (i = 0; i < this.getBonds(); ++i) {
                int n = this.getBondSrc(i);
                ncount[n] = ncount[n] + 1;
            }
            for (i = 0; i < this.getNodes(); ++i) {
                this.CTAB[i] = new int[ncount[i]];
                this.CLIST[i] = new int[ncount[i]];
                ncount[i] = 0;
            }
            for (i = 0; i < this.getBonds(); ++i) {
                this.CTAB[this.getBondSrc((int)i)][ncount[this.getBondSrc((int)i)]] = this.getBondDest(i);
                this.CLIST[this.getBondSrc((int)i)][ncount[this.getBondSrc((int)i)]] = i;
                int n = this.getBondSrc(i);
                ncount[n] = ncount[n] + 1;
            }
            return this.CTAB;
        }

        private void invalidateDeriveds() {
            this.sublevel = null;
            this.sublevelGroupIndex = -1;
            this.CTAB = null;
            this.CLIST = null;
            this.BCTAB = null;
            this.BCLIST = null;
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            int j;
            int i;
            s.defaultWriteObject();
            s.writeInt(this.nodes.size());
            s.writeInt(this.edges.size());
            s.writeInt(this.props.size());
            for (i = 0; i < this.nodes.size(); ++i) {
                int[] nd = (int[])this.nodes.get(i);
                for (j = 0; j < 2; ++j) {
                    s.writeInt(nd[j]);
                }
            }
            for (i = 0; i < this.edges.size(); ++i) {
                int[] ed = (int[])this.edges.get(i);
                for (j = 0; j < 4; ++j) {
                    s.writeInt(ed[j]);
                }
            }
            for (i = 0; i < this.props.size(); ++i) {
                Object o = this.props.get(i);
                if (o != null) {
                    s.writeObject((Serializable)o);
                    continue;
                }
                s.writeObject(null);
            }
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            int j;
            int i;
            s.defaultReadObject();
            int nc = s.readInt();
            int ec = s.readInt();
            int pc = s.readInt();
            this.nodes = new myList(nc);
            this.edges = new myList(ec);
            this.props = new myList(pc);
            for (i = 0; i < nc; ++i) {
                int[] nd = new int[2];
                for (j = 0; j < 2; ++j) {
                    nd[j] = s.readInt();
                }
                this.nodes.add(nd);
            }
            for (i = 0; i < ec; ++i) {
                int[] ed = new int[4];
                for (j = 0; j < 4; ++j) {
                    ed[j] = s.readInt();
                }
                this.edges.add(ed);
            }
            for (i = 0; i < pc; ++i) {
                this.props.add(s.readObject());
            }
        }

        public void addNodeProperty(int ni, int pi, Serializable o) {
            int[] ndesc = (int[])this.nodes.get(ni);
            if (ndesc[0] + pi <= ndesc[1]) {
                this.props.replace(ndesc[0] + pi, o);
            }
        }

        public Object getNodeProperty(int ni, int pi) {
            int[] ndesc = (int[])this.nodes.get(ni);
            return this.props.get(ndesc[0] + pi);
        }

        public void addEdgeProperty(int ne, int pi, Serializable o) {
            int[] edesc = (int[])this.edges.get(ne);
            if (edesc[2] + pi <= edesc[3]) {
                this.props.replace(edesc[2] + pi, o);
            }
        }

        public Object getBondProperty(int ne, int pi) {
            int[] edesc = (int[])this.edges.get(ne);
            return this.props.get(edesc[2] + pi);
        }

        public int addNode(int mp) {
            this.invalidateDeriveds();
            int[] nd = new int[2];
            if (mp > 0) {
                nd[0] = this.props.size();
                for (int i = 0; i < mp; ++i) {
                    this.props.add(null);
                }
                nd[1] = this.props.size() - 1;
            } else {
                nd[0] = -1;
                nd[1] = -1;
            }
            return this.nodes.add(nd);
        }

        public int addEdge(int src, int dst, int mp) {
            this.invalidateDeriveds();
            int[] ed = new int[4];
            ed[0] = src;
            ed[1] = dst;
            if (mp > 0) {
                ed[2] = this.props.size();
                for (int i = 0; i < mp; ++i) {
                    this.props.add(null);
                }
                ed[3] = this.props.size() - 1;
            } else {
                ed[2] = -1;
                ed[3] = -1;
            }
            return this.edges.add(ed);
        }

        public int getBondSrc(int en) {
            int[] ed = (int[])this.edges.get(en);
            return ed[0];
        }

        public int getBondDest(int en) {
            int[] ed = (int[])this.edges.get(en);
            return ed[1];
        }

        public int[] queryAllNodes(int[] pi, Object[] po) {
            int n = 0;
            for (int i = 0; i < this.nodes.size(); ++i) {
                if (!this.allmatch(i, pi, po)) continue;
                ++n;
            }
            int[] ret = new int[n];
            n = 0;
            for (int i = 0; i < this.nodes.size(); ++i) {
                if (!this.allmatch(i, pi, po)) continue;
                ret[n++] = i;
            }
            return ret;
        }

        boolean allmatch(int ni, int[] pi, Object[] po) {
            int[] nd = (int[])this.nodes.get(ni);
            for (int j = 0; j < pi.length; ++j) {
                if (po[j].equals(this.props.get(nd[0] + pi[j]))) continue;
                return false;
            }
            return true;
        }

        public int queryFirstNode(int[] pi, Object[] po) {
            for (int i = this.nodes.size() - 1; i >= 0; --i) {
                if (!this.allmatch(i, pi, po)) continue;
                return i;
            }
            return -1;
        }

        public int queryFirstNode(int pi1, Object po1) {
            int[] pi = new int[]{pi1};
            Object[] po = new Object[]{po1};
            return this.queryFirstNode(pi, po);
        }

        public int queryFirstNode(int pi1, Object po1, int pi2, Object po2) {
            int[] pi = new int[]{pi1, pi2};
            Object[] po = new Object[]{po1, po2};
            return this.queryFirstNode(pi, po);
        }

        public int queryFirstNode(int pi1, Object po1, int pi2, Object po2, int pi3, Object po3) {
            int[] pi = new int[]{pi1, pi2, pi3};
            Object[] po = new Object[]{po1, po2, po3};
            return this.queryFirstNode(pi, po);
        }

        public LDAG(int n, int e, int p) {
            this.nodes = new myList(n);
            this.edges = new myList(e);
            this.props = new myList(p);
        }

        public void empty() {
            this.nodes.empty();
            this.edges.empty();
            this.props.empty();
        }

        public int getNodes() {
            return this.nodes.size();
        }

        public int getBonds() {
            return this.edges.size();
        }
    }
}

