/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.diag;

import chemaxon.struc.Molecule;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;

public class Instrumentation {
    private Vector flags = new Vector();

    public void addFlag(Flag flag) {
        if (!flag.isUnique()) {
            for (int i = 0; i < this.flags.size(); ++i) {
                if (!this.flags.get(i).getClass().isAssignableFrom(flag.getClass())) continue;
                return;
            }
        }
        this.flags.add(flag);
    }

    public void storeFlags(Molecule m) {
        String[] labels = new String[this.flags.size()];
        int[] addCt = new int[this.flags.size()];
        for (int i = 0; i < this.flags.size(); ++i) {
            Flag f = (Flag)this.flags.get(i);
            labels[i] = f.getPropertyLabel();
            for (int j = 0; j < i; ++j) {
                if (!labels[i].equalsIgnoreCase(labels[j])) continue;
                addCt[i] = addCt[j] + 1;
            }
            String s = labels[i];
            if (addCt[i] > 0) {
                s = s + "." + addCt[i];
            }
            m.setProperty(s, f.getValue());
        }
    }

    public static class FragmentAnchorInStereoFlag
    extends Flag {
        @Override
        public String getMessage() {
            return "Fragment anchor in stereo criteria found";
        }
    }

    public static class MaxBuildCounterReachedFlag
    extends Flag {
        @Override
        public String getMessage() {
            return "MaxBuildCounter reached, build failed";
        }
    }

    public static class OptimizerExceptionFlag
    extends Flag {
        @Override
        public String getMessage() {
            return "Optimizer exception";
        }
    }

    public static class OptimizedToDefSP3
    extends Flag {
        @Override
        public String getMessage() {
            return "Optimized structure contains deformed SP3 neighborhood situation";
        }
    }

    public static class OptimizedToRC
    extends Flag {
        @Override
        public String getMessage() {
            return "Optimized structure has RC situation";
        }
    }

    public static class OABuildCommandFoundFlag
    extends Flag {
        @Override
        public String getMessage() {
            return "OA Build situation found in structure";
        }
    }

    public static class StereocheckOnFlawed
    extends Flag {
        @Override
        public String getMessage() {
            return "Stereo check on flawed structure";
        }
    }

    public static class OptimizerNotConvergedFlag
    extends Flag {
        @Override
        public String getMessage() {
            return "Optimizer not converged";
        }
    }

    public static class FallbackToFastCleanFlag
    extends Flag {
        @Override
        public String getMessage() {
            return "Fallback to S{FAST} occured";
        }
    }

    public static class FallbackToFuseBuild
    extends Flag {
        @Override
        public String getMessage() {
            return "Fallback to direct fragment build occured";
        }
    }

    public static class OptimizationFlawedFlag
    extends Flag {
        @Override
        public String getMessage() {
            return "Optimization resulted in flawed structure";
        }
    }

    public static class OptimizationCorruptedFlag
    extends Flag {
        @Override
        public String getMessage() {
            return "Optimization on steric OK structure resulted in steric error";
        }
    }

    public static class ExceptionReported
    extends Flag {
        String msg;

        public ExceptionReported(Exception e) {
            StringWriter w = new StringWriter();
            PrintWriter p = new PrintWriter(w);
            e.printStackTrace(p);
            this.msg = e.getMessage() + " " + w.toString();
        }

        @Override
        public String getMessage() {
            return "Exception reported: " + this.msg;
        }

        @Override
        public boolean isUnique() {
            return true;
        }

        @Override
        public String getValue() {
            return this.msg;
        }
    }

    public static class PlainFlag
    extends Flag {
        String label;
        String value;

        public PlainFlag(String label, String value) {
            this.label = label;
            this.value = value;
        }

        @Override
        public String getMessage() {
            return "universal flag";
        }

        @Override
        public String getPropertyLabel() {
            return this.label;
        }

        @Override
        public boolean isUnique() {
            return true;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static abstract class Flag {
        public abstract String getMessage();

        public String getPropertyLabel() {
            String names = this.getClass().getName();
            int i = Math.max(names.lastIndexOf(46), names.lastIndexOf(36));
            String name = i < 0 || i + 1 >= names.length() - 1 ? names : names.substring(i + 1);
            return "CLEAN3D." + name.toUpperCase();
        }

        public boolean isUnique() {
            return false;
        }

        public String getValue() {
            return "set";
        }
    }
}

