/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.edit;

import chemaxon.marvin.alignment.Quaternion;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;

public class Rotate {
    public static int ROTATE_ALL_FRAGMENTS = -1;
    private double x1;
    private double y1;
    private double z1;
    private double x2;
    private double y2;
    private double z2;
    private MoleculeGraph molecule;
    private Quaternion q = new Quaternion();
    private boolean wasRotated = false;
    private Visualizer v;

    private void show() {
        if (this.v != null) {
            this.v.show();
        }
    }

    public void setAxisPoint1(DPoint3 point1) {
        this.setAxisPoint1(point1.x, point1.y, point1.z);
        this.wasRotated = false;
    }

    public void setAxisPoint2(DPoint3 point2) {
        this.setAxisPoint2(point2.x, point2.y, point2.z);
        this.wasRotated = false;
    }

    public void setAxisPoint1(MolAtom a1) {
        this.setAxisPoint1(a1.getX(), a1.getY(), a1.getZ());
        this.wasRotated = false;
    }

    public void setAxisPoint2(MolAtom a2) {
        this.setAxisPoint2(a2.getX(), a2.getY(), a2.getZ());
        this.wasRotated = false;
    }

    public void setAxisPoint1(double x, double y, double z) {
        this.x1 = x;
        this.y1 = y;
        this.z1 = z;
        this.wasRotated = false;
    }

    public void setAxisPoint2(double x, double y, double z) {
        this.x2 = x;
        this.y2 = y;
        this.z2 = z;
        this.wasRotated = false;
    }

    public void setMoleculeToRotate(MoleculeGraph mol) {
        this.molecule = mol;
        this.wasRotated = false;
    }

    public void rotate(double angle) {
        double l = Math.sqrt((this.x1 - this.x2) * (this.x1 - this.x2) + (this.y1 - this.y2) * (this.y1 - this.y2) + (this.z1 - this.z2) * (this.z1 - this.z2));
        if (l < 1.0E-5) {
            throw new UnsupportedOperationException("Axis points were not setted properly. Axis length < 1e-5");
        }
        if (this.molecule == null) {
            throw new UnsupportedOperationException("Set either molecule or coordinates to rotate.");
        }
        this.q.setAxisAndAngle(this.x2 - this.x1, this.y2 - this.y1, this.z2 - this.z1, angle);
        double[] crd = new double[3];
        for (int i = 0; i < this.molecule.getAtomCount(); ++i) {
            crd[0] = this.molecule.getAtom(i).getX() - this.x1;
            crd[1] = this.molecule.getAtom(i).getY() - this.y1;
            crd[2] = this.molecule.getAtom(i).getZ() - this.z1;
            crd = this.q.rotate(crd);
            this.molecule.getAtom(i).setXYZ(crd[0] + this.x1, crd[1] + this.y1, crd[2] + this.z1);
        }
        this.show();
        this.wasRotated = true;
    }

    public MoleculeGraph getRotatedMolecule() {
        if (!this.wasRotated) {
            throw new UnsupportedOperationException("Perform rotate(angle) method on the setted environment before getting coordinates");
        }
        return this.molecule;
    }

    public static void rotate(MoleculeGraph m, DPoint3 axis1, DPoint3 axis2, double angle) {
        try {
            Rotate r = new Rotate();
            r.setAxisPoint1(axis1);
            r.setAxisPoint2(axis2);
            r.setMoleculeToRotate(m);
            r.rotate(angle);
        }
        catch (UnsupportedOperationException u) {
            throw new IllegalArgumentException(u);
        }
    }

    private class Visualizer {
        double[] crdAll;

        public Visualizer() {
            Molecule m = new Molecule();
            Rotate.this.molecule.clonecopy(m);
            this.crdAll = new double[m.getAtomCount() * 3];
        }

        public void show() {
            int c = 0;
            for (int i = 0; i < Rotate.this.molecule.getAtomCount(); ++i) {
                this.crdAll[c++] = Rotate.this.molecule.getAtom(i).getX();
                this.crdAll[c++] = Rotate.this.molecule.getAtom(i).getY();
                this.crdAll[c++] = Rotate.this.molecule.getAtom(i).getZ();
            }
        }
    }
}

