/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.geom;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.geom.Equivalences;
import chemaxon.marvin.modelling.struc.myMolecule;
import chemaxon.marvin.modelling.util.IntSetArray;
import chemaxon.marvin.modelling.util.NodeGroups;
import chemaxon.marvin.modelling.util.U;
import java.util.Vector;

public class MultiatomEquivalences {
    myMolecule m;
    int[][] atomlists;
    String[] descriptions = null;
    Vector selectedList = new Vector();
    boolean closed = false;

    public void placeApplet(String btnlabel) {
        int fields = (1 + this.selectedList.size()) * this.atomlists.length;
        String[] sel = new String[fields];
        String[] desc = new String[sel.length];
        int field = 0;
        for (int i = 0; i < this.atomlists.length; ++i) {
            sel[field] = U.sel(this.atomlists[i]);
            desc[field] = "Original";
            if (this.atomlists.length > 1) {
                int n = field;
                desc[n] = desc[n] + "[" + i + "]";
            }
            if (this.descriptions != null) {
                int n = field;
                desc[n] = desc[n] + ": " + this.descriptions[i];
            }
            ++field;
        }
        for (int j = 0; j < this.selectedList.size(); ++j) {
            int[][] cs = (int[][])this.selectedList.get(j);
            for (int i = 0; i < this.atomlists.length; ++i) {
                sel[field] = U.sel(cs[i]);
                desc[field] = "Selected[" + j + "]";
                if (this.atomlists.length > 1) {
                    int n = field;
                    desc[n] = desc[n] + "[" + i + "]";
                }
                if (this.descriptions != null) {
                    int n = field;
                    desc[n] = desc[n] + ": " + this.descriptions[i];
                }
                ++field;
            }
        }
        this.m.placeApplets(btnlabel, sel, desc);
    }

    public MultiatomEquivalences(myMolecule m, int[][] atomlists, String[] desc) {
        debugPrintout debug = CleanArgs.getDebug();
        if (debug != null) {
            debug.incLevel("new MultiAtomEquivalences()");
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("MultiAtomEquivalences constructor");
        }
        this.m = m;
        this.atomlists = atomlists;
        this.descriptions = desc;
        if (debug != null) {
            m.placeApplets("Given atomlists", U.sel(atomlists));
        }
        this.MultiatomEquivalences_0(m, atomlists, desc, debug);
        if (debug != null) {
            debug.decLevel();
        }
    }

    void MultiatomEquivalences_0(myMolecule m, int[][] atomlists, String[] desc, debugPrintout debug) {
        int i;
        NodeGroups eq0 = new NodeGroups(Equivalences.getMorganLabels(m));
        if (debug != null) {
            eq0.placeApplet(m, "Initial eqGroups");
        }
        if (eq0.closedToLists(atomlists)) {
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("CLOSED", "Only one set of fusing atoms found");
            }
            this.closed = true;
            this.selectedList.add(atomlists);
            return;
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Not closed", "Start equivalence set identification");
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("INITIALIZATION");
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Check for closed groups");
        }
        int[] lens = U.getLengths(atomlists);
        int max = m.a + 1;
        IntSetArray originalSets = new IntSetArray(lens, max);
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("originalSets inited empty", originalSets.toHTMLString());
        }
        Vector<IntSetArray> selectedSets = new Vector<IntSetArray>();
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Check for closed eqgroups");
        }
        IntSetArray news = new IntSetArray(lens, max);
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("news inited empty", news.toHTMLString());
        }
        for (int i2 = 0; i2 < eq0.getGroupCount(); ++i2) {
            for (int j = 0; j < atomlists.length; ++j) {
                if (!eq0.closedToList(i2, atomlists[j])) continue;
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("Group " + i2 + " is closed to list " + j + " (" + desc[j] + ")", "Atoms: " + U.sel(eq0.getGroup(i2)));
                }
                originalSets.add(j, eq0.getGroup(i2));
                news.add(j, eq0.getGroup(i2));
                if (!CleanArgs.doVerbose()) continue;
                CleanArgs.verbose("Original set expanded", originalSets.toHTMLString());
                CleanArgs.verbose("news expanded", originalSets.toHTMLString());
            }
        }
        if (originalSets.getSize() != 0) {
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Add found closed", "Closed group(s) found at the initialization<BR>step, which makes the initial original set.");
            }
            selectedSets.add(news);
        } else {
            int oa = -1;
            int oalist = -1;
            int ssi = -1;
            int sss = -1;
            for (int j = 0; j < atomlists.length; ++j) {
                for (i = 0; i < atomlists[j].length; ++i) {
                    int gi = eq0.getGroupForAtom(atomlists[j][i]);
                    int gs = eq0.getGroup(gi).length;
                    if (sss >= 0 && sss <= gs) continue;
                    oa = atomlists[j][i];
                    oalist = j;
                    ssi = gi;
                    sss = gs;
                }
            }
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Initialization", "No closed initial group found. Make initial original set<BR>from original atom: " + oa + " in list " + oalist + "(" + desc[oalist] + ") with selected group [" + ssi + "]: " + U.sel(eq0.getGroup(ssi)));
            }
            originalSets.add(oalist, oa);
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("OriginalSets expanded", originalSets.toHTMLString());
            }
            int[] gr = eq0.getGroup(ssi);
            for (i = 0; i < gr.length; ++i) {
                IntSetArray ns = new IntSetArray(lens, max);
                ns.add(oalist, gr[i]);
                selectedSets.add(ns);
            }
        }
        int al = U.countLengths(atomlists);
        while (originalSets.getSize() < al) {
            int i3;
            if (debug != null) {
                debug.printHR();
            }
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Induction loop start", "Original set (size=" + originalSets.getSize() + ")<BR>" + "Original set: " + originalSets.toSimpleString() + "<BR>" + "Selected sets size: " + selectedSets.size());
            }
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Create equivalence groups");
            }
            NodeGroups eqOi = new NodeGroups(Equivalences.getMorganLabels(m, originalSets.get()));
            if (debug != null) {
                m.placeApplets("Original sets", U.sel(originalSets.get()), desc);
                eqOi.placeApplet(m, "Original set EQgroups");
            }
            NodeGroups[] eqS = new NodeGroups[selectedSets.size()];
            for (int i4 = 0; i4 < eqS.length; ++i4) {
                eqS[i4] = new NodeGroups(Equivalences.getMorganLabels(m, ((IntSetArray)selectedSets.get(i4)).get()));
                if (debug == null) continue;
                m.placeApplets("Selected set " + i4, U.sel(((IntSetArray)selectedSets.get(i4)).get()), desc);
                eqS[i4].placeApplet(m, "Selected set " + i4 + " EQgroups");
            }
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Check for closed groups");
            }
            IntVector cgi = null;
            IntVector cli = null;
            for (i = 0; i < eqOi.getGroupCount(); ++i) {
                if (originalSets.containsInOneSet(eqOi.getGroup(i))) continue;
                for (int j = 0; j < atomlists.length; ++j) {
                    if (!eqOi.closedToList(i, atomlists[j])) continue;
                    if (cgi == null) {
                        cgi = new IntVector();
                        cli = new IntVector();
                    }
                    cgi.add(i);
                    cli.add(j);
                    originalSets.add(j, eqOi.getGroup(i));
                    if (!CleanArgs.doVerbose()) continue;
                    CleanArgs.verbose("Closed group: " + i + " in list " + j, "Group items: " + U.sel(eqOi.getGroup(i)) + "<BR>" + "Original sets: " + originalSets.toSimpleString() + originalSets.toHTMLString());
                }
            }
            if (cgi != null) {
                int j;
                for (i = 0; i < selectedSets.size(); ++i) {
                    IntSetArray ssi = (IntSetArray)selectedSets.get(i);
                    for (j = 0; j < cgi.size(); ++j) {
                        ssi.add(cli.get(j), eqS[i].getGroup(cgi.get(j)));
                        if (!CleanArgs.doVerbose()) continue;
                        CleanArgs.verbose("Se;ected set " + i + "Expanded", "Group: " + U.sel(eqS[i].getGroup(cgi.get(j))) + "<BR>" + "Set items: " + ssi.toSimpleString());
                    }
                }
                block11: for (i = 0; i < selectedSets.size(); ++i) {
                    IntSetArray ssi = (IntSetArray)selectedSets.get(i);
                    for (j = 0; j < i; ++j) {
                        IntSetArray ssj = (IntSetArray)selectedSets.get(j);
                        if (!ssj.equals(ssi)) continue;
                        if (CleanArgs.doVerbose()) {
                            CleanArgs.verbose("Duplicate, remove " + i);
                        }
                        selectedSets.remove(i);
                        --i;
                        continue block11;
                    }
                }
                if (!CleanArgs.doVerbose()) continue;
                CleanArgs.verbose("Closed groups added, new loop");
                continue;
            }
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("No closed group", "Select small group");
            }
            int oa = -1;
            int ssi = -1;
            int sss = -1;
            int ssl = -1;
            for (int j = 0; j < atomlists.length; ++j) {
                for (i3 = 0; i3 < atomlists[j].length; ++i3) {
                    if (originalSets.contains(atomlists[j][i3])) continue;
                    int gi = eqOi.getGroupForAtom(atomlists[j][i3]);
                    int gs = eqOi.getGroup(gi).length;
                    if (sss >= 0 && sss <= gs) continue;
                    oa = atomlists[j][i3];
                    ssi = gi;
                    sss = gs;
                    ssl = j;
                }
            }
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Expand sets", "No closed group found. Expand original set [+" + ssl + "]<BR>" + "" + "with original atom: " + oa + " with selected group [" + ssi + "]: " + U.sel(eqOi.getGroup(ssi)));
            }
            originalSets.add(ssl, oa);
            Vector<IntSetArray> newSelS = new Vector<IntSetArray>();
            for (i3 = 0; i3 < eqS.length; ++i3) {
                int[] g = eqS[i3].getGroup(ssi);
                IntSetArray s = (IntSetArray)selectedSets.get(i3);
                for (int j = 0; j < g.length; ++j) {
                    IntSetArray sn = null;
                    if (j == g.length - 1) {
                        sn = s;
                    } else {
                        sn = new IntSetArray(lens, max);
                        sn.add(s.get());
                    }
                    sn.add(ssl, g[j]);
                    boolean f = false;
                    for (int k = 0; k < newSelS.size(); ++k) {
                        IntSetArray ns = (IntSetArray)newSelS.get(k);
                        if (!ns.equals(sn)) continue;
                        f = true;
                        break;
                    }
                    if (f) continue;
                    if (CleanArgs.doVerbose()) {
                        CleanArgs.verbose("Add: " + U.sel(sn.get()));
                    }
                    newSelS.add(sn);
                }
            }
            selectedSets = newSelS;
        }
        for (int i5 = 0; i5 < selectedSets.size(); ++i5) {
            this.selectedList.add(((IntSetArray)selectedSets.get(i5)).get());
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("done.");
        }
    }

    void calcEquivalences() {
    }
}

