/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.geom;

import chemaxon.marvin.modelling.TextUtils;
import chemaxon.marvin.modelling.linalg.M;
import chemaxon.marvin.modelling.linalg.V;
import chemaxon.marvin.modelling.util.U;

public class Tetrahedron {
    public static final int TYPE_DIMENSIONLESS = 1;
    public static final int TYPE_LINEAR = 2;
    public static final int TYPE_PLANAR = 3;
    public static final int TYPE_3D = 4;
    public static final double APPROX_CCLEN = 0.75;
    private int type = 0;
    private int a1 = -1;
    private int a2 = -1;
    private int a3 = -1;
    private int a4 = -1;
    private double genP = 0.0;
    public static int TYPE_NOPARITY = 1;
    public static int TYPE_PARITYA = 2;
    public static int TYPE_PARITYB = 3;

    public int getType() {
        return this.type;
    }

    public static int checkConfiguration(double[] p1, double[] p2, double[] p3, double[] center) {
        double[] p12 = V.minus(p2, p1);
        double[] p13 = V.minus(p2, p1);
        return TYPE_NOPARITY;
    }

    public static int checkConfiguration(double[] p1, double[] p2, double[] p3, double[] p4, double[] center) {
        double[] v12;
        if (center == null) {
            center = V.avg(p1, p2, p3, p4);
        }
        double[][] p = new double[][]{p1, p2, p3, p4};
        double[][] cpnorm = V.minus(p, center);
        V.normalize(cpnorm);
        int[] nn = new int[]{0, 1, 2, 3};
        double fmin = 0.5235987755982988;
        for (int i = 1; i < 4; ++i) {
            int j = 0;
            while (j < i) {
                double a2;
                double[] n = V.vectProd(cpnorm[i], cpnorm[j]);
                int[] nArray = new int[]{i, j++};
                int[] o = U.remove(nn, nArray);
                double a1 = V.angle(n, cpnorm[o[0]]) - 1.5707963267948966;
                if (a1 * (a2 = V.angle(n, cpnorm[o[1]]) - 1.5707963267948966) >= 0.0) {
                    return TYPE_NOPARITY;
                }
                if (!(Math.abs(a1) < fmin) && !(Math.abs(a2) < fmin)) continue;
                return TYPE_NOPARITY;
            }
        }
        double[] v13 = V.minus(p3, p1);
        double[] vp = V.vectProd(v13, v12 = V.minus(p2, p1));
        if (V.dot(vp, cpnorm[3]) > 0.0) {
            return TYPE_PARITYA;
        }
        return TYPE_PARITYB;
    }

    public static double calcGenP(double[] ca1, double[] ca2, double[] ca3, double[] ca4) {
        double[] a = V.minus(ca2, ca1);
        double dota = V.dot(a);
        double lenRec = 1.0 / Math.sqrt(dota);
        double[] anorm = V.dot(lenRec, a);
        double[] mb = V.minus(ca3, ca1);
        double[] vp = V.vectProd(a, mb);
        double dotvp = V.dot(vp);
        double sqdotvp = Math.sqrt(dotvp);
        double recsqdotvp = 1.0 / sqdotvp;
        double[] vpnorm = V.dot(recsqdotvp, vp);
        double[] c = V.minus(ca4, ca1);
        double dotc = V.dot(c);
        double sqdotc = Math.sqrt(dotc);
        double recsqdotc = 1.0 / sqdotc;
        double[] cnorm = V.dot(recsqdotc, c);
        return V.dot(vpnorm, cnorm);
    }

    public double getGenP(double[][] ca) {
        return Tetrahedron.calcGenP(ca[this.a1], ca[this.a2], ca[this.a3], ca[this.a4]);
    }

    public Tetrahedron(double[][] ca) {
        this(ca, 0.75, null);
    }

    public Tetrahedron(double[][] ca, double minExt, StringBuffer verbinfo) {
        if (verbinfo != null) {
            verbinfo.append("calen=" + ca.length + " minExt=" + minExt + " ");
        }
        double maxm = -1.0;
        int ma1 = -1;
        int ma2 = -1;
        for (int a1 = 0; a1 < ca.length; ++a1) {
            for (int a2 = a1 + 1; a2 < ca.length; ++a2) {
                double m = V.dot(V.minus(ca[a1], ca[a2]));
                if (!(m > maxm)) continue;
                maxm = m;
                ma1 = a1;
                ma2 = a2;
            }
        }
        if (verbinfo != null) {
            verbinfo.append("1D: " + TextUtils.formatNumber(maxm));
        }
        if (maxm < minExt) {
            this.type = 1;
            return;
        }
        this.a1 = ma1;
        this.a2 = ma2;
        double[] a = V.minus(ca[ma2], ca[ma1]);
        double dota = V.dot(a);
        double lenRec = 1.0 / Math.sqrt(dota);
        double[] anorm = V.dot(lenRec, a);
        int ma3 = -1;
        double maxbd = -1.0;
        double[] mb = null;
        for (int k = 0; k < ca.length; ++k) {
            double[] b;
            double bd;
            if (k == ma1 || k == ma2 || !((bd = V.dot(b = V.minus(ca[k], ca[ma1])) - M.sqr(V.dot(anorm, b))) > maxbd)) continue;
            maxbd = bd;
            ma3 = k;
            mb = b;
        }
        if (verbinfo != null) {
            verbinfo.append(" 2D: " + TextUtils.formatNumber(maxm));
        }
        if (maxbd < minExt) {
            this.type = 2;
            return;
        }
        this.a3 = ma3;
        double[] vp = V.vectProd(a, mb);
        double dotvp = V.dot(vp);
        double sqdotvp = Math.sqrt(dotvp);
        double recsqdotvp = 1.0 / sqdotvp;
        double[] vpnorm = V.dot(recsqdotvp, vp);
        double maxsvp = 0.0;
        double svp = 0.0;
        int ma4 = -1;
        for (int k = 0; k < ca.length; ++k) {
            double[] c;
            double[] cnorm;
            double sp;
            if (k == ma1 || k == ma2 || k == ma3 || !(Math.abs(sp = V.dot(vpnorm, cnorm = (c = V.minus(ca[k], ca[ma1])))) > maxsvp)) continue;
            maxsvp = Math.abs(sp);
            svp = sp;
            ma4 = k;
        }
        if (verbinfo != null) {
            verbinfo.append("3D: " + TextUtils.formatNumber(maxm));
        }
        if (maxsvp < minExt) {
            this.type = 3;
            return;
        }
        this.a4 = ma4;
        this.genP = svp;
        this.type = 4;
    }

    public int getA1() {
        return this.a1;
    }

    public int getA2() {
        return this.a2;
    }

    public int getA3() {
        return this.a3;
    }

    public int getA4() {
        return this.a4;
    }

    public double getGenP() {
        return this.genP;
    }
}

