/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.gui;

import chemaxon.marvin.common.UserSettings;
import chemaxon.marvin.modelling.gui.MViewPlayer;
import chemaxon.marvin.modelling.gui.MoleculeLoader;
import chemaxon.struc.MDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractButton;

class ActionPerformedQueue
implements Runnable {
    private final MViewPlayer viewPlayer;

    protected ActionPerformedQueue(MViewPlayer viewPlayer) {
        this.viewPlayer = viewPlayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.viewPlayer.isActionLocked() || this.viewPlayer.isCancelled()) {
            return;
        }
        this.viewPlayer.setActionLocked(true);
        String cmd = null;
        ActionEvent ev = null;
        boolean emptyqueue = false;
        Vector vector = this.viewPlayer.actionQueue;
        synchronized (vector) {
            emptyqueue = this.viewPlayer.actionQueue.isEmpty();
        }
        while (true) {
            Object button;
            Vector vector2 = this.viewPlayer.actionQueue;
            synchronized (vector2) {
                emptyqueue = this.viewPlayer.actionQueue.isEmpty();
            }
            if (emptyqueue) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    this.viewPlayer.setCancelled(true);
                }
            }
            if (emptyqueue && !this.viewPlayer.isCancelled()) continue;
            if (this.viewPlayer.isCancelled()) break;
            ev = (ActionEvent)this.viewPlayer.actionQueue.remove(0);
            cmd = ev.getActionCommand();
            if (cmd.equals("exit")) {
                System.err.println("Saving user settings...");
                UserSettings e = this.viewPlayer.viewPlayerSettings;
                synchronized (e) {
                    this.viewPlayer.viewPlayerSettings.setProperty("viewPlayerShowSettings", Boolean.toString(this.viewPlayer.settings.isVisible()));
                    this.viewPlayer.settings.exit();
                    if (this.viewPlayer.streamIterator != null) {
                        this.viewPlayer.viewPlayerSettings.setProperty("viewPlayerShowStreamSettings", Boolean.toString(this.viewPlayer.streamIterator.isVisible()));
                        this.viewPlayer.streamIterator.exit();
                        this.viewPlayer.streamIterator = null;
                    }
                    this.viewPlayer.settings = null;
                    Rectangle b = this.viewPlayer.getBounds();
                    this.viewPlayer.viewPlayerSettings.setProperty("viewPlayerWindowX", Integer.toString(b.x));
                    this.viewPlayer.viewPlayerSettings.setProperty("viewPlayerWindowY", Integer.toString(b.y));
                    this.viewPlayer.viewPlayerSettings.setProperty("viewPlayerWindowWidth", Integer.toString(b.width));
                    this.viewPlayer.viewPlayerSettings.setProperty("viewPlayerWindowHeight", Integer.toString(b.height));
                    try {
                        this.viewPlayer.viewPlayerSettings.save("Settings by MViewPlayer");
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
                this.viewPlayer.windowClosing(null);
            } else if (cmd.equals("open")) {
                this.viewPlayer.viewPane.showFileOpenDialog();
            } else if (cmd.equals("file")) {
                File f = this.viewPlayer.viewPane.getFile();
                this.viewPlayer.workingDirectory = this.viewPlayer.viewPane.getDirectory();
                UserSettings uS = this.viewPlayer.viewPane.getUserSettings();
                uS.setViewLoadWorkingDir(this.viewPlayer.workingDirectory.getAbsolutePath());
                this.viewPlayer.viewPane.setUserSettings(uS);
                if (f != null) {
                    if (this.viewPlayer.molIterator == null) {
                        this.viewPlayer.setPause(true);
                        String[] fileNameList = new String[]{f.getAbsolutePath()};
                        MoleculeLoader mL = new MoleculeLoader(this.viewPlayer, fileNameList);
                        mL.setCyclicMode(true);
                        this.viewPlayer.molIterator = mL;
                        this.viewPlayer.sourceIteratorVector.insertElementAt(null, 0);
                        String loaderName = "File";
                        this.viewPlayer.sourceIteratorNames.insertElementAt(loaderName, 0);
                        this.viewPlayer.settings.sourceSelectionChanged();
                        Iterator iterator = this.viewPlayer.molIterator;
                        synchronized (iterator) {
                            if (this.viewPlayer.molIterator.hasNext()) {
                                MViewPlayer mViewPlayer = this.viewPlayer;
                                mViewPlayer.getClass();
                                new Thread(new MViewPlayer.SetMoleculeThred(mViewPlayer, (Molecule)this.viewPlayer.molIterator.next())).start();
                            }
                        }
                    } else {
                        Vector vector3 = this.viewPlayer.fileNames;
                        synchronized (vector3) {
                            this.viewPlayer.fileNames.addElement(f.getAbsolutePath());
                        }
                    }
                }
            } else if (cmd.equals("newMol")) {
                this.viewPlayer.viewPane.setM(0, this.viewPlayer.newMol);
                MDocument mD = this.viewPlayer.viewPane.getDocuments()[0];
                this.viewPlayer.m = mD.getAllMolecules()[0];
                this.viewPlayer.coordinates = new double[this.viewPlayer.m.getAtomCount()][3];
                String labelString = Integer.toString(this.viewPlayer.counter);
                if (this.viewPlayer.labelString != null) {
                    labelString = this.viewPlayer.labelString;
                }
                if (this.viewPlayer.streamIterator != null) {
                    labelString = this.viewPlayer.streamIterator.getLabel();
                }
                this.viewPlayer.viewPane.setL(0, labelString);
                this.viewPlayer.mP.repaintMolComponent(0);
            } else if (cmd.equals("redraw")) {
                for (int j = 0; j < this.viewPlayer.m.getAtomCount(); ++j) {
                    MolAtom aT = this.viewPlayer.m.getAtom(j);
                    aT.setXYZ(this.viewPlayer.coordinates[j][0], this.viewPlayer.coordinates[j][1], this.viewPlayer.coordinates[j][2]);
                }
                String labelString = Integer.toString(this.viewPlayer.counter);
                if (this.viewPlayer.labelString != null) {
                    labelString = this.viewPlayer.labelString;
                }
                if (this.viewPlayer.streamIterator != null) {
                    labelString = this.viewPlayer.streamIterator.getLabel();
                }
                this.viewPlayer.viewPane.setL(0, labelString);
                this.viewPlayer.mP.repaintMolComponent(0);
            } else if (cmd.equals("Next")) {
                if (!this.viewPlayer.isWaitingForNextMolecule()) {
                    if (!this.viewPlayer.isAutoPlay()) {
                        this.viewPlayer.setPause(true);
                        this.viewPlayer.fpsDelay();
                        button = this.viewPlayer.viewPane.getVisibleButtonB(1);
                        ((AbstractButton)button).setText("Play");
                    }
                    if (this.viewPlayer.streamIterator != null) {
                        button = this.viewPlayer.streamIterator;
                        synchronized (button) {
                            this.viewPlayer.streamIterator.remove();
                        }
                    }
                    if (this.viewPlayer.molIterator != null) {
                        new Thread(new MViewPlayer.SetMoleculeThred(this.viewPlayer)).start();
                    } else {
                        this.viewPlayer.setWaitingForNextMolecule(true);
                    }
                }
            } else if (cmd.equals("Play")) {
                button = (AbstractButton)ev.getSource();
                ((AbstractButton)button).setText("Pause");
                this.viewPlayer.setPause(false);
            } else if (cmd.equals("Pause")) {
                button = (AbstractButton)ev.getSource();
                ((AbstractButton)button).setText("Play");
                this.viewPlayer.setPause(true);
            } else if (cmd.equals("Step")) {
                this.viewPlayer.setOneStepAllowed(true);
                button = this.viewPlayer.viewPane.getVisibleButtonB(1);
                ((AbstractButton)button).setText("Play");
            } else if (cmd.equals("Settings")) {
                boolean visible = this.viewPlayer.settings.isVisible();
                if (this.viewPlayer.streamIterator != null) {
                    this.viewPlayer.streamIterator.setVisible(!(visible &= this.viewPlayer.streamIterator.isVisible()));
                }
                this.viewPlayer.settings.setVisible(!visible);
            } else if (cmd.equals("label")) {
                String labelString = Integer.toString(this.viewPlayer.counter);
                if (this.viewPlayer.streamIterator != null) {
                    labelString = this.viewPlayer.streamIterator.getLabel();
                }
                if (this.viewPlayer.labelString != null) {
                    labelString = this.viewPlayer.labelString;
                }
                this.viewPlayer.viewPane.setL(0, labelString);
            } else {
                this.viewPlayer.setPause(true);
                this.viewPlayer.windowClosing(null);
                System.err.println("Unknown action: " + cmd);
            }
            this.viewPlayer.viewPane.validate();
            if (this.viewPlayer.isCancelled()) break;
        }
        this.viewPlayer.setActionLocked(false);
    }
}

