/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.gui;

import chemaxon.marvin.common.UserSettings;
import chemaxon.marvin.modelling.gui.MViewPlayer;
import chemaxon.marvin.modelling.gui.StructureStream;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;

class MViewPSettings
implements Runnable,
ActionListener {
    private final MViewPlayer viewPlayer;
    JFrame settingsFrame = null;
    private JCheckBox autoPlayCheckBox = null;
    private JTextField nextDelayMessage = null;
    private JTextField nextDelayTextField = null;
    private JTextField fpsTextField = null;
    private JTextField dummyCycleTextField = null;
    private JTextField sourceChooserMessage = null;
    private JComboBox sourceChooser = null;

    public MViewPSettings(MViewPlayer viewPlayer) {
        this.viewPlayer = viewPlayer;
        this.init();
    }

    @Override
    public void run() {
    }

    private void init() {
        this.settingsFrame = new JFrame("MVPlayer settings");
        this.settingsFrame.setResizable(true);
        JPanel settingsPanel = new JPanel(new GridBagLayout());
        Border b = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        settingsPanel.setBorder(b);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        JTextField message = new JTextField("Start playing automatically:");
        message.setEditable(false);
        c.gridy = 0;
        c.gridx = 21;
        message.setBorder(b);
        message.setFocusable(false);
        settingsPanel.add((Component)message, c);
        JCheckBox autoPlayButton = new JCheckBox();
        autoPlayButton.setActionCommand("autoPlay");
        autoPlayButton.setHorizontalTextPosition(10);
        autoPlayButton.setFocusPainted(false);
        autoPlayButton.addActionListener(this);
        c.gridx = -1;
        autoPlayButton.setBorder(b);
        autoPlayButton.setSelected(this.viewPlayer.isAutoPlay());
        settingsPanel.add((Component)autoPlayButton, c);
        this.autoPlayCheckBox = autoPlayButton;
        message = new JTextField("Delay at next:");
        message.setEditable(false);
        message.setFocusable(false);
        ++c.gridy;
        c.gridx = 21;
        message.setBorder(b);
        this.nextDelayMessage = message;
        settingsPanel.add((Component)message, c);
        JTextField tField = new JTextField(Double.toString(this.viewPlayer.getNextDelay()), 5);
        tField.setEditable(true);
        tField.setActionCommand("viewPlayerNextDelay");
        tField.addActionListener(this);
        c.gridx = -1;
        Border inputB = BorderFactory.createBevelBorder(1);
        tField.setBorder(inputB);
        settingsPanel.add((Component)tField, c);
        this.nextDelayTextField = tField;
        if (!this.viewPlayer.isAutoPlay()) {
            this.nextDelayMessage.setEnabled(false);
            this.nextDelayTextField.setEnabled(false);
        }
        message = new JTextField("Frame per second:");
        message.setEditable(false);
        message.setFocusable(false);
        ++c.gridy;
        c.gridx = 21;
        message.setBorder(b);
        settingsPanel.add((Component)message, c);
        tField = new JTextField(Double.toString(this.viewPlayer.getFps()), 5);
        tField.setEditable(true);
        tField.setActionCommand("viewPlayerFPS");
        tField.addActionListener(this);
        c.gridx = -1;
        inputB = BorderFactory.createBevelBorder(1);
        tField.setBorder(inputB);
        settingsPanel.add((Component)tField, c);
        this.fpsTextField = tField;
        message = new JTextField("Max. number of dummy cycles:");
        message.setEditable(false);
        message.setFocusable(false);
        ++c.gridy;
        c.gridx = 21;
        message.setBorder(b);
        settingsPanel.add((Component)message, c);
        tField = new JTextField(Integer.toString(this.viewPlayer.getDummyCycles()), 5);
        tField.setEditable(true);
        tField.setActionCommand("viewPlayerDummyCycles");
        tField.addActionListener(this);
        c.gridx = -1;
        tField.setBorder(inputB);
        settingsPanel.add((Component)tField, c);
        this.dummyCycleTextField = tField;
        message = new JTextField("Stream source:");
        message.setEditable(false);
        message.setFocusable(false);
        ++c.gridy;
        c.gridx = 21;
        message.setBorder(b);
        this.sourceChooserMessage = message;
        settingsPanel.add((Component)message, c);
        String[] sIN = new String[this.viewPlayer.sourceIteratorNames.size()];
        this.viewPlayer.sourceIteratorNames.toArray(sIN);
        this.sourceChooser = new JComboBox<String>(sIN);
        this.sourceChooser.setEditable(false);
        this.sourceChooser.addActionListener(this);
        this.sourceChooser.setSelectedIndex(sIN.length - 1);
        c.gridx = -1;
        this.sourceChooser.setBorder(inputB);
        this.sourceChooser.setActionCommand("sourceChooser");
        settingsPanel.add((Component)this.sourceChooser, c);
        this.sourceSelectionChanged();
        JButton button = new JButton("Defaults");
        button.addActionListener(this);
        ++c.gridy;
        c.gridx = 21;
        settingsPanel.add((Component)button, c);
        button = new JButton("Load");
        button.addActionListener(this);
        c.gridx = -1;
        settingsPanel.add((Component)button, c);
        button = new JButton("Done");
        button.addActionListener(this);
        ++c.gridy;
        c.gridx = 21;
        settingsPanel.add((Component)button, c);
        button = new JButton("Save");
        button.addActionListener(this);
        c.gridx = -1;
        settingsPanel.add((Component)button, c);
        this.settingsFrame.add(settingsPanel);
        this.settingsFrame.pack();
        this.settingsFrame.validate();
        UserSettings propSet = this.viewPlayer.viewPlayerSettings;
        String prop = propSet.getProperty("viewPlayerSettingsWindowX");
        Rectangle bounds = this.settingsFrame.getBounds();
        int x = bounds.x;
        int y = bounds.y;
        int xSize = bounds.width;
        int ySize = bounds.height;
        if (prop != null) {
            x = Integer.parseInt(prop);
        }
        if ((prop = propSet.getProperty("viewPlayerSettingsWindowY")) != null) {
            y = Integer.parseInt(prop);
        }
        if ((prop = propSet.getProperty("viewPlayerSettingsWindowWidth")) != null) {
            xSize = Integer.parseInt(prop);
        }
        if ((prop = propSet.getProperty("viewPlayerSettingsWindowHeight")) != null) {
            ySize = Integer.parseInt(prop);
        }
        this.settingsFrame.setBounds(x, y, xSize, ySize);
        if (this.viewPlayer.isShowSettings()) {
            this.setVisible(true);
        }
    }

    public void setActionHandler() {
    }

    public void show() {
        this.settingsFrame.setVisible(true);
    }

    public void hide() {
        this.settingsFrame.setVisible(false);
    }

    public void setVisible(boolean visible) {
        this.settingsFrame.setVisible(visible);
    }

    public boolean isVisible() {
        return this.settingsFrame.isVisible();
    }

    public void exit() {
        Rectangle b = this.settingsFrame.getBounds();
        this.viewPlayer.viewPlayerSettings.setProperty("viewPlayerSettingsWindowX", Integer.toString(b.x));
        this.viewPlayer.viewPlayerSettings.setProperty("viewPlayerSettingsWindowY", Integer.toString(b.y));
        this.viewPlayer.viewPlayerSettings.setProperty("viewPlayerSettingsWindowWidth", Integer.toString(b.width));
        this.viewPlayer.viewPlayerSettings.setProperty("viewPlayerSettingsWindowHeight", Integer.toString(b.height));
        this.settingsFrame.setVisible(false);
        this.settingsFrame.getContentPane().removeAll();
        this.settingsFrame.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("autoPlay")) {
            JCheckBox autoPlay = (JCheckBox)e.getSource();
            this.viewPlayer.setAutoPlay(autoPlay.isSelected());
            this.nextDelayMessage.setEnabled(this.viewPlayer.isAutoPlay());
            this.nextDelayTextField.setEnabled(this.viewPlayer.isAutoPlay());
        } else if (command.equals("viewPlayerNextDelay")) {
            JTextField input = (JTextField)e.getSource();
            try {
                double newDelay = Double.parseDouble(input.getText());
                if (newDelay < 0.0) {
                    newDelay = 0.0;
                }
                newDelay = Math.round(newDelay * 1000.0) / 1000L;
                JTextField jTextField = input;
                synchronized (jTextField) {
                    input.setText(Double.toString(newDelay));
                }
                this.viewPlayer.setNextDelay(newDelay);
            }
            catch (Exception exc) {
                System.err.println(exc.getMessage());
                input.setText(Double.toString(this.viewPlayer.getFps()));
            }
        } else if (command.equals("viewPlayerFPS")) {
            JTextField input = (JTextField)e.getSource();
            try {
                double newFPS = Double.parseDouble(input.getText());
                if (newFPS < 0.01) {
                    newFPS = 0.01;
                }
                newFPS = Math.round(newFPS * 100.0) / 100L;
                JTextField jTextField = input;
                synchronized (jTextField) {
                    input.setText(Double.toString(newFPS));
                }
                this.viewPlayer.setFps(newFPS);
            }
            catch (Exception exc) {
                System.err.println(exc.getMessage());
                input.setText(Double.toString(this.viewPlayer.getFps()));
            }
        } else if (command.equals("viewPlayerDummyCycles")) {
            JTextField input = (JTextField)e.getSource();
            try {
                int newDummy = Integer.parseInt(input.getText());
                if (newDummy < 0) {
                    newDummy = 0;
                }
                JTextField jTextField = input;
                synchronized (jTextField) {
                    input.setText(Integer.toString(newDummy));
                }
                this.viewPlayer.setDummyCycles(newDummy);
            }
            catch (Exception exc) {
                System.err.println(exc.getMessage());
                input.setText(Integer.toString(this.viewPlayer.getDummyCycles()));
            }
        } else if (command.equals("sourceChooser")) {
            JComboBox chooser = (JComboBox)e.getSource();
            int indx = chooser.getSelectedIndex();
            if (this.viewPlayer.sourceIteratorVector != null && this.viewPlayer.sourceIteratorVector.size() > 0) {
                Vector vector = this.viewPlayer.sourceIteratorVector;
                synchronized (vector) {
                    this.viewPlayer.streamIterator = (StructureStream)this.viewPlayer.sourceIteratorVector.elementAt(indx);
                    if (this.viewPlayer.streamIterator != null) {
                        this.viewPlayer.streamIterator.setUserSettings(this.viewPlayer.viewPlayerSettings);
                    }
                }
            }
        } else if (command.equals("Defaults")) {
            this.setDefaults();
        } else if (command.equals("Load")) {
            this.loadSettings();
        } else if (command.equals("Done")) {
            this.settingsFrame.setVisible(false);
        } else if (command.equals("Save")) {
            try {
                this.viewPlayer.viewPlayerSettings.save("Settings by MViewPlayer");
            }
            catch (IOException e1) {
                e1.printStackTrace();
                System.err.println("Saving settings failed.");
            }
        }
        System.err.println("Settings command is: " + command);
    }

    public void sourceSelectionChanged() {
        this.sourceChooser.setModel(new DefaultComboBoxModel(this.viewPlayer.sourceIteratorNames));
        this.sourceChooser.setSelectedIndex(Math.min(0, this.viewPlayer.sourceIteratorNames.size() - 1));
        boolean enable = this.viewPlayer.sourceIteratorNames.size() > 1;
        this.sourceChooserMessage.setEnabled(enable);
        this.sourceChooser.setEnabled(enable);
    }

    private void setDefaults() {
        this.viewPlayer.setFps(this.viewPlayer.DEFAULT_FPS);
        this.viewPlayer.getClass();
        this.viewPlayer.setDummyCycles(0);
        this.viewPlayer.getClass();
        this.viewPlayer.setAutoPlay(false);
        this.autoPlayCheckBox.setSelected(this.viewPlayer.isAutoPlay());
        this.fpsTextField.setText(Double.toString(this.viewPlayer.getFps()));
        this.dummyCycleTextField.setText(Integer.toString(this.viewPlayer.getDummyCycles()));
    }

    private void loadSettings() {
        this.viewPlayer.viewPlayerSettings = new UserSettings();
        System.err.println("Settings loaded successfully.");
        String prop = this.viewPlayer.viewPlayerSettings.getProperty("viewPlayerAutoPlay");
        if (prop != null) {
            this.viewPlayer.autoPlay = Boolean.valueOf(prop);
        }
        if ((prop = this.viewPlayer.viewPlayerSettings.getProperty("viewLoadWorkingDir")) != null) {
            this.viewPlayer.workingDirectory = new File(prop);
        }
        if ((prop = this.viewPlayer.viewPlayerSettings.getProperty("viewPlayerFPS")) != null) {
            this.viewPlayer.setFps(Double.parseDouble(prop));
        }
        if ((prop = this.viewPlayer.viewPlayerSettings.getProperty("viewPlayerDummyCycles")) != null) {
            this.viewPlayer.setDummyCycles(Integer.parseInt(prop));
        }
        this.autoPlayCheckBox.setSelected(this.viewPlayer.isAutoPlay());
        this.fpsTextField.setText(Double.toString(this.viewPlayer.getFps()));
        this.dummyCycleTextField.setText(Integer.toString(this.viewPlayer.getDummyCycles()));
    }

    public JFrame getSettingsFrame() {
        return this.settingsFrame;
    }

    public void setSettingsFrame(JFrame settingsFrame) {
        this.settingsFrame = settingsFrame;
    }

    public JCheckBox getAutoPlayCheckBox() {
        return this.autoPlayCheckBox;
    }

    public void setAutoPlayCheckBox(JCheckBox autoPlayCheckBox) {
        this.autoPlayCheckBox = autoPlayCheckBox;
    }

    public JTextField getNextDelayMessage() {
        return this.nextDelayMessage;
    }

    public void setNextDelayMessage(JTextField nextDelayMessage) {
        this.nextDelayMessage = nextDelayMessage;
    }

    public JTextField getNextDelayTextField() {
        return this.nextDelayTextField;
    }

    public void setNextDelayTextField(JTextField nextDelayTextField) {
        this.nextDelayTextField = nextDelayTextField;
    }

    public JTextField getFpsTextField() {
        return this.fpsTextField;
    }

    public void setFpsTextField(JTextField fpsTextField) {
        this.fpsTextField = fpsTextField;
    }

    public JTextField getDummyCycleTextField() {
        return this.dummyCycleTextField;
    }

    public void setDummyCycleTextField(JTextField dummyCycleTextField) {
        this.dummyCycleTextField = dummyCycleTextField;
    }

    public JComboBox getSourceChooser() {
        return this.sourceChooser;
    }

    public void setSourceChooser(JComboBox sourceChooser) {
        this.sourceChooser = sourceChooser;
    }
}

