/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.gui;

import chemaxon.marvin.beans.MViewPane;
import chemaxon.marvin.common.UserSettings;
import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.modelling.gui.ActionPerformedQueue;
import chemaxon.marvin.modelling.gui.MViewPSettings;
import chemaxon.marvin.modelling.gui.MoleculeLoader;
import chemaxon.marvin.modelling.gui.StructureStream;
import chemaxon.marvin.modelling.newmd.MD;
import chemaxon.marvin.modelling.util.Canceller;
import chemaxon.struc.MDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class MViewPlayer
extends JFrame
implements WindowListener,
ActionListener,
Runnable {
    private static final long serialVersionUID = 5339553544193745058L;
    Molecule m = null;
    private int[] grInv = null;
    private int[] tmpGrInv = null;
    protected Molecule newMol = null;
    protected Iterator molIterator = null;
    protected StructureStream streamIterator = null;
    MViewPane viewPane;
    protected UserSettings viewPlayerSettings = null;
    private boolean showSettings = false;
    int counter = 0;
    protected MolPanel mP = null;
    private boolean cancelled = false;
    private boolean oneStepAllowed = false;
    private boolean pause = false;
    double[][] coordinates = null;
    private boolean actionLocked = false;
    private boolean waitingForNextMolecule = false;
    private boolean setMoleculeWaiting = false;
    private boolean mainLoopWaiting = false;
    protected Vector actionQueue = null;
    private long lastFrameTime = 0L;
    private int dummyDone = 0;
    protected File workingDirectory = null;
    private boolean openMenu = false;
    protected Vector fileNames = new Vector();
    protected Vector sourceIteratorVector = null;
    protected Vector sourceIteratorNames = null;
    protected MViewPSettings settings = null;
    public final double DEFAULT_FPS = 20.0;
    public final int DEFAULT_DUMMYCYCLES = 0;
    public final boolean DEFAULT_AUTOPLAY = false;
    public final double DEFAULT_NEXTDELAY = 1.0;
    private double fps = 20.0;
    private int dummyCycles = 0;
    boolean autoPlay = false;
    private double nextDelay = 1.0;
    private Canceller canceller = null;
    protected String labelString = null;

    public MViewPlayer(Iterator molIterator) {
        if (!molIterator.hasNext()) {
            throw new UnsupportedOperationException("Molecule iterator is empty...");
        }
        this.molIterator = molIterator;
        this.m = (Molecule)molIterator.next();
        this.init();
        this.coordinates = new double[this.m.getAtomCount()][3];
    }

    public MViewPlayer(String[] fileNames) {
        MoleculeLoader mL = new MoleculeLoader(this, fileNames);
        mL.setCyclicMode(true);
        this.molIterator = mL;
        if (!this.molIterator.hasNext()) {
            throw new UnsupportedOperationException("Molecule iterator is empty...");
        }
        this.m = (Molecule)this.molIterator.next();
        this.openMenu = true;
        this.init();
        this.coordinates = new double[this.m.getAtomCount()][3];
        if (this.m != null && !this.m.isEmpty()) {
            this.registerStructureStream(new MD(this.m), "Molecular dynamics");
        }
    }

    public MViewPlayer(Molecule m) {
        this.m = m;
        this.init();
        MDocument mD = this.viewPane.getDocuments()[0];
        this.m = mD.getAllMolecules()[0];
        this.coordinates = new double[m.getAtomCount()][3];
    }

    public MViewPlayer() {
        this.openMenu = true;
        this.init();
        this.registerStructureStream(new MD(this.m), "Molecular dynamics");
    }

    public void registerStructureStream(StructureStream structureStream, String name) {
        if (structureStream != null && name != null) {
            this.sourceIteratorVector.addElement(structureStream);
            String loaderName = name;
            this.sourceIteratorNames.addElement(loaderName);
            if (this.settings != null) {
                this.settings.sourceSelectionChanged();
            }
        } else {
            throw new NullPointerException("Cannot register null structure stream or name.");
        }
    }

    private void init() {
        this.setTitle("MViewPlayer");
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.viewPane = new MViewPane();
        this.getContentPane().add(this.viewPane);
        JMenuBar menubar = new JMenuBar();
        this.setJMenuBar(menubar);
        JMenu menu = new JMenu("File");
        menubar.add(menu);
        if (this.openMenu) {
            JMenuItem miOpen = new JMenuItem("Add file");
            menu.add(miOpen);
            miOpen.setActionCommand("open");
            miOpen.addActionListener(this);
        }
        JMenuItem mi = new JMenuItem("Exit");
        menu.add(mi);
        mi.setActionCommand("exit");
        mi.addActionListener(this);
        this.addWindowListener(this);
        this.initCell();
        if (this.m == null) {
            this.viewPane.setM(0, new Molecule());
        } else {
            ++this.counter;
            this.viewPane.setM(0, this.m);
        }
        this.viewPane.setL(0, Integer.toString(this.counter));
        this.lastFrameTime = System.currentTimeMillis();
        this.viewPlayerSettings = this.viewPane.getUserSettings();
        String prop = null;
        System.err.println("User settings loaded successfully...");
        prop = this.viewPlayerSettings.getProperty("viewPlayerAutoPlay");
        if (prop != null) {
            this.setAutoPlay(Boolean.valueOf(prop));
        } else {
            this.setAutoPlay(false);
        }
        if (this.isAutoPlay()) {
            this.doAction("Play");
        } else {
            this.doAction("Pause");
        }
        prop = this.viewPlayerSettings.getProperty("viewPlayerNextDelay");
        if (prop != null) {
            this.setNextDelay(Double.parseDouble(prop));
        }
        if ((prop = this.viewPlayerSettings.getProperty("viewLoadWorkingDir")) != null) {
            this.setWorkingDirectory(prop);
        }
        if ((prop = this.viewPlayerSettings.getProperty("viewPlayerFPS")) != null) {
            this.setFps(Double.parseDouble(prop));
        } else {
            this.setFps(20.0);
        }
        prop = this.viewPlayerSettings.getProperty("viewPlayerDummyCycles");
        if (prop != null) {
            this.setDummyCycles(Integer.parseInt(prop));
        } else {
            this.setDummyCycles(0);
        }
        prop = this.viewPlayerSettings.getProperty("viewPlayerShowSettings");
        if (prop != null) {
            this.setShowSettings(Boolean.valueOf(prop));
        }
        int x = 0;
        int y = 0;
        int xSize = 600;
        int ySize = 600;
        prop = this.viewPlayerSettings.getProperty("viewPlayerWindowX");
        if (prop != null) {
            x = Integer.parseInt(prop);
        }
        if ((prop = this.viewPlayerSettings.getProperty("viewPlayerWindowY")) != null) {
            y = Integer.parseInt(prop);
        }
        if ((prop = this.viewPlayerSettings.getProperty("viewPlayerWindowWidth")) != null) {
            xSize = Integer.parseInt(prop);
        }
        if ((prop = this.viewPlayerSettings.getProperty("viewPlayerWindowHeight")) != null) {
            ySize = Integer.parseInt(prop);
        }
        this.setBounds(x, y, xSize, ySize);
        this.sourceIteratorVector = new Vector();
        this.sourceIteratorNames = new Vector();
        if (this.molIterator != null) {
            this.sourceIteratorVector.insertElementAt(null, 0);
            String loaderName = "File";
            this.sourceIteratorNames.insertElementAt(loaderName, 0);
        }
    }

    private void initCell() {
        int cols = 1;
        int rows = 1;
        int actualVisibleRows = 1;
        String layout = "rows=1\ncols=1\nlayout0=:2:3:M:1:0:1:4:c:b:1:1:B:2:0:1:1:s:h:0:1:B:2:1:1:1:s:h:0:1:B:2:2:1:1:s:h:0:1:B:2:3:1:1:s:h:0:1:L:0:0:1:4:c:n:0:1\nparam0=:M:600:600:B:14:Next::B:14:PlayPause::B:14:Step::B:14:Settings::L:18b\ncell0=||Next|%a|next|Pause|%P|pause|Step|%a|step|Settings|%a|settings\n";
        this.viewPane.setParams("#\n# MarvinView properties\n#\nrows=" + rows + "\n" + "cols=" + cols + "\n" + "visibleRows=" + actualVisibleRows + "\n" + layout + "\n" + "#\n" + "# MarvinSketch properties also have to be specified here for the sketcher\n" + "# windows that are launched from the viewer (using Edit/Structure).\n" + "#\n" + "extrabonds=arom,wedge\n");
        this.mP = this.viewPane.getMolPanel();
        this.mP.addActionListener(this);
        this.mP.setEnabled(true);
        this.actionQueue = new Vector();
        AbstractButton button = this.viewPane.getVisibleButtonB(0);
        button.setEnabled(false);
        button.addActionListener(this);
        button = this.viewPane.getVisibleButtonB(1);
        button.setEnabled(true);
        button.addActionListener(this);
        button = this.viewPane.getVisibleButtonB(2);
        button.setEnabled(true);
        button.addActionListener(this);
        button = this.viewPane.getVisibleButtonB(3);
        button.setEnabled(true);
        button.addActionListener(this);
        this.viewPane.setBorderWidth(1);
        this.viewPane.setEditable(0);
        this.viewPane.setBackground(new Color(0xCCCCCC));
        this.viewPane.setMolbg(new Color(0xFFFFFF));
    }

    void fpsDelay() {
        long dt = Math.round(1000.0 / this.fps);
        long t = System.currentTimeMillis();
        if (t - this.lastFrameTime < dt) {
            try {
                Thread.sleep(this.lastFrameTime + dt - t);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.lastFrameTime = System.currentTimeMillis();
    }

    private void nextDelay() {
        long dt = Math.round(1000.0 * this.nextDelay);
        while (!this.isWaitingForNextMolecule()) {
            long t = System.currentTimeMillis();
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (t - this.lastFrameTime < dt) continue;
        }
        this.lastFrameTime = System.currentTimeMillis();
    }

    private boolean dummyCall() {
        if (this.isSetMoleculeWaiting()) {
            this.dummyDone = 0;
            return true;
        }
        ++this.dummyDone;
        long dt = Math.round(1000.0 / this.fps);
        if ((this.dummyCycles < 0 || this.dummyDone <= this.dummyCycles) && System.currentTimeMillis() - this.lastFrameTime < dt) {
            return true;
        }
        this.dummyDone = 0;
        return false;
    }

    public MViewPane getViewPane() {
        return this.viewPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMolecule(Molecule newMol) {
        System.err.println("Enter setMolecule.");
        if (this.setMoleculeWaiting) {
            throw new UnsupportedOperationException("Unsynchronized calls to setMolecule...");
        }
        while (this.setMoleculeWaiting && !this.isCancelled()) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
        if (this.isCancelled()) {
            return;
        }
        this.setSetMoleculeWaiting(true);
        this.stepMade();
        this.setPause(true);
        this.doAction("Pause");
        System.err.println("setMolecule wait check.");
        while (!(this.isWaitingForNextMolecule() || this.isAutoPlay() || this.isCancelled())) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
        if (this.isCancelled()) {
            return;
        }
        if (this.isWaitingForNextMolecule()) {
            this.setWaitingForNextMolecule(false);
        }
        System.err.println("setMolecule processing.");
        this.newMol = newMol;
        ActionEvent event = new ActionEvent(this.mP, 0, "newMol");
        MViewPlayer l = this;
        l.actionPerformed(event);
        while (this.m == null) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Molecule molecule = this.m;
        synchronized (molecule) {
            while (!MoleculeLoader.sameMolecules(this.m, newMol)) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        this.setPause(!this.isAutoPlay());
        if (this.isAutoPlay()) {
            this.doAction("Play");
        } else {
            this.doAction("Pause");
        }
        if (this.isAutoPlay()) {
            this.nextDelay();
        }
        this.setSetMoleculeWaiting(false);
    }

    public void setCoordinates(double[] coordinates) {
        while (this.isPause()) {
            try {
                if (this.isCancelled()) {
                    return;
                }
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }
        if (this.dummyCall()) {
            return;
        }
        if (coordinates.length / 3 != this.m.getAtomCount()) {
            throw new UnsupportedOperationException("Coordinate array mismatch.");
        }
        for (int j = 0; j < this.m.getAtomCount(); ++j) {
            int ij = 3 * j;
            this.coordinates[j][0] = coordinates[ij];
            this.coordinates[j][1] = coordinates[ij + 1];
            this.coordinates[j][2] = coordinates[ij + 2];
        }
        this.stepMade();
        ActionEvent event = new ActionEvent(this.mP, 0, "redraw");
        MViewPlayer l = this;
        this.fpsDelay();
        l.actionPerformed(event);
    }

    public void updateMoleculeCoordinates(Molecule mol) {
        if (mol == null) {
            throw new NullPointerException("updateMoleculeCoordinates: mol is null.");
        }
        while (this.isPause()) {
            try {
                if (this.isCancelled() || this.isWaitingForNextMolecule()) {
                    return;
                }
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }
        if (this.m == mol) {
            throw new UnsupportedOperationException("MVPlane's molecule is in external use...");
        }
        if (this.m == null || this.m.getAtomCount() != mol.getAtomCount()) {
            this.setMolecule(mol);
            return;
        }
        if (this.grInv == null || this.grInv.length != this.m.getAtomCount()) {
            this.grInv = new int[this.m.getAtomCount()];
            this.m.getGrinv(this.grInv);
        }
        if (this.tmpGrInv == null || this.tmpGrInv.length != this.grInv.length) {
            this.tmpGrInv = new int[this.grInv.length];
        }
        mol.getGrinv(this.tmpGrInv);
        for (int i = 0; i < this.tmpGrInv.length; ++i) {
            if (this.grInv[i] == this.tmpGrInv[i]) continue;
            this.setMolecule(mol);
            return;
        }
        if (this.dummyCall()) {
            return;
        }
        for (int j = 0; j < this.m.getAtomCount(); ++j) {
            MolAtom aS = mol.getAtom(j);
            this.coordinates[j][0] = aS.getX();
            this.coordinates[j][1] = aS.getY();
            this.coordinates[j][2] = aS.getZ();
        }
        this.stepMade();
        ActionEvent event = new ActionEvent(this.mP, 0, "redraw");
        MViewPlayer l = this;
        this.fpsDelay();
        l.actionPerformed(event);
    }

    private void stepMade() {
        if (this.isOneStepAllowed()) {
            this.setPause(true);
            this.setOneStepAllowed(false);
        }
        ++this.counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.settings = new MViewPSettings(this);
        this.pack();
        this.setVisible(true);
        this.requestFocus();
        Thread actionQueue = new Thread(new ActionPerformedQueue(this));
        actionQueue.start();
        if (this.m != null) {
            MDocument mD = this.viewPane.getDocuments()[0];
            this.m = mD.getAllMolecules()[0];
        }
        while (this.streamIterator == null && this.molIterator == null && !this.isCancelled() || this.isSetMoleculeWaiting()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                this.setCancelled(true);
                e.printStackTrace();
            }
        }
        if (this.molIterator != null || this.streamIterator != null) {
            while (!this.isCancelled()) {
                while (this.isPause() && !this.isCancelled() || this.isSetMoleculeWaiting()) {
                    this.setMainLoopWaiting(true);
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
                this.setMainLoopWaiting(false);
                if (this.isCancelled()) break;
                boolean nextOK = false;
                if (this.molIterator != null && (this.m == null || this.m.isEmpty() || this.streamIterator == null || this.isSetMoleculeWaiting() || this.isWaitingForNextMolecule())) {
                    Iterator iterator = this.molIterator;
                    synchronized (iterator) {
                        nextOK = this.molIterator.hasNext();
                    }
                    if (nextOK && !this.isCancelled()) {
                        Molecule mol = null;
                        boolean doNext = false;
                        Iterator iterator2 = this.molIterator;
                        synchronized (iterator2) {
                            doNext = this.isWaitingForNextMolecule();
                            mol = (Molecule)this.molIterator.next();
                        }
                        if (doNext) {
                            this.dummyCall();
                            this.setMolecule(mol);
                            if (this.streamIterator != null) {
                                this.streamIterator.setMolecule(mol.cloneMolecule());
                            }
                        } else {
                            this.updateMoleculeCoordinates(mol);
                        }
                    } else {
                        try {
                            Thread.sleep(5L);
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
                if (this.isWaitingForNextMolecule() || this.streamIterator == null || this.m == null || this.m.isEmpty()) continue;
                if (this.streamIterator.hasNext()) {
                    this.updateMoleculeCoordinates((Molecule)this.streamIterator.next());
                    continue;
                }
                this.streamIterator.setMolecule(this.m.cloneMolecule());
            }
        }
    }

    public void exit() {
        if (this.streamIterator != null) {
            this.streamIterator.exit();
        }
        this.windowClosing(null);
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
        this.setCancelled(true);
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        this.setCancelled(true);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.viewPane.exit();
        this.setVisible(false);
        this.getContentPane().removeAll();
        this.dispose();
        if (this.settings != null) {
            this.settings.exit();
            this.settings = null;
        }
        if (this.streamIterator != null) {
            this.streamIterator.exit();
            this.streamIterator = null;
        }
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    public void doAction(String command) {
        Object source = null;
        if (this.isCancelled()) {
            return;
        }
        if (command.equals("Pause")) {
            this.setPause(true);
            AbstractButton playPause = this.viewPane.getVisibleButtonB(1);
            if (playPause.getText().equals(command)) {
                playPause.doClick();
            }
        } else if (command.equals("Play")) {
            this.setPause(false);
            AbstractButton playPause = this.viewPane.getVisibleButtonB(1);
            if (playPause.getText().equals(command)) {
                playPause.doClick();
            }
        } else if (command.equals("Next")) {
            AbstractButton next = this.viewPane.getVisibleButtonB(0);
            next.doClick();
        } else {
            this.actionPerformed(new ActionEvent(source, 0, command));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent ev) {
        Vector vector = this.actionQueue;
        synchronized (vector) {
            this.actionQueue.add(ev);
        }
    }

    public static void main(String[] args) {
        MViewPlayer mVP = null;
        mVP = args.length > 0 ? new MViewPlayer(args) : new MViewPlayer();
        Thread mVPThread = new Thread(mVP);
        mVPThread.start();
        try {
            mVPThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean isCancelled() {
        if (this.canceller != null) {
            this.setCancelled(this.canceller.isCancelled());
        }
        return this.cancelled;
    }

    protected void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public boolean isOneStepAllowed() {
        return this.oneStepAllowed;
    }

    protected void setOneStepAllowed(boolean oneStepAllowed) {
        this.oneStepAllowed = oneStepAllowed;
        if (oneStepAllowed && this.isPause()) {
            this.setPause(false);
        }
    }

    public boolean isPause() {
        return this.pause && !this.isCancelled();
    }

    protected void setPause(boolean pause) {
        if (pause == this.pause) {
            return;
        }
        this.pause = pause;
    }

    protected boolean isActionLocked() {
        return this.actionLocked && !this.isCancelled();
    }

    protected void setActionLocked(boolean actionLocked) {
        this.actionLocked = actionLocked;
    }

    public boolean isWaitingForNextMolecule() {
        return this.waitingForNextMolecule;
    }

    protected void setWaitingForNextMolecule(boolean waitingForNextMolecule) {
        this.waitingForNextMolecule = waitingForNextMolecule;
    }

    public double getFps() {
        return this.fps;
    }

    public void setFps(double fps) {
        this.fps = fps;
        this.viewPlayerSettings.setProperty("viewPlayerFPS", Double.toString(fps));
    }

    public int getDummyCycles() {
        return this.dummyCycles;
    }

    public void setDummyCycles(int dummyCycles) {
        this.dummyCycles = dummyCycles;
        this.viewPlayerSettings.setProperty("viewPlayerDummyCycles", Integer.toString(dummyCycles));
    }

    public String getWorkingDirectory() {
        return this.workingDirectory.getName();
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
        this.viewPane.getUserSettings().setProperty("viewLoadWorkingDir", workingDirectory.getAbsolutePath());
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = new File(workingDirectory);
        this.viewPlayerSettings.setProperty("viewPlayerLoadWorkingDir", workingDirectory);
    }

    public boolean isAutoPlay() {
        return this.autoPlay;
    }

    protected void setAutoPlay(boolean autoPlay) {
        this.autoPlay = autoPlay;
        this.viewPane.getUserSettings().setProperty("viewPlayerAutoPlay", Boolean.toString(autoPlay));
    }

    protected boolean isShowSettings() {
        return this.showSettings;
    }

    private void setShowSettings(boolean showSettings) {
        this.showSettings = showSettings;
    }

    private boolean isSetMoleculeWaiting() {
        return this.setMoleculeWaiting;
    }

    private void setSetMoleculeWaiting(boolean setMoleculeWaiting) {
        this.setMoleculeWaiting = setMoleculeWaiting;
    }

    private boolean isMainLoopWaiting() {
        return this.mainLoopWaiting;
    }

    private void setMainLoopWaiting(boolean mainLoopWaiting) {
        this.mainLoopWaiting = mainLoopWaiting;
    }

    public double getNextDelay() {
        return this.nextDelay;
    }

    public void setNextDelay(double nextDelay) {
        this.nextDelay = nextDelay;
        this.viewPlayerSettings.setProperty("viewPlayerNextDelay", Double.toString(nextDelay));
    }

    public void setCanceller(Canceller canceller) {
    }

    protected StructureStream getStreamIterator() {
        return this.streamIterator;
    }

    protected void setStreamIterator(StructureStream streamIterator) {
        this.streamIterator = streamIterator;
    }

    public String getLabelString() {
        return this.labelString;
    }

    public void setLabelString(String labelString) {
        this.labelString = labelString;
    }

    class SetMoleculeThred
    implements Runnable {
        Molecule mol = null;

        public SetMoleculeThred(Molecule mol) {
            this.mol = mol;
        }

        public SetMoleculeThred() {
        }

        @Override
        public void run() {
            MViewPlayer.this.setPause(true);
            if (this.mol != null) {
                MViewPlayer.this.setWaitingForNextMolecule(true);
                MViewPlayer.this.setMolecule(this.mol);
                return;
            }
            if (MViewPlayer.this.isSetMoleculeWaiting() || MViewPlayer.this.isAutoPlay()) {
                MViewPlayer.this.setWaitingForNextMolecule(true);
            } else {
                MViewPlayer.this.setSetMoleculeWaiting(true);
                while (!MViewPlayer.this.isMainLoopWaiting()) {
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        return;
                    }
                }
                MViewPlayer.this.setSetMoleculeWaiting(false);
                MViewPlayer.this.setWaitingForNextMolecule(true);
                MViewPlayer.this.setOneStepAllowed(true);
            }
        }
    }
}

