/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.gui;

import chemaxon.formats.MolImporter;
import chemaxon.marvin.modelling.gui.MViewPlayer;
import chemaxon.struc.Molecule;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;

public class MoleculeLoader
implements Iterator<Molecule> {
    Molecule currentMolecule = null;
    int currentFileIndex = -1;
    MolImporter mi = null;
    private boolean standardize = false;
    private boolean cyclicMode = false;
    private boolean giveNext = false;
    private static int[] grInv = null;
    private static int[] tmpGrInv = null;
    private Vector<String> fileNames = new Vector();

    public MoleculeLoader(MViewPlayer viewPlayer, String fileName) {
        if (fileName != null) {
            this.fileNames.addElement(fileName);
        }
    }

    public MoleculeLoader(String fileName) {
        if (fileName != null) {
            this.fileNames.addElement(fileName);
        }
    }

    public MoleculeLoader(MViewPlayer viewPlayer, String[] files) {
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                this.fileNames.addElement(files[i]);
            }
        }
    }

    public MoleculeLoader(String[] files) {
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                this.fileNames.addElement(files[i]);
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (this.fileNames.size() == 0) {
            return false;
        }
        if (this.giveNext || this.getCurrentMolecule() != null) {
            return true;
        }
        if (this.currentFileIndex < this.fileNames.size() - 1 || this.isCyclicMode()) {
            ++this.currentFileIndex;
            this.currentFileIndex %= this.fileNames.size();
            boolean importerOK = true;
            do {
                try {
                    if (this.mi != null) {
                        this.mi.close();
                    }
                    this.mi = this.fileNames.elementAt(this.currentFileIndex).equals("-") ? new MolImporter(System.in) : new MolImporter(this.fileNames.elementAt(this.currentFileIndex));
                    importerOK = true;
                }
                catch (IOException ex) {
                    System.err.println("MolImporter: " + ex.getMessage());
                    this.fileNames.removeElementAt(this.currentFileIndex);
                    importerOK = false;
                    this.currentFileIndex = Math.min(this.fileNames.size() - 1, this.currentFileIndex);
                }
            } while (!importerOK && this.currentFileIndex > -1);
            this.giveNext = this.getCurrentMolecule() != null;
            return this.getCurrentMolecule() != null;
        }
        return false;
    }

    public void add(String fileName) {
        this.fileNames.addElement(fileName);
    }

    @Override
    public Molecule next() {
        if (this.giveNext || this.hasNext()) {
            Molecule m = this.currentMolecule;
            this.currentMolecule = null;
            this.giveNext = false;
            return m;
        }
        return null;
    }

    @Override
    public void remove() {
    }

    public Molecule[] loadMolecules(String[] fileNames) {
        return this.loadMolecules(fileNames, false);
    }

    public Molecule[] loadMolecules(String[] fileNames, boolean standardize) {
        if (fileNames == null) {
            return null;
        }
        Vector<Molecule> molVec = new Vector<Molecule>();
        try {
            for (int i = 0; i < fileNames.length; ++i) {
                MolImporter mi = new MolImporter(fileNames[i]);
                Molecule m = null;
                do {
                    if ((m = mi.read()) == null) continue;
                    molVec.addElement(m);
                } while (m != null);
            }
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
        if (molVec.size() == 0) {
            return null;
        }
        Molecule[] mols = new Molecule[molVec.size()];
        molVec.toArray(mols);
        return mols;
    }

    private Molecule getCurrentMolecule() {
        if (this.currentMolecule != null) {
            return this.currentMolecule;
        }
        if (this.mi == null) {
            return null;
        }
        try {
            this.currentMolecule = this.mi.read();
            if (this.currentMolecule == null || this.standardize) {
                // empty if block
            }
            return this.currentMolecule;
        }
        catch (IOException ex) {
            System.err.println("MolImporter read: " + ex.getMessage());
            return null;
        }
    }

    public boolean isStandardize() {
        return this.standardize;
    }

    public void setStandardize(boolean standardize) {
        this.standardize = standardize;
    }

    public boolean isCyclicMode() {
        return this.cyclicMode;
    }

    public void setCyclicMode(boolean cyclicMode) {
        this.cyclicMode = cyclicMode;
    }

    public static boolean sameMolecules(Molecule m1, Molecule m2) {
        if (m1 == m2) {
            return true;
        }
        if (m1 == null || m2 == null) {
            return false;
        }
        if (m1.getAtomCount() != m2.getAtomCount()) {
            return false;
        }
        if (grInv == null || grInv.length != m1.getAtomCount()) {
            grInv = new int[m1.getAtomCount()];
        }
        m1.getGrinv(grInv);
        if (tmpGrInv == null || tmpGrInv.length != grInv.length) {
            tmpGrInv = new int[grInv.length];
        }
        m2.getGrinv(tmpGrInv);
        for (int i = 0; i < tmpGrInv.length; ++i) {
            if (grInv[i] == tmpGrInv[i]) continue;
            return false;
        }
        return true;
    }
}

