/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.interfacing;

import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.CleanSettings;
import chemaxon.marvin.modelling.build.fafuse.FuseBuilder;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.interfacing.CalculationAbortedException;
import chemaxon.marvin.modelling.interfacing.CalculationFailedException;
import chemaxon.marvin.modelling.interfacing.CalculationInput;
import chemaxon.marvin.modelling.interfacing.CalculationResult;
import chemaxon.marvin.modelling.interfacing.CxnMoleculeInput;
import chemaxon.marvin.modelling.interfacing.InvokeCalculation;
import chemaxon.marvin.modelling.interfacing.MultipleConformersResultImpl;
import chemaxon.marvin.modelling.struc.Fragment;
import chemaxon.marvin.modelling.struc.StereoCriteriaList;
import chemaxon.marvin.modelling.struc.myMolecule;
import chemaxon.marvin.modelling.util.myList;

public class InvokeFAFBuildCalculation
extends InvokeCalculation {
    private myList params = null;
    private CleanSettings settings = null;

    public void setSettings(CleanSettings s) {
        this.settings = s;
    }

    public void setParams(myList p) {
        this.params = p;
    }

    @Override
    public CalculationResult invoke(CalculationInput input, boolean reportSingleConformer) throws CalculationAbortedException, CalculationFailedException {
        debugPrintout debug = CleanArgs.getDebug();
        if (debug != null && debug.getWillPrint()) {
            debug.println("StartClean2() invoked");
            debug.incLevel("Parameters:");
            for (int i = 0; i < this.params.size(); ++i) {
                ((FuseBuilder.CleanParams)this.params.get(i)).printout(debug);
            }
            debug.decLevel();
        }
        Fragment frag = ((CxnMoleculeInput)input).getSelMolFrag(false, this.settings);
        StereoCriteriaList stereo = frag.getStereo();
        myMolecule mol = frag.getFragMol();
        FuseBuilder builder = new FuseBuilder(mol, stereo);
        if (debug != null && debug.getWillPrint()) {
            debug.incLevel("Given molecule:");
            mol.printout(debug);
            debug.decLevel();
        }
        int iterIndex = 0;
        boolean newIterRequired = false;
        do {
            FuseBuilder.CleanParams ap = (FuseBuilder.CleanParams)this.params.get(iterIndex);
            if (CleanArgs.cltracer != null) {
                CleanArgs.cltracer.changeTaskID(3, 0);
                debug = CleanArgs.getDebug();
            }
            int cleanRes = builder.makeCoords2(ap, null, this.settings, this.settings.isOptionCAGiven());
            if (debug != null && debug.getWillPrint()) {
                debug.printB("Cleaner result:");
                switch (cleanRes) {
                    case 1: {
                        debug.println("OK.");
                        break;
                    }
                    case 2: {
                        debug.println("FAILED.");
                        break;
                    }
                    case 3: {
                        debug.println("CANCELLED.");
                    }
                }
            }
            newIterRequired = false;
            if (cleanRes == 3) {
                throw new CalculationAbortedException();
            }
            if (cleanRes == 1) {
                MultipleConformersResultImpl res = new MultipleConformersResultImpl(input, builder.getCoordinates());
                return res;
            }
            if (cleanRes == 2 && this.params.size() > iterIndex + 1) {
                ++iterIndex;
                newIterRequired = true;
            }
            if (cleanRes == 1 || newIterRequired) continue;
            throw new CalculationFailedException();
        } while (newIterRequired);
        throw new CalculationFailedException();
    }
}

